# Examples

## main (Encoder/decoder end-to-end)

This example shows an end-to-end pipeline to generate codes from a raw WAV audio file
and use these codes to reconstruct the WAV audio file.

```bash
    ./main -t 8 \
    -i ~/Documents/encodec.cpp/build/bin/audio.wav \
    -m ~/Documents/encodec.cpp/ggml_weights/ggml-model.bin \
    -o output.wav
```

## Compress (encoder only)

This example shows how to generate a compressed representation of an audio with
the Encodec's encoder.

```bash
    ./compress -t 8 \
    -i ~/Documents/encodec.cpp/build/bin/audio.wav \
    -m ~/Documents/encodec.cpp/ggml_weights/ggml-model.bin \
    -o output.bin
```

## Decompress (decoder only)

This example shows how to reconstruct an audio from a compressed representation
generated by the Encodec's encoder.

```bash
    ./decompress -t 8 \
    -i ~/Documents/encodec.cpp/build/bin/output.bin \
    -m ~/Documents/encodec.cpp/ggml_weights/ggml-model.bin \
    -o output.wav
```
