# v0.15.0 Release Plan

## Release Overview

**Target Version**: v0.15.0
**Previous Version**: v0.14.4
**Release Date**: TBD
**Milestone**: [v0.15.0](https://github.com/basicmachines-co/basic-memory/milestone)

### Release Highlights

This is a **major release** with 53 merged PRs introducing:
- **Cloud Sync**: Bidirectional sync with rclone bisync
- **Authentication**: JWT-based cloud authentication with subscription validation
- **Performance**: API optimizations and background processing improvements
- **Security**: Removed .env loading vulnerability, added .gitignore support
- **Platform**: Python 3.13 support
- **Bug Fixes**: 13+ critical fixes

## Key Features by Category

### Cloud Features
- Cloud authentication with JWT and subscription validation
- Bidirectional sync with rclone bisync
- Cloud mount commands for direct file access
- Cloud project management
- Integrity verification

### Performance Improvements
- API performance optimizations (SPEC-11)
- Background relation resolution (prevents cold start blocking)
- WAL mode for SQLite
- Non-blocking sync operations

### Security Enhancements
- Removed .env file loading vulnerability
- .gitignore integration (respects gitignored files)
- Improved authentication and session management
- Better config security

### Developer Experience
- Python 3.13 support
- ChatGPT tools integration
- Improved error handling
- Better CLI output and formatting

### Bug Fixes (13+ PRs)
- Entity upsert conflict resolution (#328)
- memory:// URL underscore handling (#329)
- .env loading removed (#330)
- Minimum timeframe enforcement (#318)
- move_note file extension handling (#281)
- Project parameter handling (#310)
- And more...

---

## Document

- [ ] **MNew Cloud Features**
  - [ ] `bm cloud login` authentication flow
  - [ ] `bm cloud logout` session cleanup
  - [ ] `bm cloud sync` bidirectional sync
  - [ ] `bm cloud check` integrity verification
  - [ ] Cloud mode toggle for regular commands
  - [ ] Project creation in cloud mode

- [ ] **Manual Testing - Bug Fixes**
  - [ ] Entity upsert conflict resolution (#328)
  - [ ] memory:// URL underscore normalization (#329)
  - [ ] .gitignore file filtering (#287, #285)
  - [ ] move_note with/without file extension (#281)
  - [ ]  .env file loading removed (#330)

- [ ] **Platform Testing**
  - [ ] Python 3.13 compatibility (new in this release)

- [ ] **CHANGELOG.md**
  - [ ] Create comprehensive v0.15.0 entry
  - [ ] List all major features
  - [ ] Document all bug fixes with issue links
  - [ ] Include breaking changes (if any)
  - [ ] Add migration guide (if needed)
  - [ ] Credit contributors
  - [ ] `mcp/tools/chatgpt_tools.py` - ChatGPT integration

- [x] **README.md**
  - [x] Update Python version badge to 3.13+
  - [x] Add cloud features to feature list
  - [x] Add cloud CLI commands section
  - [x] Expand MCP tools list with all tools organized by category
  - [x] Add Cloud CLI documentation link

- [x] **CLAUDE.md**
  - [x] Add Python 3.13+ support note
  - [x] Add cloud commands section
  - [x] Expand MCP tools with all missing tools
  - [x] Add comprehensive "Cloud Features (v0.15.0+)" section

- [ ] **docs.basicmemory.com Updates** (Docs Site)
  - [ ] **latest-releases.mdx**: Add v0.15.0 release entry with all features
  - [ ] **cli-reference.mdx**: Add cloud commands section (login, logout, sync, check, mount, unmount)
  - [ ] **mcp-tools-reference.mdx**: Add missing tools (read_content, all project management tools)
  - [ ] **cloud-cli.mdx**: CREATE NEW - Cloud authentication, sync, rclone config, troubleshooting
  - [ ] **getting-started.mdx**: Mention Python 3.13 support
  - [ ] **whats-new.mdx**: Add v0.15.0 section with cloud features, performance, security updates

- [ ] **Cloud Documentation**
  - [ ] Review docs/cloud-cli.md for accuracy
  - [ ] Update authentication instructions
  - [ ] Document subscription requirements
  - [ ] Add troubleshooting section
  - [ ] rclone configuration

- [ ] **API Documentation**
  - [ ] Document new cloud endpoints
  - [ ] Update MCP tool documentation
  - [ ] Review schema documentation
  - [ ] Config file changes

- [ ] **New Specifications**
  - [ ] SPEC-11: API Performance Optimization
  - [ ] SPEC-13: CLI Authentication with Subscription Validation
  - [ ] SPEC-6: Explicit Project Parameter Architecture

- [ ] **Feature PRs**
  - [ ] #330: Remove .env file loading
  - [ ] #329: Normalize memory:// URLs
  - [ ] #328: Simplify entity upsert
  - [ ] #327: CLI subscription validation
  - [ ] #322: Cloud CLI rclone bisync
  - [ ] #320: Lifecycle management optimization
  - [ ] #319: Background relation resolution
  - [ ] #318: Minimum timeframe enforcement
  - [ ] #317: Cloud deployment fixes
  - [ ] #315: API performance optimizations
  - [ ] #314: .gitignore integration
  - [ ] #313: Disable permalinks config flag
  - [ ] #312: DateTime JSON schema fixes


### Phase 5: GitHub Milestone Review

- [ ] **Closed Issues** (23 total)
  - [ ] Review all closed issues for completeness
  - [ ] Verify fixes are properly tested
  - [ ] Ensure documentation updated

- [ ] **Merged PRs** (13 in milestone, 53 total since v0.14.4)
  - [ ] All critical PRs merged
  - [ ] All PRs properly tested
  - [ ] All PRs documented

- [ ] **Open Issues**
  - [ ] #326: Create user guides and demos (can defer to v0.15.1?)
  - [ ] Decision on whether to block release

## Notes

- This is a significant release with major new cloud features
- Cloud features require active subscription - ensure this is clear in docs
