# Changelog

All notable changes to BasicFetch will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.0.0] - 2025-01-18

### Added
- Initial PyPI release
- Cross-platform system information display (Windows, Linux, macOS, BSD)
- 200+ beautiful ASCII distribution logos
- Multiple display modes (simple, detailed, JSON)
- Rich color support with ANSI and RGB colors
- Comprehensive hardware detection:
  - CPU information (name, cores, threads, frequency, usage)
  - GPU detection and temperature monitoring
  - Memory usage statistics (RAM, swap)
  - Storage information by partition
  - Network statistics
  - Motherboard information
- Command-line interface with multiple options
- Console scripts: `basicfetch` and `bfetch`
- Support for `python -m basicfetch`
- Customizable logo display
- Color palette display
- JSON output for machine processing
- Fast and efficient performance
- Pure Python implementation with minimal dependencies

### Dependencies
- Python 3.7+
- psutil >= 5.8.0
- rich >= 10.0.0
- wmi >= 1.5.1 (Windows only)

### Author
- **Yakup Kaya (@y4kupkaya)**
- Website: [yakupkaya.me](https://yakupkaya.me)
- Telegram: [@YakupKaya](https://t.me/YakupKaya)
- GitHub: [@y4kupkaya](https://github.com/y4kupkaya)

### License
- GNU General Public License v3.0

---

*Made with ❤️  by @y4kupkaya*