# Contributing to BasicFetch

Thank you for your interest in contributing to BasicFetch! This document provides guidelines for contributing to the project.

## Author

**Yakup Kaya (@y4kupkaya)**
- 🌐 Website: [yakupkaya.me](https://yakupkaya.me)
- 📱 Telegram: [@YakupKaya](https://t.me/YakupKaya) 
- 💻 GitHub: [@y4kupkaya](https://github.com/y4kupkaya)

## Ways to Contribute

### Bug Reports
- Use the GitHub issue tracker
- Provide detailed steps to reproduce
- Include system information and error messages
- Test with the latest version

### Feature Requests
- Check existing issues first
- Describe the feature clearly
- Explain the use case and benefits
- Consider backward compatibility

### Code Contributions
- Fork the repository
- Create a feature branch
- Follow the coding standards
- Add tests for new features
- Update documentation
- Submit a pull request

## Development Setup

1. Fork and clone the repository
2. Create a virtual environment
3. Install development dependencies: `pip install -e .[dev]`
4. Run tests: `pytest`
5. Format code: `black .`
6. Check linting: `flake8`

## Code Standards

- Follow PEP 8 style guide
- Use type hints where appropriate
- Write docstrings for functions and classes
- Keep functions focused and small
- Add comments for complex logic

## Testing

- Write tests for new features
- Ensure all tests pass
- Test on multiple platforms when possible
- Include edge cases in tests

## Documentation

- Update README.md for user-facing changes
- Update docstrings for API changes
- Add examples for new features
- Keep documentation clear and concise

## License

By contributing to BasicFetch, you agree that your contributions will be licensed under the GNU General Public License v3.0.

## Contact

For questions about contributing, contact:
- Email: contact@yakupkaya.me
- Telegram: @YakupKaya
- GitHub Issues: https://github.com/y4kupkaya/BasicFetch/issues