# BasicFetch Development Guide

## Setting up Development Environment

1. Clone the repository:
```bash
git clone https://github.com/y4kupkaya/BasicFetch.git
cd BasicFetch
```

2. Create virtual environment:
```bash
python -m venv venv
source venv/bin/activate  # On Windows: venv\Scripts\activate
```

3. Install in development mode:
```bash
pip install -e .[dev]
```

## Running Tests

```bash
# Run all tests
pytest

# Run with coverage
pytest --cov=basicfetch

# Run specific test
pytest test_basicfetch.py::TestSystemInfoCollector::test_get_basic_info
```

## Code Style

We use black for code formatting:
```bash
# Format all code
black .

# Check formatting
black --check .
```

We use flake8 for linting:
```bash
flake8 basicfetch.py distro_logo.py
```

## Type Checking

We use mypy for type checking:
```bash
mypy basicfetch.py
```

## Building and Publishing

### Build Package
```bash
# Build source and wheel distributions
python -m build

# Check the package
twine check dist/*
```

### Publishing to PyPI

#### Test PyPI (for testing)
```bash
# Upload to Test PyPI
twine upload --repository testpypi dist/*

# Install from Test PyPI
pip install --index-url https://test.pypi.org/simple/ basicfetch
```

#### Production PyPI
```bash
# Upload to PyPI
twine upload dist/*
```

## Release Process

1. Update version in setup.py and pyproject.toml
2. Update CHANGELOG.md
3. Update README.md if needed
4. Run tests: `pytest`
5. Build package: `python -m build`
6. Test package: `twine check dist/*`
7. Upload to Test PyPI: `twine upload --repository testpypi dist/*`
8. Test installation from Test PyPI
9. Upload to PyPI: `twine upload dist/*`
10. Create GitHub release with tag
11. Update documentation

## Adding New Features

1. Create feature branch: `git checkout -b feature/new-feature`
2. Implement feature with tests
3. Update documentation
4. Run all tests and checks
5. Submit pull request

## Adding New Distribution Logos

1. Add logo data to `distro_logo.py` in the `data` dictionary
2. Follow existing format with colors and logo ASCII art
3. Test the logo: `basicfetch -l your-distro`
4. Update documentation with new supported distro

## Debugging

Enable debug output:
```python
import logging
logging.basicConfig(level=logging.DEBUG)
```

Common issues:
- Import errors: Check Python path and virtual environment
- Permission errors: Check file permissions and admin rights
- Display issues: Test with different terminal emulators