# BasicFetch

[![PyPI version](https://badge.fury.io/py/basicfetch.svg)](https://badge.fury.io/py/basicfetch)
[![Python Support](https://img.shields.io/pypi/pyversions/basicfetch.svg)](https://pypi.org/project/basicfetch/)
[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)
[![Downloads](https://pepy.tech/badge/basicfetch)](https://pepy.tech/project/basicfetch)

Cross-platform system information display tool similar to neofetch/fastfetch, written in Python with rich feature set and beautiful ASCII logos.

## Features

- 🖥️ **Cross-platform support**: Windows, Linux, macOS, BSD systems
- 🎨 **Beautiful ASCII logos**: Over 200+ distribution logos
- 📊 **Comprehensive system info**: Hardware, software, network, storage details
- 🌈 **Rich color support**: ANSI color codes and RGB support
- 🎯 **Multiple display modes**: Simple, detailed, JSON output
- ⚡ **Fast performance**: Efficient system information gathering
- 🔧 **Highly customizable**: Various command-line options
- 🐍 **Pure Python**: No external system dependencies

## Installation

### From PyPI (Recommended)

```bash
pip install basicfetch
```

### From Source

```bash
git clone https://github.com/y4kupkaya/BasicFetch.git
cd BasicFetch
pip install -e .
```

### Development Installation

```bash
git clone https://github.com/y4kupkaya/BasicFetch.git
cd BasicFetch
pip install -e .[dev]
```

## Usage

### Basic Usage

```bash
# Display system information with logo
basicfetch

# Alternative command
bfetch
```

### Display Modes

```bash
# Simple mode - minimal information
basicfetch --simple
basicfetch -s

# Full mode - detailed information with color palette
basicfetch --full
basicfetch -f

# JSON output - machine readable format
basicfetch --json
basicfetch -j

# Only color palette
basicfetch --palette
basicfetch -p
```

### Logo Options

```bash
# Display without logo
basicfetch --no-logo
basicfetch -n

# Use specific distribution logo
basicfetch --distro ubuntu
basicfetch -d arch

# Show only logo for specific distribution
basicfetch --logo windows
basicfetch -l macos
```

### Display Options

```bash
# Disable colors
basicfetch --no-color

# Don't clear console before displaying
basicfetch --no-clear
```

### Examples

```bash
# Show detailed Windows information with logo
basicfetch -f -d windows

# Get system info in JSON format without clearing screen
basicfetch -j --no-clear

# Show Ubuntu logo only
basicfetch -l ubuntu

# Simple mode without colors
basicfetch -s --no-color
```

## System Information Displayed

### Basic Information

- **OS**: Operating system name and version
- **Host**: Computer name and model
- **Kernel**: Kernel version
- **Uptime**: System uptime
- **Packages**: Installed packages count
- **Shell**: Current shell
- **Resolution**: Screen resolution
- **Terminal**: Terminal emulator

### Hardware Information

- **CPU**: Processor name, cores, threads, frequency, usage
- **GPU**: Graphics card information and temperature
- **Memory**: RAM usage, total, available, swap
- **Storage**: Disk usage by partition
- **Motherboard**: Motherboard information

### Network Information

- **Network**: Data sent/received statistics

## Supported Systems

- **Windows**: 7, 8, 10, 11 (32-bit and 64-bit)
- **Linux**: All major distributions (Ubuntu, Debian, Arch, Fedora, etc.)
- **macOS**: 10.13+ (High Sierra and newer)
- **BSD**: FreeBSD, OpenBSD, NetBSD

## Supported Distribution Logos

Over 200+ ASCII logos including:

- **Linux**: Ubuntu, Debian, Arch, Fedora, CentOS, SUSE, Manjaro, etc.
- **BSD**: FreeBSD, OpenBSD, NetBSD
- **Windows**: All versions
- **macOS**: All versions
- **Other**: Android, Haiku, and many more

## Dependencies

- **Python 3.7+**
- **psutil**: System and process utilities
- **rich**: Rich text and beautiful formatting
- **wmi** (Windows only): Windows Management Instrumentation

## Performance

BasicFetch is designed to be fast and efficient:

- **Startup time**: < 0.5 seconds
- **Memory usage**: < 50MB
- **CPU usage**: Minimal impact
- **Network**: No external requests

## Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

1. Fork the repository
2. Create your feature branch (`git checkout -b feature/AmazingFeature`)
3. Commit your changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

### Development Setup

```bash
git clone https://github.com/y4kupkaya/BasicFetch.git
cd BasicFetch
pip install -e .[dev]

# Run tests
pytest

# Format code
black .

# Lint code
flake8

# Type checking
mypy basicfetch.py
```

## License

This project is licensed under the GNU General Public License v3.0 - see the [LICENSE](LICENSE) file for details.

## Changelog

### v1.0.0 (2025-01-18)

- Initial PyPI release
- Cross-platform system information display
- 200+ distribution logos
- Multiple display modes
- Rich color support
- Comprehensive hardware detection
- JSON output support
- Command-line interface

## Acknowledgments

- Inspired by [neofetch](https://github.com/dylanaraps/neofetch) and [fastfetch](https://github.com/fastfetch-cli/fastfetch)
- ASCII logos from various sources and community contributions
- Built with [psutil](https://github.com/giampaolo/psutil) and [rich](https://github.com/Textualize/rich)

## Support

If you encounter any issues or have questions:

- Open an issue on [GitHub Issues](https://github.com/y4kupkaya/BasicFetch/issues)
- Check the documentation and examples above
- Make sure you're using Python 3.7 or newer

---

## Author

**Yakup Kaya (@y4kupkaya)**

- 🌐 Website: [yakupkaya.me](https://yakupkaya.me)
- 📱 Telegram: [@YakupKaya](https://t.me/YakupKaya)
- 💻 GitHub: [@y4kupkaya](https://github.com/y4kupkaya)

*Made with ❤️ in Turkey*
