#!/usr/bin/env python3

from setuptools import setup, find_packages
import sys
import os

# Minimum Python version kontrolü
if sys.version_info < (3, 7):
    print("Python 3.7 veya üzeri gereklidir.")
    sys.exit(1)

# README dosyasını okuma
here = os.path.abspath(os.path.dirname(__file__))
with open(os.path.join(here, "README.md"), encoding="utf-8") as f:
    long_description = f.read()

# Requirements dosyasını okuma
with open(os.path.join(here, "requirements.txt"), encoding="utf-8") as f:
    requirements = [
        line.strip() for line in f if line.strip() and not line.startswith("#")
    ]

setup(
    name="basicfetch",
    version="1.0.0",
    author="Yakup Kaya",
    author_email="contact@yakupkaya.me",
    description="Cross-platform system information display tool similar to neofetch",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/y4kupkaya/BasicFetch",
    project_urls={
        "Homepage": "https://yakupkaya.me",
        "Bug Reports": "https://github.com/y4kupkaya/BasicFetch/issues",
        "Source": "https://github.com/y4kupkaya/BasicFetch",
        "Documentation": "https://github.com/y4kupkaya/BasicFetch#readme",
        "Author Website": "https://yakupkaya.me",
        "Telegram": "https://t.me/YakupKaya",
    },
    packages=find_packages(),
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Console",
        "Intended Audience :: End Users/Desktop",
        "Intended Audience :: System Administrators",
        "License :: OSI Approved :: GNU General Public License v3 (GPLv3)",
        "Natural Language :: English",
        "Natural Language :: Turkish",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Topic :: System :: Systems Administration",
        "Topic :: Utilities",
    ],
    keywords="system information neofetch fastfetch system-info hardware specs cli terminal",
    python_requires=">=3.7",
    install_requires=requirements,
    extras_require={
        "dev": [
            "pytest>=6.0",
            "pytest-cov>=2.0",
            "black>=21.0",
            "flake8>=3.8",
            "mypy>=0.800",
        ],
        "windows": [
            "wmi>=1.5.1; sys_platform == 'win32'",
        ],
    },
    entry_points={
        "console_scripts": [
            "basicfetch=basicfetch:main",
            "bfetch=basicfetch:main",
        ],
    },
    include_package_data=True,
    package_data={
        "": ["*.txt", "*.md", "*.rst"],
    },
    zip_safe=False,
    platforms=["any"],
)
