# Test file for basicfetch
import pytest
import sys
import os

# Add parent directory to path to import basicfetch
sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

import basicfetch
from basicfetch import SystemInfoCollector, SystemLogo, ColorSystem


class TestSystemInfoCollector:
    def test_init(self):
        collector = SystemInfoCollector()
        assert collector is not None
        assert hasattr(collector, "system_name")

    def test_get_basic_info(self):
        collector = SystemInfoCollector()
        info = collector.get_basic_info()
        assert isinstance(info, dict)
        assert "hostname" in info
        assert "os" in info
        assert "architecture" in info

    def test_get_cpu_info(self):
        collector = SystemInfoCollector()
        info = collector.get_cpu_info()
        assert isinstance(info, dict)
        assert "cpu" in info
        assert "cpu_cores" in info

    def test_get_memory_info(self):
        collector = SystemInfoCollector()
        info = collector.get_memory_info()
        assert isinstance(info, dict)
        assert "memory_total" in info
        assert "memory_used" in info


class TestColorSystem:
    def test_hex_to_rgb(self):
        rgb = ColorSystem.hex_to_rgb("#ff0000")
        assert rgb == (255, 0, 0)

        rgb = ColorSystem.hex_to_rgb("ff0000")
        assert rgb == (255, 0, 0)

    def test_rgb_to_hex(self):
        hex_color = ColorSystem.rgb_to_hex((255, 0, 0))
        assert hex_color == "#ff0000"

    def test_convert_color_to_ansi(self):
        ansi = ColorSystem.convert_color_to_ansi((255, 0, 0))
        assert ansi.startswith("\033[38;2;")


class TestSystemLogo:
    def test_get_system_name(self):
        name = SystemLogo._get_system_name()
        assert isinstance(name, str)
        assert len(name) > 0

    def test_get_system_logo(self):
        logo = SystemLogo.get_system_logo("Ubuntu", 10)
        assert isinstance(logo, list)


def test_main_function():
    # Test that main function exists and is callable
    assert callable(basicfetch.main)


if __name__ == "__main__":
    pytest.main([__file__])
