"""
Command definitions for Basicmicro motor controllers.
"""

from enum import IntEnum


class Commands(IntEnum):
    """
    Command enumerations for Basicmicro controllers.
    
    These commands are used to communicate with the controller
    in packet serial mode.
    """
    # Functions deprecated. Stubs retained for backwards compatibility
    M1FORWARD = 0
    M1BACKWARD = 1
    M2FORWARD = 4
    M2BACKWARD = 5
    M17BIT = 6
    M27BIT = 7
    MIXEDFORWARD = 8
    MIXEDBACKWARD = 9
    MIXEDRIGHT = 10
    MIXEDLEFT = 11
    MIXEDFB = 12
    MIXEDLR = 13
    # end stubs

    SETTIMEOUT = 14
    GETTIMEOUT = 15
    GETM1ENC = 16
    GETM2ENC = 17
    GETM1SPEED = 18
    GETM2SPEED = 19
    RESETENC = 20
    GETVERSION = 21
    SETM1ENCCOUNT = 22
    SETM2ENCCOUNT = 23
    GETMBATT = 24
    GETLBATT = 25
    
    SETM1PID = 28
    SETM2PID = 29
    GETM1ISPEED = 30
    GETM2ISPEED = 31
    M1DUTY = 32
    M2DUTY = 33
    MIXEDDUTY = 34
    M1SPEED = 35
    M2SPEED = 36
    MIXEDSPEED = 37
    M1SPEEDACCEL = 38
    M2SPEEDACCEL = 39
    MIXEDSPEEDACCEL = 40
    M1SPEEDDIST = 41
    M2SPEEDDIST = 42
    MIXEDSPEEDDIST = 43
    M1SPEEDACCELDIST = 44
    M2SPEEDACCELDIST = 45
    MIXEDSPEEDACCELDIST = 46
    GETBUFFERS = 47
    GETPWMS = 48
    GETCURRENTS = 49
    MIXEDSPEED2ACCEL = 50
    MIXEDSPEED2ACCELDIST = 51
    M1DUTYACCEL = 52
    M2DUTYACCEL = 53
    MIXEDDUTYACCEL = 54
    READM1PID = 55
    READM2PID = 56
    SETMAINVOLTAGES = 57
    SETLOGICVOLTAGES = 58
    GETMINMAXMAINVOLTAGES = 59
    GETMINMAXLOGICVOLTAGES = 60
    SETM1POSPID = 61
    SETM2POSPID = 62
    READM1POSPID = 63
    READM2POSPID = 64
    M1SPEEDACCELDECCELPOS = 65
    M2SPEEDACCELDECCELPOS = 66
    MIXEDSPEEDACCELDECCELPOS = 67
    SETM1DEFAULTACCEL = 68
    SETM2DEFAULTACCEL = 69
    SETM1DEFAULTSPEED = 70
    SETM2DEFAULTSPEED = 71
    GETDEFAULTSPEEDS = 72
    GETSTATUS = 73
    SETPINFUNCTIONS = 74
    GETPINFUNCTIONS = 75
    SETCTRLSETTINGS = 76
    GETCTRLSETTINGS = 77
    GETENCODERS = 78
    GETISPEEDS = 79
    RESTOREDEFAULTS = 80
    GETDEFAULTACCELS = 81
    GETTEMP = 82
    GETTEMP2 = 83
    GETERROR = 90
    GETENCODERMODE = 91
    SETM1ENCODERMODE = 92
    SETM2ENCODERMODE = 93
    WRITENVM = 94
    READNVM = 95
    SETSERIALNUMBER = 96
    GETSERIALNUMBER = 97
    SETCONFIG = 98
    GETCONFIG = 99
    GETVOLTS = 100
    GETTEMPS = 101
    SETAUXDUTYS = 102
    GETENCSTATUS = 103
    GETAUXDUTYS = 104
    SETAUTO1 = 105
    SETAUTO2 = 106
    GETAUTOS = 107
    GETSPEEDS = 108
    SETSPEEDERRORLIMIT = 109
    GETSPEEDERRORLIMIT = 110
    GETSPEEDERRORS = 111
    SETPOSERRORLIMIT = 112
    GETPOSERRORLIMIT = 113
    GETPOSERRORS = 114
    SETOFFSETS = 115
    GETOFFSETS = 116

    M1POS = 119
    M2POS = 120
    MIXEDPOS = 121
    M1SPEEDPOS = 122
    M2SPEEDPOS = 123
    MIXEDSPEEDPOS = 124
    M1PPOS = 125
    M2PPOS = 126
    MIXEDPPOS = 127
    SETM1LR = 128
    SETM2LR = 129
    GETM1LR = 130
    GETM2LR = 131
    
    SETM1MAXCURRENT = 133
    SETM2MAXCURRENT = 134
    GETM1MAXCURRENT = 135
    GETM2MAXCURRENT = 136

    SETDOUT = 137
    GETDOUTS = 138
    SETPRIORITY = 139
    GETPRIORITY = 140
    SETADDRESSMIXED = 141
    GETADDRESSMIXED = 142
    SETSIGNAL = 143
    GETSIGNALS = 144
    SETSTREAM = 145
    GETSTREAMS = 146
    GETSIGNALSDATA = 147
                          
    SETPWMMODE = 148
    GETPWMMODE = 149

    SETNODEID = 150
    GETNODEID = 151

    SETPWMIDLE = 160
    GETPWMIDLE = 161

    CANBUFFERSTATE = 180
    CANPUTPACKET = 181
    CANGETPACKET = 182

    CANOPENWRITELOCALDICT = 190
    CANOPENREADLOCALDICT = 191

    RESETESTOP = 200
    SETESTOPLOCK = 201
    GETESTOPLOCK = 202

    SETSCRIPTAUTORUN = 246
    GETSCRIPTAUTORUN = 247
    STARTSCRIPT = 248
    STOPSCRIPT = 249

    READEEPROM = 252
    WRITEEEPROM = 253