# Basic Progress Bar
Progress bar for console and discord


[![Pypi](https://github.com/Sumiza/basicprogressbar/actions/workflows/python-publish.yml/badge.svg)](https://github.com/Sumiza/basicprogressbar/actions/workflows/python-publish.yml)
![PyPI](https://img.shields.io/pypi/v/basicprogressbar)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/basicprogressbar)


<br/>

installation:
```bash
pip install basicprogressbar        # for basic features
pip install basicprogressbar[timer] # for pretty time support
pip install basicprogressbar[all]   # for all features
```
```python
from basicprogressbar import BasicProgressBar
```

Arguments:
```python
    current:float = 0       # current progress
    total:float = -1        # total progress '-1' for unlimited
    posttext:str=""         # text behind the bar
    pretext:str="Progress:" # text before the bar
    length:int=60           # length of the bar
    endtext:str=""          # text after the bar when done
    endline:str='\r'        # endline character to rewite same line
    showtime:bool=False     # show remaining time
```

Basic Examples:

```python
prog = BasicProgressBar(1, 50, pretext="Before bar:", showtimer=True)
for i in range(51):
    time.sleep(0.1)
    prog.current = i
    prog.endtext = (f"I ended on {i}")
    prog.bar(True)

for i in range(11):
    time.sleep(0.1)
    BasicProgressBar(i, 10).bar(True)

prog = BasicProgressBar(1, 10)
for i in range(11):
    time.sleep(0.1)
    prog.current = i
    prog.posttext = f"processing {i}"
    print(prog.bar(), end=prog.endline)

prog = BasicProgressBar()
for i in range(25):
    time.sleep(0.1)
    print(prog.next(), end="\r")
print()
```
<br/>

# Discord Progress Bar:
Progress bar for discord
<br/>

installation:
```bash
pip install basicprogressbar[discord]
```
```python
from basicprogressbar import DiscordProgressBar
```



Arguments:
```python
    # All the arguments of from BasicProgressBar first
    idtoken:str=""              # discord id token
    disuser:str="Progress Bar"  # name of discord user
    throttle:float=0.5          # time between messages
    # shouldnt have to edit the ones below
    messtime:float=0.0          # time used for waiting between messages
    messid:str=""               # message id to edit line
    timeout:float=10.0          # discord timeout
```
```python
# all examples from BasicProgressBar apply
token = "23135245523/f43faDSAF-FEAfe24f3qfq-2yfbB-agdagADGA-g334t34gqarGS"

prog = DiscordProgressBar(1,100,idtoken=token)
for i in range(1,101):
    time.sleep(0.1)
    prog.current = i
    prog.send()

prog = DiscordProgressBar(idtoken=token)
for i in range(1,101):
    time.sleep(0.1)
    prog.current = i
    prog.send()

prog = DiscordProgressBar(total=100, idtoken=token)
for i in range(1,101):
    time.sleep(0.1)
    prog.next()
```


## For Async use:
##### Dependencies: httpx, asyncio
```bash
pip install basicprogressbar[async]
```
```python
from basicprogressbar import class DiscordProgressBarAsync
```

```python
# Async Examples
import asyncio

token = "23135245523/f43faDSAF-FEAfe24f3qfq-2yfbB-agdagADGA-g334t34gqarGS"

prog = basicprogressbar.DiscordProgressBarAsync(1,100, idtoken=token)

async def sending():
    for i in range(1, 51):
        prog.current = i
        await prog.send()
        await asyncio.sleep(1)

asyncio.run(sending())
```