/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.aliyun.batchcompute.demo.logcount.util;

import java.util.Properties;

/**
 * Created by guangchun.luo on 15/4/16.
 */
public class Config {

    private Config() {

        String[] arr = new String[]{
                "config.properties"
        };

        Properties prop = FileLoader.loadProperties(arr);

        accessId = (String) prop.get("accessId");
        accessKey = (String) prop.get("accessKey");
        dataPath = (String) prop.get("dataPath");

    }

    private static Config config;

    public static Config getInstance() {
        if (null == config) {
            config = new Config();
        }
        return config;
    }


    public String getAccessId() {
        return accessId;
    }

    public String getAccessKey() {
        return accessKey;
    }

    public String getDataPath() {
        return dataPath;
    }


    private String accessId;
    private String accessKey;
    private String dataPath;

}
