python job project
-----------------------

## 1. 工程介绍

这是一个 BatchCompute 作业工程, 用来创建 AliCloud BatchCompute 作业.

本例子主要功能: 

* 使用1个split任务将log.txt分为10份上传到oss;
* 然后启动10个count任务统计日志类型的数量,结果上传到oss;
* 然后在启动1个merge任务汇总日志类型的数量,结果上传到oss.

工程目录结构:

```
 |-- src/             # 作业逻辑代码目录
      |-- oss2           # oss2 sdk
      |-- oss_tool.py    # oss2的封装, 方便操作
      |-- conf.py        # 配置
      |-- split.py        # 任务split的程序, 将log.txt分为10份
      |-- count.py        # 任务find的程序, 统计每份的日志类型数量
      |-- merge.py      # 任务merge的程序, 汇总日志类型数量
 |-- project.json     # 工程描述文件, 描述打包路径等
 |-- job.json         # 作业描述文件, 描述作业中的任务, 以及DAG顺序.
 |-- Readme.md        # 新手必读
```

您可以使用以下命令查看作业描述详情:

```bash
bcs p status   
```


还可以查看其他命令如何使用:
```bash
bcs -h        # 查看帮助
bcs jobs -h   # 查看子命令帮助
```


## 2. 编辑作业代码

### (1) 配置 job.json

使用命令添加 auto cluster.

```bash
bcs p update -c img=m-28s58a5qq:type=ecs.s3.large
```

当然, 您也可以手动修改 job.json.

### (2) 修改代码:

代码逻辑都在src目录中, 可以根据业务实际情况修改.

程序运行入口在 job.json 的 每个task中 Parameters.Command.CommandLine 字段指定.

你可以手动修改, 也可以使用命令行工具批量修改哦, 当然也可以到入到其他IDE中编辑.


### (3) 本地调试(适用于Docker模式运行的任务):

本地调试需要有Docker环境, 如果没有安装Docker请到官网查看教程, 这里不再赘述.

* 注意: 如果是Mac和Windows环境, 安装docker后, 需要双击 boot2docker 或者 Docker quickstart terminal 进入docker命令行环境

使用下面的命令调试:
```bash
bcs debug -h  #查看debug命令的帮助
```


## 3. build 工程

```bash
bcs p build
```

这个命令会执行以下操作:

按照 project.json 文件的 tar_src 字段指定的文件打包到 worker.tar.gz. (最终需要在project根目录生成 worker.tar.gz)


## 4. 提交作业

```bash
bcs p submit
```

这个命令会做 3 步操作:

#### (1). 校验 job.json 的各个字段正确性.

#### (2). 上传 worker.tar.gz 到oss

具体地址为 job.json 中的配置的PackagePath 

#### (3). 按照 job.json 提交作业.

最后你可以 通过以下命令查看作业状态:

```bash
bcs job <job-id>
```


