# -*- coding: utf-8 -*-

import oss_tool
import os
from conf import conf
import re
import json

# instance_id: should be start from 0
instance_id = os.environ['BATCH_COMPUTE_DAG_INSTANCE_ID']

data_path = conf['data_path']

split_results = 'split_results'

filename = 'part_%s.txt' %  instance_id

def main():

    pre = data_path[0: data_path.rfind('/')]

    print('download form: %s/%s/' % (pre, split_results))

    # 1. download a part
    oss_tool.download_file('%s/%s/%s.txt' % (pre, split_results, instance_id ), filename)

    # 2. parse, calculate
    with open(filename) as f:
        txt = f.read()

    m = {
        'INFO': 0,
        'WARN': 0,
        'ERROR': 0,
        'DEBUG': 0
    }


    for k in m:
       m[k] = len(re.findall(k, txt))

    print(m)

    # 3. upload result to oss
    upload_to = '%s/count_results/%s.json' % (pre, instance_id )
    print('upload to %s' % upload_to)
    oss_tool.put_data(json.dumps(m), upload_to)


if __name__ == '__main__':
    main()