# -*- coding: utf-8 -*-
from terminal import green
import re
import os
from ..util import client, config, formater, list2table, qsub_config
import json
import uuid
import base64
import tarfile
from ..const import  STRING, NUMBER
import socket


def qstat(for_job_id=None, all=False, waiting=False, running=False,

          user_list=None, nodes=None, ss=False,RR=False, QQ=False, qq=False, PBS=False):

    if for_job_id:
        get_job_info(for_job_id)
    elif all:
        list()
    elif waiting:
        list(None, 'Waiting')
    elif running:
        list(None, 'Running')
    else:
        list(None, 'Waiting,Running')

def get_job_info(jobId):
    try:

       jobId = formater.get_job_id(jobId)
    except:
        raise Exception('Invalid jobId')

    result= client.get_job(jobId)
    #desc = client.get_job_description(jobId)

    print('Job Id: %s' % result.Id)

    for k,v in result.items():
        if k=='Id' or k=='Message':
            continue

        if isinstance(v, STRING):
           print('%s=%s' % (k,v))
        elif isinstance(v, NUMBER):
            print('%s=%s' % (k, v))




def list(n=None, state=None):
    result = client.list_jobs()
    arr = formater.items2arr(result.get('Items'))

    filter = {'Name': {'startswith':"qsub-"}}

    # state filter
    if state:
        filter['State'] = state.split(',')

    arr = formater.filter_list(arr, filter)

    if n:
        _print(arr[:n])
    else:
        _print(arr)

    #print(' total: %s' % len(arr))

def _print(arr):
    arr = formater.format_date_in_arr(arr, ['CreationTime', 'StartTime', 'EndTime'])
    list2table.print_table(arr, [('Id','job-Id',formater.hex_job_id), ('Name','name'), ('State', 'state', formater.get_job_state_simple),
                                 ('CreationTime', 'submit at'), ('StartTime','start at'), ('EndTime', 'end at')],
                           show_no=False,show_border=False)


