/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.aliyun.batchcompute.demo.logcount;

import com.aliyun.batchcompute.demo.logcount.util.Config;
import com.aliyun.batchcompute.demo.logcount.util.OSSTool;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;

import java.io.*;

/**
 * Created by guangchun.luo on 16/3/2.
 */
public class Split {

    public static void main(String[] args) throws Exception{

        Config cfg = Config.getInstance();

        String dataPath = cfg.getDataPath();

        String pre = dataPath.substring(0, dataPath.lastIndexOf("/"));


        InputStream is = OSSTool.getObjectContent(dataPath);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));


        int c = 0;
        int num = 0;
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line).append("\n");
            c++;

            if( c >= 3500 ){

                OSSTool.putObjectContent(pre+"/split_results/"+ num + ".txt", sb.toString());
                sb = new StringBuilder("");
                c=0;
                num++;
            }

        }

        if(!sb.toString().trim().equals("")){
            OSSTool.putObjectContent(pre+"/split_results/"+ num + ".txt", sb.toString());
        }

        System.out.println("total: "+ (num+1));

        is.close();

    }


}
