native job project: GATK
-----------------------

## 1. 工程介绍

工程目录结构:

```
 |-- gatk4-data-processing
     |-- src/
          |-- processing-for-variant-discovery-gatk4.wdl
          |-- processing-for-variant-discovery-gatk4.hg38.wgs.inputs.json
          |-- generic.batchcmopute-papi.options.json
          |-- LICENSE
          |-- README.md
     |-- main.sh
 |-- gatk4-germline-snps-indels
     |-- src/
          |-- haplotypecaller-gvcf-gatk4.wdl
          |-- haplotypecaller-gvcf-gatk4.hg38.wgs.inputs.json
          |-- generic.batchcompute-papi.options.json
          |-- joint-discovery-gatk4.wdl
          |-- joint-discovery-gatk4.hg38.wgs.inputs.json
          |-- LICENSE
          |-- README.md
     |-- haplotypecaller-gvcf-gatk4-main.sh
     |-- joint-discovery-gatk4-main.sh
 |-- README.md
```

生成的代码中，包含3个部分：data-processing , germline-snps-indels 和 joint-discovery。
一般情况下，先运行 data-processing，成功后再运行 germline-snps-indels， 最后运行 joint-discovery。


## 2. 编辑作业代码

运行前需要先编辑: main.sh

* 修改 main.sh 中的 input_WORKING_DIR 和 output_OUTPUTS_DIR 路径。


## 3. 提交作业

```bash
sh main.sh
```

最后你可以 通过以下命令查看作业状态:

```bash
bcs j <job-id>  # 查看作业状态

bcs log <job-id>  # 查看作业日志
```


## 4. 验证结果

查看中间文件:

```
bcs o ls oss://your_bucket/gatk4_worker_dir/
```

查看结果日志等:
```
bcs o ls oss://your_bucket/gatk4_outputs/
```






