/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package com.aliyun.batchcompute.demo.logcount.util;

import com.aliyun.batchcompute.demo.logcount.pojo.OSSPathInfo;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

/**
 * Created by guangchun.luo on 16/3/2.
 */
public class OSSTool {

    //环境变量
    static String ossHost = System.getenv("BATCH_COMPUTE_OSS_HOST");


    public static InputStream getObjectContent(String ossPath) throws Exception {

        Config cfg = Config.getInstance();

        OSSClient ossClient = new OSSClient(ossHost, cfg.getAccessId(), cfg.getAccessKey());

        System.out.println("reading : "+ossPath);

        OSSPathInfo ossPathInfo = parseOSSPath(ossPath);

        OSSObject ossObject = ossClient.getObject(ossPathInfo.getBucket(), ossPathInfo.getKey());

        InputStream is = ossObject.getObjectContent();

        return is;
    }

    public static void putObjectContent(String ossPath, String content) throws Exception {

        byte[] barr = content.getBytes("UTF-8");

        System.out.println("upload to: "+ossPath+", size:"+barr.length);

        Config cfg = Config.getInstance();

        OSSClient ossClient = new OSSClient(ossHost,  cfg.getAccessId(), cfg.getAccessKey());

        OSSPathInfo ossPathInfo = parseOSSPath(ossPath);




        ObjectMetadata objMeta = new ObjectMetadata();
        objMeta.setContentLength(barr.length);


        InputStream is = new ByteArrayInputStream(barr);

        PutObjectResult result = ossClient.putObject(ossPathInfo.getBucket(), ossPathInfo.getKey(), is, objMeta);

        System.out.println("etag:"+result.getETag());

        is.close();
    }


    public static OSSPathInfo parseOSSPath(String ossPath) throws Exception{
        if(!ossPath.startsWith("oss://")){
            throw new Exception("Invalid osspath:" + ossPath);
        }

        String str = ossPath.substring("oss://".length());

        return new OSSPathInfo(str.substring(0, str.indexOf("/")),
                str.substring(str.indexOf("/")+1));
    }

}




