/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.aliyun.batchcompute.demo.logcount;

import com.aliyun.batchcompute.demo.logcount.pojo.CountInfo;
import com.aliyun.batchcompute.demo.logcount.util.Config;
import com.aliyun.batchcompute.demo.logcount.util.OSSTool;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * Created by guangchun.luo on 16/3/2.
 */
public class Count {

    static String instanceId = System.getenv("BATCH_COMPUTE_DAG_INSTANCE_ID");


    public static void main(String[] args) throws Exception {

        Config cfg = Config.getInstance();

        String dataPath = cfg.getDataPath();

        String pre = dataPath.substring(0, dataPath.lastIndexOf("/"));

        String oss_path = pre+"/split_results/"+instanceId+".txt";

        String oss_path_result = pre+"/count_results/"+instanceId+".json";


        InputStream is = OSSTool.getObjectContent(oss_path);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));

        CountInfo countInfo = new CountInfo();

        String line = null;
        while ((line = br.readLine()) != null) {
            if(line.indexOf("[INFO]")!=-1){
                countInfo.info++;
            }
             else if(line.indexOf("[ERROR]")!=-1){
                countInfo.error++;
            }
            else if(line.indexOf("[DEBUG]")!=-1){
                countInfo.debug++;
            }
            else {
                countInfo.warn++;
            }
        }

        is.close();

        System.out.println("count: "+countInfo.toString());
        OSSTool.putObjectContent(oss_path_result, countInfo.toString());
    }
}