# This file was autogenerated by some hot garbage in the `uniffi` crate.
# Trust me, you don't want to mess with it!

# Tell mypy (a type checker) to ignore all errors from this file.
# See https://mypy.readthedocs.io/en/stable/config_file.html?highlight=ignore-errors#confval-ignore_errors
# mypy: ignore-errors

# Common helper code.
#
# Ideally this would live in a separate .py file where it can be unittested etc
# in isolation, and perhaps even published as a re-useable package.
#
# However, it's important that the details of how this helper code works (e.g. the
# way that different builtin types are passed across the FFI) exactly match what's
# expected by the rust code on the other side of the interface. In practice right
# now that means coming from the exact some version of `uniffi` that was used to
# compile the rust component. The easiest way to ensure this is to bundle the Python
# helpers directly inline like we're doing here.

import os
import sys
import ctypes
import enum
import struct
import contextlib
import datetime

# Used for default argument values
DEFAULT = object()


class RustBuffer(ctypes.Structure):
    _fields_ = [
        ("capacity", ctypes.c_int32),
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    @staticmethod
    def alloc(size):
        return rust_call(_UniFFILib.ffi_bdk_3ed8_rustbuffer_alloc, size)

    @staticmethod
    def reserve(rbuf, additional):
        return rust_call(_UniFFILib.ffi_bdk_3ed8_rustbuffer_reserve, rbuf, additional)

    def free(self):
        return rust_call(_UniFFILib.ffi_bdk_3ed8_rustbuffer_free, self)

    def __str__(self):
        return "RustBuffer(capacity={}, len={}, data={})".format(
            self.capacity,
            self.len,
            self.data[0:self.len]
        )

    @contextlib.contextmanager
    def allocWithBuilder():
        """Context-manger to allocate a buffer using a RustBufferBuilder.

        The allocated buffer will be automatically freed if an error occurs, ensuring that
        we don't accidentally leak it.
        """
        builder = RustBufferBuilder()
        try:
            yield builder
        except:
            builder.discard()
            raise

    @contextlib.contextmanager
    def consumeWithStream(self):
        """Context-manager to consume a buffer using a RustBufferStream.

        The RustBuffer will be freed once the context-manager exits, ensuring that we don't
        leak it even if an error occurs.
        """
        try:
            s = RustBufferStream(self)
            yield s
            if s.remaining() != 0:
                raise RuntimeError("junk data left in buffer after consuming")
        finally:
            self.free()


class ForeignBytes(ctypes.Structure):
    _fields_ = [
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    def __str__(self):
        return "ForeignBytes(len={}, data={})".format(self.len, self.data[0:self.len])


class RustBufferStream(object):
    """
    Helper for structured reading of bytes from a RustBuffer
    """

    def __init__(self, rbuf):
        self.rbuf = rbuf
        self.offset = 0

    def remaining(self):
        return self.rbuf.len - self.offset

    def _unpack_from(self, size, format):
        if self.offset + size > self.rbuf.len:
            raise InternalError("read past end of rust buffer")
        value = struct.unpack(format, self.rbuf.data[self.offset:self.offset+size])[0]
        self.offset += size
        return value

    def read(self, size):
        if self.offset + size > self.rbuf.len:
            raise InternalError("read past end of rust buffer")
        data = self.rbuf.data[self.offset:self.offset+size]
        self.offset += size
        return data

    def readI8(self):
        return self._unpack_from(1, ">b")

    def readU8(self):
        return self._unpack_from(1, ">B")

    def readI16(self):
        return self._unpack_from(2, ">h")

    def readU16(self):
        return self._unpack_from(2, ">H")

    def readI32(self):
        return self._unpack_from(4, ">i")

    def readU32(self):
        return self._unpack_from(4, ">I")

    def readI64(self):
        return self._unpack_from(8, ">q")

    def readU64(self):
        return self._unpack_from(8, ">Q")

    def readFloat(self):
        v = self._unpack_from(4, ">f")
        return v

    def readDouble(self):
        return self._unpack_from(8, ">d")


class RustBufferBuilder(object):
    """
    Helper for structured writing of bytes into a RustBuffer.
    """

    def __init__(self):
        self.rbuf = RustBuffer.alloc(16)
        self.rbuf.len = 0

    def finalize(self):
        rbuf = self.rbuf
        self.rbuf = None
        return rbuf

    def discard(self):
        if self.rbuf is not None:
            rbuf = self.finalize()
            rbuf.free()

    @contextlib.contextmanager
    def _reserve(self, numBytes):
        if self.rbuf.len + numBytes > self.rbuf.capacity:
            self.rbuf = RustBuffer.reserve(self.rbuf, numBytes)
        yield None
        self.rbuf.len += numBytes

    def _pack_into(self, size, format, value):
        with self._reserve(size):
            # XXX TODO: I feel like I should be able to use `struct.pack_into` here but can't figure it out.
            for i, byte in enumerate(struct.pack(format, value)):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write(self, value):
        with self._reserve(len(value)):
            for i, byte in enumerate(value):
                self.rbuf.data[self.rbuf.len + i] = byte

    def writeI8(self, v):
        self._pack_into(1, ">b", v)

    def writeU8(self, v):
        self._pack_into(1, ">B", v)

    def writeI16(self, v):
        self._pack_into(2, ">h", v)

    def writeU16(self, v):
        self._pack_into(2, ">H", v)

    def writeI32(self, v):
        self._pack_into(4, ">i", v)

    def writeU32(self, v):
        self._pack_into(4, ">I", v)

    def writeI64(self, v):
        self._pack_into(8, ">q", v)

    def writeU64(self, v):
        self._pack_into(8, ">Q", v)

    def writeFloat(self, v):
        self._pack_into(4, ">f", v)

    def writeDouble(self, v):
        self._pack_into(8, ">d", v)
# A handful of classes and functions to support the generated data structures.
# This would be a good candidate for isolating in its own ffi-support lib.

class InternalError(Exception):
    pass

class RustCallStatus(ctypes.Structure):
    """
    Error runtime.
    """
    _fields_ = [
        ("code", ctypes.c_int8),
        ("error_buf", RustBuffer),
    ]

    # These match the values from the uniffi::rustcalls module
    CALL_SUCCESS = 0
    CALL_ERROR = 1
    CALL_PANIC = 2

    def __str__(self):
        if self.code == RustCallStatus.CALL_SUCCESS:
            return "RustCallStatus(CALL_SUCCESS)"
        elif self.code == RustCallStatus.CALL_ERROR:
            return "RustCallStatus(CALL_ERROR)"
        elif self.code == RustCallStatus.CALL_PANIC:
            return "RustCallStatus(CALL_PANIC)"
        else:
            return "RustCallStatus(<invalid code>)"

def rust_call(fn, *args):
    # Call a rust function
    return rust_call_with_error(None, fn, *args)

def rust_call_with_error(error_ffi_converter, fn, *args):
    # Call a rust function and handle any errors
    #
    # This function is used for rust calls that return Result<> and therefore can set the CALL_ERROR status code.
    # error_ffi_converter must be set to the FfiConverter for the error class that corresponds to the result.
    call_status = RustCallStatus(code=RustCallStatus.CALL_SUCCESS, error_buf=RustBuffer(0, 0, None))

    args_with_error = args + (ctypes.byref(call_status),)
    result = fn(*args_with_error)
    if call_status.code == RustCallStatus.CALL_SUCCESS:
        return result
    elif call_status.code == RustCallStatus.CALL_ERROR:
        if error_ffi_converter is None:
            call_status.error_buf.free()
            raise InternalError("rust_call_with_error: CALL_ERROR, but error_ffi_converter is None")
        else:
            raise error_ffi_converter.lift(call_status.error_buf)
    elif call_status.code == RustCallStatus.CALL_PANIC:
        # When the rust code sees a panic, it tries to construct a RustBuffer
        # with the message.  But if that code panics, then it just sends back
        # an empty buffer.
        if call_status.error_buf.len > 0:
            msg = FfiConverterString.lift(call_status.error_buf)
        else:
            msg = "Unknown rust panic"
        raise InternalError(msg)
    else:
        raise InternalError("Invalid RustCallStatus code: {}".format(
            call_status.code))

# A function pointer for a callback as defined by UniFFI.
# Rust definition `fn(handle: u64, method: u32, args: RustBuffer, buf_ptr: *mut RustBuffer) -> int`
FOREIGN_CALLBACK_T = ctypes.CFUNCTYPE(ctypes.c_int, ctypes.c_ulonglong, ctypes.c_ulong, RustBuffer, ctypes.POINTER(RustBuffer))
# Types conforming to `FfiConverterPrimitive` pass themselves directly over the FFI.
class FfiConverterPrimitive:
    @classmethod
    def lift(cls, value):
        return value

    @classmethod
    def lower(cls, value):
        return value

# Helper class for wrapper types that will always go through a RustBuffer.
# Classes should inherit from this and implement the `read` and `write` static methods.
class FfiConverterRustBuffer:
    @classmethod
    def lift(cls, rbuf):
        with rbuf.consumeWithStream() as stream:
            return cls.read(stream)

    @classmethod
    def lower(cls, value):
        with RustBuffer.allocWithBuilder() as builder:
            cls.write(value, builder)
            return builder.finalize()

# Contains loading, initialization code,
# and the FFI Function declarations in a com.sun.jna.Library.
# This is how we find and load the dynamic library provided by the component.
# For now we just look it up by name.
#
# XXX TODO: This will probably grow some magic for resolving megazording in future.
# E.g. we might start by looking for the named component in `libuniffi.so` and if
# that fails, fall back to loading it separately from `lib${componentName}.so`.

from pathlib import Path

def loadIndirect():
    if sys.platform == "darwin":
        libname = "lib{}.dylib"
    elif sys.platform.startswith("win"):
        # As of python3.8, ctypes does not seem to search $PATH when loading DLLs.
        # We could use `os.add_dll_directory` to configure the search path, but
        # it doesn't feel right to mess with application-wide settings. Let's
        # assume that the `.dll` is next to the `.py` file and load by full path.
        libname = os.path.join(
            os.path.dirname(__file__),
            "{}.dll",
        )
    else:
        # Anything else must be an ELF platform - Linux, *BSD, Solaris/illumos
        libname = "lib{}.so"

    lib = libname.format("bdkffi")
    path = str(Path(__file__).parent / lib)
    return ctypes.cdll.LoadLibrary(path)

# A ctypes library to expose the extern-C FFI definitions.
# This is an implementation detail which will be called internally by the public API.

_UniFFILib = loadIndirect()
_UniFFILib.ffi_bdk_3ed8_Blockchain_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_Blockchain_object_free.restype = None
_UniFFILib.bdk_3ed8_Blockchain_new.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Blockchain_new.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_Blockchain_broadcast.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Blockchain_broadcast.restype = None
_UniFFILib.bdk_3ed8_Blockchain_estimate_fee.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Blockchain_estimate_fee.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_Blockchain_get_height.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Blockchain_get_height.restype = ctypes.c_uint32
_UniFFILib.bdk_3ed8_Blockchain_get_block_hash.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Blockchain_get_block_hash.restype = RustBuffer
_UniFFILib.ffi_bdk_3ed8_Wallet_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_Wallet_object_free.restype = None
_UniFFILib.bdk_3ed8_Wallet_new.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Wallet_new.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_Wallet_get_address.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Wallet_get_address.restype = RustBuffer
_UniFFILib.bdk_3ed8_Wallet_get_internal_address.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Wallet_get_internal_address.restype = RustBuffer
_UniFFILib.bdk_3ed8_Wallet_get_balance.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Wallet_get_balance.restype = RustBuffer
_UniFFILib.bdk_3ed8_Wallet_sign.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Wallet_sign.restype = ctypes.c_int8
_UniFFILib.bdk_3ed8_Wallet_list_transactions.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int8,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Wallet_list_transactions.restype = RustBuffer
_UniFFILib.bdk_3ed8_Wallet_network.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Wallet_network.restype = RustBuffer
_UniFFILib.bdk_3ed8_Wallet_sync.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Wallet_sync.restype = None
_UniFFILib.bdk_3ed8_Wallet_list_unspent.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Wallet_list_unspent.restype = RustBuffer
_UniFFILib.ffi_bdk_3ed8_FeeRate_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_FeeRate_object_free.restype = None
_UniFFILib.bdk_3ed8_FeeRate_from_sat_per_vb.argtypes = (
    ctypes.c_float,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_FeeRate_from_sat_per_vb.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_FeeRate_as_sat_per_vb.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_FeeRate_as_sat_per_vb.restype = ctypes.c_float
_UniFFILib.ffi_bdk_3ed8_Transaction_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_Transaction_object_free.restype = None
_UniFFILib.bdk_3ed8_Transaction_new.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Transaction_new.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_Transaction_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Transaction_txid.restype = RustBuffer
_UniFFILib.bdk_3ed8_Transaction_weight.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Transaction_weight.restype = ctypes.c_uint64
_UniFFILib.bdk_3ed8_Transaction_size.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Transaction_size.restype = ctypes.c_uint64
_UniFFILib.bdk_3ed8_Transaction_vsize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Transaction_vsize.restype = ctypes.c_uint64
_UniFFILib.bdk_3ed8_Transaction_serialize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Transaction_serialize.restype = RustBuffer
_UniFFILib.bdk_3ed8_Transaction_is_coin_base.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Transaction_is_coin_base.restype = ctypes.c_int8
_UniFFILib.bdk_3ed8_Transaction_is_explicitly_rbf.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Transaction_is_explicitly_rbf.restype = ctypes.c_int8
_UniFFILib.bdk_3ed8_Transaction_is_lock_time_enabled.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Transaction_is_lock_time_enabled.restype = ctypes.c_int8
_UniFFILib.bdk_3ed8_Transaction_version.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Transaction_version.restype = ctypes.c_int32
_UniFFILib.bdk_3ed8_Transaction_lock_time.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Transaction_lock_time.restype = ctypes.c_uint32
_UniFFILib.bdk_3ed8_Transaction_input.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Transaction_input.restype = RustBuffer
_UniFFILib.bdk_3ed8_Transaction_output.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Transaction_output.restype = RustBuffer
_UniFFILib.ffi_bdk_3ed8_PartiallySignedTransaction_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_PartiallySignedTransaction_object_free.restype = None
_UniFFILib.bdk_3ed8_PartiallySignedTransaction_new.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_PartiallySignedTransaction_new.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_PartiallySignedTransaction_serialize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_PartiallySignedTransaction_serialize.restype = RustBuffer
_UniFFILib.bdk_3ed8_PartiallySignedTransaction_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_PartiallySignedTransaction_txid.restype = RustBuffer
_UniFFILib.bdk_3ed8_PartiallySignedTransaction_extract_tx.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_PartiallySignedTransaction_extract_tx.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_PartiallySignedTransaction_combine.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_PartiallySignedTransaction_combine.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_PartiallySignedTransaction_fee_amount.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_PartiallySignedTransaction_fee_amount.restype = RustBuffer
_UniFFILib.bdk_3ed8_PartiallySignedTransaction_fee_rate.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_PartiallySignedTransaction_fee_rate.restype = RustBuffer
_UniFFILib.bdk_3ed8_PartiallySignedTransaction_json_serialize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_PartiallySignedTransaction_json_serialize.restype = RustBuffer
_UniFFILib.ffi_bdk_3ed8_TxBuilder_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_TxBuilder_object_free.restype = None
_UniFFILib.bdk_3ed8_TxBuilder_new.argtypes = (
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_TxBuilder_new.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_TxBuilder_add_recipient.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_TxBuilder_add_recipient.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_TxBuilder_add_unspendable.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_TxBuilder_add_unspendable.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_TxBuilder_add_utxo.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_TxBuilder_add_utxo.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_TxBuilder_add_utxos.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_TxBuilder_add_utxos.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_TxBuilder_do_not_spend_change.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_TxBuilder_do_not_spend_change.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_TxBuilder_manually_selected_only.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_TxBuilder_manually_selected_only.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_TxBuilder_only_spend_change.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_TxBuilder_only_spend_change.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_TxBuilder_unspendable.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_TxBuilder_unspendable.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_TxBuilder_fee_rate.argtypes = (
    ctypes.c_void_p,
    ctypes.c_float,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_TxBuilder_fee_rate.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_TxBuilder_fee_absolute.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_TxBuilder_fee_absolute.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_TxBuilder_drain_wallet.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_TxBuilder_drain_wallet.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_TxBuilder_drain_to.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_TxBuilder_drain_to.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_TxBuilder_enable_rbf.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_TxBuilder_enable_rbf.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_TxBuilder_enable_rbf_with_sequence.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_TxBuilder_enable_rbf_with_sequence.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_TxBuilder_add_data.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_TxBuilder_add_data.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_TxBuilder_set_recipients.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_TxBuilder_set_recipients.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_TxBuilder_finish.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_TxBuilder_finish.restype = RustBuffer
_UniFFILib.ffi_bdk_3ed8_BumpFeeTxBuilder_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_BumpFeeTxBuilder_object_free.restype = None
_UniFFILib.bdk_3ed8_BumpFeeTxBuilder_new.argtypes = (
    RustBuffer,
    ctypes.c_float,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_BumpFeeTxBuilder_new.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_BumpFeeTxBuilder_allow_shrinking.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_BumpFeeTxBuilder_allow_shrinking.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_BumpFeeTxBuilder_enable_rbf.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_BumpFeeTxBuilder_enable_rbf.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_BumpFeeTxBuilder_enable_rbf_with_sequence.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_BumpFeeTxBuilder_enable_rbf_with_sequence.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_BumpFeeTxBuilder_finish.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_BumpFeeTxBuilder_finish.restype = ctypes.c_void_p
_UniFFILib.ffi_bdk_3ed8_Mnemonic_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_Mnemonic_object_free.restype = None
_UniFFILib.bdk_3ed8_Mnemonic_new.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Mnemonic_new.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_Mnemonic_from_string.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Mnemonic_from_string.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_Mnemonic_from_entropy.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Mnemonic_from_entropy.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_Mnemonic_as_string.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Mnemonic_as_string.restype = RustBuffer
_UniFFILib.ffi_bdk_3ed8_DerivationPath_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_DerivationPath_object_free.restype = None
_UniFFILib.bdk_3ed8_DerivationPath_new.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_DerivationPath_new.restype = ctypes.c_void_p
_UniFFILib.ffi_bdk_3ed8_DescriptorSecretKey_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_DescriptorSecretKey_object_free.restype = None
_UniFFILib.bdk_3ed8_DescriptorSecretKey_new.argtypes = (
    RustBuffer,
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_DescriptorSecretKey_new.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_DescriptorSecretKey_from_string.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_DescriptorSecretKey_from_string.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_DescriptorSecretKey_derive.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_DescriptorSecretKey_derive.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_DescriptorSecretKey_extend.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_DescriptorSecretKey_extend.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_DescriptorSecretKey_as_public.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_DescriptorSecretKey_as_public.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_DescriptorSecretKey_secret_bytes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_DescriptorSecretKey_secret_bytes.restype = RustBuffer
_UniFFILib.bdk_3ed8_DescriptorSecretKey_as_string.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_DescriptorSecretKey_as_string.restype = RustBuffer
_UniFFILib.ffi_bdk_3ed8_DescriptorPublicKey_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_DescriptorPublicKey_object_free.restype = None
_UniFFILib.bdk_3ed8_DescriptorPublicKey_from_string.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_DescriptorPublicKey_from_string.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_DescriptorPublicKey_derive.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_DescriptorPublicKey_derive.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_DescriptorPublicKey_extend.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_DescriptorPublicKey_extend.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_DescriptorPublicKey_as_string.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_DescriptorPublicKey_as_string.restype = RustBuffer
_UniFFILib.ffi_bdk_3ed8_Descriptor_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_Descriptor_object_free.restype = None
_UniFFILib.bdk_3ed8_Descriptor_new.argtypes = (
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Descriptor_new.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_Descriptor_new_bip44.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Descriptor_new_bip44.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_Descriptor_new_bip44_public.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Descriptor_new_bip44_public.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_Descriptor_new_bip49.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Descriptor_new_bip49.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_Descriptor_new_bip49_public.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Descriptor_new_bip49_public.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_Descriptor_new_bip84.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Descriptor_new_bip84.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_Descriptor_new_bip84_public.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Descriptor_new_bip84_public.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_Descriptor_as_string.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Descriptor_as_string.restype = RustBuffer
_UniFFILib.bdk_3ed8_Descriptor_as_string_private.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Descriptor_as_string_private.restype = RustBuffer
_UniFFILib.ffi_bdk_3ed8_Address_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_Address_object_free.restype = None
_UniFFILib.bdk_3ed8_Address_new.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Address_new.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_Address_from_script.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Address_from_script.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_Address_payload.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Address_payload.restype = RustBuffer
_UniFFILib.bdk_3ed8_Address_network.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Address_network.restype = RustBuffer
_UniFFILib.bdk_3ed8_Address_script_pubkey.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Address_script_pubkey.restype = ctypes.c_void_p
_UniFFILib.bdk_3ed8_Address_to_qr_uri.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Address_to_qr_uri.restype = RustBuffer
_UniFFILib.bdk_3ed8_Address_as_string.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Address_as_string.restype = RustBuffer
_UniFFILib.ffi_bdk_3ed8_Script_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_Script_object_free.restype = None
_UniFFILib.bdk_3ed8_Script_new.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_3ed8_Script_new.restype = ctypes.c_void_p
_UniFFILib.ffi_bdk_3ed8_Progress_init_callback.argtypes = (
    FOREIGN_CALLBACK_T,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_Progress_init_callback.restype = None
_UniFFILib.ffi_bdk_3ed8_rustbuffer_alloc.argtypes = (
    ctypes.c_int32,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_rustbuffer_alloc.restype = RustBuffer
_UniFFILib.ffi_bdk_3ed8_rustbuffer_from_bytes.argtypes = (
    ForeignBytes,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_rustbuffer_from_bytes.restype = RustBuffer
_UniFFILib.ffi_bdk_3ed8_rustbuffer_free.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_rustbuffer_free.restype = None
_UniFFILib.ffi_bdk_3ed8_rustbuffer_reserve.argtypes = (
    RustBuffer,
    ctypes.c_int32,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_3ed8_rustbuffer_reserve.restype = RustBuffer

# Public interface members begin here.


class FfiConverterUInt8(FfiConverterPrimitive):
    @staticmethod
    def read(buf):
        return buf.readU8()

    @staticmethod
    def write(value, buf):
        buf.writeU8(value)

class FfiConverterUInt32(FfiConverterPrimitive):
    @staticmethod
    def read(buf):
        return buf.readU32()

    @staticmethod
    def write(value, buf):
        buf.writeU32(value)

class FfiConverterInt32(FfiConverterPrimitive):
    @staticmethod
    def read(buf):
        return buf.readI32()

    @staticmethod
    def write(value, buf):
        buf.writeI32(value)

class FfiConverterUInt64(FfiConverterPrimitive):
    @staticmethod
    def read(buf):
        return buf.readU64()

    @staticmethod
    def write(value, buf):
        buf.writeU64(value)

class FfiConverterFloat(FfiConverterPrimitive):
    @staticmethod
    def read(buf):
        return buf.readFloat()

    @staticmethod
    def write(value, buf):
        buf.writeFloat(value)

class FfiConverterBool:
    @classmethod
    def read(cls, buf):
        return cls.lift(buf.readU8())

    @classmethod
    def write(cls, value, buf):
        buf.writeU8(cls.lower(value))

    @staticmethod
    def lift(value):
        return int(value) != 0

    @staticmethod
    def lower(value):
        return 1 if value else 0

class FfiConverterString:
    @staticmethod
    def read(buf):
        size = buf.readI32()
        if size < 0:
            raise InternalError("Unexpected negative string length")
        utf8Bytes = buf.read(size)
        return utf8Bytes.decode("utf-8")

    @staticmethod
    def write(value, buf):
        utf8Bytes = value.encode("utf-8")
        buf.writeI32(len(utf8Bytes))
        buf.write(utf8Bytes)

    @staticmethod
    def lift(buf):
        with buf.consumeWithStream() as stream:
            return stream.read(stream.remaining()).decode("utf-8")

    @staticmethod
    def lower(value):
        with RustBuffer.allocWithBuilder() as builder:
            builder.write(value.encode("utf-8"))
            return builder.finalize()



class Address(object):
    def __init__(self, address):
        address = address
        
        self._pointer = rust_call_with_error(FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Address_new,
        FfiConverterString.lower(address))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_3ed8_Address_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def from_script(cls, script,network):
        script = script
        
        network = network
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = rust_call_with_error(FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Address_from_script,
        FfiConverterTypeScript.lower(script),
        FfiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)
    

    def payload(self, ):
        return FfiConverterTypePayload.lift(
            rust_call(_UniFFILib.bdk_3ed8_Address_payload,self._pointer,)
        )
    def network(self, ):
        return FfiConverterTypeNetwork.lift(
            rust_call(_UniFFILib.bdk_3ed8_Address_network,self._pointer,)
        )
    def script_pubkey(self, ):
        return FfiConverterTypeScript.lift(
            rust_call(_UniFFILib.bdk_3ed8_Address_script_pubkey,self._pointer,)
        )
    def to_qr_uri(self, ):
        return FfiConverterString.lift(
            rust_call(_UniFFILib.bdk_3ed8_Address_to_qr_uri,self._pointer,)
        )
    def as_string(self, ):
        return FfiConverterString.lift(
            rust_call(_UniFFILib.bdk_3ed8_Address_as_string,self._pointer,)
        )
    


class FfiConverterTypeAddress:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Address):
            raise TypeError("Expected Address instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Address._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class Blockchain(object):
    def __init__(self, config):
        config = config
        
        self._pointer = rust_call_with_error(FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Blockchain_new,
        FfiConverterTypeBlockchainConfig.lower(config))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_3ed8_Blockchain_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    

    def broadcast(self, transaction):
        transaction = transaction
        
        rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Blockchain_broadcast,self._pointer,
        FfiConverterTypeTransaction.lower(transaction))
    
    def estimate_fee(self, target):
        target = int(target)
        
        return FfiConverterTypeFeeRate.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Blockchain_estimate_fee,self._pointer,
        FfiConverterUInt64.lower(target))
        )
    def get_height(self, ):
        return FfiConverterUInt32.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Blockchain_get_height,self._pointer,)
        )
    def get_block_hash(self, height):
        height = int(height)
        
        return FfiConverterString.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Blockchain_get_block_hash,self._pointer,
        FfiConverterUInt32.lower(height))
        )
    


class FfiConverterTypeBlockchain:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Blockchain):
            raise TypeError("Expected Blockchain instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Blockchain._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class BumpFeeTxBuilder(object):
    def __init__(self, txid,new_fee_rate):
        txid = txid
        
        new_fee_rate = float(new_fee_rate)
        
        self._pointer = rust_call(_UniFFILib.bdk_3ed8_BumpFeeTxBuilder_new,
        FfiConverterString.lower(txid),
        FfiConverterFloat.lower(new_fee_rate))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_3ed8_BumpFeeTxBuilder_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    

    def allow_shrinking(self, address):
        address = address
        
        return FfiConverterTypeBumpFeeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_BumpFeeTxBuilder_allow_shrinking,self._pointer,
        FfiConverterString.lower(address))
        )
    def enable_rbf(self, ):
        return FfiConverterTypeBumpFeeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_BumpFeeTxBuilder_enable_rbf,self._pointer,)
        )
    def enable_rbf_with_sequence(self, nsequence):
        nsequence = int(nsequence)
        
        return FfiConverterTypeBumpFeeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_BumpFeeTxBuilder_enable_rbf_with_sequence,self._pointer,
        FfiConverterUInt32.lower(nsequence))
        )
    def finish(self, wallet):
        wallet = wallet
        
        return FfiConverterTypePartiallySignedTransaction.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_BumpFeeTxBuilder_finish,self._pointer,
        FfiConverterTypeWallet.lower(wallet))
        )
    


class FfiConverterTypeBumpFeeTxBuilder:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, BumpFeeTxBuilder):
            raise TypeError("Expected BumpFeeTxBuilder instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return BumpFeeTxBuilder._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class DerivationPath(object):
    def __init__(self, path):
        path = path
        
        self._pointer = rust_call_with_error(FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_DerivationPath_new,
        FfiConverterString.lower(path))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_3ed8_DerivationPath_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    

    


class FfiConverterTypeDerivationPath:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, DerivationPath):
            raise TypeError("Expected DerivationPath instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return DerivationPath._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class Descriptor(object):
    def __init__(self, descriptor,network):
        descriptor = descriptor
        
        network = network
        
        self._pointer = rust_call_with_error(FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Descriptor_new,
        FfiConverterString.lower(descriptor),
        FfiConverterTypeNetwork.lower(network))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_3ed8_Descriptor_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def new_bip44(cls, secret_key,keychain,network):
        secret_key = secret_key
        
        keychain = keychain
        
        network = network
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = rust_call(_UniFFILib.bdk_3ed8_Descriptor_new_bip44,
        FfiConverterTypeDescriptorSecretKey.lower(secret_key),
        FfiConverterTypeKeychainKind.lower(keychain),
        FfiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)
    @classmethod
    def new_bip44_public(cls, public_key,fingerprint,keychain,network):
        public_key = public_key
        
        fingerprint = fingerprint
        
        keychain = keychain
        
        network = network
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = rust_call(_UniFFILib.bdk_3ed8_Descriptor_new_bip44_public,
        FfiConverterTypeDescriptorPublicKey.lower(public_key),
        FfiConverterString.lower(fingerprint),
        FfiConverterTypeKeychainKind.lower(keychain),
        FfiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)
    @classmethod
    def new_bip49(cls, secret_key,keychain,network):
        secret_key = secret_key
        
        keychain = keychain
        
        network = network
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = rust_call(_UniFFILib.bdk_3ed8_Descriptor_new_bip49,
        FfiConverterTypeDescriptorSecretKey.lower(secret_key),
        FfiConverterTypeKeychainKind.lower(keychain),
        FfiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)
    @classmethod
    def new_bip49_public(cls, public_key,fingerprint,keychain,network):
        public_key = public_key
        
        fingerprint = fingerprint
        
        keychain = keychain
        
        network = network
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = rust_call(_UniFFILib.bdk_3ed8_Descriptor_new_bip49_public,
        FfiConverterTypeDescriptorPublicKey.lower(public_key),
        FfiConverterString.lower(fingerprint),
        FfiConverterTypeKeychainKind.lower(keychain),
        FfiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)
    @classmethod
    def new_bip84(cls, secret_key,keychain,network):
        secret_key = secret_key
        
        keychain = keychain
        
        network = network
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = rust_call(_UniFFILib.bdk_3ed8_Descriptor_new_bip84,
        FfiConverterTypeDescriptorSecretKey.lower(secret_key),
        FfiConverterTypeKeychainKind.lower(keychain),
        FfiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)
    @classmethod
    def new_bip84_public(cls, public_key,fingerprint,keychain,network):
        public_key = public_key
        
        fingerprint = fingerprint
        
        keychain = keychain
        
        network = network
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = rust_call(_UniFFILib.bdk_3ed8_Descriptor_new_bip84_public,
        FfiConverterTypeDescriptorPublicKey.lower(public_key),
        FfiConverterString.lower(fingerprint),
        FfiConverterTypeKeychainKind.lower(keychain),
        FfiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)
    

    def as_string(self, ):
        return FfiConverterString.lift(
            rust_call(_UniFFILib.bdk_3ed8_Descriptor_as_string,self._pointer,)
        )
    def as_string_private(self, ):
        return FfiConverterString.lift(
            rust_call(_UniFFILib.bdk_3ed8_Descriptor_as_string_private,self._pointer,)
        )
    


class FfiConverterTypeDescriptor:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Descriptor):
            raise TypeError("Expected Descriptor instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Descriptor._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class DescriptorPublicKey(object):

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_3ed8_DescriptorPublicKey_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def from_string(cls, public_key):
        public_key = public_key
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = rust_call_with_error(FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_DescriptorPublicKey_from_string,
        FfiConverterString.lower(public_key))
        return cls._make_instance_(pointer)
    

    def derive(self, path):
        path = path
        
        return FfiConverterTypeDescriptorPublicKey.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_DescriptorPublicKey_derive,self._pointer,
        FfiConverterTypeDerivationPath.lower(path))
        )
    def extend(self, path):
        path = path
        
        return FfiConverterTypeDescriptorPublicKey.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_DescriptorPublicKey_extend,self._pointer,
        FfiConverterTypeDerivationPath.lower(path))
        )
    def as_string(self, ):
        return FfiConverterString.lift(
            rust_call(_UniFFILib.bdk_3ed8_DescriptorPublicKey_as_string,self._pointer,)
        )
    


class FfiConverterTypeDescriptorPublicKey:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, DescriptorPublicKey):
            raise TypeError("Expected DescriptorPublicKey instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return DescriptorPublicKey._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class DescriptorSecretKey(object):
    def __init__(self, network,mnemonic,password):
        network = network
        
        mnemonic = mnemonic
        
        password = (None if password is None else password)
        
        self._pointer = rust_call(_UniFFILib.bdk_3ed8_DescriptorSecretKey_new,
        FfiConverterTypeNetwork.lower(network),
        FfiConverterTypeMnemonic.lower(mnemonic),
        FfiConverterOptionalString.lower(password))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_3ed8_DescriptorSecretKey_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def from_string(cls, secret_key):
        secret_key = secret_key
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = rust_call_with_error(FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_DescriptorSecretKey_from_string,
        FfiConverterString.lower(secret_key))
        return cls._make_instance_(pointer)
    

    def derive(self, path):
        path = path
        
        return FfiConverterTypeDescriptorSecretKey.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_DescriptorSecretKey_derive,self._pointer,
        FfiConverterTypeDerivationPath.lower(path))
        )
    def extend(self, path):
        path = path
        
        return FfiConverterTypeDescriptorSecretKey.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_DescriptorSecretKey_extend,self._pointer,
        FfiConverterTypeDerivationPath.lower(path))
        )
    def as_public(self, ):
        return FfiConverterTypeDescriptorPublicKey.lift(
            rust_call(_UniFFILib.bdk_3ed8_DescriptorSecretKey_as_public,self._pointer,)
        )
    def secret_bytes(self, ):
        return FfiConverterSequenceUInt8.lift(
            rust_call(_UniFFILib.bdk_3ed8_DescriptorSecretKey_secret_bytes,self._pointer,)
        )
    def as_string(self, ):
        return FfiConverterString.lift(
            rust_call(_UniFFILib.bdk_3ed8_DescriptorSecretKey_as_string,self._pointer,)
        )
    


class FfiConverterTypeDescriptorSecretKey:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, DescriptorSecretKey):
            raise TypeError("Expected DescriptorSecretKey instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return DescriptorSecretKey._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class FeeRate(object):

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_3ed8_FeeRate_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def from_sat_per_vb(cls, sat_per_vb):
        sat_per_vb = float(sat_per_vb)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = rust_call(_UniFFILib.bdk_3ed8_FeeRate_from_sat_per_vb,
        FfiConverterFloat.lower(sat_per_vb))
        return cls._make_instance_(pointer)
    

    def as_sat_per_vb(self, ):
        return FfiConverterFloat.lift(
            rust_call(_UniFFILib.bdk_3ed8_FeeRate_as_sat_per_vb,self._pointer,)
        )
    


class FfiConverterTypeFeeRate:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, FeeRate):
            raise TypeError("Expected FeeRate instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return FeeRate._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class Mnemonic(object):
    def __init__(self, word_count):
        word_count = word_count
        
        self._pointer = rust_call(_UniFFILib.bdk_3ed8_Mnemonic_new,
        FfiConverterTypeWordCount.lower(word_count))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_3ed8_Mnemonic_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def from_string(cls, mnemonic):
        mnemonic = mnemonic
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = rust_call_with_error(FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Mnemonic_from_string,
        FfiConverterString.lower(mnemonic))
        return cls._make_instance_(pointer)
    @classmethod
    def from_entropy(cls, entropy):
        entropy = list(int(x) for x in entropy)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = rust_call_with_error(FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Mnemonic_from_entropy,
        FfiConverterSequenceUInt8.lower(entropy))
        return cls._make_instance_(pointer)
    

    def as_string(self, ):
        return FfiConverterString.lift(
            rust_call(_UniFFILib.bdk_3ed8_Mnemonic_as_string,self._pointer,)
        )
    


class FfiConverterTypeMnemonic:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Mnemonic):
            raise TypeError("Expected Mnemonic instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Mnemonic._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class PartiallySignedTransaction(object):
    def __init__(self, psbt_base64):
        psbt_base64 = psbt_base64
        
        self._pointer = rust_call_with_error(FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_PartiallySignedTransaction_new,
        FfiConverterString.lower(psbt_base64))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_3ed8_PartiallySignedTransaction_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    

    def serialize(self, ):
        return FfiConverterString.lift(
            rust_call(_UniFFILib.bdk_3ed8_PartiallySignedTransaction_serialize,self._pointer,)
        )
    def txid(self, ):
        return FfiConverterString.lift(
            rust_call(_UniFFILib.bdk_3ed8_PartiallySignedTransaction_txid,self._pointer,)
        )
    def extract_tx(self, ):
        return FfiConverterTypeTransaction.lift(
            rust_call(_UniFFILib.bdk_3ed8_PartiallySignedTransaction_extract_tx,self._pointer,)
        )
    def combine(self, other):
        other = other
        
        return FfiConverterTypePartiallySignedTransaction.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_PartiallySignedTransaction_combine,self._pointer,
        FfiConverterTypePartiallySignedTransaction.lower(other))
        )
    def fee_amount(self, ):
        return FfiConverterOptionalUInt64.lift(
            rust_call(_UniFFILib.bdk_3ed8_PartiallySignedTransaction_fee_amount,self._pointer,)
        )
    def fee_rate(self, ):
        return FfiConverterOptionalTypeFeeRate.lift(
            rust_call(_UniFFILib.bdk_3ed8_PartiallySignedTransaction_fee_rate,self._pointer,)
        )
    def json_serialize(self, ):
        return FfiConverterString.lift(
            rust_call(_UniFFILib.bdk_3ed8_PartiallySignedTransaction_json_serialize,self._pointer,)
        )
    


class FfiConverterTypePartiallySignedTransaction:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, PartiallySignedTransaction):
            raise TypeError("Expected PartiallySignedTransaction instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return PartiallySignedTransaction._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class Script(object):
    def __init__(self, raw_output_script):
        raw_output_script = list(int(x) for x in raw_output_script)
        
        self._pointer = rust_call(_UniFFILib.bdk_3ed8_Script_new,
        FfiConverterSequenceUInt8.lower(raw_output_script))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_3ed8_Script_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    

    


class FfiConverterTypeScript:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Script):
            raise TypeError("Expected Script instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Script._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class Transaction(object):
    def __init__(self, transaction_bytes):
        transaction_bytes = list(int(x) for x in transaction_bytes)
        
        self._pointer = rust_call_with_error(FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Transaction_new,
        FfiConverterSequenceUInt8.lower(transaction_bytes))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_3ed8_Transaction_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    

    def txid(self, ):
        return FfiConverterString.lift(
            rust_call(_UniFFILib.bdk_3ed8_Transaction_txid,self._pointer,)
        )
    def weight(self, ):
        return FfiConverterUInt64.lift(
            rust_call(_UniFFILib.bdk_3ed8_Transaction_weight,self._pointer,)
        )
    def size(self, ):
        return FfiConverterUInt64.lift(
            rust_call(_UniFFILib.bdk_3ed8_Transaction_size,self._pointer,)
        )
    def vsize(self, ):
        return FfiConverterUInt64.lift(
            rust_call(_UniFFILib.bdk_3ed8_Transaction_vsize,self._pointer,)
        )
    def serialize(self, ):
        return FfiConverterSequenceUInt8.lift(
            rust_call(_UniFFILib.bdk_3ed8_Transaction_serialize,self._pointer,)
        )
    def is_coin_base(self, ):
        return FfiConverterBool.lift(
            rust_call(_UniFFILib.bdk_3ed8_Transaction_is_coin_base,self._pointer,)
        )
    def is_explicitly_rbf(self, ):
        return FfiConverterBool.lift(
            rust_call(_UniFFILib.bdk_3ed8_Transaction_is_explicitly_rbf,self._pointer,)
        )
    def is_lock_time_enabled(self, ):
        return FfiConverterBool.lift(
            rust_call(_UniFFILib.bdk_3ed8_Transaction_is_lock_time_enabled,self._pointer,)
        )
    def version(self, ):
        return FfiConverterInt32.lift(
            rust_call(_UniFFILib.bdk_3ed8_Transaction_version,self._pointer,)
        )
    def lock_time(self, ):
        return FfiConverterUInt32.lift(
            rust_call(_UniFFILib.bdk_3ed8_Transaction_lock_time,self._pointer,)
        )
    def input(self, ):
        return FfiConverterSequenceTypeTxIn.lift(
            rust_call(_UniFFILib.bdk_3ed8_Transaction_input,self._pointer,)
        )
    def output(self, ):
        return FfiConverterSequenceTypeTxOut.lift(
            rust_call(_UniFFILib.bdk_3ed8_Transaction_output,self._pointer,)
        )
    


class FfiConverterTypeTransaction:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Transaction):
            raise TypeError("Expected Transaction instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Transaction._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class TxBuilder(object):
    def __init__(self, ):
        self._pointer = rust_call(_UniFFILib.bdk_3ed8_TxBuilder_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_3ed8_TxBuilder_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    

    def add_recipient(self, script,amount):
        script = script
        
        amount = int(amount)
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_TxBuilder_add_recipient,self._pointer,
        FfiConverterTypeScript.lower(script),
        FfiConverterUInt64.lower(amount))
        )
    def add_unspendable(self, unspendable):
        unspendable = unspendable
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_TxBuilder_add_unspendable,self._pointer,
        FfiConverterTypeOutPoint.lower(unspendable))
        )
    def add_utxo(self, outpoint):
        outpoint = outpoint
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_TxBuilder_add_utxo,self._pointer,
        FfiConverterTypeOutPoint.lower(outpoint))
        )
    def add_utxos(self, outpoints):
        outpoints = list(x for x in outpoints)
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_TxBuilder_add_utxos,self._pointer,
        FfiConverterSequenceTypeOutPoint.lower(outpoints))
        )
    def do_not_spend_change(self, ):
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_TxBuilder_do_not_spend_change,self._pointer,)
        )
    def manually_selected_only(self, ):
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_TxBuilder_manually_selected_only,self._pointer,)
        )
    def only_spend_change(self, ):
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_TxBuilder_only_spend_change,self._pointer,)
        )
    def unspendable(self, unspendable):
        unspendable = list(x for x in unspendable)
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_TxBuilder_unspendable,self._pointer,
        FfiConverterSequenceTypeOutPoint.lower(unspendable))
        )
    def fee_rate(self, sat_per_vbyte):
        sat_per_vbyte = float(sat_per_vbyte)
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_TxBuilder_fee_rate,self._pointer,
        FfiConverterFloat.lower(sat_per_vbyte))
        )
    def fee_absolute(self, fee_amount):
        fee_amount = int(fee_amount)
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_TxBuilder_fee_absolute,self._pointer,
        FfiConverterUInt64.lower(fee_amount))
        )
    def drain_wallet(self, ):
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_TxBuilder_drain_wallet,self._pointer,)
        )
    def drain_to(self, script):
        script = script
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_TxBuilder_drain_to,self._pointer,
        FfiConverterTypeScript.lower(script))
        )
    def enable_rbf(self, ):
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_TxBuilder_enable_rbf,self._pointer,)
        )
    def enable_rbf_with_sequence(self, nsequence):
        nsequence = int(nsequence)
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_TxBuilder_enable_rbf_with_sequence,self._pointer,
        FfiConverterUInt32.lower(nsequence))
        )
    def add_data(self, data):
        data = list(int(x) for x in data)
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_TxBuilder_add_data,self._pointer,
        FfiConverterSequenceUInt8.lower(data))
        )
    def set_recipients(self, recipients):
        recipients = list(x for x in recipients)
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_3ed8_TxBuilder_set_recipients,self._pointer,
        FfiConverterSequenceTypeScriptAmount.lower(recipients))
        )
    def finish(self, wallet):
        wallet = wallet
        
        return FfiConverterTypeTxBuilderResult.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_TxBuilder_finish,self._pointer,
        FfiConverterTypeWallet.lower(wallet))
        )
    


class FfiConverterTypeTxBuilder:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, TxBuilder):
            raise TypeError("Expected TxBuilder instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return TxBuilder._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class Wallet(object):
    def __init__(self, descriptor,change_descriptor,network,database_config):
        descriptor = descriptor
        
        change_descriptor = (None if change_descriptor is None else change_descriptor)
        
        network = network
        
        database_config = database_config
        
        self._pointer = rust_call_with_error(FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Wallet_new,
        FfiConverterTypeDescriptor.lower(descriptor),
        FfiConverterOptionalTypeDescriptor.lower(change_descriptor),
        FfiConverterTypeNetwork.lower(network),
        FfiConverterTypeDatabaseConfig.lower(database_config))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_3ed8_Wallet_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    

    def get_address(self, address_index):
        address_index = address_index
        
        return FfiConverterTypeAddressInfo.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Wallet_get_address,self._pointer,
        FfiConverterTypeAddressIndex.lower(address_index))
        )
    def get_internal_address(self, address_index):
        address_index = address_index
        
        return FfiConverterTypeAddressInfo.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Wallet_get_internal_address,self._pointer,
        FfiConverterTypeAddressIndex.lower(address_index))
        )
    def get_balance(self, ):
        return FfiConverterTypeBalance.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Wallet_get_balance,self._pointer,)
        )
    def sign(self, psbt,sign_options):
        psbt = psbt
        
        sign_options = (None if sign_options is None else sign_options)
        
        return FfiConverterBool.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Wallet_sign,self._pointer,
        FfiConverterTypePartiallySignedTransaction.lower(psbt),
        FfiConverterOptionalTypeSignOptions.lower(sign_options))
        )
    def list_transactions(self, include_raw):
        include_raw = bool(include_raw)
        
        return FfiConverterSequenceTypeTransactionDetails.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Wallet_list_transactions,self._pointer,
        FfiConverterBool.lower(include_raw))
        )
    def network(self, ):
        return FfiConverterTypeNetwork.lift(
            rust_call(_UniFFILib.bdk_3ed8_Wallet_network,self._pointer,)
        )
    def sync(self, blockchain,progress):
        blockchain = blockchain
        
        progress = (None if progress is None else progress)
        
        rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Wallet_sync,self._pointer,
        FfiConverterTypeBlockchain.lower(blockchain),
        FfiConverterOptionalCallbackInterfaceProgress.lower(progress))
    
    def list_unspent(self, ):
        return FfiConverterSequenceTypeLocalUtxo.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_3ed8_Wallet_list_unspent,self._pointer,)
        )
    


class FfiConverterTypeWallet:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Wallet):
            raise TypeError("Expected Wallet instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Wallet._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer


class AddressInfo:

    def __init__(self, index, address, keychain):
        self.index = index
        self.address = address
        self.keychain = keychain

    def __str__(self):
        return "AddressInfo(index={}, address={}, keychain={})".format(self.index, self.address, self.keychain)

    def __eq__(self, other):
        if self.index != other.index:
            return False
        if self.address != other.address:
            return False
        if self.keychain != other.keychain:
            return False
        return True

class FfiConverterTypeAddressInfo(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return AddressInfo(
            index=FfiConverterUInt32.read(buf),
            address=FfiConverterTypeAddress.read(buf),
            keychain=FfiConverterTypeKeychainKind.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterUInt32.write(value.index, buf)
        FfiConverterTypeAddress.write(value.address, buf)
        FfiConverterTypeKeychainKind.write(value.keychain, buf)


class Balance:

    def __init__(self, immature, trusted_pending, untrusted_pending, confirmed, spendable, total):
        self.immature = immature
        self.trusted_pending = trusted_pending
        self.untrusted_pending = untrusted_pending
        self.confirmed = confirmed
        self.spendable = spendable
        self.total = total

    def __str__(self):
        return "Balance(immature={}, trusted_pending={}, untrusted_pending={}, confirmed={}, spendable={}, total={})".format(self.immature, self.trusted_pending, self.untrusted_pending, self.confirmed, self.spendable, self.total)

    def __eq__(self, other):
        if self.immature != other.immature:
            return False
        if self.trusted_pending != other.trusted_pending:
            return False
        if self.untrusted_pending != other.untrusted_pending:
            return False
        if self.confirmed != other.confirmed:
            return False
        if self.spendable != other.spendable:
            return False
        if self.total != other.total:
            return False
        return True

class FfiConverterTypeBalance(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Balance(
            immature=FfiConverterUInt64.read(buf),
            trusted_pending=FfiConverterUInt64.read(buf),
            untrusted_pending=FfiConverterUInt64.read(buf),
            confirmed=FfiConverterUInt64.read(buf),
            spendable=FfiConverterUInt64.read(buf),
            total=FfiConverterUInt64.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterUInt64.write(value.immature, buf)
        FfiConverterUInt64.write(value.trusted_pending, buf)
        FfiConverterUInt64.write(value.untrusted_pending, buf)
        FfiConverterUInt64.write(value.confirmed, buf)
        FfiConverterUInt64.write(value.spendable, buf)
        FfiConverterUInt64.write(value.total, buf)


class BlockTime:

    def __init__(self, height, timestamp):
        self.height = height
        self.timestamp = timestamp

    def __str__(self):
        return "BlockTime(height={}, timestamp={})".format(self.height, self.timestamp)

    def __eq__(self, other):
        if self.height != other.height:
            return False
        if self.timestamp != other.timestamp:
            return False
        return True

class FfiConverterTypeBlockTime(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return BlockTime(
            height=FfiConverterUInt32.read(buf),
            timestamp=FfiConverterUInt64.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterUInt32.write(value.height, buf)
        FfiConverterUInt64.write(value.timestamp, buf)


class ElectrumConfig:

    def __init__(self, url, socks5, retry, timeout, stop_gap, validate_domain):
        self.url = url
        self.socks5 = socks5
        self.retry = retry
        self.timeout = timeout
        self.stop_gap = stop_gap
        self.validate_domain = validate_domain

    def __str__(self):
        return "ElectrumConfig(url={}, socks5={}, retry={}, timeout={}, stop_gap={}, validate_domain={})".format(self.url, self.socks5, self.retry, self.timeout, self.stop_gap, self.validate_domain)

    def __eq__(self, other):
        if self.url != other.url:
            return False
        if self.socks5 != other.socks5:
            return False
        if self.retry != other.retry:
            return False
        if self.timeout != other.timeout:
            return False
        if self.stop_gap != other.stop_gap:
            return False
        if self.validate_domain != other.validate_domain:
            return False
        return True

class FfiConverterTypeElectrumConfig(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ElectrumConfig(
            url=FfiConverterString.read(buf),
            socks5=FfiConverterOptionalString.read(buf),
            retry=FfiConverterUInt8.read(buf),
            timeout=FfiConverterOptionalUInt8.read(buf),
            stop_gap=FfiConverterUInt64.read(buf),
            validate_domain=FfiConverterBool.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterString.write(value.url, buf)
        FfiConverterOptionalString.write(value.socks5, buf)
        FfiConverterUInt8.write(value.retry, buf)
        FfiConverterOptionalUInt8.write(value.timeout, buf)
        FfiConverterUInt64.write(value.stop_gap, buf)
        FfiConverterBool.write(value.validate_domain, buf)


class EsploraConfig:

    def __init__(self, base_url, proxy, concurrency, stop_gap, timeout):
        self.base_url = base_url
        self.proxy = proxy
        self.concurrency = concurrency
        self.stop_gap = stop_gap
        self.timeout = timeout

    def __str__(self):
        return "EsploraConfig(base_url={}, proxy={}, concurrency={}, stop_gap={}, timeout={})".format(self.base_url, self.proxy, self.concurrency, self.stop_gap, self.timeout)

    def __eq__(self, other):
        if self.base_url != other.base_url:
            return False
        if self.proxy != other.proxy:
            return False
        if self.concurrency != other.concurrency:
            return False
        if self.stop_gap != other.stop_gap:
            return False
        if self.timeout != other.timeout:
            return False
        return True

class FfiConverterTypeEsploraConfig(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return EsploraConfig(
            base_url=FfiConverterString.read(buf),
            proxy=FfiConverterOptionalString.read(buf),
            concurrency=FfiConverterOptionalUInt8.read(buf),
            stop_gap=FfiConverterUInt64.read(buf),
            timeout=FfiConverterOptionalUInt64.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterString.write(value.base_url, buf)
        FfiConverterOptionalString.write(value.proxy, buf)
        FfiConverterOptionalUInt8.write(value.concurrency, buf)
        FfiConverterUInt64.write(value.stop_gap, buf)
        FfiConverterOptionalUInt64.write(value.timeout, buf)


class LocalUtxo:

    def __init__(self, outpoint, txout, keychain, is_spent):
        self.outpoint = outpoint
        self.txout = txout
        self.keychain = keychain
        self.is_spent = is_spent

    def __str__(self):
        return "LocalUtxo(outpoint={}, txout={}, keychain={}, is_spent={})".format(self.outpoint, self.txout, self.keychain, self.is_spent)

    def __eq__(self, other):
        if self.outpoint != other.outpoint:
            return False
        if self.txout != other.txout:
            return False
        if self.keychain != other.keychain:
            return False
        if self.is_spent != other.is_spent:
            return False
        return True

class FfiConverterTypeLocalUtxo(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LocalUtxo(
            outpoint=FfiConverterTypeOutPoint.read(buf),
            txout=FfiConverterTypeTxOut.read(buf),
            keychain=FfiConverterTypeKeychainKind.read(buf),
            is_spent=FfiConverterBool.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterTypeOutPoint.write(value.outpoint, buf)
        FfiConverterTypeTxOut.write(value.txout, buf)
        FfiConverterTypeKeychainKind.write(value.keychain, buf)
        FfiConverterBool.write(value.is_spent, buf)


class OutPoint:

    def __init__(self, txid, vout):
        self.txid = txid
        self.vout = vout

    def __str__(self):
        return "OutPoint(txid={}, vout={})".format(self.txid, self.vout)

    def __eq__(self, other):
        if self.txid != other.txid:
            return False
        if self.vout != other.vout:
            return False
        return True

class FfiConverterTypeOutPoint(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return OutPoint(
            txid=FfiConverterString.read(buf),
            vout=FfiConverterUInt32.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterString.write(value.txid, buf)
        FfiConverterUInt32.write(value.vout, buf)


class RpcConfig:

    def __init__(self, url, auth, network, wallet_name, sync_params):
        self.url = url
        self.auth = auth
        self.network = network
        self.wallet_name = wallet_name
        self.sync_params = sync_params

    def __str__(self):
        return "RpcConfig(url={}, auth={}, network={}, wallet_name={}, sync_params={})".format(self.url, self.auth, self.network, self.wallet_name, self.sync_params)

    def __eq__(self, other):
        if self.url != other.url:
            return False
        if self.auth != other.auth:
            return False
        if self.network != other.network:
            return False
        if self.wallet_name != other.wallet_name:
            return False
        if self.sync_params != other.sync_params:
            return False
        return True

class FfiConverterTypeRpcConfig(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return RpcConfig(
            url=FfiConverterString.read(buf),
            auth=FfiConverterTypeAuth.read(buf),
            network=FfiConverterTypeNetwork.read(buf),
            wallet_name=FfiConverterString.read(buf),
            sync_params=FfiConverterOptionalTypeRpcSyncParams.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterString.write(value.url, buf)
        FfiConverterTypeAuth.write(value.auth, buf)
        FfiConverterTypeNetwork.write(value.network, buf)
        FfiConverterString.write(value.wallet_name, buf)
        FfiConverterOptionalTypeRpcSyncParams.write(value.sync_params, buf)


class RpcSyncParams:

    def __init__(self, start_script_count, start_time, force_start_time, poll_rate_sec):
        self.start_script_count = start_script_count
        self.start_time = start_time
        self.force_start_time = force_start_time
        self.poll_rate_sec = poll_rate_sec

    def __str__(self):
        return "RpcSyncParams(start_script_count={}, start_time={}, force_start_time={}, poll_rate_sec={})".format(self.start_script_count, self.start_time, self.force_start_time, self.poll_rate_sec)

    def __eq__(self, other):
        if self.start_script_count != other.start_script_count:
            return False
        if self.start_time != other.start_time:
            return False
        if self.force_start_time != other.force_start_time:
            return False
        if self.poll_rate_sec != other.poll_rate_sec:
            return False
        return True

class FfiConverterTypeRpcSyncParams(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return RpcSyncParams(
            start_script_count=FfiConverterUInt64.read(buf),
            start_time=FfiConverterUInt64.read(buf),
            force_start_time=FfiConverterBool.read(buf),
            poll_rate_sec=FfiConverterUInt64.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterUInt64.write(value.start_script_count, buf)
        FfiConverterUInt64.write(value.start_time, buf)
        FfiConverterBool.write(value.force_start_time, buf)
        FfiConverterUInt64.write(value.poll_rate_sec, buf)


class ScriptAmount:

    def __init__(self, script, amount):
        self.script = script
        self.amount = amount

    def __str__(self):
        return "ScriptAmount(script={}, amount={})".format(self.script, self.amount)

    def __eq__(self, other):
        if self.script != other.script:
            return False
        if self.amount != other.amount:
            return False
        return True

class FfiConverterTypeScriptAmount(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ScriptAmount(
            script=FfiConverterTypeScript.read(buf),
            amount=FfiConverterUInt64.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterTypeScript.write(value.script, buf)
        FfiConverterUInt64.write(value.amount, buf)


class SignOptions:

    def __init__(self, trust_witness_utxo, assume_height, allow_all_sighashes, remove_partial_sigs, try_finalize, sign_with_tap_internal_key, allow_grinding):
        self.trust_witness_utxo = trust_witness_utxo
        self.assume_height = assume_height
        self.allow_all_sighashes = allow_all_sighashes
        self.remove_partial_sigs = remove_partial_sigs
        self.try_finalize = try_finalize
        self.sign_with_tap_internal_key = sign_with_tap_internal_key
        self.allow_grinding = allow_grinding

    def __str__(self):
        return "SignOptions(trust_witness_utxo={}, assume_height={}, allow_all_sighashes={}, remove_partial_sigs={}, try_finalize={}, sign_with_tap_internal_key={}, allow_grinding={})".format(self.trust_witness_utxo, self.assume_height, self.allow_all_sighashes, self.remove_partial_sigs, self.try_finalize, self.sign_with_tap_internal_key, self.allow_grinding)

    def __eq__(self, other):
        if self.trust_witness_utxo != other.trust_witness_utxo:
            return False
        if self.assume_height != other.assume_height:
            return False
        if self.allow_all_sighashes != other.allow_all_sighashes:
            return False
        if self.remove_partial_sigs != other.remove_partial_sigs:
            return False
        if self.try_finalize != other.try_finalize:
            return False
        if self.sign_with_tap_internal_key != other.sign_with_tap_internal_key:
            return False
        if self.allow_grinding != other.allow_grinding:
            return False
        return True

class FfiConverterTypeSignOptions(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SignOptions(
            trust_witness_utxo=FfiConverterBool.read(buf),
            assume_height=FfiConverterOptionalUInt32.read(buf),
            allow_all_sighashes=FfiConverterBool.read(buf),
            remove_partial_sigs=FfiConverterBool.read(buf),
            try_finalize=FfiConverterBool.read(buf),
            sign_with_tap_internal_key=FfiConverterBool.read(buf),
            allow_grinding=FfiConverterBool.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterBool.write(value.trust_witness_utxo, buf)
        FfiConverterOptionalUInt32.write(value.assume_height, buf)
        FfiConverterBool.write(value.allow_all_sighashes, buf)
        FfiConverterBool.write(value.remove_partial_sigs, buf)
        FfiConverterBool.write(value.try_finalize, buf)
        FfiConverterBool.write(value.sign_with_tap_internal_key, buf)
        FfiConverterBool.write(value.allow_grinding, buf)


class SledDbConfiguration:

    def __init__(self, path, tree_name):
        self.path = path
        self.tree_name = tree_name

    def __str__(self):
        return "SledDbConfiguration(path={}, tree_name={})".format(self.path, self.tree_name)

    def __eq__(self, other):
        if self.path != other.path:
            return False
        if self.tree_name != other.tree_name:
            return False
        return True

class FfiConverterTypeSledDbConfiguration(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SledDbConfiguration(
            path=FfiConverterString.read(buf),
            tree_name=FfiConverterString.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterString.write(value.path, buf)
        FfiConverterString.write(value.tree_name, buf)


class SqliteDbConfiguration:

    def __init__(self, path):
        self.path = path

    def __str__(self):
        return "SqliteDbConfiguration(path={})".format(self.path)

    def __eq__(self, other):
        if self.path != other.path:
            return False
        return True

class FfiConverterTypeSqliteDbConfiguration(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SqliteDbConfiguration(
            path=FfiConverterString.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterString.write(value.path, buf)


class TransactionDetails:

    def __init__(self, transaction, fee, received, sent, txid, confirmation_time):
        self.transaction = transaction
        self.fee = fee
        self.received = received
        self.sent = sent
        self.txid = txid
        self.confirmation_time = confirmation_time

    def __str__(self):
        return "TransactionDetails(transaction={}, fee={}, received={}, sent={}, txid={}, confirmation_time={})".format(self.transaction, self.fee, self.received, self.sent, self.txid, self.confirmation_time)

    def __eq__(self, other):
        if self.transaction != other.transaction:
            return False
        if self.fee != other.fee:
            return False
        if self.received != other.received:
            return False
        if self.sent != other.sent:
            return False
        if self.txid != other.txid:
            return False
        if self.confirmation_time != other.confirmation_time:
            return False
        return True

class FfiConverterTypeTransactionDetails(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return TransactionDetails(
            transaction=FfiConverterOptionalTypeTransaction.read(buf),
            fee=FfiConverterOptionalUInt64.read(buf),
            received=FfiConverterUInt64.read(buf),
            sent=FfiConverterUInt64.read(buf),
            txid=FfiConverterString.read(buf),
            confirmation_time=FfiConverterOptionalTypeBlockTime.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterOptionalTypeTransaction.write(value.transaction, buf)
        FfiConverterOptionalUInt64.write(value.fee, buf)
        FfiConverterUInt64.write(value.received, buf)
        FfiConverterUInt64.write(value.sent, buf)
        FfiConverterString.write(value.txid, buf)
        FfiConverterOptionalTypeBlockTime.write(value.confirmation_time, buf)


class TxBuilderResult:

    def __init__(self, psbt, transaction_details):
        self.psbt = psbt
        self.transaction_details = transaction_details

    def __str__(self):
        return "TxBuilderResult(psbt={}, transaction_details={})".format(self.psbt, self.transaction_details)

    def __eq__(self, other):
        if self.psbt != other.psbt:
            return False
        if self.transaction_details != other.transaction_details:
            return False
        return True

class FfiConverterTypeTxBuilderResult(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return TxBuilderResult(
            psbt=FfiConverterTypePartiallySignedTransaction.read(buf),
            transaction_details=FfiConverterTypeTransactionDetails.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterTypePartiallySignedTransaction.write(value.psbt, buf)
        FfiConverterTypeTransactionDetails.write(value.transaction_details, buf)


class TxIn:

    def __init__(self, previous_output, script_sig, sequence, witness):
        self.previous_output = previous_output
        self.script_sig = script_sig
        self.sequence = sequence
        self.witness = witness

    def __str__(self):
        return "TxIn(previous_output={}, script_sig={}, sequence={}, witness={})".format(self.previous_output, self.script_sig, self.sequence, self.witness)

    def __eq__(self, other):
        if self.previous_output != other.previous_output:
            return False
        if self.script_sig != other.script_sig:
            return False
        if self.sequence != other.sequence:
            return False
        if self.witness != other.witness:
            return False
        return True

class FfiConverterTypeTxIn(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return TxIn(
            previous_output=FfiConverterTypeOutPoint.read(buf),
            script_sig=FfiConverterTypeScript.read(buf),
            sequence=FfiConverterUInt32.read(buf),
            witness=FfiConverterSequenceSequenceUInt8.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterTypeOutPoint.write(value.previous_output, buf)
        FfiConverterTypeScript.write(value.script_sig, buf)
        FfiConverterUInt32.write(value.sequence, buf)
        FfiConverterSequenceSequenceUInt8.write(value.witness, buf)


class TxOut:

    def __init__(self, value, script_pubkey):
        self.value = value
        self.script_pubkey = script_pubkey

    def __str__(self):
        return "TxOut(value={}, script_pubkey={})".format(self.value, self.script_pubkey)

    def __eq__(self, other):
        if self.value != other.value:
            return False
        if self.script_pubkey != other.script_pubkey:
            return False
        return True

class FfiConverterTypeTxOut(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return TxOut(
            value=FfiConverterUInt64.read(buf),
            script_pubkey=FfiConverterTypeScript.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterUInt64.write(value.value, buf)
        FfiConverterTypeScript.write(value.script_pubkey, buf)




class AddressIndex:
    def __init__(self):
        raise RuntimeError("AddressIndex cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class NEW(object):
        def __init__(self,):
            
            pass
            

        def __str__(self):
            return "AddressIndex.NEW()".format()

        def __eq__(self, other):
            if not other.is_new():
                return False
            return True
    class LAST_UNUSED(object):
        def __init__(self,):
            
            pass
            

        def __str__(self):
            return "AddressIndex.LAST_UNUSED()".format()

        def __eq__(self, other):
            if not other.is_last_unused():
                return False
            return True
    class PEEK(object):
        def __init__(self,index):
            
            self.index = index
            

        def __str__(self):
            return "AddressIndex.PEEK(index={})".format(self.index)

        def __eq__(self, other):
            if not other.is_peek():
                return False
            if self.index != other.index:
                return False
            return True
    class RESET(object):
        def __init__(self,index):
            
            self.index = index
            

        def __str__(self):
            return "AddressIndex.RESET(index={})".format(self.index)

        def __eq__(self, other):
            if not other.is_reset():
                return False
            if self.index != other.index:
                return False
            return True
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_new(self):
        return isinstance(self, AddressIndex.NEW)
    def is_last_unused(self):
        return isinstance(self, AddressIndex.LAST_UNUSED)
    def is_peek(self):
        return isinstance(self, AddressIndex.PEEK)
    def is_reset(self):
        return isinstance(self, AddressIndex.RESET)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
AddressIndex.NEW = type("AddressIndex.NEW", (AddressIndex.NEW, AddressIndex,), {})
AddressIndex.LAST_UNUSED = type("AddressIndex.LAST_UNUSED", (AddressIndex.LAST_UNUSED, AddressIndex,), {})
AddressIndex.PEEK = type("AddressIndex.PEEK", (AddressIndex.PEEK, AddressIndex,), {})
AddressIndex.RESET = type("AddressIndex.RESET", (AddressIndex.RESET, AddressIndex,), {})




class FfiConverterTypeAddressIndex(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return AddressIndex.NEW(
            )
        if variant == 2:
            return AddressIndex.LAST_UNUSED(
            )
        if variant == 3:
            return AddressIndex.PEEK(
                FfiConverterUInt32.read(buf),
            )
        if variant == 4:
            return AddressIndex.RESET(
                FfiConverterUInt32.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value.is_new():
            buf.writeI32(1)
        if value.is_last_unused():
            buf.writeI32(2)
        if value.is_peek():
            buf.writeI32(3)
            FfiConverterUInt32.write(value.index, buf)
        if value.is_reset():
            buf.writeI32(4)
            FfiConverterUInt32.write(value.index, buf)




class Auth:
    def __init__(self):
        raise RuntimeError("Auth cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class NONE(object):
        def __init__(self,):
            
            pass
            

        def __str__(self):
            return "Auth.NONE()".format()

        def __eq__(self, other):
            if not other.is_none():
                return False
            return True
    class USER_PASS(object):
        def __init__(self,username, password):
            
            self.username = username
            self.password = password
            

        def __str__(self):
            return "Auth.USER_PASS(username={}, password={})".format(self.username, self.password)

        def __eq__(self, other):
            if not other.is_user_pass():
                return False
            if self.username != other.username:
                return False
            if self.password != other.password:
                return False
            return True
    class COOKIE(object):
        def __init__(self,file):
            
            self.file = file
            

        def __str__(self):
            return "Auth.COOKIE(file={})".format(self.file)

        def __eq__(self, other):
            if not other.is_cookie():
                return False
            if self.file != other.file:
                return False
            return True
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_none(self):
        return isinstance(self, Auth.NONE)
    def is_user_pass(self):
        return isinstance(self, Auth.USER_PASS)
    def is_cookie(self):
        return isinstance(self, Auth.COOKIE)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
Auth.NONE = type("Auth.NONE", (Auth.NONE, Auth,), {})
Auth.USER_PASS = type("Auth.USER_PASS", (Auth.USER_PASS, Auth,), {})
Auth.COOKIE = type("Auth.COOKIE", (Auth.COOKIE, Auth,), {})




class FfiConverterTypeAuth(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return Auth.NONE(
            )
        if variant == 2:
            return Auth.USER_PASS(
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
            )
        if variant == 3:
            return Auth.COOKIE(
                FfiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value.is_none():
            buf.writeI32(1)
        if value.is_user_pass():
            buf.writeI32(2)
            FfiConverterString.write(value.username, buf)
            FfiConverterString.write(value.password, buf)
        if value.is_cookie():
            buf.writeI32(3)
            FfiConverterString.write(value.file, buf)




class BlockchainConfig:
    def __init__(self):
        raise RuntimeError("BlockchainConfig cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class ELECTRUM(object):
        def __init__(self,config):
            
            self.config = config
            

        def __str__(self):
            return "BlockchainConfig.ELECTRUM(config={})".format(self.config)

        def __eq__(self, other):
            if not other.is_electrum():
                return False
            if self.config != other.config:
                return False
            return True
    class ESPLORA(object):
        def __init__(self,config):
            
            self.config = config
            

        def __str__(self):
            return "BlockchainConfig.ESPLORA(config={})".format(self.config)

        def __eq__(self, other):
            if not other.is_esplora():
                return False
            if self.config != other.config:
                return False
            return True
    class RPC(object):
        def __init__(self,config):
            
            self.config = config
            

        def __str__(self):
            return "BlockchainConfig.RPC(config={})".format(self.config)

        def __eq__(self, other):
            if not other.is_rpc():
                return False
            if self.config != other.config:
                return False
            return True
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_electrum(self):
        return isinstance(self, BlockchainConfig.ELECTRUM)
    def is_esplora(self):
        return isinstance(self, BlockchainConfig.ESPLORA)
    def is_rpc(self):
        return isinstance(self, BlockchainConfig.RPC)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
BlockchainConfig.ELECTRUM = type("BlockchainConfig.ELECTRUM", (BlockchainConfig.ELECTRUM, BlockchainConfig,), {})
BlockchainConfig.ESPLORA = type("BlockchainConfig.ESPLORA", (BlockchainConfig.ESPLORA, BlockchainConfig,), {})
BlockchainConfig.RPC = type("BlockchainConfig.RPC", (BlockchainConfig.RPC, BlockchainConfig,), {})




class FfiConverterTypeBlockchainConfig(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return BlockchainConfig.ELECTRUM(
                FfiConverterTypeElectrumConfig.read(buf),
            )
        if variant == 2:
            return BlockchainConfig.ESPLORA(
                FfiConverterTypeEsploraConfig.read(buf),
            )
        if variant == 3:
            return BlockchainConfig.RPC(
                FfiConverterTypeRpcConfig.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value.is_electrum():
            buf.writeI32(1)
            FfiConverterTypeElectrumConfig.write(value.config, buf)
        if value.is_esplora():
            buf.writeI32(2)
            FfiConverterTypeEsploraConfig.write(value.config, buf)
        if value.is_rpc():
            buf.writeI32(3)
            FfiConverterTypeRpcConfig.write(value.config, buf)




class DatabaseConfig:
    def __init__(self):
        raise RuntimeError("DatabaseConfig cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class MEMORY(object):
        def __init__(self,):
            
            pass
            

        def __str__(self):
            return "DatabaseConfig.MEMORY()".format()

        def __eq__(self, other):
            if not other.is_memory():
                return False
            return True
    class SLED(object):
        def __init__(self,config):
            
            self.config = config
            

        def __str__(self):
            return "DatabaseConfig.SLED(config={})".format(self.config)

        def __eq__(self, other):
            if not other.is_sled():
                return False
            if self.config != other.config:
                return False
            return True
    class SQLITE(object):
        def __init__(self,config):
            
            self.config = config
            

        def __str__(self):
            return "DatabaseConfig.SQLITE(config={})".format(self.config)

        def __eq__(self, other):
            if not other.is_sqlite():
                return False
            if self.config != other.config:
                return False
            return True
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_memory(self):
        return isinstance(self, DatabaseConfig.MEMORY)
    def is_sled(self):
        return isinstance(self, DatabaseConfig.SLED)
    def is_sqlite(self):
        return isinstance(self, DatabaseConfig.SQLITE)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
DatabaseConfig.MEMORY = type("DatabaseConfig.MEMORY", (DatabaseConfig.MEMORY, DatabaseConfig,), {})
DatabaseConfig.SLED = type("DatabaseConfig.SLED", (DatabaseConfig.SLED, DatabaseConfig,), {})
DatabaseConfig.SQLITE = type("DatabaseConfig.SQLITE", (DatabaseConfig.SQLITE, DatabaseConfig,), {})




class FfiConverterTypeDatabaseConfig(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return DatabaseConfig.MEMORY(
            )
        if variant == 2:
            return DatabaseConfig.SLED(
                FfiConverterTypeSledDbConfiguration.read(buf),
            )
        if variant == 3:
            return DatabaseConfig.SQLITE(
                FfiConverterTypeSqliteDbConfiguration.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value.is_memory():
            buf.writeI32(1)
        if value.is_sled():
            buf.writeI32(2)
            FfiConverterTypeSledDbConfiguration.write(value.config, buf)
        if value.is_sqlite():
            buf.writeI32(3)
            FfiConverterTypeSqliteDbConfiguration.write(value.config, buf)




class KeychainKind(enum.Enum):
    EXTERNAL = 1
    INTERNAL = 2
    


class FfiConverterTypeKeychainKind(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return KeychainKind.EXTERNAL
        if variant == 2:
            return KeychainKind.INTERNAL
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value == KeychainKind.EXTERNAL:
            buf.writeI32(1)
        if value == KeychainKind.INTERNAL:
            buf.writeI32(2)




class Network(enum.Enum):
    BITCOIN = 1
    TESTNET = 2
    SIGNET = 3
    REGTEST = 4
    


class FfiConverterTypeNetwork(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return Network.BITCOIN
        if variant == 2:
            return Network.TESTNET
        if variant == 3:
            return Network.SIGNET
        if variant == 4:
            return Network.REGTEST
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value == Network.BITCOIN:
            buf.writeI32(1)
        if value == Network.TESTNET:
            buf.writeI32(2)
        if value == Network.SIGNET:
            buf.writeI32(3)
        if value == Network.REGTEST:
            buf.writeI32(4)




class Payload:
    def __init__(self):
        raise RuntimeError("Payload cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class PUBKEY_HASH(object):
        def __init__(self,pubkey_hash):
            
            self.pubkey_hash = pubkey_hash
            

        def __str__(self):
            return "Payload.PUBKEY_HASH(pubkey_hash={})".format(self.pubkey_hash)

        def __eq__(self, other):
            if not other.is_pubkey_hash():
                return False
            if self.pubkey_hash != other.pubkey_hash:
                return False
            return True
    class SCRIPT_HASH(object):
        def __init__(self,script_hash):
            
            self.script_hash = script_hash
            

        def __str__(self):
            return "Payload.SCRIPT_HASH(script_hash={})".format(self.script_hash)

        def __eq__(self, other):
            if not other.is_script_hash():
                return False
            if self.script_hash != other.script_hash:
                return False
            return True
    class WITNESS_PROGRAM(object):
        def __init__(self,version, program):
            
            self.version = version
            self.program = program
            

        def __str__(self):
            return "Payload.WITNESS_PROGRAM(version={}, program={})".format(self.version, self.program)

        def __eq__(self, other):
            if not other.is_witness_program():
                return False
            if self.version != other.version:
                return False
            if self.program != other.program:
                return False
            return True
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_pubkey_hash(self):
        return isinstance(self, Payload.PUBKEY_HASH)
    def is_script_hash(self):
        return isinstance(self, Payload.SCRIPT_HASH)
    def is_witness_program(self):
        return isinstance(self, Payload.WITNESS_PROGRAM)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
Payload.PUBKEY_HASH = type("Payload.PUBKEY_HASH", (Payload.PUBKEY_HASH, Payload,), {})
Payload.SCRIPT_HASH = type("Payload.SCRIPT_HASH", (Payload.SCRIPT_HASH, Payload,), {})
Payload.WITNESS_PROGRAM = type("Payload.WITNESS_PROGRAM", (Payload.WITNESS_PROGRAM, Payload,), {})




class FfiConverterTypePayload(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return Payload.PUBKEY_HASH(
                FfiConverterSequenceUInt8.read(buf),
            )
        if variant == 2:
            return Payload.SCRIPT_HASH(
                FfiConverterSequenceUInt8.read(buf),
            )
        if variant == 3:
            return Payload.WITNESS_PROGRAM(
                FfiConverterTypeWitnessVersion.read(buf),
                FfiConverterSequenceUInt8.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value.is_pubkey_hash():
            buf.writeI32(1)
            FfiConverterSequenceUInt8.write(value.pubkey_hash, buf)
        if value.is_script_hash():
            buf.writeI32(2)
            FfiConverterSequenceUInt8.write(value.script_hash, buf)
        if value.is_witness_program():
            buf.writeI32(3)
            FfiConverterTypeWitnessVersion.write(value.version, buf)
            FfiConverterSequenceUInt8.write(value.program, buf)




class WitnessVersion(enum.Enum):
    V0 = 1
    V1 = 2
    V2 = 3
    V3 = 4
    V4 = 5
    V5 = 6
    V6 = 7
    V7 = 8
    V8 = 9
    V9 = 10
    V10 = 11
    V11 = 12
    V12 = 13
    V13 = 14
    V14 = 15
    V15 = 16
    V16 = 17
    


class FfiConverterTypeWitnessVersion(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return WitnessVersion.V0
        if variant == 2:
            return WitnessVersion.V1
        if variant == 3:
            return WitnessVersion.V2
        if variant == 4:
            return WitnessVersion.V3
        if variant == 5:
            return WitnessVersion.V4
        if variant == 6:
            return WitnessVersion.V5
        if variant == 7:
            return WitnessVersion.V6
        if variant == 8:
            return WitnessVersion.V7
        if variant == 9:
            return WitnessVersion.V8
        if variant == 10:
            return WitnessVersion.V9
        if variant == 11:
            return WitnessVersion.V10
        if variant == 12:
            return WitnessVersion.V11
        if variant == 13:
            return WitnessVersion.V12
        if variant == 14:
            return WitnessVersion.V13
        if variant == 15:
            return WitnessVersion.V14
        if variant == 16:
            return WitnessVersion.V15
        if variant == 17:
            return WitnessVersion.V16
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value == WitnessVersion.V0:
            buf.writeI32(1)
        if value == WitnessVersion.V1:
            buf.writeI32(2)
        if value == WitnessVersion.V2:
            buf.writeI32(3)
        if value == WitnessVersion.V3:
            buf.writeI32(4)
        if value == WitnessVersion.V4:
            buf.writeI32(5)
        if value == WitnessVersion.V5:
            buf.writeI32(6)
        if value == WitnessVersion.V6:
            buf.writeI32(7)
        if value == WitnessVersion.V7:
            buf.writeI32(8)
        if value == WitnessVersion.V8:
            buf.writeI32(9)
        if value == WitnessVersion.V9:
            buf.writeI32(10)
        if value == WitnessVersion.V10:
            buf.writeI32(11)
        if value == WitnessVersion.V11:
            buf.writeI32(12)
        if value == WitnessVersion.V12:
            buf.writeI32(13)
        if value == WitnessVersion.V13:
            buf.writeI32(14)
        if value == WitnessVersion.V14:
            buf.writeI32(15)
        if value == WitnessVersion.V15:
            buf.writeI32(16)
        if value == WitnessVersion.V16:
            buf.writeI32(17)




class WordCount(enum.Enum):
    WORDS12 = 1
    WORDS15 = 2
    WORDS18 = 3
    WORDS21 = 4
    WORDS24 = 5
    


class FfiConverterTypeWordCount(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return WordCount.WORDS12
        if variant == 2:
            return WordCount.WORDS15
        if variant == 3:
            return WordCount.WORDS18
        if variant == 4:
            return WordCount.WORDS21
        if variant == 5:
            return WordCount.WORDS24
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value == WordCount.WORDS12:
            buf.writeI32(1)
        if value == WordCount.WORDS15:
            buf.writeI32(2)
        if value == WordCount.WORDS18:
            buf.writeI32(3)
        if value == WordCount.WORDS21:
            buf.writeI32(4)
        if value == WordCount.WORDS24:
            buf.writeI32(5)



# BdkError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separated, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class UniFFIExceptionTmpNamespace:
    class BdkError(Exception):
        pass
    
    class InvalidU32Bytes(BdkError):
        def __str__(self):
            return "BdkError.InvalidU32Bytes({})".format(repr(super().__str__()))

    BdkError.InvalidU32Bytes = InvalidU32Bytes
    class Generic(BdkError):
        def __str__(self):
            return "BdkError.Generic({})".format(repr(super().__str__()))

    BdkError.Generic = Generic
    class MissingCachedScripts(BdkError):
        def __str__(self):
            return "BdkError.MissingCachedScripts({})".format(repr(super().__str__()))

    BdkError.MissingCachedScripts = MissingCachedScripts
    class ScriptDoesntHaveAddressForm(BdkError):
        def __str__(self):
            return "BdkError.ScriptDoesntHaveAddressForm({})".format(repr(super().__str__()))

    BdkError.ScriptDoesntHaveAddressForm = ScriptDoesntHaveAddressForm
    class NoRecipients(BdkError):
        def __str__(self):
            return "BdkError.NoRecipients({})".format(repr(super().__str__()))

    BdkError.NoRecipients = NoRecipients
    class NoUtxosSelected(BdkError):
        def __str__(self):
            return "BdkError.NoUtxosSelected({})".format(repr(super().__str__()))

    BdkError.NoUtxosSelected = NoUtxosSelected
    class OutputBelowDustLimit(BdkError):
        def __str__(self):
            return "BdkError.OutputBelowDustLimit({})".format(repr(super().__str__()))

    BdkError.OutputBelowDustLimit = OutputBelowDustLimit
    class InsufficientFunds(BdkError):
        def __str__(self):
            return "BdkError.InsufficientFunds({})".format(repr(super().__str__()))

    BdkError.InsufficientFunds = InsufficientFunds
    class BnBTotalTriesExceeded(BdkError):
        def __str__(self):
            return "BdkError.BnBTotalTriesExceeded({})".format(repr(super().__str__()))

    BdkError.BnBTotalTriesExceeded = BnBTotalTriesExceeded
    class BnBNoExactMatch(BdkError):
        def __str__(self):
            return "BdkError.BnBNoExactMatch({})".format(repr(super().__str__()))

    BdkError.BnBNoExactMatch = BnBNoExactMatch
    class UnknownUtxo(BdkError):
        def __str__(self):
            return "BdkError.UnknownUtxo({})".format(repr(super().__str__()))

    BdkError.UnknownUtxo = UnknownUtxo
    class TransactionNotFound(BdkError):
        def __str__(self):
            return "BdkError.TransactionNotFound({})".format(repr(super().__str__()))

    BdkError.TransactionNotFound = TransactionNotFound
    class TransactionConfirmed(BdkError):
        def __str__(self):
            return "BdkError.TransactionConfirmed({})".format(repr(super().__str__()))

    BdkError.TransactionConfirmed = TransactionConfirmed
    class IrreplaceableTransaction(BdkError):
        def __str__(self):
            return "BdkError.IrreplaceableTransaction({})".format(repr(super().__str__()))

    BdkError.IrreplaceableTransaction = IrreplaceableTransaction
    class FeeRateTooLow(BdkError):
        def __str__(self):
            return "BdkError.FeeRateTooLow({})".format(repr(super().__str__()))

    BdkError.FeeRateTooLow = FeeRateTooLow
    class FeeTooLow(BdkError):
        def __str__(self):
            return "BdkError.FeeTooLow({})".format(repr(super().__str__()))

    BdkError.FeeTooLow = FeeTooLow
    class FeeRateUnavailable(BdkError):
        def __str__(self):
            return "BdkError.FeeRateUnavailable({})".format(repr(super().__str__()))

    BdkError.FeeRateUnavailable = FeeRateUnavailable
    class MissingKeyOrigin(BdkError):
        def __str__(self):
            return "BdkError.MissingKeyOrigin({})".format(repr(super().__str__()))

    BdkError.MissingKeyOrigin = MissingKeyOrigin
    class Key(BdkError):
        def __str__(self):
            return "BdkError.Key({})".format(repr(super().__str__()))

    BdkError.Key = Key
    class ChecksumMismatch(BdkError):
        def __str__(self):
            return "BdkError.ChecksumMismatch({})".format(repr(super().__str__()))

    BdkError.ChecksumMismatch = ChecksumMismatch
    class SpendingPolicyRequired(BdkError):
        def __str__(self):
            return "BdkError.SpendingPolicyRequired({})".format(repr(super().__str__()))

    BdkError.SpendingPolicyRequired = SpendingPolicyRequired
    class InvalidPolicyPathError(BdkError):
        def __str__(self):
            return "BdkError.InvalidPolicyPathError({})".format(repr(super().__str__()))

    BdkError.InvalidPolicyPathError = InvalidPolicyPathError
    class Signer(BdkError):
        def __str__(self):
            return "BdkError.Signer({})".format(repr(super().__str__()))

    BdkError.Signer = Signer
    class InvalidNetwork(BdkError):
        def __str__(self):
            return "BdkError.InvalidNetwork({})".format(repr(super().__str__()))

    BdkError.InvalidNetwork = InvalidNetwork
    class InvalidProgressValue(BdkError):
        def __str__(self):
            return "BdkError.InvalidProgressValue({})".format(repr(super().__str__()))

    BdkError.InvalidProgressValue = InvalidProgressValue
    class ProgressUpdateError(BdkError):
        def __str__(self):
            return "BdkError.ProgressUpdateError({})".format(repr(super().__str__()))

    BdkError.ProgressUpdateError = ProgressUpdateError
    class InvalidOutpoint(BdkError):
        def __str__(self):
            return "BdkError.InvalidOutpoint({})".format(repr(super().__str__()))

    BdkError.InvalidOutpoint = InvalidOutpoint
    class Descriptor(BdkError):
        def __str__(self):
            return "BdkError.Descriptor({})".format(repr(super().__str__()))

    BdkError.Descriptor = Descriptor
    class Encode(BdkError):
        def __str__(self):
            return "BdkError.Encode({})".format(repr(super().__str__()))

    BdkError.Encode = Encode
    class Miniscript(BdkError):
        def __str__(self):
            return "BdkError.Miniscript({})".format(repr(super().__str__()))

    BdkError.Miniscript = Miniscript
    class MiniscriptPsbt(BdkError):
        def __str__(self):
            return "BdkError.MiniscriptPsbt({})".format(repr(super().__str__()))

    BdkError.MiniscriptPsbt = MiniscriptPsbt
    class Bip32(BdkError):
        def __str__(self):
            return "BdkError.Bip32({})".format(repr(super().__str__()))

    BdkError.Bip32 = Bip32
    class Secp256k1(BdkError):
        def __str__(self):
            return "BdkError.Secp256k1({})".format(repr(super().__str__()))

    BdkError.Secp256k1 = Secp256k1
    class Json(BdkError):
        def __str__(self):
            return "BdkError.Json({})".format(repr(super().__str__()))

    BdkError.Json = Json
    class Hex(BdkError):
        def __str__(self):
            return "BdkError.Hex({})".format(repr(super().__str__()))

    BdkError.Hex = Hex
    class Psbt(BdkError):
        def __str__(self):
            return "BdkError.Psbt({})".format(repr(super().__str__()))

    BdkError.Psbt = Psbt
    class PsbtParse(BdkError):
        def __str__(self):
            return "BdkError.PsbtParse({})".format(repr(super().__str__()))

    BdkError.PsbtParse = PsbtParse
    class Electrum(BdkError):
        def __str__(self):
            return "BdkError.Electrum({})".format(repr(super().__str__()))

    BdkError.Electrum = Electrum
    class Esplora(BdkError):
        def __str__(self):
            return "BdkError.Esplora({})".format(repr(super().__str__()))

    BdkError.Esplora = Esplora
    class Sled(BdkError):
        def __str__(self):
            return "BdkError.Sled({})".format(repr(super().__str__()))

    BdkError.Sled = Sled
    class Rusqlite(BdkError):
        def __str__(self):
            return "BdkError.Rusqlite({})".format(repr(super().__str__()))

    BdkError.Rusqlite = Rusqlite
    class Rpc(BdkError):
        def __str__(self):
            return "BdkError.Rpc({})".format(repr(super().__str__()))

    BdkError.Rpc = Rpc
BdkError = UniFFIExceptionTmpNamespace.BdkError
del UniFFIExceptionTmpNamespace


class FfiConverterTypeBdkError(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return BdkError.InvalidU32Bytes(
                FfiConverterString.read(buf),
            )
        if variant == 2:
            return BdkError.Generic(
                FfiConverterString.read(buf),
            )
        if variant == 3:
            return BdkError.MissingCachedScripts(
                FfiConverterString.read(buf),
            )
        if variant == 4:
            return BdkError.ScriptDoesntHaveAddressForm(
                FfiConverterString.read(buf),
            )
        if variant == 5:
            return BdkError.NoRecipients(
                FfiConverterString.read(buf),
            )
        if variant == 6:
            return BdkError.NoUtxosSelected(
                FfiConverterString.read(buf),
            )
        if variant == 7:
            return BdkError.OutputBelowDustLimit(
                FfiConverterString.read(buf),
            )
        if variant == 8:
            return BdkError.InsufficientFunds(
                FfiConverterString.read(buf),
            )
        if variant == 9:
            return BdkError.BnBTotalTriesExceeded(
                FfiConverterString.read(buf),
            )
        if variant == 10:
            return BdkError.BnBNoExactMatch(
                FfiConverterString.read(buf),
            )
        if variant == 11:
            return BdkError.UnknownUtxo(
                FfiConverterString.read(buf),
            )
        if variant == 12:
            return BdkError.TransactionNotFound(
                FfiConverterString.read(buf),
            )
        if variant == 13:
            return BdkError.TransactionConfirmed(
                FfiConverterString.read(buf),
            )
        if variant == 14:
            return BdkError.IrreplaceableTransaction(
                FfiConverterString.read(buf),
            )
        if variant == 15:
            return BdkError.FeeRateTooLow(
                FfiConverterString.read(buf),
            )
        if variant == 16:
            return BdkError.FeeTooLow(
                FfiConverterString.read(buf),
            )
        if variant == 17:
            return BdkError.FeeRateUnavailable(
                FfiConverterString.read(buf),
            )
        if variant == 18:
            return BdkError.MissingKeyOrigin(
                FfiConverterString.read(buf),
            )
        if variant == 19:
            return BdkError.Key(
                FfiConverterString.read(buf),
            )
        if variant == 20:
            return BdkError.ChecksumMismatch(
                FfiConverterString.read(buf),
            )
        if variant == 21:
            return BdkError.SpendingPolicyRequired(
                FfiConverterString.read(buf),
            )
        if variant == 22:
            return BdkError.InvalidPolicyPathError(
                FfiConverterString.read(buf),
            )
        if variant == 23:
            return BdkError.Signer(
                FfiConverterString.read(buf),
            )
        if variant == 24:
            return BdkError.InvalidNetwork(
                FfiConverterString.read(buf),
            )
        if variant == 25:
            return BdkError.InvalidProgressValue(
                FfiConverterString.read(buf),
            )
        if variant == 26:
            return BdkError.ProgressUpdateError(
                FfiConverterString.read(buf),
            )
        if variant == 27:
            return BdkError.InvalidOutpoint(
                FfiConverterString.read(buf),
            )
        if variant == 28:
            return BdkError.Descriptor(
                FfiConverterString.read(buf),
            )
        if variant == 29:
            return BdkError.Encode(
                FfiConverterString.read(buf),
            )
        if variant == 30:
            return BdkError.Miniscript(
                FfiConverterString.read(buf),
            )
        if variant == 31:
            return BdkError.MiniscriptPsbt(
                FfiConverterString.read(buf),
            )
        if variant == 32:
            return BdkError.Bip32(
                FfiConverterString.read(buf),
            )
        if variant == 33:
            return BdkError.Secp256k1(
                FfiConverterString.read(buf),
            )
        if variant == 34:
            return BdkError.Json(
                FfiConverterString.read(buf),
            )
        if variant == 35:
            return BdkError.Hex(
                FfiConverterString.read(buf),
            )
        if variant == 36:
            return BdkError.Psbt(
                FfiConverterString.read(buf),
            )
        if variant == 37:
            return BdkError.PsbtParse(
                FfiConverterString.read(buf),
            )
        if variant == 38:
            return BdkError.Electrum(
                FfiConverterString.read(buf),
            )
        if variant == 39:
            return BdkError.Esplora(
                FfiConverterString.read(buf),
            )
        if variant == 40:
            return BdkError.Sled(
                FfiConverterString.read(buf),
            )
        if variant == 41:
            return BdkError.Rusqlite(
                FfiConverterString.read(buf),
            )
        if variant == 42:
            return BdkError.Rpc(
                FfiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def write(value, buf):
        if isinstance(value, BdkError.InvalidU32Bytes):
            buf.writeI32(1)
        if isinstance(value, BdkError.Generic):
            buf.writeI32(2)
        if isinstance(value, BdkError.MissingCachedScripts):
            buf.writeI32(3)
        if isinstance(value, BdkError.ScriptDoesntHaveAddressForm):
            buf.writeI32(4)
        if isinstance(value, BdkError.NoRecipients):
            buf.writeI32(5)
        if isinstance(value, BdkError.NoUtxosSelected):
            buf.writeI32(6)
        if isinstance(value, BdkError.OutputBelowDustLimit):
            buf.writeI32(7)
        if isinstance(value, BdkError.InsufficientFunds):
            buf.writeI32(8)
        if isinstance(value, BdkError.BnBTotalTriesExceeded):
            buf.writeI32(9)
        if isinstance(value, BdkError.BnBNoExactMatch):
            buf.writeI32(10)
        if isinstance(value, BdkError.UnknownUtxo):
            buf.writeI32(11)
        if isinstance(value, BdkError.TransactionNotFound):
            buf.writeI32(12)
        if isinstance(value, BdkError.TransactionConfirmed):
            buf.writeI32(13)
        if isinstance(value, BdkError.IrreplaceableTransaction):
            buf.writeI32(14)
        if isinstance(value, BdkError.FeeRateTooLow):
            buf.writeI32(15)
        if isinstance(value, BdkError.FeeTooLow):
            buf.writeI32(16)
        if isinstance(value, BdkError.FeeRateUnavailable):
            buf.writeI32(17)
        if isinstance(value, BdkError.MissingKeyOrigin):
            buf.writeI32(18)
        if isinstance(value, BdkError.Key):
            buf.writeI32(19)
        if isinstance(value, BdkError.ChecksumMismatch):
            buf.writeI32(20)
        if isinstance(value, BdkError.SpendingPolicyRequired):
            buf.writeI32(21)
        if isinstance(value, BdkError.InvalidPolicyPathError):
            buf.writeI32(22)
        if isinstance(value, BdkError.Signer):
            buf.writeI32(23)
        if isinstance(value, BdkError.InvalidNetwork):
            buf.writeI32(24)
        if isinstance(value, BdkError.InvalidProgressValue):
            buf.writeI32(25)
        if isinstance(value, BdkError.ProgressUpdateError):
            buf.writeI32(26)
        if isinstance(value, BdkError.InvalidOutpoint):
            buf.writeI32(27)
        if isinstance(value, BdkError.Descriptor):
            buf.writeI32(28)
        if isinstance(value, BdkError.Encode):
            buf.writeI32(29)
        if isinstance(value, BdkError.Miniscript):
            buf.writeI32(30)
        if isinstance(value, BdkError.MiniscriptPsbt):
            buf.writeI32(31)
        if isinstance(value, BdkError.Bip32):
            buf.writeI32(32)
        if isinstance(value, BdkError.Secp256k1):
            buf.writeI32(33)
        if isinstance(value, BdkError.Json):
            buf.writeI32(34)
        if isinstance(value, BdkError.Hex):
            buf.writeI32(35)
        if isinstance(value, BdkError.Psbt):
            buf.writeI32(36)
        if isinstance(value, BdkError.PsbtParse):
            buf.writeI32(37)
        if isinstance(value, BdkError.Electrum):
            buf.writeI32(38)
        if isinstance(value, BdkError.Esplora):
            buf.writeI32(39)
        if isinstance(value, BdkError.Sled):
            buf.writeI32(40)
        if isinstance(value, BdkError.Rusqlite):
            buf.writeI32(41)
        if isinstance(value, BdkError.Rpc):
            buf.writeI32(42)



import threading

class ConcurrentHandleMap:
    """
    A map where inserting, getting and removing data is synchronized with a lock.
    """

    def __init__(self):
        # type Handle = int
        self._left_map = {}  # type: Dict[Handle, Any]
        self._right_map = {}  # type: Dict[Any, Handle]

        self._lock = threading.Lock()
        self._current_handle = 0
        self._stride = 1


    def insert(self, obj):
        with self._lock:
            if obj in self._right_map:
                return self._right_map[obj]
            else:
                handle = self._current_handle
                self._current_handle += self._stride
                self._left_map[handle] = obj
                self._right_map[obj] = handle
                return handle

    def get(self, handle):
        with self._lock:
            return self._left_map.get(handle)

    def remove(self, handle):
        with self._lock:
            if handle in self._left_map:
                obj = self._left_map.pop(handle)
                del self._right_map[obj]
                return obj

# Magic number for the Rust proxy to call using the same mechanism as every other method,
# to free the callback once it's dropped by Rust.
IDX_CALLBACK_FREE = 0

class FfiConverterCallbackInterface:
    _handle_map = ConcurrentHandleMap()

    def __init__(self, cb):
        self._foreign_callback = cb

    def drop(self, handle):
        self.__class__._handle_map.remove(handle)

    @classmethod
    def lift(cls, handle):
        obj = cls._handle_map.get(handle)
        if not obj:
            raise InternalError("The object in the handle map has been dropped already")

        return obj

    @classmethod
    def read(cls, buf):
        handle = buf.readU64()
        cls.lift(handle)

    @classmethod
    def lower(cls, cb):
        handle = cls._handle_map.insert(cb)
        return handle

    @classmethod
    def write(cls, cb, buf):
        buf.writeU64(cls.lower(cb))

# Declaration and FfiConverters for Progress Callback Interface

class Progress:
    def update(progress,message):
        raise NotImplementedError

    

def py_foreignCallbackCallbackInterfaceProgress(handle, method, args, buf_ptr):
    
    def invoke_update(python_callback, args):
        with args.consumeWithStream() as buf:
            rval = python_callback.update(
                FfiConverterFloat.read(buf), 
                FfiConverterOptionalString.read(buf)
                )
        return RustBuffer.alloc(0)
        

    cb = FfiConverterCallbackInterfaceProgress.lift(handle)
    if not cb:
        raise InternalError("No callback in handlemap; this is a Uniffi bug")

    if method == IDX_CALLBACK_FREE:
        FfiConverterCallbackInterfaceProgress.drop(handle)
        # No return value.
        # See docs of ForeignCallback in `uniffi/src/ffi/foreigncallbacks.rs`
        return 0

    if method == 1:
        # Call the method and handle any errors
        # See docs of ForeignCallback in `uniffi/src/ffi/foreigncallbacks.rs` for details
        try:
            # Successful return
            buf_ptr[0] = invoke_update(cb, args)
            return 1
        except BaseException as e:
            # Catch unexpected errors
            try:
                # Try to serialize the exception into a String
                buf_ptr[0] = FfiConverterString.lower(repr(e))
            except:
                # If that fails, just give up
                pass
            return -1
    

    # This should never happen, because an out of bounds method index won't
    # ever be used. Once we can catch errors, we should return an InternalException.
    # https://github.com/mozilla/uniffi-rs/issues/351

    # An unexpected error happened.
    # See docs of ForeignCallback in `uniffi/src/ffi/foreigncallbacks.rs`
    return -1

# We need to keep this function reference alive:
# if they get GC'd while in use then UniFFI internals could attempt to call a function
# that is in freed memory.
# That would be...uh...bad. Yeah, that's the word. Bad.
foreignCallbackCallbackInterfaceProgress = FOREIGN_CALLBACK_T(py_foreignCallbackCallbackInterfaceProgress)

# The FfiConverter which transforms the Callbacks in to Handles to pass to Rust.
rust_call(lambda err: _UniFFILib.ffi_bdk_3ed8_Progress_init_callback(foreignCallbackCallbackInterfaceProgress, err))
FfiConverterCallbackInterfaceProgress = FfiConverterCallbackInterface(foreignCallbackCallbackInterfaceProgress)



class FfiConverterOptionalUInt8(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterUInt8.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterUInt8.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterOptionalUInt32(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterUInt32.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterUInt32.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterOptionalUInt64(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterUInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterUInt64.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterOptionalString(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterString.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterString.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterOptionalTypeDescriptor(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterTypeDescriptor.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterTypeDescriptor.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterOptionalTypeFeeRate(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterTypeFeeRate.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterTypeFeeRate.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterOptionalTypeTransaction(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterTypeTransaction.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterTypeTransaction.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterOptionalTypeBlockTime(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterTypeBlockTime.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterTypeBlockTime.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterOptionalTypeRpcSyncParams(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterTypeRpcSyncParams.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterTypeRpcSyncParams.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterOptionalTypeSignOptions(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterTypeSignOptions.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterTypeSignOptions.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterOptionalCallbackInterfaceProgress(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterCallbackInterfaceProgress.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterCallbackInterfaceProgress.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterSequenceUInt8(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.writeI32(items)
        for item in value:
            FfiConverterUInt8.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.readI32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            FfiConverterUInt8.read(buf) for i in range(count)
        ]



class FfiConverterSequenceTypeLocalUtxo(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.writeI32(items)
        for item in value:
            FfiConverterTypeLocalUtxo.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.readI32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            FfiConverterTypeLocalUtxo.read(buf) for i in range(count)
        ]



class FfiConverterSequenceTypeOutPoint(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.writeI32(items)
        for item in value:
            FfiConverterTypeOutPoint.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.readI32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            FfiConverterTypeOutPoint.read(buf) for i in range(count)
        ]



class FfiConverterSequenceTypeScriptAmount(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.writeI32(items)
        for item in value:
            FfiConverterTypeScriptAmount.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.readI32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            FfiConverterTypeScriptAmount.read(buf) for i in range(count)
        ]



class FfiConverterSequenceTypeTransactionDetails(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.writeI32(items)
        for item in value:
            FfiConverterTypeTransactionDetails.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.readI32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            FfiConverterTypeTransactionDetails.read(buf) for i in range(count)
        ]



class FfiConverterSequenceTypeTxIn(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.writeI32(items)
        for item in value:
            FfiConverterTypeTxIn.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.readI32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            FfiConverterTypeTxIn.read(buf) for i in range(count)
        ]



class FfiConverterSequenceTypeTxOut(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.writeI32(items)
        for item in value:
            FfiConverterTypeTxOut.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.readI32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            FfiConverterTypeTxOut.read(buf) for i in range(count)
        ]



class FfiConverterSequenceSequenceUInt8(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.writeI32(items)
        for item in value:
            FfiConverterSequenceUInt8.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.readI32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            FfiConverterSequenceUInt8.read(buf) for i in range(count)
        ]

__all__ = [
    "InternalError",
    "AddressIndex",
    "Auth",
    "BlockchainConfig",
    "DatabaseConfig",
    "KeychainKind",
    "Network",
    "Payload",
    "WitnessVersion",
    "WordCount",
    "AddressInfo",
    "Balance",
    "BlockTime",
    "ElectrumConfig",
    "EsploraConfig",
    "LocalUtxo",
    "OutPoint",
    "RpcConfig",
    "RpcSyncParams",
    "ScriptAmount",
    "SignOptions",
    "SledDbConfiguration",
    "SqliteDbConfiguration",
    "TransactionDetails",
    "TxBuilderResult",
    "TxIn",
    "TxOut",
    "Blockchain",
    "Wallet",
    "FeeRate",
    "Transaction",
    "PartiallySignedTransaction",
    "TxBuilder",
    "BumpFeeTxBuilder",
    "Mnemonic",
    "DerivationPath",
    "DescriptorSecretKey",
    "DescriptorPublicKey",
    "Descriptor",
    "Address",
    "Script",
    "BdkError",
    "Progress",
]

