# This file was autogenerated by some hot garbage in the `uniffi` crate.
# Trust me, you don't want to mess with it!

# Tell mypy (a type checker) to ignore all errors from this file.
# See https://mypy.readthedocs.io/en/stable/config_file.html?highlight=ignore-errors#confval-ignore_errors
# mypy: ignore-errors

# Common helper code.
#
# Ideally this would live in a separate .py file where it can be unittested etc
# in isolation, and perhaps even published as a re-useable package.
#
# However, it's important that the details of how this helper code works (e.g. the
# way that different builtin types are passed across the FFI) exactly match what's
# expected by the rust code on the other side of the interface. In practice right
# now that means coming from the exact some version of `uniffi` that was used to
# compile the rust component. The easiest way to ensure this is to bundle the Python
# helpers directly inline like we're doing here.

import os
import sys
import ctypes
import enum
import struct
import contextlib
import datetime

# Used for default argument values
DEFAULT = object()


class RustBuffer(ctypes.Structure):
    _fields_ = [
        ("capacity", ctypes.c_int32),
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    @staticmethod
    def alloc(size):
        return rust_call(_UniFFILib.ffi_bdk_8bed_rustbuffer_alloc, size)

    @staticmethod
    def reserve(rbuf, additional):
        return rust_call(_UniFFILib.ffi_bdk_8bed_rustbuffer_reserve, rbuf, additional)

    def free(self):
        return rust_call(_UniFFILib.ffi_bdk_8bed_rustbuffer_free, self)

    def __str__(self):
        return "RustBuffer(capacity={}, len={}, data={})".format(
            self.capacity,
            self.len,
            self.data[0:self.len]
        )

    @contextlib.contextmanager
    def allocWithBuilder():
        """Context-manger to allocate a buffer using a RustBufferBuilder.

        The allocated buffer will be automatically freed if an error occurs, ensuring that
        we don't accidentally leak it.
        """
        builder = RustBufferBuilder()
        try:
            yield builder
        except:
            builder.discard()
            raise

    @contextlib.contextmanager
    def consumeWithStream(self):
        """Context-manager to consume a buffer using a RustBufferStream.

        The RustBuffer will be freed once the context-manager exits, ensuring that we don't
        leak it even if an error occurs.
        """
        try:
            s = RustBufferStream(self)
            yield s
            if s.remaining() != 0:
                raise RuntimeError("junk data left in buffer after consuming")
        finally:
            self.free()


class ForeignBytes(ctypes.Structure):
    _fields_ = [
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    def __str__(self):
        return "ForeignBytes(len={}, data={})".format(self.len, self.data[0:self.len])


class RustBufferStream(object):
    """
    Helper for structured reading of bytes from a RustBuffer
    """

    def __init__(self, rbuf):
        self.rbuf = rbuf
        self.offset = 0

    def remaining(self):
        return self.rbuf.len - self.offset

    def _unpack_from(self, size, format):
        if self.offset + size > self.rbuf.len:
            raise InternalError("read past end of rust buffer")
        value = struct.unpack(format, self.rbuf.data[self.offset:self.offset+size])[0]
        self.offset += size
        return value

    def read(self, size):
        if self.offset + size > self.rbuf.len:
            raise InternalError("read past end of rust buffer")
        data = self.rbuf.data[self.offset:self.offset+size]
        self.offset += size
        return data

    def readI8(self):
        return self._unpack_from(1, ">b")

    def readU8(self):
        return self._unpack_from(1, ">B")

    def readI16(self):
        return self._unpack_from(2, ">h")

    def readU16(self):
        return self._unpack_from(2, ">H")

    def readI32(self):
        return self._unpack_from(4, ">i")

    def readU32(self):
        return self._unpack_from(4, ">I")

    def readI64(self):
        return self._unpack_from(8, ">q")

    def readU64(self):
        return self._unpack_from(8, ">Q")

    def readFloat(self):
        v = self._unpack_from(4, ">f")
        return v

    def readDouble(self):
        return self._unpack_from(8, ">d")


class RustBufferBuilder(object):
    """
    Helper for structured writing of bytes into a RustBuffer.
    """

    def __init__(self):
        self.rbuf = RustBuffer.alloc(16)
        self.rbuf.len = 0

    def finalize(self):
        rbuf = self.rbuf
        self.rbuf = None
        return rbuf

    def discard(self):
        if self.rbuf is not None:
            rbuf = self.finalize()
            rbuf.free()

    @contextlib.contextmanager
    def _reserve(self, numBytes):
        if self.rbuf.len + numBytes > self.rbuf.capacity:
            self.rbuf = RustBuffer.reserve(self.rbuf, numBytes)
        yield None
        self.rbuf.len += numBytes

    def _pack_into(self, size, format, value):
        with self._reserve(size):
            # XXX TODO: I feel like I should be able to use `struct.pack_into` here but can't figure it out.
            for i, byte in enumerate(struct.pack(format, value)):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write(self, value):
        with self._reserve(len(value)):
            for i, byte in enumerate(value):
                self.rbuf.data[self.rbuf.len + i] = byte

    def writeI8(self, v):
        self._pack_into(1, ">b", v)

    def writeU8(self, v):
        self._pack_into(1, ">B", v)

    def writeI16(self, v):
        self._pack_into(2, ">h", v)

    def writeU16(self, v):
        self._pack_into(2, ">H", v)

    def writeI32(self, v):
        self._pack_into(4, ">i", v)

    def writeU32(self, v):
        self._pack_into(4, ">I", v)

    def writeI64(self, v):
        self._pack_into(8, ">q", v)

    def writeU64(self, v):
        self._pack_into(8, ">Q", v)

    def writeFloat(self, v):
        self._pack_into(4, ">f", v)

    def writeDouble(self, v):
        self._pack_into(8, ">d", v)
# A handful of classes and functions to support the generated data structures.
# This would be a good candidate for isolating in its own ffi-support lib.

class InternalError(Exception):
    pass

class RustCallStatus(ctypes.Structure):
    """
    Error runtime.
    """
    _fields_ = [
        ("code", ctypes.c_int8),
        ("error_buf", RustBuffer),
    ]

    # These match the values from the uniffi::rustcalls module
    CALL_SUCCESS = 0
    CALL_ERROR = 1
    CALL_PANIC = 2

    def __str__(self):
        if self.code == RustCallStatus.CALL_SUCCESS:
            return "RustCallStatus(CALL_SUCCESS)"
        elif self.code == RustCallStatus.CALL_ERROR:
            return "RustCallStatus(CALL_ERROR)"
        elif self.code == RustCallStatus.CALL_PANIC:
            return "RustCallStatus(CALL_PANIC)"
        else:
            return "RustCallStatus(<invalid code>)"

def rust_call(fn, *args):
    # Call a rust function
    return rust_call_with_error(None, fn, *args)

def rust_call_with_error(error_ffi_converter, fn, *args):
    # Call a rust function and handle any errors
    #
    # This function is used for rust calls that return Result<> and therefore can set the CALL_ERROR status code.
    # error_ffi_converter must be set to the FFIConverter for the error class that corresponds to the result.
    call_status = RustCallStatus(code=RustCallStatus.CALL_SUCCESS, error_buf=RustBuffer(0, 0, None))

    args_with_error = args + (ctypes.byref(call_status),)
    result = fn(*args_with_error)
    if call_status.code == RustCallStatus.CALL_SUCCESS:
        return result
    elif call_status.code == RustCallStatus.CALL_ERROR:
        if error_ffi_converter is None:
            call_status.err_buf.contents.free()
            raise InternalError("rust_call_with_error: CALL_ERROR, but error_ffi_converter is None")
        else:
            raise error_ffi_converter.lift(call_status.error_buf)
    elif call_status.code == RustCallStatus.CALL_PANIC:
        # When the rust code sees a panic, it tries to construct a RustBuffer
        # with the message.  But if that code panics, then it just sends back
        # an empty buffer.
        if call_status.error_buf.len > 0:
            msg = FfiConverterString.lift(call_status.error_buf)
        else:
            msg = "Unknown rust panic"
        raise InternalError(msg)
    else:
        raise InternalError("Invalid RustCallStatus code: {}".format(
            call_status.code))

# A function pointer for a callback as defined by UniFFI.
# Rust definition `fn(handle: u64, method: u32, args: RustBuffer, buf_ptr: *mut RustBuffer) -> int`
FOREIGN_CALLBACK_T = ctypes.CFUNCTYPE(ctypes.c_int, ctypes.c_ulonglong, ctypes.c_ulong, RustBuffer, ctypes.POINTER(RustBuffer))
# Types conforming to `FfiConverterPrimitive` pass themselves directly over the FFI.
class FfiConverterPrimitive:
    @classmethod
    def lift(cls, value):
        return value

    @classmethod
    def lower(cls, value):
        return value

# Helper class for wrapper types that will always go through a RustBuffer.
# Classes should inherit from this and implement the `read` and `write` static methods.
class FfiConverterRustBuffer:
    @classmethod
    def lift(cls, rbuf):
        with rbuf.consumeWithStream() as stream:
            return cls.read(stream)

    @classmethod
    def lower(cls, value):
        with RustBuffer.allocWithBuilder() as builder:
            cls.write(value, builder)
            return builder.finalize()

# Contains loading, initialization code,
# and the FFI Function declarations in a com.sun.jna.Library.
# This is how we find and load the dynamic library provided by the component.
# For now we just look it up by name.
#
# XXX TODO: This will probably grow some magic for resolving megazording in future.
# E.g. we might start by looking for the named component in `libuniffi.so` and if
# that fails, fall back to loading it separately from `lib${componentName}.so`.

from pathlib import Path


def loadIndirect():
    import glob
    return getattr(ctypes.cdll, glob.glob(os.path.join(os.path.dirname(os.path.abspath(__file__)), 'bdkffi.*'))[0])

def _loadIndirectOld():
    if sys.platform == "darwin":
        libname = "lib{}.dylib"
    elif sys.platform.startswith("win"):
        # As of python3.8, ctypes does not seem to search $PATH when loading DLLs.
        # We could use `os.add_dll_directory` to configure the search path, but
        # it doesn't feel right to mess with application-wide settings. Let's
        # assume that the `.dll` is next to the `.py` file and load by full path.
        libname = os.path.join(
            os.path.dirname(__file__),
            "{}.dll",
        )
    else:
        # Anything else must be an ELF platform - Linux, *BSD, Solaris/illumos
        libname = "lib{}.so"

    lib = libname.format("bdkffi")
    path = str(Path(__file__).parent / lib)
    return ctypes.cdll.LoadLibrary(path)

# A ctypes library to expose the extern-C FFI definitions.
# This is an implementation detail which will be called internally by the public API.

_UniFFILib = loadIndirect()
_UniFFILib.ffi_bdk_8bed_Blockchain_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_8bed_Blockchain_object_free.restype = None
_UniFFILib.bdk_8bed_Blockchain_new.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_Blockchain_new.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_Blockchain_broadcast.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_Blockchain_broadcast.restype = None
_UniFFILib.bdk_8bed_Blockchain_get_height.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_Blockchain_get_height.restype = ctypes.c_uint32
_UniFFILib.bdk_8bed_Blockchain_get_block_hash.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_Blockchain_get_block_hash.restype = RustBuffer
_UniFFILib.ffi_bdk_8bed_Wallet_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_8bed_Wallet_object_free.restype = None
_UniFFILib.bdk_8bed_Wallet_new.argtypes = (
    RustBuffer,
    RustBuffer,
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_Wallet_new.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_Wallet_get_address.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_Wallet_get_address.restype = RustBuffer
_UniFFILib.bdk_8bed_Wallet_get_balance.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_Wallet_get_balance.restype = RustBuffer
_UniFFILib.bdk_8bed_Wallet_sign.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_Wallet_sign.restype = ctypes.c_int8
_UniFFILib.bdk_8bed_Wallet_list_transactions.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_Wallet_list_transactions.restype = RustBuffer
_UniFFILib.bdk_8bed_Wallet_network.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_Wallet_network.restype = RustBuffer
_UniFFILib.bdk_8bed_Wallet_sync.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_Wallet_sync.restype = None
_UniFFILib.bdk_8bed_Wallet_list_unspent.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_Wallet_list_unspent.restype = RustBuffer
_UniFFILib.ffi_bdk_8bed_PartiallySignedBitcoinTransaction_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_8bed_PartiallySignedBitcoinTransaction_object_free.restype = None
_UniFFILib.bdk_8bed_PartiallySignedBitcoinTransaction_new.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_PartiallySignedBitcoinTransaction_new.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_PartiallySignedBitcoinTransaction_serialize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_PartiallySignedBitcoinTransaction_serialize.restype = RustBuffer
_UniFFILib.bdk_8bed_PartiallySignedBitcoinTransaction_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_PartiallySignedBitcoinTransaction_txid.restype = RustBuffer
_UniFFILib.ffi_bdk_8bed_TxBuilder_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_8bed_TxBuilder_object_free.restype = None
_UniFFILib.bdk_8bed_TxBuilder_new.argtypes = (
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_TxBuilder_new.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_TxBuilder_add_recipient.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.c_uint64,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_TxBuilder_add_recipient.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_TxBuilder_add_unspendable.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_TxBuilder_add_unspendable.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_TxBuilder_add_utxo.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_TxBuilder_add_utxo.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_TxBuilder_add_utxos.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_TxBuilder_add_utxos.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_TxBuilder_do_not_spend_change.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_TxBuilder_do_not_spend_change.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_TxBuilder_manually_selected_only.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_TxBuilder_manually_selected_only.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_TxBuilder_only_spend_change.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_TxBuilder_only_spend_change.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_TxBuilder_unspendable.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_TxBuilder_unspendable.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_TxBuilder_fee_rate.argtypes = (
    ctypes.c_void_p,
    ctypes.c_float,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_TxBuilder_fee_rate.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_TxBuilder_fee_absolute.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_TxBuilder_fee_absolute.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_TxBuilder_drain_wallet.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_TxBuilder_drain_wallet.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_TxBuilder_drain_to.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_TxBuilder_drain_to.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_TxBuilder_enable_rbf.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_TxBuilder_enable_rbf.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_TxBuilder_enable_rbf_with_sequence.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_TxBuilder_enable_rbf_with_sequence.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_TxBuilder_add_data.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_TxBuilder_add_data.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_TxBuilder_set_recipients.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_TxBuilder_set_recipients.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_TxBuilder_finish.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_TxBuilder_finish.restype = ctypes.c_void_p
_UniFFILib.ffi_bdk_8bed_BumpFeeTxBuilder_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_8bed_BumpFeeTxBuilder_object_free.restype = None
_UniFFILib.bdk_8bed_BumpFeeTxBuilder_new.argtypes = (
    RustBuffer,
    ctypes.c_float,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_BumpFeeTxBuilder_new.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_BumpFeeTxBuilder_allow_shrinking.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_BumpFeeTxBuilder_allow_shrinking.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_BumpFeeTxBuilder_enable_rbf.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_BumpFeeTxBuilder_enable_rbf.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_BumpFeeTxBuilder_enable_rbf_with_sequence.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_BumpFeeTxBuilder_enable_rbf_with_sequence.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_BumpFeeTxBuilder_finish.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_BumpFeeTxBuilder_finish.restype = ctypes.c_void_p
_UniFFILib.ffi_bdk_8bed_DerivationPath_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_8bed_DerivationPath_object_free.restype = None
_UniFFILib.bdk_8bed_DerivationPath_new.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_DerivationPath_new.restype = ctypes.c_void_p
_UniFFILib.ffi_bdk_8bed_DescriptorSecretKey_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_8bed_DescriptorSecretKey_object_free.restype = None
_UniFFILib.bdk_8bed_DescriptorSecretKey_new.argtypes = (
    RustBuffer,
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_DescriptorSecretKey_new.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_DescriptorSecretKey_derive.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_DescriptorSecretKey_derive.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_DescriptorSecretKey_extend.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_DescriptorSecretKey_extend.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_DescriptorSecretKey_as_public.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_DescriptorSecretKey_as_public.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_DescriptorSecretKey_as_string.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_DescriptorSecretKey_as_string.restype = RustBuffer
_UniFFILib.ffi_bdk_8bed_DescriptorPublicKey_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_8bed_DescriptorPublicKey_object_free.restype = None
_UniFFILib.bdk_8bed_DescriptorPublicKey_derive.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_DescriptorPublicKey_derive.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_DescriptorPublicKey_extend.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_DescriptorPublicKey_extend.restype = ctypes.c_void_p
_UniFFILib.bdk_8bed_DescriptorPublicKey_as_string.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_DescriptorPublicKey_as_string.restype = RustBuffer
_UniFFILib.ffi_bdk_8bed_Progress_init_callback.argtypes = (
    FOREIGN_CALLBACK_T,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_8bed_Progress_init_callback.restype = None
_UniFFILib.bdk_8bed_generate_mnemonic.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.bdk_8bed_generate_mnemonic.restype = RustBuffer
_UniFFILib.ffi_bdk_8bed_rustbuffer_alloc.argtypes = (
    ctypes.c_int32,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_8bed_rustbuffer_alloc.restype = RustBuffer
_UniFFILib.ffi_bdk_8bed_rustbuffer_from_bytes.argtypes = (
    ForeignBytes,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_8bed_rustbuffer_from_bytes.restype = RustBuffer
_UniFFILib.ffi_bdk_8bed_rustbuffer_free.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_8bed_rustbuffer_free.restype = None
_UniFFILib.ffi_bdk_8bed_rustbuffer_reserve.argtypes = (
    RustBuffer,
    ctypes.c_int32,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_bdk_8bed_rustbuffer_reserve.restype = RustBuffer

# Public interface members begin here.


class FfiConverterUInt8(FfiConverterPrimitive):
    @staticmethod
    def read(buf):
        return buf.readU8()

    @staticmethod
    def write(value, buf):
        buf.writeU8(value)

class FfiConverterUInt32(FfiConverterPrimitive):
    @staticmethod
    def read(buf):
        return buf.readU32()

    @staticmethod
    def write(value, buf):
        buf.writeU32(value)

class FfiConverterUInt64(FfiConverterPrimitive):
    @staticmethod
    def read(buf):
        return buf.readU64()

    @staticmethod
    def write(value, buf):
        buf.writeU64(value)

class FfiConverterFloat(FfiConverterPrimitive):
    @staticmethod
    def read(buf):
        return buf.readFloat()

    @staticmethod
    def write(value, buf):
        buf.writeFloat(value)

class FfiConverterBool:
    @classmethod
    def read(cls, buf):
        return cls.lift(buf.readU8())

    @classmethod
    def write(cls, value, buf):
        buf.writeU8(cls.lower(value))

    @staticmethod
    def lift(value):
        return int(value) != 0

    @staticmethod
    def lower(value):
        return 1 if value else 0

class FfiConverterString:
    @staticmethod
    def read(buf):
        size = buf.readI32()
        if size < 0:
            raise InternalError("Unexpected negative string length")
        utf8Bytes = buf.read(size)
        return utf8Bytes.decode("utf-8")

    @staticmethod
    def write(value, buf):
        utf8Bytes = value.encode("utf-8")
        buf.writeI32(len(utf8Bytes))
        buf.write(utf8Bytes)

    @staticmethod
    def lift(buf):
        with buf.consumeWithStream() as stream:
            return stream.read(stream.remaining()).decode("utf-8")

    @staticmethod
    def lower(value):
        with RustBuffer.allocWithBuilder() as builder:
            builder.write(value.encode("utf-8"))
            return builder.finalize()



class Blockchain(object):
    def __init__(self, config):
        config = config
        
        self._pointer = rust_call_with_error(FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_Blockchain_new,
        FfiConverterTypeBlockchainConfig.lower(config))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_8bed_Blockchain_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    

    def broadcast(self, psbt):
        psbt = psbt
        
        rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_Blockchain_broadcast,self._pointer,
        FfiConverterTypePartiallySignedBitcoinTransaction.lower(psbt))
    
    def get_height(self, ):
        return FfiConverterUInt32.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_Blockchain_get_height,self._pointer,)
        )
    def get_block_hash(self, height):
        height = int(height)
        
        return FfiConverterString.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_Blockchain_get_block_hash,self._pointer,
        FfiConverterUInt32.lower(height))
        )
    


class FfiConverterTypeBlockchain:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Blockchain):
            raise TypeError("Expected Blockchain instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Blockchain._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class BumpFeeTxBuilder(object):
    def __init__(self, txid,new_fee_rate):
        txid = txid
        
        new_fee_rate = float(new_fee_rate)
        
        self._pointer = rust_call(_UniFFILib.bdk_8bed_BumpFeeTxBuilder_new,
        FfiConverterString.lower(txid),
        FfiConverterFloat.lower(new_fee_rate))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_8bed_BumpFeeTxBuilder_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    

    def allow_shrinking(self, address):
        address = address
        
        return FfiConverterTypeBumpFeeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_BumpFeeTxBuilder_allow_shrinking,self._pointer,
        FfiConverterString.lower(address))
        )
    def enable_rbf(self, ):
        return FfiConverterTypeBumpFeeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_BumpFeeTxBuilder_enable_rbf,self._pointer,)
        )
    def enable_rbf_with_sequence(self, nsequence):
        nsequence = int(nsequence)
        
        return FfiConverterTypeBumpFeeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_BumpFeeTxBuilder_enable_rbf_with_sequence,self._pointer,
        FfiConverterUInt32.lower(nsequence))
        )
    def finish(self, wallet):
        wallet = wallet
        
        return FfiConverterTypePartiallySignedBitcoinTransaction.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_BumpFeeTxBuilder_finish,self._pointer,
        FfiConverterTypeWallet.lower(wallet))
        )
    


class FfiConverterTypeBumpFeeTxBuilder:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, BumpFeeTxBuilder):
            raise TypeError("Expected BumpFeeTxBuilder instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return BumpFeeTxBuilder._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class DerivationPath(object):
    def __init__(self, path):
        path = path
        
        self._pointer = rust_call_with_error(FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_DerivationPath_new,
        FfiConverterString.lower(path))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_8bed_DerivationPath_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    

    


class FfiConverterTypeDerivationPath:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, DerivationPath):
            raise TypeError("Expected DerivationPath instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return DerivationPath._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class DescriptorPublicKey(object):

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_8bed_DescriptorPublicKey_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    

    def derive(self, path):
        path = path
        
        return FfiConverterTypeDescriptorPublicKey.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_DescriptorPublicKey_derive,self._pointer,
        FfiConverterTypeDerivationPath.lower(path))
        )
    def extend(self, path):
        path = path
        
        return FfiConverterTypeDescriptorPublicKey.lift(
            rust_call(_UniFFILib.bdk_8bed_DescriptorPublicKey_extend,self._pointer,
        FfiConverterTypeDerivationPath.lower(path))
        )
    def as_string(self, ):
        return FfiConverterString.lift(
            rust_call(_UniFFILib.bdk_8bed_DescriptorPublicKey_as_string,self._pointer,)
        )
    


class FfiConverterTypeDescriptorPublicKey:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, DescriptorPublicKey):
            raise TypeError("Expected DescriptorPublicKey instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return DescriptorPublicKey._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class DescriptorSecretKey(object):
    def __init__(self, network,mnemonic,password):
        network = network
        
        mnemonic = mnemonic
        
        password = (None if password is None else password)
        
        self._pointer = rust_call_with_error(FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_DescriptorSecretKey_new,
        FfiConverterTypeNetwork.lower(network),
        FfiConverterString.lower(mnemonic),
        FfiConverterOptionalString.lower(password))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_8bed_DescriptorSecretKey_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    

    def derive(self, path):
        path = path
        
        return FfiConverterTypeDescriptorSecretKey.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_DescriptorSecretKey_derive,self._pointer,
        FfiConverterTypeDerivationPath.lower(path))
        )
    def extend(self, path):
        path = path
        
        return FfiConverterTypeDescriptorSecretKey.lift(
            rust_call(_UniFFILib.bdk_8bed_DescriptorSecretKey_extend,self._pointer,
        FfiConverterTypeDerivationPath.lower(path))
        )
    def as_public(self, ):
        return FfiConverterTypeDescriptorPublicKey.lift(
            rust_call(_UniFFILib.bdk_8bed_DescriptorSecretKey_as_public,self._pointer,)
        )
    def as_string(self, ):
        return FfiConverterString.lift(
            rust_call(_UniFFILib.bdk_8bed_DescriptorSecretKey_as_string,self._pointer,)
        )
    


class FfiConverterTypeDescriptorSecretKey:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, DescriptorSecretKey):
            raise TypeError("Expected DescriptorSecretKey instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return DescriptorSecretKey._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class PartiallySignedBitcoinTransaction(object):
    def __init__(self, psbt_base64):
        psbt_base64 = psbt_base64
        
        self._pointer = rust_call_with_error(FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_PartiallySignedBitcoinTransaction_new,
        FfiConverterString.lower(psbt_base64))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_8bed_PartiallySignedBitcoinTransaction_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    

    def serialize(self, ):
        return FfiConverterString.lift(
            rust_call(_UniFFILib.bdk_8bed_PartiallySignedBitcoinTransaction_serialize,self._pointer,)
        )
    def txid(self, ):
        return FfiConverterString.lift(
            rust_call(_UniFFILib.bdk_8bed_PartiallySignedBitcoinTransaction_txid,self._pointer,)
        )
    


class FfiConverterTypePartiallySignedBitcoinTransaction:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, PartiallySignedBitcoinTransaction):
            raise TypeError("Expected PartiallySignedBitcoinTransaction instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return PartiallySignedBitcoinTransaction._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class TxBuilder(object):
    def __init__(self, ):
        self._pointer = rust_call(_UniFFILib.bdk_8bed_TxBuilder_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_8bed_TxBuilder_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    

    def add_recipient(self, address,amount):
        address = address
        
        amount = int(amount)
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_TxBuilder_add_recipient,self._pointer,
        FfiConverterString.lower(address),
        FfiConverterUInt64.lower(amount))
        )
    def add_unspendable(self, unspendable):
        unspendable = unspendable
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_TxBuilder_add_unspendable,self._pointer,
        FfiConverterTypeOutPoint.lower(unspendable))
        )
    def add_utxo(self, outpoint):
        outpoint = outpoint
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_TxBuilder_add_utxo,self._pointer,
        FfiConverterTypeOutPoint.lower(outpoint))
        )
    def add_utxos(self, outpoints):
        outpoints = list(x for x in outpoints)
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_TxBuilder_add_utxos,self._pointer,
        FfiConverterSequenceTypeOutPoint.lower(outpoints))
        )
    def do_not_spend_change(self, ):
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_TxBuilder_do_not_spend_change,self._pointer,)
        )
    def manually_selected_only(self, ):
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_TxBuilder_manually_selected_only,self._pointer,)
        )
    def only_spend_change(self, ):
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_TxBuilder_only_spend_change,self._pointer,)
        )
    def unspendable(self, unspendable):
        unspendable = list(x for x in unspendable)
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_TxBuilder_unspendable,self._pointer,
        FfiConverterSequenceTypeOutPoint.lower(unspendable))
        )
    def fee_rate(self, sat_per_vbyte):
        sat_per_vbyte = float(sat_per_vbyte)
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_TxBuilder_fee_rate,self._pointer,
        FfiConverterFloat.lower(sat_per_vbyte))
        )
    def fee_absolute(self, fee_amount):
        fee_amount = int(fee_amount)
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_TxBuilder_fee_absolute,self._pointer,
        FfiConverterUInt64.lower(fee_amount))
        )
    def drain_wallet(self, ):
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_TxBuilder_drain_wallet,self._pointer,)
        )
    def drain_to(self, address):
        address = address
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_TxBuilder_drain_to,self._pointer,
        FfiConverterString.lower(address))
        )
    def enable_rbf(self, ):
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_TxBuilder_enable_rbf,self._pointer,)
        )
    def enable_rbf_with_sequence(self, nsequence):
        nsequence = int(nsequence)
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_TxBuilder_enable_rbf_with_sequence,self._pointer,
        FfiConverterUInt32.lower(nsequence))
        )
    def add_data(self, data):
        data = list(int(x) for x in data)
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_TxBuilder_add_data,self._pointer,
        FfiConverterSequenceUInt8.lower(data))
        )
    def set_recipients(self, recipients):
        recipients = list(x for x in recipients)
        
        return FfiConverterTypeTxBuilder.lift(
            rust_call(_UniFFILib.bdk_8bed_TxBuilder_set_recipients,self._pointer,
        FfiConverterSequenceTypeAddressAmount.lower(recipients))
        )
    def finish(self, wallet):
        wallet = wallet
        
        return FfiConverterTypePartiallySignedBitcoinTransaction.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_TxBuilder_finish,self._pointer,
        FfiConverterTypeWallet.lower(wallet))
        )
    


class FfiConverterTypeTxBuilder:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, TxBuilder):
            raise TypeError("Expected TxBuilder instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return TxBuilder._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class Wallet(object):
    def __init__(self, descriptor,change_descriptor,network,database_config):
        descriptor = descriptor
        
        change_descriptor = (None if change_descriptor is None else change_descriptor)
        
        network = network
        
        database_config = database_config
        
        self._pointer = rust_call_with_error(FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_Wallet_new,
        FfiConverterString.lower(descriptor),
        FfiConverterOptionalString.lower(change_descriptor),
        FfiConverterTypeNetwork.lower(network),
        FfiConverterTypeDatabaseConfig.lower(database_config))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_bdk_8bed_Wallet_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    

    def get_address(self, address_index):
        address_index = address_index
        
        return FfiConverterTypeAddressInfo.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_Wallet_get_address,self._pointer,
        FfiConverterTypeAddressIndex.lower(address_index))
        )
    def get_balance(self, ):
        return FfiConverterTypeBalance.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_Wallet_get_balance,self._pointer,)
        )
    def sign(self, psbt):
        psbt = psbt
        
        return FfiConverterBool.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_Wallet_sign,self._pointer,
        FfiConverterTypePartiallySignedBitcoinTransaction.lower(psbt))
        )
    def list_transactions(self, ):
        return FfiConverterSequenceTypeTransactionDetails.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_Wallet_list_transactions,self._pointer,)
        )
    def network(self, ):
        return FfiConverterTypeNetwork.lift(
            rust_call(_UniFFILib.bdk_8bed_Wallet_network,self._pointer,)
        )
    def sync(self, blockchain,progress):
        blockchain = blockchain
        
        progress = (None if progress is None else progress)
        
        rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_Wallet_sync,self._pointer,
        FfiConverterTypeBlockchain.lower(blockchain),
        FfiConverterOptionalCallbackInterfaceProgress.lower(progress))
    
    def list_unspent(self, ):
        return FfiConverterSequenceTypeLocalUtxo.lift(
            rust_call_with_error(
    FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_Wallet_list_unspent,self._pointer,)
        )
    


class FfiConverterTypeWallet:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Wallet):
            raise TypeError("Expected Wallet instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Wallet._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer


class AddressAmount:

    def __init__(self, address, amount):
        self.address = address
        self.amount = amount

    def __str__(self):
        return "AddressAmount(address={}, amount={})".format(self.address, self.amount)

    def __eq__(self, other):
        if self.address != other.address:
            return False
        if self.amount != other.amount:
            return False
        return True

class FfiConverterTypeAddressAmount(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return AddressAmount(
            address=FfiConverterString.read(buf),
            amount=FfiConverterUInt64.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterString.write(value.address, buf)
        FfiConverterUInt64.write(value.amount, buf)


class AddressInfo:

    def __init__(self, index, address):
        self.index = index
        self.address = address

    def __str__(self):
        return "AddressInfo(index={}, address={})".format(self.index, self.address)

    def __eq__(self, other):
        if self.index != other.index:
            return False
        if self.address != other.address:
            return False
        return True

class FfiConverterTypeAddressInfo(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return AddressInfo(
            index=FfiConverterUInt32.read(buf),
            address=FfiConverterString.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterUInt32.write(value.index, buf)
        FfiConverterString.write(value.address, buf)


class Balance:

    def __init__(self, immature, trusted_pending, untrusted_pending, confirmed, spendable, total):
        self.immature = immature
        self.trusted_pending = trusted_pending
        self.untrusted_pending = untrusted_pending
        self.confirmed = confirmed
        self.spendable = spendable
        self.total = total

    def __str__(self):
        return "Balance(immature={}, trusted_pending={}, untrusted_pending={}, confirmed={}, spendable={}, total={})".format(self.immature, self.trusted_pending, self.untrusted_pending, self.confirmed, self.spendable, self.total)

    def __eq__(self, other):
        if self.immature != other.immature:
            return False
        if self.trusted_pending != other.trusted_pending:
            return False
        if self.untrusted_pending != other.untrusted_pending:
            return False
        if self.confirmed != other.confirmed:
            return False
        if self.spendable != other.spendable:
            return False
        if self.total != other.total:
            return False
        return True

class FfiConverterTypeBalance(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Balance(
            immature=FfiConverterUInt64.read(buf),
            trusted_pending=FfiConverterUInt64.read(buf),
            untrusted_pending=FfiConverterUInt64.read(buf),
            confirmed=FfiConverterUInt64.read(buf),
            spendable=FfiConverterUInt64.read(buf),
            total=FfiConverterUInt64.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterUInt64.write(value.immature, buf)
        FfiConverterUInt64.write(value.trusted_pending, buf)
        FfiConverterUInt64.write(value.untrusted_pending, buf)
        FfiConverterUInt64.write(value.confirmed, buf)
        FfiConverterUInt64.write(value.spendable, buf)
        FfiConverterUInt64.write(value.total, buf)


class BlockTime:

    def __init__(self, height, timestamp):
        self.height = height
        self.timestamp = timestamp

    def __str__(self):
        return "BlockTime(height={}, timestamp={})".format(self.height, self.timestamp)

    def __eq__(self, other):
        if self.height != other.height:
            return False
        if self.timestamp != other.timestamp:
            return False
        return True

class FfiConverterTypeBlockTime(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return BlockTime(
            height=FfiConverterUInt32.read(buf),
            timestamp=FfiConverterUInt64.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterUInt32.write(value.height, buf)
        FfiConverterUInt64.write(value.timestamp, buf)


class ElectrumConfig:

    def __init__(self, url, socks5, retry, timeout, stop_gap):
        self.url = url
        self.socks5 = socks5
        self.retry = retry
        self.timeout = timeout
        self.stop_gap = stop_gap

    def __str__(self):
        return "ElectrumConfig(url={}, socks5={}, retry={}, timeout={}, stop_gap={})".format(self.url, self.socks5, self.retry, self.timeout, self.stop_gap)

    def __eq__(self, other):
        if self.url != other.url:
            return False
        if self.socks5 != other.socks5:
            return False
        if self.retry != other.retry:
            return False
        if self.timeout != other.timeout:
            return False
        if self.stop_gap != other.stop_gap:
            return False
        return True

class FfiConverterTypeElectrumConfig(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ElectrumConfig(
            url=FfiConverterString.read(buf),
            socks5=FfiConverterOptionalString.read(buf),
            retry=FfiConverterUInt8.read(buf),
            timeout=FfiConverterOptionalUInt8.read(buf),
            stop_gap=FfiConverterUInt64.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterString.write(value.url, buf)
        FfiConverterOptionalString.write(value.socks5, buf)
        FfiConverterUInt8.write(value.retry, buf)
        FfiConverterOptionalUInt8.write(value.timeout, buf)
        FfiConverterUInt64.write(value.stop_gap, buf)


class EsploraConfig:

    def __init__(self, base_url, proxy, concurrency, stop_gap, timeout):
        self.base_url = base_url
        self.proxy = proxy
        self.concurrency = concurrency
        self.stop_gap = stop_gap
        self.timeout = timeout

    def __str__(self):
        return "EsploraConfig(base_url={}, proxy={}, concurrency={}, stop_gap={}, timeout={})".format(self.base_url, self.proxy, self.concurrency, self.stop_gap, self.timeout)

    def __eq__(self, other):
        if self.base_url != other.base_url:
            return False
        if self.proxy != other.proxy:
            return False
        if self.concurrency != other.concurrency:
            return False
        if self.stop_gap != other.stop_gap:
            return False
        if self.timeout != other.timeout:
            return False
        return True

class FfiConverterTypeEsploraConfig(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return EsploraConfig(
            base_url=FfiConverterString.read(buf),
            proxy=FfiConverterOptionalString.read(buf),
            concurrency=FfiConverterOptionalUInt8.read(buf),
            stop_gap=FfiConverterUInt64.read(buf),
            timeout=FfiConverterOptionalUInt64.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterString.write(value.base_url, buf)
        FfiConverterOptionalString.write(value.proxy, buf)
        FfiConverterOptionalUInt8.write(value.concurrency, buf)
        FfiConverterUInt64.write(value.stop_gap, buf)
        FfiConverterOptionalUInt64.write(value.timeout, buf)


class LocalUtxo:

    def __init__(self, outpoint, txout, keychain, is_spent):
        self.outpoint = outpoint
        self.txout = txout
        self.keychain = keychain
        self.is_spent = is_spent

    def __str__(self):
        return "LocalUtxo(outpoint={}, txout={}, keychain={}, is_spent={})".format(self.outpoint, self.txout, self.keychain, self.is_spent)

    def __eq__(self, other):
        if self.outpoint != other.outpoint:
            return False
        if self.txout != other.txout:
            return False
        if self.keychain != other.keychain:
            return False
        if self.is_spent != other.is_spent:
            return False
        return True

class FfiConverterTypeLocalUtxo(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LocalUtxo(
            outpoint=FfiConverterTypeOutPoint.read(buf),
            txout=FfiConverterTypeTxOut.read(buf),
            keychain=FfiConverterTypeKeychainKind.read(buf),
            is_spent=FfiConverterBool.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterTypeOutPoint.write(value.outpoint, buf)
        FfiConverterTypeTxOut.write(value.txout, buf)
        FfiConverterTypeKeychainKind.write(value.keychain, buf)
        FfiConverterBool.write(value.is_spent, buf)


class OutPoint:

    def __init__(self, txid, vout):
        self.txid = txid
        self.vout = vout

    def __str__(self):
        return "OutPoint(txid={}, vout={})".format(self.txid, self.vout)

    def __eq__(self, other):
        if self.txid != other.txid:
            return False
        if self.vout != other.vout:
            return False
        return True

class FfiConverterTypeOutPoint(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return OutPoint(
            txid=FfiConverterString.read(buf),
            vout=FfiConverterUInt32.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterString.write(value.txid, buf)
        FfiConverterUInt32.write(value.vout, buf)


class SledDbConfiguration:

    def __init__(self, path, tree_name):
        self.path = path
        self.tree_name = tree_name

    def __str__(self):
        return "SledDbConfiguration(path={}, tree_name={})".format(self.path, self.tree_name)

    def __eq__(self, other):
        if self.path != other.path:
            return False
        if self.tree_name != other.tree_name:
            return False
        return True

class FfiConverterTypeSledDbConfiguration(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SledDbConfiguration(
            path=FfiConverterString.read(buf),
            tree_name=FfiConverterString.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterString.write(value.path, buf)
        FfiConverterString.write(value.tree_name, buf)


class SqliteDbConfiguration:

    def __init__(self, path):
        self.path = path

    def __str__(self):
        return "SqliteDbConfiguration(path={})".format(self.path)

    def __eq__(self, other):
        if self.path != other.path:
            return False
        return True

class FfiConverterTypeSqliteDbConfiguration(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SqliteDbConfiguration(
            path=FfiConverterString.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterString.write(value.path, buf)


class TransactionDetails:

    def __init__(self, fee, received, sent, txid, confirmation_time):
        self.fee = fee
        self.received = received
        self.sent = sent
        self.txid = txid
        self.confirmation_time = confirmation_time

    def __str__(self):
        return "TransactionDetails(fee={}, received={}, sent={}, txid={}, confirmation_time={})".format(self.fee, self.received, self.sent, self.txid, self.confirmation_time)

    def __eq__(self, other):
        if self.fee != other.fee:
            return False
        if self.received != other.received:
            return False
        if self.sent != other.sent:
            return False
        if self.txid != other.txid:
            return False
        if self.confirmation_time != other.confirmation_time:
            return False
        return True

class FfiConverterTypeTransactionDetails(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return TransactionDetails(
            fee=FfiConverterOptionalUInt64.read(buf),
            received=FfiConverterUInt64.read(buf),
            sent=FfiConverterUInt64.read(buf),
            txid=FfiConverterString.read(buf),
            confirmation_time=FfiConverterOptionalTypeBlockTime.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterOptionalUInt64.write(value.fee, buf)
        FfiConverterUInt64.write(value.received, buf)
        FfiConverterUInt64.write(value.sent, buf)
        FfiConverterString.write(value.txid, buf)
        FfiConverterOptionalTypeBlockTime.write(value.confirmation_time, buf)


class TxOut:

    def __init__(self, value, address):
        self.value = value
        self.address = address

    def __str__(self):
        return "TxOut(value={}, address={})".format(self.value, self.address)

    def __eq__(self, other):
        if self.value != other.value:
            return False
        if self.address != other.address:
            return False
        return True

class FfiConverterTypeTxOut(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return TxOut(
            value=FfiConverterUInt64.read(buf),
            address=FfiConverterString.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterUInt64.write(value.value, buf)
        FfiConverterString.write(value.address, buf)




class AddressIndex(enum.Enum):
    NEW = 1
    LAST_UNUSED = 2
    


class FfiConverterTypeAddressIndex(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return AddressIndex.NEW
        if variant == 2:
            return AddressIndex.LAST_UNUSED
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value == AddressIndex.NEW:
            buf.writeI32(1)
        if value == AddressIndex.LAST_UNUSED:
            buf.writeI32(2)




class BlockchainConfig:
    def __init__(self):
        raise RuntimeError("BlockchainConfig cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class ELECTRUM(object):
        def __init__(self,config):
            
            self.config = config
            

        def __str__(self):
            return "BlockchainConfig.ELECTRUM(config={})".format(self.config)

        def __eq__(self, other):
            if not other.is_electrum():
                return False
            if self.config != other.config:
                return False
            return True
    class ESPLORA(object):
        def __init__(self,config):
            
            self.config = config
            

        def __str__(self):
            return "BlockchainConfig.ESPLORA(config={})".format(self.config)

        def __eq__(self, other):
            if not other.is_esplora():
                return False
            if self.config != other.config:
                return False
            return True
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_electrum(self):
        return isinstance(self, BlockchainConfig.ELECTRUM)
    def is_esplora(self):
        return isinstance(self, BlockchainConfig.ESPLORA)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
BlockchainConfig.ELECTRUM = type("BlockchainConfig.ELECTRUM", (BlockchainConfig.ELECTRUM, BlockchainConfig,), {})
BlockchainConfig.ESPLORA = type("BlockchainConfig.ESPLORA", (BlockchainConfig.ESPLORA, BlockchainConfig,), {})




class FfiConverterTypeBlockchainConfig(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return BlockchainConfig.ELECTRUM(
                FfiConverterTypeElectrumConfig.read(buf),
            )
        if variant == 2:
            return BlockchainConfig.ESPLORA(
                FfiConverterTypeEsploraConfig.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value.is_electrum():
            buf.writeI32(1)
            FfiConverterTypeElectrumConfig.write(value.config, buf)
        if value.is_esplora():
            buf.writeI32(2)
            FfiConverterTypeEsploraConfig.write(value.config, buf)




class DatabaseConfig:
    def __init__(self):
        raise RuntimeError("DatabaseConfig cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class MEMORY(object):
        def __init__(self,):
            
            pass
            

        def __str__(self):
            return "DatabaseConfig.MEMORY()".format()

        def __eq__(self, other):
            if not other.is_memory():
                return False
            return True
    class SLED(object):
        def __init__(self,config):
            
            self.config = config
            

        def __str__(self):
            return "DatabaseConfig.SLED(config={})".format(self.config)

        def __eq__(self, other):
            if not other.is_sled():
                return False
            if self.config != other.config:
                return False
            return True
    class SQLITE(object):
        def __init__(self,config):
            
            self.config = config
            

        def __str__(self):
            return "DatabaseConfig.SQLITE(config={})".format(self.config)

        def __eq__(self, other):
            if not other.is_sqlite():
                return False
            if self.config != other.config:
                return False
            return True
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_memory(self):
        return isinstance(self, DatabaseConfig.MEMORY)
    def is_sled(self):
        return isinstance(self, DatabaseConfig.SLED)
    def is_sqlite(self):
        return isinstance(self, DatabaseConfig.SQLITE)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
DatabaseConfig.MEMORY = type("DatabaseConfig.MEMORY", (DatabaseConfig.MEMORY, DatabaseConfig,), {})
DatabaseConfig.SLED = type("DatabaseConfig.SLED", (DatabaseConfig.SLED, DatabaseConfig,), {})
DatabaseConfig.SQLITE = type("DatabaseConfig.SQLITE", (DatabaseConfig.SQLITE, DatabaseConfig,), {})




class FfiConverterTypeDatabaseConfig(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return DatabaseConfig.MEMORY(
            )
        if variant == 2:
            return DatabaseConfig.SLED(
                FfiConverterTypeSledDbConfiguration.read(buf),
            )
        if variant == 3:
            return DatabaseConfig.SQLITE(
                FfiConverterTypeSqliteDbConfiguration.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value.is_memory():
            buf.writeI32(1)
        if value.is_sled():
            buf.writeI32(2)
            FfiConverterTypeSledDbConfiguration.write(value.config, buf)
        if value.is_sqlite():
            buf.writeI32(3)
            FfiConverterTypeSqliteDbConfiguration.write(value.config, buf)




class KeychainKind(enum.Enum):
    EXTERNAL = 1
    INTERNAL = 2
    


class FfiConverterTypeKeychainKind(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return KeychainKind.EXTERNAL
        if variant == 2:
            return KeychainKind.INTERNAL
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value == KeychainKind.EXTERNAL:
            buf.writeI32(1)
        if value == KeychainKind.INTERNAL:
            buf.writeI32(2)




class Network(enum.Enum):
    BITCOIN = 1
    TESTNET = 2
    SIGNET = 3
    REGTEST = 4
    


class FfiConverterTypeNetwork(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return Network.BITCOIN
        if variant == 2:
            return Network.TESTNET
        if variant == 3:
            return Network.SIGNET
        if variant == 4:
            return Network.REGTEST
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value == Network.BITCOIN:
            buf.writeI32(1)
        if value == Network.TESTNET:
            buf.writeI32(2)
        if value == Network.SIGNET:
            buf.writeI32(3)
        if value == Network.REGTEST:
            buf.writeI32(4)




class WordCount(enum.Enum):
    WORDS12 = 1
    WORDS15 = 2
    WORDS18 = 3
    WORDS21 = 4
    WORDS24 = 5
    


class FfiConverterTypeWordCount(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return WordCount.WORDS12
        if variant == 2:
            return WordCount.WORDS15
        if variant == 3:
            return WordCount.WORDS18
        if variant == 4:
            return WordCount.WORDS21
        if variant == 5:
            return WordCount.WORDS24
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value == WordCount.WORDS12:
            buf.writeI32(1)
        if value == WordCount.WORDS15:
            buf.writeI32(2)
        if value == WordCount.WORDS18:
            buf.writeI32(3)
        if value == WordCount.WORDS21:
            buf.writeI32(4)
        if value == WordCount.WORDS24:
            buf.writeI32(5)


class BdkError(Exception):

    # Each variant is a nested class of the error itself.
    # It just carries a string error message, so no special implementation is necessary.
    class InvalidU32Bytes(Exception):
        pass
    class Generic(Exception):
        pass
    class MissingCachedScripts(Exception):
        pass
    class ScriptDoesntHaveAddressForm(Exception):
        pass
    class NoRecipients(Exception):
        pass
    class NoUtxosSelected(Exception):
        pass
    class OutputBelowDustLimit(Exception):
        pass
    class InsufficientFunds(Exception):
        pass
    class BnBTotalTriesExceeded(Exception):
        pass
    class BnBNoExactMatch(Exception):
        pass
    class UnknownUtxo(Exception):
        pass
    class TransactionNotFound(Exception):
        pass
    class TransactionConfirmed(Exception):
        pass
    class IrreplaceableTransaction(Exception):
        pass
    class FeeRateTooLow(Exception):
        pass
    class FeeTooLow(Exception):
        pass
    class FeeRateUnavailable(Exception):
        pass
    class MissingKeyOrigin(Exception):
        pass
    class Key(Exception):
        pass
    class ChecksumMismatch(Exception):
        pass
    class SpendingPolicyRequired(Exception):
        pass
    class InvalidPolicyPathError(Exception):
        pass
    class Signer(Exception):
        pass
    class InvalidNetwork(Exception):
        pass
    class InvalidProgressValue(Exception):
        pass
    class ProgressUpdateError(Exception):
        pass
    class InvalidOutpoint(Exception):
        pass
    class Descriptor(Exception):
        pass
    class AddressValidator(Exception):
        pass
    class Encode(Exception):
        pass
    class Miniscript(Exception):
        pass
    class Bip32(Exception):
        pass
    class Secp256k1(Exception):
        pass
    class Json(Exception):
        pass
    class Hex(Exception):
        pass
    class Psbt(Exception):
        pass
    class PsbtParse(Exception):
        pass
    class Electrum(Exception):
        pass
    class Esplora(Exception):
        pass
    class Sled(Exception):
        pass
    class Rusqlite(Exception):
        pass

class FfiConverterTypeBdkError(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return BdkError.InvalidU32Bytes(
                FfiConverterString.read(buf),
            )
        if variant == 2:
            return BdkError.Generic(
                FfiConverterString.read(buf),
            )
        if variant == 3:
            return BdkError.MissingCachedScripts(
                FfiConverterString.read(buf),
            )
        if variant == 4:
            return BdkError.ScriptDoesntHaveAddressForm(
                FfiConverterString.read(buf),
            )
        if variant == 5:
            return BdkError.NoRecipients(
                FfiConverterString.read(buf),
            )
        if variant == 6:
            return BdkError.NoUtxosSelected(
                FfiConverterString.read(buf),
            )
        if variant == 7:
            return BdkError.OutputBelowDustLimit(
                FfiConverterString.read(buf),
            )
        if variant == 8:
            return BdkError.InsufficientFunds(
                FfiConverterString.read(buf),
            )
        if variant == 9:
            return BdkError.BnBTotalTriesExceeded(
                FfiConverterString.read(buf),
            )
        if variant == 10:
            return BdkError.BnBNoExactMatch(
                FfiConverterString.read(buf),
            )
        if variant == 11:
            return BdkError.UnknownUtxo(
                FfiConverterString.read(buf),
            )
        if variant == 12:
            return BdkError.TransactionNotFound(
                FfiConverterString.read(buf),
            )
        if variant == 13:
            return BdkError.TransactionConfirmed(
                FfiConverterString.read(buf),
            )
        if variant == 14:
            return BdkError.IrreplaceableTransaction(
                FfiConverterString.read(buf),
            )
        if variant == 15:
            return BdkError.FeeRateTooLow(
                FfiConverterString.read(buf),
            )
        if variant == 16:
            return BdkError.FeeTooLow(
                FfiConverterString.read(buf),
            )
        if variant == 17:
            return BdkError.FeeRateUnavailable(
                FfiConverterString.read(buf),
            )
        if variant == 18:
            return BdkError.MissingKeyOrigin(
                FfiConverterString.read(buf),
            )
        if variant == 19:
            return BdkError.Key(
                FfiConverterString.read(buf),
            )
        if variant == 20:
            return BdkError.ChecksumMismatch(
                FfiConverterString.read(buf),
            )
        if variant == 21:
            return BdkError.SpendingPolicyRequired(
                FfiConverterString.read(buf),
            )
        if variant == 22:
            return BdkError.InvalidPolicyPathError(
                FfiConverterString.read(buf),
            )
        if variant == 23:
            return BdkError.Signer(
                FfiConverterString.read(buf),
            )
        if variant == 24:
            return BdkError.InvalidNetwork(
                FfiConverterString.read(buf),
            )
        if variant == 25:
            return BdkError.InvalidProgressValue(
                FfiConverterString.read(buf),
            )
        if variant == 26:
            return BdkError.ProgressUpdateError(
                FfiConverterString.read(buf),
            )
        if variant == 27:
            return BdkError.InvalidOutpoint(
                FfiConverterString.read(buf),
            )
        if variant == 28:
            return BdkError.Descriptor(
                FfiConverterString.read(buf),
            )
        if variant == 29:
            return BdkError.AddressValidator(
                FfiConverterString.read(buf),
            )
        if variant == 30:
            return BdkError.Encode(
                FfiConverterString.read(buf),
            )
        if variant == 31:
            return BdkError.Miniscript(
                FfiConverterString.read(buf),
            )
        if variant == 32:
            return BdkError.Bip32(
                FfiConverterString.read(buf),
            )
        if variant == 33:
            return BdkError.Secp256k1(
                FfiConverterString.read(buf),
            )
        if variant == 34:
            return BdkError.Json(
                FfiConverterString.read(buf),
            )
        if variant == 35:
            return BdkError.Hex(
                FfiConverterString.read(buf),
            )
        if variant == 36:
            return BdkError.Psbt(
                FfiConverterString.read(buf),
            )
        if variant == 37:
            return BdkError.PsbtParse(
                FfiConverterString.read(buf),
            )
        if variant == 38:
            return BdkError.Electrum(
                FfiConverterString.read(buf),
            )
        if variant == 39:
            return BdkError.Esplora(
                FfiConverterString.read(buf),
            )
        if variant == 40:
            return BdkError.Sled(
                FfiConverterString.read(buf),
            )
        if variant == 41:
            return BdkError.Rusqlite(
                FfiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def write(value, buf):
        if isinstance(value, BdkError.InvalidU32Bytes):
            buf.writeI32(1)
        if isinstance(value, BdkError.Generic):
            buf.writeI32(2)
        if isinstance(value, BdkError.MissingCachedScripts):
            buf.writeI32(3)
        if isinstance(value, BdkError.ScriptDoesntHaveAddressForm):
            buf.writeI32(4)
        if isinstance(value, BdkError.NoRecipients):
            buf.writeI32(5)
        if isinstance(value, BdkError.NoUtxosSelected):
            buf.writeI32(6)
        if isinstance(value, BdkError.OutputBelowDustLimit):
            buf.writeI32(7)
        if isinstance(value, BdkError.InsufficientFunds):
            buf.writeI32(8)
        if isinstance(value, BdkError.BnBTotalTriesExceeded):
            buf.writeI32(9)
        if isinstance(value, BdkError.BnBNoExactMatch):
            buf.writeI32(10)
        if isinstance(value, BdkError.UnknownUtxo):
            buf.writeI32(11)
        if isinstance(value, BdkError.TransactionNotFound):
            buf.writeI32(12)
        if isinstance(value, BdkError.TransactionConfirmed):
            buf.writeI32(13)
        if isinstance(value, BdkError.IrreplaceableTransaction):
            buf.writeI32(14)
        if isinstance(value, BdkError.FeeRateTooLow):
            buf.writeI32(15)
        if isinstance(value, BdkError.FeeTooLow):
            buf.writeI32(16)
        if isinstance(value, BdkError.FeeRateUnavailable):
            buf.writeI32(17)
        if isinstance(value, BdkError.MissingKeyOrigin):
            buf.writeI32(18)
        if isinstance(value, BdkError.Key):
            buf.writeI32(19)
        if isinstance(value, BdkError.ChecksumMismatch):
            buf.writeI32(20)
        if isinstance(value, BdkError.SpendingPolicyRequired):
            buf.writeI32(21)
        if isinstance(value, BdkError.InvalidPolicyPathError):
            buf.writeI32(22)
        if isinstance(value, BdkError.Signer):
            buf.writeI32(23)
        if isinstance(value, BdkError.InvalidNetwork):
            buf.writeI32(24)
        if isinstance(value, BdkError.InvalidProgressValue):
            buf.writeI32(25)
        if isinstance(value, BdkError.ProgressUpdateError):
            buf.writeI32(26)
        if isinstance(value, BdkError.InvalidOutpoint):
            buf.writeI32(27)
        if isinstance(value, BdkError.Descriptor):
            buf.writeI32(28)
        if isinstance(value, BdkError.AddressValidator):
            buf.writeI32(29)
        if isinstance(value, BdkError.Encode):
            buf.writeI32(30)
        if isinstance(value, BdkError.Miniscript):
            buf.writeI32(31)
        if isinstance(value, BdkError.Bip32):
            buf.writeI32(32)
        if isinstance(value, BdkError.Secp256k1):
            buf.writeI32(33)
        if isinstance(value, BdkError.Json):
            buf.writeI32(34)
        if isinstance(value, BdkError.Hex):
            buf.writeI32(35)
        if isinstance(value, BdkError.Psbt):
            buf.writeI32(36)
        if isinstance(value, BdkError.PsbtParse):
            buf.writeI32(37)
        if isinstance(value, BdkError.Electrum):
            buf.writeI32(38)
        if isinstance(value, BdkError.Esplora):
            buf.writeI32(39)
        if isinstance(value, BdkError.Sled):
            buf.writeI32(40)
        if isinstance(value, BdkError.Rusqlite):
            buf.writeI32(41)



import threading

class ConcurrentHandleMap:
    """
    A map where inserting, getting and removing data is synchronized with a lock.
    """

    def __init__(self):
        # type Handle = int
        self._left_map = {}  # type: Dict[Handle, Any]
        self._right_map = {}  # type: Dict[Any, Handle]

        self._lock = threading.Lock()
        self._current_handle = 0
        self._stride = 1


    def insert(self, obj):
        with self._lock:
            if obj in self._right_map:
                return self._right_map[obj]
            else:
                handle = self._current_handle
                self._current_handle += self._stride
                self._left_map[handle] = obj
                self._right_map[obj] = handle
                return handle

    def get(self, handle):
        with self._lock:
            return self._left_map.get(handle)

    def remove(self, handle):
        with self._lock:
            if handle in self._left_map:
                obj = self._left_map.pop(handle)
                del self._right_map[obj]
                return obj

# Magic number for the Rust proxy to call using the same mechanism as every other method,
# to free the callback once it's dropped by Rust.
IDX_CALLBACK_FREE = 0

class FfiConverterCallbackInterface:
    _handle_map = ConcurrentHandleMap()

    def __init__(self, cb):
        self._foreign_callback = cb

    def drop(self, handle):
        self.__class__._handle_map.remove(handle)

    @classmethod
    def lift(cls, handle):
        obj = cls._handle_map.get(handle)
        if not obj:
            raise InternalError("The object in the handle map has been dropped already")

        return obj

    @classmethod
    def read(cls, buf):
        handle = buf.readU64()
        cls.lift(handle)

    @classmethod
    def lower(cls, cb):
        handle = cls._handle_map.insert(cb)
        return handle

    @classmethod
    def write(cls, cb, buf):
        buf.writeU64(cls.lower(cb))

# Declaration and FfiConverters for Progress Callback Interface

class Progress:
    def update(progress,message):
        raise NotImplementedError

    

def py_foreignCallbackCallbackInterfaceProgress(handle, method, args, buf_ptr):
    
    def invoke_update(python_callback, args):
        rval = None
        with args.consumeWithStream() as buf:
            rval = python_callback.update(
                FfiConverterFloat.read(buf), 
                FfiConverterOptionalString.read(buf)
                )
        return RustBuffer.alloc(0)
        # TODO catch errors and report them back to Rust.
        # https://github.com/mozilla/uniffi-rs/issues/351
    

    cb = FfiConverterCallbackInterfaceProgress.lift(handle)
    if not cb:
        raise InternalError("No callback in handlemap; this is a Uniffi bug")

    if method == IDX_CALLBACK_FREE:
        FfiConverterCallbackInterfaceProgress.drop(handle)
        # No return value.
        # See docs of ForeignCallback in `uniffi/src/ffi/foreigncallbacks.rs`
        return 0

    if method == 1:
        buf_ptr[0] = invoke_update(cb, args)
        # Value written to out buffer.
        # See docs of ForeignCallback in `uniffi/src/ffi/foreigncallbacks.rs`
        return 1
    

    # This should never happen, because an out of bounds method index won't
    # ever be used. Once we can catch errors, we should return an InternalException.
    # https://github.com/mozilla/uniffi-rs/issues/351

    # An unexpected error happened.
    # See docs of ForeignCallback in `uniffi/src/ffi/foreigncallbacks.rs`
    return -1

# We need to keep this function reference alive:
# if they get GC'd while in use then UniFFI internals could attempt to call a function
# that is in freed memory.
# That would be...uh...bad. Yeah, that's the word. Bad.
foreignCallbackCallbackInterfaceProgress = FOREIGN_CALLBACK_T(py_foreignCallbackCallbackInterfaceProgress)

# The FfiConverter which transforms the Callbacks in to Handles to pass to Rust.
rust_call(lambda err: _UniFFILib.ffi_bdk_8bed_Progress_init_callback(foreignCallbackCallbackInterfaceProgress, err))
FfiConverterCallbackInterfaceProgress = FfiConverterCallbackInterface(foreignCallbackCallbackInterfaceProgress)



class FfiConverterOptionalUInt8(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterUInt8.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterUInt8.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterOptionalUInt64(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterUInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterUInt64.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterOptionalString(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterString.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterString.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterOptionalTypeBlockTime(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterTypeBlockTime.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterTypeBlockTime.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterOptionalCallbackInterfaceProgress(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterCallbackInterfaceProgress.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterCallbackInterfaceProgress.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterSequenceUInt8(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.writeI32(items)
        for item in value:
            FfiConverterUInt8.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.readI32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            FfiConverterUInt8.read(buf) for i in range(count)
        ]



class FfiConverterSequenceTypeAddressAmount(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.writeI32(items)
        for item in value:
            FfiConverterTypeAddressAmount.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.readI32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            FfiConverterTypeAddressAmount.read(buf) for i in range(count)
        ]



class FfiConverterSequenceTypeLocalUtxo(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.writeI32(items)
        for item in value:
            FfiConverterTypeLocalUtxo.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.readI32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            FfiConverterTypeLocalUtxo.read(buf) for i in range(count)
        ]



class FfiConverterSequenceTypeOutPoint(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.writeI32(items)
        for item in value:
            FfiConverterTypeOutPoint.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.readI32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            FfiConverterTypeOutPoint.read(buf) for i in range(count)
        ]



class FfiConverterSequenceTypeTransactionDetails(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.writeI32(items)
        for item in value:
            FfiConverterTypeTransactionDetails.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.readI32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            FfiConverterTypeTransactionDetails.read(buf) for i in range(count)
        ]

def generate_mnemonic(word_count):
    word_count = word_count
    
    return FfiConverterString.lift(rust_call_with_error(FfiConverterTypeBdkError,_UniFFILib.bdk_8bed_generate_mnemonic,
        FfiConverterTypeWordCount.lower(word_count)))



__all__ = [
    "InternalError",
    "AddressIndex",
    "Network",
    "DatabaseConfig",
    "WordCount",
    "BlockchainConfig",
    "KeychainKind",
    "AddressInfo",
    "SledDbConfiguration",
    "SqliteDbConfiguration",
    "Balance",
    "TransactionDetails",
    "BlockTime",
    "ElectrumConfig",
    "EsploraConfig",
    "OutPoint",
    "TxOut",
    "LocalUtxo",
    "AddressAmount",
    "generate_mnemonic",
    "Blockchain",
    "Wallet",
    "PartiallySignedBitcoinTransaction",
    "TxBuilder",
    "BumpFeeTxBuilder",
    "DerivationPath",
    "DescriptorSecretKey",
    "DescriptorPublicKey",
    "BdkError",
    "Progress",
]

