# This file was autogenerated by some hot garbage in the `uniffi` crate.
# Trust me, you don't want to mess with it!

# Common helper code.
#
# Ideally this would live in a separate .py file where it can be unittested etc
# in isolation, and perhaps even published as a re-useable package.
#
# However, it's important that the details of how this helper code works (e.g. the
# way that different builtin types are passed across the FFI) exactly match what's
# expected by the rust code on the other side of the interface. In practice right
# now that means coming from the exact some version of `uniffi` that was used to
# compile the rust component. The easiest way to ensure this is to bundle the Python
# helpers directly inline like we're doing here.

import os
import sys
import ctypes
import enum
import struct
import contextlib
import datetime
import typing
import platform

# Used for default argument values
_DEFAULT = object()


class _UniffiRustBuffer(ctypes.Structure):
    _fields_ = [
        ("capacity", ctypes.c_int32),
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    @staticmethod
    def alloc(size):
        return _rust_call(_UniffiLib.ffi_bdkffi_rustbuffer_alloc, size)

    @staticmethod
    def reserve(rbuf, additional):
        return _rust_call(_UniffiLib.ffi_bdkffi_rustbuffer_reserve, rbuf, additional)

    def free(self):
        return _rust_call(_UniffiLib.ffi_bdkffi_rustbuffer_free, self)

    def __str__(self):
        return "_UniffiRustBuffer(capacity={}, len={}, data={})".format(
            self.capacity,
            self.len,
            self.data[0:self.len]
        )

    @contextlib.contextmanager
    def alloc_with_builder(*args):
        """Context-manger to allocate a buffer using a _UniffiRustBufferBuilder.

        The allocated buffer will be automatically freed if an error occurs, ensuring that
        we don't accidentally leak it.
        """
        builder = _UniffiRustBufferBuilder()
        try:
            yield builder
        except:
            builder.discard()
            raise

    @contextlib.contextmanager
    def consume_with_stream(self):
        """Context-manager to consume a buffer using a _UniffiRustBufferStream.

        The _UniffiRustBuffer will be freed once the context-manager exits, ensuring that we don't
        leak it even if an error occurs.
        """
        try:
            s = _UniffiRustBufferStream.from_rust_buffer(self)
            yield s
            if s.remaining() != 0:
                raise RuntimeError("junk data left in buffer at end of consume_with_stream")
        finally:
            self.free()

    @contextlib.contextmanager
    def read_with_stream(self):
        """Context-manager to read a buffer using a _UniffiRustBufferStream.

        This is like consume_with_stream, but doesn't free the buffer afterwards.
        It should only be used with borrowed `_UniffiRustBuffer` data.
        """
        s = _UniffiRustBufferStream.from_rust_buffer(self)
        yield s
        if s.remaining() != 0:
            raise RuntimeError("junk data left in buffer at end of read_with_stream")

class _UniffiForeignBytes(ctypes.Structure):
    _fields_ = [
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    def __str__(self):
        return "_UniffiForeignBytes(len={}, data={})".format(self.len, self.data[0:self.len])


class _UniffiRustBufferStream:
    """
    Helper for structured reading of bytes from a _UniffiRustBuffer
    """

    def __init__(self, data, len):
        self.data = data
        self.len = len
        self.offset = 0

    @classmethod
    def from_rust_buffer(cls, buf):
        return cls(buf.data, buf.len)

    def remaining(self):
        return self.len - self.offset

    def _unpack_from(self, size, format):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        value = struct.unpack(format, self.data[self.offset:self.offset+size])[0]
        self.offset += size
        return value

    def read(self, size):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        data = self.data[self.offset:self.offset+size]
        self.offset += size
        return data

    def read_i8(self):
        return self._unpack_from(1, ">b")

    def read_u8(self):
        return self._unpack_from(1, ">B")

    def read_i16(self):
        return self._unpack_from(2, ">h")

    def read_u16(self):
        return self._unpack_from(2, ">H")

    def read_i32(self):
        return self._unpack_from(4, ">i")

    def read_u32(self):
        return self._unpack_from(4, ">I")

    def read_i64(self):
        return self._unpack_from(8, ">q")

    def read_u64(self):
        return self._unpack_from(8, ">Q")

    def read_float(self):
        v = self._unpack_from(4, ">f")
        return v

    def read_double(self):
        return self._unpack_from(8, ">d")

    def read_c_size_t(self):
        return self._unpack_from(ctypes.sizeof(ctypes.c_size_t) , "@N")

class _UniffiRustBufferBuilder:
    """
    Helper for structured writing of bytes into a _UniffiRustBuffer.
    """

    def __init__(self):
        self.rbuf = _UniffiRustBuffer.alloc(16)
        self.rbuf.len = 0

    def finalize(self):
        rbuf = self.rbuf
        self.rbuf = None
        return rbuf

    def discard(self):
        if self.rbuf is not None:
            rbuf = self.finalize()
            rbuf.free()

    @contextlib.contextmanager
    def _reserve(self, num_bytes):
        if self.rbuf.len + num_bytes > self.rbuf.capacity:
            self.rbuf = _UniffiRustBuffer.reserve(self.rbuf, num_bytes)
        yield None
        self.rbuf.len += num_bytes

    def _pack_into(self, size, format, value):
        with self._reserve(size):
            # XXX TODO: I feel like I should be able to use `struct.pack_into` here but can't figure it out.
            for i, byte in enumerate(struct.pack(format, value)):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write(self, value):
        with self._reserve(len(value)):
            for i, byte in enumerate(value):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write_i8(self, v):
        self._pack_into(1, ">b", v)

    def write_u8(self, v):
        self._pack_into(1, ">B", v)

    def write_i16(self, v):
        self._pack_into(2, ">h", v)

    def write_u16(self, v):
        self._pack_into(2, ">H", v)

    def write_i32(self, v):
        self._pack_into(4, ">i", v)

    def write_u32(self, v):
        self._pack_into(4, ">I", v)

    def write_i64(self, v):
        self._pack_into(8, ">q", v)

    def write_u64(self, v):
        self._pack_into(8, ">Q", v)

    def write_float(self, v):
        self._pack_into(4, ">f", v)

    def write_double(self, v):
        self._pack_into(8, ">d", v)

    def write_c_size_t(self, v):
        self._pack_into(ctypes.sizeof(ctypes.c_size_t) , "@N", v)
# A handful of classes and functions to support the generated data structures.
# This would be a good candidate for isolating in its own ffi-support lib.

class InternalError(Exception):
    pass

class _UniffiRustCallStatus(ctypes.Structure):
    """
    Error runtime.
    """
    _fields_ = [
        ("code", ctypes.c_int8),
        ("error_buf", _UniffiRustBuffer),
    ]

    # These match the values from the uniffi::rustcalls module
    CALL_SUCCESS = 0
    CALL_ERROR = 1
    CALL_PANIC = 2

    def __str__(self):
        if self.code == _UniffiRustCallStatus.CALL_SUCCESS:
            return "_UniffiRustCallStatus(CALL_SUCCESS)"
        elif self.code == _UniffiRustCallStatus.CALL_ERROR:
            return "_UniffiRustCallStatus(CALL_ERROR)"
        elif self.code == _UniffiRustCallStatus.CALL_PANIC:
            return "_UniffiRustCallStatus(CALL_PANIC)"
        else:
            return "_UniffiRustCallStatus(<invalid code>)"

def _rust_call(fn, *args):
    # Call a rust function
    return _rust_call_with_error(None, fn, *args)

def _rust_call_with_error(error_ffi_converter, fn, *args):
    # Call a rust function and handle any errors
    #
    # This function is used for rust calls that return Result<> and therefore can set the CALL_ERROR status code.
    # error_ffi_converter must be set to the _UniffiConverter for the error class that corresponds to the result.
    call_status = _UniffiRustCallStatus(code=_UniffiRustCallStatus.CALL_SUCCESS, error_buf=_UniffiRustBuffer(0, 0, None))

    args_with_error = args + (ctypes.byref(call_status),)
    result = fn(*args_with_error)
    _uniffi_check_call_status(error_ffi_converter, call_status)
    return result

def _uniffi_check_call_status(error_ffi_converter, call_status):
    if call_status.code == _UniffiRustCallStatus.CALL_SUCCESS:
        pass
    elif call_status.code == _UniffiRustCallStatus.CALL_ERROR:
        if error_ffi_converter is None:
            call_status.error_buf.free()
            raise InternalError("_rust_call_with_error: CALL_ERROR, but error_ffi_converter is None")
        else:
            raise error_ffi_converter.lift(call_status.error_buf)
    elif call_status.code == _UniffiRustCallStatus.CALL_PANIC:
        # When the rust code sees a panic, it tries to construct a _UniffiRustBuffer
        # with the message.  But if that code panics, then it just sends back
        # an empty buffer.
        if call_status.error_buf.len > 0:
            msg = _UniffiConverterString.lift(call_status.error_buf)
        else:
            msg = "Unknown rust panic"
        raise InternalError(msg)
    else:
        raise InternalError("Invalid _UniffiRustCallStatus code: {}".format(
            call_status.code))

# A function pointer for a callback as defined by UniFFI.
# Rust definition `fn(handle: u64, method: u32, args: _UniffiRustBuffer, buf_ptr: *mut _UniffiRustBuffer) -> int`
_UNIFFI_FOREIGN_CALLBACK_T = ctypes.CFUNCTYPE(ctypes.c_int, ctypes.c_ulonglong, ctypes.c_ulong, ctypes.POINTER(ctypes.c_char), ctypes.c_int, ctypes.POINTER(_UniffiRustBuffer))

# UniFFI future continuation
_UNIFFI_FUTURE_CONTINUATION_T = ctypes.CFUNCTYPE(None, ctypes.c_size_t, ctypes.c_int8)
class _UniffiPointerManagerCPython:
    """
    Manage giving out pointers to Python objects on CPython

    This class is used to generate opaque pointers that reference Python objects to pass to Rust.
    It assumes a CPython platform.  See _UniffiPointerManagerGeneral for the alternative.
    """

    def new_pointer(self, obj):
        """
        Get a pointer for an object as a ctypes.c_size_t instance

        Each call to new_pointer() must be balanced with exactly one call to release_pointer()

        This returns a ctypes.c_size_t.  This is always the same size as a pointer and can be
        interchanged with pointers for FFI function arguments and return values.
        """
        # IncRef the object since we're going to pass a pointer to Rust
        ctypes.pythonapi.Py_IncRef(ctypes.py_object(obj))
        # id() is the object address on CPython
        # (https://docs.python.org/3/library/functions.html#id)
        return id(obj)

    def release_pointer(self, address):
        py_obj = ctypes.cast(address, ctypes.py_object)
        obj = py_obj.value
        ctypes.pythonapi.Py_DecRef(py_obj)
        return obj

    def lookup(self, address):
        return ctypes.cast(address, ctypes.py_object).value

class _UniffiPointerManagerGeneral:
    """
    Manage giving out pointers to Python objects on non-CPython platforms

    This has the same API as _UniffiPointerManagerCPython, but doesn't assume we're running on
    CPython and is slightly slower.

    Instead of using real pointers, it maps integer values to objects and returns the keys as
    c_size_t values.
    """

    def __init__(self):
        self._map = {}
        self._lock = threading.Lock()
        self._current_handle = 0

    def new_pointer(self, obj):
        with self._lock:
            handle = self._current_handle
            self._current_handle += 1
            self._map[handle] = obj
        return handle

    def release_pointer(self, handle):
        with self._lock:
            return self._map.pop(handle)

    def lookup(self, handle):
        with self._lock:
            return self._map[handle]

# Pick an pointer manager implementation based on the platform
if platform.python_implementation() == 'CPython':
    _UniffiPointerManager = _UniffiPointerManagerCPython # type: ignore
else:
    _UniffiPointerManager = _UniffiPointerManagerGeneral # type: ignore
# Types conforming to `_UniffiConverterPrimitive` pass themselves directly over the FFI.
class _UniffiConverterPrimitive:
    @classmethod
    def check(cls, value):
        return value

    @classmethod
    def lift(cls, value):
        return value

    @classmethod
    def lower(cls, value):
        return cls.lowerUnchecked(cls.check(value))

    @classmethod
    def lowerUnchecked(cls, value):
        return value

    @classmethod
    def write(cls, value, buf):
        cls.write_unchecked(cls.check(value), buf)

class _UniffiConverterPrimitiveInt(_UniffiConverterPrimitive):
    @classmethod
    def check(cls, value):
        try:
            value = value.__index__()
        except Exception:
            raise TypeError("'{}' object cannot be interpreted as an integer".format(type(value).__name__))
        if not isinstance(value, int):
            raise TypeError("__index__ returned non-int (type {})".format(type(value).__name__))
        if not cls.VALUE_MIN <= value < cls.VALUE_MAX:
            raise ValueError("{} requires {} <= value < {}".format(cls.CLASS_NAME, cls.VALUE_MIN, cls.VALUE_MAX))
        return super().check(value)

class _UniffiConverterPrimitiveFloat(_UniffiConverterPrimitive):
    @classmethod
    def check(cls, value):
        try:
            value = value.__float__()
        except Exception:
            raise TypeError("must be real number, not {}".format(type(value).__name__))
        if not isinstance(value, float):
            raise TypeError("__float__ returned non-float (type {})".format(type(value).__name__))
        return super().check(value)

# Helper class for wrapper types that will always go through a _UniffiRustBuffer.
# Classes should inherit from this and implement the `read` and `write` static methods.
class _UniffiConverterRustBuffer:
    @classmethod
    def lift(cls, rbuf):
        with rbuf.consume_with_stream() as stream:
            return cls.read(stream)

    @classmethod
    def lower(cls, value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            cls.write(value, builder)
            return builder.finalize()

# Contains loading, initialization code, and the FFI Function declarations.
# Define some ctypes FFI types that we use in the library

"""
ctypes type for the foreign executor callback.  This is a built-in interface for scheduling
tasks

Args:
  executor: opaque c_size_t value representing the eventloop
  delay: delay in ms
  task: function pointer to the task callback
  task_data: void pointer to the task callback data

Normally we should call task(task_data) after the detail.
However, when task is NULL this indicates that Rust has dropped the ForeignExecutor and we should
decrease the EventLoop refcount.
"""
_UNIFFI_FOREIGN_EXECUTOR_CALLBACK_T = ctypes.CFUNCTYPE(ctypes.c_int8, ctypes.c_size_t, ctypes.c_uint32, ctypes.c_void_p, ctypes.c_void_p)

"""
Function pointer for a Rust task, which a callback function that takes a opaque pointer
"""
_UNIFFI_RUST_TASK = ctypes.CFUNCTYPE(None, ctypes.c_void_p, ctypes.c_int8)

def _uniffi_future_callback_t(return_type):
    """
    Factory function to create callback function types for async functions
    """
    return ctypes.CFUNCTYPE(None, ctypes.c_size_t, return_type, _UniffiRustCallStatus)

def _uniffi_load_indirect():
    """
    This is how we find and load the dynamic library provided by the component.
    For now we just look it up by name.
    """
    if sys.platform == "darwin":
        libname = "lib{}.dylib"
    elif sys.platform.startswith("win"):
        # As of python3.8, ctypes does not seem to search $PATH when loading DLLs.
        # We could use `os.add_dll_directory` to configure the search path, but
        # it doesn't feel right to mess with application-wide settings. Let's
        # assume that the `.dll` is next to the `.py` file and load by full path.
        libname = os.path.join(
            os.path.dirname(__file__),
            "{}.dll",
        )
    else:
        # Anything else must be an ELF platform - Linux, *BSD, Solaris/illumos
        libname = "lib{}.so"

    libname = libname.format("bdkffi")
    path = os.path.join(os.path.dirname(__file__), libname)
    lib = ctypes.cdll.LoadLibrary(path)
    return lib

def _uniffi_check_contract_api_version(lib):
    # Get the bindings contract version from our ComponentInterface
    bindings_contract_version = 24
    # Get the scaffolding contract version by calling the into the dylib
    scaffolding_contract_version = lib.ffi_bdkffi_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version:
        raise InternalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")

def _uniffi_check_api_checksums(lib):
    if lib.uniffi_bdkffi_checksum_method_address_as_string() != 26179:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_address_network() != 50205:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_address_script_pubkey() != 10722:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_address_to_qr_uri() != 48141:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_balance_confirmed() != 42885:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_balance_immature() != 55250:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_balance_total() != 25835:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_balance_trusted_pending() != 13958:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_balance_trusted_spendable() != 30647:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_balance_untrusted_pending() != 13507:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptor_as_string() != 23756:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptor_as_string_private() != 64930:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptorpublickey_as_string() != 37256:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptorpublickey_derive() != 59387:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptorpublickey_extend() != 41984:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptorsecretkey_as_public() != 56954:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptorsecretkey_as_string() != 28335:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptorsecretkey_derive() != 11887:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptorsecretkey_extend() != 10475:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptorsecretkey_secret_bytes() != 53007:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_esploraclient_broadcast() != 30916:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_esploraclient_scan() != 1824:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_mnemonic_as_string() != 3181:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_partiallysignedtransaction_extract_tx() != 10768:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_partiallysignedtransaction_serialize() != 39126:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_script_to_bytes() != 50761:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_is_coin_base() != 42930:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_is_explicitly_rbf() != 32682:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_is_lock_time_enabled() != 48885:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_size() != 63453:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_txid() != 29904:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_version() != 15271:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_vsize() != 3804:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_add_recipient() != 52335:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_add_unspendable() != 57388:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_add_utxo() != 25330:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_change_policy() != 46562:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_do_not_spend_change() != 51770:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_drain_wallet() != 5081:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_fee_rate() != 62655:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_finish() != 22559:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_manually_selected_only() != 12623:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_only_spend_change() != 18757:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_set_recipients() != 32411:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_apply_update() != 41138:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_get_address() != 41012:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_get_balance() != 28277:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_get_internal_address() != 32658:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_is_mine() != 56329:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_network() != 11273:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_sign() != 61978:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_address_new() != 51980:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_derivationpath_new() != 39111:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptor_new() != 21503:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip44() != 15714:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip44_public() != 1044:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip49() != 4317:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip49_public() != 10961:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip84() != 48893:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip84_public() != 49623:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip86() != 6190:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip86_public() != 8125:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptorpublickey_from_string() != 35396:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptorsecretkey_from_string() != 45930:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptorsecretkey_new() != 58238:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_esploraclient_new() != 45557:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_mnemonic_from_entropy() != 7563:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_mnemonic_from_string() != 381:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_mnemonic_new() != 570:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_partiallysignedtransaction_new() != 44591:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_script_new() != 25525:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_transaction_new() != 23685:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_txbuilder_new() != 978:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_wallet_new_no_persist() != 57682:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")

# A ctypes library to expose the extern-C FFI definitions.
# This is an implementation detail which will be called internally by the public API.

_UniffiLib = _uniffi_load_indirect()
_UniffiLib.uniffi_bdkffi_fn_free_address.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_address.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_address_new.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_address_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_address_as_string.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_address_as_string.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_address_network.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_address_network.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_address_script_pubkey.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_address_script_pubkey.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_address_to_qr_uri.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_address_to_qr_uri.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_free_balance.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_balance.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_balance_confirmed.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_balance_confirmed.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_balance_immature.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_balance_immature.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_balance_total.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_balance_total.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_balance_trusted_pending.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_balance_trusted_pending.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_balance_trusted_spendable.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_balance_trusted_spendable.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_balance_untrusted_pending.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_balance_untrusted_pending.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_free_derivationpath.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_derivationpath.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_derivationpath_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_derivationpath_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_descriptor.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_descriptor.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip44.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip44.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip44_public.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip44_public.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip49.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip49.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip49_public.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip49_public.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip84.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip84.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip84_public.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip84_public.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip86.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip86.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip86_public.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip86_public.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_descriptor_as_string.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptor_as_string.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_descriptor_as_string_private.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptor_as_string_private.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_free_descriptorpublickey.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_descriptorpublickey.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorpublickey_from_string.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorpublickey_from_string.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_as_string.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_as_string.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_derive.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_derive.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_extend.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_extend.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_descriptorsecretkey.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_descriptorsecretkey.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorsecretkey_from_string.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorsecretkey_from_string.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorsecretkey_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorsecretkey_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_as_public.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_as_public.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_as_string.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_as_string.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_derive.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_derive.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_extend.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_extend.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_secret_bytes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_secret_bytes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_free_esploraclient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_esploraclient.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_esploraclient_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_esploraclient_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_broadcast.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_broadcast.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_scan.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_scan.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_mnemonic.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_mnemonic.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_mnemonic_from_entropy.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_mnemonic_from_entropy.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_mnemonic_from_string.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_mnemonic_from_string.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_mnemonic_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_mnemonic_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_mnemonic_as_string.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_mnemonic_as_string.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_free_partiallysignedtransaction.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_partiallysignedtransaction.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_partiallysignedtransaction_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_partiallysignedtransaction_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_partiallysignedtransaction_extract_tx.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_partiallysignedtransaction_extract_tx.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_partiallysignedtransaction_serialize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_partiallysignedtransaction_serialize.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_free_script.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_script.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_script_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_script_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_script_to_bytes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_script_to_bytes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_free_transaction.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_transaction.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_transaction_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_transaction_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_transaction_is_coin_base.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_is_coin_base.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_transaction_is_explicitly_rbf.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_is_explicitly_rbf.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_transaction_is_lock_time_enabled.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_is_lock_time_enabled.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_transaction_size.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_size.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_transaction_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_txid.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_transaction_version.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_version.restype = ctypes.c_int32
_UniffiLib.uniffi_bdkffi_fn_method_transaction_vsize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_vsize.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_free_txbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_txbuilder.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_txbuilder_new.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_txbuilder_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_recipient.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_recipient.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_unspendable.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_unspendable.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_utxo.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_utxo.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_change_policy.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_change_policy.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_do_not_spend_change.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_do_not_spend_change.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_drain_wallet.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_drain_wallet.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_fee_rate.argtypes = (
    ctypes.c_void_p,
    ctypes.c_float,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_fee_rate.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_finish.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_finish.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_manually_selected_only.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_manually_selected_only.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_only_spend_change.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_only_spend_change.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_set_recipients.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_set_recipients.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_update.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_update.restype = None
_UniffiLib.uniffi_bdkffi_fn_free_wallet.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_wallet.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_wallet_new_no_persist.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_wallet_new_no_persist.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_wallet_apply_update.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_apply_update.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_wallet_get_address.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_get_address.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_get_balance.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_get_balance.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_wallet_get_internal_address.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_get_internal_address.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_is_mine.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_is_mine.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_wallet_network.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_network.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_sign.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_sign.restype = ctypes.c_int8
_UniffiLib.ffi_bdkffi_rustbuffer_alloc.argtypes = (
    ctypes.c_int32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rustbuffer_alloc.restype = _UniffiRustBuffer
_UniffiLib.ffi_bdkffi_rustbuffer_from_bytes.argtypes = (
    _UniffiForeignBytes,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rustbuffer_from_bytes.restype = _UniffiRustBuffer
_UniffiLib.ffi_bdkffi_rustbuffer_free.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rustbuffer_free.restype = None
_UniffiLib.ffi_bdkffi_rustbuffer_reserve.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_int32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rustbuffer_reserve.restype = _UniffiRustBuffer
_UniffiLib.ffi_bdkffi_rust_future_continuation_callback_set.argtypes = (
    _UNIFFI_FUTURE_CONTINUATION_T,
)
_UniffiLib.ffi_bdkffi_rust_future_continuation_callback_set.restype = None
_UniffiLib.ffi_bdkffi_rust_future_poll_u8.argtypes = (
    ctypes.c_void_p,
    ctypes.c_size_t,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_u8.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_u8.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_u8.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_u8.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_free_u8.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_u8.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_u8.restype = ctypes.c_uint8
_UniffiLib.ffi_bdkffi_rust_future_poll_i8.argtypes = (
    ctypes.c_void_p,
    ctypes.c_size_t,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_i8.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_i8.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_i8.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_i8.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_free_i8.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_i8.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_i8.restype = ctypes.c_int8
_UniffiLib.ffi_bdkffi_rust_future_poll_u16.argtypes = (
    ctypes.c_void_p,
    ctypes.c_size_t,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_u16.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_u16.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_u16.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_u16.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_free_u16.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_u16.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_u16.restype = ctypes.c_uint16
_UniffiLib.ffi_bdkffi_rust_future_poll_i16.argtypes = (
    ctypes.c_void_p,
    ctypes.c_size_t,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_i16.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_i16.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_i16.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_i16.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_free_i16.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_i16.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_i16.restype = ctypes.c_int16
_UniffiLib.ffi_bdkffi_rust_future_poll_u32.argtypes = (
    ctypes.c_void_p,
    ctypes.c_size_t,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_u32.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_u32.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_u32.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_u32.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_free_u32.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_u32.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_u32.restype = ctypes.c_uint32
_UniffiLib.ffi_bdkffi_rust_future_poll_i32.argtypes = (
    ctypes.c_void_p,
    ctypes.c_size_t,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_i32.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_i32.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_i32.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_i32.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_free_i32.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_i32.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_i32.restype = ctypes.c_int32
_UniffiLib.ffi_bdkffi_rust_future_poll_u64.argtypes = (
    ctypes.c_void_p,
    ctypes.c_size_t,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_u64.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_u64.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_u64.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_u64.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_free_u64.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_u64.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_u64.restype = ctypes.c_uint64
_UniffiLib.ffi_bdkffi_rust_future_poll_i64.argtypes = (
    ctypes.c_void_p,
    ctypes.c_size_t,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_i64.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_i64.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_i64.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_i64.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_free_i64.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_i64.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_i64.restype = ctypes.c_int64
_UniffiLib.ffi_bdkffi_rust_future_poll_f32.argtypes = (
    ctypes.c_void_p,
    ctypes.c_size_t,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_f32.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_f32.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_f32.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_f32.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_free_f32.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_f32.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_f32.restype = ctypes.c_float
_UniffiLib.ffi_bdkffi_rust_future_poll_f64.argtypes = (
    ctypes.c_void_p,
    ctypes.c_size_t,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_f64.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_f64.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_f64.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_f64.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_free_f64.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_f64.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_f64.restype = ctypes.c_double
_UniffiLib.ffi_bdkffi_rust_future_poll_pointer.argtypes = (
    ctypes.c_void_p,
    ctypes.c_size_t,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_pointer.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_pointer.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_pointer.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_pointer.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_free_pointer.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_pointer.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_pointer.restype = ctypes.c_void_p
_UniffiLib.ffi_bdkffi_rust_future_poll_rust_buffer.argtypes = (
    ctypes.c_void_p,
    ctypes.c_size_t,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_rust_buffer.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_rust_buffer.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_rust_buffer.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_rust_buffer.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_free_rust_buffer.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_rust_buffer.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_rust_buffer.restype = _UniffiRustBuffer
_UniffiLib.ffi_bdkffi_rust_future_poll_void.argtypes = (
    ctypes.c_void_p,
    ctypes.c_size_t,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_void.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_void.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_void.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_void.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.ffi_bdkffi_rust_future_free_void.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_void.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_void.restype = None
_UniffiLib.uniffi_bdkffi_checksum_method_address_as_string.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_address_as_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_address_network.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_address_network.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_address_script_pubkey.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_address_script_pubkey.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_address_to_qr_uri.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_address_to_qr_uri.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_balance_confirmed.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_balance_confirmed.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_balance_immature.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_balance_immature.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_balance_total.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_balance_total.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_balance_trusted_pending.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_balance_trusted_pending.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_balance_trusted_spendable.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_balance_trusted_spendable.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_balance_untrusted_pending.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_balance_untrusted_pending.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptor_as_string.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptor_as_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptor_as_string_private.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptor_as_string_private.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorpublickey_as_string.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorpublickey_as_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorpublickey_derive.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorpublickey_derive.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorpublickey_extend.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorpublickey_extend.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorsecretkey_as_public.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorsecretkey_as_public.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorsecretkey_as_string.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorsecretkey_as_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorsecretkey_derive.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorsecretkey_derive.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorsecretkey_extend.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorsecretkey_extend.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorsecretkey_secret_bytes.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorsecretkey_secret_bytes.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_broadcast.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_broadcast.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_scan.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_scan.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_mnemonic_as_string.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_mnemonic_as_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_partiallysignedtransaction_extract_tx.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_partiallysignedtransaction_extract_tx.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_partiallysignedtransaction_serialize.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_partiallysignedtransaction_serialize.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_script_to_bytes.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_script_to_bytes.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_is_coin_base.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_is_coin_base.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_is_explicitly_rbf.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_is_explicitly_rbf.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_is_lock_time_enabled.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_is_lock_time_enabled.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_size.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_size.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_txid.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_txid.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_version.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_version.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_vsize.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_vsize.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_add_recipient.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_add_recipient.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_add_unspendable.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_add_unspendable.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_add_utxo.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_add_utxo.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_change_policy.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_change_policy.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_do_not_spend_change.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_do_not_spend_change.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_drain_wallet.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_drain_wallet.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_fee_rate.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_fee_rate.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_finish.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_finish.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_manually_selected_only.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_manually_selected_only.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_only_spend_change.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_only_spend_change.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_set_recipients.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_set_recipients.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_apply_update.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_apply_update.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_get_address.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_get_address.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_get_balance.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_get_balance.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_get_internal_address.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_get_internal_address.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_is_mine.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_is_mine.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_network.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_network.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_sign.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_sign.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_address_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_address_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_derivationpath_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_derivationpath_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip44.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip44.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip44_public.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip44_public.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip49.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip49.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip49_public.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip49_public.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip84.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip84.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip84_public.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip84_public.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip86.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip86.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip86_public.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip86_public.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptorpublickey_from_string.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptorpublickey_from_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptorsecretkey_from_string.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptorsecretkey_from_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptorsecretkey_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptorsecretkey_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_esploraclient_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_esploraclient_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_mnemonic_from_entropy.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_mnemonic_from_entropy.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_mnemonic_from_string.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_mnemonic_from_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_mnemonic_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_mnemonic_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_partiallysignedtransaction_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_partiallysignedtransaction_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_script_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_script_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_transaction_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_transaction_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_txbuilder_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_txbuilder_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_wallet_new_no_persist.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_wallet_new_no_persist.restype = ctypes.c_uint16
_UniffiLib.ffi_bdkffi_uniffi_contract_version.argtypes = (
)
_UniffiLib.ffi_bdkffi_uniffi_contract_version.restype = ctypes.c_uint32
_uniffi_check_contract_api_version(_UniffiLib)
_uniffi_check_api_checksums(_UniffiLib)

# Async support

# Public interface members begin here.


class _UniffiConverterUInt8(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u8"
    VALUE_MIN = 0
    VALUE_MAX = 2**8

    @staticmethod
    def read(buf):
        return buf.read_u8()

    @staticmethod
    def write_unchecked(value, buf):
        buf.write_u8(value)

class _UniffiConverterUInt32(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u32"
    VALUE_MIN = 0
    VALUE_MAX = 2**32

    @staticmethod
    def read(buf):
        return buf.read_u32()

    @staticmethod
    def write_unchecked(value, buf):
        buf.write_u32(value)

class _UniffiConverterInt32(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "i32"
    VALUE_MIN = -2**31
    VALUE_MAX = 2**31

    @staticmethod
    def read(buf):
        return buf.read_i32()

    @staticmethod
    def write_unchecked(value, buf):
        buf.write_i32(value)

class _UniffiConverterUInt64(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u64"
    VALUE_MIN = 0
    VALUE_MAX = 2**64

    @staticmethod
    def read(buf):
        return buf.read_u64()

    @staticmethod
    def write_unchecked(value, buf):
        buf.write_u64(value)

class _UniffiConverterFloat(_UniffiConverterPrimitiveFloat):
    @staticmethod
    def read(buf):
        return buf.read_float()

    @staticmethod
    def write_unchecked(value, buf):
        buf.write_float(value)

class _UniffiConverterBool(_UniffiConverterPrimitive):
    @classmethod
    def check(cls, value):
        return not not value

    @classmethod
    def read(cls, buf):
        return cls.lift(buf.read_u8())

    @classmethod
    def write_unchecked(cls, value, buf):
        buf.write_u8(value)

    @staticmethod
    def lift(value):
        return value != 0

class _UniffiConverterString:
    @staticmethod
    def check(value):
        if not isinstance(value, str):
            raise TypeError("argument must be str, not {}".format(type(value).__name__))
        return value

    @staticmethod
    def read(buf):
        size = buf.read_i32()
        if size < 0:
            raise InternalError("Unexpected negative string length")
        utf8_bytes = buf.read(size)
        return utf8_bytes.decode("utf-8")

    @staticmethod
    def write(value, buf):
        value = _UniffiConverterString.check(value)
        utf8_bytes = value.encode("utf-8")
        buf.write_i32(len(utf8_bytes))
        buf.write(utf8_bytes)

    @staticmethod
    def lift(buf):
        with buf.consume_with_stream() as stream:
            return stream.read(stream.remaining()).decode("utf-8")

    @staticmethod
    def lower(value):
        value = _UniffiConverterString.check(value)
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            builder.write(value.encode("utf-8"))
            return builder.finalize()



class Address:
    _pointer: ctypes.c_void_p
    def __init__(self, address: "str",network: "Network"):
        
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_constructor_address_new,
        _UniffiConverterString.lower(address),
        _UniffiConverterTypeNetwork.lower(network))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_free_address, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def as_string(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_address_as_string,self._pointer,)
        )






    def network(self, ) -> "Network":
        return _UniffiConverterTypeNetwork.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_address_network,self._pointer,)
        )






    def script_pubkey(self, ) -> "Script":
        return _UniffiConverterTypeScript.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_address_script_pubkey,self._pointer,)
        )






    def to_qr_uri(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_address_to_qr_uri,self._pointer,)
        )






class _UniffiConverterTypeAddress:
    @classmethod
    def read(cls, buf):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Address):
            raise TypeError("Expected Address instance, {} found".format(type(value).__name__))
        buf.write_u64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Address._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class Balance:
    _pointer: ctypes.c_void_p

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_free_balance, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def confirmed(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_balance_confirmed,self._pointer,)
        )






    def immature(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_balance_immature,self._pointer,)
        )






    def total(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_balance_total,self._pointer,)
        )






    def trusted_pending(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_balance_trusted_pending,self._pointer,)
        )






    def trusted_spendable(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_balance_trusted_spendable,self._pointer,)
        )






    def untrusted_pending(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_balance_untrusted_pending,self._pointer,)
        )






class _UniffiConverterTypeBalance:
    @classmethod
    def read(cls, buf):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Balance):
            raise TypeError("Expected Balance instance, {} found".format(type(value).__name__))
        buf.write_u64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Balance._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class DerivationPath:
    _pointer: ctypes.c_void_p
    def __init__(self, path: "str"):
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_constructor_derivationpath_new,
        _UniffiConverterString.lower(path))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_free_derivationpath, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


class _UniffiConverterTypeDerivationPath:
    @classmethod
    def read(cls, buf):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, DerivationPath):
            raise TypeError("Expected DerivationPath instance, {} found".format(type(value).__name__))
        buf.write_u64(cls.lower(value))

    @staticmethod
    def lift(value):
        return DerivationPath._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class Descriptor:
    _pointer: ctypes.c_void_p
    def __init__(self, descriptor: "str",network: "Network"):
        
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new,
        _UniffiConverterString.lower(descriptor),
        _UniffiConverterTypeNetwork.lower(network))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_free_descriptor, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def new_bip44(cls, secret_key: "DescriptorSecretKey",keychain: "KeychainKind",network: "Network"):
        
        
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip44,
        _UniffiConverterTypeDescriptorSecretKey.lower(secret_key),
        _UniffiConverterTypeKeychainKind.lower(keychain),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)


    @classmethod
    def new_bip44_public(cls, public_key: "DescriptorPublicKey",fingerprint: "str",keychain: "KeychainKind",network: "Network"):
        
        
        
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip44_public,
        _UniffiConverterTypeDescriptorPublicKey.lower(public_key),
        _UniffiConverterString.lower(fingerprint),
        _UniffiConverterTypeKeychainKind.lower(keychain),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)


    @classmethod
    def new_bip49(cls, secret_key: "DescriptorSecretKey",keychain: "KeychainKind",network: "Network"):
        
        
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip49,
        _UniffiConverterTypeDescriptorSecretKey.lower(secret_key),
        _UniffiConverterTypeKeychainKind.lower(keychain),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)


    @classmethod
    def new_bip49_public(cls, public_key: "DescriptorPublicKey",fingerprint: "str",keychain: "KeychainKind",network: "Network"):
        
        
        
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip49_public,
        _UniffiConverterTypeDescriptorPublicKey.lower(public_key),
        _UniffiConverterString.lower(fingerprint),
        _UniffiConverterTypeKeychainKind.lower(keychain),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)


    @classmethod
    def new_bip84(cls, secret_key: "DescriptorSecretKey",keychain: "KeychainKind",network: "Network"):
        
        
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip84,
        _UniffiConverterTypeDescriptorSecretKey.lower(secret_key),
        _UniffiConverterTypeKeychainKind.lower(keychain),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)


    @classmethod
    def new_bip84_public(cls, public_key: "DescriptorPublicKey",fingerprint: "str",keychain: "KeychainKind",network: "Network"):
        
        
        
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip84_public,
        _UniffiConverterTypeDescriptorPublicKey.lower(public_key),
        _UniffiConverterString.lower(fingerprint),
        _UniffiConverterTypeKeychainKind.lower(keychain),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)


    @classmethod
    def new_bip86(cls, secret_key: "DescriptorSecretKey",keychain: "KeychainKind",network: "Network"):
        
        
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip86,
        _UniffiConverterTypeDescriptorSecretKey.lower(secret_key),
        _UniffiConverterTypeKeychainKind.lower(keychain),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)


    @classmethod
    def new_bip86_public(cls, public_key: "DescriptorPublicKey",fingerprint: "str",keychain: "KeychainKind",network: "Network"):
        
        
        
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip86_public,
        _UniffiConverterTypeDescriptorPublicKey.lower(public_key),
        _UniffiConverterString.lower(fingerprint),
        _UniffiConverterTypeKeychainKind.lower(keychain),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)



    def as_string(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptor_as_string,self._pointer,)
        )






    def as_string_private(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptor_as_string_private,self._pointer,)
        )






class _UniffiConverterTypeDescriptor:
    @classmethod
    def read(cls, buf):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Descriptor):
            raise TypeError("Expected Descriptor instance, {} found".format(type(value).__name__))
        buf.write_u64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Descriptor._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class DescriptorPublicKey:
    _pointer: ctypes.c_void_p

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_free_descriptorpublickey, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def from_string(cls, public_key: "str"):
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _rust_call_with_error(_UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorpublickey_from_string,
        _UniffiConverterString.lower(public_key))
        return cls._make_instance_(pointer)



    def as_string(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_as_string,self._pointer,)
        )






    def derive(self, path: "DerivationPath") -> "DescriptorPublicKey":
        
        return _UniffiConverterTypeDescriptorPublicKey.lift(
            _rust_call_with_error(
    _UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_derive,self._pointer,
        _UniffiConverterTypeDerivationPath.lower(path))
        )






    def extend(self, path: "DerivationPath") -> "DescriptorPublicKey":
        
        return _UniffiConverterTypeDescriptorPublicKey.lift(
            _rust_call_with_error(
    _UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_extend,self._pointer,
        _UniffiConverterTypeDerivationPath.lower(path))
        )






class _UniffiConverterTypeDescriptorPublicKey:
    @classmethod
    def read(cls, buf):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, DescriptorPublicKey):
            raise TypeError("Expected DescriptorPublicKey instance, {} found".format(type(value).__name__))
        buf.write_u64(cls.lower(value))

    @staticmethod
    def lift(value):
        return DescriptorPublicKey._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class DescriptorSecretKey:
    _pointer: ctypes.c_void_p
    def __init__(self, network: "Network",mnemonic: "Mnemonic",password: "typing.Optional[str]"):
        
        
        
        self._pointer = _rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorsecretkey_new,
        _UniffiConverterTypeNetwork.lower(network),
        _UniffiConverterTypeMnemonic.lower(mnemonic),
        _UniffiConverterOptionalString.lower(password))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_free_descriptorsecretkey, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def from_string(cls, secret_key: "str"):
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _rust_call_with_error(_UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorsecretkey_from_string,
        _UniffiConverterString.lower(secret_key))
        return cls._make_instance_(pointer)



    def as_public(self, ) -> "DescriptorPublicKey":
        return _UniffiConverterTypeDescriptorPublicKey.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_as_public,self._pointer,)
        )






    def as_string(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_as_string,self._pointer,)
        )






    def derive(self, path: "DerivationPath") -> "DescriptorSecretKey":
        
        return _UniffiConverterTypeDescriptorSecretKey.lift(
            _rust_call_with_error(
    _UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_derive,self._pointer,
        _UniffiConverterTypeDerivationPath.lower(path))
        )






    def extend(self, path: "DerivationPath") -> "DescriptorSecretKey":
        
        return _UniffiConverterTypeDescriptorSecretKey.lift(
            _rust_call_with_error(
    _UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_extend,self._pointer,
        _UniffiConverterTypeDerivationPath.lower(path))
        )






    def secret_bytes(self, ) -> "typing.List[int]":
        return _UniffiConverterSequenceUInt8.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_secret_bytes,self._pointer,)
        )






class _UniffiConverterTypeDescriptorSecretKey:
    @classmethod
    def read(cls, buf):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, DescriptorSecretKey):
            raise TypeError("Expected DescriptorSecretKey instance, {} found".format(type(value).__name__))
        buf.write_u64(cls.lower(value))

    @staticmethod
    def lift(value):
        return DescriptorSecretKey._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class EsploraClient:
    _pointer: ctypes.c_void_p
    def __init__(self, url: "str"):
        
        self._pointer = _rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_esploraclient_new,
        _UniffiConverterString.lower(url))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_free_esploraclient, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def broadcast(self, transaction: "Transaction"):
        
        _rust_call_with_error(
    _UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_broadcast,self._pointer,
        _UniffiConverterTypeTransaction.lower(transaction))







    def scan(self, wallet: "Wallet",stop_gap: "int",parallel_requests: "int") -> "Update":
        
        
        
        return _UniffiConverterTypeUpdate.lift(
            _rust_call_with_error(
    _UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_scan,self._pointer,
        _UniffiConverterTypeWallet.lower(wallet),
        _UniffiConverterUInt64.lower(stop_gap),
        _UniffiConverterUInt64.lower(parallel_requests))
        )






class _UniffiConverterTypeEsploraClient:
    @classmethod
    def read(cls, buf):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, EsploraClient):
            raise TypeError("Expected EsploraClient instance, {} found".format(type(value).__name__))
        buf.write_u64(cls.lower(value))

    @staticmethod
    def lift(value):
        return EsploraClient._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class Mnemonic:
    _pointer: ctypes.c_void_p
    def __init__(self, word_count: "WordCount"):
        
        self._pointer = _rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_mnemonic_new,
        _UniffiConverterTypeWordCount.lower(word_count))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_free_mnemonic, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def from_entropy(cls, entropy: "typing.List[int]"):
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _rust_call_with_error(_UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_constructor_mnemonic_from_entropy,
        _UniffiConverterSequenceUInt8.lower(entropy))
        return cls._make_instance_(pointer)


    @classmethod
    def from_string(cls, mnemonic: "str"):
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _rust_call_with_error(_UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_constructor_mnemonic_from_string,
        _UniffiConverterString.lower(mnemonic))
        return cls._make_instance_(pointer)



    def as_string(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_mnemonic_as_string,self._pointer,)
        )






class _UniffiConverterTypeMnemonic:
    @classmethod
    def read(cls, buf):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Mnemonic):
            raise TypeError("Expected Mnemonic instance, {} found".format(type(value).__name__))
        buf.write_u64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Mnemonic._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class PartiallySignedTransaction:
    _pointer: ctypes.c_void_p
    def __init__(self, psbt_base64: "str"):
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_constructor_partiallysignedtransaction_new,
        _UniffiConverterString.lower(psbt_base64))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_free_partiallysignedtransaction, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def extract_tx(self, ) -> "Transaction":
        return _UniffiConverterTypeTransaction.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_partiallysignedtransaction_extract_tx,self._pointer,)
        )






    def serialize(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_partiallysignedtransaction_serialize,self._pointer,)
        )






class _UniffiConverterTypePartiallySignedTransaction:
    @classmethod
    def read(cls, buf):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, PartiallySignedTransaction):
            raise TypeError("Expected PartiallySignedTransaction instance, {} found".format(type(value).__name__))
        buf.write_u64(cls.lower(value))

    @staticmethod
    def lift(value):
        return PartiallySignedTransaction._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class Script:
    _pointer: ctypes.c_void_p
    def __init__(self, raw_output_script: "typing.List[int]"):
        
        self._pointer = _rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_script_new,
        _UniffiConverterSequenceUInt8.lower(raw_output_script))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_free_script, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def to_bytes(self, ) -> "typing.List[int]":
        return _UniffiConverterSequenceUInt8.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_script_to_bytes,self._pointer,)
        )






class _UniffiConverterTypeScript:
    @classmethod
    def read(cls, buf):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Script):
            raise TypeError("Expected Script instance, {} found".format(type(value).__name__))
        buf.write_u64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Script._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class Transaction:
    _pointer: ctypes.c_void_p
    def __init__(self, transaction_bytes: "typing.List[int]"):
        
        self._pointer = _rust_call_with_error(_UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_constructor_transaction_new,
        _UniffiConverterSequenceUInt8.lower(transaction_bytes))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_free_transaction, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def is_coin_base(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_is_coin_base,self._pointer,)
        )






    def is_explicitly_rbf(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_is_explicitly_rbf,self._pointer,)
        )






    def is_lock_time_enabled(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_is_lock_time_enabled,self._pointer,)
        )






    def size(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_size,self._pointer,)
        )






    def txid(self, ) -> "str":
        return _UniffiConverterString.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_txid,self._pointer,)
        )






    def version(self, ) -> "int":
        return _UniffiConverterInt32.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_version,self._pointer,)
        )






    def vsize(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_vsize,self._pointer,)
        )






class _UniffiConverterTypeTransaction:
    @classmethod
    def read(cls, buf):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Transaction):
            raise TypeError("Expected Transaction instance, {} found".format(type(value).__name__))
        buf.write_u64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Transaction._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class TxBuilder:
    _pointer: ctypes.c_void_p
    def __init__(self, ):
        self._pointer = _rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_txbuilder_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_free_txbuilder, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def add_recipient(self, script: "Script",amount: "int") -> "TxBuilder":
        
        
        return _UniffiConverterTypeTxBuilder.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_recipient,self._pointer,
        _UniffiConverterTypeScript.lower(script),
        _UniffiConverterUInt64.lower(amount))
        )






    def add_unspendable(self, unspendable: "OutPoint") -> "TxBuilder":
        
        return _UniffiConverterTypeTxBuilder.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_unspendable,self._pointer,
        _UniffiConverterTypeOutPoint.lower(unspendable))
        )






    def add_utxo(self, outpoint: "OutPoint") -> "TxBuilder":
        
        return _UniffiConverterTypeTxBuilder.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_utxo,self._pointer,
        _UniffiConverterTypeOutPoint.lower(outpoint))
        )






    def change_policy(self, change_policy: "ChangeSpendPolicy") -> "TxBuilder":
        
        return _UniffiConverterTypeTxBuilder.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_change_policy,self._pointer,
        _UniffiConverterTypeChangeSpendPolicy.lower(change_policy))
        )






    def do_not_spend_change(self, ) -> "TxBuilder":
        return _UniffiConverterTypeTxBuilder.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_do_not_spend_change,self._pointer,)
        )






    def drain_wallet(self, ) -> "TxBuilder":
        return _UniffiConverterTypeTxBuilder.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_drain_wallet,self._pointer,)
        )






    def fee_rate(self, sat_per_vbyte: "float") -> "TxBuilder":
        
        return _UniffiConverterTypeTxBuilder.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_fee_rate,self._pointer,
        _UniffiConverterFloat.lower(sat_per_vbyte))
        )






    def finish(self, wallet: "Wallet") -> "PartiallySignedTransaction":
        
        return _UniffiConverterTypePartiallySignedTransaction.lift(
            _rust_call_with_error(
    _UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_finish,self._pointer,
        _UniffiConverterTypeWallet.lower(wallet))
        )






    def manually_selected_only(self, ) -> "TxBuilder":
        return _UniffiConverterTypeTxBuilder.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_manually_selected_only,self._pointer,)
        )






    def only_spend_change(self, ) -> "TxBuilder":
        return _UniffiConverterTypeTxBuilder.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_only_spend_change,self._pointer,)
        )






    def set_recipients(self, script_amount: "typing.List[ScriptAmount]") -> "TxBuilder":
        
        return _UniffiConverterTypeTxBuilder.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_set_recipients,self._pointer,
        _UniffiConverterSequenceTypeScriptAmount.lower(script_amount))
        )






class _UniffiConverterTypeTxBuilder:
    @classmethod
    def read(cls, buf):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, TxBuilder):
            raise TypeError("Expected TxBuilder instance, {} found".format(type(value).__name__))
        buf.write_u64(cls.lower(value))

    @staticmethod
    def lift(value):
        return TxBuilder._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class Update:
    _pointer: ctypes.c_void_p

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_free_update, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


class _UniffiConverterTypeUpdate:
    @classmethod
    def read(cls, buf):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Update):
            raise TypeError("Expected Update instance, {} found".format(type(value).__name__))
        buf.write_u64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Update._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class Wallet:
    _pointer: ctypes.c_void_p

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_free_wallet, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def new_no_persist(cls, descriptor: "Descriptor",change_descriptor: "typing.Optional[Descriptor]",network: "Network"):
        
        
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _rust_call_with_error(_UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_constructor_wallet_new_no_persist,
        _UniffiConverterTypeDescriptor.lower(descriptor),
        _UniffiConverterOptionalTypeDescriptor.lower(change_descriptor),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)



    def apply_update(self, update: "Update"):
        
        _rust_call_with_error(
    _UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_method_wallet_apply_update,self._pointer,
        _UniffiConverterTypeUpdate.lower(update))







    def get_address(self, address_index: "AddressIndex") -> "AddressInfo":
        
        return _UniffiConverterTypeAddressInfo.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_get_address,self._pointer,
        _UniffiConverterTypeAddressIndex.lower(address_index))
        )






    def get_balance(self, ) -> "Balance":
        return _UniffiConverterTypeBalance.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_get_balance,self._pointer,)
        )






    def get_internal_address(self, address_index: "AddressIndex") -> "AddressInfo":
        
        return _UniffiConverterTypeAddressInfo.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_get_internal_address,self._pointer,
        _UniffiConverterTypeAddressIndex.lower(address_index))
        )






    def is_mine(self, script: "Script") -> "bool":
        
        return _UniffiConverterBool.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_is_mine,self._pointer,
        _UniffiConverterTypeScript.lower(script))
        )






    def network(self, ) -> "Network":
        return _UniffiConverterTypeNetwork.lift(
            _rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_network,self._pointer,)
        )






    def sign(self, psbt: "PartiallySignedTransaction") -> "bool":
        
        return _UniffiConverterBool.lift(
            _rust_call_with_error(
    _UniffiConverterTypeBdkError,_UniffiLib.uniffi_bdkffi_fn_method_wallet_sign,self._pointer,
        _UniffiConverterTypePartiallySignedTransaction.lower(psbt))
        )






class _UniffiConverterTypeWallet:
    @classmethod
    def read(cls, buf):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Wallet):
            raise TypeError("Expected Wallet instance, {} found".format(type(value).__name__))
        buf.write_u64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Wallet._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer


class AddressInfo:
    index: "int";address: "Address";keychain: "KeychainKind";

    @typing.no_type_check
    def __init__(self, index: "int", address: "Address", keychain: "KeychainKind"):
        self.index = index
        self.address = address
        self.keychain = keychain

    def __str__(self):
        return "AddressInfo(index={}, address={}, keychain={})".format(self.index, self.address, self.keychain)

    def __eq__(self, other):
        if self.index != other.index:
            return False
        if self.address != other.address:
            return False
        if self.keychain != other.keychain:
            return False
        return True

class _UniffiConverterTypeAddressInfo(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return AddressInfo(
            index=_UniffiConverterUInt32.read(buf),
            address=_UniffiConverterTypeAddress.read(buf),
            keychain=_UniffiConverterTypeKeychainKind.read(buf),
        )

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.index, buf)
        _UniffiConverterTypeAddress.write(value.address, buf)
        _UniffiConverterTypeKeychainKind.write(value.keychain, buf)


class OutPoint:
    txid: "str";vout: "int";

    @typing.no_type_check
    def __init__(self, txid: "str", vout: "int"):
        self.txid = txid
        self.vout = vout

    def __str__(self):
        return "OutPoint(txid={}, vout={})".format(self.txid, self.vout)

    def __eq__(self, other):
        if self.txid != other.txid:
            return False
        if self.vout != other.vout:
            return False
        return True

class _UniffiConverterTypeOutPoint(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return OutPoint(
            txid=_UniffiConverterString.read(buf),
            vout=_UniffiConverterUInt32.read(buf),
        )

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.txid, buf)
        _UniffiConverterUInt32.write(value.vout, buf)


class ScriptAmount:
    script: "Script";amount: "int";

    @typing.no_type_check
    def __init__(self, script: "Script", amount: "int"):
        self.script = script
        self.amount = amount

    def __str__(self):
        return "ScriptAmount(script={}, amount={})".format(self.script, self.amount)

    def __eq__(self, other):
        if self.script != other.script:
            return False
        if self.amount != other.amount:
            return False
        return True

class _UniffiConverterTypeScriptAmount(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ScriptAmount(
            script=_UniffiConverterTypeScript.read(buf),
            amount=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeScript.write(value.script, buf)
        _UniffiConverterUInt64.write(value.amount, buf)





class AddressIndex:
    def __init__(self):
        raise RuntimeError("AddressIndex cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class NEW:
        

        @typing.no_type_check
        def __init__(self,):
            
            pass
            

        def __str__(self):
            return "AddressIndex.NEW()".format()

        def __eq__(self, other):
            if not other.is_new():
                return False
            return True
    class LAST_UNUSED:
        

        @typing.no_type_check
        def __init__(self,):
            
            pass
            

        def __str__(self):
            return "AddressIndex.LAST_UNUSED()".format()

        def __eq__(self, other):
            if not other.is_last_unused():
                return False
            return True
    class PEEK:
        index: "int";

        @typing.no_type_check
        def __init__(self,index: "int"):
            
            self.index = index
            

        def __str__(self):
            return "AddressIndex.PEEK(index={})".format(self.index)

        def __eq__(self, other):
            if not other.is_peek():
                return False
            if self.index != other.index:
                return False
            return True
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_new(self) -> bool:
        return isinstance(self, AddressIndex.NEW)
    def is_last_unused(self) -> bool:
        return isinstance(self, AddressIndex.LAST_UNUSED)
    def is_peek(self) -> bool:
        return isinstance(self, AddressIndex.PEEK)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
AddressIndex.NEW = type("AddressIndex.NEW", (AddressIndex.NEW, AddressIndex,), {})  # type: ignore
AddressIndex.LAST_UNUSED = type("AddressIndex.LAST_UNUSED", (AddressIndex.LAST_UNUSED, AddressIndex,), {})  # type: ignore
AddressIndex.PEEK = type("AddressIndex.PEEK", (AddressIndex.PEEK, AddressIndex,), {})  # type: ignore




class _UniffiConverterTypeAddressIndex(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return AddressIndex.NEW(
            )
        if variant == 2:
            return AddressIndex.LAST_UNUSED(
            )
        if variant == 3:
            return AddressIndex.PEEK(
                _UniffiConverterUInt32.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value.is_new():
            buf.write_i32(1)
        if value.is_last_unused():
            buf.write_i32(2)
        if value.is_peek():
            buf.write_i32(3)
            _UniffiConverterUInt32.write(value.index, buf)



# BdkError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class BdkError(Exception):
    pass

_UniffiTempBdkError = BdkError

class BdkError:  # type: ignore
    class Generic(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.Generic({})".format(repr(str(self)))
    _UniffiTempBdkError.Generic = Generic # type: ignore
    class NoRecipients(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.NoRecipients({})".format(repr(str(self)))
    _UniffiTempBdkError.NoRecipients = NoRecipients # type: ignore
    class NoUtxosSelected(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.NoUtxosSelected({})".format(repr(str(self)))
    _UniffiTempBdkError.NoUtxosSelected = NoUtxosSelected # type: ignore
    class OutputBelowDustLimit(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.OutputBelowDustLimit({})".format(repr(str(self)))
    _UniffiTempBdkError.OutputBelowDustLimit = OutputBelowDustLimit # type: ignore
    class InsufficientFunds(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.InsufficientFunds({})".format(repr(str(self)))
    _UniffiTempBdkError.InsufficientFunds = InsufficientFunds # type: ignore
    class BnBTotalTriesExceeded(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.BnBTotalTriesExceeded({})".format(repr(str(self)))
    _UniffiTempBdkError.BnBTotalTriesExceeded = BnBTotalTriesExceeded # type: ignore
    class BnBNoExactMatch(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.BnBNoExactMatch({})".format(repr(str(self)))
    _UniffiTempBdkError.BnBNoExactMatch = BnBNoExactMatch # type: ignore
    class UnknownUtxo(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.UnknownUtxo({})".format(repr(str(self)))
    _UniffiTempBdkError.UnknownUtxo = UnknownUtxo # type: ignore
    class TransactionNotFound(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.TransactionNotFound({})".format(repr(str(self)))
    _UniffiTempBdkError.TransactionNotFound = TransactionNotFound # type: ignore
    class TransactionConfirmed(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.TransactionConfirmed({})".format(repr(str(self)))
    _UniffiTempBdkError.TransactionConfirmed = TransactionConfirmed # type: ignore
    class IrreplaceableTransaction(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.IrreplaceableTransaction({})".format(repr(str(self)))
    _UniffiTempBdkError.IrreplaceableTransaction = IrreplaceableTransaction # type: ignore
    class FeeRateTooLow(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.FeeRateTooLow({})".format(repr(str(self)))
    _UniffiTempBdkError.FeeRateTooLow = FeeRateTooLow # type: ignore
    class FeeTooLow(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.FeeTooLow({})".format(repr(str(self)))
    _UniffiTempBdkError.FeeTooLow = FeeTooLow # type: ignore
    class FeeRateUnavailable(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.FeeRateUnavailable({})".format(repr(str(self)))
    _UniffiTempBdkError.FeeRateUnavailable = FeeRateUnavailable # type: ignore
    class MissingKeyOrigin(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.MissingKeyOrigin({})".format(repr(str(self)))
    _UniffiTempBdkError.MissingKeyOrigin = MissingKeyOrigin # type: ignore
    class Key(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.Key({})".format(repr(str(self)))
    _UniffiTempBdkError.Key = Key # type: ignore
    class ChecksumMismatch(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.ChecksumMismatch({})".format(repr(str(self)))
    _UniffiTempBdkError.ChecksumMismatch = ChecksumMismatch # type: ignore
    class SpendingPolicyRequired(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.SpendingPolicyRequired({})".format(repr(str(self)))
    _UniffiTempBdkError.SpendingPolicyRequired = SpendingPolicyRequired # type: ignore
    class InvalidPolicyPathError(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.InvalidPolicyPathError({})".format(repr(str(self)))
    _UniffiTempBdkError.InvalidPolicyPathError = InvalidPolicyPathError # type: ignore
    class Signer(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.Signer({})".format(repr(str(self)))
    _UniffiTempBdkError.Signer = Signer # type: ignore
    class InvalidOutpoint(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.InvalidOutpoint({})".format(repr(str(self)))
    _UniffiTempBdkError.InvalidOutpoint = InvalidOutpoint # type: ignore
    class Descriptor(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.Descriptor({})".format(repr(str(self)))
    _UniffiTempBdkError.Descriptor = Descriptor # type: ignore
    class Miniscript(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.Miniscript({})".format(repr(str(self)))
    _UniffiTempBdkError.Miniscript = Miniscript # type: ignore
    class MiniscriptPsbt(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.MiniscriptPsbt({})".format(repr(str(self)))
    _UniffiTempBdkError.MiniscriptPsbt = MiniscriptPsbt # type: ignore
    class Bip32(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.Bip32({})".format(repr(str(self)))
    _UniffiTempBdkError.Bip32 = Bip32 # type: ignore
    class Psbt(_UniffiTempBdkError):
        def __repr__(self):
            return "BdkError.Psbt({})".format(repr(str(self)))
    _UniffiTempBdkError.Psbt = Psbt # type: ignore

BdkError = _UniffiTempBdkError # type: ignore
del _UniffiTempBdkError


class _UniffiConverterTypeBdkError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return BdkError.Generic(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return BdkError.NoRecipients(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return BdkError.NoUtxosSelected(
                _UniffiConverterString.read(buf),
            )
        if variant == 4:
            return BdkError.OutputBelowDustLimit(
                _UniffiConverterString.read(buf),
            )
        if variant == 5:
            return BdkError.InsufficientFunds(
                _UniffiConverterString.read(buf),
            )
        if variant == 6:
            return BdkError.BnBTotalTriesExceeded(
                _UniffiConverterString.read(buf),
            )
        if variant == 7:
            return BdkError.BnBNoExactMatch(
                _UniffiConverterString.read(buf),
            )
        if variant == 8:
            return BdkError.UnknownUtxo(
                _UniffiConverterString.read(buf),
            )
        if variant == 9:
            return BdkError.TransactionNotFound(
                _UniffiConverterString.read(buf),
            )
        if variant == 10:
            return BdkError.TransactionConfirmed(
                _UniffiConverterString.read(buf),
            )
        if variant == 11:
            return BdkError.IrreplaceableTransaction(
                _UniffiConverterString.read(buf),
            )
        if variant == 12:
            return BdkError.FeeRateTooLow(
                _UniffiConverterString.read(buf),
            )
        if variant == 13:
            return BdkError.FeeTooLow(
                _UniffiConverterString.read(buf),
            )
        if variant == 14:
            return BdkError.FeeRateUnavailable(
                _UniffiConverterString.read(buf),
            )
        if variant == 15:
            return BdkError.MissingKeyOrigin(
                _UniffiConverterString.read(buf),
            )
        if variant == 16:
            return BdkError.Key(
                _UniffiConverterString.read(buf),
            )
        if variant == 17:
            return BdkError.ChecksumMismatch(
                _UniffiConverterString.read(buf),
            )
        if variant == 18:
            return BdkError.SpendingPolicyRequired(
                _UniffiConverterString.read(buf),
            )
        if variant == 19:
            return BdkError.InvalidPolicyPathError(
                _UniffiConverterString.read(buf),
            )
        if variant == 20:
            return BdkError.Signer(
                _UniffiConverterString.read(buf),
            )
        if variant == 21:
            return BdkError.InvalidOutpoint(
                _UniffiConverterString.read(buf),
            )
        if variant == 22:
            return BdkError.Descriptor(
                _UniffiConverterString.read(buf),
            )
        if variant == 23:
            return BdkError.Miniscript(
                _UniffiConverterString.read(buf),
            )
        if variant == 24:
            return BdkError.MiniscriptPsbt(
                _UniffiConverterString.read(buf),
            )
        if variant == 25:
            return BdkError.Bip32(
                _UniffiConverterString.read(buf),
            )
        if variant == 26:
            return BdkError.Psbt(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def write(value, buf):
        if isinstance(value, BdkError.Generic):
            buf.write_i32(1)
        if isinstance(value, BdkError.NoRecipients):
            buf.write_i32(2)
        if isinstance(value, BdkError.NoUtxosSelected):
            buf.write_i32(3)
        if isinstance(value, BdkError.OutputBelowDustLimit):
            buf.write_i32(4)
        if isinstance(value, BdkError.InsufficientFunds):
            buf.write_i32(5)
        if isinstance(value, BdkError.BnBTotalTriesExceeded):
            buf.write_i32(6)
        if isinstance(value, BdkError.BnBNoExactMatch):
            buf.write_i32(7)
        if isinstance(value, BdkError.UnknownUtxo):
            buf.write_i32(8)
        if isinstance(value, BdkError.TransactionNotFound):
            buf.write_i32(9)
        if isinstance(value, BdkError.TransactionConfirmed):
            buf.write_i32(10)
        if isinstance(value, BdkError.IrreplaceableTransaction):
            buf.write_i32(11)
        if isinstance(value, BdkError.FeeRateTooLow):
            buf.write_i32(12)
        if isinstance(value, BdkError.FeeTooLow):
            buf.write_i32(13)
        if isinstance(value, BdkError.FeeRateUnavailable):
            buf.write_i32(14)
        if isinstance(value, BdkError.MissingKeyOrigin):
            buf.write_i32(15)
        if isinstance(value, BdkError.Key):
            buf.write_i32(16)
        if isinstance(value, BdkError.ChecksumMismatch):
            buf.write_i32(17)
        if isinstance(value, BdkError.SpendingPolicyRequired):
            buf.write_i32(18)
        if isinstance(value, BdkError.InvalidPolicyPathError):
            buf.write_i32(19)
        if isinstance(value, BdkError.Signer):
            buf.write_i32(20)
        if isinstance(value, BdkError.InvalidOutpoint):
            buf.write_i32(21)
        if isinstance(value, BdkError.Descriptor):
            buf.write_i32(22)
        if isinstance(value, BdkError.Miniscript):
            buf.write_i32(23)
        if isinstance(value, BdkError.MiniscriptPsbt):
            buf.write_i32(24)
        if isinstance(value, BdkError.Bip32):
            buf.write_i32(25)
        if isinstance(value, BdkError.Psbt):
            buf.write_i32(26)





class ChangeSpendPolicy(enum.Enum):
    CHANGE_ALLOWED = 1
    ONLY_CHANGE = 2
    CHANGE_FORBIDDEN = 3
    


class _UniffiConverterTypeChangeSpendPolicy(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return ChangeSpendPolicy.CHANGE_ALLOWED
        if variant == 2:
            return ChangeSpendPolicy.ONLY_CHANGE
        if variant == 3:
            return ChangeSpendPolicy.CHANGE_FORBIDDEN
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value == ChangeSpendPolicy.CHANGE_ALLOWED:
            buf.write_i32(1)
        if value == ChangeSpendPolicy.ONLY_CHANGE:
            buf.write_i32(2)
        if value == ChangeSpendPolicy.CHANGE_FORBIDDEN:
            buf.write_i32(3)






class KeychainKind(enum.Enum):
    EXTERNAL = 1
    INTERNAL = 2
    


class _UniffiConverterTypeKeychainKind(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return KeychainKind.EXTERNAL
        if variant == 2:
            return KeychainKind.INTERNAL
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value == KeychainKind.EXTERNAL:
            buf.write_i32(1)
        if value == KeychainKind.INTERNAL:
            buf.write_i32(2)






class Network(enum.Enum):
    BITCOIN = 1
    TESTNET = 2
    SIGNET = 3
    REGTEST = 4
    


class _UniffiConverterTypeNetwork(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return Network.BITCOIN
        if variant == 2:
            return Network.TESTNET
        if variant == 3:
            return Network.SIGNET
        if variant == 4:
            return Network.REGTEST
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value == Network.BITCOIN:
            buf.write_i32(1)
        if value == Network.TESTNET:
            buf.write_i32(2)
        if value == Network.SIGNET:
            buf.write_i32(3)
        if value == Network.REGTEST:
            buf.write_i32(4)






class WordCount(enum.Enum):
    WORDS12 = 1
    WORDS15 = 2
    WORDS18 = 3
    WORDS21 = 4
    WORDS24 = 5
    


class _UniffiConverterTypeWordCount(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return WordCount.WORDS12
        if variant == 2:
            return WordCount.WORDS15
        if variant == 3:
            return WordCount.WORDS18
        if variant == 4:
            return WordCount.WORDS21
        if variant == 5:
            return WordCount.WORDS24
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value == WordCount.WORDS12:
            buf.write_i32(1)
        if value == WordCount.WORDS15:
            buf.write_i32(2)
        if value == WordCount.WORDS18:
            buf.write_i32(3)
        if value == WordCount.WORDS21:
            buf.write_i32(4)
        if value == WordCount.WORDS24:
            buf.write_i32(5)




class _UniffiConverterOptionalString(_UniffiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterString.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterString.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeDescriptor(_UniffiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeDescriptor.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeDescriptor.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterSequenceUInt8(_UniffiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterUInt8.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterUInt8.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeScriptAmount(_UniffiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeScriptAmount.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeScriptAmount.read(buf) for i in range(count)
        ]

__all__ = [
    "InternalError",
    "AddressIndex",
    "BdkError",
    "ChangeSpendPolicy",
    "KeychainKind",
    "Network",
    "WordCount",
    "AddressInfo",
    "OutPoint",
    "ScriptAmount",
    "Address",
    "Balance",
    "DerivationPath",
    "Descriptor",
    "DescriptorPublicKey",
    "DescriptorSecretKey",
    "EsploraClient",
    "Mnemonic",
    "PartiallySignedTransaction",
    "Script",
    "Transaction",
    "TxBuilder",
    "Update",
    "Wallet",
]

