

# This file was autogenerated by some hot garbage in the `uniffi` crate.
# Trust me, you don't want to mess with it!

# Common helper code.
#
# Ideally this would live in a separate .py file where it can be unittested etc
# in isolation, and perhaps even published as a re-useable package.
#
# However, it's important that the details of how this helper code works (e.g. the
# way that different builtin types are passed across the FFI) exactly match what's
# expected by the rust code on the other side of the interface. In practice right
# now that means coming from the exact some version of `uniffi` that was used to
# compile the rust component. The easiest way to ensure this is to bundle the Python
# helpers directly inline like we're doing here.

from __future__ import annotations
import os
import sys
import ctypes
import enum
import struct
import contextlib
import datetime
import threading
import itertools
import traceback
import typing
import asyncio
import platform

# Used for default argument values
_DEFAULT = object() # type: typing.Any


class _UniffiRustBuffer(ctypes.Structure):
    _fields_ = [
        ("capacity", ctypes.c_uint64),
        ("len", ctypes.c_uint64),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    @staticmethod
    def default():
        return _UniffiRustBuffer(0, 0, None)

    @staticmethod
    def alloc(size):
        return _uniffi_rust_call(_UniffiLib.ffi_bdkffi_rustbuffer_alloc, size)

    @staticmethod
    def reserve(rbuf, additional):
        return _uniffi_rust_call(_UniffiLib.ffi_bdkffi_rustbuffer_reserve, rbuf, additional)

    def free(self):
        return _uniffi_rust_call(_UniffiLib.ffi_bdkffi_rustbuffer_free, self)

    def __str__(self):
        return "_UniffiRustBuffer(capacity={}, len={}, data={})".format(
            self.capacity,
            self.len,
            self.data[0:self.len]
        )

    @contextlib.contextmanager
    def alloc_with_builder(*args):
        """Context-manger to allocate a buffer using a _UniffiRustBufferBuilder.

        The allocated buffer will be automatically freed if an error occurs, ensuring that
        we don't accidentally leak it.
        """
        builder = _UniffiRustBufferBuilder()
        try:
            yield builder
        except:
            builder.discard()
            raise

    @contextlib.contextmanager
    def consume_with_stream(self):
        """Context-manager to consume a buffer using a _UniffiRustBufferStream.

        The _UniffiRustBuffer will be freed once the context-manager exits, ensuring that we don't
        leak it even if an error occurs.
        """
        try:
            s = _UniffiRustBufferStream.from_rust_buffer(self)
            yield s
            if s.remaining() != 0:
                raise RuntimeError("junk data left in buffer at end of consume_with_stream")
        finally:
            self.free()

    @contextlib.contextmanager
    def read_with_stream(self):
        """Context-manager to read a buffer using a _UniffiRustBufferStream.

        This is like consume_with_stream, but doesn't free the buffer afterwards.
        It should only be used with borrowed `_UniffiRustBuffer` data.
        """
        s = _UniffiRustBufferStream.from_rust_buffer(self)
        yield s
        if s.remaining() != 0:
            raise RuntimeError("junk data left in buffer at end of read_with_stream")

class _UniffiForeignBytes(ctypes.Structure):
    _fields_ = [
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    def __str__(self):
        return "_UniffiForeignBytes(len={}, data={})".format(self.len, self.data[0:self.len])


class _UniffiRustBufferStream:
    """
    Helper for structured reading of bytes from a _UniffiRustBuffer
    """

    def __init__(self, data, len):
        self.data = data
        self.len = len
        self.offset = 0

    @classmethod
    def from_rust_buffer(cls, buf):
        return cls(buf.data, buf.len)

    def remaining(self):
        return self.len - self.offset

    def _unpack_from(self, size, format):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        value = struct.unpack(format, self.data[self.offset:self.offset+size])[0]
        self.offset += size
        return value

    def read(self, size):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        data = self.data[self.offset:self.offset+size]
        self.offset += size
        return data

    def read_i8(self):
        return self._unpack_from(1, ">b")

    def read_u8(self):
        return self._unpack_from(1, ">B")

    def read_i16(self):
        return self._unpack_from(2, ">h")

    def read_u16(self):
        return self._unpack_from(2, ">H")

    def read_i32(self):
        return self._unpack_from(4, ">i")

    def read_u32(self):
        return self._unpack_from(4, ">I")

    def read_i64(self):
        return self._unpack_from(8, ">q")

    def read_u64(self):
        return self._unpack_from(8, ">Q")

    def read_float(self):
        v = self._unpack_from(4, ">f")
        return v

    def read_double(self):
        return self._unpack_from(8, ">d")

class _UniffiRustBufferBuilder:
    """
    Helper for structured writing of bytes into a _UniffiRustBuffer.
    """

    def __init__(self):
        self.rbuf = _UniffiRustBuffer.alloc(16)
        self.rbuf.len = 0

    def finalize(self):
        rbuf = self.rbuf
        self.rbuf = None
        return rbuf

    def discard(self):
        if self.rbuf is not None:
            rbuf = self.finalize()
            rbuf.free()

    @contextlib.contextmanager
    def _reserve(self, num_bytes):
        if self.rbuf.len + num_bytes > self.rbuf.capacity:
            self.rbuf = _UniffiRustBuffer.reserve(self.rbuf, num_bytes)
        yield None
        self.rbuf.len += num_bytes

    def _pack_into(self, size, format, value):
        with self._reserve(size):
            # XXX TODO: I feel like I should be able to use `struct.pack_into` here but can't figure it out.
            for i, byte in enumerate(struct.pack(format, value)):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write(self, value):
        with self._reserve(len(value)):
            for i, byte in enumerate(value):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write_i8(self, v):
        self._pack_into(1, ">b", v)

    def write_u8(self, v):
        self._pack_into(1, ">B", v)

    def write_i16(self, v):
        self._pack_into(2, ">h", v)

    def write_u16(self, v):
        self._pack_into(2, ">H", v)

    def write_i32(self, v):
        self._pack_into(4, ">i", v)

    def write_u32(self, v):
        self._pack_into(4, ">I", v)

    def write_i64(self, v):
        self._pack_into(8, ">q", v)

    def write_u64(self, v):
        self._pack_into(8, ">Q", v)

    def write_float(self, v):
        self._pack_into(4, ">f", v)

    def write_double(self, v):
        self._pack_into(8, ">d", v)

    def write_c_size_t(self, v):
        self._pack_into(ctypes.sizeof(ctypes.c_size_t) , "@N", v)
# A handful of classes and functions to support the generated data structures.
# This would be a good candidate for isolating in its own ffi-support lib.

class InternalError(Exception):
    pass

class _UniffiRustCallStatus(ctypes.Structure):
    """
    Error runtime.
    """
    _fields_ = [
        ("code", ctypes.c_int8),
        ("error_buf", _UniffiRustBuffer),
    ]

    # These match the values from the uniffi::rustcalls module
    CALL_SUCCESS = 0
    CALL_ERROR = 1
    CALL_UNEXPECTED_ERROR = 2

    @staticmethod
    def default():
        return _UniffiRustCallStatus(code=_UniffiRustCallStatus.CALL_SUCCESS, error_buf=_UniffiRustBuffer.default())

    def __str__(self):
        if self.code == _UniffiRustCallStatus.CALL_SUCCESS:
            return "_UniffiRustCallStatus(CALL_SUCCESS)"
        elif self.code == _UniffiRustCallStatus.CALL_ERROR:
            return "_UniffiRustCallStatus(CALL_ERROR)"
        elif self.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
            return "_UniffiRustCallStatus(CALL_UNEXPECTED_ERROR)"
        else:
            return "_UniffiRustCallStatus(<invalid code>)"

def _uniffi_rust_call(fn, *args):
    # Call a rust function
    return _uniffi_rust_call_with_error(None, fn, *args)

def _uniffi_rust_call_with_error(error_ffi_converter, fn, *args):
    # Call a rust function and handle any errors
    #
    # This function is used for rust calls that return Result<> and therefore can set the CALL_ERROR status code.
    # error_ffi_converter must be set to the _UniffiConverter for the error class that corresponds to the result.
    call_status = _UniffiRustCallStatus.default()

    args_with_error = args + (ctypes.byref(call_status),)
    result = fn(*args_with_error)
    _uniffi_check_call_status(error_ffi_converter, call_status)
    return result

def _uniffi_check_call_status(error_ffi_converter, call_status):
    if call_status.code == _UniffiRustCallStatus.CALL_SUCCESS:
        pass
    elif call_status.code == _UniffiRustCallStatus.CALL_ERROR:
        if error_ffi_converter is None:
            call_status.error_buf.free()
            raise InternalError("_uniffi_rust_call_with_error: CALL_ERROR, but error_ffi_converter is None")
        else:
            raise error_ffi_converter.lift(call_status.error_buf)
    elif call_status.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
        # When the rust code sees a panic, it tries to construct a _UniffiRustBuffer
        # with the message.  But if that code panics, then it just sends back
        # an empty buffer.
        if call_status.error_buf.len > 0:
            msg = _UniffiConverterString.lift(call_status.error_buf)
        else:
            msg = "Unknown rust panic"
        raise InternalError(msg)
    else:
        raise InternalError("Invalid _UniffiRustCallStatus code: {}".format(
            call_status.code))

def _uniffi_trait_interface_call(call_status, make_call, write_return_value):
    try:
        return write_return_value(make_call())
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))

def _uniffi_trait_interface_call_with_error(call_status, make_call, write_return_value, error_type, lower_error):
    try:
        try:
            return write_return_value(make_call())
        except error_type as e:
            call_status.code = _UniffiRustCallStatus.CALL_ERROR
            call_status.error_buf = lower_error(e)
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))
class _UniffiHandleMap:
    """
    A map where inserting, getting and removing data is synchronized with a lock.
    """

    def __init__(self):
        # type Handle = int
        self._map = {}  # type: Dict[Handle, Any]
        self._lock = threading.Lock()
        self._counter = itertools.count()

    def insert(self, obj):
        with self._lock:
            handle = next(self._counter)
            self._map[handle] = obj
            return handle

    def get(self, handle):
        try:
            with self._lock:
                return self._map[handle]
        except KeyError:
            raise InternalError("_UniffiHandleMap.get: Invalid handle")

    def remove(self, handle):
        try:
            with self._lock:
                return self._map.pop(handle)
        except KeyError:
            raise InternalError("_UniffiHandleMap.remove: Invalid handle")

    def __len__(self):
        return len(self._map)
# Types conforming to `_UniffiConverterPrimitive` pass themselves directly over the FFI.
class _UniffiConverterPrimitive:
    @classmethod
    def lift(cls, value):
        return value

    @classmethod
    def lower(cls, value):
        return value

class _UniffiConverterPrimitiveInt(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__index__()
        except Exception:
            raise TypeError("'{}' object cannot be interpreted as an integer".format(type(value).__name__))
        if not isinstance(value, int):
            raise TypeError("__index__ returned non-int (type {})".format(type(value).__name__))
        if not cls.VALUE_MIN <= value < cls.VALUE_MAX:
            raise ValueError("{} requires {} <= value < {}".format(cls.CLASS_NAME, cls.VALUE_MIN, cls.VALUE_MAX))

class _UniffiConverterPrimitiveFloat(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__float__()
        except Exception:
            raise TypeError("must be real number, not {}".format(type(value).__name__))
        if not isinstance(value, float):
            raise TypeError("__float__ returned non-float (type {})".format(type(value).__name__))

# Helper class for wrapper types that will always go through a _UniffiRustBuffer.
# Classes should inherit from this and implement the `read` and `write` static methods.
class _UniffiConverterRustBuffer:
    @classmethod
    def lift(cls, rbuf):
        with rbuf.consume_with_stream() as stream:
            return cls.read(stream)

    @classmethod
    def lower(cls, value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            cls.write(value, builder)
            return builder.finalize()

# Contains loading, initialization code, and the FFI Function declarations.
# Define some ctypes FFI types that we use in the library

"""
Function pointer for a Rust task, which a callback function that takes a opaque pointer
"""
_UNIFFI_RUST_TASK = ctypes.CFUNCTYPE(None, ctypes.c_void_p, ctypes.c_int8)

def _uniffi_future_callback_t(return_type):
    """
    Factory function to create callback function types for async functions
    """
    return ctypes.CFUNCTYPE(None, ctypes.c_uint64, return_type, _UniffiRustCallStatus)

def _uniffi_load_indirect():
    """
    This is how we find and load the dynamic library provided by the component.
    For now we just look it up by name.
    """
    if sys.platform == "darwin":
        libname = "lib{}.dylib"
    elif sys.platform.startswith("win"):
        # As of python3.8, ctypes does not seem to search $PATH when loading DLLs.
        # We could use `os.add_dll_directory` to configure the search path, but
        # it doesn't feel right to mess with application-wide settings. Let's
        # assume that the `.dll` is next to the `.py` file and load by full path.
        libname = os.path.join(
            os.path.dirname(__file__),
            "{}.dll",
        )
    else:
        # Anything else must be an ELF platform - Linux, *BSD, Solaris/illumos
        libname = "lib{}.so"

    libname = libname.format("bdkffi")
    path = os.path.join(os.path.dirname(__file__), libname)
    lib = ctypes.cdll.LoadLibrary(path)
    return lib

def _uniffi_check_contract_api_version(lib):
    # Get the bindings contract version from our ComponentInterface
    bindings_contract_version = 29
    # Get the scaffolding contract version by calling the into the dylib
    scaffolding_contract_version = lib.ffi_bdkffi_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version:
        raise InternalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")

def _uniffi_check_api_checksums(lib):
    if lib.uniffi_bdkffi_checksum_method_address_is_valid_for_network() != 799:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_address_script_pubkey() != 23663:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_address_to_address_data() != 6766:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_address_to_qr_uri() != 60630:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_amount_to_btc() != 44112:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_amount_to_sat() != 2062:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_blockhash_serialize() != 58329:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_bumpfeetxbuilder_allow_dust() != 64834:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_bumpfeetxbuilder_current_height() != 25489:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_bumpfeetxbuilder_finish() != 36534:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_bumpfeetxbuilder_nlocktime() != 13924:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_bumpfeetxbuilder_set_exact_sequence() != 13533:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_bumpfeetxbuilder_version() != 18790:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfbuilder_build() != 49355:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfbuilder_configure_timeout_millis() != 41120:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfbuilder_connections() != 8040:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfbuilder_data_dir() != 31903:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfbuilder_dns_resolver() != 20074:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfbuilder_log_level() != 53476:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfbuilder_peers() != 54701:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfbuilder_scan_type() != 58442:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfbuilder_socks5_proxy() != 50836:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfclient_add_revealed_scripts() != 52140:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfclient_average_fee_rate() != 26767:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfclient_broadcast() != 8491:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfclient_connect() != 2287:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfclient_is_running() != 22584:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfclient_lookup_host() != 26923:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfclient_min_broadcast_feerate() != 31908:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfclient_next_info() != 22000:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfclient_next_log() != 8685:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfclient_next_warning() != 38083:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfclient_shutdown() != 21067:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfclient_update() != 59279:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_cbfnode_run() != 61383:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_changeset_change_descriptor() != 60265:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_changeset_descriptor() != 8527:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_changeset_indexer_changeset() != 12024:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_changeset_localchain_changeset() != 8072:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_changeset_network() != 12695:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_changeset_tx_graph_changeset() != 51559:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptor_descriptor_id() != 35226:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptor_is_multipath() != 24851:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptor_max_weight_to_satisfy() != 27840:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptor_to_single_descriptors() != 24048:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptor_to_string_with_secret() != 44538:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptorid_serialize() != 36044:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptorpublickey_derive() != 53424:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptorpublickey_extend() != 11343:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptorpublickey_is_multipath() != 23614:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptorpublickey_master_fingerprint() != 43604:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptorsecretkey_as_public() != 40418:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptorsecretkey_derive() != 17313:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptorsecretkey_extend() != 24206:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_descriptorsecretkey_secret_bytes() != 44537:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_electrumclient_block_headers_subscribe() != 27583:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_electrumclient_estimate_fee() != 55819:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_electrumclient_full_scan() != 12661:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_electrumclient_ping() != 41284:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_electrumclient_server_features() != 31597:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_electrumclient_sync() != 55678:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_electrumclient_transaction_broadcast() != 24746:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_esploraclient_broadcast() != 45367:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_esploraclient_full_scan() != 19768:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_esploraclient_get_block_hash() != 37777:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_esploraclient_get_fee_estimates() != 62859:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_esploraclient_get_height() != 26148:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_esploraclient_get_tx() != 51222:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_esploraclient_get_tx_info() != 59479:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_esploraclient_get_tx_status() != 61956:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_esploraclient_sync() != 21097:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_feerate_to_sat_per_kwu() != 54539:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_feerate_to_sat_per_vb_ceil() != 34953:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_feerate_to_sat_per_vb_floor() != 29836:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_fullscanrequestbuilder_build() != 5585:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_fullscanrequestbuilder_inspect_spks_for_all_keychains() != 43667:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_fullscanscriptinspector_inspect() != 36414:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_hashableoutpoint_outpoint() != 21921:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_persistence_initialize() != 9283:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_persistence_persist() != 29474:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_policy_as_string() != 42734:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_policy_contribution() != 11262:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_policy_id() != 23964:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_policy_item() != 6003:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_policy_requires_path() != 4187:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_policy_satisfaction() != 46765:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_psbt_combine() != 42075:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_psbt_extract_tx() != 26653:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_psbt_fee() != 30353:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_psbt_finalize() != 51031:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_psbt_json_serialize() != 25111:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_psbt_serialize() != 9376:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_psbt_spend_utxo() != 12381:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_psbt_write_to_file() != 17670:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_script_to_bytes() != 64817:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_syncrequestbuilder_build() != 26747:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_syncrequestbuilder_inspect_spks() != 38063:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_syncscriptinspector_inspect() != 63115:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_compute_txid() != 4600:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_compute_wtxid() != 59414:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_input() != 17971:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_is_coinbase() != 52376:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_is_explicitly_rbf() != 33467:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_is_lock_time_enabled() != 17927:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_lock_time() != 11673:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_output() != 18641:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_serialize() != 63746:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_total_size() != 32499:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_version() != 57173:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_vsize() != 23751:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_transaction_weight() != 22642:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_add_data() != 3485:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_add_global_xpubs() != 60600:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_add_recipient() != 38261:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_add_unspendable() != 42556:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_add_utxo() != 55155:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_add_utxos() != 36635:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_allow_dust() != 36330:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_change_policy() != 33210:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_current_height() != 25990:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_do_not_spend_change() != 279:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_drain_to() != 19958:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_drain_wallet() != 21886:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_fee_absolute() != 6920:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_fee_rate() != 42880:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_finish() != 43504:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_manually_selected_only() != 17632:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_nlocktime() != 61968:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_only_spend_change() != 2625:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_policy_path() != 36425:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_set_exact_sequence() != 11338:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_set_recipients() != 8653:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_unspendable() != 59793:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txbuilder_version() != 12910:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txmerklenode_serialize() != 6758:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_txid_serialize() != 15501:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_apply_unconfirmed_txs() != 61391:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_apply_update() != 14059:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_balance() != 1065:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_calculate_fee() != 62842:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_calculate_fee_rate() != 52109:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_cancel_tx() != 52250:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_derivation_index() != 17133:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_derivation_of_spk() != 57131:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_descriptor_checksum() != 65455:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_finalize_psbt() != 23125:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_get_tx() != 23045:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_get_utxo() != 31901:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_is_mine() != 12109:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_latest_checkpoint() != 15617:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_list_output() != 28293:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_list_unspent() != 38160:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_list_unused_addresses() != 43002:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_mark_used() != 53437:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_network() != 61015:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_next_derivation_index() != 54301:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_next_unused_address() != 64390:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_peek_address() != 33286:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_persist() != 45543:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_policies() != 10593:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_public_descriptor() != 58017:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_reveal_addresses_to() != 39125:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_reveal_next_address() != 21378:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_sent_and_received() != 55583:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_sign() != 16374:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_start_full_scan() != 29628:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_start_sync_with_revealed_spks() != 37305:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_transactions() != 45722:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wallet_tx_details() != 21865:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_method_wtxid_serialize() != 29733:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_address_from_script() != 63311:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_address_new() != 15543:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_amount_from_btc() != 43617:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_amount_from_sat() != 18287:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_blockhash_from_bytes() != 58986:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_blockhash_from_string() != 55044:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_bumpfeetxbuilder_new() != 17822:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_cbfbuilder_new() != 33361:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_changeset_from_aggregate() != 32936:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_changeset_from_descriptor_and_network() != 39614:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_changeset_from_indexer_changeset() != 52453:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_changeset_from_local_chain_changes() != 14452:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_changeset_from_merge() != 41467:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_changeset_from_tx_graph_changeset() != 31574:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_changeset_new() != 22000:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_derivationpath_new() != 30769:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptor_new() != 19141:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip44() != 3624:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip44_public() != 31153:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip49() != 25091:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip49_public() != 37536:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip84() != 64808:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip84_public() != 21895:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip86() != 29942:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip86_public() != 10777:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptorid_from_bytes() != 7595:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptorid_from_string() != 26289:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptorpublickey_from_string() != 45545:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptorsecretkey_from_string() != 11133:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_descriptorsecretkey_new() != 48188:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_electrumclient_new() != 2029:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_esploraclient_new() != 7406:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_feerate_from_sat_per_kwu() != 2730:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_feerate_from_sat_per_vb() != 6982:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_hashableoutpoint_new() != 16705:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_ipaddress_from_ipv4() != 14635:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_ipaddress_from_ipv6() != 31033:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_mnemonic_from_entropy() != 812:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_mnemonic_from_string() != 30002:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_mnemonic_new() != 11901:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_persister_custom() != 31182:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_persister_new_in_memory() != 62085:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_persister_new_sqlite() != 14945:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_psbt_from_file() != 48265:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_psbt_from_unsigned_tx() != 6265:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_psbt_new() != 6279:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_script_new() != 53899:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_transaction_new() != 50797:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_txbuilder_new() != 20554:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_txmerklenode_from_bytes() != 62268:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_txmerklenode_from_string() != 34111:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_txid_from_bytes() != 24877:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_txid_from_string() != 39405:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_wallet_load() != 21534:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_wallet_new() != 39177:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_wtxid_from_bytes() != 34456:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_bdkffi_checksum_constructor_wtxid_from_string() != 20341:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")

# A ctypes library to expose the extern-C FFI definitions.
# This is an implementation detail which will be called internally by the public API.

_UniffiLib = _uniffi_load_indirect()
_UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK = ctypes.CFUNCTYPE(None,ctypes.c_uint64,ctypes.c_int8,
)
_UNIFFI_FOREIGN_FUTURE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
_UNIFFI_CALLBACK_INTERFACE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
class _UniffiForeignFuture(ctypes.Structure):
    _fields_ = [
        ("handle", ctypes.c_uint64),
        ("free", _UNIFFI_FOREIGN_FUTURE_FREE),
    ]
class _UniffiForeignFutureStructU8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU8,
)
class _UniffiForeignFutureStructI8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI8,
)
class _UniffiForeignFutureStructU16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU16,
)
class _UniffiForeignFutureStructI16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI16,
)
class _UniffiForeignFutureStructU32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU32,
)
class _UniffiForeignFutureStructI32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI32,
)
class _UniffiForeignFutureStructU64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU64,
)
class _UniffiForeignFutureStructI64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI64,
)
class _UniffiForeignFutureStructF32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_float),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF32,
)
class _UniffiForeignFutureStructF64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_double),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF64,
)
class _UniffiForeignFutureStructPointer(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_void_p),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_POINTER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructPointer,
)
class _UniffiForeignFutureStructRustBuffer(ctypes.Structure):
    _fields_ = [
        ("return_value", _UniffiRustBuffer),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_RUST_BUFFER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructRustBuffer,
)
class _UniffiForeignFutureStructVoid(ctypes.Structure):
    _fields_ = [
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_VOID = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructVoid,
)
_UNIFFI_CALLBACK_INTERFACE_FULL_SCAN_SCRIPT_INSPECTOR_METHOD0 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,ctypes.c_uint32,ctypes.c_void_p,ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UNIFFI_CALLBACK_INTERFACE_PERSISTENCE_METHOD0 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,ctypes.POINTER(ctypes.c_void_p),
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UNIFFI_CALLBACK_INTERFACE_PERSISTENCE_METHOD1 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,ctypes.c_void_p,ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UNIFFI_CALLBACK_INTERFACE_SYNC_SCRIPT_INSPECTOR_METHOD0 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,ctypes.c_void_p,ctypes.c_uint64,ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
class _UniffiVTableCallbackInterfaceFullScanScriptInspector(ctypes.Structure):
    _fields_ = [
        ("inspect", _UNIFFI_CALLBACK_INTERFACE_FULL_SCAN_SCRIPT_INSPECTOR_METHOD0),
        ("uniffi_free", _UNIFFI_CALLBACK_INTERFACE_FREE),
    ]
class _UniffiVTableCallbackInterfacePersistence(ctypes.Structure):
    _fields_ = [
        ("initialize", _UNIFFI_CALLBACK_INTERFACE_PERSISTENCE_METHOD0),
        ("persist", _UNIFFI_CALLBACK_INTERFACE_PERSISTENCE_METHOD1),
        ("uniffi_free", _UNIFFI_CALLBACK_INTERFACE_FREE),
    ]
class _UniffiVTableCallbackInterfaceSyncScriptInspector(ctypes.Structure):
    _fields_ = [
        ("inspect", _UNIFFI_CALLBACK_INTERFACE_SYNC_SCRIPT_INSPECTOR_METHOD0),
        ("uniffi_free", _UNIFFI_CALLBACK_INTERFACE_FREE),
    ]
_UniffiLib.uniffi_bdkffi_fn_clone_address.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_address.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_address.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_address.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_address_from_script.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_address_from_script.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_address_new.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_address_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_address_is_valid_for_network.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_address_is_valid_for_network.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_address_script_pubkey.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_address_script_pubkey.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_address_to_address_data.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_address_to_address_data.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_address_to_qr_uri.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_address_to_qr_uri.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_address_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_address_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_address_uniffi_trait_eq_eq.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_address_uniffi_trait_eq_eq.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_address_uniffi_trait_eq_ne.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_address_uniffi_trait_eq_ne.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_clone_amount.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_amount.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_amount.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_amount.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_amount_from_btc.argtypes = (
    ctypes.c_double,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_amount_from_btc.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_amount_from_sat.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_amount_from_sat.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_amount_to_btc.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_amount_to_btc.restype = ctypes.c_double
_UniffiLib.uniffi_bdkffi_fn_method_amount_to_sat.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_amount_to_sat.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_clone_blockhash.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_blockhash.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_blockhash.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_blockhash.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_blockhash_from_bytes.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_blockhash_from_bytes.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_blockhash_from_string.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_blockhash_from_string.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_blockhash_serialize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_blockhash_serialize.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_blockhash_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_blockhash_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_blockhash_uniffi_trait_eq_eq.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_blockhash_uniffi_trait_eq_eq.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_blockhash_uniffi_trait_eq_ne.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_blockhash_uniffi_trait_eq_ne.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_blockhash_uniffi_trait_hash.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_blockhash_uniffi_trait_hash.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_clone_bumpfeetxbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_bumpfeetxbuilder.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_bumpfeetxbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_bumpfeetxbuilder.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_bumpfeetxbuilder_new.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_bumpfeetxbuilder_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_bumpfeetxbuilder_allow_dust.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_bumpfeetxbuilder_allow_dust.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_bumpfeetxbuilder_current_height.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_bumpfeetxbuilder_current_height.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_bumpfeetxbuilder_finish.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_bumpfeetxbuilder_finish.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_bumpfeetxbuilder_nlocktime.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_bumpfeetxbuilder_nlocktime.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_bumpfeetxbuilder_set_exact_sequence.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_bumpfeetxbuilder_set_exact_sequence.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_bumpfeetxbuilder_version.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_bumpfeetxbuilder_version.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_clone_cbfbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_cbfbuilder.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_cbfbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_cbfbuilder.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_cbfbuilder_new.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_cbfbuilder_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_build.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_build.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_configure_timeout_millis.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_configure_timeout_millis.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_connections.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_connections.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_data_dir.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_data_dir.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_dns_resolver.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_dns_resolver.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_log_level.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_log_level.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_peers.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_peers.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_scan_type.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_scan_type.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_socks5_proxy.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_socks5_proxy.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_clone_cbfclient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_cbfclient.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_cbfclient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_cbfclient.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_add_revealed_scripts.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_add_revealed_scripts.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_average_fee_rate.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_average_fee_rate.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_broadcast.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_broadcast.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_connect.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_connect.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_is_running.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_is_running.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_lookup_host.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_lookup_host.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_min_broadcast_feerate.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_min_broadcast_feerate.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_next_info.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_next_info.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_next_log.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_next_log.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_next_warning.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_next_warning.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_shutdown.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_shutdown.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_update.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_update.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_clone_cbfnode.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_cbfnode.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_cbfnode.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_cbfnode.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_cbfnode_run.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_cbfnode_run.restype = None
_UniffiLib.uniffi_bdkffi_fn_clone_changeset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_changeset.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_changeset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_changeset.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_from_aggregate.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_from_aggregate.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_from_descriptor_and_network.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_from_descriptor_and_network.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_from_indexer_changeset.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_from_indexer_changeset.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_from_local_chain_changes.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_from_local_chain_changes.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_from_merge.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_from_merge.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_from_tx_graph_changeset.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_from_tx_graph_changeset.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_new.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_changeset_change_descriptor.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_changeset_change_descriptor.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_changeset_descriptor.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_changeset_descriptor.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_changeset_indexer_changeset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_changeset_indexer_changeset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_changeset_localchain_changeset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_changeset_localchain_changeset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_changeset_network.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_changeset_network.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_changeset_tx_graph_changeset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_changeset_tx_graph_changeset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_clone_derivationpath.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_derivationpath.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_derivationpath.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_derivationpath.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_derivationpath_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_derivationpath_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_clone_descriptor.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_descriptor.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_descriptor.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_descriptor.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip44.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip44.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip44_public.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip44_public.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip49.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip49.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip49_public.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip49_public.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip84.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip84.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip84_public.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip84_public.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip86.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip86.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip86_public.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip86_public.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_descriptor_descriptor_id.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptor_descriptor_id.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_descriptor_is_multipath.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptor_is_multipath.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_descriptor_max_weight_to_satisfy.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptor_max_weight_to_satisfy.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_descriptor_to_single_descriptors.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptor_to_single_descriptors.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_descriptor_to_string_with_secret.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptor_to_string_with_secret.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_descriptor_uniffi_trait_debug.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptor_uniffi_trait_debug.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_descriptor_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptor_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_clone_descriptorid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_descriptorid.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_descriptorid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_descriptorid.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorid_from_bytes.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorid_from_bytes.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorid_from_string.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorid_from_string.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_descriptorid_serialize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorid_serialize.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_descriptorid_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorid_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_descriptorid_uniffi_trait_eq_eq.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorid_uniffi_trait_eq_eq.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_descriptorid_uniffi_trait_eq_ne.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorid_uniffi_trait_eq_ne.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_descriptorid_uniffi_trait_hash.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorid_uniffi_trait_hash.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_clone_descriptorpublickey.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_descriptorpublickey.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_descriptorpublickey.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_descriptorpublickey.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorpublickey_from_string.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorpublickey_from_string.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_derive.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_derive.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_extend.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_extend.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_is_multipath.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_is_multipath.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_master_fingerprint.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_master_fingerprint.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_uniffi_trait_debug.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_uniffi_trait_debug.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_clone_descriptorsecretkey.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_descriptorsecretkey.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_descriptorsecretkey.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_descriptorsecretkey.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorsecretkey_from_string.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorsecretkey_from_string.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorsecretkey_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorsecretkey_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_as_public.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_as_public.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_derive.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_derive.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_extend.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_extend.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_secret_bytes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_secret_bytes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_uniffi_trait_debug.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_uniffi_trait_debug.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_clone_electrumclient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_electrumclient.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_electrumclient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_electrumclient.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_electrumclient_new.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_electrumclient_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_block_headers_subscribe.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_block_headers_subscribe.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_estimate_fee.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_estimate_fee.restype = ctypes.c_double
_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_full_scan.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.c_uint64,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_full_scan.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_ping.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_ping.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_server_features.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_server_features.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_sync.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_sync.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_transaction_broadcast.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_transaction_broadcast.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_clone_esploraclient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_esploraclient.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_esploraclient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_esploraclient.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_esploraclient_new.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_esploraclient_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_broadcast.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_broadcast.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_full_scan.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_full_scan.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_get_block_hash.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_get_block_hash.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_get_fee_estimates.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_get_fee_estimates.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_get_height.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_get_height.restype = ctypes.c_uint32
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_get_tx.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_get_tx.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_get_tx_info.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_get_tx_info.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_get_tx_status.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_get_tx_status.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_sync.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_sync.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_clone_feerate.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_feerate.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_feerate.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_feerate.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_feerate_from_sat_per_kwu.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_feerate_from_sat_per_kwu.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_feerate_from_sat_per_vb.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_feerate_from_sat_per_vb.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_feerate_to_sat_per_kwu.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_feerate_to_sat_per_kwu.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_feerate_to_sat_per_vb_ceil.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_feerate_to_sat_per_vb_ceil.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_feerate_to_sat_per_vb_floor.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_feerate_to_sat_per_vb_floor.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_clone_fullscanrequest.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_fullscanrequest.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_fullscanrequest.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_fullscanrequest.restype = None
_UniffiLib.uniffi_bdkffi_fn_clone_fullscanrequestbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_fullscanrequestbuilder.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_fullscanrequestbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_fullscanrequestbuilder.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_fullscanrequestbuilder_build.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_fullscanrequestbuilder_build.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_fullscanrequestbuilder_inspect_spks_for_all_keychains.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_fullscanrequestbuilder_inspect_spks_for_all_keychains.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_clone_fullscanscriptinspector.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_fullscanscriptinspector.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_fullscanscriptinspector.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_fullscanscriptinspector.restype = None
_UniffiLib.uniffi_bdkffi_fn_init_callback_vtable_fullscanscriptinspector.argtypes = (
    ctypes.POINTER(_UniffiVTableCallbackInterfaceFullScanScriptInspector),
)
_UniffiLib.uniffi_bdkffi_fn_init_callback_vtable_fullscanscriptinspector.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_fullscanscriptinspector_inspect.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_uint32,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_fullscanscriptinspector_inspect.restype = None
_UniffiLib.uniffi_bdkffi_fn_clone_hashableoutpoint.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_hashableoutpoint.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_hashableoutpoint.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_hashableoutpoint.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_hashableoutpoint_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_hashableoutpoint_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_hashableoutpoint_outpoint.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_hashableoutpoint_outpoint.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_hashableoutpoint_uniffi_trait_debug.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_hashableoutpoint_uniffi_trait_debug.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_hashableoutpoint_uniffi_trait_eq_eq.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_hashableoutpoint_uniffi_trait_eq_eq.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_hashableoutpoint_uniffi_trait_eq_ne.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_hashableoutpoint_uniffi_trait_eq_ne.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_hashableoutpoint_uniffi_trait_hash.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_hashableoutpoint_uniffi_trait_hash.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_clone_ipaddress.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_ipaddress.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_ipaddress.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_ipaddress.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_ipaddress_from_ipv4.argtypes = (
    ctypes.c_uint8,
    ctypes.c_uint8,
    ctypes.c_uint8,
    ctypes.c_uint8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_ipaddress_from_ipv4.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_ipaddress_from_ipv6.argtypes = (
    ctypes.c_uint16,
    ctypes.c_uint16,
    ctypes.c_uint16,
    ctypes.c_uint16,
    ctypes.c_uint16,
    ctypes.c_uint16,
    ctypes.c_uint16,
    ctypes.c_uint16,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_ipaddress_from_ipv6.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_clone_mnemonic.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_mnemonic.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_mnemonic.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_mnemonic.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_mnemonic_from_entropy.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_mnemonic_from_entropy.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_mnemonic_from_string.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_mnemonic_from_string.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_mnemonic_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_mnemonic_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_mnemonic_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_mnemonic_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_clone_persistence.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_persistence.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_persistence.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_persistence.restype = None
_UniffiLib.uniffi_bdkffi_fn_init_callback_vtable_persistence.argtypes = (
    ctypes.POINTER(_UniffiVTableCallbackInterfacePersistence),
)
_UniffiLib.uniffi_bdkffi_fn_init_callback_vtable_persistence.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_persistence_initialize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_persistence_initialize.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_persistence_persist.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_persistence_persist.restype = None
_UniffiLib.uniffi_bdkffi_fn_clone_persister.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_persister.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_persister.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_persister.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_persister_custom.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_persister_custom.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_persister_new_in_memory.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_persister_new_in_memory.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_persister_new_sqlite.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_persister_new_sqlite.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_clone_policy.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_policy.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_policy.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_policy.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_policy_as_string.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_policy_as_string.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_policy_contribution.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_policy_contribution.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_policy_id.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_policy_id.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_policy_item.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_policy_item.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_policy_requires_path.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_policy_requires_path.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_policy_satisfaction.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_policy_satisfaction.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_clone_psbt.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_psbt.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_psbt.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_psbt.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_psbt_from_file.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_psbt_from_file.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_psbt_from_unsigned_tx.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_psbt_from_unsigned_tx.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_psbt_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_psbt_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_psbt_combine.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_psbt_combine.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_psbt_extract_tx.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_psbt_extract_tx.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_psbt_fee.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_psbt_fee.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_psbt_finalize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_psbt_finalize.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_psbt_json_serialize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_psbt_json_serialize.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_psbt_serialize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_psbt_serialize.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_psbt_spend_utxo.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_psbt_spend_utxo.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_psbt_write_to_file.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_psbt_write_to_file.restype = None
_UniffiLib.uniffi_bdkffi_fn_clone_script.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_script.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_script.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_script.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_script_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_script_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_script_to_bytes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_script_to_bytes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_clone_syncrequest.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_syncrequest.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_syncrequest.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_syncrequest.restype = None
_UniffiLib.uniffi_bdkffi_fn_clone_syncrequestbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_syncrequestbuilder.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_syncrequestbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_syncrequestbuilder.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_syncrequestbuilder_build.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_syncrequestbuilder_build.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_syncrequestbuilder_inspect_spks.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_syncrequestbuilder_inspect_spks.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_clone_syncscriptinspector.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_syncscriptinspector.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_syncscriptinspector.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_syncscriptinspector.restype = None
_UniffiLib.uniffi_bdkffi_fn_init_callback_vtable_syncscriptinspector.argtypes = (
    ctypes.POINTER(_UniffiVTableCallbackInterfaceSyncScriptInspector),
)
_UniffiLib.uniffi_bdkffi_fn_init_callback_vtable_syncscriptinspector.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_syncscriptinspector_inspect.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_syncscriptinspector_inspect.restype = None
_UniffiLib.uniffi_bdkffi_fn_clone_transaction.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_transaction.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_transaction.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_transaction.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_transaction_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_transaction_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_transaction_compute_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_compute_txid.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_transaction_compute_wtxid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_compute_wtxid.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_transaction_input.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_input.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_transaction_is_coinbase.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_is_coinbase.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_transaction_is_explicitly_rbf.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_is_explicitly_rbf.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_transaction_is_lock_time_enabled.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_is_lock_time_enabled.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_transaction_lock_time.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_lock_time.restype = ctypes.c_uint32
_UniffiLib.uniffi_bdkffi_fn_method_transaction_output.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_output.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_transaction_serialize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_serialize.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_transaction_total_size.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_total_size.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_transaction_version.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_version.restype = ctypes.c_int32
_UniffiLib.uniffi_bdkffi_fn_method_transaction_vsize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_vsize.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_transaction_weight.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_weight.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_method_transaction_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_transaction_uniffi_trait_eq_eq.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_uniffi_trait_eq_eq.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_transaction_uniffi_trait_eq_ne.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_transaction_uniffi_trait_eq_ne.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_clone_txbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_txbuilder.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_txbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_txbuilder.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_txbuilder_new.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_txbuilder_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_data.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_data.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_global_xpubs.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_global_xpubs.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_recipient.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_recipient.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_unspendable.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_unspendable.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_utxo.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_utxo.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_utxos.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_utxos.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_allow_dust.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_allow_dust.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_change_policy.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_change_policy.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_current_height.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_current_height.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_do_not_spend_change.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_do_not_spend_change.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_drain_to.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_drain_to.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_drain_wallet.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_drain_wallet.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_fee_absolute.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_fee_absolute.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_fee_rate.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_fee_rate.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_finish.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_finish.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_manually_selected_only.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_manually_selected_only.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_nlocktime.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_nlocktime.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_only_spend_change.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_only_spend_change.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_policy_path.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_policy_path.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_set_exact_sequence.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_set_exact_sequence.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_set_recipients.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_set_recipients.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_unspendable.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_unspendable.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_version.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_version.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_clone_txmerklenode.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_txmerklenode.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_txmerklenode.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_txmerklenode.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_txmerklenode_from_bytes.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_txmerklenode_from_bytes.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_txmerklenode_from_string.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_txmerklenode_from_string.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txmerklenode_serialize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txmerklenode_serialize.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_txmerklenode_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txmerklenode_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_txmerklenode_uniffi_trait_eq_eq.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txmerklenode_uniffi_trait_eq_eq.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_txmerklenode_uniffi_trait_eq_ne.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txmerklenode_uniffi_trait_eq_ne.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_txmerklenode_uniffi_trait_hash.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txmerklenode_uniffi_trait_hash.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_clone_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_txid.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_txid.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_txid_from_bytes.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_txid_from_bytes.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_txid_from_string.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_txid_from_string.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_txid_serialize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txid_serialize.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_txid_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txid_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_txid_uniffi_trait_eq_eq.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txid_uniffi_trait_eq_eq.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_txid_uniffi_trait_eq_ne.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txid_uniffi_trait_eq_ne.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_txid_uniffi_trait_hash.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_txid_uniffi_trait_hash.restype = ctypes.c_uint64
_UniffiLib.uniffi_bdkffi_fn_clone_update.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_update.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_update.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_update.restype = None
_UniffiLib.uniffi_bdkffi_fn_clone_wallet.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_wallet.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_wallet.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_wallet.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_wallet_load.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_wallet_load.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_wallet_new.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_wallet_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_wallet_apply_unconfirmed_txs.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_apply_unconfirmed_txs.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_wallet_apply_update.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_apply_update.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_wallet_balance.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_balance.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_calculate_fee.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_calculate_fee.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_wallet_calculate_fee_rate.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_calculate_fee_rate.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_wallet_cancel_tx.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_cancel_tx.restype = None
_UniffiLib.uniffi_bdkffi_fn_method_wallet_derivation_index.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_derivation_index.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_derivation_of_spk.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_derivation_of_spk.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_descriptor_checksum.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_descriptor_checksum.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_finalize_psbt.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_finalize_psbt.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_wallet_get_tx.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_get_tx.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_get_utxo.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_get_utxo.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_is_mine.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_is_mine.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_wallet_latest_checkpoint.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_latest_checkpoint.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_list_output.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_list_output.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_list_unspent.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_list_unspent.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_list_unused_addresses.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_list_unused_addresses.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_mark_used.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_uint32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_mark_used.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_wallet_network.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_network.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_next_derivation_index.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_next_derivation_index.restype = ctypes.c_uint32
_UniffiLib.uniffi_bdkffi_fn_method_wallet_next_unused_address.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_next_unused_address.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_peek_address.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_uint32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_peek_address.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_persist.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_persist.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_wallet_policies.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_policies.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_public_descriptor.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_public_descriptor.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_reveal_addresses_to.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_uint32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_reveal_addresses_to.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_reveal_next_address.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_reveal_next_address.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_sent_and_received.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_sent_and_received.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_sign.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_sign.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_wallet_start_full_scan.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_start_full_scan.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_wallet_start_sync_with_revealed_spks.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_start_sync_with_revealed_spks.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_wallet_transactions.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_transactions.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wallet_tx_details.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wallet_tx_details.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_clone_wtxid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_clone_wtxid.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_free_wtxid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_free_wtxid.restype = None
_UniffiLib.uniffi_bdkffi_fn_constructor_wtxid_from_bytes.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_wtxid_from_bytes.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_constructor_wtxid_from_string.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_constructor_wtxid_from_string.restype = ctypes.c_void_p
_UniffiLib.uniffi_bdkffi_fn_method_wtxid_serialize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wtxid_serialize.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wtxid_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wtxid_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_bdkffi_fn_method_wtxid_uniffi_trait_eq_eq.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wtxid_uniffi_trait_eq_eq.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_wtxid_uniffi_trait_eq_ne.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wtxid_uniffi_trait_eq_ne.restype = ctypes.c_int8
_UniffiLib.uniffi_bdkffi_fn_method_wtxid_uniffi_trait_hash.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_bdkffi_fn_method_wtxid_uniffi_trait_hash.restype = ctypes.c_uint64
_UniffiLib.ffi_bdkffi_rustbuffer_alloc.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rustbuffer_alloc.restype = _UniffiRustBuffer
_UniffiLib.ffi_bdkffi_rustbuffer_from_bytes.argtypes = (
    _UniffiForeignBytes,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rustbuffer_from_bytes.restype = _UniffiRustBuffer
_UniffiLib.ffi_bdkffi_rustbuffer_free.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rustbuffer_free.restype = None
_UniffiLib.ffi_bdkffi_rustbuffer_reserve.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rustbuffer_reserve.restype = _UniffiRustBuffer
_UniffiLib.ffi_bdkffi_rust_future_poll_u8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_u8.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_u8.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_free_u8.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_u8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_u8.restype = ctypes.c_uint8
_UniffiLib.ffi_bdkffi_rust_future_poll_i8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_i8.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_i8.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_free_i8.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_i8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_i8.restype = ctypes.c_int8
_UniffiLib.ffi_bdkffi_rust_future_poll_u16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_u16.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_u16.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_free_u16.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_u16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_u16.restype = ctypes.c_uint16
_UniffiLib.ffi_bdkffi_rust_future_poll_i16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_i16.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_i16.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_free_i16.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_i16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_i16.restype = ctypes.c_int16
_UniffiLib.ffi_bdkffi_rust_future_poll_u32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_u32.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_u32.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_free_u32.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_u32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_u32.restype = ctypes.c_uint32
_UniffiLib.ffi_bdkffi_rust_future_poll_i32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_i32.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_i32.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_free_i32.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_i32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_i32.restype = ctypes.c_int32
_UniffiLib.ffi_bdkffi_rust_future_poll_u64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_u64.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_u64.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_free_u64.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_u64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_u64.restype = ctypes.c_uint64
_UniffiLib.ffi_bdkffi_rust_future_poll_i64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_i64.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_i64.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_free_i64.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_i64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_i64.restype = ctypes.c_int64
_UniffiLib.ffi_bdkffi_rust_future_poll_f32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_f32.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_f32.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_free_f32.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_f32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_f32.restype = ctypes.c_float
_UniffiLib.ffi_bdkffi_rust_future_poll_f64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_f64.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_f64.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_free_f64.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_f64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_f64.restype = ctypes.c_double
_UniffiLib.ffi_bdkffi_rust_future_poll_pointer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_pointer.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_pointer.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_free_pointer.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_pointer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_pointer.restype = ctypes.c_void_p
_UniffiLib.ffi_bdkffi_rust_future_poll_rust_buffer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_rust_buffer.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_rust_buffer.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_free_rust_buffer.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_rust_buffer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_rust_buffer.restype = _UniffiRustBuffer
_UniffiLib.ffi_bdkffi_rust_future_poll_void.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_poll_void.restype = None
_UniffiLib.ffi_bdkffi_rust_future_cancel_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_cancel_void.restype = None
_UniffiLib.ffi_bdkffi_rust_future_free_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_bdkffi_rust_future_free_void.restype = None
_UniffiLib.ffi_bdkffi_rust_future_complete_void.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_bdkffi_rust_future_complete_void.restype = None
_UniffiLib.uniffi_bdkffi_checksum_method_address_is_valid_for_network.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_address_is_valid_for_network.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_address_script_pubkey.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_address_script_pubkey.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_address_to_address_data.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_address_to_address_data.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_address_to_qr_uri.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_address_to_qr_uri.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_amount_to_btc.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_amount_to_btc.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_amount_to_sat.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_amount_to_sat.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_blockhash_serialize.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_blockhash_serialize.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_bumpfeetxbuilder_allow_dust.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_bumpfeetxbuilder_allow_dust.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_bumpfeetxbuilder_current_height.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_bumpfeetxbuilder_current_height.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_bumpfeetxbuilder_finish.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_bumpfeetxbuilder_finish.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_bumpfeetxbuilder_nlocktime.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_bumpfeetxbuilder_nlocktime.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_bumpfeetxbuilder_set_exact_sequence.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_bumpfeetxbuilder_set_exact_sequence.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_bumpfeetxbuilder_version.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_bumpfeetxbuilder_version.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfbuilder_build.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfbuilder_build.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfbuilder_configure_timeout_millis.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfbuilder_configure_timeout_millis.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfbuilder_connections.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfbuilder_connections.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfbuilder_data_dir.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfbuilder_data_dir.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfbuilder_dns_resolver.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfbuilder_dns_resolver.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfbuilder_log_level.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfbuilder_log_level.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfbuilder_peers.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfbuilder_peers.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfbuilder_scan_type.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfbuilder_scan_type.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfbuilder_socks5_proxy.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfbuilder_socks5_proxy.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_add_revealed_scripts.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_add_revealed_scripts.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_average_fee_rate.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_average_fee_rate.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_broadcast.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_broadcast.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_connect.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_connect.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_is_running.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_is_running.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_lookup_host.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_lookup_host.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_min_broadcast_feerate.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_min_broadcast_feerate.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_next_info.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_next_info.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_next_log.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_next_log.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_next_warning.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_next_warning.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_shutdown.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_shutdown.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_update.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfclient_update.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_cbfnode_run.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_cbfnode_run.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_changeset_change_descriptor.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_changeset_change_descriptor.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_changeset_descriptor.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_changeset_descriptor.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_changeset_indexer_changeset.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_changeset_indexer_changeset.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_changeset_localchain_changeset.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_changeset_localchain_changeset.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_changeset_network.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_changeset_network.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_changeset_tx_graph_changeset.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_changeset_tx_graph_changeset.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptor_descriptor_id.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptor_descriptor_id.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptor_is_multipath.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptor_is_multipath.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptor_max_weight_to_satisfy.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptor_max_weight_to_satisfy.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptor_to_single_descriptors.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptor_to_single_descriptors.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptor_to_string_with_secret.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptor_to_string_with_secret.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorid_serialize.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorid_serialize.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorpublickey_derive.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorpublickey_derive.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorpublickey_extend.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorpublickey_extend.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorpublickey_is_multipath.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorpublickey_is_multipath.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorpublickey_master_fingerprint.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorpublickey_master_fingerprint.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorsecretkey_as_public.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorsecretkey_as_public.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorsecretkey_derive.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorsecretkey_derive.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorsecretkey_extend.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorsecretkey_extend.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorsecretkey_secret_bytes.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_descriptorsecretkey_secret_bytes.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_electrumclient_block_headers_subscribe.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_electrumclient_block_headers_subscribe.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_electrumclient_estimate_fee.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_electrumclient_estimate_fee.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_electrumclient_full_scan.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_electrumclient_full_scan.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_electrumclient_ping.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_electrumclient_ping.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_electrumclient_server_features.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_electrumclient_server_features.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_electrumclient_sync.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_electrumclient_sync.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_electrumclient_transaction_broadcast.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_electrumclient_transaction_broadcast.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_broadcast.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_broadcast.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_full_scan.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_full_scan.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_get_block_hash.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_get_block_hash.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_get_fee_estimates.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_get_fee_estimates.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_get_height.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_get_height.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_get_tx.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_get_tx.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_get_tx_info.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_get_tx_info.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_get_tx_status.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_get_tx_status.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_sync.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_esploraclient_sync.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_feerate_to_sat_per_kwu.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_feerate_to_sat_per_kwu.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_feerate_to_sat_per_vb_ceil.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_feerate_to_sat_per_vb_ceil.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_feerate_to_sat_per_vb_floor.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_feerate_to_sat_per_vb_floor.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_fullscanrequestbuilder_build.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_fullscanrequestbuilder_build.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_fullscanrequestbuilder_inspect_spks_for_all_keychains.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_fullscanrequestbuilder_inspect_spks_for_all_keychains.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_fullscanscriptinspector_inspect.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_fullscanscriptinspector_inspect.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_hashableoutpoint_outpoint.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_hashableoutpoint_outpoint.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_persistence_initialize.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_persistence_initialize.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_persistence_persist.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_persistence_persist.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_policy_as_string.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_policy_as_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_policy_contribution.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_policy_contribution.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_policy_id.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_policy_id.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_policy_item.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_policy_item.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_policy_requires_path.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_policy_requires_path.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_policy_satisfaction.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_policy_satisfaction.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_psbt_combine.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_psbt_combine.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_psbt_extract_tx.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_psbt_extract_tx.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_psbt_fee.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_psbt_fee.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_psbt_finalize.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_psbt_finalize.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_psbt_json_serialize.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_psbt_json_serialize.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_psbt_serialize.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_psbt_serialize.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_psbt_spend_utxo.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_psbt_spend_utxo.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_psbt_write_to_file.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_psbt_write_to_file.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_script_to_bytes.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_script_to_bytes.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_syncrequestbuilder_build.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_syncrequestbuilder_build.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_syncrequestbuilder_inspect_spks.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_syncrequestbuilder_inspect_spks.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_syncscriptinspector_inspect.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_syncscriptinspector_inspect.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_compute_txid.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_compute_txid.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_compute_wtxid.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_compute_wtxid.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_input.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_input.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_is_coinbase.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_is_coinbase.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_is_explicitly_rbf.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_is_explicitly_rbf.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_is_lock_time_enabled.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_is_lock_time_enabled.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_lock_time.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_lock_time.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_output.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_output.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_serialize.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_serialize.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_total_size.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_total_size.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_version.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_version.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_vsize.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_vsize.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_weight.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_transaction_weight.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_add_data.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_add_data.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_add_global_xpubs.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_add_global_xpubs.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_add_recipient.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_add_recipient.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_add_unspendable.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_add_unspendable.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_add_utxo.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_add_utxo.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_add_utxos.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_add_utxos.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_allow_dust.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_allow_dust.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_change_policy.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_change_policy.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_current_height.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_current_height.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_do_not_spend_change.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_do_not_spend_change.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_drain_to.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_drain_to.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_drain_wallet.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_drain_wallet.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_fee_absolute.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_fee_absolute.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_fee_rate.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_fee_rate.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_finish.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_finish.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_manually_selected_only.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_manually_selected_only.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_nlocktime.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_nlocktime.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_only_spend_change.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_only_spend_change.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_policy_path.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_policy_path.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_set_exact_sequence.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_set_exact_sequence.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_set_recipients.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_set_recipients.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_unspendable.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_unspendable.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_version.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txbuilder_version.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txmerklenode_serialize.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txmerklenode_serialize.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_txid_serialize.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_txid_serialize.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_apply_unconfirmed_txs.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_apply_unconfirmed_txs.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_apply_update.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_apply_update.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_balance.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_balance.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_calculate_fee.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_calculate_fee.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_calculate_fee_rate.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_calculate_fee_rate.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_cancel_tx.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_cancel_tx.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_derivation_index.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_derivation_index.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_derivation_of_spk.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_derivation_of_spk.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_descriptor_checksum.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_descriptor_checksum.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_finalize_psbt.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_finalize_psbt.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_get_tx.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_get_tx.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_get_utxo.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_get_utxo.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_is_mine.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_is_mine.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_latest_checkpoint.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_latest_checkpoint.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_list_output.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_list_output.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_list_unspent.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_list_unspent.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_list_unused_addresses.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_list_unused_addresses.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_mark_used.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_mark_used.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_network.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_network.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_next_derivation_index.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_next_derivation_index.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_next_unused_address.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_next_unused_address.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_peek_address.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_peek_address.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_persist.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_persist.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_policies.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_policies.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_public_descriptor.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_public_descriptor.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_reveal_addresses_to.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_reveal_addresses_to.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_reveal_next_address.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_reveal_next_address.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_sent_and_received.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_sent_and_received.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_sign.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_sign.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_start_full_scan.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_start_full_scan.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_start_sync_with_revealed_spks.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_start_sync_with_revealed_spks.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_transactions.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_transactions.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_tx_details.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wallet_tx_details.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_method_wtxid_serialize.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_method_wtxid_serialize.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_address_from_script.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_address_from_script.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_address_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_address_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_amount_from_btc.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_amount_from_btc.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_amount_from_sat.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_amount_from_sat.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_blockhash_from_bytes.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_blockhash_from_bytes.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_blockhash_from_string.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_blockhash_from_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_bumpfeetxbuilder_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_bumpfeetxbuilder_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_cbfbuilder_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_cbfbuilder_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_changeset_from_aggregate.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_changeset_from_aggregate.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_changeset_from_descriptor_and_network.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_changeset_from_descriptor_and_network.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_changeset_from_indexer_changeset.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_changeset_from_indexer_changeset.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_changeset_from_local_chain_changes.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_changeset_from_local_chain_changes.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_changeset_from_merge.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_changeset_from_merge.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_changeset_from_tx_graph_changeset.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_changeset_from_tx_graph_changeset.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_changeset_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_changeset_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_derivationpath_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_derivationpath_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip44.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip44.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip44_public.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip44_public.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip49.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip49.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip49_public.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip49_public.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip84.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip84.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip84_public.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip84_public.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip86.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip86.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip86_public.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptor_new_bip86_public.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptorid_from_bytes.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptorid_from_bytes.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptorid_from_string.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptorid_from_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptorpublickey_from_string.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptorpublickey_from_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptorsecretkey_from_string.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptorsecretkey_from_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptorsecretkey_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_descriptorsecretkey_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_electrumclient_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_electrumclient_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_esploraclient_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_esploraclient_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_feerate_from_sat_per_kwu.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_feerate_from_sat_per_kwu.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_feerate_from_sat_per_vb.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_feerate_from_sat_per_vb.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_hashableoutpoint_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_hashableoutpoint_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_ipaddress_from_ipv4.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_ipaddress_from_ipv4.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_ipaddress_from_ipv6.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_ipaddress_from_ipv6.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_mnemonic_from_entropy.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_mnemonic_from_entropy.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_mnemonic_from_string.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_mnemonic_from_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_mnemonic_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_mnemonic_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_persister_custom.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_persister_custom.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_persister_new_in_memory.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_persister_new_in_memory.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_persister_new_sqlite.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_persister_new_sqlite.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_psbt_from_file.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_psbt_from_file.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_psbt_from_unsigned_tx.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_psbt_from_unsigned_tx.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_psbt_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_psbt_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_script_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_script_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_transaction_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_transaction_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_txbuilder_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_txbuilder_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_txmerklenode_from_bytes.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_txmerklenode_from_bytes.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_txmerklenode_from_string.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_txmerklenode_from_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_txid_from_bytes.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_txid_from_bytes.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_txid_from_string.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_txid_from_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_wallet_load.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_wallet_load.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_wallet_new.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_wallet_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_wtxid_from_bytes.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_wtxid_from_bytes.restype = ctypes.c_uint16
_UniffiLib.uniffi_bdkffi_checksum_constructor_wtxid_from_string.argtypes = (
)
_UniffiLib.uniffi_bdkffi_checksum_constructor_wtxid_from_string.restype = ctypes.c_uint16
_UniffiLib.ffi_bdkffi_uniffi_contract_version.argtypes = (
)
_UniffiLib.ffi_bdkffi_uniffi_contract_version.restype = ctypes.c_uint32

_uniffi_check_contract_api_version(_UniffiLib)
# _uniffi_check_api_checksums(_UniffiLib)

# Public interface members begin here.


class _UniffiConverterUInt8(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u8"
    VALUE_MIN = 0
    VALUE_MAX = 2**8

    @staticmethod
    def read(buf):
        return buf.read_u8()

    @staticmethod
    def write(value, buf):
        buf.write_u8(value)

class _UniffiConverterUInt16(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u16"
    VALUE_MIN = 0
    VALUE_MAX = 2**16

    @staticmethod
    def read(buf):
        return buf.read_u16()

    @staticmethod
    def write(value, buf):
        buf.write_u16(value)

class _UniffiConverterUInt32(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u32"
    VALUE_MIN = 0
    VALUE_MAX = 2**32

    @staticmethod
    def read(buf):
        return buf.read_u32()

    @staticmethod
    def write(value, buf):
        buf.write_u32(value)

class _UniffiConverterInt32(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "i32"
    VALUE_MIN = -2**31
    VALUE_MAX = 2**31

    @staticmethod
    def read(buf):
        return buf.read_i32()

    @staticmethod
    def write(value, buf):
        buf.write_i32(value)

class _UniffiConverterUInt64(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u64"
    VALUE_MIN = 0
    VALUE_MAX = 2**64

    @staticmethod
    def read(buf):
        return buf.read_u64()

    @staticmethod
    def write(value, buf):
        buf.write_u64(value)

class _UniffiConverterInt64(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "i64"
    VALUE_MIN = -2**63
    VALUE_MAX = 2**63

    @staticmethod
    def read(buf):
        return buf.read_i64()

    @staticmethod
    def write(value, buf):
        buf.write_i64(value)

class _UniffiConverterFloat(_UniffiConverterPrimitiveFloat):
    @staticmethod
    def read(buf):
        return buf.read_float()

    @staticmethod
    def write(value, buf):
        buf.write_float(value)

class _UniffiConverterDouble(_UniffiConverterPrimitiveFloat):
    @staticmethod
    def read(buf):
        return buf.read_double()

    @staticmethod
    def write(value, buf):
        buf.write_double(value)

class _UniffiConverterBool:
    @classmethod
    def check_lower(cls, value):
        return not not value

    @classmethod
    def lower(cls, value):
        return 1 if value else 0

    @staticmethod
    def lift(value):
        return value != 0

    @classmethod
    def read(cls, buf):
        return cls.lift(buf.read_u8())

    @classmethod
    def write(cls, value, buf):
        buf.write_u8(value)

class _UniffiConverterString:
    @staticmethod
    def check_lower(value):
        if not isinstance(value, str):
            raise TypeError("argument must be str, not {}".format(type(value).__name__))
        return value

    @staticmethod
    def read(buf):
        size = buf.read_i32()
        if size < 0:
            raise InternalError("Unexpected negative string length")
        utf8_bytes = buf.read(size)
        return utf8_bytes.decode("utf-8")

    @staticmethod
    def write(value, buf):
        utf8_bytes = value.encode("utf-8")
        buf.write_i32(len(utf8_bytes))
        buf.write(utf8_bytes)

    @staticmethod
    def lift(buf):
        with buf.consume_with_stream() as stream:
            return stream.read(stream.remaining()).decode("utf-8")

    @staticmethod
    def lower(value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            builder.write(value.encode("utf-8"))
            return builder.finalize()

class _UniffiConverterBytes(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        size = buf.read_i32()
        if size < 0:
            raise InternalError("Unexpected negative byte string length")
        return buf.read(size)

    @staticmethod
    def check_lower(value):
        try:
            memoryview(value)
        except TypeError:
            raise TypeError("a bytes-like object is required, not {!r}".format(type(value).__name__))

    @staticmethod
    def write(value, buf):
        buf.write_i32(len(value))
        buf.write(value)












































































class AddressInfo:
    """
    A derived address and the index it was found at.
    """

    index: "int"
    """
    Child index of this address
    """

    address: "Address"
    """
    The address
    """

    keychain: "KeychainKind"
    """
    Type of keychain
    """

    def __init__(self, *, index: "int", address: "Address", keychain: "KeychainKind"):
        self.index = index
        self.address = address
        self.keychain = keychain

    def __str__(self):
        return "AddressInfo(index={}, address={}, keychain={})".format(self.index, self.address, self.keychain)

    def __eq__(self, other):
        if self.index != other.index:
            return False
        if self.address != other.address:
            return False
        if self.keychain != other.keychain:
            return False
        return True

class _UniffiConverterTypeAddressInfo(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return AddressInfo(
            index=_UniffiConverterUInt32.read(buf),
            address=_UniffiConverterTypeAddress.read(buf),
            keychain=_UniffiConverterTypeKeychainKind.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.index)
        _UniffiConverterTypeAddress.check_lower(value.address)
        _UniffiConverterTypeKeychainKind.check_lower(value.keychain)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.index, buf)
        _UniffiConverterTypeAddress.write(value.address, buf)
        _UniffiConverterTypeKeychainKind.write(value.keychain, buf)


class Anchor:
    confirmation_block_time: "ConfirmationBlockTime"
    txid: "Txid"
    def __init__(self, *, confirmation_block_time: "ConfirmationBlockTime", txid: "Txid"):
        self.confirmation_block_time = confirmation_block_time
        self.txid = txid

    def __str__(self):
        return "Anchor(confirmation_block_time={}, txid={})".format(self.confirmation_block_time, self.txid)

    def __eq__(self, other):
        if self.confirmation_block_time != other.confirmation_block_time:
            return False
        if self.txid != other.txid:
            return False
        return True

class _UniffiConverterTypeAnchor(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Anchor(
            confirmation_block_time=_UniffiConverterTypeConfirmationBlockTime.read(buf),
            txid=_UniffiConverterTypeTxid.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeConfirmationBlockTime.check_lower(value.confirmation_block_time)
        _UniffiConverterTypeTxid.check_lower(value.txid)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeConfirmationBlockTime.write(value.confirmation_block_time, buf)
        _UniffiConverterTypeTxid.write(value.txid, buf)


class Balance:
    """
    Balance, differentiated into various categories.
    """

    immature: "Amount"
    """
    All coinbase outputs not yet matured
    """

    trusted_pending: "Amount"
    """
    Unconfirmed UTXOs generated by a wallet tx
    """

    untrusted_pending: "Amount"
    """
    Unconfirmed UTXOs received from an external wallet
    """

    confirmed: "Amount"
    """
    Confirmed and immediately spendable balance
    """

    trusted_spendable: "Amount"
    """
    Get sum of trusted_pending and confirmed coins.

    This is the balance you can spend right now that shouldn't get cancelled via another party
    double spending it.
    """

    total: "Amount"
    """
    Get the whole balance visible to the wallet.
    """

    def __init__(self, *, immature: "Amount", trusted_pending: "Amount", untrusted_pending: "Amount", confirmed: "Amount", trusted_spendable: "Amount", total: "Amount"):
        self.immature = immature
        self.trusted_pending = trusted_pending
        self.untrusted_pending = untrusted_pending
        self.confirmed = confirmed
        self.trusted_spendable = trusted_spendable
        self.total = total

    def __str__(self):
        return "Balance(immature={}, trusted_pending={}, untrusted_pending={}, confirmed={}, trusted_spendable={}, total={})".format(self.immature, self.trusted_pending, self.untrusted_pending, self.confirmed, self.trusted_spendable, self.total)

    def __eq__(self, other):
        if self.immature != other.immature:
            return False
        if self.trusted_pending != other.trusted_pending:
            return False
        if self.untrusted_pending != other.untrusted_pending:
            return False
        if self.confirmed != other.confirmed:
            return False
        if self.trusted_spendable != other.trusted_spendable:
            return False
        if self.total != other.total:
            return False
        return True

class _UniffiConverterTypeBalance(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Balance(
            immature=_UniffiConverterTypeAmount.read(buf),
            trusted_pending=_UniffiConverterTypeAmount.read(buf),
            untrusted_pending=_UniffiConverterTypeAmount.read(buf),
            confirmed=_UniffiConverterTypeAmount.read(buf),
            trusted_spendable=_UniffiConverterTypeAmount.read(buf),
            total=_UniffiConverterTypeAmount.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeAmount.check_lower(value.immature)
        _UniffiConverterTypeAmount.check_lower(value.trusted_pending)
        _UniffiConverterTypeAmount.check_lower(value.untrusted_pending)
        _UniffiConverterTypeAmount.check_lower(value.confirmed)
        _UniffiConverterTypeAmount.check_lower(value.trusted_spendable)
        _UniffiConverterTypeAmount.check_lower(value.total)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeAmount.write(value.immature, buf)
        _UniffiConverterTypeAmount.write(value.trusted_pending, buf)
        _UniffiConverterTypeAmount.write(value.untrusted_pending, buf)
        _UniffiConverterTypeAmount.write(value.confirmed, buf)
        _UniffiConverterTypeAmount.write(value.trusted_spendable, buf)
        _UniffiConverterTypeAmount.write(value.total, buf)


class BlockId:
    """
    A reference to a block in the canonical chain.
    """

    height: "int"
    """
    The height of the block.
    """

    hash: "BlockHash"
    """
    The hash of the block.
    """

    def __init__(self, *, height: "int", hash: "BlockHash"):
        self.height = height
        self.hash = hash

    def __str__(self):
        return "BlockId(height={}, hash={})".format(self.height, self.hash)

    def __eq__(self, other):
        if self.height != other.height:
            return False
        if self.hash != other.hash:
            return False
        return True

class _UniffiConverterTypeBlockId(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return BlockId(
            height=_UniffiConverterUInt32.read(buf),
            hash=_UniffiConverterTypeBlockHash.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.height)
        _UniffiConverterTypeBlockHash.check_lower(value.hash)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.height, buf)
        _UniffiConverterTypeBlockHash.write(value.hash, buf)


class CanonicalTx:
    """
    A transaction that is deemed to be part of the canonical history.
    """

    transaction: "Transaction"
    """
    The transaction.
    """

    chain_position: "ChainPosition"
    """
    How the transaction is observed in the canonical chain (confirmed or unconfirmed).
    """

    def __init__(self, *, transaction: "Transaction", chain_position: "ChainPosition"):
        self.transaction = transaction
        self.chain_position = chain_position

    def __str__(self):
        return "CanonicalTx(transaction={}, chain_position={})".format(self.transaction, self.chain_position)

    def __eq__(self, other):
        if self.transaction != other.transaction:
            return False
        if self.chain_position != other.chain_position:
            return False
        return True

class _UniffiConverterTypeCanonicalTx(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return CanonicalTx(
            transaction=_UniffiConverterTypeTransaction.read(buf),
            chain_position=_UniffiConverterTypeChainPosition.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeTransaction.check_lower(value.transaction)
        _UniffiConverterTypeChainPosition.check_lower(value.chain_position)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeTransaction.write(value.transaction, buf)
        _UniffiConverterTypeChainPosition.write(value.chain_position, buf)


class CbfComponents:
    """
    Receive a [`CbfClient`] and [`CbfNode`].
    """

    client: "CbfClient"
    """
    Publish events to the node, like broadcasting transactions or adding scripts.
    """

    node: "CbfNode"
    """
    The node to run and fetch transactions for a [`Wallet`].
    """

    def __init__(self, *, client: "CbfClient", node: "CbfNode"):
        self.client = client
        self.node = node

    def __str__(self):
        return "CbfComponents(client={}, node={})".format(self.client, self.node)

    def __eq__(self, other):
        if self.client != other.client:
            return False
        if self.node != other.node:
            return False
        return True

class _UniffiConverterTypeCbfComponents(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return CbfComponents(
            client=_UniffiConverterTypeCbfClient.read(buf),
            node=_UniffiConverterTypeCbfNode.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeCbfClient.check_lower(value.client)
        _UniffiConverterTypeCbfNode.check_lower(value.node)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeCbfClient.write(value.client, buf)
        _UniffiConverterTypeCbfNode.write(value.node, buf)


class ChainChange:
    """
    The hash added or removed at the given height.
    """

    height: "int"
    """
    Effected height
    """

    hash: "typing.Optional[BlockHash]"
    """
    A hash was added or must be removed.
    """

    def __init__(self, *, height: "int", hash: "typing.Optional[BlockHash]"):
        self.height = height
        self.hash = hash

    def __str__(self):
        return "ChainChange(height={}, hash={})".format(self.height, self.hash)

    def __eq__(self, other):
        if self.height != other.height:
            return False
        if self.hash != other.hash:
            return False
        return True

class _UniffiConverterTypeChainChange(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ChainChange(
            height=_UniffiConverterUInt32.read(buf),
            hash=_UniffiConverterOptionalTypeBlockHash.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.height)
        _UniffiConverterOptionalTypeBlockHash.check_lower(value.hash)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.height, buf)
        _UniffiConverterOptionalTypeBlockHash.write(value.hash, buf)


class Condition:
    """
    An extra condition that must be satisfied but that is out of control of the user
    """

    csv: "typing.Optional[int]"
    """
    Optional CheckSequenceVerify condition
    """

    timelock: "typing.Optional[LockTime]"
    """
    Optional timelock condition
    """

    def __init__(self, *, csv: "typing.Optional[int]", timelock: "typing.Optional[LockTime]"):
        self.csv = csv
        self.timelock = timelock

    def __str__(self):
        return "Condition(csv={}, timelock={})".format(self.csv, self.timelock)

    def __eq__(self, other):
        if self.csv != other.csv:
            return False
        if self.timelock != other.timelock:
            return False
        return True

class _UniffiConverterTypeCondition(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Condition(
            csv=_UniffiConverterOptionalUInt32.read(buf),
            timelock=_UniffiConverterOptionalTypeLockTime.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalUInt32.check_lower(value.csv)
        _UniffiConverterOptionalTypeLockTime.check_lower(value.timelock)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalUInt32.write(value.csv, buf)
        _UniffiConverterOptionalTypeLockTime.write(value.timelock, buf)


class ConfirmationBlockTime:
    """
    Represents the confirmation block and time of a transaction.
    """

    block_id: "BlockId"
    """
    The anchor block.
    """

    confirmation_time: "int"
    """
    The confirmation time of the transaction being anchored.
    """

    def __init__(self, *, block_id: "BlockId", confirmation_time: "int"):
        self.block_id = block_id
        self.confirmation_time = confirmation_time

    def __str__(self):
        return "ConfirmationBlockTime(block_id={}, confirmation_time={})".format(self.block_id, self.confirmation_time)

    def __eq__(self, other):
        if self.block_id != other.block_id:
            return False
        if self.confirmation_time != other.confirmation_time:
            return False
        return True

class _UniffiConverterTypeConfirmationBlockTime(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ConfirmationBlockTime(
            block_id=_UniffiConverterTypeBlockId.read(buf),
            confirmation_time=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeBlockId.check_lower(value.block_id)
        _UniffiConverterUInt64.check_lower(value.confirmation_time)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeBlockId.write(value.block_id, buf)
        _UniffiConverterUInt64.write(value.confirmation_time, buf)


class FinalizedPsbtResult:
    psbt: "Psbt"
    could_finalize: "bool"
    errors: "typing.Optional[typing.List[PsbtFinalizeError]]"
    def __init__(self, *, psbt: "Psbt", could_finalize: "bool", errors: "typing.Optional[typing.List[PsbtFinalizeError]]"):
        self.psbt = psbt
        self.could_finalize = could_finalize
        self.errors = errors

    def __str__(self):
        return "FinalizedPsbtResult(psbt={}, could_finalize={}, errors={})".format(self.psbt, self.could_finalize, self.errors)

    def __eq__(self, other):
        if self.psbt != other.psbt:
            return False
        if self.could_finalize != other.could_finalize:
            return False
        if self.errors != other.errors:
            return False
        return True

class _UniffiConverterTypeFinalizedPsbtResult(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return FinalizedPsbtResult(
            psbt=_UniffiConverterTypePsbt.read(buf),
            could_finalize=_UniffiConverterBool.read(buf),
            errors=_UniffiConverterOptionalSequenceTypePsbtFinalizeError.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypePsbt.check_lower(value.psbt)
        _UniffiConverterBool.check_lower(value.could_finalize)
        _UniffiConverterOptionalSequenceTypePsbtFinalizeError.check_lower(value.errors)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypePsbt.write(value.psbt, buf)
        _UniffiConverterBool.write(value.could_finalize, buf)
        _UniffiConverterOptionalSequenceTypePsbtFinalizeError.write(value.errors, buf)


class Header:
    """
    Bitcoin block header.
    Contains all the block’s information except the actual transactions, but including a root of a merkle tree
    committing to all transactions in the block.
    """

    version: "int"
    """
    Block version, now repurposed for soft fork signalling.
    """

    prev_blockhash: "BlockHash"
    """
    Reference to the previous block in the chain.
    """

    merkle_root: "TxMerkleNode"
    """
    The root hash of the merkle tree of transactions in the block.
    """

    time: "int"
    """
    The timestamp of the block, as claimed by the miner.
    """

    bits: "int"
    """
    The target value below which the blockhash must lie.
    """

    nonce: "int"
    """
    The nonce, selected to obtain a low enough blockhash.
    """

    def __init__(self, *, version: "int", prev_blockhash: "BlockHash", merkle_root: "TxMerkleNode", time: "int", bits: "int", nonce: "int"):
        self.version = version
        self.prev_blockhash = prev_blockhash
        self.merkle_root = merkle_root
        self.time = time
        self.bits = bits
        self.nonce = nonce

    def __str__(self):
        return "Header(version={}, prev_blockhash={}, merkle_root={}, time={}, bits={}, nonce={})".format(self.version, self.prev_blockhash, self.merkle_root, self.time, self.bits, self.nonce)

    def __eq__(self, other):
        if self.version != other.version:
            return False
        if self.prev_blockhash != other.prev_blockhash:
            return False
        if self.merkle_root != other.merkle_root:
            return False
        if self.time != other.time:
            return False
        if self.bits != other.bits:
            return False
        if self.nonce != other.nonce:
            return False
        return True

class _UniffiConverterTypeHeader(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Header(
            version=_UniffiConverterInt32.read(buf),
            prev_blockhash=_UniffiConverterTypeBlockHash.read(buf),
            merkle_root=_UniffiConverterTypeTxMerkleNode.read(buf),
            time=_UniffiConverterUInt32.read(buf),
            bits=_UniffiConverterUInt32.read(buf),
            nonce=_UniffiConverterUInt32.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterInt32.check_lower(value.version)
        _UniffiConverterTypeBlockHash.check_lower(value.prev_blockhash)
        _UniffiConverterTypeTxMerkleNode.check_lower(value.merkle_root)
        _UniffiConverterUInt32.check_lower(value.time)
        _UniffiConverterUInt32.check_lower(value.bits)
        _UniffiConverterUInt32.check_lower(value.nonce)

    @staticmethod
    def write(value, buf):
        _UniffiConverterInt32.write(value.version, buf)
        _UniffiConverterTypeBlockHash.write(value.prev_blockhash, buf)
        _UniffiConverterTypeTxMerkleNode.write(value.merkle_root, buf)
        _UniffiConverterUInt32.write(value.time, buf)
        _UniffiConverterUInt32.write(value.bits, buf)
        _UniffiConverterUInt32.write(value.nonce, buf)


class HeaderNotification:
    """
    Notification of a new block header.
    """

    height: "int"
    """
    New block height.
    """

    header: "Header"
    """
    Newly added header.
    """

    def __init__(self, *, height: "int", header: "Header"):
        self.height = height
        self.header = header

    def __str__(self):
        return "HeaderNotification(height={}, header={})".format(self.height, self.header)

    def __eq__(self, other):
        if self.height != other.height:
            return False
        if self.header != other.header:
            return False
        return True

class _UniffiConverterTypeHeaderNotification(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return HeaderNotification(
            height=_UniffiConverterUInt64.read(buf),
            header=_UniffiConverterTypeHeader.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt64.check_lower(value.height)
        _UniffiConverterTypeHeader.check_lower(value.header)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt64.write(value.height, buf)
        _UniffiConverterTypeHeader.write(value.header, buf)


class IndexerChangeSet:
    """
    Mapping of descriptors to their last revealed index.
    """

    last_revealed: "dict[DescriptorId, int]"
    def __init__(self, *, last_revealed: "dict[DescriptorId, int]"):
        self.last_revealed = last_revealed

    def __str__(self):
        return "IndexerChangeSet(last_revealed={})".format(self.last_revealed)

    def __eq__(self, other):
        if self.last_revealed != other.last_revealed:
            return False
        return True

class _UniffiConverterTypeIndexerChangeSet(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return IndexerChangeSet(
            last_revealed=_UniffiConverterMapTypeDescriptorIdUInt32.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterMapTypeDescriptorIdUInt32.check_lower(value.last_revealed)

    @staticmethod
    def write(value, buf):
        _UniffiConverterMapTypeDescriptorIdUInt32.write(value.last_revealed, buf)


class KeychainAndIndex:
    """
    The keychain kind and the index in that keychain.
    """

    keychain: "KeychainKind"
    """
    Type of keychains.
    """

    index: "int"
    """
    The index in the keychain.
    """

    def __init__(self, *, keychain: "KeychainKind", index: "int"):
        self.keychain = keychain
        self.index = index

    def __str__(self):
        return "KeychainAndIndex(keychain={}, index={})".format(self.keychain, self.index)

    def __eq__(self, other):
        if self.keychain != other.keychain:
            return False
        if self.index != other.index:
            return False
        return True

class _UniffiConverterTypeKeychainAndIndex(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return KeychainAndIndex(
            keychain=_UniffiConverterTypeKeychainKind.read(buf),
            index=_UniffiConverterUInt32.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeKeychainKind.check_lower(value.keychain)
        _UniffiConverterUInt32.check_lower(value.index)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeKeychainKind.write(value.keychain, buf)
        _UniffiConverterUInt32.write(value.index, buf)


class LocalChainChangeSet:
    """
    Changes to the local chain
    """

    changes: "typing.List[ChainChange]"
    def __init__(self, *, changes: "typing.List[ChainChange]"):
        self.changes = changes

    def __str__(self):
        return "LocalChainChangeSet(changes={})".format(self.changes)

    def __eq__(self, other):
        if self.changes != other.changes:
            return False
        return True

class _UniffiConverterTypeLocalChainChangeSet(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LocalChainChangeSet(
            changes=_UniffiConverterSequenceTypeChainChange.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterSequenceTypeChainChange.check_lower(value.changes)

    @staticmethod
    def write(value, buf):
        _UniffiConverterSequenceTypeChainChange.write(value.changes, buf)


class LocalOutput:
    """
    An unspent output owned by a [`Wallet`].
    """

    outpoint: "OutPoint"
    """
    Reference to a transaction output
    """

    txout: "TxOut"
    """
    Transaction output
    """

    keychain: "KeychainKind"
    """
    Type of keychain
    """

    is_spent: "bool"
    """
    Whether this UTXO is spent or not
    """

    derivation_index: "int"
    """
    The derivation index for the script pubkey in the wallet
    """

    chain_position: "ChainPosition"
    """
    The position of the output in the blockchain.
    """

    def __init__(self, *, outpoint: "OutPoint", txout: "TxOut", keychain: "KeychainKind", is_spent: "bool", derivation_index: "int", chain_position: "ChainPosition"):
        self.outpoint = outpoint
        self.txout = txout
        self.keychain = keychain
        self.is_spent = is_spent
        self.derivation_index = derivation_index
        self.chain_position = chain_position

    def __str__(self):
        return "LocalOutput(outpoint={}, txout={}, keychain={}, is_spent={}, derivation_index={}, chain_position={})".format(self.outpoint, self.txout, self.keychain, self.is_spent, self.derivation_index, self.chain_position)

    def __eq__(self, other):
        if self.outpoint != other.outpoint:
            return False
        if self.txout != other.txout:
            return False
        if self.keychain != other.keychain:
            return False
        if self.is_spent != other.is_spent:
            return False
        if self.derivation_index != other.derivation_index:
            return False
        if self.chain_position != other.chain_position:
            return False
        return True

class _UniffiConverterTypeLocalOutput(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LocalOutput(
            outpoint=_UniffiConverterTypeOutPoint.read(buf),
            txout=_UniffiConverterTypeTxOut.read(buf),
            keychain=_UniffiConverterTypeKeychainKind.read(buf),
            is_spent=_UniffiConverterBool.read(buf),
            derivation_index=_UniffiConverterUInt32.read(buf),
            chain_position=_UniffiConverterTypeChainPosition.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeOutPoint.check_lower(value.outpoint)
        _UniffiConverterTypeTxOut.check_lower(value.txout)
        _UniffiConverterTypeKeychainKind.check_lower(value.keychain)
        _UniffiConverterBool.check_lower(value.is_spent)
        _UniffiConverterUInt32.check_lower(value.derivation_index)
        _UniffiConverterTypeChainPosition.check_lower(value.chain_position)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeOutPoint.write(value.outpoint, buf)
        _UniffiConverterTypeTxOut.write(value.txout, buf)
        _UniffiConverterTypeKeychainKind.write(value.keychain, buf)
        _UniffiConverterBool.write(value.is_spent, buf)
        _UniffiConverterUInt32.write(value.derivation_index, buf)
        _UniffiConverterTypeChainPosition.write(value.chain_position, buf)


class OutPoint:
    """
    A reference to an unspent output by TXID and output index.
    """

    txid: "Txid"
    """
    The transaction.
    """

    vout: "int"
    """
    The index of the output in the transaction.
    """

    def __init__(self, *, txid: "Txid", vout: "int"):
        self.txid = txid
        self.vout = vout

    def __str__(self):
        return "OutPoint(txid={}, vout={})".format(self.txid, self.vout)

    def __eq__(self, other):
        if self.txid != other.txid:
            return False
        if self.vout != other.vout:
            return False
        return True

class _UniffiConverterTypeOutPoint(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return OutPoint(
            txid=_UniffiConverterTypeTxid.read(buf),
            vout=_UniffiConverterUInt32.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeTxid.check_lower(value.txid)
        _UniffiConverterUInt32.check_lower(value.vout)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeTxid.write(value.txid, buf)
        _UniffiConverterUInt32.write(value.vout, buf)


class Peer:
    """
    A peer to connect to over the Bitcoin peer-to-peer network.
    """

    address: "IpAddress"
    """
    The IP address to reach the node.
    """

    port: "typing.Optional[int]"
    """
    The port to reach the node. If none is provided, the default
    port for the selected network will be used.
    """

    v2_transport: "bool"
    """
    Does the remote node offer encrypted peer-to-peer connection.
    """

    def __init__(self, *, address: "IpAddress", port: "typing.Optional[int]", v2_transport: "bool"):
        self.address = address
        self.port = port
        self.v2_transport = v2_transport

    def __str__(self):
        return "Peer(address={}, port={}, v2_transport={})".format(self.address, self.port, self.v2_transport)

    def __eq__(self, other):
        if self.address != other.address:
            return False
        if self.port != other.port:
            return False
        if self.v2_transport != other.v2_transport:
            return False
        return True

class _UniffiConverterTypePeer(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Peer(
            address=_UniffiConverterTypeIpAddress.read(buf),
            port=_UniffiConverterOptionalUInt16.read(buf),
            v2_transport=_UniffiConverterBool.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeIpAddress.check_lower(value.address)
        _UniffiConverterOptionalUInt16.check_lower(value.port)
        _UniffiConverterBool.check_lower(value.v2_transport)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeIpAddress.write(value.address, buf)
        _UniffiConverterOptionalUInt16.write(value.port, buf)
        _UniffiConverterBool.write(value.v2_transport, buf)


class ScriptAmount:
    """
    A bitcoin script and associated amount.
    """

    script: "Script"
    """
    The underlying script.
    """

    amount: "Amount"
    """
    The amount owned by the script.
    """

    def __init__(self, *, script: "Script", amount: "Amount"):
        self.script = script
        self.amount = amount

    def __str__(self):
        return "ScriptAmount(script={}, amount={})".format(self.script, self.amount)

    def __eq__(self, other):
        if self.script != other.script:
            return False
        if self.amount != other.amount:
            return False
        return True

class _UniffiConverterTypeScriptAmount(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ScriptAmount(
            script=_UniffiConverterTypeScript.read(buf),
            amount=_UniffiConverterTypeAmount.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeScript.check_lower(value.script)
        _UniffiConverterTypeAmount.check_lower(value.amount)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeScript.write(value.script, buf)
        _UniffiConverterTypeAmount.write(value.amount, buf)


class SentAndReceivedValues:
    """
    The total value sent and received.
    """

    sent: "Amount"
    """
    Amount sent in the transaction.
    """

    received: "Amount"
    """
    The amount received in the transaction, possibly as a change output(s).
    """

    def __init__(self, *, sent: "Amount", received: "Amount"):
        self.sent = sent
        self.received = received

    def __str__(self):
        return "SentAndReceivedValues(sent={}, received={})".format(self.sent, self.received)

    def __eq__(self, other):
        if self.sent != other.sent:
            return False
        if self.received != other.received:
            return False
        return True

class _UniffiConverterTypeSentAndReceivedValues(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SentAndReceivedValues(
            sent=_UniffiConverterTypeAmount.read(buf),
            received=_UniffiConverterTypeAmount.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeAmount.check_lower(value.sent)
        _UniffiConverterTypeAmount.check_lower(value.received)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeAmount.write(value.sent, buf)
        _UniffiConverterTypeAmount.write(value.received, buf)


class ServerFeaturesRes:
    """
    Response to an ElectrumClient.server_features request.
    """

    server_version: "str"
    """
    Server version reported.
    """

    genesis_hash: "BlockHash"
    """
    Hash of the genesis block.
    """

    protocol_min: "str"
    """
    Minimum supported version of the protocol.
    """

    protocol_max: "str"
    """
    Maximum supported version of the protocol.
    """

    hash_function: "typing.Optional[str]"
    """
    Hash function used to create the `ScriptHash`.
    """

    pruning: "typing.Optional[int]"
    """
    Pruned height of the server.
    """

    def __init__(self, *, server_version: "str", genesis_hash: "BlockHash", protocol_min: "str", protocol_max: "str", hash_function: "typing.Optional[str]", pruning: "typing.Optional[int]"):
        self.server_version = server_version
        self.genesis_hash = genesis_hash
        self.protocol_min = protocol_min
        self.protocol_max = protocol_max
        self.hash_function = hash_function
        self.pruning = pruning

    def __str__(self):
        return "ServerFeaturesRes(server_version={}, genesis_hash={}, protocol_min={}, protocol_max={}, hash_function={}, pruning={})".format(self.server_version, self.genesis_hash, self.protocol_min, self.protocol_max, self.hash_function, self.pruning)

    def __eq__(self, other):
        if self.server_version != other.server_version:
            return False
        if self.genesis_hash != other.genesis_hash:
            return False
        if self.protocol_min != other.protocol_min:
            return False
        if self.protocol_max != other.protocol_max:
            return False
        if self.hash_function != other.hash_function:
            return False
        if self.pruning != other.pruning:
            return False
        return True

class _UniffiConverterTypeServerFeaturesRes(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ServerFeaturesRes(
            server_version=_UniffiConverterString.read(buf),
            genesis_hash=_UniffiConverterTypeBlockHash.read(buf),
            protocol_min=_UniffiConverterString.read(buf),
            protocol_max=_UniffiConverterString.read(buf),
            hash_function=_UniffiConverterOptionalString.read(buf),
            pruning=_UniffiConverterOptionalInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.server_version)
        _UniffiConverterTypeBlockHash.check_lower(value.genesis_hash)
        _UniffiConverterString.check_lower(value.protocol_min)
        _UniffiConverterString.check_lower(value.protocol_max)
        _UniffiConverterOptionalString.check_lower(value.hash_function)
        _UniffiConverterOptionalInt64.check_lower(value.pruning)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.server_version, buf)
        _UniffiConverterTypeBlockHash.write(value.genesis_hash, buf)
        _UniffiConverterString.write(value.protocol_min, buf)
        _UniffiConverterString.write(value.protocol_max, buf)
        _UniffiConverterOptionalString.write(value.hash_function, buf)
        _UniffiConverterOptionalInt64.write(value.pruning, buf)


class SignOptions:
    """
    Options for a software signer.

    Adjust the behavior of our software signers and the way a transaction is finalized.
    """

    trust_witness_utxo: "bool"
    """
    Whether the signer should trust the `witness_utxo`, if the `non_witness_utxo` hasn't been
    provided

    Defaults to `false` to mitigate the "SegWit bug" which could trick the wallet into
    paying a fee larger than expected.

    Some wallets, especially if relatively old, might not provide the `non_witness_utxo` for
    SegWit transactions in the PSBT they generate: in those cases setting this to `true`
    should correctly produce a signature, at the expense of an increased trust in the creator
    of the PSBT.

    For more details see: <https://blog.trezor.io/details-of-firmware-updates-for-trezor-one-version-1-9-1-and-trezor-model-t-version-2-3-1-1eba8f60f2dd>
    """

    assume_height: "typing.Optional[int]"
    """
    Whether the wallet should assume a specific height has been reached when trying to finalize
    a transaction

    The wallet will only "use" a timelock to satisfy the spending policy of an input if the
    timelock height has already been reached. This option allows overriding the "current height" to let the
    wallet use timelocks in the future to spend a coin.
    """

    allow_all_sighashes: "bool"
    """
    Whether the signer should use the `sighash_type` set in the PSBT when signing, no matter
    what its value is

    Defaults to `false` which will only allow signing using `SIGHASH_ALL`.
    """

    try_finalize: "bool"
    """
    Whether to try finalizing the PSBT after the inputs are signed.

    Defaults to `true` which will try finalizing PSBT after inputs are signed.
    """

    sign_with_tap_internal_key: "bool"
    """
    Whether we should try to sign a taproot transaction with the taproot internal key
    or not. This option is ignored if we're signing a non-taproot PSBT.

    Defaults to `true`, i.e., we always try to sign with the taproot internal key.
    """

    allow_grinding: "bool"
    """
    Whether we should grind ECDSA signature to ensure signing with low r
    or not.
    Defaults to `true`, i.e., we always grind ECDSA signature to sign with low r.
    """

    def __init__(self, *, trust_witness_utxo: "bool", assume_height: "typing.Optional[int]", allow_all_sighashes: "bool", try_finalize: "bool", sign_with_tap_internal_key: "bool", allow_grinding: "bool"):
        self.trust_witness_utxo = trust_witness_utxo
        self.assume_height = assume_height
        self.allow_all_sighashes = allow_all_sighashes
        self.try_finalize = try_finalize
        self.sign_with_tap_internal_key = sign_with_tap_internal_key
        self.allow_grinding = allow_grinding

    def __str__(self):
        return "SignOptions(trust_witness_utxo={}, assume_height={}, allow_all_sighashes={}, try_finalize={}, sign_with_tap_internal_key={}, allow_grinding={})".format(self.trust_witness_utxo, self.assume_height, self.allow_all_sighashes, self.try_finalize, self.sign_with_tap_internal_key, self.allow_grinding)

    def __eq__(self, other):
        if self.trust_witness_utxo != other.trust_witness_utxo:
            return False
        if self.assume_height != other.assume_height:
            return False
        if self.allow_all_sighashes != other.allow_all_sighashes:
            return False
        if self.try_finalize != other.try_finalize:
            return False
        if self.sign_with_tap_internal_key != other.sign_with_tap_internal_key:
            return False
        if self.allow_grinding != other.allow_grinding:
            return False
        return True

class _UniffiConverterTypeSignOptions(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SignOptions(
            trust_witness_utxo=_UniffiConverterBool.read(buf),
            assume_height=_UniffiConverterOptionalUInt32.read(buf),
            allow_all_sighashes=_UniffiConverterBool.read(buf),
            try_finalize=_UniffiConverterBool.read(buf),
            sign_with_tap_internal_key=_UniffiConverterBool.read(buf),
            allow_grinding=_UniffiConverterBool.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterBool.check_lower(value.trust_witness_utxo)
        _UniffiConverterOptionalUInt32.check_lower(value.assume_height)
        _UniffiConverterBool.check_lower(value.allow_all_sighashes)
        _UniffiConverterBool.check_lower(value.try_finalize)
        _UniffiConverterBool.check_lower(value.sign_with_tap_internal_key)
        _UniffiConverterBool.check_lower(value.allow_grinding)

    @staticmethod
    def write(value, buf):
        _UniffiConverterBool.write(value.trust_witness_utxo, buf)
        _UniffiConverterOptionalUInt32.write(value.assume_height, buf)
        _UniffiConverterBool.write(value.allow_all_sighashes, buf)
        _UniffiConverterBool.write(value.try_finalize, buf)
        _UniffiConverterBool.write(value.sign_with_tap_internal_key, buf)
        _UniffiConverterBool.write(value.allow_grinding, buf)


class Socks5Proxy:
    """
    A proxy to route network traffic, most likely through a Tor daemon. Normally this proxy is
    exposed at 127.0.0.1:9050.
    """

    address: "IpAddress"
    """
    The IP address, likely `127.0.0.1`
    """

    port: "int"
    """
    The listening port, likely `9050`
    """

    def __init__(self, *, address: "IpAddress", port: "int"):
        self.address = address
        self.port = port

    def __str__(self):
        return "Socks5Proxy(address={}, port={})".format(self.address, self.port)

    def __eq__(self, other):
        if self.address != other.address:
            return False
        if self.port != other.port:
            return False
        return True

class _UniffiConverterTypeSocks5Proxy(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Socks5Proxy(
            address=_UniffiConverterTypeIpAddress.read(buf),
            port=_UniffiConverterUInt16.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeIpAddress.check_lower(value.address)
        _UniffiConverterUInt16.check_lower(value.port)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeIpAddress.write(value.address, buf)
        _UniffiConverterUInt16.write(value.port, buf)


class Tx:
    """
    Bitcoin transaction metadata.
    """

    txid: "Txid"
    """
    The transaction identifier.
    """

    version: "int"
    """
    The transaction version, of which 0, 1, 2 are standard.
    """

    locktime: "int"
    """
    The block height or time restriction on the transaction.
    """

    size: "int"
    """
    The size of the transaction in bytes.
    """

    weight: "int"
    """
    The weight units of this transaction.
    """

    fee: "int"
    """
    The fee of this transaction in satoshis.
    """

    status: "TxStatus"
    """
    Confirmation status and data.
    """

    def __init__(self, *, txid: "Txid", version: "int", locktime: "int", size: "int", weight: "int", fee: "int", status: "TxStatus"):
        self.txid = txid
        self.version = version
        self.locktime = locktime
        self.size = size
        self.weight = weight
        self.fee = fee
        self.status = status

    def __str__(self):
        return "Tx(txid={}, version={}, locktime={}, size={}, weight={}, fee={}, status={})".format(self.txid, self.version, self.locktime, self.size, self.weight, self.fee, self.status)

    def __eq__(self, other):
        if self.txid != other.txid:
            return False
        if self.version != other.version:
            return False
        if self.locktime != other.locktime:
            return False
        if self.size != other.size:
            return False
        if self.weight != other.weight:
            return False
        if self.fee != other.fee:
            return False
        if self.status != other.status:
            return False
        return True

class _UniffiConverterTypeTx(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Tx(
            txid=_UniffiConverterTypeTxid.read(buf),
            version=_UniffiConverterInt32.read(buf),
            locktime=_UniffiConverterUInt32.read(buf),
            size=_UniffiConverterUInt64.read(buf),
            weight=_UniffiConverterUInt64.read(buf),
            fee=_UniffiConverterUInt64.read(buf),
            status=_UniffiConverterTypeTxStatus.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeTxid.check_lower(value.txid)
        _UniffiConverterInt32.check_lower(value.version)
        _UniffiConverterUInt32.check_lower(value.locktime)
        _UniffiConverterUInt64.check_lower(value.size)
        _UniffiConverterUInt64.check_lower(value.weight)
        _UniffiConverterUInt64.check_lower(value.fee)
        _UniffiConverterTypeTxStatus.check_lower(value.status)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeTxid.write(value.txid, buf)
        _UniffiConverterInt32.write(value.version, buf)
        _UniffiConverterUInt32.write(value.locktime, buf)
        _UniffiConverterUInt64.write(value.size, buf)
        _UniffiConverterUInt64.write(value.weight, buf)
        _UniffiConverterUInt64.write(value.fee, buf)
        _UniffiConverterTypeTxStatus.write(value.status, buf)


class TxDetails:
    txid: "Txid"
    sent: "Amount"
    received: "Amount"
    fee: "typing.Optional[Amount]"
    fee_rate: "typing.Optional[float]"
    balance_delta: "int"
    chain_position: "ChainPosition"
    tx: "Transaction"
    def __init__(self, *, txid: "Txid", sent: "Amount", received: "Amount", fee: "typing.Optional[Amount]", fee_rate: "typing.Optional[float]", balance_delta: "int", chain_position: "ChainPosition", tx: "Transaction"):
        self.txid = txid
        self.sent = sent
        self.received = received
        self.fee = fee
        self.fee_rate = fee_rate
        self.balance_delta = balance_delta
        self.chain_position = chain_position
        self.tx = tx

    def __str__(self):
        return "TxDetails(txid={}, sent={}, received={}, fee={}, fee_rate={}, balance_delta={}, chain_position={}, tx={})".format(self.txid, self.sent, self.received, self.fee, self.fee_rate, self.balance_delta, self.chain_position, self.tx)

    def __eq__(self, other):
        if self.txid != other.txid:
            return False
        if self.sent != other.sent:
            return False
        if self.received != other.received:
            return False
        if self.fee != other.fee:
            return False
        if self.fee_rate != other.fee_rate:
            return False
        if self.balance_delta != other.balance_delta:
            return False
        if self.chain_position != other.chain_position:
            return False
        if self.tx != other.tx:
            return False
        return True

class _UniffiConverterTypeTxDetails(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return TxDetails(
            txid=_UniffiConverterTypeTxid.read(buf),
            sent=_UniffiConverterTypeAmount.read(buf),
            received=_UniffiConverterTypeAmount.read(buf),
            fee=_UniffiConverterOptionalTypeAmount.read(buf),
            fee_rate=_UniffiConverterOptionalFloat.read(buf),
            balance_delta=_UniffiConverterInt64.read(buf),
            chain_position=_UniffiConverterTypeChainPosition.read(buf),
            tx=_UniffiConverterTypeTransaction.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeTxid.check_lower(value.txid)
        _UniffiConverterTypeAmount.check_lower(value.sent)
        _UniffiConverterTypeAmount.check_lower(value.received)
        _UniffiConverterOptionalTypeAmount.check_lower(value.fee)
        _UniffiConverterOptionalFloat.check_lower(value.fee_rate)
        _UniffiConverterInt64.check_lower(value.balance_delta)
        _UniffiConverterTypeChainPosition.check_lower(value.chain_position)
        _UniffiConverterTypeTransaction.check_lower(value.tx)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeTxid.write(value.txid, buf)
        _UniffiConverterTypeAmount.write(value.sent, buf)
        _UniffiConverterTypeAmount.write(value.received, buf)
        _UniffiConverterOptionalTypeAmount.write(value.fee, buf)
        _UniffiConverterOptionalFloat.write(value.fee_rate, buf)
        _UniffiConverterInt64.write(value.balance_delta, buf)
        _UniffiConverterTypeChainPosition.write(value.chain_position, buf)
        _UniffiConverterTypeTransaction.write(value.tx, buf)


class TxGraphChangeSet:
    txs: "typing.List[Transaction]"
    txouts: "dict[HashableOutPoint, TxOut]"
    anchors: "typing.List[Anchor]"
    last_seen: "dict[Txid, int]"
    first_seen: "dict[Txid, int]"
    last_evicted: "dict[Txid, int]"
    def __init__(self, *, txs: "typing.List[Transaction]", txouts: "dict[HashableOutPoint, TxOut]", anchors: "typing.List[Anchor]", last_seen: "dict[Txid, int]", first_seen: "dict[Txid, int]", last_evicted: "dict[Txid, int]"):
        self.txs = txs
        self.txouts = txouts
        self.anchors = anchors
        self.last_seen = last_seen
        self.first_seen = first_seen
        self.last_evicted = last_evicted

    def __str__(self):
        return "TxGraphChangeSet(txs={}, txouts={}, anchors={}, last_seen={}, first_seen={}, last_evicted={})".format(self.txs, self.txouts, self.anchors, self.last_seen, self.first_seen, self.last_evicted)

    def __eq__(self, other):
        if self.txs != other.txs:
            return False
        if self.txouts != other.txouts:
            return False
        if self.anchors != other.anchors:
            return False
        if self.last_seen != other.last_seen:
            return False
        if self.first_seen != other.first_seen:
            return False
        if self.last_evicted != other.last_evicted:
            return False
        return True

class _UniffiConverterTypeTxGraphChangeSet(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return TxGraphChangeSet(
            txs=_UniffiConverterSequenceTypeTransaction.read(buf),
            txouts=_UniffiConverterMapTypeHashableOutPointTypeTxOut.read(buf),
            anchors=_UniffiConverterSequenceTypeAnchor.read(buf),
            last_seen=_UniffiConverterMapTypeTxidUInt64.read(buf),
            first_seen=_UniffiConverterMapTypeTxidUInt64.read(buf),
            last_evicted=_UniffiConverterMapTypeTxidUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterSequenceTypeTransaction.check_lower(value.txs)
        _UniffiConverterMapTypeHashableOutPointTypeTxOut.check_lower(value.txouts)
        _UniffiConverterSequenceTypeAnchor.check_lower(value.anchors)
        _UniffiConverterMapTypeTxidUInt64.check_lower(value.last_seen)
        _UniffiConverterMapTypeTxidUInt64.check_lower(value.first_seen)
        _UniffiConverterMapTypeTxidUInt64.check_lower(value.last_evicted)

    @staticmethod
    def write(value, buf):
        _UniffiConverterSequenceTypeTransaction.write(value.txs, buf)
        _UniffiConverterMapTypeHashableOutPointTypeTxOut.write(value.txouts, buf)
        _UniffiConverterSequenceTypeAnchor.write(value.anchors, buf)
        _UniffiConverterMapTypeTxidUInt64.write(value.last_seen, buf)
        _UniffiConverterMapTypeTxidUInt64.write(value.first_seen, buf)
        _UniffiConverterMapTypeTxidUInt64.write(value.last_evicted, buf)


class TxIn:
    """
    A transcation input.
    """

    previous_output: "OutPoint"
    """
    A pointer to the previous output this input spends from.
    """

    script_sig: "Script"
    """
    The script corresponding to the `scriptPubKey`, empty in SegWit transactions.
    """

    sequence: "int"
    """
    https://bitcoin.stackexchange.com/questions/87372/what-does-the-sequence-in-a-transaction-input-mean
    """

    witness: "typing.List[bytes]"
    """
    A proof for the script that authorizes the spend of the output.
    """

    def __init__(self, *, previous_output: "OutPoint", script_sig: "Script", sequence: "int", witness: "typing.List[bytes]"):
        self.previous_output = previous_output
        self.script_sig = script_sig
        self.sequence = sequence
        self.witness = witness

    def __str__(self):
        return "TxIn(previous_output={}, script_sig={}, sequence={}, witness={})".format(self.previous_output, self.script_sig, self.sequence, self.witness)

    def __eq__(self, other):
        if self.previous_output != other.previous_output:
            return False
        if self.script_sig != other.script_sig:
            return False
        if self.sequence != other.sequence:
            return False
        if self.witness != other.witness:
            return False
        return True

class _UniffiConverterTypeTxIn(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return TxIn(
            previous_output=_UniffiConverterTypeOutPoint.read(buf),
            script_sig=_UniffiConverterTypeScript.read(buf),
            sequence=_UniffiConverterUInt32.read(buf),
            witness=_UniffiConverterSequenceBytes.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeOutPoint.check_lower(value.previous_output)
        _UniffiConverterTypeScript.check_lower(value.script_sig)
        _UniffiConverterUInt32.check_lower(value.sequence)
        _UniffiConverterSequenceBytes.check_lower(value.witness)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeOutPoint.write(value.previous_output, buf)
        _UniffiConverterTypeScript.write(value.script_sig, buf)
        _UniffiConverterUInt32.write(value.sequence, buf)
        _UniffiConverterSequenceBytes.write(value.witness, buf)


class TxOut:
    """
    Bitcoin transaction output.

    Defines new coins to be created as a result of the transaction,
    along with spending conditions ("script", aka "output script"),
    which an input spending it must satisfy.

    An output that is not yet spent by an input is called Unspent Transaction Output ("UTXO").
    """

    value: "Amount"
    """
    The value of the output, in satoshis.
    """

    script_pubkey: "Script"
    """
    The script which must be satisfied for the output to be spent.
    """

    def __init__(self, *, value: "Amount", script_pubkey: "Script"):
        self.value = value
        self.script_pubkey = script_pubkey

    def __str__(self):
        return "TxOut(value={}, script_pubkey={})".format(self.value, self.script_pubkey)

    def __eq__(self, other):
        if self.value != other.value:
            return False
        if self.script_pubkey != other.script_pubkey:
            return False
        return True

class _UniffiConverterTypeTxOut(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return TxOut(
            value=_UniffiConverterTypeAmount.read(buf),
            script_pubkey=_UniffiConverterTypeScript.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeAmount.check_lower(value.value)
        _UniffiConverterTypeScript.check_lower(value.script_pubkey)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeAmount.write(value.value, buf)
        _UniffiConverterTypeScript.write(value.script_pubkey, buf)


class TxStatus:
    """
    Transaction confirmation metadata.
    """

    confirmed: "bool"
    """
    Is the transaction in a block.
    """

    block_height: "typing.Optional[int]"
    """
    Height of the block this transaction was included.
    """

    block_hash: "typing.Optional[BlockHash]"
    """
    Hash of the block.
    """

    block_time: "typing.Optional[int]"
    """
    The time shown in the block, not necessarily the same time as when the block was found.
    """

    def __init__(self, *, confirmed: "bool", block_height: "typing.Optional[int]", block_hash: "typing.Optional[BlockHash]", block_time: "typing.Optional[int]"):
        self.confirmed = confirmed
        self.block_height = block_height
        self.block_hash = block_hash
        self.block_time = block_time

    def __str__(self):
        return "TxStatus(confirmed={}, block_height={}, block_hash={}, block_time={})".format(self.confirmed, self.block_height, self.block_hash, self.block_time)

    def __eq__(self, other):
        if self.confirmed != other.confirmed:
            return False
        if self.block_height != other.block_height:
            return False
        if self.block_hash != other.block_hash:
            return False
        if self.block_time != other.block_time:
            return False
        return True

class _UniffiConverterTypeTxStatus(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return TxStatus(
            confirmed=_UniffiConverterBool.read(buf),
            block_height=_UniffiConverterOptionalUInt32.read(buf),
            block_hash=_UniffiConverterOptionalTypeBlockHash.read(buf),
            block_time=_UniffiConverterOptionalUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterBool.check_lower(value.confirmed)
        _UniffiConverterOptionalUInt32.check_lower(value.block_height)
        _UniffiConverterOptionalTypeBlockHash.check_lower(value.block_hash)
        _UniffiConverterOptionalUInt64.check_lower(value.block_time)

    @staticmethod
    def write(value, buf):
        _UniffiConverterBool.write(value.confirmed, buf)
        _UniffiConverterOptionalUInt32.write(value.block_height, buf)
        _UniffiConverterOptionalTypeBlockHash.write(value.block_hash, buf)
        _UniffiConverterOptionalUInt64.write(value.block_time, buf)


class UnconfirmedTx:
    """
    This type replaces the Rust tuple `(tx, last_seen)` used in the Wallet::apply_unconfirmed_txs` method,
    where `last_seen` is the timestamp of when the transaction `tx` was last seen in the mempool.
    """

    tx: "Transaction"
    last_seen: "int"
    def __init__(self, *, tx: "Transaction", last_seen: "int"):
        self.tx = tx
        self.last_seen = last_seen

    def __str__(self):
        return "UnconfirmedTx(tx={}, last_seen={})".format(self.tx, self.last_seen)

    def __eq__(self, other):
        if self.tx != other.tx:
            return False
        if self.last_seen != other.last_seen:
            return False
        return True

class _UniffiConverterTypeUnconfirmedTx(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return UnconfirmedTx(
            tx=_UniffiConverterTypeTransaction.read(buf),
            last_seen=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeTransaction.check_lower(value.tx)
        _UniffiConverterUInt64.check_lower(value.last_seen)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeTransaction.write(value.tx, buf)
        _UniffiConverterUInt64.write(value.last_seen, buf)


class WitnessProgram:
    """
    The version and program of a Segwit address.
    """

    version: "int"
    """
    Version. For example 1 for Taproot.
    """

    program: "bytes"
    """
    The witness program.
    """

    def __init__(self, *, version: "int", program: "bytes"):
        self.version = version
        self.program = program

    def __str__(self):
        return "WitnessProgram(version={}, program={})".format(self.version, self.program)

    def __eq__(self, other):
        if self.version != other.version:
            return False
        if self.program != other.program:
            return False
        return True

class _UniffiConverterTypeWitnessProgram(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return WitnessProgram(
            version=_UniffiConverterUInt8.read(buf),
            program=_UniffiConverterBytes.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt8.check_lower(value.version)
        _UniffiConverterBytes.check_lower(value.program)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt8.write(value.version, buf)
        _UniffiConverterBytes.write(value.program, buf)





class AddressData:
    """
    The type of address.
    """

    def __init__(self):
        raise RuntimeError("AddressData cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class P2PKH:
        """
        Legacy.
        """

        pubkey_hash: "str"

        def __init__(self,pubkey_hash: "str"):
            self.pubkey_hash = pubkey_hash

        def __str__(self):
            return "AddressData.P2PKH(pubkey_hash={})".format(self.pubkey_hash)

        def __eq__(self, other):
            if not other.is_P2PKH():
                return False
            if self.pubkey_hash != other.pubkey_hash:
                return False
            return True
    
    class P2SH:
        """
        Wrapped Segwit
        """

        script_hash: "str"

        def __init__(self,script_hash: "str"):
            self.script_hash = script_hash

        def __str__(self):
            return "AddressData.P2SH(script_hash={})".format(self.script_hash)

        def __eq__(self, other):
            if not other.is_P2SH():
                return False
            if self.script_hash != other.script_hash:
                return False
            return True
    
    class SEGWIT:
        """
        Segwit
        """

        witness_program: "WitnessProgram"

        def __init__(self,witness_program: "WitnessProgram"):
            self.witness_program = witness_program

        def __str__(self):
            return "AddressData.SEGWIT(witness_program={})".format(self.witness_program)

        def __eq__(self, other):
            if not other.is_SEGWIT():
                return False
            if self.witness_program != other.witness_program:
                return False
            return True
    
    

    # For each variant, we have `is_NAME` and `is_name` methods for easily checking
    # whether an instance is that variant.
    def is_P2PKH(self) -> bool:
        return isinstance(self, AddressData.P2PKH)
    def is_p2pkh(self) -> bool:
        return isinstance(self, AddressData.P2PKH)
    def is_P2SH(self) -> bool:
        return isinstance(self, AddressData.P2SH)
    def is_p2sh(self) -> bool:
        return isinstance(self, AddressData.P2SH)
    def is_SEGWIT(self) -> bool:
        return isinstance(self, AddressData.SEGWIT)
    def is_segwit(self) -> bool:
        return isinstance(self, AddressData.SEGWIT)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
AddressData.P2PKH = type("AddressData.P2PKH", (AddressData.P2PKH, AddressData,), {})  # type: ignore
AddressData.P2SH = type("AddressData.P2SH", (AddressData.P2SH, AddressData,), {})  # type: ignore
AddressData.SEGWIT = type("AddressData.SEGWIT", (AddressData.SEGWIT, AddressData,), {})  # type: ignore




class _UniffiConverterTypeAddressData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return AddressData.P2PKH(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return AddressData.P2SH(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return AddressData.SEGWIT(
                _UniffiConverterTypeWitnessProgram.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_P2PKH():
            _UniffiConverterString.check_lower(value.pubkey_hash)
            return
        if value.is_P2SH():
            _UniffiConverterString.check_lower(value.script_hash)
            return
        if value.is_SEGWIT():
            _UniffiConverterTypeWitnessProgram.check_lower(value.witness_program)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_P2PKH():
            buf.write_i32(1)
            _UniffiConverterString.write(value.pubkey_hash, buf)
        if value.is_P2SH():
            buf.write_i32(2)
            _UniffiConverterString.write(value.script_hash, buf)
        if value.is_SEGWIT():
            buf.write_i32(3)
            _UniffiConverterTypeWitnessProgram.write(value.witness_program, buf)




# AddressParseError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class AddressParseError(Exception):
    pass

_UniffiTempAddressParseError = AddressParseError

class AddressParseError:  # type: ignore
    class Base58(_UniffiTempAddressParseError):
        def __init__(self):
            pass

        def __repr__(self):
            return "AddressParseError.Base58({})".format(str(self))
    _UniffiTempAddressParseError.Base58 = Base58 # type: ignore
    class Bech32(_UniffiTempAddressParseError):
        def __init__(self):
            pass

        def __repr__(self):
            return "AddressParseError.Bech32({})".format(str(self))
    _UniffiTempAddressParseError.Bech32 = Bech32 # type: ignore
    class WitnessVersion(_UniffiTempAddressParseError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "AddressParseError.WitnessVersion({})".format(str(self))
    _UniffiTempAddressParseError.WitnessVersion = WitnessVersion # type: ignore
    class WitnessProgram(_UniffiTempAddressParseError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "AddressParseError.WitnessProgram({})".format(str(self))
    _UniffiTempAddressParseError.WitnessProgram = WitnessProgram # type: ignore
    class UnknownHrp(_UniffiTempAddressParseError):
        def __init__(self):
            pass

        def __repr__(self):
            return "AddressParseError.UnknownHrp({})".format(str(self))
    _UniffiTempAddressParseError.UnknownHrp = UnknownHrp # type: ignore
    class LegacyAddressTooLong(_UniffiTempAddressParseError):
        def __init__(self):
            pass

        def __repr__(self):
            return "AddressParseError.LegacyAddressTooLong({})".format(str(self))
    _UniffiTempAddressParseError.LegacyAddressTooLong = LegacyAddressTooLong # type: ignore
    class InvalidBase58PayloadLength(_UniffiTempAddressParseError):
        def __init__(self):
            pass

        def __repr__(self):
            return "AddressParseError.InvalidBase58PayloadLength({})".format(str(self))
    _UniffiTempAddressParseError.InvalidBase58PayloadLength = InvalidBase58PayloadLength # type: ignore
    class InvalidLegacyPrefix(_UniffiTempAddressParseError):
        def __init__(self):
            pass

        def __repr__(self):
            return "AddressParseError.InvalidLegacyPrefix({})".format(str(self))
    _UniffiTempAddressParseError.InvalidLegacyPrefix = InvalidLegacyPrefix # type: ignore
    class NetworkValidation(_UniffiTempAddressParseError):
        def __init__(self):
            pass

        def __repr__(self):
            return "AddressParseError.NetworkValidation({})".format(str(self))
    _UniffiTempAddressParseError.NetworkValidation = NetworkValidation # type: ignore
    class OtherAddressParseErr(_UniffiTempAddressParseError):
        def __init__(self):
            pass

        def __repr__(self):
            return "AddressParseError.OtherAddressParseErr({})".format(str(self))
    _UniffiTempAddressParseError.OtherAddressParseErr = OtherAddressParseErr # type: ignore

AddressParseError = _UniffiTempAddressParseError # type: ignore
del _UniffiTempAddressParseError


class _UniffiConverterTypeAddressParseError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return AddressParseError.Base58(
            )
        if variant == 2:
            return AddressParseError.Bech32(
            )
        if variant == 3:
            return AddressParseError.WitnessVersion(
                _UniffiConverterString.read(buf),
            )
        if variant == 4:
            return AddressParseError.WitnessProgram(
                _UniffiConverterString.read(buf),
            )
        if variant == 5:
            return AddressParseError.UnknownHrp(
            )
        if variant == 6:
            return AddressParseError.LegacyAddressTooLong(
            )
        if variant == 7:
            return AddressParseError.InvalidBase58PayloadLength(
            )
        if variant == 8:
            return AddressParseError.InvalidLegacyPrefix(
            )
        if variant == 9:
            return AddressParseError.NetworkValidation(
            )
        if variant == 10:
            return AddressParseError.OtherAddressParseErr(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, AddressParseError.Base58):
            return
        if isinstance(value, AddressParseError.Bech32):
            return
        if isinstance(value, AddressParseError.WitnessVersion):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, AddressParseError.WitnessProgram):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, AddressParseError.UnknownHrp):
            return
        if isinstance(value, AddressParseError.LegacyAddressTooLong):
            return
        if isinstance(value, AddressParseError.InvalidBase58PayloadLength):
            return
        if isinstance(value, AddressParseError.InvalidLegacyPrefix):
            return
        if isinstance(value, AddressParseError.NetworkValidation):
            return
        if isinstance(value, AddressParseError.OtherAddressParseErr):
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, AddressParseError.Base58):
            buf.write_i32(1)
        if isinstance(value, AddressParseError.Bech32):
            buf.write_i32(2)
        if isinstance(value, AddressParseError.WitnessVersion):
            buf.write_i32(3)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, AddressParseError.WitnessProgram):
            buf.write_i32(4)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, AddressParseError.UnknownHrp):
            buf.write_i32(5)
        if isinstance(value, AddressParseError.LegacyAddressTooLong):
            buf.write_i32(6)
        if isinstance(value, AddressParseError.InvalidBase58PayloadLength):
            buf.write_i32(7)
        if isinstance(value, AddressParseError.InvalidLegacyPrefix):
            buf.write_i32(8)
        if isinstance(value, AddressParseError.NetworkValidation):
            buf.write_i32(9)
        if isinstance(value, AddressParseError.OtherAddressParseErr):
            buf.write_i32(10)


# Bip32Error
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class Bip32Error(Exception):
    pass

_UniffiTempBip32Error = Bip32Error

class Bip32Error:  # type: ignore
    class CannotDeriveFromHardenedKey(_UniffiTempBip32Error):
        def __init__(self):
            pass

        def __repr__(self):
            return "Bip32Error.CannotDeriveFromHardenedKey({})".format(str(self))
    _UniffiTempBip32Error.CannotDeriveFromHardenedKey = CannotDeriveFromHardenedKey # type: ignore
    class Secp256k1(_UniffiTempBip32Error):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "Bip32Error.Secp256k1({})".format(str(self))
    _UniffiTempBip32Error.Secp256k1 = Secp256k1 # type: ignore
    class InvalidChildNumber(_UniffiTempBip32Error):
        def __init__(self, child_number):
            super().__init__(", ".join([
                "child_number={!r}".format(child_number),
            ]))
            self.child_number = child_number

        def __repr__(self):
            return "Bip32Error.InvalidChildNumber({})".format(str(self))
    _UniffiTempBip32Error.InvalidChildNumber = InvalidChildNumber # type: ignore
    class InvalidChildNumberFormat(_UniffiTempBip32Error):
        def __init__(self):
            pass

        def __repr__(self):
            return "Bip32Error.InvalidChildNumberFormat({})".format(str(self))
    _UniffiTempBip32Error.InvalidChildNumberFormat = InvalidChildNumberFormat # type: ignore
    class InvalidDerivationPathFormat(_UniffiTempBip32Error):
        def __init__(self):
            pass

        def __repr__(self):
            return "Bip32Error.InvalidDerivationPathFormat({})".format(str(self))
    _UniffiTempBip32Error.InvalidDerivationPathFormat = InvalidDerivationPathFormat # type: ignore
    class UnknownVersion(_UniffiTempBip32Error):
        def __init__(self, version):
            super().__init__(", ".join([
                "version={!r}".format(version),
            ]))
            self.version = version

        def __repr__(self):
            return "Bip32Error.UnknownVersion({})".format(str(self))
    _UniffiTempBip32Error.UnknownVersion = UnknownVersion # type: ignore
    class WrongExtendedKeyLength(_UniffiTempBip32Error):
        def __init__(self, length):
            super().__init__(", ".join([
                "length={!r}".format(length),
            ]))
            self.length = length

        def __repr__(self):
            return "Bip32Error.WrongExtendedKeyLength({})".format(str(self))
    _UniffiTempBip32Error.WrongExtendedKeyLength = WrongExtendedKeyLength # type: ignore
    class Base58(_UniffiTempBip32Error):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "Bip32Error.Base58({})".format(str(self))
    _UniffiTempBip32Error.Base58 = Base58 # type: ignore
    class Hex(_UniffiTempBip32Error):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "Bip32Error.Hex({})".format(str(self))
    _UniffiTempBip32Error.Hex = Hex # type: ignore
    class InvalidPublicKeyHexLength(_UniffiTempBip32Error):
        def __init__(self, length):
            super().__init__(", ".join([
                "length={!r}".format(length),
            ]))
            self.length = length

        def __repr__(self):
            return "Bip32Error.InvalidPublicKeyHexLength({})".format(str(self))
    _UniffiTempBip32Error.InvalidPublicKeyHexLength = InvalidPublicKeyHexLength # type: ignore
    class UnknownError(_UniffiTempBip32Error):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "Bip32Error.UnknownError({})".format(str(self))
    _UniffiTempBip32Error.UnknownError = UnknownError # type: ignore

Bip32Error = _UniffiTempBip32Error # type: ignore
del _UniffiTempBip32Error


class _UniffiConverterTypeBip32Error(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return Bip32Error.CannotDeriveFromHardenedKey(
            )
        if variant == 2:
            return Bip32Error.Secp256k1(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return Bip32Error.InvalidChildNumber(
                _UniffiConverterUInt32.read(buf),
            )
        if variant == 4:
            return Bip32Error.InvalidChildNumberFormat(
            )
        if variant == 5:
            return Bip32Error.InvalidDerivationPathFormat(
            )
        if variant == 6:
            return Bip32Error.UnknownVersion(
                _UniffiConverterString.read(buf),
            )
        if variant == 7:
            return Bip32Error.WrongExtendedKeyLength(
                _UniffiConverterUInt32.read(buf),
            )
        if variant == 8:
            return Bip32Error.Base58(
                _UniffiConverterString.read(buf),
            )
        if variant == 9:
            return Bip32Error.Hex(
                _UniffiConverterString.read(buf),
            )
        if variant == 10:
            return Bip32Error.InvalidPublicKeyHexLength(
                _UniffiConverterUInt32.read(buf),
            )
        if variant == 11:
            return Bip32Error.UnknownError(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, Bip32Error.CannotDeriveFromHardenedKey):
            return
        if isinstance(value, Bip32Error.Secp256k1):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, Bip32Error.InvalidChildNumber):
            _UniffiConverterUInt32.check_lower(value.child_number)
            return
        if isinstance(value, Bip32Error.InvalidChildNumberFormat):
            return
        if isinstance(value, Bip32Error.InvalidDerivationPathFormat):
            return
        if isinstance(value, Bip32Error.UnknownVersion):
            _UniffiConverterString.check_lower(value.version)
            return
        if isinstance(value, Bip32Error.WrongExtendedKeyLength):
            _UniffiConverterUInt32.check_lower(value.length)
            return
        if isinstance(value, Bip32Error.Base58):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, Bip32Error.Hex):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, Bip32Error.InvalidPublicKeyHexLength):
            _UniffiConverterUInt32.check_lower(value.length)
            return
        if isinstance(value, Bip32Error.UnknownError):
            _UniffiConverterString.check_lower(value.error_message)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, Bip32Error.CannotDeriveFromHardenedKey):
            buf.write_i32(1)
        if isinstance(value, Bip32Error.Secp256k1):
            buf.write_i32(2)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, Bip32Error.InvalidChildNumber):
            buf.write_i32(3)
            _UniffiConverterUInt32.write(value.child_number, buf)
        if isinstance(value, Bip32Error.InvalidChildNumberFormat):
            buf.write_i32(4)
        if isinstance(value, Bip32Error.InvalidDerivationPathFormat):
            buf.write_i32(5)
        if isinstance(value, Bip32Error.UnknownVersion):
            buf.write_i32(6)
            _UniffiConverterString.write(value.version, buf)
        if isinstance(value, Bip32Error.WrongExtendedKeyLength):
            buf.write_i32(7)
            _UniffiConverterUInt32.write(value.length, buf)
        if isinstance(value, Bip32Error.Base58):
            buf.write_i32(8)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, Bip32Error.Hex):
            buf.write_i32(9)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, Bip32Error.InvalidPublicKeyHexLength):
            buf.write_i32(10)
            _UniffiConverterUInt32.write(value.length, buf)
        if isinstance(value, Bip32Error.UnknownError):
            buf.write_i32(11)
            _UniffiConverterString.write(value.error_message, buf)


# Bip39Error
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class Bip39Error(Exception):
    pass

_UniffiTempBip39Error = Bip39Error

class Bip39Error:  # type: ignore
    class BadWordCount(_UniffiTempBip39Error):
        def __init__(self, word_count):
            super().__init__(", ".join([
                "word_count={!r}".format(word_count),
            ]))
            self.word_count = word_count

        def __repr__(self):
            return "Bip39Error.BadWordCount({})".format(str(self))
    _UniffiTempBip39Error.BadWordCount = BadWordCount # type: ignore
    class UnknownWord(_UniffiTempBip39Error):
        def __init__(self, index):
            super().__init__(", ".join([
                "index={!r}".format(index),
            ]))
            self.index = index

        def __repr__(self):
            return "Bip39Error.UnknownWord({})".format(str(self))
    _UniffiTempBip39Error.UnknownWord = UnknownWord # type: ignore
    class BadEntropyBitCount(_UniffiTempBip39Error):
        def __init__(self, bit_count):
            super().__init__(", ".join([
                "bit_count={!r}".format(bit_count),
            ]))
            self.bit_count = bit_count

        def __repr__(self):
            return "Bip39Error.BadEntropyBitCount({})".format(str(self))
    _UniffiTempBip39Error.BadEntropyBitCount = BadEntropyBitCount # type: ignore
    class InvalidChecksum(_UniffiTempBip39Error):
        def __init__(self):
            pass

        def __repr__(self):
            return "Bip39Error.InvalidChecksum({})".format(str(self))
    _UniffiTempBip39Error.InvalidChecksum = InvalidChecksum # type: ignore
    class AmbiguousLanguages(_UniffiTempBip39Error):
        def __init__(self, languages):
            super().__init__(", ".join([
                "languages={!r}".format(languages),
            ]))
            self.languages = languages

        def __repr__(self):
            return "Bip39Error.AmbiguousLanguages({})".format(str(self))
    _UniffiTempBip39Error.AmbiguousLanguages = AmbiguousLanguages # type: ignore

Bip39Error = _UniffiTempBip39Error # type: ignore
del _UniffiTempBip39Error


class _UniffiConverterTypeBip39Error(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return Bip39Error.BadWordCount(
                _UniffiConverterUInt64.read(buf),
            )
        if variant == 2:
            return Bip39Error.UnknownWord(
                _UniffiConverterUInt64.read(buf),
            )
        if variant == 3:
            return Bip39Error.BadEntropyBitCount(
                _UniffiConverterUInt64.read(buf),
            )
        if variant == 4:
            return Bip39Error.InvalidChecksum(
            )
        if variant == 5:
            return Bip39Error.AmbiguousLanguages(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, Bip39Error.BadWordCount):
            _UniffiConverterUInt64.check_lower(value.word_count)
            return
        if isinstance(value, Bip39Error.UnknownWord):
            _UniffiConverterUInt64.check_lower(value.index)
            return
        if isinstance(value, Bip39Error.BadEntropyBitCount):
            _UniffiConverterUInt64.check_lower(value.bit_count)
            return
        if isinstance(value, Bip39Error.InvalidChecksum):
            return
        if isinstance(value, Bip39Error.AmbiguousLanguages):
            _UniffiConverterString.check_lower(value.languages)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, Bip39Error.BadWordCount):
            buf.write_i32(1)
            _UniffiConverterUInt64.write(value.word_count, buf)
        if isinstance(value, Bip39Error.UnknownWord):
            buf.write_i32(2)
            _UniffiConverterUInt64.write(value.index, buf)
        if isinstance(value, Bip39Error.BadEntropyBitCount):
            buf.write_i32(3)
            _UniffiConverterUInt64.write(value.bit_count, buf)
        if isinstance(value, Bip39Error.InvalidChecksum):
            buf.write_i32(4)
        if isinstance(value, Bip39Error.AmbiguousLanguages):
            buf.write_i32(5)
            _UniffiConverterString.write(value.languages, buf)


# CalculateFeeError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class CalculateFeeError(Exception):
    pass

_UniffiTempCalculateFeeError = CalculateFeeError

class CalculateFeeError:  # type: ignore
    class MissingTxOut(_UniffiTempCalculateFeeError):
        def __init__(self, out_points):
            super().__init__(", ".join([
                "out_points={!r}".format(out_points),
            ]))
            self.out_points = out_points

        def __repr__(self):
            return "CalculateFeeError.MissingTxOut({})".format(str(self))
    _UniffiTempCalculateFeeError.MissingTxOut = MissingTxOut # type: ignore
    class NegativeFee(_UniffiTempCalculateFeeError):
        def __init__(self, amount):
            super().__init__(", ".join([
                "amount={!r}".format(amount),
            ]))
            self.amount = amount

        def __repr__(self):
            return "CalculateFeeError.NegativeFee({})".format(str(self))
    _UniffiTempCalculateFeeError.NegativeFee = NegativeFee # type: ignore

CalculateFeeError = _UniffiTempCalculateFeeError # type: ignore
del _UniffiTempCalculateFeeError


class _UniffiConverterTypeCalculateFeeError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return CalculateFeeError.MissingTxOut(
                _UniffiConverterSequenceTypeOutPoint.read(buf),
            )
        if variant == 2:
            return CalculateFeeError.NegativeFee(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, CalculateFeeError.MissingTxOut):
            _UniffiConverterSequenceTypeOutPoint.check_lower(value.out_points)
            return
        if isinstance(value, CalculateFeeError.NegativeFee):
            _UniffiConverterString.check_lower(value.amount)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, CalculateFeeError.MissingTxOut):
            buf.write_i32(1)
            _UniffiConverterSequenceTypeOutPoint.write(value.out_points, buf)
        if isinstance(value, CalculateFeeError.NegativeFee):
            buf.write_i32(2)
            _UniffiConverterString.write(value.amount, buf)


# CannotConnectError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class CannotConnectError(Exception):
    pass

_UniffiTempCannotConnectError = CannotConnectError

class CannotConnectError:  # type: ignore
    class Include(_UniffiTempCannotConnectError):
        def __init__(self, height):
            super().__init__(", ".join([
                "height={!r}".format(height),
            ]))
            self.height = height

        def __repr__(self):
            return "CannotConnectError.Include({})".format(str(self))
    _UniffiTempCannotConnectError.Include = Include # type: ignore

CannotConnectError = _UniffiTempCannotConnectError # type: ignore
del _UniffiTempCannotConnectError


class _UniffiConverterTypeCannotConnectError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return CannotConnectError.Include(
                _UniffiConverterUInt32.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, CannotConnectError.Include):
            _UniffiConverterUInt32.check_lower(value.height)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, CannotConnectError.Include):
            buf.write_i32(1)
            _UniffiConverterUInt32.write(value.height, buf)


# CbfBuilderError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class CbfBuilderError(Exception):
    pass

_UniffiTempCbfBuilderError = CbfBuilderError

class CbfBuilderError:  # type: ignore
    class DatabaseError(_UniffiTempCbfBuilderError):
        def __init__(self, reason):
            super().__init__(", ".join([
                "reason={!r}".format(reason),
            ]))
            self.reason = reason

        def __repr__(self):
            return "CbfBuilderError.DatabaseError({})".format(str(self))
    _UniffiTempCbfBuilderError.DatabaseError = DatabaseError # type: ignore

CbfBuilderError = _UniffiTempCbfBuilderError # type: ignore
del _UniffiTempCbfBuilderError


class _UniffiConverterTypeCbfBuilderError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return CbfBuilderError.DatabaseError(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, CbfBuilderError.DatabaseError):
            _UniffiConverterString.check_lower(value.reason)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, CbfBuilderError.DatabaseError):
            buf.write_i32(1)
            _UniffiConverterString.write(value.reason, buf)


# CbfError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class CbfError(Exception):
    pass

_UniffiTempCbfError = CbfError

class CbfError:  # type: ignore
    class NodeStopped(_UniffiTempCbfError):
        def __init__(self):
            pass

        def __repr__(self):
            return "CbfError.NodeStopped({})".format(str(self))
    _UniffiTempCbfError.NodeStopped = NodeStopped # type: ignore

CbfError = _UniffiTempCbfError # type: ignore
del _UniffiTempCbfError


class _UniffiConverterTypeCbfError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return CbfError.NodeStopped(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, CbfError.NodeStopped):
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, CbfError.NodeStopped):
            buf.write_i32(1)





class ChainPosition:
    """
    Represents the observed position of some chain data.
    """

    def __init__(self):
        raise RuntimeError("ChainPosition cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class CONFIRMED:
        """
        The chain data is confirmed as it is anchored in the best chain by `A`.
        """

        confirmation_block_time: "ConfirmationBlockTime"
        transitively: "typing.Optional[Txid]"
        """
        A child transaction that has been confirmed. Due to incomplete information,
        it is only known that this transaction is confirmed at a chain height less than
        or equal to this child TXID.
        """


        def __init__(self,confirmation_block_time: "ConfirmationBlockTime", transitively: "typing.Optional[Txid]"):
            self.confirmation_block_time = confirmation_block_time
            self.transitively = transitively

        def __str__(self):
            return "ChainPosition.CONFIRMED(confirmation_block_time={}, transitively={})".format(self.confirmation_block_time, self.transitively)

        def __eq__(self, other):
            if not other.is_CONFIRMED():
                return False
            if self.confirmation_block_time != other.confirmation_block_time:
                return False
            if self.transitively != other.transitively:
                return False
            return True
    
    class UNCONFIRMED:
        """
        The transaction was last seen in the mempool at this timestamp.
        """

        timestamp: "typing.Optional[int]"

        def __init__(self,timestamp: "typing.Optional[int]"):
            self.timestamp = timestamp

        def __str__(self):
            return "ChainPosition.UNCONFIRMED(timestamp={})".format(self.timestamp)

        def __eq__(self, other):
            if not other.is_UNCONFIRMED():
                return False
            if self.timestamp != other.timestamp:
                return False
            return True
    
    

    # For each variant, we have `is_NAME` and `is_name` methods for easily checking
    # whether an instance is that variant.
    def is_CONFIRMED(self) -> bool:
        return isinstance(self, ChainPosition.CONFIRMED)
    def is_confirmed(self) -> bool:
        return isinstance(self, ChainPosition.CONFIRMED)
    def is_UNCONFIRMED(self) -> bool:
        return isinstance(self, ChainPosition.UNCONFIRMED)
    def is_unconfirmed(self) -> bool:
        return isinstance(self, ChainPosition.UNCONFIRMED)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
ChainPosition.CONFIRMED = type("ChainPosition.CONFIRMED", (ChainPosition.CONFIRMED, ChainPosition,), {})  # type: ignore
ChainPosition.UNCONFIRMED = type("ChainPosition.UNCONFIRMED", (ChainPosition.UNCONFIRMED, ChainPosition,), {})  # type: ignore




class _UniffiConverterTypeChainPosition(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return ChainPosition.CONFIRMED(
                _UniffiConverterTypeConfirmationBlockTime.read(buf),
                _UniffiConverterOptionalTypeTxid.read(buf),
            )
        if variant == 2:
            return ChainPosition.UNCONFIRMED(
                _UniffiConverterOptionalUInt64.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_CONFIRMED():
            _UniffiConverterTypeConfirmationBlockTime.check_lower(value.confirmation_block_time)
            _UniffiConverterOptionalTypeTxid.check_lower(value.transitively)
            return
        if value.is_UNCONFIRMED():
            _UniffiConverterOptionalUInt64.check_lower(value.timestamp)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_CONFIRMED():
            buf.write_i32(1)
            _UniffiConverterTypeConfirmationBlockTime.write(value.confirmation_block_time, buf)
            _UniffiConverterOptionalTypeTxid.write(value.transitively, buf)
        if value.is_UNCONFIRMED():
            buf.write_i32(2)
            _UniffiConverterOptionalUInt64.write(value.timestamp, buf)







class ChangeSpendPolicy(enum.Enum):
    """
    Policy regarding the use of change outputs when creating a transaction.
    """

    CHANGE_ALLOWED = 0
    """
    Use both change and non-change outputs (default).
    """

    
    ONLY_CHANGE = 1
    """
    Only use change outputs (see [`bdk_wallet::TxBuilder::only_spend_change`]).
    """

    
    CHANGE_FORBIDDEN = 2
    """
    Only use non-change outputs (see [`bdk_wallet::TxBuilder::do_not_spend_change`]).
    """

    


class _UniffiConverterTypeChangeSpendPolicy(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return ChangeSpendPolicy.CHANGE_ALLOWED
        if variant == 2:
            return ChangeSpendPolicy.ONLY_CHANGE
        if variant == 3:
            return ChangeSpendPolicy.CHANGE_FORBIDDEN
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == ChangeSpendPolicy.CHANGE_ALLOWED:
            return
        if value == ChangeSpendPolicy.ONLY_CHANGE:
            return
        if value == ChangeSpendPolicy.CHANGE_FORBIDDEN:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == ChangeSpendPolicy.CHANGE_ALLOWED:
            buf.write_i32(1)
        if value == ChangeSpendPolicy.ONLY_CHANGE:
            buf.write_i32(2)
        if value == ChangeSpendPolicy.CHANGE_FORBIDDEN:
            buf.write_i32(3)




# CreateTxError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class CreateTxError(Exception):
    pass

_UniffiTempCreateTxError = CreateTxError

class CreateTxError:  # type: ignore
    class Descriptor(_UniffiTempCreateTxError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "CreateTxError.Descriptor({})".format(str(self))
    _UniffiTempCreateTxError.Descriptor = Descriptor # type: ignore
    class Policy(_UniffiTempCreateTxError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "CreateTxError.Policy({})".format(str(self))
    _UniffiTempCreateTxError.Policy = Policy # type: ignore
    class SpendingPolicyRequired(_UniffiTempCreateTxError):
        def __init__(self, kind):
            super().__init__(", ".join([
                "kind={!r}".format(kind),
            ]))
            self.kind = kind

        def __repr__(self):
            return "CreateTxError.SpendingPolicyRequired({})".format(str(self))
    _UniffiTempCreateTxError.SpendingPolicyRequired = SpendingPolicyRequired # type: ignore
    class Version0(_UniffiTempCreateTxError):
        def __init__(self):
            pass

        def __repr__(self):
            return "CreateTxError.Version0({})".format(str(self))
    _UniffiTempCreateTxError.Version0 = Version0 # type: ignore
    class Version1Csv(_UniffiTempCreateTxError):
        def __init__(self):
            pass

        def __repr__(self):
            return "CreateTxError.Version1Csv({})".format(str(self))
    _UniffiTempCreateTxError.Version1Csv = Version1Csv # type: ignore
    class LockTime(_UniffiTempCreateTxError):
        def __init__(self, requested, required):
            super().__init__(", ".join([
                "requested={!r}".format(requested),
                "required={!r}".format(required),
            ]))
            self.requested = requested
            self.required = required

        def __repr__(self):
            return "CreateTxError.LockTime({})".format(str(self))
    _UniffiTempCreateTxError.LockTime = LockTime # type: ignore
    class RbfSequenceCsv(_UniffiTempCreateTxError):
        def __init__(self, sequence, csv):
            super().__init__(", ".join([
                "sequence={!r}".format(sequence),
                "csv={!r}".format(csv),
            ]))
            self.sequence = sequence
            self.csv = csv

        def __repr__(self):
            return "CreateTxError.RbfSequenceCsv({})".format(str(self))
    _UniffiTempCreateTxError.RbfSequenceCsv = RbfSequenceCsv # type: ignore
    class FeeTooLow(_UniffiTempCreateTxError):
        def __init__(self, required):
            super().__init__(", ".join([
                "required={!r}".format(required),
            ]))
            self.required = required

        def __repr__(self):
            return "CreateTxError.FeeTooLow({})".format(str(self))
    _UniffiTempCreateTxError.FeeTooLow = FeeTooLow # type: ignore
    class FeeRateTooLow(_UniffiTempCreateTxError):
        def __init__(self, required):
            super().__init__(", ".join([
                "required={!r}".format(required),
            ]))
            self.required = required

        def __repr__(self):
            return "CreateTxError.FeeRateTooLow({})".format(str(self))
    _UniffiTempCreateTxError.FeeRateTooLow = FeeRateTooLow # type: ignore
    class NoUtxosSelected(_UniffiTempCreateTxError):
        def __init__(self):
            pass

        def __repr__(self):
            return "CreateTxError.NoUtxosSelected({})".format(str(self))
    _UniffiTempCreateTxError.NoUtxosSelected = NoUtxosSelected # type: ignore
    class OutputBelowDustLimit(_UniffiTempCreateTxError):
        def __init__(self, index):
            super().__init__(", ".join([
                "index={!r}".format(index),
            ]))
            self.index = index

        def __repr__(self):
            return "CreateTxError.OutputBelowDustLimit({})".format(str(self))
    _UniffiTempCreateTxError.OutputBelowDustLimit = OutputBelowDustLimit # type: ignore
    class ChangePolicyDescriptor(_UniffiTempCreateTxError):
        def __init__(self):
            pass

        def __repr__(self):
            return "CreateTxError.ChangePolicyDescriptor({})".format(str(self))
    _UniffiTempCreateTxError.ChangePolicyDescriptor = ChangePolicyDescriptor # type: ignore
    class CoinSelection(_UniffiTempCreateTxError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "CreateTxError.CoinSelection({})".format(str(self))
    _UniffiTempCreateTxError.CoinSelection = CoinSelection # type: ignore
    class InsufficientFunds(_UniffiTempCreateTxError):
        def __init__(self, needed, available):
            super().__init__(", ".join([
                "needed={!r}".format(needed),
                "available={!r}".format(available),
            ]))
            self.needed = needed
            self.available = available

        def __repr__(self):
            return "CreateTxError.InsufficientFunds({})".format(str(self))
    _UniffiTempCreateTxError.InsufficientFunds = InsufficientFunds # type: ignore
    class NoRecipients(_UniffiTempCreateTxError):
        def __init__(self):
            pass

        def __repr__(self):
            return "CreateTxError.NoRecipients({})".format(str(self))
    _UniffiTempCreateTxError.NoRecipients = NoRecipients # type: ignore
    class Psbt(_UniffiTempCreateTxError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "CreateTxError.Psbt({})".format(str(self))
    _UniffiTempCreateTxError.Psbt = Psbt # type: ignore
    class MissingKeyOrigin(_UniffiTempCreateTxError):
        def __init__(self, key):
            super().__init__(", ".join([
                "key={!r}".format(key),
            ]))
            self.key = key

        def __repr__(self):
            return "CreateTxError.MissingKeyOrigin({})".format(str(self))
    _UniffiTempCreateTxError.MissingKeyOrigin = MissingKeyOrigin # type: ignore
    class UnknownUtxo(_UniffiTempCreateTxError):
        def __init__(self, outpoint):
            super().__init__(", ".join([
                "outpoint={!r}".format(outpoint),
            ]))
            self.outpoint = outpoint

        def __repr__(self):
            return "CreateTxError.UnknownUtxo({})".format(str(self))
    _UniffiTempCreateTxError.UnknownUtxo = UnknownUtxo # type: ignore
    class MissingNonWitnessUtxo(_UniffiTempCreateTxError):
        def __init__(self, outpoint):
            super().__init__(", ".join([
                "outpoint={!r}".format(outpoint),
            ]))
            self.outpoint = outpoint

        def __repr__(self):
            return "CreateTxError.MissingNonWitnessUtxo({})".format(str(self))
    _UniffiTempCreateTxError.MissingNonWitnessUtxo = MissingNonWitnessUtxo # type: ignore
    class MiniscriptPsbt(_UniffiTempCreateTxError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "CreateTxError.MiniscriptPsbt({})".format(str(self))
    _UniffiTempCreateTxError.MiniscriptPsbt = MiniscriptPsbt # type: ignore
    class PushBytesError(_UniffiTempCreateTxError):
        def __init__(self):
            pass

        def __repr__(self):
            return "CreateTxError.PushBytesError({})".format(str(self))
    _UniffiTempCreateTxError.PushBytesError = PushBytesError # type: ignore
    class LockTimeConversionError(_UniffiTempCreateTxError):
        def __init__(self):
            pass

        def __repr__(self):
            return "CreateTxError.LockTimeConversionError({})".format(str(self))
    _UniffiTempCreateTxError.LockTimeConversionError = LockTimeConversionError # type: ignore

CreateTxError = _UniffiTempCreateTxError # type: ignore
del _UniffiTempCreateTxError


class _UniffiConverterTypeCreateTxError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return CreateTxError.Descriptor(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return CreateTxError.Policy(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return CreateTxError.SpendingPolicyRequired(
                _UniffiConverterString.read(buf),
            )
        if variant == 4:
            return CreateTxError.Version0(
            )
        if variant == 5:
            return CreateTxError.Version1Csv(
            )
        if variant == 6:
            return CreateTxError.LockTime(
                _UniffiConverterString.read(buf),
                _UniffiConverterString.read(buf),
            )
        if variant == 7:
            return CreateTxError.RbfSequenceCsv(
                _UniffiConverterString.read(buf),
                _UniffiConverterString.read(buf),
            )
        if variant == 8:
            return CreateTxError.FeeTooLow(
                _UniffiConverterString.read(buf),
            )
        if variant == 9:
            return CreateTxError.FeeRateTooLow(
                _UniffiConverterString.read(buf),
            )
        if variant == 10:
            return CreateTxError.NoUtxosSelected(
            )
        if variant == 11:
            return CreateTxError.OutputBelowDustLimit(
                _UniffiConverterUInt64.read(buf),
            )
        if variant == 12:
            return CreateTxError.ChangePolicyDescriptor(
            )
        if variant == 13:
            return CreateTxError.CoinSelection(
                _UniffiConverterString.read(buf),
            )
        if variant == 14:
            return CreateTxError.InsufficientFunds(
                _UniffiConverterUInt64.read(buf),
                _UniffiConverterUInt64.read(buf),
            )
        if variant == 15:
            return CreateTxError.NoRecipients(
            )
        if variant == 16:
            return CreateTxError.Psbt(
                _UniffiConverterString.read(buf),
            )
        if variant == 17:
            return CreateTxError.MissingKeyOrigin(
                _UniffiConverterString.read(buf),
            )
        if variant == 18:
            return CreateTxError.UnknownUtxo(
                _UniffiConverterString.read(buf),
            )
        if variant == 19:
            return CreateTxError.MissingNonWitnessUtxo(
                _UniffiConverterString.read(buf),
            )
        if variant == 20:
            return CreateTxError.MiniscriptPsbt(
                _UniffiConverterString.read(buf),
            )
        if variant == 21:
            return CreateTxError.PushBytesError(
            )
        if variant == 22:
            return CreateTxError.LockTimeConversionError(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, CreateTxError.Descriptor):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, CreateTxError.Policy):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, CreateTxError.SpendingPolicyRequired):
            _UniffiConverterString.check_lower(value.kind)
            return
        if isinstance(value, CreateTxError.Version0):
            return
        if isinstance(value, CreateTxError.Version1Csv):
            return
        if isinstance(value, CreateTxError.LockTime):
            _UniffiConverterString.check_lower(value.requested)
            _UniffiConverterString.check_lower(value.required)
            return
        if isinstance(value, CreateTxError.RbfSequenceCsv):
            _UniffiConverterString.check_lower(value.sequence)
            _UniffiConverterString.check_lower(value.csv)
            return
        if isinstance(value, CreateTxError.FeeTooLow):
            _UniffiConverterString.check_lower(value.required)
            return
        if isinstance(value, CreateTxError.FeeRateTooLow):
            _UniffiConverterString.check_lower(value.required)
            return
        if isinstance(value, CreateTxError.NoUtxosSelected):
            return
        if isinstance(value, CreateTxError.OutputBelowDustLimit):
            _UniffiConverterUInt64.check_lower(value.index)
            return
        if isinstance(value, CreateTxError.ChangePolicyDescriptor):
            return
        if isinstance(value, CreateTxError.CoinSelection):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, CreateTxError.InsufficientFunds):
            _UniffiConverterUInt64.check_lower(value.needed)
            _UniffiConverterUInt64.check_lower(value.available)
            return
        if isinstance(value, CreateTxError.NoRecipients):
            return
        if isinstance(value, CreateTxError.Psbt):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, CreateTxError.MissingKeyOrigin):
            _UniffiConverterString.check_lower(value.key)
            return
        if isinstance(value, CreateTxError.UnknownUtxo):
            _UniffiConverterString.check_lower(value.outpoint)
            return
        if isinstance(value, CreateTxError.MissingNonWitnessUtxo):
            _UniffiConverterString.check_lower(value.outpoint)
            return
        if isinstance(value, CreateTxError.MiniscriptPsbt):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, CreateTxError.PushBytesError):
            return
        if isinstance(value, CreateTxError.LockTimeConversionError):
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, CreateTxError.Descriptor):
            buf.write_i32(1)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, CreateTxError.Policy):
            buf.write_i32(2)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, CreateTxError.SpendingPolicyRequired):
            buf.write_i32(3)
            _UniffiConverterString.write(value.kind, buf)
        if isinstance(value, CreateTxError.Version0):
            buf.write_i32(4)
        if isinstance(value, CreateTxError.Version1Csv):
            buf.write_i32(5)
        if isinstance(value, CreateTxError.LockTime):
            buf.write_i32(6)
            _UniffiConverterString.write(value.requested, buf)
            _UniffiConverterString.write(value.required, buf)
        if isinstance(value, CreateTxError.RbfSequenceCsv):
            buf.write_i32(7)
            _UniffiConverterString.write(value.sequence, buf)
            _UniffiConverterString.write(value.csv, buf)
        if isinstance(value, CreateTxError.FeeTooLow):
            buf.write_i32(8)
            _UniffiConverterString.write(value.required, buf)
        if isinstance(value, CreateTxError.FeeRateTooLow):
            buf.write_i32(9)
            _UniffiConverterString.write(value.required, buf)
        if isinstance(value, CreateTxError.NoUtxosSelected):
            buf.write_i32(10)
        if isinstance(value, CreateTxError.OutputBelowDustLimit):
            buf.write_i32(11)
            _UniffiConverterUInt64.write(value.index, buf)
        if isinstance(value, CreateTxError.ChangePolicyDescriptor):
            buf.write_i32(12)
        if isinstance(value, CreateTxError.CoinSelection):
            buf.write_i32(13)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, CreateTxError.InsufficientFunds):
            buf.write_i32(14)
            _UniffiConverterUInt64.write(value.needed, buf)
            _UniffiConverterUInt64.write(value.available, buf)
        if isinstance(value, CreateTxError.NoRecipients):
            buf.write_i32(15)
        if isinstance(value, CreateTxError.Psbt):
            buf.write_i32(16)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, CreateTxError.MissingKeyOrigin):
            buf.write_i32(17)
            _UniffiConverterString.write(value.key, buf)
        if isinstance(value, CreateTxError.UnknownUtxo):
            buf.write_i32(18)
            _UniffiConverterString.write(value.outpoint, buf)
        if isinstance(value, CreateTxError.MissingNonWitnessUtxo):
            buf.write_i32(19)
            _UniffiConverterString.write(value.outpoint, buf)
        if isinstance(value, CreateTxError.MiniscriptPsbt):
            buf.write_i32(20)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, CreateTxError.PushBytesError):
            buf.write_i32(21)
        if isinstance(value, CreateTxError.LockTimeConversionError):
            buf.write_i32(22)


# CreateWithPersistError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class CreateWithPersistError(Exception):
    pass

_UniffiTempCreateWithPersistError = CreateWithPersistError

class CreateWithPersistError:  # type: ignore
    class Persist(_UniffiTempCreateWithPersistError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "CreateWithPersistError.Persist({})".format(str(self))
    _UniffiTempCreateWithPersistError.Persist = Persist # type: ignore
    class DataAlreadyExists(_UniffiTempCreateWithPersistError):
        def __init__(self):
            pass

        def __repr__(self):
            return "CreateWithPersistError.DataAlreadyExists({})".format(str(self))
    _UniffiTempCreateWithPersistError.DataAlreadyExists = DataAlreadyExists # type: ignore
    class Descriptor(_UniffiTempCreateWithPersistError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "CreateWithPersistError.Descriptor({})".format(str(self))
    _UniffiTempCreateWithPersistError.Descriptor = Descriptor # type: ignore

CreateWithPersistError = _UniffiTempCreateWithPersistError # type: ignore
del _UniffiTempCreateWithPersistError


class _UniffiConverterTypeCreateWithPersistError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return CreateWithPersistError.Persist(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return CreateWithPersistError.DataAlreadyExists(
            )
        if variant == 3:
            return CreateWithPersistError.Descriptor(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, CreateWithPersistError.Persist):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, CreateWithPersistError.DataAlreadyExists):
            return
        if isinstance(value, CreateWithPersistError.Descriptor):
            _UniffiConverterString.check_lower(value.error_message)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, CreateWithPersistError.Persist):
            buf.write_i32(1)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, CreateWithPersistError.DataAlreadyExists):
            buf.write_i32(2)
        if isinstance(value, CreateWithPersistError.Descriptor):
            buf.write_i32(3)
            _UniffiConverterString.write(value.error_message, buf)


# DescriptorError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class DescriptorError(Exception):
    pass

_UniffiTempDescriptorError = DescriptorError

class DescriptorError:  # type: ignore
    class InvalidHdKeyPath(_UniffiTempDescriptorError):
        def __init__(self):
            pass

        def __repr__(self):
            return "DescriptorError.InvalidHdKeyPath({})".format(str(self))
    _UniffiTempDescriptorError.InvalidHdKeyPath = InvalidHdKeyPath # type: ignore
    class InvalidDescriptorChecksum(_UniffiTempDescriptorError):
        def __init__(self):
            pass

        def __repr__(self):
            return "DescriptorError.InvalidDescriptorChecksum({})".format(str(self))
    _UniffiTempDescriptorError.InvalidDescriptorChecksum = InvalidDescriptorChecksum # type: ignore
    class HardenedDerivationXpub(_UniffiTempDescriptorError):
        def __init__(self):
            pass

        def __repr__(self):
            return "DescriptorError.HardenedDerivationXpub({})".format(str(self))
    _UniffiTempDescriptorError.HardenedDerivationXpub = HardenedDerivationXpub # type: ignore
    class MultiPath(_UniffiTempDescriptorError):
        def __init__(self):
            pass

        def __repr__(self):
            return "DescriptorError.MultiPath({})".format(str(self))
    _UniffiTempDescriptorError.MultiPath = MultiPath # type: ignore
    class Key(_UniffiTempDescriptorError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "DescriptorError.Key({})".format(str(self))
    _UniffiTempDescriptorError.Key = Key # type: ignore
    class Policy(_UniffiTempDescriptorError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "DescriptorError.Policy({})".format(str(self))
    _UniffiTempDescriptorError.Policy = Policy # type: ignore
    class InvalidDescriptorCharacter(_UniffiTempDescriptorError):
        def __init__(self, char):
            super().__init__(", ".join([
                "char={!r}".format(char),
            ]))
            self.char = char

        def __repr__(self):
            return "DescriptorError.InvalidDescriptorCharacter({})".format(str(self))
    _UniffiTempDescriptorError.InvalidDescriptorCharacter = InvalidDescriptorCharacter # type: ignore
    class Bip32(_UniffiTempDescriptorError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "DescriptorError.Bip32({})".format(str(self))
    _UniffiTempDescriptorError.Bip32 = Bip32 # type: ignore
    class Base58(_UniffiTempDescriptorError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "DescriptorError.Base58({})".format(str(self))
    _UniffiTempDescriptorError.Base58 = Base58 # type: ignore
    class Pk(_UniffiTempDescriptorError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "DescriptorError.Pk({})".format(str(self))
    _UniffiTempDescriptorError.Pk = Pk # type: ignore
    class Miniscript(_UniffiTempDescriptorError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "DescriptorError.Miniscript({})".format(str(self))
    _UniffiTempDescriptorError.Miniscript = Miniscript # type: ignore
    class Hex(_UniffiTempDescriptorError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "DescriptorError.Hex({})".format(str(self))
    _UniffiTempDescriptorError.Hex = Hex # type: ignore
    class ExternalAndInternalAreTheSame(_UniffiTempDescriptorError):
        def __init__(self):
            pass

        def __repr__(self):
            return "DescriptorError.ExternalAndInternalAreTheSame({})".format(str(self))
    _UniffiTempDescriptorError.ExternalAndInternalAreTheSame = ExternalAndInternalAreTheSame # type: ignore

DescriptorError = _UniffiTempDescriptorError # type: ignore
del _UniffiTempDescriptorError


class _UniffiConverterTypeDescriptorError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return DescriptorError.InvalidHdKeyPath(
            )
        if variant == 2:
            return DescriptorError.InvalidDescriptorChecksum(
            )
        if variant == 3:
            return DescriptorError.HardenedDerivationXpub(
            )
        if variant == 4:
            return DescriptorError.MultiPath(
            )
        if variant == 5:
            return DescriptorError.Key(
                _UniffiConverterString.read(buf),
            )
        if variant == 6:
            return DescriptorError.Policy(
                _UniffiConverterString.read(buf),
            )
        if variant == 7:
            return DescriptorError.InvalidDescriptorCharacter(
                _UniffiConverterString.read(buf),
            )
        if variant == 8:
            return DescriptorError.Bip32(
                _UniffiConverterString.read(buf),
            )
        if variant == 9:
            return DescriptorError.Base58(
                _UniffiConverterString.read(buf),
            )
        if variant == 10:
            return DescriptorError.Pk(
                _UniffiConverterString.read(buf),
            )
        if variant == 11:
            return DescriptorError.Miniscript(
                _UniffiConverterString.read(buf),
            )
        if variant == 12:
            return DescriptorError.Hex(
                _UniffiConverterString.read(buf),
            )
        if variant == 13:
            return DescriptorError.ExternalAndInternalAreTheSame(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, DescriptorError.InvalidHdKeyPath):
            return
        if isinstance(value, DescriptorError.InvalidDescriptorChecksum):
            return
        if isinstance(value, DescriptorError.HardenedDerivationXpub):
            return
        if isinstance(value, DescriptorError.MultiPath):
            return
        if isinstance(value, DescriptorError.Key):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, DescriptorError.Policy):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, DescriptorError.InvalidDescriptorCharacter):
            _UniffiConverterString.check_lower(value.char)
            return
        if isinstance(value, DescriptorError.Bip32):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, DescriptorError.Base58):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, DescriptorError.Pk):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, DescriptorError.Miniscript):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, DescriptorError.Hex):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, DescriptorError.ExternalAndInternalAreTheSame):
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, DescriptorError.InvalidHdKeyPath):
            buf.write_i32(1)
        if isinstance(value, DescriptorError.InvalidDescriptorChecksum):
            buf.write_i32(2)
        if isinstance(value, DescriptorError.HardenedDerivationXpub):
            buf.write_i32(3)
        if isinstance(value, DescriptorError.MultiPath):
            buf.write_i32(4)
        if isinstance(value, DescriptorError.Key):
            buf.write_i32(5)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, DescriptorError.Policy):
            buf.write_i32(6)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, DescriptorError.InvalidDescriptorCharacter):
            buf.write_i32(7)
            _UniffiConverterString.write(value.char, buf)
        if isinstance(value, DescriptorError.Bip32):
            buf.write_i32(8)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, DescriptorError.Base58):
            buf.write_i32(9)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, DescriptorError.Pk):
            buf.write_i32(10)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, DescriptorError.Miniscript):
            buf.write_i32(11)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, DescriptorError.Hex):
            buf.write_i32(12)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, DescriptorError.ExternalAndInternalAreTheSame):
            buf.write_i32(13)


# DescriptorKeyError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class DescriptorKeyError(Exception):
    pass

_UniffiTempDescriptorKeyError = DescriptorKeyError

class DescriptorKeyError:  # type: ignore
    class Parse(_UniffiTempDescriptorKeyError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "DescriptorKeyError.Parse({})".format(str(self))
    _UniffiTempDescriptorKeyError.Parse = Parse # type: ignore
    class InvalidKeyType(_UniffiTempDescriptorKeyError):
        def __init__(self):
            pass

        def __repr__(self):
            return "DescriptorKeyError.InvalidKeyType({})".format(str(self))
    _UniffiTempDescriptorKeyError.InvalidKeyType = InvalidKeyType # type: ignore
    class Bip32(_UniffiTempDescriptorKeyError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "DescriptorKeyError.Bip32({})".format(str(self))
    _UniffiTempDescriptorKeyError.Bip32 = Bip32 # type: ignore

DescriptorKeyError = _UniffiTempDescriptorKeyError # type: ignore
del _UniffiTempDescriptorKeyError


class _UniffiConverterTypeDescriptorKeyError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return DescriptorKeyError.Parse(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return DescriptorKeyError.InvalidKeyType(
            )
        if variant == 3:
            return DescriptorKeyError.Bip32(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, DescriptorKeyError.Parse):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, DescriptorKeyError.InvalidKeyType):
            return
        if isinstance(value, DescriptorKeyError.Bip32):
            _UniffiConverterString.check_lower(value.error_message)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, DescriptorKeyError.Parse):
            buf.write_i32(1)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, DescriptorKeyError.InvalidKeyType):
            buf.write_i32(2)
        if isinstance(value, DescriptorKeyError.Bip32):
            buf.write_i32(3)
            _UniffiConverterString.write(value.error_message, buf)


# ElectrumError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class ElectrumError(Exception):
    pass

_UniffiTempElectrumError = ElectrumError

class ElectrumError:  # type: ignore
    class IoError(_UniffiTempElectrumError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "ElectrumError.IoError({})".format(str(self))
    _UniffiTempElectrumError.IoError = IoError # type: ignore
    class Json(_UniffiTempElectrumError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "ElectrumError.Json({})".format(str(self))
    _UniffiTempElectrumError.Json = Json # type: ignore
    class Hex(_UniffiTempElectrumError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "ElectrumError.Hex({})".format(str(self))
    _UniffiTempElectrumError.Hex = Hex # type: ignore
    class Protocol(_UniffiTempElectrumError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "ElectrumError.Protocol({})".format(str(self))
    _UniffiTempElectrumError.Protocol = Protocol # type: ignore
    class Bitcoin(_UniffiTempElectrumError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "ElectrumError.Bitcoin({})".format(str(self))
    _UniffiTempElectrumError.Bitcoin = Bitcoin # type: ignore
    class AlreadySubscribed(_UniffiTempElectrumError):
        def __init__(self):
            pass

        def __repr__(self):
            return "ElectrumError.AlreadySubscribed({})".format(str(self))
    _UniffiTempElectrumError.AlreadySubscribed = AlreadySubscribed # type: ignore
    class NotSubscribed(_UniffiTempElectrumError):
        def __init__(self):
            pass

        def __repr__(self):
            return "ElectrumError.NotSubscribed({})".format(str(self))
    _UniffiTempElectrumError.NotSubscribed = NotSubscribed # type: ignore
    class InvalidResponse(_UniffiTempElectrumError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "ElectrumError.InvalidResponse({})".format(str(self))
    _UniffiTempElectrumError.InvalidResponse = InvalidResponse # type: ignore
    class Message(_UniffiTempElectrumError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "ElectrumError.Message({})".format(str(self))
    _UniffiTempElectrumError.Message = Message # type: ignore
    class InvalidDnsNameError(_UniffiTempElectrumError):
        def __init__(self, domain):
            super().__init__(", ".join([
                "domain={!r}".format(domain),
            ]))
            self.domain = domain

        def __repr__(self):
            return "ElectrumError.InvalidDnsNameError({})".format(str(self))
    _UniffiTempElectrumError.InvalidDnsNameError = InvalidDnsNameError # type: ignore
    class MissingDomain(_UniffiTempElectrumError):
        def __init__(self):
            pass

        def __repr__(self):
            return "ElectrumError.MissingDomain({})".format(str(self))
    _UniffiTempElectrumError.MissingDomain = MissingDomain # type: ignore
    class AllAttemptsErrored(_UniffiTempElectrumError):
        def __init__(self):
            pass

        def __repr__(self):
            return "ElectrumError.AllAttemptsErrored({})".format(str(self))
    _UniffiTempElectrumError.AllAttemptsErrored = AllAttemptsErrored # type: ignore
    class SharedIoError(_UniffiTempElectrumError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "ElectrumError.SharedIoError({})".format(str(self))
    _UniffiTempElectrumError.SharedIoError = SharedIoError # type: ignore
    class CouldntLockReader(_UniffiTempElectrumError):
        def __init__(self):
            pass

        def __repr__(self):
            return "ElectrumError.CouldntLockReader({})".format(str(self))
    _UniffiTempElectrumError.CouldntLockReader = CouldntLockReader # type: ignore
    class Mpsc(_UniffiTempElectrumError):
        def __init__(self):
            pass

        def __repr__(self):
            return "ElectrumError.Mpsc({})".format(str(self))
    _UniffiTempElectrumError.Mpsc = Mpsc # type: ignore
    class CouldNotCreateConnection(_UniffiTempElectrumError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "ElectrumError.CouldNotCreateConnection({})".format(str(self))
    _UniffiTempElectrumError.CouldNotCreateConnection = CouldNotCreateConnection # type: ignore
    class RequestAlreadyConsumed(_UniffiTempElectrumError):
        def __init__(self):
            pass

        def __repr__(self):
            return "ElectrumError.RequestAlreadyConsumed({})".format(str(self))
    _UniffiTempElectrumError.RequestAlreadyConsumed = RequestAlreadyConsumed # type: ignore

ElectrumError = _UniffiTempElectrumError # type: ignore
del _UniffiTempElectrumError


class _UniffiConverterTypeElectrumError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return ElectrumError.IoError(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return ElectrumError.Json(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return ElectrumError.Hex(
                _UniffiConverterString.read(buf),
            )
        if variant == 4:
            return ElectrumError.Protocol(
                _UniffiConverterString.read(buf),
            )
        if variant == 5:
            return ElectrumError.Bitcoin(
                _UniffiConverterString.read(buf),
            )
        if variant == 6:
            return ElectrumError.AlreadySubscribed(
            )
        if variant == 7:
            return ElectrumError.NotSubscribed(
            )
        if variant == 8:
            return ElectrumError.InvalidResponse(
                _UniffiConverterString.read(buf),
            )
        if variant == 9:
            return ElectrumError.Message(
                _UniffiConverterString.read(buf),
            )
        if variant == 10:
            return ElectrumError.InvalidDnsNameError(
                _UniffiConverterString.read(buf),
            )
        if variant == 11:
            return ElectrumError.MissingDomain(
            )
        if variant == 12:
            return ElectrumError.AllAttemptsErrored(
            )
        if variant == 13:
            return ElectrumError.SharedIoError(
                _UniffiConverterString.read(buf),
            )
        if variant == 14:
            return ElectrumError.CouldntLockReader(
            )
        if variant == 15:
            return ElectrumError.Mpsc(
            )
        if variant == 16:
            return ElectrumError.CouldNotCreateConnection(
                _UniffiConverterString.read(buf),
            )
        if variant == 17:
            return ElectrumError.RequestAlreadyConsumed(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, ElectrumError.IoError):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, ElectrumError.Json):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, ElectrumError.Hex):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, ElectrumError.Protocol):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, ElectrumError.Bitcoin):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, ElectrumError.AlreadySubscribed):
            return
        if isinstance(value, ElectrumError.NotSubscribed):
            return
        if isinstance(value, ElectrumError.InvalidResponse):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, ElectrumError.Message):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, ElectrumError.InvalidDnsNameError):
            _UniffiConverterString.check_lower(value.domain)
            return
        if isinstance(value, ElectrumError.MissingDomain):
            return
        if isinstance(value, ElectrumError.AllAttemptsErrored):
            return
        if isinstance(value, ElectrumError.SharedIoError):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, ElectrumError.CouldntLockReader):
            return
        if isinstance(value, ElectrumError.Mpsc):
            return
        if isinstance(value, ElectrumError.CouldNotCreateConnection):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, ElectrumError.RequestAlreadyConsumed):
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, ElectrumError.IoError):
            buf.write_i32(1)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, ElectrumError.Json):
            buf.write_i32(2)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, ElectrumError.Hex):
            buf.write_i32(3)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, ElectrumError.Protocol):
            buf.write_i32(4)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, ElectrumError.Bitcoin):
            buf.write_i32(5)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, ElectrumError.AlreadySubscribed):
            buf.write_i32(6)
        if isinstance(value, ElectrumError.NotSubscribed):
            buf.write_i32(7)
        if isinstance(value, ElectrumError.InvalidResponse):
            buf.write_i32(8)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, ElectrumError.Message):
            buf.write_i32(9)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, ElectrumError.InvalidDnsNameError):
            buf.write_i32(10)
            _UniffiConverterString.write(value.domain, buf)
        if isinstance(value, ElectrumError.MissingDomain):
            buf.write_i32(11)
        if isinstance(value, ElectrumError.AllAttemptsErrored):
            buf.write_i32(12)
        if isinstance(value, ElectrumError.SharedIoError):
            buf.write_i32(13)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, ElectrumError.CouldntLockReader):
            buf.write_i32(14)
        if isinstance(value, ElectrumError.Mpsc):
            buf.write_i32(15)
        if isinstance(value, ElectrumError.CouldNotCreateConnection):
            buf.write_i32(16)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, ElectrumError.RequestAlreadyConsumed):
            buf.write_i32(17)


# EsploraError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class EsploraError(Exception):
    pass

_UniffiTempEsploraError = EsploraError

class EsploraError:  # type: ignore
    class Minreq(_UniffiTempEsploraError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "EsploraError.Minreq({})".format(str(self))
    _UniffiTempEsploraError.Minreq = Minreq # type: ignore
    class HttpResponse(_UniffiTempEsploraError):
        def __init__(self, status, error_message):
            super().__init__(", ".join([
                "status={!r}".format(status),
                "error_message={!r}".format(error_message),
            ]))
            self.status = status
            self.error_message = error_message

        def __repr__(self):
            return "EsploraError.HttpResponse({})".format(str(self))
    _UniffiTempEsploraError.HttpResponse = HttpResponse # type: ignore
    class Parsing(_UniffiTempEsploraError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "EsploraError.Parsing({})".format(str(self))
    _UniffiTempEsploraError.Parsing = Parsing # type: ignore
    class StatusCode(_UniffiTempEsploraError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "EsploraError.StatusCode({})".format(str(self))
    _UniffiTempEsploraError.StatusCode = StatusCode # type: ignore
    class BitcoinEncoding(_UniffiTempEsploraError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "EsploraError.BitcoinEncoding({})".format(str(self))
    _UniffiTempEsploraError.BitcoinEncoding = BitcoinEncoding # type: ignore
    class HexToArray(_UniffiTempEsploraError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "EsploraError.HexToArray({})".format(str(self))
    _UniffiTempEsploraError.HexToArray = HexToArray # type: ignore
    class HexToBytes(_UniffiTempEsploraError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "EsploraError.HexToBytes({})".format(str(self))
    _UniffiTempEsploraError.HexToBytes = HexToBytes # type: ignore
    class TransactionNotFound(_UniffiTempEsploraError):
        def __init__(self):
            pass

        def __repr__(self):
            return "EsploraError.TransactionNotFound({})".format(str(self))
    _UniffiTempEsploraError.TransactionNotFound = TransactionNotFound # type: ignore
    class HeaderHeightNotFound(_UniffiTempEsploraError):
        def __init__(self, height):
            super().__init__(", ".join([
                "height={!r}".format(height),
            ]))
            self.height = height

        def __repr__(self):
            return "EsploraError.HeaderHeightNotFound({})".format(str(self))
    _UniffiTempEsploraError.HeaderHeightNotFound = HeaderHeightNotFound # type: ignore
    class HeaderHashNotFound(_UniffiTempEsploraError):
        def __init__(self):
            pass

        def __repr__(self):
            return "EsploraError.HeaderHashNotFound({})".format(str(self))
    _UniffiTempEsploraError.HeaderHashNotFound = HeaderHashNotFound # type: ignore
    class InvalidHttpHeaderName(_UniffiTempEsploraError):
        def __init__(self, name):
            super().__init__(", ".join([
                "name={!r}".format(name),
            ]))
            self.name = name

        def __repr__(self):
            return "EsploraError.InvalidHttpHeaderName({})".format(str(self))
    _UniffiTempEsploraError.InvalidHttpHeaderName = InvalidHttpHeaderName # type: ignore
    class InvalidHttpHeaderValue(_UniffiTempEsploraError):
        def __init__(self, value):
            super().__init__(", ".join([
                "value={!r}".format(value),
            ]))
            self.value = value

        def __repr__(self):
            return "EsploraError.InvalidHttpHeaderValue({})".format(str(self))
    _UniffiTempEsploraError.InvalidHttpHeaderValue = InvalidHttpHeaderValue # type: ignore
    class RequestAlreadyConsumed(_UniffiTempEsploraError):
        def __init__(self):
            pass

        def __repr__(self):
            return "EsploraError.RequestAlreadyConsumed({})".format(str(self))
    _UniffiTempEsploraError.RequestAlreadyConsumed = RequestAlreadyConsumed # type: ignore
    class InvalidResponse(_UniffiTempEsploraError):
        def __init__(self):
            pass

        def __repr__(self):
            return "EsploraError.InvalidResponse({})".format(str(self))
    _UniffiTempEsploraError.InvalidResponse = InvalidResponse # type: ignore

EsploraError = _UniffiTempEsploraError # type: ignore
del _UniffiTempEsploraError


class _UniffiConverterTypeEsploraError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return EsploraError.Minreq(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return EsploraError.HttpResponse(
                _UniffiConverterUInt16.read(buf),
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return EsploraError.Parsing(
                _UniffiConverterString.read(buf),
            )
        if variant == 4:
            return EsploraError.StatusCode(
                _UniffiConverterString.read(buf),
            )
        if variant == 5:
            return EsploraError.BitcoinEncoding(
                _UniffiConverterString.read(buf),
            )
        if variant == 6:
            return EsploraError.HexToArray(
                _UniffiConverterString.read(buf),
            )
        if variant == 7:
            return EsploraError.HexToBytes(
                _UniffiConverterString.read(buf),
            )
        if variant == 8:
            return EsploraError.TransactionNotFound(
            )
        if variant == 9:
            return EsploraError.HeaderHeightNotFound(
                _UniffiConverterUInt32.read(buf),
            )
        if variant == 10:
            return EsploraError.HeaderHashNotFound(
            )
        if variant == 11:
            return EsploraError.InvalidHttpHeaderName(
                _UniffiConverterString.read(buf),
            )
        if variant == 12:
            return EsploraError.InvalidHttpHeaderValue(
                _UniffiConverterString.read(buf),
            )
        if variant == 13:
            return EsploraError.RequestAlreadyConsumed(
            )
        if variant == 14:
            return EsploraError.InvalidResponse(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, EsploraError.Minreq):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, EsploraError.HttpResponse):
            _UniffiConverterUInt16.check_lower(value.status)
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, EsploraError.Parsing):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, EsploraError.StatusCode):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, EsploraError.BitcoinEncoding):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, EsploraError.HexToArray):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, EsploraError.HexToBytes):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, EsploraError.TransactionNotFound):
            return
        if isinstance(value, EsploraError.HeaderHeightNotFound):
            _UniffiConverterUInt32.check_lower(value.height)
            return
        if isinstance(value, EsploraError.HeaderHashNotFound):
            return
        if isinstance(value, EsploraError.InvalidHttpHeaderName):
            _UniffiConverterString.check_lower(value.name)
            return
        if isinstance(value, EsploraError.InvalidHttpHeaderValue):
            _UniffiConverterString.check_lower(value.value)
            return
        if isinstance(value, EsploraError.RequestAlreadyConsumed):
            return
        if isinstance(value, EsploraError.InvalidResponse):
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, EsploraError.Minreq):
            buf.write_i32(1)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, EsploraError.HttpResponse):
            buf.write_i32(2)
            _UniffiConverterUInt16.write(value.status, buf)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, EsploraError.Parsing):
            buf.write_i32(3)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, EsploraError.StatusCode):
            buf.write_i32(4)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, EsploraError.BitcoinEncoding):
            buf.write_i32(5)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, EsploraError.HexToArray):
            buf.write_i32(6)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, EsploraError.HexToBytes):
            buf.write_i32(7)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, EsploraError.TransactionNotFound):
            buf.write_i32(8)
        if isinstance(value, EsploraError.HeaderHeightNotFound):
            buf.write_i32(9)
            _UniffiConverterUInt32.write(value.height, buf)
        if isinstance(value, EsploraError.HeaderHashNotFound):
            buf.write_i32(10)
        if isinstance(value, EsploraError.InvalidHttpHeaderName):
            buf.write_i32(11)
            _UniffiConverterString.write(value.name, buf)
        if isinstance(value, EsploraError.InvalidHttpHeaderValue):
            buf.write_i32(12)
            _UniffiConverterString.write(value.value, buf)
        if isinstance(value, EsploraError.RequestAlreadyConsumed):
            buf.write_i32(13)
        if isinstance(value, EsploraError.InvalidResponse):
            buf.write_i32(14)


# ExtractTxError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class ExtractTxError(Exception):
    pass

_UniffiTempExtractTxError = ExtractTxError

class ExtractTxError:  # type: ignore
    class AbsurdFeeRate(_UniffiTempExtractTxError):
        def __init__(self, fee_rate):
            super().__init__(", ".join([
                "fee_rate={!r}".format(fee_rate),
            ]))
            self.fee_rate = fee_rate

        def __repr__(self):
            return "ExtractTxError.AbsurdFeeRate({})".format(str(self))
    _UniffiTempExtractTxError.AbsurdFeeRate = AbsurdFeeRate # type: ignore
    class MissingInputValue(_UniffiTempExtractTxError):
        def __init__(self):
            pass

        def __repr__(self):
            return "ExtractTxError.MissingInputValue({})".format(str(self))
    _UniffiTempExtractTxError.MissingInputValue = MissingInputValue # type: ignore
    class SendingTooMuch(_UniffiTempExtractTxError):
        def __init__(self):
            pass

        def __repr__(self):
            return "ExtractTxError.SendingTooMuch({})".format(str(self))
    _UniffiTempExtractTxError.SendingTooMuch = SendingTooMuch # type: ignore
    class OtherExtractTxErr(_UniffiTempExtractTxError):
        def __init__(self):
            pass

        def __repr__(self):
            return "ExtractTxError.OtherExtractTxErr({})".format(str(self))
    _UniffiTempExtractTxError.OtherExtractTxErr = OtherExtractTxErr # type: ignore

ExtractTxError = _UniffiTempExtractTxError # type: ignore
del _UniffiTempExtractTxError


class _UniffiConverterTypeExtractTxError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return ExtractTxError.AbsurdFeeRate(
                _UniffiConverterUInt64.read(buf),
            )
        if variant == 2:
            return ExtractTxError.MissingInputValue(
            )
        if variant == 3:
            return ExtractTxError.SendingTooMuch(
            )
        if variant == 4:
            return ExtractTxError.OtherExtractTxErr(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, ExtractTxError.AbsurdFeeRate):
            _UniffiConverterUInt64.check_lower(value.fee_rate)
            return
        if isinstance(value, ExtractTxError.MissingInputValue):
            return
        if isinstance(value, ExtractTxError.SendingTooMuch):
            return
        if isinstance(value, ExtractTxError.OtherExtractTxErr):
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, ExtractTxError.AbsurdFeeRate):
            buf.write_i32(1)
            _UniffiConverterUInt64.write(value.fee_rate, buf)
        if isinstance(value, ExtractTxError.MissingInputValue):
            buf.write_i32(2)
        if isinstance(value, ExtractTxError.SendingTooMuch):
            buf.write_i32(3)
        if isinstance(value, ExtractTxError.OtherExtractTxErr):
            buf.write_i32(4)


# FeeRateError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class FeeRateError(Exception):
    pass

_UniffiTempFeeRateError = FeeRateError

class FeeRateError:  # type: ignore
    class ArithmeticOverflow(_UniffiTempFeeRateError):
        def __init__(self):
            pass

        def __repr__(self):
            return "FeeRateError.ArithmeticOverflow({})".format(str(self))
    _UniffiTempFeeRateError.ArithmeticOverflow = ArithmeticOverflow # type: ignore

FeeRateError = _UniffiTempFeeRateError # type: ignore
del _UniffiTempFeeRateError


class _UniffiConverterTypeFeeRateError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return FeeRateError.ArithmeticOverflow(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, FeeRateError.ArithmeticOverflow):
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, FeeRateError.ArithmeticOverflow):
            buf.write_i32(1)


# FromScriptError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class FromScriptError(Exception):
    pass

_UniffiTempFromScriptError = FromScriptError

class FromScriptError:  # type: ignore
    class UnrecognizedScript(_UniffiTempFromScriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "FromScriptError.UnrecognizedScript({})".format(str(self))
    _UniffiTempFromScriptError.UnrecognizedScript = UnrecognizedScript # type: ignore
    class WitnessProgram(_UniffiTempFromScriptError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "FromScriptError.WitnessProgram({})".format(str(self))
    _UniffiTempFromScriptError.WitnessProgram = WitnessProgram # type: ignore
    class WitnessVersion(_UniffiTempFromScriptError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "FromScriptError.WitnessVersion({})".format(str(self))
    _UniffiTempFromScriptError.WitnessVersion = WitnessVersion # type: ignore
    class OtherFromScriptErr(_UniffiTempFromScriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "FromScriptError.OtherFromScriptErr({})".format(str(self))
    _UniffiTempFromScriptError.OtherFromScriptErr = OtherFromScriptErr # type: ignore

FromScriptError = _UniffiTempFromScriptError # type: ignore
del _UniffiTempFromScriptError


class _UniffiConverterTypeFromScriptError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return FromScriptError.UnrecognizedScript(
            )
        if variant == 2:
            return FromScriptError.WitnessProgram(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return FromScriptError.WitnessVersion(
                _UniffiConverterString.read(buf),
            )
        if variant == 4:
            return FromScriptError.OtherFromScriptErr(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, FromScriptError.UnrecognizedScript):
            return
        if isinstance(value, FromScriptError.WitnessProgram):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, FromScriptError.WitnessVersion):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, FromScriptError.OtherFromScriptErr):
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, FromScriptError.UnrecognizedScript):
            buf.write_i32(1)
        if isinstance(value, FromScriptError.WitnessProgram):
            buf.write_i32(2)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, FromScriptError.WitnessVersion):
            buf.write_i32(3)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, FromScriptError.OtherFromScriptErr):
            buf.write_i32(4)


# HashParseError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class HashParseError(Exception):
    pass

_UniffiTempHashParseError = HashParseError

class HashParseError:  # type: ignore
    class InvalidHash(_UniffiTempHashParseError):
        def __init__(self, len):
            super().__init__(", ".join([
                "len={!r}".format(len),
            ]))
            self.len = len

        def __repr__(self):
            return "HashParseError.InvalidHash({})".format(str(self))
    _UniffiTempHashParseError.InvalidHash = InvalidHash # type: ignore
    class InvalidHexString(_UniffiTempHashParseError):
        def __init__(self, hex):
            super().__init__(", ".join([
                "hex={!r}".format(hex),
            ]))
            self.hex = hex

        def __repr__(self):
            return "HashParseError.InvalidHexString({})".format(str(self))
    _UniffiTempHashParseError.InvalidHexString = InvalidHexString # type: ignore

HashParseError = _UniffiTempHashParseError # type: ignore
del _UniffiTempHashParseError


class _UniffiConverterTypeHashParseError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return HashParseError.InvalidHash(
                _UniffiConverterUInt32.read(buf),
            )
        if variant == 2:
            return HashParseError.InvalidHexString(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, HashParseError.InvalidHash):
            _UniffiConverterUInt32.check_lower(value.len)
            return
        if isinstance(value, HashParseError.InvalidHexString):
            _UniffiConverterString.check_lower(value.hex)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, HashParseError.InvalidHash):
            buf.write_i32(1)
            _UniffiConverterUInt32.write(value.len, buf)
        if isinstance(value, HashParseError.InvalidHexString):
            buf.write_i32(2)
            _UniffiConverterString.write(value.hex, buf)





class Info:
    """
    A log message from the node.
    """

    def __init__(self):
        raise RuntimeError("Info cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class CONNECTIONS_MET:
        """
        All the required connections have been met. This is subject to change.
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "Info.CONNECTIONS_MET()".format()

        def __eq__(self, other):
            if not other.is_CONNECTIONS_MET():
                return False
            return True
    
    class SUCCESSFUL_HANDSHAKE:
        """
        The node was able to successfully connect to a remote peer.
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "Info.SUCCESSFUL_HANDSHAKE()".format()

        def __eq__(self, other):
            if not other.is_SUCCESSFUL_HANDSHAKE():
                return False
            return True
    
    class NEW_CHAIN_HEIGHT:
        """
        The block header chain of most work was extended to this height.
        """

        height: "int"

        def __init__(self,height: "int"):
            self.height = height

        def __str__(self):
            return "Info.NEW_CHAIN_HEIGHT(height={})".format(self.height)

        def __eq__(self, other):
            if not other.is_NEW_CHAIN_HEIGHT():
                return False
            if self.height != other.height:
                return False
            return True
    
    class NEW_FORK:
        """
        A new fork was advertised to the node, but has not been selected yet.
        """

        height: "int"

        def __init__(self,height: "int"):
            self.height = height

        def __str__(self):
            return "Info.NEW_FORK(height={})".format(self.height)

        def __eq__(self, other):
            if not other.is_NEW_FORK():
                return False
            if self.height != other.height:
                return False
            return True
    
    class PROGRESS:
        """
        A percentage value of filters that have been scanned.
        """

        progress: "float"

        def __init__(self,progress: "float"):
            self.progress = progress

        def __str__(self):
            return "Info.PROGRESS(progress={})".format(self.progress)

        def __eq__(self, other):
            if not other.is_PROGRESS():
                return False
            if self.progress != other.progress:
                return False
            return True
    
    class STATE_UPDATE:
        """
        A state in the node syncing process.
        """

        node_state: "NodeState"

        def __init__(self,node_state: "NodeState"):
            self.node_state = node_state

        def __str__(self):
            return "Info.STATE_UPDATE(node_state={})".format(self.node_state)

        def __eq__(self, other):
            if not other.is_STATE_UPDATE():
                return False
            if self.node_state != other.node_state:
                return False
            return True
    
    class TX_GOSSIPED:
        """
        A transaction was broadcast over the wire to a peer that requested it from our inventory.
        The transaction may or may not be rejected by recipient nodes.
        """

        wtxid: "str"

        def __init__(self,wtxid: "str"):
            self.wtxid = wtxid

        def __str__(self):
            return "Info.TX_GOSSIPED(wtxid={})".format(self.wtxid)

        def __eq__(self, other):
            if not other.is_TX_GOSSIPED():
                return False
            if self.wtxid != other.wtxid:
                return False
            return True
    
    

    # For each variant, we have `is_NAME` and `is_name` methods for easily checking
    # whether an instance is that variant.
    def is_CONNECTIONS_MET(self) -> bool:
        return isinstance(self, Info.CONNECTIONS_MET)
    def is_connections_met(self) -> bool:
        return isinstance(self, Info.CONNECTIONS_MET)
    def is_SUCCESSFUL_HANDSHAKE(self) -> bool:
        return isinstance(self, Info.SUCCESSFUL_HANDSHAKE)
    def is_successful_handshake(self) -> bool:
        return isinstance(self, Info.SUCCESSFUL_HANDSHAKE)
    def is_NEW_CHAIN_HEIGHT(self) -> bool:
        return isinstance(self, Info.NEW_CHAIN_HEIGHT)
    def is_new_chain_height(self) -> bool:
        return isinstance(self, Info.NEW_CHAIN_HEIGHT)
    def is_NEW_FORK(self) -> bool:
        return isinstance(self, Info.NEW_FORK)
    def is_new_fork(self) -> bool:
        return isinstance(self, Info.NEW_FORK)
    def is_PROGRESS(self) -> bool:
        return isinstance(self, Info.PROGRESS)
    def is_progress(self) -> bool:
        return isinstance(self, Info.PROGRESS)
    def is_STATE_UPDATE(self) -> bool:
        return isinstance(self, Info.STATE_UPDATE)
    def is_state_update(self) -> bool:
        return isinstance(self, Info.STATE_UPDATE)
    def is_TX_GOSSIPED(self) -> bool:
        return isinstance(self, Info.TX_GOSSIPED)
    def is_tx_gossiped(self) -> bool:
        return isinstance(self, Info.TX_GOSSIPED)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
Info.CONNECTIONS_MET = type("Info.CONNECTIONS_MET", (Info.CONNECTIONS_MET, Info,), {})  # type: ignore
Info.SUCCESSFUL_HANDSHAKE = type("Info.SUCCESSFUL_HANDSHAKE", (Info.SUCCESSFUL_HANDSHAKE, Info,), {})  # type: ignore
Info.NEW_CHAIN_HEIGHT = type("Info.NEW_CHAIN_HEIGHT", (Info.NEW_CHAIN_HEIGHT, Info,), {})  # type: ignore
Info.NEW_FORK = type("Info.NEW_FORK", (Info.NEW_FORK, Info,), {})  # type: ignore
Info.PROGRESS = type("Info.PROGRESS", (Info.PROGRESS, Info,), {})  # type: ignore
Info.STATE_UPDATE = type("Info.STATE_UPDATE", (Info.STATE_UPDATE, Info,), {})  # type: ignore
Info.TX_GOSSIPED = type("Info.TX_GOSSIPED", (Info.TX_GOSSIPED, Info,), {})  # type: ignore




class _UniffiConverterTypeInfo(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return Info.CONNECTIONS_MET(
            )
        if variant == 2:
            return Info.SUCCESSFUL_HANDSHAKE(
            )
        if variant == 3:
            return Info.NEW_CHAIN_HEIGHT(
                _UniffiConverterUInt32.read(buf),
            )
        if variant == 4:
            return Info.NEW_FORK(
                _UniffiConverterUInt32.read(buf),
            )
        if variant == 5:
            return Info.PROGRESS(
                _UniffiConverterFloat.read(buf),
            )
        if variant == 6:
            return Info.STATE_UPDATE(
                _UniffiConverterTypeNodeState.read(buf),
            )
        if variant == 7:
            return Info.TX_GOSSIPED(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_CONNECTIONS_MET():
            return
        if value.is_SUCCESSFUL_HANDSHAKE():
            return
        if value.is_NEW_CHAIN_HEIGHT():
            _UniffiConverterUInt32.check_lower(value.height)
            return
        if value.is_NEW_FORK():
            _UniffiConverterUInt32.check_lower(value.height)
            return
        if value.is_PROGRESS():
            _UniffiConverterFloat.check_lower(value.progress)
            return
        if value.is_STATE_UPDATE():
            _UniffiConverterTypeNodeState.check_lower(value.node_state)
            return
        if value.is_TX_GOSSIPED():
            _UniffiConverterString.check_lower(value.wtxid)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_CONNECTIONS_MET():
            buf.write_i32(1)
        if value.is_SUCCESSFUL_HANDSHAKE():
            buf.write_i32(2)
        if value.is_NEW_CHAIN_HEIGHT():
            buf.write_i32(3)
            _UniffiConverterUInt32.write(value.height, buf)
        if value.is_NEW_FORK():
            buf.write_i32(4)
            _UniffiConverterUInt32.write(value.height, buf)
        if value.is_PROGRESS():
            buf.write_i32(5)
            _UniffiConverterFloat.write(value.progress, buf)
        if value.is_STATE_UPDATE():
            buf.write_i32(6)
            _UniffiConverterTypeNodeState.write(value.node_state, buf)
        if value.is_TX_GOSSIPED():
            buf.write_i32(7)
            _UniffiConverterString.write(value.wtxid, buf)







class KeychainKind(enum.Enum):
    """
    Types of keychains.
    """

    EXTERNAL = 0
    """
    External keychain, used for deriving recipient addresses.
    """

    
    INTERNAL = 1
    """
    Internal keychain, used for deriving change addresses.
    """

    


class _UniffiConverterTypeKeychainKind(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return KeychainKind.EXTERNAL
        if variant == 2:
            return KeychainKind.INTERNAL
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == KeychainKind.EXTERNAL:
            return
        if value == KeychainKind.INTERNAL:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == KeychainKind.EXTERNAL:
            buf.write_i32(1)
        if value == KeychainKind.INTERNAL:
            buf.write_i32(2)




# LoadWithPersistError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class LoadWithPersistError(Exception):
    pass

_UniffiTempLoadWithPersistError = LoadWithPersistError

class LoadWithPersistError:  # type: ignore
    class Persist(_UniffiTempLoadWithPersistError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "LoadWithPersistError.Persist({})".format(str(self))
    _UniffiTempLoadWithPersistError.Persist = Persist # type: ignore
    class InvalidChangeSet(_UniffiTempLoadWithPersistError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "LoadWithPersistError.InvalidChangeSet({})".format(str(self))
    _UniffiTempLoadWithPersistError.InvalidChangeSet = InvalidChangeSet # type: ignore
    class CouldNotLoad(_UniffiTempLoadWithPersistError):
        def __init__(self):
            pass

        def __repr__(self):
            return "LoadWithPersistError.CouldNotLoad({})".format(str(self))
    _UniffiTempLoadWithPersistError.CouldNotLoad = CouldNotLoad # type: ignore

LoadWithPersistError = _UniffiTempLoadWithPersistError # type: ignore
del _UniffiTempLoadWithPersistError


class _UniffiConverterTypeLoadWithPersistError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return LoadWithPersistError.Persist(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return LoadWithPersistError.InvalidChangeSet(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return LoadWithPersistError.CouldNotLoad(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, LoadWithPersistError.Persist):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, LoadWithPersistError.InvalidChangeSet):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, LoadWithPersistError.CouldNotLoad):
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, LoadWithPersistError.Persist):
            buf.write_i32(1)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, LoadWithPersistError.InvalidChangeSet):
            buf.write_i32(2)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, LoadWithPersistError.CouldNotLoad):
            buf.write_i32(3)





class LockTime:
    def __init__(self):
        raise RuntimeError("LockTime cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class BLOCKS:
        height: "int"

        def __init__(self,height: "int"):
            self.height = height

        def __str__(self):
            return "LockTime.BLOCKS(height={})".format(self.height)

        def __eq__(self, other):
            if not other.is_BLOCKS():
                return False
            if self.height != other.height:
                return False
            return True
    
    class SECONDS:
        consensus_time: "int"

        def __init__(self,consensus_time: "int"):
            self.consensus_time = consensus_time

        def __str__(self):
            return "LockTime.SECONDS(consensus_time={})".format(self.consensus_time)

        def __eq__(self, other):
            if not other.is_SECONDS():
                return False
            if self.consensus_time != other.consensus_time:
                return False
            return True
    
    

    # For each variant, we have `is_NAME` and `is_name` methods for easily checking
    # whether an instance is that variant.
    def is_BLOCKS(self) -> bool:
        return isinstance(self, LockTime.BLOCKS)
    def is_blocks(self) -> bool:
        return isinstance(self, LockTime.BLOCKS)
    def is_SECONDS(self) -> bool:
        return isinstance(self, LockTime.SECONDS)
    def is_seconds(self) -> bool:
        return isinstance(self, LockTime.SECONDS)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
LockTime.BLOCKS = type("LockTime.BLOCKS", (LockTime.BLOCKS, LockTime,), {})  # type: ignore
LockTime.SECONDS = type("LockTime.SECONDS", (LockTime.SECONDS, LockTime,), {})  # type: ignore




class _UniffiConverterTypeLockTime(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return LockTime.BLOCKS(
                _UniffiConverterUInt32.read(buf),
            )
        if variant == 2:
            return LockTime.SECONDS(
                _UniffiConverterUInt32.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_BLOCKS():
            _UniffiConverterUInt32.check_lower(value.height)
            return
        if value.is_SECONDS():
            _UniffiConverterUInt32.check_lower(value.consensus_time)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_BLOCKS():
            buf.write_i32(1)
            _UniffiConverterUInt32.write(value.height, buf)
        if value.is_SECONDS():
            buf.write_i32(2)
            _UniffiConverterUInt32.write(value.consensus_time, buf)







class LogLevel(enum.Enum):
    """
    Select the category of messages for the node to emit.
    """

    DEBUG = 0
    """
    Send string messages. These messages are intended for debugging or troubleshooting
    node operation.
    """

    
    INFO = 1
    """
    Send info and warning messages, but omit debug strings - including their memory allocations.
    Ideal for a production application that uses minimal logging.
    """

    
    WARNING = 2
    """
    Omit debug strings and info messages, including their memory allocations.
    """

    


class _UniffiConverterTypeLogLevel(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return LogLevel.DEBUG
        if variant == 2:
            return LogLevel.INFO
        if variant == 3:
            return LogLevel.WARNING
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == LogLevel.DEBUG:
            return
        if value == LogLevel.INFO:
            return
        if value == LogLevel.WARNING:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == LogLevel.DEBUG:
            buf.write_i32(1)
        if value == LogLevel.INFO:
            buf.write_i32(2)
        if value == LogLevel.WARNING:
            buf.write_i32(3)




# MiniscriptError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class MiniscriptError(Exception):
    pass

_UniffiTempMiniscriptError = MiniscriptError

class MiniscriptError:  # type: ignore
    class AbsoluteLockTime(_UniffiTempMiniscriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "MiniscriptError.AbsoluteLockTime({})".format(str(self))
    _UniffiTempMiniscriptError.AbsoluteLockTime = AbsoluteLockTime # type: ignore
    class AddrError(_UniffiTempMiniscriptError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "MiniscriptError.AddrError({})".format(str(self))
    _UniffiTempMiniscriptError.AddrError = AddrError # type: ignore
    class AddrP2shError(_UniffiTempMiniscriptError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "MiniscriptError.AddrP2shError({})".format(str(self))
    _UniffiTempMiniscriptError.AddrP2shError = AddrP2shError # type: ignore
    class AnalysisError(_UniffiTempMiniscriptError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "MiniscriptError.AnalysisError({})".format(str(self))
    _UniffiTempMiniscriptError.AnalysisError = AnalysisError # type: ignore
    class AtOutsideOr(_UniffiTempMiniscriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "MiniscriptError.AtOutsideOr({})".format(str(self))
    _UniffiTempMiniscriptError.AtOutsideOr = AtOutsideOr # type: ignore
    class BadDescriptor(_UniffiTempMiniscriptError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "MiniscriptError.BadDescriptor({})".format(str(self))
    _UniffiTempMiniscriptError.BadDescriptor = BadDescriptor # type: ignore
    class BareDescriptorAddr(_UniffiTempMiniscriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "MiniscriptError.BareDescriptorAddr({})".format(str(self))
    _UniffiTempMiniscriptError.BareDescriptorAddr = BareDescriptorAddr # type: ignore
    class CmsTooManyKeys(_UniffiTempMiniscriptError):
        def __init__(self, keys):
            super().__init__(", ".join([
                "keys={!r}".format(keys),
            ]))
            self.keys = keys

        def __repr__(self):
            return "MiniscriptError.CmsTooManyKeys({})".format(str(self))
    _UniffiTempMiniscriptError.CmsTooManyKeys = CmsTooManyKeys # type: ignore
    class ContextError(_UniffiTempMiniscriptError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "MiniscriptError.ContextError({})".format(str(self))
    _UniffiTempMiniscriptError.ContextError = ContextError # type: ignore
    class CouldNotSatisfy(_UniffiTempMiniscriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "MiniscriptError.CouldNotSatisfy({})".format(str(self))
    _UniffiTempMiniscriptError.CouldNotSatisfy = CouldNotSatisfy # type: ignore
    class ExpectedChar(_UniffiTempMiniscriptError):
        def __init__(self, char):
            super().__init__(", ".join([
                "char={!r}".format(char),
            ]))
            self.char = char

        def __repr__(self):
            return "MiniscriptError.ExpectedChar({})".format(str(self))
    _UniffiTempMiniscriptError.ExpectedChar = ExpectedChar # type: ignore
    class ImpossibleSatisfaction(_UniffiTempMiniscriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "MiniscriptError.ImpossibleSatisfaction({})".format(str(self))
    _UniffiTempMiniscriptError.ImpossibleSatisfaction = ImpossibleSatisfaction # type: ignore
    class InvalidOpcode(_UniffiTempMiniscriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "MiniscriptError.InvalidOpcode({})".format(str(self))
    _UniffiTempMiniscriptError.InvalidOpcode = InvalidOpcode # type: ignore
    class InvalidPush(_UniffiTempMiniscriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "MiniscriptError.InvalidPush({})".format(str(self))
    _UniffiTempMiniscriptError.InvalidPush = InvalidPush # type: ignore
    class LiftError(_UniffiTempMiniscriptError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "MiniscriptError.LiftError({})".format(str(self))
    _UniffiTempMiniscriptError.LiftError = LiftError # type: ignore
    class MaxRecursiveDepthExceeded(_UniffiTempMiniscriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "MiniscriptError.MaxRecursiveDepthExceeded({})".format(str(self))
    _UniffiTempMiniscriptError.MaxRecursiveDepthExceeded = MaxRecursiveDepthExceeded # type: ignore
    class MissingSig(_UniffiTempMiniscriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "MiniscriptError.MissingSig({})".format(str(self))
    _UniffiTempMiniscriptError.MissingSig = MissingSig # type: ignore
    class MultiATooManyKeys(_UniffiTempMiniscriptError):
        def __init__(self, keys):
            super().__init__(", ".join([
                "keys={!r}".format(keys),
            ]))
            self.keys = keys

        def __repr__(self):
            return "MiniscriptError.MultiATooManyKeys({})".format(str(self))
    _UniffiTempMiniscriptError.MultiATooManyKeys = MultiATooManyKeys # type: ignore
    class MultiColon(_UniffiTempMiniscriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "MiniscriptError.MultiColon({})".format(str(self))
    _UniffiTempMiniscriptError.MultiColon = MultiColon # type: ignore
    class MultipathDescLenMismatch(_UniffiTempMiniscriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "MiniscriptError.MultipathDescLenMismatch({})".format(str(self))
    _UniffiTempMiniscriptError.MultipathDescLenMismatch = MultipathDescLenMismatch # type: ignore
    class NonMinimalVerify(_UniffiTempMiniscriptError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "MiniscriptError.NonMinimalVerify({})".format(str(self))
    _UniffiTempMiniscriptError.NonMinimalVerify = NonMinimalVerify # type: ignore
    class NonStandardBareScript(_UniffiTempMiniscriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "MiniscriptError.NonStandardBareScript({})".format(str(self))
    _UniffiTempMiniscriptError.NonStandardBareScript = NonStandardBareScript # type: ignore
    class NonTopLevel(_UniffiTempMiniscriptError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "MiniscriptError.NonTopLevel({})".format(str(self))
    _UniffiTempMiniscriptError.NonTopLevel = NonTopLevel # type: ignore
    class ParseThreshold(_UniffiTempMiniscriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "MiniscriptError.ParseThreshold({})".format(str(self))
    _UniffiTempMiniscriptError.ParseThreshold = ParseThreshold # type: ignore
    class PolicyError(_UniffiTempMiniscriptError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "MiniscriptError.PolicyError({})".format(str(self))
    _UniffiTempMiniscriptError.PolicyError = PolicyError # type: ignore
    class PubKeyCtxError(_UniffiTempMiniscriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "MiniscriptError.PubKeyCtxError({})".format(str(self))
    _UniffiTempMiniscriptError.PubKeyCtxError = PubKeyCtxError # type: ignore
    class RelativeLockTime(_UniffiTempMiniscriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "MiniscriptError.RelativeLockTime({})".format(str(self))
    _UniffiTempMiniscriptError.RelativeLockTime = RelativeLockTime # type: ignore
    class Script(_UniffiTempMiniscriptError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "MiniscriptError.Script({})".format(str(self))
    _UniffiTempMiniscriptError.Script = Script # type: ignore
    class Secp(_UniffiTempMiniscriptError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "MiniscriptError.Secp({})".format(str(self))
    _UniffiTempMiniscriptError.Secp = Secp # type: ignore
    class Threshold(_UniffiTempMiniscriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "MiniscriptError.Threshold({})".format(str(self))
    _UniffiTempMiniscriptError.Threshold = Threshold # type: ignore
    class TrNoScriptCode(_UniffiTempMiniscriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "MiniscriptError.TrNoScriptCode({})".format(str(self))
    _UniffiTempMiniscriptError.TrNoScriptCode = TrNoScriptCode # type: ignore
    class Trailing(_UniffiTempMiniscriptError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "MiniscriptError.Trailing({})".format(str(self))
    _UniffiTempMiniscriptError.Trailing = Trailing # type: ignore
    class TypeCheck(_UniffiTempMiniscriptError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "MiniscriptError.TypeCheck({})".format(str(self))
    _UniffiTempMiniscriptError.TypeCheck = TypeCheck # type: ignore
    class Unexpected(_UniffiTempMiniscriptError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "MiniscriptError.Unexpected({})".format(str(self))
    _UniffiTempMiniscriptError.Unexpected = Unexpected # type: ignore
    class UnexpectedStart(_UniffiTempMiniscriptError):
        def __init__(self):
            pass

        def __repr__(self):
            return "MiniscriptError.UnexpectedStart({})".format(str(self))
    _UniffiTempMiniscriptError.UnexpectedStart = UnexpectedStart # type: ignore
    class UnknownWrapper(_UniffiTempMiniscriptError):
        def __init__(self, char):
            super().__init__(", ".join([
                "char={!r}".format(char),
            ]))
            self.char = char

        def __repr__(self):
            return "MiniscriptError.UnknownWrapper({})".format(str(self))
    _UniffiTempMiniscriptError.UnknownWrapper = UnknownWrapper # type: ignore
    class Unprintable(_UniffiTempMiniscriptError):
        def __init__(self, byte):
            super().__init__(", ".join([
                "byte={!r}".format(byte),
            ]))
            self.byte = byte

        def __repr__(self):
            return "MiniscriptError.Unprintable({})".format(str(self))
    _UniffiTempMiniscriptError.Unprintable = Unprintable # type: ignore

MiniscriptError = _UniffiTempMiniscriptError # type: ignore
del _UniffiTempMiniscriptError


class _UniffiConverterTypeMiniscriptError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return MiniscriptError.AbsoluteLockTime(
            )
        if variant == 2:
            return MiniscriptError.AddrError(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return MiniscriptError.AddrP2shError(
                _UniffiConverterString.read(buf),
            )
        if variant == 4:
            return MiniscriptError.AnalysisError(
                _UniffiConverterString.read(buf),
            )
        if variant == 5:
            return MiniscriptError.AtOutsideOr(
            )
        if variant == 6:
            return MiniscriptError.BadDescriptor(
                _UniffiConverterString.read(buf),
            )
        if variant == 7:
            return MiniscriptError.BareDescriptorAddr(
            )
        if variant == 8:
            return MiniscriptError.CmsTooManyKeys(
                _UniffiConverterUInt32.read(buf),
            )
        if variant == 9:
            return MiniscriptError.ContextError(
                _UniffiConverterString.read(buf),
            )
        if variant == 10:
            return MiniscriptError.CouldNotSatisfy(
            )
        if variant == 11:
            return MiniscriptError.ExpectedChar(
                _UniffiConverterString.read(buf),
            )
        if variant == 12:
            return MiniscriptError.ImpossibleSatisfaction(
            )
        if variant == 13:
            return MiniscriptError.InvalidOpcode(
            )
        if variant == 14:
            return MiniscriptError.InvalidPush(
            )
        if variant == 15:
            return MiniscriptError.LiftError(
                _UniffiConverterString.read(buf),
            )
        if variant == 16:
            return MiniscriptError.MaxRecursiveDepthExceeded(
            )
        if variant == 17:
            return MiniscriptError.MissingSig(
            )
        if variant == 18:
            return MiniscriptError.MultiATooManyKeys(
                _UniffiConverterUInt64.read(buf),
            )
        if variant == 19:
            return MiniscriptError.MultiColon(
            )
        if variant == 20:
            return MiniscriptError.MultipathDescLenMismatch(
            )
        if variant == 21:
            return MiniscriptError.NonMinimalVerify(
                _UniffiConverterString.read(buf),
            )
        if variant == 22:
            return MiniscriptError.NonStandardBareScript(
            )
        if variant == 23:
            return MiniscriptError.NonTopLevel(
                _UniffiConverterString.read(buf),
            )
        if variant == 24:
            return MiniscriptError.ParseThreshold(
            )
        if variant == 25:
            return MiniscriptError.PolicyError(
                _UniffiConverterString.read(buf),
            )
        if variant == 26:
            return MiniscriptError.PubKeyCtxError(
            )
        if variant == 27:
            return MiniscriptError.RelativeLockTime(
            )
        if variant == 28:
            return MiniscriptError.Script(
                _UniffiConverterString.read(buf),
            )
        if variant == 29:
            return MiniscriptError.Secp(
                _UniffiConverterString.read(buf),
            )
        if variant == 30:
            return MiniscriptError.Threshold(
            )
        if variant == 31:
            return MiniscriptError.TrNoScriptCode(
            )
        if variant == 32:
            return MiniscriptError.Trailing(
                _UniffiConverterString.read(buf),
            )
        if variant == 33:
            return MiniscriptError.TypeCheck(
                _UniffiConverterString.read(buf),
            )
        if variant == 34:
            return MiniscriptError.Unexpected(
                _UniffiConverterString.read(buf),
            )
        if variant == 35:
            return MiniscriptError.UnexpectedStart(
            )
        if variant == 36:
            return MiniscriptError.UnknownWrapper(
                _UniffiConverterString.read(buf),
            )
        if variant == 37:
            return MiniscriptError.Unprintable(
                _UniffiConverterUInt8.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, MiniscriptError.AbsoluteLockTime):
            return
        if isinstance(value, MiniscriptError.AddrError):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, MiniscriptError.AddrP2shError):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, MiniscriptError.AnalysisError):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, MiniscriptError.AtOutsideOr):
            return
        if isinstance(value, MiniscriptError.BadDescriptor):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, MiniscriptError.BareDescriptorAddr):
            return
        if isinstance(value, MiniscriptError.CmsTooManyKeys):
            _UniffiConverterUInt32.check_lower(value.keys)
            return
        if isinstance(value, MiniscriptError.ContextError):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, MiniscriptError.CouldNotSatisfy):
            return
        if isinstance(value, MiniscriptError.ExpectedChar):
            _UniffiConverterString.check_lower(value.char)
            return
        if isinstance(value, MiniscriptError.ImpossibleSatisfaction):
            return
        if isinstance(value, MiniscriptError.InvalidOpcode):
            return
        if isinstance(value, MiniscriptError.InvalidPush):
            return
        if isinstance(value, MiniscriptError.LiftError):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, MiniscriptError.MaxRecursiveDepthExceeded):
            return
        if isinstance(value, MiniscriptError.MissingSig):
            return
        if isinstance(value, MiniscriptError.MultiATooManyKeys):
            _UniffiConverterUInt64.check_lower(value.keys)
            return
        if isinstance(value, MiniscriptError.MultiColon):
            return
        if isinstance(value, MiniscriptError.MultipathDescLenMismatch):
            return
        if isinstance(value, MiniscriptError.NonMinimalVerify):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, MiniscriptError.NonStandardBareScript):
            return
        if isinstance(value, MiniscriptError.NonTopLevel):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, MiniscriptError.ParseThreshold):
            return
        if isinstance(value, MiniscriptError.PolicyError):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, MiniscriptError.PubKeyCtxError):
            return
        if isinstance(value, MiniscriptError.RelativeLockTime):
            return
        if isinstance(value, MiniscriptError.Script):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, MiniscriptError.Secp):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, MiniscriptError.Threshold):
            return
        if isinstance(value, MiniscriptError.TrNoScriptCode):
            return
        if isinstance(value, MiniscriptError.Trailing):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, MiniscriptError.TypeCheck):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, MiniscriptError.Unexpected):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, MiniscriptError.UnexpectedStart):
            return
        if isinstance(value, MiniscriptError.UnknownWrapper):
            _UniffiConverterString.check_lower(value.char)
            return
        if isinstance(value, MiniscriptError.Unprintable):
            _UniffiConverterUInt8.check_lower(value.byte)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, MiniscriptError.AbsoluteLockTime):
            buf.write_i32(1)
        if isinstance(value, MiniscriptError.AddrError):
            buf.write_i32(2)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, MiniscriptError.AddrP2shError):
            buf.write_i32(3)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, MiniscriptError.AnalysisError):
            buf.write_i32(4)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, MiniscriptError.AtOutsideOr):
            buf.write_i32(5)
        if isinstance(value, MiniscriptError.BadDescriptor):
            buf.write_i32(6)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, MiniscriptError.BareDescriptorAddr):
            buf.write_i32(7)
        if isinstance(value, MiniscriptError.CmsTooManyKeys):
            buf.write_i32(8)
            _UniffiConverterUInt32.write(value.keys, buf)
        if isinstance(value, MiniscriptError.ContextError):
            buf.write_i32(9)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, MiniscriptError.CouldNotSatisfy):
            buf.write_i32(10)
        if isinstance(value, MiniscriptError.ExpectedChar):
            buf.write_i32(11)
            _UniffiConverterString.write(value.char, buf)
        if isinstance(value, MiniscriptError.ImpossibleSatisfaction):
            buf.write_i32(12)
        if isinstance(value, MiniscriptError.InvalidOpcode):
            buf.write_i32(13)
        if isinstance(value, MiniscriptError.InvalidPush):
            buf.write_i32(14)
        if isinstance(value, MiniscriptError.LiftError):
            buf.write_i32(15)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, MiniscriptError.MaxRecursiveDepthExceeded):
            buf.write_i32(16)
        if isinstance(value, MiniscriptError.MissingSig):
            buf.write_i32(17)
        if isinstance(value, MiniscriptError.MultiATooManyKeys):
            buf.write_i32(18)
            _UniffiConverterUInt64.write(value.keys, buf)
        if isinstance(value, MiniscriptError.MultiColon):
            buf.write_i32(19)
        if isinstance(value, MiniscriptError.MultipathDescLenMismatch):
            buf.write_i32(20)
        if isinstance(value, MiniscriptError.NonMinimalVerify):
            buf.write_i32(21)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, MiniscriptError.NonStandardBareScript):
            buf.write_i32(22)
        if isinstance(value, MiniscriptError.NonTopLevel):
            buf.write_i32(23)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, MiniscriptError.ParseThreshold):
            buf.write_i32(24)
        if isinstance(value, MiniscriptError.PolicyError):
            buf.write_i32(25)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, MiniscriptError.PubKeyCtxError):
            buf.write_i32(26)
        if isinstance(value, MiniscriptError.RelativeLockTime):
            buf.write_i32(27)
        if isinstance(value, MiniscriptError.Script):
            buf.write_i32(28)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, MiniscriptError.Secp):
            buf.write_i32(29)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, MiniscriptError.Threshold):
            buf.write_i32(30)
        if isinstance(value, MiniscriptError.TrNoScriptCode):
            buf.write_i32(31)
        if isinstance(value, MiniscriptError.Trailing):
            buf.write_i32(32)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, MiniscriptError.TypeCheck):
            buf.write_i32(33)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, MiniscriptError.Unexpected):
            buf.write_i32(34)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, MiniscriptError.UnexpectedStart):
            buf.write_i32(35)
        if isinstance(value, MiniscriptError.UnknownWrapper):
            buf.write_i32(36)
            _UniffiConverterString.write(value.char, buf)
        if isinstance(value, MiniscriptError.Unprintable):
            buf.write_i32(37)
            _UniffiConverterUInt8.write(value.byte, buf)





class Network(enum.Enum):
    BITCOIN = 0
    
    TESTNET = 1
    
    SIGNET = 2
    
    REGTEST = 3
    
    TESTNET4 = 4
    


class _UniffiConverterTypeNetwork(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return Network.BITCOIN
        if variant == 2:
            return Network.TESTNET
        if variant == 3:
            return Network.SIGNET
        if variant == 4:
            return Network.REGTEST
        if variant == 5:
            return Network.TESTNET4
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == Network.BITCOIN:
            return
        if value == Network.TESTNET:
            return
        if value == Network.SIGNET:
            return
        if value == Network.REGTEST:
            return
        if value == Network.TESTNET4:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == Network.BITCOIN:
            buf.write_i32(1)
        if value == Network.TESTNET:
            buf.write_i32(2)
        if value == Network.SIGNET:
            buf.write_i32(3)
        if value == Network.REGTEST:
            buf.write_i32(4)
        if value == Network.TESTNET4:
            buf.write_i32(5)







class NodeState(enum.Enum):
    """
    The state of the node with respect to connected peers.
    """

    BEHIND = 0
    """
    We are behind on block headers according to our peers.
    """

    
    HEADERS_SYNCED = 1
    """
    We may start downloading compact block filter headers.
    """

    
    FILTER_HEADERS_SYNCED = 2
    """
    We may start scanning compact block filters.
    """

    
    FILTERS_SYNCED = 3
    """
    We may start asking for blocks with matches.
    """

    
    TRANSACTIONS_SYNCED = 4
    """
    We found all known transactions to the wallet.
    """

    


class _UniffiConverterTypeNodeState(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return NodeState.BEHIND
        if variant == 2:
            return NodeState.HEADERS_SYNCED
        if variant == 3:
            return NodeState.FILTER_HEADERS_SYNCED
        if variant == 4:
            return NodeState.FILTERS_SYNCED
        if variant == 5:
            return NodeState.TRANSACTIONS_SYNCED
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == NodeState.BEHIND:
            return
        if value == NodeState.HEADERS_SYNCED:
            return
        if value == NodeState.FILTER_HEADERS_SYNCED:
            return
        if value == NodeState.FILTERS_SYNCED:
            return
        if value == NodeState.TRANSACTIONS_SYNCED:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == NodeState.BEHIND:
            buf.write_i32(1)
        if value == NodeState.HEADERS_SYNCED:
            buf.write_i32(2)
        if value == NodeState.FILTER_HEADERS_SYNCED:
            buf.write_i32(3)
        if value == NodeState.FILTERS_SYNCED:
            buf.write_i32(4)
        if value == NodeState.TRANSACTIONS_SYNCED:
            buf.write_i32(5)




# ParseAmountError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class ParseAmountError(Exception):
    pass

_UniffiTempParseAmountError = ParseAmountError

class ParseAmountError:  # type: ignore
    class OutOfRange(_UniffiTempParseAmountError):
        def __init__(self):
            pass

        def __repr__(self):
            return "ParseAmountError.OutOfRange({})".format(str(self))
    _UniffiTempParseAmountError.OutOfRange = OutOfRange # type: ignore
    class TooPrecise(_UniffiTempParseAmountError):
        def __init__(self):
            pass

        def __repr__(self):
            return "ParseAmountError.TooPrecise({})".format(str(self))
    _UniffiTempParseAmountError.TooPrecise = TooPrecise # type: ignore
    class MissingDigits(_UniffiTempParseAmountError):
        def __init__(self):
            pass

        def __repr__(self):
            return "ParseAmountError.MissingDigits({})".format(str(self))
    _UniffiTempParseAmountError.MissingDigits = MissingDigits # type: ignore
    class InputTooLarge(_UniffiTempParseAmountError):
        def __init__(self):
            pass

        def __repr__(self):
            return "ParseAmountError.InputTooLarge({})".format(str(self))
    _UniffiTempParseAmountError.InputTooLarge = InputTooLarge # type: ignore
    class InvalidCharacter(_UniffiTempParseAmountError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "ParseAmountError.InvalidCharacter({})".format(str(self))
    _UniffiTempParseAmountError.InvalidCharacter = InvalidCharacter # type: ignore
    class OtherParseAmountErr(_UniffiTempParseAmountError):
        def __init__(self):
            pass

        def __repr__(self):
            return "ParseAmountError.OtherParseAmountErr({})".format(str(self))
    _UniffiTempParseAmountError.OtherParseAmountErr = OtherParseAmountErr # type: ignore

ParseAmountError = _UniffiTempParseAmountError # type: ignore
del _UniffiTempParseAmountError


class _UniffiConverterTypeParseAmountError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return ParseAmountError.OutOfRange(
            )
        if variant == 2:
            return ParseAmountError.TooPrecise(
            )
        if variant == 3:
            return ParseAmountError.MissingDigits(
            )
        if variant == 4:
            return ParseAmountError.InputTooLarge(
            )
        if variant == 5:
            return ParseAmountError.InvalidCharacter(
                _UniffiConverterString.read(buf),
            )
        if variant == 6:
            return ParseAmountError.OtherParseAmountErr(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, ParseAmountError.OutOfRange):
            return
        if isinstance(value, ParseAmountError.TooPrecise):
            return
        if isinstance(value, ParseAmountError.MissingDigits):
            return
        if isinstance(value, ParseAmountError.InputTooLarge):
            return
        if isinstance(value, ParseAmountError.InvalidCharacter):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, ParseAmountError.OtherParseAmountErr):
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, ParseAmountError.OutOfRange):
            buf.write_i32(1)
        if isinstance(value, ParseAmountError.TooPrecise):
            buf.write_i32(2)
        if isinstance(value, ParseAmountError.MissingDigits):
            buf.write_i32(3)
        if isinstance(value, ParseAmountError.InputTooLarge):
            buf.write_i32(4)
        if isinstance(value, ParseAmountError.InvalidCharacter):
            buf.write_i32(5)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, ParseAmountError.OtherParseAmountErr):
            buf.write_i32(6)


# PersistenceError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class PersistenceError(Exception):
    pass

_UniffiTempPersistenceError = PersistenceError

class PersistenceError:  # type: ignore
    class Reason(_UniffiTempPersistenceError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "PersistenceError.Reason({})".format(str(self))
    _UniffiTempPersistenceError.Reason = Reason # type: ignore

PersistenceError = _UniffiTempPersistenceError # type: ignore
del _UniffiTempPersistenceError


class _UniffiConverterTypePersistenceError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return PersistenceError.Reason(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, PersistenceError.Reason):
            _UniffiConverterString.check_lower(value.error_message)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, PersistenceError.Reason):
            buf.write_i32(1)
            _UniffiConverterString.write(value.error_message, buf)





class PkOrF:
    def __init__(self):
        raise RuntimeError("PkOrF cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class PUBKEY:
        value: "str"

        def __init__(self,value: "str"):
            self.value = value

        def __str__(self):
            return "PkOrF.PUBKEY(value={})".format(self.value)

        def __eq__(self, other):
            if not other.is_PUBKEY():
                return False
            if self.value != other.value:
                return False
            return True
    
    class X_ONLY_PUBKEY:
        value: "str"

        def __init__(self,value: "str"):
            self.value = value

        def __str__(self):
            return "PkOrF.X_ONLY_PUBKEY(value={})".format(self.value)

        def __eq__(self, other):
            if not other.is_X_ONLY_PUBKEY():
                return False
            if self.value != other.value:
                return False
            return True
    
    class FINGERPRINT:
        value: "str"

        def __init__(self,value: "str"):
            self.value = value

        def __str__(self):
            return "PkOrF.FINGERPRINT(value={})".format(self.value)

        def __eq__(self, other):
            if not other.is_FINGERPRINT():
                return False
            if self.value != other.value:
                return False
            return True
    
    

    # For each variant, we have `is_NAME` and `is_name` methods for easily checking
    # whether an instance is that variant.
    def is_PUBKEY(self) -> bool:
        return isinstance(self, PkOrF.PUBKEY)
    def is_pubkey(self) -> bool:
        return isinstance(self, PkOrF.PUBKEY)
    def is_X_ONLY_PUBKEY(self) -> bool:
        return isinstance(self, PkOrF.X_ONLY_PUBKEY)
    def is_x_only_pubkey(self) -> bool:
        return isinstance(self, PkOrF.X_ONLY_PUBKEY)
    def is_FINGERPRINT(self) -> bool:
        return isinstance(self, PkOrF.FINGERPRINT)
    def is_fingerprint(self) -> bool:
        return isinstance(self, PkOrF.FINGERPRINT)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
PkOrF.PUBKEY = type("PkOrF.PUBKEY", (PkOrF.PUBKEY, PkOrF,), {})  # type: ignore
PkOrF.X_ONLY_PUBKEY = type("PkOrF.X_ONLY_PUBKEY", (PkOrF.X_ONLY_PUBKEY, PkOrF,), {})  # type: ignore
PkOrF.FINGERPRINT = type("PkOrF.FINGERPRINT", (PkOrF.FINGERPRINT, PkOrF,), {})  # type: ignore




class _UniffiConverterTypePkOrF(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return PkOrF.PUBKEY(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return PkOrF.X_ONLY_PUBKEY(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return PkOrF.FINGERPRINT(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_PUBKEY():
            _UniffiConverterString.check_lower(value.value)
            return
        if value.is_X_ONLY_PUBKEY():
            _UniffiConverterString.check_lower(value.value)
            return
        if value.is_FINGERPRINT():
            _UniffiConverterString.check_lower(value.value)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_PUBKEY():
            buf.write_i32(1)
            _UniffiConverterString.write(value.value, buf)
        if value.is_X_ONLY_PUBKEY():
            buf.write_i32(2)
            _UniffiConverterString.write(value.value, buf)
        if value.is_FINGERPRINT():
            buf.write_i32(3)
            _UniffiConverterString.write(value.value, buf)




# PsbtError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class PsbtError(Exception):
    pass

_UniffiTempPsbtError = PsbtError

class PsbtError:  # type: ignore
    class InvalidMagic(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.InvalidMagic({})".format(str(self))
    _UniffiTempPsbtError.InvalidMagic = InvalidMagic # type: ignore
    class MissingUtxo(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.MissingUtxo({})".format(str(self))
    _UniffiTempPsbtError.MissingUtxo = MissingUtxo # type: ignore
    class InvalidSeparator(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.InvalidSeparator({})".format(str(self))
    _UniffiTempPsbtError.InvalidSeparator = InvalidSeparator # type: ignore
    class PsbtUtxoOutOfBounds(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.PsbtUtxoOutOfBounds({})".format(str(self))
    _UniffiTempPsbtError.PsbtUtxoOutOfBounds = PsbtUtxoOutOfBounds # type: ignore
    class InvalidKey(_UniffiTempPsbtError):
        def __init__(self, key):
            super().__init__(", ".join([
                "key={!r}".format(key),
            ]))
            self.key = key

        def __repr__(self):
            return "PsbtError.InvalidKey({})".format(str(self))
    _UniffiTempPsbtError.InvalidKey = InvalidKey # type: ignore
    class InvalidProprietaryKey(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.InvalidProprietaryKey({})".format(str(self))
    _UniffiTempPsbtError.InvalidProprietaryKey = InvalidProprietaryKey # type: ignore
    class DuplicateKey(_UniffiTempPsbtError):
        def __init__(self, key):
            super().__init__(", ".join([
                "key={!r}".format(key),
            ]))
            self.key = key

        def __repr__(self):
            return "PsbtError.DuplicateKey({})".format(str(self))
    _UniffiTempPsbtError.DuplicateKey = DuplicateKey # type: ignore
    class UnsignedTxHasScriptSigs(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.UnsignedTxHasScriptSigs({})".format(str(self))
    _UniffiTempPsbtError.UnsignedTxHasScriptSigs = UnsignedTxHasScriptSigs # type: ignore
    class UnsignedTxHasScriptWitnesses(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.UnsignedTxHasScriptWitnesses({})".format(str(self))
    _UniffiTempPsbtError.UnsignedTxHasScriptWitnesses = UnsignedTxHasScriptWitnesses # type: ignore
    class MustHaveUnsignedTx(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.MustHaveUnsignedTx({})".format(str(self))
    _UniffiTempPsbtError.MustHaveUnsignedTx = MustHaveUnsignedTx # type: ignore
    class NoMorePairs(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.NoMorePairs({})".format(str(self))
    _UniffiTempPsbtError.NoMorePairs = NoMorePairs # type: ignore
    class UnexpectedUnsignedTx(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.UnexpectedUnsignedTx({})".format(str(self))
    _UniffiTempPsbtError.UnexpectedUnsignedTx = UnexpectedUnsignedTx # type: ignore
    class NonStandardSighashType(_UniffiTempPsbtError):
        def __init__(self, sighash):
            super().__init__(", ".join([
                "sighash={!r}".format(sighash),
            ]))
            self.sighash = sighash

        def __repr__(self):
            return "PsbtError.NonStandardSighashType({})".format(str(self))
    _UniffiTempPsbtError.NonStandardSighashType = NonStandardSighashType # type: ignore
    class InvalidHash(_UniffiTempPsbtError):
        def __init__(self, hash):
            super().__init__(", ".join([
                "hash={!r}".format(hash),
            ]))
            self.hash = hash

        def __repr__(self):
            return "PsbtError.InvalidHash({})".format(str(self))
    _UniffiTempPsbtError.InvalidHash = InvalidHash # type: ignore
    class InvalidPreimageHashPair(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.InvalidPreimageHashPair({})".format(str(self))
    _UniffiTempPsbtError.InvalidPreimageHashPair = InvalidPreimageHashPair # type: ignore
    class CombineInconsistentKeySources(_UniffiTempPsbtError):
        def __init__(self, xpub):
            super().__init__(", ".join([
                "xpub={!r}".format(xpub),
            ]))
            self.xpub = xpub

        def __repr__(self):
            return "PsbtError.CombineInconsistentKeySources({})".format(str(self))
    _UniffiTempPsbtError.CombineInconsistentKeySources = CombineInconsistentKeySources # type: ignore
    class ConsensusEncoding(_UniffiTempPsbtError):
        def __init__(self, encoding_error):
            super().__init__(", ".join([
                "encoding_error={!r}".format(encoding_error),
            ]))
            self.encoding_error = encoding_error

        def __repr__(self):
            return "PsbtError.ConsensusEncoding({})".format(str(self))
    _UniffiTempPsbtError.ConsensusEncoding = ConsensusEncoding # type: ignore
    class NegativeFee(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.NegativeFee({})".format(str(self))
    _UniffiTempPsbtError.NegativeFee = NegativeFee # type: ignore
    class FeeOverflow(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.FeeOverflow({})".format(str(self))
    _UniffiTempPsbtError.FeeOverflow = FeeOverflow # type: ignore
    class InvalidPublicKey(_UniffiTempPsbtError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "PsbtError.InvalidPublicKey({})".format(str(self))
    _UniffiTempPsbtError.InvalidPublicKey = InvalidPublicKey # type: ignore
    class InvalidSecp256k1PublicKey(_UniffiTempPsbtError):
        def __init__(self, secp256k1_error):
            super().__init__(", ".join([
                "secp256k1_error={!r}".format(secp256k1_error),
            ]))
            self.secp256k1_error = secp256k1_error

        def __repr__(self):
            return "PsbtError.InvalidSecp256k1PublicKey({})".format(str(self))
    _UniffiTempPsbtError.InvalidSecp256k1PublicKey = InvalidSecp256k1PublicKey # type: ignore
    class InvalidXOnlyPublicKey(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.InvalidXOnlyPublicKey({})".format(str(self))
    _UniffiTempPsbtError.InvalidXOnlyPublicKey = InvalidXOnlyPublicKey # type: ignore
    class InvalidEcdsaSignature(_UniffiTempPsbtError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "PsbtError.InvalidEcdsaSignature({})".format(str(self))
    _UniffiTempPsbtError.InvalidEcdsaSignature = InvalidEcdsaSignature # type: ignore
    class InvalidTaprootSignature(_UniffiTempPsbtError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "PsbtError.InvalidTaprootSignature({})".format(str(self))
    _UniffiTempPsbtError.InvalidTaprootSignature = InvalidTaprootSignature # type: ignore
    class InvalidControlBlock(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.InvalidControlBlock({})".format(str(self))
    _UniffiTempPsbtError.InvalidControlBlock = InvalidControlBlock # type: ignore
    class InvalidLeafVersion(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.InvalidLeafVersion({})".format(str(self))
    _UniffiTempPsbtError.InvalidLeafVersion = InvalidLeafVersion # type: ignore
    class Taproot(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.Taproot({})".format(str(self))
    _UniffiTempPsbtError.Taproot = Taproot # type: ignore
    class TapTree(_UniffiTempPsbtError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "PsbtError.TapTree({})".format(str(self))
    _UniffiTempPsbtError.TapTree = TapTree # type: ignore
    class XPubKey(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.XPubKey({})".format(str(self))
    _UniffiTempPsbtError.XPubKey = XPubKey # type: ignore
    class Version(_UniffiTempPsbtError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "PsbtError.Version({})".format(str(self))
    _UniffiTempPsbtError.Version = Version # type: ignore
    class PartialDataConsumption(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.PartialDataConsumption({})".format(str(self))
    _UniffiTempPsbtError.PartialDataConsumption = PartialDataConsumption # type: ignore
    class Io(_UniffiTempPsbtError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "PsbtError.Io({})".format(str(self))
    _UniffiTempPsbtError.Io = Io # type: ignore
    class OtherPsbtErr(_UniffiTempPsbtError):
        def __init__(self):
            pass

        def __repr__(self):
            return "PsbtError.OtherPsbtErr({})".format(str(self))
    _UniffiTempPsbtError.OtherPsbtErr = OtherPsbtErr # type: ignore

PsbtError = _UniffiTempPsbtError # type: ignore
del _UniffiTempPsbtError


class _UniffiConverterTypePsbtError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return PsbtError.InvalidMagic(
            )
        if variant == 2:
            return PsbtError.MissingUtxo(
            )
        if variant == 3:
            return PsbtError.InvalidSeparator(
            )
        if variant == 4:
            return PsbtError.PsbtUtxoOutOfBounds(
            )
        if variant == 5:
            return PsbtError.InvalidKey(
                _UniffiConverterString.read(buf),
            )
        if variant == 6:
            return PsbtError.InvalidProprietaryKey(
            )
        if variant == 7:
            return PsbtError.DuplicateKey(
                _UniffiConverterString.read(buf),
            )
        if variant == 8:
            return PsbtError.UnsignedTxHasScriptSigs(
            )
        if variant == 9:
            return PsbtError.UnsignedTxHasScriptWitnesses(
            )
        if variant == 10:
            return PsbtError.MustHaveUnsignedTx(
            )
        if variant == 11:
            return PsbtError.NoMorePairs(
            )
        if variant == 12:
            return PsbtError.UnexpectedUnsignedTx(
            )
        if variant == 13:
            return PsbtError.NonStandardSighashType(
                _UniffiConverterUInt32.read(buf),
            )
        if variant == 14:
            return PsbtError.InvalidHash(
                _UniffiConverterString.read(buf),
            )
        if variant == 15:
            return PsbtError.InvalidPreimageHashPair(
            )
        if variant == 16:
            return PsbtError.CombineInconsistentKeySources(
                _UniffiConverterString.read(buf),
            )
        if variant == 17:
            return PsbtError.ConsensusEncoding(
                _UniffiConverterString.read(buf),
            )
        if variant == 18:
            return PsbtError.NegativeFee(
            )
        if variant == 19:
            return PsbtError.FeeOverflow(
            )
        if variant == 20:
            return PsbtError.InvalidPublicKey(
                _UniffiConverterString.read(buf),
            )
        if variant == 21:
            return PsbtError.InvalidSecp256k1PublicKey(
                _UniffiConverterString.read(buf),
            )
        if variant == 22:
            return PsbtError.InvalidXOnlyPublicKey(
            )
        if variant == 23:
            return PsbtError.InvalidEcdsaSignature(
                _UniffiConverterString.read(buf),
            )
        if variant == 24:
            return PsbtError.InvalidTaprootSignature(
                _UniffiConverterString.read(buf),
            )
        if variant == 25:
            return PsbtError.InvalidControlBlock(
            )
        if variant == 26:
            return PsbtError.InvalidLeafVersion(
            )
        if variant == 27:
            return PsbtError.Taproot(
            )
        if variant == 28:
            return PsbtError.TapTree(
                _UniffiConverterString.read(buf),
            )
        if variant == 29:
            return PsbtError.XPubKey(
            )
        if variant == 30:
            return PsbtError.Version(
                _UniffiConverterString.read(buf),
            )
        if variant == 31:
            return PsbtError.PartialDataConsumption(
            )
        if variant == 32:
            return PsbtError.Io(
                _UniffiConverterString.read(buf),
            )
        if variant == 33:
            return PsbtError.OtherPsbtErr(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, PsbtError.InvalidMagic):
            return
        if isinstance(value, PsbtError.MissingUtxo):
            return
        if isinstance(value, PsbtError.InvalidSeparator):
            return
        if isinstance(value, PsbtError.PsbtUtxoOutOfBounds):
            return
        if isinstance(value, PsbtError.InvalidKey):
            _UniffiConverterString.check_lower(value.key)
            return
        if isinstance(value, PsbtError.InvalidProprietaryKey):
            return
        if isinstance(value, PsbtError.DuplicateKey):
            _UniffiConverterString.check_lower(value.key)
            return
        if isinstance(value, PsbtError.UnsignedTxHasScriptSigs):
            return
        if isinstance(value, PsbtError.UnsignedTxHasScriptWitnesses):
            return
        if isinstance(value, PsbtError.MustHaveUnsignedTx):
            return
        if isinstance(value, PsbtError.NoMorePairs):
            return
        if isinstance(value, PsbtError.UnexpectedUnsignedTx):
            return
        if isinstance(value, PsbtError.NonStandardSighashType):
            _UniffiConverterUInt32.check_lower(value.sighash)
            return
        if isinstance(value, PsbtError.InvalidHash):
            _UniffiConverterString.check_lower(value.hash)
            return
        if isinstance(value, PsbtError.InvalidPreimageHashPair):
            return
        if isinstance(value, PsbtError.CombineInconsistentKeySources):
            _UniffiConverterString.check_lower(value.xpub)
            return
        if isinstance(value, PsbtError.ConsensusEncoding):
            _UniffiConverterString.check_lower(value.encoding_error)
            return
        if isinstance(value, PsbtError.NegativeFee):
            return
        if isinstance(value, PsbtError.FeeOverflow):
            return
        if isinstance(value, PsbtError.InvalidPublicKey):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, PsbtError.InvalidSecp256k1PublicKey):
            _UniffiConverterString.check_lower(value.secp256k1_error)
            return
        if isinstance(value, PsbtError.InvalidXOnlyPublicKey):
            return
        if isinstance(value, PsbtError.InvalidEcdsaSignature):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, PsbtError.InvalidTaprootSignature):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, PsbtError.InvalidControlBlock):
            return
        if isinstance(value, PsbtError.InvalidLeafVersion):
            return
        if isinstance(value, PsbtError.Taproot):
            return
        if isinstance(value, PsbtError.TapTree):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, PsbtError.XPubKey):
            return
        if isinstance(value, PsbtError.Version):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, PsbtError.PartialDataConsumption):
            return
        if isinstance(value, PsbtError.Io):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, PsbtError.OtherPsbtErr):
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, PsbtError.InvalidMagic):
            buf.write_i32(1)
        if isinstance(value, PsbtError.MissingUtxo):
            buf.write_i32(2)
        if isinstance(value, PsbtError.InvalidSeparator):
            buf.write_i32(3)
        if isinstance(value, PsbtError.PsbtUtxoOutOfBounds):
            buf.write_i32(4)
        if isinstance(value, PsbtError.InvalidKey):
            buf.write_i32(5)
            _UniffiConverterString.write(value.key, buf)
        if isinstance(value, PsbtError.InvalidProprietaryKey):
            buf.write_i32(6)
        if isinstance(value, PsbtError.DuplicateKey):
            buf.write_i32(7)
            _UniffiConverterString.write(value.key, buf)
        if isinstance(value, PsbtError.UnsignedTxHasScriptSigs):
            buf.write_i32(8)
        if isinstance(value, PsbtError.UnsignedTxHasScriptWitnesses):
            buf.write_i32(9)
        if isinstance(value, PsbtError.MustHaveUnsignedTx):
            buf.write_i32(10)
        if isinstance(value, PsbtError.NoMorePairs):
            buf.write_i32(11)
        if isinstance(value, PsbtError.UnexpectedUnsignedTx):
            buf.write_i32(12)
        if isinstance(value, PsbtError.NonStandardSighashType):
            buf.write_i32(13)
            _UniffiConverterUInt32.write(value.sighash, buf)
        if isinstance(value, PsbtError.InvalidHash):
            buf.write_i32(14)
            _UniffiConverterString.write(value.hash, buf)
        if isinstance(value, PsbtError.InvalidPreimageHashPair):
            buf.write_i32(15)
        if isinstance(value, PsbtError.CombineInconsistentKeySources):
            buf.write_i32(16)
            _UniffiConverterString.write(value.xpub, buf)
        if isinstance(value, PsbtError.ConsensusEncoding):
            buf.write_i32(17)
            _UniffiConverterString.write(value.encoding_error, buf)
        if isinstance(value, PsbtError.NegativeFee):
            buf.write_i32(18)
        if isinstance(value, PsbtError.FeeOverflow):
            buf.write_i32(19)
        if isinstance(value, PsbtError.InvalidPublicKey):
            buf.write_i32(20)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, PsbtError.InvalidSecp256k1PublicKey):
            buf.write_i32(21)
            _UniffiConverterString.write(value.secp256k1_error, buf)
        if isinstance(value, PsbtError.InvalidXOnlyPublicKey):
            buf.write_i32(22)
        if isinstance(value, PsbtError.InvalidEcdsaSignature):
            buf.write_i32(23)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, PsbtError.InvalidTaprootSignature):
            buf.write_i32(24)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, PsbtError.InvalidControlBlock):
            buf.write_i32(25)
        if isinstance(value, PsbtError.InvalidLeafVersion):
            buf.write_i32(26)
        if isinstance(value, PsbtError.Taproot):
            buf.write_i32(27)
        if isinstance(value, PsbtError.TapTree):
            buf.write_i32(28)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, PsbtError.XPubKey):
            buf.write_i32(29)
        if isinstance(value, PsbtError.Version):
            buf.write_i32(30)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, PsbtError.PartialDataConsumption):
            buf.write_i32(31)
        if isinstance(value, PsbtError.Io):
            buf.write_i32(32)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, PsbtError.OtherPsbtErr):
            buf.write_i32(33)


# PsbtFinalizeError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class PsbtFinalizeError(Exception):
    pass

_UniffiTempPsbtFinalizeError = PsbtFinalizeError

class PsbtFinalizeError:  # type: ignore
    class InputError(_UniffiTempPsbtFinalizeError):
        def __init__(self, reason, index):
            super().__init__(", ".join([
                "reason={!r}".format(reason),
                "index={!r}".format(index),
            ]))
            self.reason = reason
            self.index = index

        def __repr__(self):
            return "PsbtFinalizeError.InputError({})".format(str(self))
    _UniffiTempPsbtFinalizeError.InputError = InputError # type: ignore
    class WrongInputCount(_UniffiTempPsbtFinalizeError):
        def __init__(self, in_tx, in_map):
            super().__init__(", ".join([
                "in_tx={!r}".format(in_tx),
                "in_map={!r}".format(in_map),
            ]))
            self.in_tx = in_tx
            self.in_map = in_map

        def __repr__(self):
            return "PsbtFinalizeError.WrongInputCount({})".format(str(self))
    _UniffiTempPsbtFinalizeError.WrongInputCount = WrongInputCount # type: ignore
    class InputIdxOutofBounds(_UniffiTempPsbtFinalizeError):
        def __init__(self, psbt_inp, requested):
            super().__init__(", ".join([
                "psbt_inp={!r}".format(psbt_inp),
                "requested={!r}".format(requested),
            ]))
            self.psbt_inp = psbt_inp
            self.requested = requested

        def __repr__(self):
            return "PsbtFinalizeError.InputIdxOutofBounds({})".format(str(self))
    _UniffiTempPsbtFinalizeError.InputIdxOutofBounds = InputIdxOutofBounds # type: ignore

PsbtFinalizeError = _UniffiTempPsbtFinalizeError # type: ignore
del _UniffiTempPsbtFinalizeError


class _UniffiConverterTypePsbtFinalizeError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return PsbtFinalizeError.InputError(
                _UniffiConverterString.read(buf),
                _UniffiConverterUInt32.read(buf),
            )
        if variant == 2:
            return PsbtFinalizeError.WrongInputCount(
                _UniffiConverterUInt32.read(buf),
                _UniffiConverterUInt32.read(buf),
            )
        if variant == 3:
            return PsbtFinalizeError.InputIdxOutofBounds(
                _UniffiConverterUInt32.read(buf),
                _UniffiConverterUInt32.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, PsbtFinalizeError.InputError):
            _UniffiConverterString.check_lower(value.reason)
            _UniffiConverterUInt32.check_lower(value.index)
            return
        if isinstance(value, PsbtFinalizeError.WrongInputCount):
            _UniffiConverterUInt32.check_lower(value.in_tx)
            _UniffiConverterUInt32.check_lower(value.in_map)
            return
        if isinstance(value, PsbtFinalizeError.InputIdxOutofBounds):
            _UniffiConverterUInt32.check_lower(value.psbt_inp)
            _UniffiConverterUInt32.check_lower(value.requested)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, PsbtFinalizeError.InputError):
            buf.write_i32(1)
            _UniffiConverterString.write(value.reason, buf)
            _UniffiConverterUInt32.write(value.index, buf)
        if isinstance(value, PsbtFinalizeError.WrongInputCount):
            buf.write_i32(2)
            _UniffiConverterUInt32.write(value.in_tx, buf)
            _UniffiConverterUInt32.write(value.in_map, buf)
        if isinstance(value, PsbtFinalizeError.InputIdxOutofBounds):
            buf.write_i32(3)
            _UniffiConverterUInt32.write(value.psbt_inp, buf)
            _UniffiConverterUInt32.write(value.requested, buf)


# PsbtParseError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class PsbtParseError(Exception):
    pass

_UniffiTempPsbtParseError = PsbtParseError

class PsbtParseError:  # type: ignore
    class PsbtEncoding(_UniffiTempPsbtParseError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "PsbtParseError.PsbtEncoding({})".format(str(self))
    _UniffiTempPsbtParseError.PsbtEncoding = PsbtEncoding # type: ignore
    class Base64Encoding(_UniffiTempPsbtParseError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "PsbtParseError.Base64Encoding({})".format(str(self))
    _UniffiTempPsbtParseError.Base64Encoding = Base64Encoding # type: ignore

PsbtParseError = _UniffiTempPsbtParseError # type: ignore
del _UniffiTempPsbtParseError


class _UniffiConverterTypePsbtParseError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return PsbtParseError.PsbtEncoding(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return PsbtParseError.Base64Encoding(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, PsbtParseError.PsbtEncoding):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, PsbtParseError.Base64Encoding):
            _UniffiConverterString.check_lower(value.error_message)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, PsbtParseError.PsbtEncoding):
            buf.write_i32(1)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, PsbtParseError.Base64Encoding):
            buf.write_i32(2)
            _UniffiConverterString.write(value.error_message, buf)


# RequestBuilderError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class RequestBuilderError(Exception):
    pass

_UniffiTempRequestBuilderError = RequestBuilderError

class RequestBuilderError:  # type: ignore
    class RequestAlreadyConsumed(_UniffiTempRequestBuilderError):
        def __init__(self):
            pass

        def __repr__(self):
            return "RequestBuilderError.RequestAlreadyConsumed({})".format(str(self))
    _UniffiTempRequestBuilderError.RequestAlreadyConsumed = RequestAlreadyConsumed # type: ignore

RequestBuilderError = _UniffiTempRequestBuilderError # type: ignore
del _UniffiTempRequestBuilderError


class _UniffiConverterTypeRequestBuilderError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return RequestBuilderError.RequestAlreadyConsumed(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, RequestBuilderError.RequestAlreadyConsumed):
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, RequestBuilderError.RequestAlreadyConsumed):
            buf.write_i32(1)





class Satisfaction:
    def __init__(self):
        raise RuntimeError("Satisfaction cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class PARTIAL:
        n: "int"
        m: "int"
        items: "typing.List[int]"
        sorted: "typing.Optional[bool]"
        conditions: "dict[int, typing.List[Condition]]"

        def __init__(self,n: "int", m: "int", items: "typing.List[int]", sorted: "typing.Optional[bool]", conditions: "dict[int, typing.List[Condition]]"):
            self.n = n
            self.m = m
            self.items = items
            self.sorted = sorted
            self.conditions = conditions

        def __str__(self):
            return "Satisfaction.PARTIAL(n={}, m={}, items={}, sorted={}, conditions={})".format(self.n, self.m, self.items, self.sorted, self.conditions)

        def __eq__(self, other):
            if not other.is_PARTIAL():
                return False
            if self.n != other.n:
                return False
            if self.m != other.m:
                return False
            if self.items != other.items:
                return False
            if self.sorted != other.sorted:
                return False
            if self.conditions != other.conditions:
                return False
            return True
    
    class PARTIAL_COMPLETE:
        n: "int"
        m: "int"
        items: "typing.List[int]"
        sorted: "typing.Optional[bool]"
        conditions: "dict[typing.List[int], typing.List[Condition]]"

        def __init__(self,n: "int", m: "int", items: "typing.List[int]", sorted: "typing.Optional[bool]", conditions: "dict[typing.List[int], typing.List[Condition]]"):
            self.n = n
            self.m = m
            self.items = items
            self.sorted = sorted
            self.conditions = conditions

        def __str__(self):
            return "Satisfaction.PARTIAL_COMPLETE(n={}, m={}, items={}, sorted={}, conditions={})".format(self.n, self.m, self.items, self.sorted, self.conditions)

        def __eq__(self, other):
            if not other.is_PARTIAL_COMPLETE():
                return False
            if self.n != other.n:
                return False
            if self.m != other.m:
                return False
            if self.items != other.items:
                return False
            if self.sorted != other.sorted:
                return False
            if self.conditions != other.conditions:
                return False
            return True
    
    class COMPLETE:
        condition: "Condition"

        def __init__(self,condition: "Condition"):
            self.condition = condition

        def __str__(self):
            return "Satisfaction.COMPLETE(condition={})".format(self.condition)

        def __eq__(self, other):
            if not other.is_COMPLETE():
                return False
            if self.condition != other.condition:
                return False
            return True
    
    class NONE:
        msg: "str"

        def __init__(self,msg: "str"):
            self.msg = msg

        def __str__(self):
            return "Satisfaction.NONE(msg={})".format(self.msg)

        def __eq__(self, other):
            if not other.is_NONE():
                return False
            if self.msg != other.msg:
                return False
            return True
    
    

    # For each variant, we have `is_NAME` and `is_name` methods for easily checking
    # whether an instance is that variant.
    def is_PARTIAL(self) -> bool:
        return isinstance(self, Satisfaction.PARTIAL)
    def is_partial(self) -> bool:
        return isinstance(self, Satisfaction.PARTIAL)
    def is_PARTIAL_COMPLETE(self) -> bool:
        return isinstance(self, Satisfaction.PARTIAL_COMPLETE)
    def is_partial_complete(self) -> bool:
        return isinstance(self, Satisfaction.PARTIAL_COMPLETE)
    def is_COMPLETE(self) -> bool:
        return isinstance(self, Satisfaction.COMPLETE)
    def is_complete(self) -> bool:
        return isinstance(self, Satisfaction.COMPLETE)
    def is_NONE(self) -> bool:
        return isinstance(self, Satisfaction.NONE)
    def is_none(self) -> bool:
        return isinstance(self, Satisfaction.NONE)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
Satisfaction.PARTIAL = type("Satisfaction.PARTIAL", (Satisfaction.PARTIAL, Satisfaction,), {})  # type: ignore
Satisfaction.PARTIAL_COMPLETE = type("Satisfaction.PARTIAL_COMPLETE", (Satisfaction.PARTIAL_COMPLETE, Satisfaction,), {})  # type: ignore
Satisfaction.COMPLETE = type("Satisfaction.COMPLETE", (Satisfaction.COMPLETE, Satisfaction,), {})  # type: ignore
Satisfaction.NONE = type("Satisfaction.NONE", (Satisfaction.NONE, Satisfaction,), {})  # type: ignore




class _UniffiConverterTypeSatisfaction(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return Satisfaction.PARTIAL(
                _UniffiConverterUInt64.read(buf),
                _UniffiConverterUInt64.read(buf),
                _UniffiConverterSequenceUInt64.read(buf),
                _UniffiConverterOptionalBool.read(buf),
                _UniffiConverterMapUInt32SequenceTypeCondition.read(buf),
            )
        if variant == 2:
            return Satisfaction.PARTIAL_COMPLETE(
                _UniffiConverterUInt64.read(buf),
                _UniffiConverterUInt64.read(buf),
                _UniffiConverterSequenceUInt64.read(buf),
                _UniffiConverterOptionalBool.read(buf),
                _UniffiConverterMapSequenceUInt32SequenceTypeCondition.read(buf),
            )
        if variant == 3:
            return Satisfaction.COMPLETE(
                _UniffiConverterTypeCondition.read(buf),
            )
        if variant == 4:
            return Satisfaction.NONE(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_PARTIAL():
            _UniffiConverterUInt64.check_lower(value.n)
            _UniffiConverterUInt64.check_lower(value.m)
            _UniffiConverterSequenceUInt64.check_lower(value.items)
            _UniffiConverterOptionalBool.check_lower(value.sorted)
            _UniffiConverterMapUInt32SequenceTypeCondition.check_lower(value.conditions)
            return
        if value.is_PARTIAL_COMPLETE():
            _UniffiConverterUInt64.check_lower(value.n)
            _UniffiConverterUInt64.check_lower(value.m)
            _UniffiConverterSequenceUInt64.check_lower(value.items)
            _UniffiConverterOptionalBool.check_lower(value.sorted)
            _UniffiConverterMapSequenceUInt32SequenceTypeCondition.check_lower(value.conditions)
            return
        if value.is_COMPLETE():
            _UniffiConverterTypeCondition.check_lower(value.condition)
            return
        if value.is_NONE():
            _UniffiConverterString.check_lower(value.msg)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_PARTIAL():
            buf.write_i32(1)
            _UniffiConverterUInt64.write(value.n, buf)
            _UniffiConverterUInt64.write(value.m, buf)
            _UniffiConverterSequenceUInt64.write(value.items, buf)
            _UniffiConverterOptionalBool.write(value.sorted, buf)
            _UniffiConverterMapUInt32SequenceTypeCondition.write(value.conditions, buf)
        if value.is_PARTIAL_COMPLETE():
            buf.write_i32(2)
            _UniffiConverterUInt64.write(value.n, buf)
            _UniffiConverterUInt64.write(value.m, buf)
            _UniffiConverterSequenceUInt64.write(value.items, buf)
            _UniffiConverterOptionalBool.write(value.sorted, buf)
            _UniffiConverterMapSequenceUInt32SequenceTypeCondition.write(value.conditions, buf)
        if value.is_COMPLETE():
            buf.write_i32(3)
            _UniffiConverterTypeCondition.write(value.condition, buf)
        if value.is_NONE():
            buf.write_i32(4)
            _UniffiConverterString.write(value.msg, buf)







class SatisfiableItem:
    def __init__(self):
        raise RuntimeError("SatisfiableItem cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class ECDSA_SIGNATURE:
        key: "PkOrF"

        def __init__(self,key: "PkOrF"):
            self.key = key

        def __str__(self):
            return "SatisfiableItem.ECDSA_SIGNATURE(key={})".format(self.key)

        def __eq__(self, other):
            if not other.is_ECDSA_SIGNATURE():
                return False
            if self.key != other.key:
                return False
            return True
    
    class SCHNORR_SIGNATURE:
        key: "PkOrF"

        def __init__(self,key: "PkOrF"):
            self.key = key

        def __str__(self):
            return "SatisfiableItem.SCHNORR_SIGNATURE(key={})".format(self.key)

        def __eq__(self, other):
            if not other.is_SCHNORR_SIGNATURE():
                return False
            if self.key != other.key:
                return False
            return True
    
    class SHA256_PREIMAGE:
        hash: "str"

        def __init__(self,hash: "str"):
            self.hash = hash

        def __str__(self):
            return "SatisfiableItem.SHA256_PREIMAGE(hash={})".format(self.hash)

        def __eq__(self, other):
            if not other.is_SHA256_PREIMAGE():
                return False
            if self.hash != other.hash:
                return False
            return True
    
    class HASH256_PREIMAGE:
        hash: "str"

        def __init__(self,hash: "str"):
            self.hash = hash

        def __str__(self):
            return "SatisfiableItem.HASH256_PREIMAGE(hash={})".format(self.hash)

        def __eq__(self, other):
            if not other.is_HASH256_PREIMAGE():
                return False
            if self.hash != other.hash:
                return False
            return True
    
    class RIPEMD160_PREIMAGE:
        hash: "str"

        def __init__(self,hash: "str"):
            self.hash = hash

        def __str__(self):
            return "SatisfiableItem.RIPEMD160_PREIMAGE(hash={})".format(self.hash)

        def __eq__(self, other):
            if not other.is_RIPEMD160_PREIMAGE():
                return False
            if self.hash != other.hash:
                return False
            return True
    
    class HASH160_PREIMAGE:
        hash: "str"

        def __init__(self,hash: "str"):
            self.hash = hash

        def __str__(self):
            return "SatisfiableItem.HASH160_PREIMAGE(hash={})".format(self.hash)

        def __eq__(self, other):
            if not other.is_HASH160_PREIMAGE():
                return False
            if self.hash != other.hash:
                return False
            return True
    
    class ABSOLUTE_TIMELOCK:
        value: "LockTime"

        def __init__(self,value: "LockTime"):
            self.value = value

        def __str__(self):
            return "SatisfiableItem.ABSOLUTE_TIMELOCK(value={})".format(self.value)

        def __eq__(self, other):
            if not other.is_ABSOLUTE_TIMELOCK():
                return False
            if self.value != other.value:
                return False
            return True
    
    class RELATIVE_TIMELOCK:
        value: "int"

        def __init__(self,value: "int"):
            self.value = value

        def __str__(self):
            return "SatisfiableItem.RELATIVE_TIMELOCK(value={})".format(self.value)

        def __eq__(self, other):
            if not other.is_RELATIVE_TIMELOCK():
                return False
            if self.value != other.value:
                return False
            return True
    
    class MULTISIG:
        keys: "typing.List[PkOrF]"
        threshold: "int"

        def __init__(self,keys: "typing.List[PkOrF]", threshold: "int"):
            self.keys = keys
            self.threshold = threshold

        def __str__(self):
            return "SatisfiableItem.MULTISIG(keys={}, threshold={})".format(self.keys, self.threshold)

        def __eq__(self, other):
            if not other.is_MULTISIG():
                return False
            if self.keys != other.keys:
                return False
            if self.threshold != other.threshold:
                return False
            return True
    
    class THRESH:
        items: "typing.List[Policy]"
        threshold: "int"

        def __init__(self,items: "typing.List[Policy]", threshold: "int"):
            self.items = items
            self.threshold = threshold

        def __str__(self):
            return "SatisfiableItem.THRESH(items={}, threshold={})".format(self.items, self.threshold)

        def __eq__(self, other):
            if not other.is_THRESH():
                return False
            if self.items != other.items:
                return False
            if self.threshold != other.threshold:
                return False
            return True
    
    

    # For each variant, we have `is_NAME` and `is_name` methods for easily checking
    # whether an instance is that variant.
    def is_ECDSA_SIGNATURE(self) -> bool:
        return isinstance(self, SatisfiableItem.ECDSA_SIGNATURE)
    def is_ecdsa_signature(self) -> bool:
        return isinstance(self, SatisfiableItem.ECDSA_SIGNATURE)
    def is_SCHNORR_SIGNATURE(self) -> bool:
        return isinstance(self, SatisfiableItem.SCHNORR_SIGNATURE)
    def is_schnorr_signature(self) -> bool:
        return isinstance(self, SatisfiableItem.SCHNORR_SIGNATURE)
    def is_SHA256_PREIMAGE(self) -> bool:
        return isinstance(self, SatisfiableItem.SHA256_PREIMAGE)
    def is_sha256_preimage(self) -> bool:
        return isinstance(self, SatisfiableItem.SHA256_PREIMAGE)
    def is_HASH256_PREIMAGE(self) -> bool:
        return isinstance(self, SatisfiableItem.HASH256_PREIMAGE)
    def is_hash256_preimage(self) -> bool:
        return isinstance(self, SatisfiableItem.HASH256_PREIMAGE)
    def is_RIPEMD160_PREIMAGE(self) -> bool:
        return isinstance(self, SatisfiableItem.RIPEMD160_PREIMAGE)
    def is_ripemd160_preimage(self) -> bool:
        return isinstance(self, SatisfiableItem.RIPEMD160_PREIMAGE)
    def is_HASH160_PREIMAGE(self) -> bool:
        return isinstance(self, SatisfiableItem.HASH160_PREIMAGE)
    def is_hash160_preimage(self) -> bool:
        return isinstance(self, SatisfiableItem.HASH160_PREIMAGE)
    def is_ABSOLUTE_TIMELOCK(self) -> bool:
        return isinstance(self, SatisfiableItem.ABSOLUTE_TIMELOCK)
    def is_absolute_timelock(self) -> bool:
        return isinstance(self, SatisfiableItem.ABSOLUTE_TIMELOCK)
    def is_RELATIVE_TIMELOCK(self) -> bool:
        return isinstance(self, SatisfiableItem.RELATIVE_TIMELOCK)
    def is_relative_timelock(self) -> bool:
        return isinstance(self, SatisfiableItem.RELATIVE_TIMELOCK)
    def is_MULTISIG(self) -> bool:
        return isinstance(self, SatisfiableItem.MULTISIG)
    def is_multisig(self) -> bool:
        return isinstance(self, SatisfiableItem.MULTISIG)
    def is_THRESH(self) -> bool:
        return isinstance(self, SatisfiableItem.THRESH)
    def is_thresh(self) -> bool:
        return isinstance(self, SatisfiableItem.THRESH)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
SatisfiableItem.ECDSA_SIGNATURE = type("SatisfiableItem.ECDSA_SIGNATURE", (SatisfiableItem.ECDSA_SIGNATURE, SatisfiableItem,), {})  # type: ignore
SatisfiableItem.SCHNORR_SIGNATURE = type("SatisfiableItem.SCHNORR_SIGNATURE", (SatisfiableItem.SCHNORR_SIGNATURE, SatisfiableItem,), {})  # type: ignore
SatisfiableItem.SHA256_PREIMAGE = type("SatisfiableItem.SHA256_PREIMAGE", (SatisfiableItem.SHA256_PREIMAGE, SatisfiableItem,), {})  # type: ignore
SatisfiableItem.HASH256_PREIMAGE = type("SatisfiableItem.HASH256_PREIMAGE", (SatisfiableItem.HASH256_PREIMAGE, SatisfiableItem,), {})  # type: ignore
SatisfiableItem.RIPEMD160_PREIMAGE = type("SatisfiableItem.RIPEMD160_PREIMAGE", (SatisfiableItem.RIPEMD160_PREIMAGE, SatisfiableItem,), {})  # type: ignore
SatisfiableItem.HASH160_PREIMAGE = type("SatisfiableItem.HASH160_PREIMAGE", (SatisfiableItem.HASH160_PREIMAGE, SatisfiableItem,), {})  # type: ignore
SatisfiableItem.ABSOLUTE_TIMELOCK = type("SatisfiableItem.ABSOLUTE_TIMELOCK", (SatisfiableItem.ABSOLUTE_TIMELOCK, SatisfiableItem,), {})  # type: ignore
SatisfiableItem.RELATIVE_TIMELOCK = type("SatisfiableItem.RELATIVE_TIMELOCK", (SatisfiableItem.RELATIVE_TIMELOCK, SatisfiableItem,), {})  # type: ignore
SatisfiableItem.MULTISIG = type("SatisfiableItem.MULTISIG", (SatisfiableItem.MULTISIG, SatisfiableItem,), {})  # type: ignore
SatisfiableItem.THRESH = type("SatisfiableItem.THRESH", (SatisfiableItem.THRESH, SatisfiableItem,), {})  # type: ignore




class _UniffiConverterTypeSatisfiableItem(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return SatisfiableItem.ECDSA_SIGNATURE(
                _UniffiConverterTypePkOrF.read(buf),
            )
        if variant == 2:
            return SatisfiableItem.SCHNORR_SIGNATURE(
                _UniffiConverterTypePkOrF.read(buf),
            )
        if variant == 3:
            return SatisfiableItem.SHA256_PREIMAGE(
                _UniffiConverterString.read(buf),
            )
        if variant == 4:
            return SatisfiableItem.HASH256_PREIMAGE(
                _UniffiConverterString.read(buf),
            )
        if variant == 5:
            return SatisfiableItem.RIPEMD160_PREIMAGE(
                _UniffiConverterString.read(buf),
            )
        if variant == 6:
            return SatisfiableItem.HASH160_PREIMAGE(
                _UniffiConverterString.read(buf),
            )
        if variant == 7:
            return SatisfiableItem.ABSOLUTE_TIMELOCK(
                _UniffiConverterTypeLockTime.read(buf),
            )
        if variant == 8:
            return SatisfiableItem.RELATIVE_TIMELOCK(
                _UniffiConverterUInt32.read(buf),
            )
        if variant == 9:
            return SatisfiableItem.MULTISIG(
                _UniffiConverterSequenceTypePkOrF.read(buf),
                _UniffiConverterUInt64.read(buf),
            )
        if variant == 10:
            return SatisfiableItem.THRESH(
                _UniffiConverterSequenceTypePolicy.read(buf),
                _UniffiConverterUInt64.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_ECDSA_SIGNATURE():
            _UniffiConverterTypePkOrF.check_lower(value.key)
            return
        if value.is_SCHNORR_SIGNATURE():
            _UniffiConverterTypePkOrF.check_lower(value.key)
            return
        if value.is_SHA256_PREIMAGE():
            _UniffiConverterString.check_lower(value.hash)
            return
        if value.is_HASH256_PREIMAGE():
            _UniffiConverterString.check_lower(value.hash)
            return
        if value.is_RIPEMD160_PREIMAGE():
            _UniffiConverterString.check_lower(value.hash)
            return
        if value.is_HASH160_PREIMAGE():
            _UniffiConverterString.check_lower(value.hash)
            return
        if value.is_ABSOLUTE_TIMELOCK():
            _UniffiConverterTypeLockTime.check_lower(value.value)
            return
        if value.is_RELATIVE_TIMELOCK():
            _UniffiConverterUInt32.check_lower(value.value)
            return
        if value.is_MULTISIG():
            _UniffiConverterSequenceTypePkOrF.check_lower(value.keys)
            _UniffiConverterUInt64.check_lower(value.threshold)
            return
        if value.is_THRESH():
            _UniffiConverterSequenceTypePolicy.check_lower(value.items)
            _UniffiConverterUInt64.check_lower(value.threshold)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_ECDSA_SIGNATURE():
            buf.write_i32(1)
            _UniffiConverterTypePkOrF.write(value.key, buf)
        if value.is_SCHNORR_SIGNATURE():
            buf.write_i32(2)
            _UniffiConverterTypePkOrF.write(value.key, buf)
        if value.is_SHA256_PREIMAGE():
            buf.write_i32(3)
            _UniffiConverterString.write(value.hash, buf)
        if value.is_HASH256_PREIMAGE():
            buf.write_i32(4)
            _UniffiConverterString.write(value.hash, buf)
        if value.is_RIPEMD160_PREIMAGE():
            buf.write_i32(5)
            _UniffiConverterString.write(value.hash, buf)
        if value.is_HASH160_PREIMAGE():
            buf.write_i32(6)
            _UniffiConverterString.write(value.hash, buf)
        if value.is_ABSOLUTE_TIMELOCK():
            buf.write_i32(7)
            _UniffiConverterTypeLockTime.write(value.value, buf)
        if value.is_RELATIVE_TIMELOCK():
            buf.write_i32(8)
            _UniffiConverterUInt32.write(value.value, buf)
        if value.is_MULTISIG():
            buf.write_i32(9)
            _UniffiConverterSequenceTypePkOrF.write(value.keys, buf)
            _UniffiConverterUInt64.write(value.threshold, buf)
        if value.is_THRESH():
            buf.write_i32(10)
            _UniffiConverterSequenceTypePolicy.write(value.items, buf)
            _UniffiConverterUInt64.write(value.threshold, buf)







class ScanType:
    """
    Sync a wallet from the last known block hash, recover a wallet from a specified height,
    or perform an expedited block header download for a new wallet.
    """

    def __init__(self):
        raise RuntimeError("ScanType cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class NEW:
        """
        Perform an expedited header and filter download for a new wallet.
        If this option is not set, and the wallet has no history, the
        entire chain will be scanned for script inclusions.
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "ScanType.NEW()".format()

        def __eq__(self, other):
            if not other.is_NEW():
                return False
            return True
    
    class SYNC:
        """
        Sync an existing wallet from the last stored chain checkpoint.
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "ScanType.SYNC()".format()

        def __eq__(self, other):
            if not other.is_SYNC():
                return False
            return True
    
    class RECOVERY:
        """
        Recover an existing wallet by scanning from the specified height.
        """

        from_height: "int"

        def __init__(self,from_height: "int"):
            self.from_height = from_height

        def __str__(self):
            return "ScanType.RECOVERY(from_height={})".format(self.from_height)

        def __eq__(self, other):
            if not other.is_RECOVERY():
                return False
            if self.from_height != other.from_height:
                return False
            return True
    
    

    # For each variant, we have `is_NAME` and `is_name` methods for easily checking
    # whether an instance is that variant.
    def is_NEW(self) -> bool:
        return isinstance(self, ScanType.NEW)
    def is_new(self) -> bool:
        return isinstance(self, ScanType.NEW)
    def is_SYNC(self) -> bool:
        return isinstance(self, ScanType.SYNC)
    def is_sync(self) -> bool:
        return isinstance(self, ScanType.SYNC)
    def is_RECOVERY(self) -> bool:
        return isinstance(self, ScanType.RECOVERY)
    def is_recovery(self) -> bool:
        return isinstance(self, ScanType.RECOVERY)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
ScanType.NEW = type("ScanType.NEW", (ScanType.NEW, ScanType,), {})  # type: ignore
ScanType.SYNC = type("ScanType.SYNC", (ScanType.SYNC, ScanType,), {})  # type: ignore
ScanType.RECOVERY = type("ScanType.RECOVERY", (ScanType.RECOVERY, ScanType,), {})  # type: ignore




class _UniffiConverterTypeScanType(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return ScanType.NEW(
            )
        if variant == 2:
            return ScanType.SYNC(
            )
        if variant == 3:
            return ScanType.RECOVERY(
                _UniffiConverterUInt32.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_NEW():
            return
        if value.is_SYNC():
            return
        if value.is_RECOVERY():
            _UniffiConverterUInt32.check_lower(value.from_height)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_NEW():
            buf.write_i32(1)
        if value.is_SYNC():
            buf.write_i32(2)
        if value.is_RECOVERY():
            buf.write_i32(3)
            _UniffiConverterUInt32.write(value.from_height, buf)




# SignerError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class SignerError(Exception):
    pass

_UniffiTempSignerError = SignerError

class SignerError:  # type: ignore
    class MissingKey(_UniffiTempSignerError):
        def __init__(self):
            pass

        def __repr__(self):
            return "SignerError.MissingKey({})".format(str(self))
    _UniffiTempSignerError.MissingKey = MissingKey # type: ignore
    class InvalidKey(_UniffiTempSignerError):
        def __init__(self):
            pass

        def __repr__(self):
            return "SignerError.InvalidKey({})".format(str(self))
    _UniffiTempSignerError.InvalidKey = InvalidKey # type: ignore
    class UserCanceled(_UniffiTempSignerError):
        def __init__(self):
            pass

        def __repr__(self):
            return "SignerError.UserCanceled({})".format(str(self))
    _UniffiTempSignerError.UserCanceled = UserCanceled # type: ignore
    class InputIndexOutOfRange(_UniffiTempSignerError):
        def __init__(self):
            pass

        def __repr__(self):
            return "SignerError.InputIndexOutOfRange({})".format(str(self))
    _UniffiTempSignerError.InputIndexOutOfRange = InputIndexOutOfRange # type: ignore
    class MissingNonWitnessUtxo(_UniffiTempSignerError):
        def __init__(self):
            pass

        def __repr__(self):
            return "SignerError.MissingNonWitnessUtxo({})".format(str(self))
    _UniffiTempSignerError.MissingNonWitnessUtxo = MissingNonWitnessUtxo # type: ignore
    class InvalidNonWitnessUtxo(_UniffiTempSignerError):
        def __init__(self):
            pass

        def __repr__(self):
            return "SignerError.InvalidNonWitnessUtxo({})".format(str(self))
    _UniffiTempSignerError.InvalidNonWitnessUtxo = InvalidNonWitnessUtxo # type: ignore
    class MissingWitnessUtxo(_UniffiTempSignerError):
        def __init__(self):
            pass

        def __repr__(self):
            return "SignerError.MissingWitnessUtxo({})".format(str(self))
    _UniffiTempSignerError.MissingWitnessUtxo = MissingWitnessUtxo # type: ignore
    class MissingWitnessScript(_UniffiTempSignerError):
        def __init__(self):
            pass

        def __repr__(self):
            return "SignerError.MissingWitnessScript({})".format(str(self))
    _UniffiTempSignerError.MissingWitnessScript = MissingWitnessScript # type: ignore
    class MissingHdKeypath(_UniffiTempSignerError):
        def __init__(self):
            pass

        def __repr__(self):
            return "SignerError.MissingHdKeypath({})".format(str(self))
    _UniffiTempSignerError.MissingHdKeypath = MissingHdKeypath # type: ignore
    class NonStandardSighash(_UniffiTempSignerError):
        def __init__(self):
            pass

        def __repr__(self):
            return "SignerError.NonStandardSighash({})".format(str(self))
    _UniffiTempSignerError.NonStandardSighash = NonStandardSighash # type: ignore
    class InvalidSighash(_UniffiTempSignerError):
        def __init__(self):
            pass

        def __repr__(self):
            return "SignerError.InvalidSighash({})".format(str(self))
    _UniffiTempSignerError.InvalidSighash = InvalidSighash # type: ignore
    class SighashP2wpkh(_UniffiTempSignerError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "SignerError.SighashP2wpkh({})".format(str(self))
    _UniffiTempSignerError.SighashP2wpkh = SighashP2wpkh # type: ignore
    class SighashTaproot(_UniffiTempSignerError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "SignerError.SighashTaproot({})".format(str(self))
    _UniffiTempSignerError.SighashTaproot = SighashTaproot # type: ignore
    class TxInputsIndexError(_UniffiTempSignerError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "SignerError.TxInputsIndexError({})".format(str(self))
    _UniffiTempSignerError.TxInputsIndexError = TxInputsIndexError # type: ignore
    class MiniscriptPsbt(_UniffiTempSignerError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "SignerError.MiniscriptPsbt({})".format(str(self))
    _UniffiTempSignerError.MiniscriptPsbt = MiniscriptPsbt # type: ignore
    class External(_UniffiTempSignerError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "SignerError.External({})".format(str(self))
    _UniffiTempSignerError.External = External # type: ignore
    class Psbt(_UniffiTempSignerError):
        def __init__(self, error_message):
            super().__init__(", ".join([
                "error_message={!r}".format(error_message),
            ]))
            self.error_message = error_message

        def __repr__(self):
            return "SignerError.Psbt({})".format(str(self))
    _UniffiTempSignerError.Psbt = Psbt # type: ignore

SignerError = _UniffiTempSignerError # type: ignore
del _UniffiTempSignerError


class _UniffiConverterTypeSignerError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return SignerError.MissingKey(
            )
        if variant == 2:
            return SignerError.InvalidKey(
            )
        if variant == 3:
            return SignerError.UserCanceled(
            )
        if variant == 4:
            return SignerError.InputIndexOutOfRange(
            )
        if variant == 5:
            return SignerError.MissingNonWitnessUtxo(
            )
        if variant == 6:
            return SignerError.InvalidNonWitnessUtxo(
            )
        if variant == 7:
            return SignerError.MissingWitnessUtxo(
            )
        if variant == 8:
            return SignerError.MissingWitnessScript(
            )
        if variant == 9:
            return SignerError.MissingHdKeypath(
            )
        if variant == 10:
            return SignerError.NonStandardSighash(
            )
        if variant == 11:
            return SignerError.InvalidSighash(
            )
        if variant == 12:
            return SignerError.SighashP2wpkh(
                _UniffiConverterString.read(buf),
            )
        if variant == 13:
            return SignerError.SighashTaproot(
                _UniffiConverterString.read(buf),
            )
        if variant == 14:
            return SignerError.TxInputsIndexError(
                _UniffiConverterString.read(buf),
            )
        if variant == 15:
            return SignerError.MiniscriptPsbt(
                _UniffiConverterString.read(buf),
            )
        if variant == 16:
            return SignerError.External(
                _UniffiConverterString.read(buf),
            )
        if variant == 17:
            return SignerError.Psbt(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, SignerError.MissingKey):
            return
        if isinstance(value, SignerError.InvalidKey):
            return
        if isinstance(value, SignerError.UserCanceled):
            return
        if isinstance(value, SignerError.InputIndexOutOfRange):
            return
        if isinstance(value, SignerError.MissingNonWitnessUtxo):
            return
        if isinstance(value, SignerError.InvalidNonWitnessUtxo):
            return
        if isinstance(value, SignerError.MissingWitnessUtxo):
            return
        if isinstance(value, SignerError.MissingWitnessScript):
            return
        if isinstance(value, SignerError.MissingHdKeypath):
            return
        if isinstance(value, SignerError.NonStandardSighash):
            return
        if isinstance(value, SignerError.InvalidSighash):
            return
        if isinstance(value, SignerError.SighashP2wpkh):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, SignerError.SighashTaproot):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, SignerError.TxInputsIndexError):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, SignerError.MiniscriptPsbt):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, SignerError.External):
            _UniffiConverterString.check_lower(value.error_message)
            return
        if isinstance(value, SignerError.Psbt):
            _UniffiConverterString.check_lower(value.error_message)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, SignerError.MissingKey):
            buf.write_i32(1)
        if isinstance(value, SignerError.InvalidKey):
            buf.write_i32(2)
        if isinstance(value, SignerError.UserCanceled):
            buf.write_i32(3)
        if isinstance(value, SignerError.InputIndexOutOfRange):
            buf.write_i32(4)
        if isinstance(value, SignerError.MissingNonWitnessUtxo):
            buf.write_i32(5)
        if isinstance(value, SignerError.InvalidNonWitnessUtxo):
            buf.write_i32(6)
        if isinstance(value, SignerError.MissingWitnessUtxo):
            buf.write_i32(7)
        if isinstance(value, SignerError.MissingWitnessScript):
            buf.write_i32(8)
        if isinstance(value, SignerError.MissingHdKeypath):
            buf.write_i32(9)
        if isinstance(value, SignerError.NonStandardSighash):
            buf.write_i32(10)
        if isinstance(value, SignerError.InvalidSighash):
            buf.write_i32(11)
        if isinstance(value, SignerError.SighashP2wpkh):
            buf.write_i32(12)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, SignerError.SighashTaproot):
            buf.write_i32(13)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, SignerError.TxInputsIndexError):
            buf.write_i32(14)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, SignerError.MiniscriptPsbt):
            buf.write_i32(15)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, SignerError.External):
            buf.write_i32(16)
            _UniffiConverterString.write(value.error_message, buf)
        if isinstance(value, SignerError.Psbt):
            buf.write_i32(17)
            _UniffiConverterString.write(value.error_message, buf)


# TransactionError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class TransactionError(Exception):
    pass

_UniffiTempTransactionError = TransactionError

class TransactionError:  # type: ignore
    class Io(_UniffiTempTransactionError):
        def __init__(self):
            pass

        def __repr__(self):
            return "TransactionError.Io({})".format(str(self))
    _UniffiTempTransactionError.Io = Io # type: ignore
    class OversizedVectorAllocation(_UniffiTempTransactionError):
        def __init__(self):
            pass

        def __repr__(self):
            return "TransactionError.OversizedVectorAllocation({})".format(str(self))
    _UniffiTempTransactionError.OversizedVectorAllocation = OversizedVectorAllocation # type: ignore
    class InvalidChecksum(_UniffiTempTransactionError):
        def __init__(self, expected, actual):
            super().__init__(", ".join([
                "expected={!r}".format(expected),
                "actual={!r}".format(actual),
            ]))
            self.expected = expected
            self.actual = actual

        def __repr__(self):
            return "TransactionError.InvalidChecksum({})".format(str(self))
    _UniffiTempTransactionError.InvalidChecksum = InvalidChecksum # type: ignore
    class NonMinimalVarInt(_UniffiTempTransactionError):
        def __init__(self):
            pass

        def __repr__(self):
            return "TransactionError.NonMinimalVarInt({})".format(str(self))
    _UniffiTempTransactionError.NonMinimalVarInt = NonMinimalVarInt # type: ignore
    class ParseFailed(_UniffiTempTransactionError):
        def __init__(self):
            pass

        def __repr__(self):
            return "TransactionError.ParseFailed({})".format(str(self))
    _UniffiTempTransactionError.ParseFailed = ParseFailed # type: ignore
    class UnsupportedSegwitFlag(_UniffiTempTransactionError):
        def __init__(self, flag):
            super().__init__(", ".join([
                "flag={!r}".format(flag),
            ]))
            self.flag = flag

        def __repr__(self):
            return "TransactionError.UnsupportedSegwitFlag({})".format(str(self))
    _UniffiTempTransactionError.UnsupportedSegwitFlag = UnsupportedSegwitFlag # type: ignore
    class OtherTransactionErr(_UniffiTempTransactionError):
        def __init__(self):
            pass

        def __repr__(self):
            return "TransactionError.OtherTransactionErr({})".format(str(self))
    _UniffiTempTransactionError.OtherTransactionErr = OtherTransactionErr # type: ignore

TransactionError = _UniffiTempTransactionError # type: ignore
del _UniffiTempTransactionError


class _UniffiConverterTypeTransactionError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return TransactionError.Io(
            )
        if variant == 2:
            return TransactionError.OversizedVectorAllocation(
            )
        if variant == 3:
            return TransactionError.InvalidChecksum(
                _UniffiConverterString.read(buf),
                _UniffiConverterString.read(buf),
            )
        if variant == 4:
            return TransactionError.NonMinimalVarInt(
            )
        if variant == 5:
            return TransactionError.ParseFailed(
            )
        if variant == 6:
            return TransactionError.UnsupportedSegwitFlag(
                _UniffiConverterUInt8.read(buf),
            )
        if variant == 7:
            return TransactionError.OtherTransactionErr(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, TransactionError.Io):
            return
        if isinstance(value, TransactionError.OversizedVectorAllocation):
            return
        if isinstance(value, TransactionError.InvalidChecksum):
            _UniffiConverterString.check_lower(value.expected)
            _UniffiConverterString.check_lower(value.actual)
            return
        if isinstance(value, TransactionError.NonMinimalVarInt):
            return
        if isinstance(value, TransactionError.ParseFailed):
            return
        if isinstance(value, TransactionError.UnsupportedSegwitFlag):
            _UniffiConverterUInt8.check_lower(value.flag)
            return
        if isinstance(value, TransactionError.OtherTransactionErr):
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, TransactionError.Io):
            buf.write_i32(1)
        if isinstance(value, TransactionError.OversizedVectorAllocation):
            buf.write_i32(2)
        if isinstance(value, TransactionError.InvalidChecksum):
            buf.write_i32(3)
            _UniffiConverterString.write(value.expected, buf)
            _UniffiConverterString.write(value.actual, buf)
        if isinstance(value, TransactionError.NonMinimalVarInt):
            buf.write_i32(4)
        if isinstance(value, TransactionError.ParseFailed):
            buf.write_i32(5)
        if isinstance(value, TransactionError.UnsupportedSegwitFlag):
            buf.write_i32(6)
            _UniffiConverterUInt8.write(value.flag, buf)
        if isinstance(value, TransactionError.OtherTransactionErr):
            buf.write_i32(7)


# TxidParseError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class TxidParseError(Exception):
    pass

_UniffiTempTxidParseError = TxidParseError

class TxidParseError:  # type: ignore
    class InvalidTxid(_UniffiTempTxidParseError):
        def __init__(self, txid):
            super().__init__(", ".join([
                "txid={!r}".format(txid),
            ]))
            self.txid = txid

        def __repr__(self):
            return "TxidParseError.InvalidTxid({})".format(str(self))
    _UniffiTempTxidParseError.InvalidTxid = InvalidTxid # type: ignore

TxidParseError = _UniffiTempTxidParseError # type: ignore
del _UniffiTempTxidParseError


class _UniffiConverterTypeTxidParseError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return TxidParseError.InvalidTxid(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, TxidParseError.InvalidTxid):
            _UniffiConverterString.check_lower(value.txid)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, TxidParseError.InvalidTxid):
            buf.write_i32(1)
            _UniffiConverterString.write(value.txid, buf)





class Warning:
    """
    Warnings a node may issue while running.
    """

    def __init__(self):
        raise RuntimeError("Warning cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class NEED_CONNECTIONS:
        """
        The node is looking for connections to peers.
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "Warning.NEED_CONNECTIONS()".format()

        def __eq__(self, other):
            if not other.is_NEED_CONNECTIONS():
                return False
            return True
    
    class PEER_TIMED_OUT:
        """
        A connection to a peer timed out.
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "Warning.PEER_TIMED_OUT()".format()

        def __eq__(self, other):
            if not other.is_PEER_TIMED_OUT():
                return False
            return True
    
    class COULD_NOT_CONNECT:
        """
        The node was unable to connect to a peer in the database.
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "Warning.COULD_NOT_CONNECT()".format()

        def __eq__(self, other):
            if not other.is_COULD_NOT_CONNECT():
                return False
            return True
    
    class NO_COMPACT_FILTERS:
        """
        A connection was maintained, but the peer does not signal for compact block filers.
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "Warning.NO_COMPACT_FILTERS()".format()

        def __eq__(self, other):
            if not other.is_NO_COMPACT_FILTERS():
                return False
            return True
    
    class POTENTIAL_STALE_TIP:
        """
        The node has been waiting for new inv and will find new peers to avoid block withholding.
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "Warning.POTENTIAL_STALE_TIP()".format()

        def __eq__(self, other):
            if not other.is_POTENTIAL_STALE_TIP():
                return False
            return True
    
    class UNSOLICITED_MESSAGE:
        """
        A peer sent us a peer-to-peer message the node did not request.
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "Warning.UNSOLICITED_MESSAGE()".format()

        def __eq__(self, other):
            if not other.is_UNSOLICITED_MESSAGE():
                return False
            return True
    
    class INVALID_START_HEIGHT:
        """
        The provided starting height is deeper than the database history.
        This should not occur under normal use.
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "Warning.INVALID_START_HEIGHT()".format()

        def __eq__(self, other):
            if not other.is_INVALID_START_HEIGHT():
                return False
            return True
    
    class CORRUPTED_HEADERS:
        """
        The headers in the database do not link together.
        Recoverable by deleting the database.
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "Warning.CORRUPTED_HEADERS()".format()

        def __eq__(self, other):
            if not other.is_CORRUPTED_HEADERS():
                return False
            return True
    
    class TRANSACTION_REJECTED:
        """
        A transaction got rejected, likely for being an insufficient fee or non-standard transaction.
        """

        wtxid: "str"
        reason: "typing.Optional[str]"

        def __init__(self,wtxid: "str", reason: "typing.Optional[str]"):
            self.wtxid = wtxid
            self.reason = reason

        def __str__(self):
            return "Warning.TRANSACTION_REJECTED(wtxid={}, reason={})".format(self.wtxid, self.reason)

        def __eq__(self, other):
            if not other.is_TRANSACTION_REJECTED():
                return False
            if self.wtxid != other.wtxid:
                return False
            if self.reason != other.reason:
                return False
            return True
    
    class FAILED_PERSISTENCE:
        """
        A database failed to persist some data and may retry again
        """

        warning: "str"

        def __init__(self,warning: "str"):
            self.warning = warning

        def __str__(self):
            return "Warning.FAILED_PERSISTENCE(warning={})".format(self.warning)

        def __eq__(self, other):
            if not other.is_FAILED_PERSISTENCE():
                return False
            if self.warning != other.warning:
                return False
            return True
    
    class EVALUATING_FORK:
        """
        The peer sent us a potential fork.
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "Warning.EVALUATING_FORK()".format()

        def __eq__(self, other):
            if not other.is_EVALUATING_FORK():
                return False
            return True
    
    class EMPTY_PEER_DATABASE:
        """
        The peer database has no values.
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "Warning.EMPTY_PEER_DATABASE()".format()

        def __eq__(self, other):
            if not other.is_EMPTY_PEER_DATABASE():
                return False
            return True
    
    class UNEXPECTED_SYNC_ERROR:
        """
        An unexpected error occurred processing a peer-to-peer message.
        """

        warning: "str"

        def __init__(self,warning: "str"):
            self.warning = warning

        def __str__(self):
            return "Warning.UNEXPECTED_SYNC_ERROR(warning={})".format(self.warning)

        def __eq__(self, other):
            if not other.is_UNEXPECTED_SYNC_ERROR():
                return False
            if self.warning != other.warning:
                return False
            return True
    
    class REQUEST_FAILED:
        """
        The node failed to respond to a message sent from the client.
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "Warning.REQUEST_FAILED()".format()

        def __eq__(self, other):
            if not other.is_REQUEST_FAILED():
                return False
            return True
    
    

    # For each variant, we have `is_NAME` and `is_name` methods for easily checking
    # whether an instance is that variant.
    def is_NEED_CONNECTIONS(self) -> bool:
        return isinstance(self, Warning.NEED_CONNECTIONS)
    def is_need_connections(self) -> bool:
        return isinstance(self, Warning.NEED_CONNECTIONS)
    def is_PEER_TIMED_OUT(self) -> bool:
        return isinstance(self, Warning.PEER_TIMED_OUT)
    def is_peer_timed_out(self) -> bool:
        return isinstance(self, Warning.PEER_TIMED_OUT)
    def is_COULD_NOT_CONNECT(self) -> bool:
        return isinstance(self, Warning.COULD_NOT_CONNECT)
    def is_could_not_connect(self) -> bool:
        return isinstance(self, Warning.COULD_NOT_CONNECT)
    def is_NO_COMPACT_FILTERS(self) -> bool:
        return isinstance(self, Warning.NO_COMPACT_FILTERS)
    def is_no_compact_filters(self) -> bool:
        return isinstance(self, Warning.NO_COMPACT_FILTERS)
    def is_POTENTIAL_STALE_TIP(self) -> bool:
        return isinstance(self, Warning.POTENTIAL_STALE_TIP)
    def is_potential_stale_tip(self) -> bool:
        return isinstance(self, Warning.POTENTIAL_STALE_TIP)
    def is_UNSOLICITED_MESSAGE(self) -> bool:
        return isinstance(self, Warning.UNSOLICITED_MESSAGE)
    def is_unsolicited_message(self) -> bool:
        return isinstance(self, Warning.UNSOLICITED_MESSAGE)
    def is_INVALID_START_HEIGHT(self) -> bool:
        return isinstance(self, Warning.INVALID_START_HEIGHT)
    def is_invalid_start_height(self) -> bool:
        return isinstance(self, Warning.INVALID_START_HEIGHT)
    def is_CORRUPTED_HEADERS(self) -> bool:
        return isinstance(self, Warning.CORRUPTED_HEADERS)
    def is_corrupted_headers(self) -> bool:
        return isinstance(self, Warning.CORRUPTED_HEADERS)
    def is_TRANSACTION_REJECTED(self) -> bool:
        return isinstance(self, Warning.TRANSACTION_REJECTED)
    def is_transaction_rejected(self) -> bool:
        return isinstance(self, Warning.TRANSACTION_REJECTED)
    def is_FAILED_PERSISTENCE(self) -> bool:
        return isinstance(self, Warning.FAILED_PERSISTENCE)
    def is_failed_persistence(self) -> bool:
        return isinstance(self, Warning.FAILED_PERSISTENCE)
    def is_EVALUATING_FORK(self) -> bool:
        return isinstance(self, Warning.EVALUATING_FORK)
    def is_evaluating_fork(self) -> bool:
        return isinstance(self, Warning.EVALUATING_FORK)
    def is_EMPTY_PEER_DATABASE(self) -> bool:
        return isinstance(self, Warning.EMPTY_PEER_DATABASE)
    def is_empty_peer_database(self) -> bool:
        return isinstance(self, Warning.EMPTY_PEER_DATABASE)
    def is_UNEXPECTED_SYNC_ERROR(self) -> bool:
        return isinstance(self, Warning.UNEXPECTED_SYNC_ERROR)
    def is_unexpected_sync_error(self) -> bool:
        return isinstance(self, Warning.UNEXPECTED_SYNC_ERROR)
    def is_REQUEST_FAILED(self) -> bool:
        return isinstance(self, Warning.REQUEST_FAILED)
    def is_request_failed(self) -> bool:
        return isinstance(self, Warning.REQUEST_FAILED)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
Warning.NEED_CONNECTIONS = type("Warning.NEED_CONNECTIONS", (Warning.NEED_CONNECTIONS, Warning,), {})  # type: ignore
Warning.PEER_TIMED_OUT = type("Warning.PEER_TIMED_OUT", (Warning.PEER_TIMED_OUT, Warning,), {})  # type: ignore
Warning.COULD_NOT_CONNECT = type("Warning.COULD_NOT_CONNECT", (Warning.COULD_NOT_CONNECT, Warning,), {})  # type: ignore
Warning.NO_COMPACT_FILTERS = type("Warning.NO_COMPACT_FILTERS", (Warning.NO_COMPACT_FILTERS, Warning,), {})  # type: ignore
Warning.POTENTIAL_STALE_TIP = type("Warning.POTENTIAL_STALE_TIP", (Warning.POTENTIAL_STALE_TIP, Warning,), {})  # type: ignore
Warning.UNSOLICITED_MESSAGE = type("Warning.UNSOLICITED_MESSAGE", (Warning.UNSOLICITED_MESSAGE, Warning,), {})  # type: ignore
Warning.INVALID_START_HEIGHT = type("Warning.INVALID_START_HEIGHT", (Warning.INVALID_START_HEIGHT, Warning,), {})  # type: ignore
Warning.CORRUPTED_HEADERS = type("Warning.CORRUPTED_HEADERS", (Warning.CORRUPTED_HEADERS, Warning,), {})  # type: ignore
Warning.TRANSACTION_REJECTED = type("Warning.TRANSACTION_REJECTED", (Warning.TRANSACTION_REJECTED, Warning,), {})  # type: ignore
Warning.FAILED_PERSISTENCE = type("Warning.FAILED_PERSISTENCE", (Warning.FAILED_PERSISTENCE, Warning,), {})  # type: ignore
Warning.EVALUATING_FORK = type("Warning.EVALUATING_FORK", (Warning.EVALUATING_FORK, Warning,), {})  # type: ignore
Warning.EMPTY_PEER_DATABASE = type("Warning.EMPTY_PEER_DATABASE", (Warning.EMPTY_PEER_DATABASE, Warning,), {})  # type: ignore
Warning.UNEXPECTED_SYNC_ERROR = type("Warning.UNEXPECTED_SYNC_ERROR", (Warning.UNEXPECTED_SYNC_ERROR, Warning,), {})  # type: ignore
Warning.REQUEST_FAILED = type("Warning.REQUEST_FAILED", (Warning.REQUEST_FAILED, Warning,), {})  # type: ignore




class _UniffiConverterTypeWarning(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return Warning.NEED_CONNECTIONS(
            )
        if variant == 2:
            return Warning.PEER_TIMED_OUT(
            )
        if variant == 3:
            return Warning.COULD_NOT_CONNECT(
            )
        if variant == 4:
            return Warning.NO_COMPACT_FILTERS(
            )
        if variant == 5:
            return Warning.POTENTIAL_STALE_TIP(
            )
        if variant == 6:
            return Warning.UNSOLICITED_MESSAGE(
            )
        if variant == 7:
            return Warning.INVALID_START_HEIGHT(
            )
        if variant == 8:
            return Warning.CORRUPTED_HEADERS(
            )
        if variant == 9:
            return Warning.TRANSACTION_REJECTED(
                _UniffiConverterString.read(buf),
                _UniffiConverterOptionalString.read(buf),
            )
        if variant == 10:
            return Warning.FAILED_PERSISTENCE(
                _UniffiConverterString.read(buf),
            )
        if variant == 11:
            return Warning.EVALUATING_FORK(
            )
        if variant == 12:
            return Warning.EMPTY_PEER_DATABASE(
            )
        if variant == 13:
            return Warning.UNEXPECTED_SYNC_ERROR(
                _UniffiConverterString.read(buf),
            )
        if variant == 14:
            return Warning.REQUEST_FAILED(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_NEED_CONNECTIONS():
            return
        if value.is_PEER_TIMED_OUT():
            return
        if value.is_COULD_NOT_CONNECT():
            return
        if value.is_NO_COMPACT_FILTERS():
            return
        if value.is_POTENTIAL_STALE_TIP():
            return
        if value.is_UNSOLICITED_MESSAGE():
            return
        if value.is_INVALID_START_HEIGHT():
            return
        if value.is_CORRUPTED_HEADERS():
            return
        if value.is_TRANSACTION_REJECTED():
            _UniffiConverterString.check_lower(value.wtxid)
            _UniffiConverterOptionalString.check_lower(value.reason)
            return
        if value.is_FAILED_PERSISTENCE():
            _UniffiConverterString.check_lower(value.warning)
            return
        if value.is_EVALUATING_FORK():
            return
        if value.is_EMPTY_PEER_DATABASE():
            return
        if value.is_UNEXPECTED_SYNC_ERROR():
            _UniffiConverterString.check_lower(value.warning)
            return
        if value.is_REQUEST_FAILED():
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_NEED_CONNECTIONS():
            buf.write_i32(1)
        if value.is_PEER_TIMED_OUT():
            buf.write_i32(2)
        if value.is_COULD_NOT_CONNECT():
            buf.write_i32(3)
        if value.is_NO_COMPACT_FILTERS():
            buf.write_i32(4)
        if value.is_POTENTIAL_STALE_TIP():
            buf.write_i32(5)
        if value.is_UNSOLICITED_MESSAGE():
            buf.write_i32(6)
        if value.is_INVALID_START_HEIGHT():
            buf.write_i32(7)
        if value.is_CORRUPTED_HEADERS():
            buf.write_i32(8)
        if value.is_TRANSACTION_REJECTED():
            buf.write_i32(9)
            _UniffiConverterString.write(value.wtxid, buf)
            _UniffiConverterOptionalString.write(value.reason, buf)
        if value.is_FAILED_PERSISTENCE():
            buf.write_i32(10)
            _UniffiConverterString.write(value.warning, buf)
        if value.is_EVALUATING_FORK():
            buf.write_i32(11)
        if value.is_EMPTY_PEER_DATABASE():
            buf.write_i32(12)
        if value.is_UNEXPECTED_SYNC_ERROR():
            buf.write_i32(13)
            _UniffiConverterString.write(value.warning, buf)
        if value.is_REQUEST_FAILED():
            buf.write_i32(14)







class WordCount(enum.Enum):
    WORDS12 = 0
    
    WORDS15 = 1
    
    WORDS18 = 2
    
    WORDS21 = 3
    
    WORDS24 = 4
    


class _UniffiConverterTypeWordCount(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return WordCount.WORDS12
        if variant == 2:
            return WordCount.WORDS15
        if variant == 3:
            return WordCount.WORDS18
        if variant == 4:
            return WordCount.WORDS21
        if variant == 5:
            return WordCount.WORDS24
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == WordCount.WORDS12:
            return
        if value == WordCount.WORDS15:
            return
        if value == WordCount.WORDS18:
            return
        if value == WordCount.WORDS21:
            return
        if value == WordCount.WORDS24:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == WordCount.WORDS12:
            buf.write_i32(1)
        if value == WordCount.WORDS15:
            buf.write_i32(2)
        if value == WordCount.WORDS18:
            buf.write_i32(3)
        if value == WordCount.WORDS21:
            buf.write_i32(4)
        if value == WordCount.WORDS24:
            buf.write_i32(5)





class _UniffiConverterOptionalUInt16(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt16.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt16.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt16.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalUInt32(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt32.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt32.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt32.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalUInt64(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt64.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt64.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalInt64(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterInt64.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterInt64.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalFloat(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterFloat.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterFloat.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterFloat.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalBool(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterBool.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterBool.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterBool.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalString(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterString.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterString.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterString.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeAmount(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeAmount.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeAmount.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeAmount.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeBlockHash(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeBlockHash.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeBlockHash.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeBlockHash.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeDescriptor(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeDescriptor.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeDescriptor.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeDescriptor.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypePolicy(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypePolicy.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypePolicy.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypePolicy.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeTransaction(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeTransaction.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeTransaction.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeTransaction.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeTxid(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeTxid.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeTxid.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeTxid.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeCanonicalTx(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeCanonicalTx.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeCanonicalTx.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeCanonicalTx.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeKeychainAndIndex(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeKeychainAndIndex.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeKeychainAndIndex.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeKeychainAndIndex.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeLocalOutput(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeLocalOutput.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeLocalOutput.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeLocalOutput.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeSignOptions(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeSignOptions.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeSignOptions.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeSignOptions.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeTx(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeTx.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeTx.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeTx.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeTxDetails(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeTxDetails.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeTxDetails.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeTxDetails.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeLockTime(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeLockTime.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeLockTime.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeLockTime.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeNetwork(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeNetwork.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeNetwork.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeNetwork.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalSequenceTypePsbtFinalizeError(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterSequenceTypePsbtFinalizeError.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterSequenceTypePsbtFinalizeError.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterSequenceTypePsbtFinalizeError.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterSequenceUInt32(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterUInt32.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterUInt32.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterUInt32.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceUInt64(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterUInt64.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterUInt64.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterUInt64.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceBytes(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterBytes.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterBytes.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterBytes.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeDescriptor(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeDescriptor.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeDescriptor.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeDescriptor.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeIpAddress(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeIpAddress.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeIpAddress.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeIpAddress.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypePolicy(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypePolicy.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypePolicy.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypePolicy.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeTransaction(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeTransaction.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeTransaction.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeTransaction.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeAddressInfo(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeAddressInfo.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeAddressInfo.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeAddressInfo.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeAnchor(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeAnchor.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeAnchor.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeAnchor.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeCanonicalTx(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeCanonicalTx.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeCanonicalTx.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeCanonicalTx.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeChainChange(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeChainChange.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeChainChange.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeChainChange.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeCondition(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeCondition.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeCondition.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeCondition.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeLocalOutput(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeLocalOutput.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeLocalOutput.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeLocalOutput.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeOutPoint(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeOutPoint.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeOutPoint.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeOutPoint.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypePeer(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypePeer.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypePeer.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypePeer.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeScriptAmount(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeScriptAmount.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeScriptAmount.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeScriptAmount.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeTxIn(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeTxIn.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeTxIn.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeTxIn.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeTxOut(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeTxOut.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeTxOut.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeTxOut.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeUnconfirmedTx(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeUnconfirmedTx.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeUnconfirmedTx.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeUnconfirmedTx.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypePkOrF(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypePkOrF.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypePkOrF.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypePkOrF.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypePsbtFinalizeError(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypePsbtFinalizeError.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypePsbtFinalizeError.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypePsbtFinalizeError.read(buf) for i in range(count)
        ]



class _UniffiConverterMapUInt16Double(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterUInt16.check_lower(key)
            _UniffiConverterDouble.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterUInt16.write(key, buf)
            _UniffiConverterDouble.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterUInt16.read(buf)
            val = _UniffiConverterDouble.read(buf)
            d[key] = val
        return d



class _UniffiConverterMapUInt32SequenceTypeCondition(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterUInt32.check_lower(key)
            _UniffiConverterSequenceTypeCondition.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterUInt32.write(key, buf)
            _UniffiConverterSequenceTypeCondition.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterUInt32.read(buf)
            val = _UniffiConverterSequenceTypeCondition.read(buf)
            d[key] = val
        return d



class _UniffiConverterMapStringSequenceUInt64(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterString.check_lower(key)
            _UniffiConverterSequenceUInt64.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterString.write(key, buf)
            _UniffiConverterSequenceUInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterString.read(buf)
            val = _UniffiConverterSequenceUInt64.read(buf)
            d[key] = val
        return d



class _UniffiConverterMapTypeDescriptorIdUInt32(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterTypeDescriptorId.check_lower(key)
            _UniffiConverterUInt32.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterTypeDescriptorId.write(key, buf)
            _UniffiConverterUInt32.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterTypeDescriptorId.read(buf)
            val = _UniffiConverterUInt32.read(buf)
            d[key] = val
        return d



class _UniffiConverterMapTypeHashableOutPointTypeTxOut(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterTypeHashableOutPoint.check_lower(key)
            _UniffiConverterTypeTxOut.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterTypeHashableOutPoint.write(key, buf)
            _UniffiConverterTypeTxOut.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterTypeHashableOutPoint.read(buf)
            val = _UniffiConverterTypeTxOut.read(buf)
            d[key] = val
        return d



class _UniffiConverterMapTypeTxidUInt64(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterTypeTxid.check_lower(key)
            _UniffiConverterUInt64.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterTypeTxid.write(key, buf)
            _UniffiConverterUInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterTypeTxid.read(buf)
            val = _UniffiConverterUInt64.read(buf)
            d[key] = val
        return d



class _UniffiConverterMapSequenceUInt32SequenceTypeCondition(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterSequenceUInt32.check_lower(key)
            _UniffiConverterSequenceTypeCondition.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterSequenceUInt32.write(key, buf)
            _UniffiConverterSequenceTypeCondition.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterSequenceUInt32.read(buf)
            val = _UniffiConverterSequenceTypeCondition.read(buf)
            d[key] = val
        return d

# objects.
class FullScanScriptInspectorProtocol(typing.Protocol):
    def inspect(self, keychain: "KeychainKind",index: "int",script: "Script"):
        raise NotImplementedError
# FullScanScriptInspector is a foreign trait so treated like a callback interface, where the
# primary use-case is the trait being implemented locally.
# It is a base-class local implementations might subclass.


class FullScanScriptInspector():
    def inspect(self, keychain: "KeychainKind",index: "int",script: "Script"):
        raise NotImplementedError
# `FullScanScriptInspectorImpl` is the implementation for a Rust implemented version.
class FullScanScriptInspectorImpl():
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_fullscanscriptinspector, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_fullscanscriptinspector, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def inspect(self, keychain: "KeychainKind",index: "int",script: "Script") -> None:
        _UniffiConverterTypeKeychainKind.check_lower(keychain)
        
        _UniffiConverterUInt32.check_lower(index)
        
        _UniffiConverterTypeScript.check_lower(script)
        
        _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_fullscanscriptinspector_inspect,self._uniffi_clone_pointer(),
        _UniffiConverterTypeKeychainKind.lower(keychain),
        _UniffiConverterUInt32.lower(index),
        _UniffiConverterTypeScript.lower(script))




# Magic number for the Rust proxy to call using the same mechanism as every other method,
# to free the callback once it's dropped by Rust.
_UNIFFI_IDX_CALLBACK_FREE = 0
# Return codes for callback calls
_UNIFFI_CALLBACK_SUCCESS = 0
_UNIFFI_CALLBACK_ERROR = 1
_UNIFFI_CALLBACK_UNEXPECTED_ERROR = 2

class _UniffiCallbackInterfaceFfiConverter:
    _handle_map = _UniffiHandleMap()

    @classmethod
    def lift(cls, handle):
        return cls._handle_map.get(handle)

    @classmethod
    def read(cls, buf):
        handle = buf.read_u64()
        cls.lift(handle)

    @classmethod
    def check_lower(cls, cb):
        pass

    @classmethod
    def lower(cls, cb):
        handle = cls._handle_map.insert(cb)
        return handle

    @classmethod
    def write(cls, cb, buf):
        buf.write_u64(cls.lower(cb))

# Put all the bits inside a class to keep the top-level namespace clean
class _UniffiTraitImplFullScanScriptInspector:
    # For each method, generate a callback function to pass to Rust

    @_UNIFFI_CALLBACK_INTERFACE_FULL_SCAN_SCRIPT_INSPECTOR_METHOD0
    def inspect(
            uniffi_handle,
            keychain,
            index,
            script,
            uniffi_out_return,
            uniffi_call_status_ptr,
        ):
        uniffi_obj = _UniffiConverterTypeFullScanScriptInspector._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterTypeKeychainKind.lift(keychain), _UniffiConverterUInt32.lift(index), _UniffiConverterTypeScript.lift(script), )
            method = uniffi_obj.inspect
            return method(*args)

        
        write_return_value = lambda v: None
        _uniffi_trait_interface_call(
                uniffi_call_status_ptr.contents,
                make_call,
                write_return_value,
        )

    @_UNIFFI_CALLBACK_INTERFACE_FREE
    def _uniffi_free(uniffi_handle):
        _UniffiConverterTypeFullScanScriptInspector._handle_map.remove(uniffi_handle)

    # Generate the FFI VTable.  This has a field for each callback interface method.
    _uniffi_vtable = _UniffiVTableCallbackInterfaceFullScanScriptInspector(
        inspect,
        _uniffi_free
    )
    # Send Rust a pointer to the VTable.  Note: this means we need to keep the struct alive forever,
    # or else bad things will happen when Rust tries to access it.
    _UniffiLib.uniffi_bdkffi_fn_init_callback_vtable_fullscanscriptinspector(ctypes.byref(_uniffi_vtable))



class _UniffiConverterTypeFullScanScriptInspector:
    _handle_map = _UniffiHandleMap()

    @staticmethod
    def lift(value: int):
        return FullScanScriptInspectorImpl._make_instance_(value)

    @staticmethod
    def check_lower(value: FullScanScriptInspector):
        pass

    @staticmethod
    def lower(value: FullScanScriptInspectorProtocol):
        return _UniffiConverterTypeFullScanScriptInspector._handle_map.insert(value)

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: FullScanScriptInspectorProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class PersistenceProtocol(typing.Protocol):
    """
    Definition of a wallet persistence implementation.
    """

    def initialize(self, ):
        """
        Initialize the total aggregate `ChangeSet` for the underlying wallet.
        """

        raise NotImplementedError
    def persist(self, changeset: "ChangeSet"):
        """
        Persist a `ChangeSet` to the total aggregate changeset of the wallet.
        """

        raise NotImplementedError
# Persistence is a foreign trait so treated like a callback interface, where the
# primary use-case is the trait being implemented locally.
# It is a base-class local implementations might subclass.


class Persistence():
    """
    Definition of a wallet persistence implementation.
    """

    def initialize(self, ):
        """
        Initialize the total aggregate `ChangeSet` for the underlying wallet.
        """

        raise NotImplementedError
    def persist(self, changeset: "ChangeSet"):
        """
        Persist a `ChangeSet` to the total aggregate changeset of the wallet.
        """

        raise NotImplementedError
# `PersistenceImpl` is the implementation for a Rust implemented version.
class PersistenceImpl():
    """
    Definition of a wallet persistence implementation.
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_persistence, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_persistence, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def initialize(self, ) -> "ChangeSet":
        """
        Initialize the total aggregate `ChangeSet` for the underlying wallet.
        """

        return _UniffiConverterTypeChangeSet.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypePersistenceError,_UniffiLib.uniffi_bdkffi_fn_method_persistence_initialize,self._uniffi_clone_pointer(),)
        )





    def persist(self, changeset: "ChangeSet") -> None:
        """
        Persist a `ChangeSet` to the total aggregate changeset of the wallet.
        """

        _UniffiConverterTypeChangeSet.check_lower(changeset)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypePersistenceError,_UniffiLib.uniffi_bdkffi_fn_method_persistence_persist,self._uniffi_clone_pointer(),
        _UniffiConverterTypeChangeSet.lower(changeset))






# Put all the bits inside a class to keep the top-level namespace clean
class _UniffiTraitImplPersistence:
    # For each method, generate a callback function to pass to Rust

    @_UNIFFI_CALLBACK_INTERFACE_PERSISTENCE_METHOD0
    def initialize(
            uniffi_handle,
            uniffi_out_return,
            uniffi_call_status_ptr,
        ):
        uniffi_obj = _UniffiConverterTypePersistence._handle_map.get(uniffi_handle)
        def make_call():
            args = ()
            method = uniffi_obj.initialize
            return method(*args)

        
        def write_return_value(v):
            uniffi_out_return[0] = _UniffiConverterTypeChangeSet.lower(v)
        _uniffi_trait_interface_call_with_error(
                uniffi_call_status_ptr.contents,
                make_call,
                write_return_value,
                PersistenceError,
                _UniffiConverterTypePersistenceError.lower,
        )

    @_UNIFFI_CALLBACK_INTERFACE_PERSISTENCE_METHOD1
    def persist(
            uniffi_handle,
            changeset,
            uniffi_out_return,
            uniffi_call_status_ptr,
        ):
        uniffi_obj = _UniffiConverterTypePersistence._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterTypeChangeSet.lift(changeset), )
            method = uniffi_obj.persist
            return method(*args)

        
        write_return_value = lambda v: None
        _uniffi_trait_interface_call_with_error(
                uniffi_call_status_ptr.contents,
                make_call,
                write_return_value,
                PersistenceError,
                _UniffiConverterTypePersistenceError.lower,
        )

    @_UNIFFI_CALLBACK_INTERFACE_FREE
    def _uniffi_free(uniffi_handle):
        _UniffiConverterTypePersistence._handle_map.remove(uniffi_handle)

    # Generate the FFI VTable.  This has a field for each callback interface method.
    _uniffi_vtable = _UniffiVTableCallbackInterfacePersistence(
        initialize,
        persist,
        _uniffi_free
    )
    # Send Rust a pointer to the VTable.  Note: this means we need to keep the struct alive forever,
    # or else bad things will happen when Rust tries to access it.
    _UniffiLib.uniffi_bdkffi_fn_init_callback_vtable_persistence(ctypes.byref(_uniffi_vtable))



class _UniffiConverterTypePersistence:
    _handle_map = _UniffiHandleMap()

    @staticmethod
    def lift(value: int):
        return PersistenceImpl._make_instance_(value)

    @staticmethod
    def check_lower(value: Persistence):
        pass

    @staticmethod
    def lower(value: PersistenceProtocol):
        return _UniffiConverterTypePersistence._handle_map.insert(value)

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: PersistenceProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class SyncScriptInspectorProtocol(typing.Protocol):
    def inspect(self, script: "Script",total: "int"):
        raise NotImplementedError
# SyncScriptInspector is a foreign trait so treated like a callback interface, where the
# primary use-case is the trait being implemented locally.
# It is a base-class local implementations might subclass.


class SyncScriptInspector():
    def inspect(self, script: "Script",total: "int"):
        raise NotImplementedError
# `SyncScriptInspectorImpl` is the implementation for a Rust implemented version.
class SyncScriptInspectorImpl():
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_syncscriptinspector, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_syncscriptinspector, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def inspect(self, script: "Script",total: "int") -> None:
        _UniffiConverterTypeScript.check_lower(script)
        
        _UniffiConverterUInt64.check_lower(total)
        
        _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_syncscriptinspector_inspect,self._uniffi_clone_pointer(),
        _UniffiConverterTypeScript.lower(script),
        _UniffiConverterUInt64.lower(total))






# Put all the bits inside a class to keep the top-level namespace clean
class _UniffiTraitImplSyncScriptInspector:
    # For each method, generate a callback function to pass to Rust

    @_UNIFFI_CALLBACK_INTERFACE_SYNC_SCRIPT_INSPECTOR_METHOD0
    def inspect(
            uniffi_handle,
            script,
            total,
            uniffi_out_return,
            uniffi_call_status_ptr,
        ):
        uniffi_obj = _UniffiConverterTypeSyncScriptInspector._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterTypeScript.lift(script), _UniffiConverterUInt64.lift(total), )
            method = uniffi_obj.inspect
            return method(*args)

        
        write_return_value = lambda v: None
        _uniffi_trait_interface_call(
                uniffi_call_status_ptr.contents,
                make_call,
                write_return_value,
        )

    @_UNIFFI_CALLBACK_INTERFACE_FREE
    def _uniffi_free(uniffi_handle):
        _UniffiConverterTypeSyncScriptInspector._handle_map.remove(uniffi_handle)

    # Generate the FFI VTable.  This has a field for each callback interface method.
    _uniffi_vtable = _UniffiVTableCallbackInterfaceSyncScriptInspector(
        inspect,
        _uniffi_free
    )
    # Send Rust a pointer to the VTable.  Note: this means we need to keep the struct alive forever,
    # or else bad things will happen when Rust tries to access it.
    _UniffiLib.uniffi_bdkffi_fn_init_callback_vtable_syncscriptinspector(ctypes.byref(_uniffi_vtable))



class _UniffiConverterTypeSyncScriptInspector:
    _handle_map = _UniffiHandleMap()

    @staticmethod
    def lift(value: int):
        return SyncScriptInspectorImpl._make_instance_(value)

    @staticmethod
    def check_lower(value: SyncScriptInspector):
        pass

    @staticmethod
    def lower(value: SyncScriptInspectorProtocol):
        return _UniffiConverterTypeSyncScriptInspector._handle_map.insert(value)

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: SyncScriptInspectorProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class AddressProtocol(typing.Protocol):
    """
    A bitcoin address
    """

    def is_valid_for_network(self, network: "Network"):
        """
        Is the address valid for the provided network
        """

        raise NotImplementedError
    def script_pubkey(self, ):
        """
        Return the `scriptPubKey` underlying an address.
        """

        raise NotImplementedError
    def to_address_data(self, ):
        """
        Return the data for the address.
        """

        raise NotImplementedError
    def to_qr_uri(self, ):
        """
        Return a BIP-21 URI string for this address.
        """

        raise NotImplementedError
# Address is a Rust-only trait - it's a wrapper around a Rust implementation.
class Address():
    """
    A bitcoin address
    """

    _pointer: ctypes.c_void_p
    def __init__(self, address: "str",network: "Network"):
        """
        Parse a string as an address for the given network.
        """

        _UniffiConverterString.check_lower(address)
        
        _UniffiConverterTypeNetwork.check_lower(network)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeAddressParseError,_UniffiLib.uniffi_bdkffi_fn_constructor_address_new,
        _UniffiConverterString.lower(address),
        _UniffiConverterTypeNetwork.lower(network))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_address, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_address, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst
    @classmethod
    def from_script(cls, script: "Script",network: "Network"):
        """
        Parse a script as an address for the given network
        """

        _UniffiConverterTypeScript.check_lower(script)
        
        _UniffiConverterTypeNetwork.check_lower(network)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeFromScriptError,_UniffiLib.uniffi_bdkffi_fn_constructor_address_from_script,
        _UniffiConverterTypeScript.lower(script),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)



    def is_valid_for_network(self, network: "Network") -> "bool":
        """
        Is the address valid for the provided network
        """

        _UniffiConverterTypeNetwork.check_lower(network)
        
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_address_is_valid_for_network,self._uniffi_clone_pointer(),
        _UniffiConverterTypeNetwork.lower(network))
        )





    def script_pubkey(self, ) -> "Script":
        """
        Return the `scriptPubKey` underlying an address.
        """

        return _UniffiConverterTypeScript.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_address_script_pubkey,self._uniffi_clone_pointer(),)
        )





    def to_address_data(self, ) -> "AddressData":
        """
        Return the data for the address.
        """

        return _UniffiConverterTypeAddressData.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_address_to_address_data,self._uniffi_clone_pointer(),)
        )





    def to_qr_uri(self, ) -> "str":
        """
        Return a BIP-21 URI string for this address.
        """

        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_address_to_qr_uri,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_address_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )



    def __eq__(self, other: object) -> bool:
        if not isinstance(other, Address):
            return NotImplemented

        return _UniffiConverterBool.lift(_uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_address_uniffi_trait_eq_eq,self._uniffi_clone_pointer(),
        _UniffiConverterTypeAddress.lower(other)))

    def __ne__(self, other: object) -> bool:
        if not isinstance(other, Address):
            return NotImplemented

        return _UniffiConverterBool.lift(_uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_address_uniffi_trait_eq_ne,self._uniffi_clone_pointer(),
        _UniffiConverterTypeAddress.lower(other)))



class _UniffiConverterTypeAddress:

    @staticmethod
    def lift(value: int):
        return Address._make_instance_(value)

    @staticmethod
    def check_lower(value: Address):
        if not isinstance(value, Address):
            raise TypeError("Expected Address instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: AddressProtocol):
        if not isinstance(value, Address):
            raise TypeError("Expected Address instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: AddressProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class AmountProtocol(typing.Protocol):
    """
    The Amount type can be used to express Bitcoin amounts that support arithmetic and conversion
    to various denominations. The operations that Amount implements will panic when overflow or
    underflow occurs. Also note that since the internal representation of amounts is unsigned,
    subtracting below zero is considered an underflow and will cause a panic.
    """

    def to_btc(self, ):
        """
        Express this Amount as a floating-point value in Bitcoin. Please be aware of the risk of
        using floating-point numbers.
        """

        raise NotImplementedError
    def to_sat(self, ):
        """
        Get the number of satoshis in this Amount.
        """

        raise NotImplementedError
# Amount is a Rust-only trait - it's a wrapper around a Rust implementation.
class Amount():
    """
    The Amount type can be used to express Bitcoin amounts that support arithmetic and conversion
    to various denominations. The operations that Amount implements will panic when overflow or
    underflow occurs. Also note that since the internal representation of amounts is unsigned,
    subtracting below zero is considered an underflow and will cause a panic.
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_amount, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_amount, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst
    @classmethod
    def from_btc(cls, btc: "float"):
        """
        Convert from a value expressing bitcoins to an Amount.
        """

        _UniffiConverterDouble.check_lower(btc)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeParseAmountError,_UniffiLib.uniffi_bdkffi_fn_constructor_amount_from_btc,
        _UniffiConverterDouble.lower(btc))
        return cls._make_instance_(pointer)

    @classmethod
    def from_sat(cls, satoshi: "int"):
        """
        Create an Amount with satoshi precision and the given number of satoshis.
        """

        _UniffiConverterUInt64.check_lower(satoshi)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_amount_from_sat,
        _UniffiConverterUInt64.lower(satoshi))
        return cls._make_instance_(pointer)



    def to_btc(self, ) -> "float":
        """
        Express this Amount as a floating-point value in Bitcoin. Please be aware of the risk of
        using floating-point numbers.
        """

        return _UniffiConverterDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_amount_to_btc,self._uniffi_clone_pointer(),)
        )





    def to_sat(self, ) -> "int":
        """
        Get the number of satoshis in this Amount.
        """

        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_amount_to_sat,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeAmount:

    @staticmethod
    def lift(value: int):
        return Amount._make_instance_(value)

    @staticmethod
    def check_lower(value: Amount):
        if not isinstance(value, Amount):
            raise TypeError("Expected Amount instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: AmountProtocol):
        if not isinstance(value, Amount):
            raise TypeError("Expected Amount instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: AmountProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class BlockHashProtocol(typing.Protocol):
    """
    A bitcoin Block hash
    """

    def serialize(self, ):
        """
        Serialize this type into a 32 byte array.
        """

        raise NotImplementedError
# BlockHash is a Rust-only trait - it's a wrapper around a Rust implementation.
class BlockHash():
    """
    A bitcoin Block hash
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_blockhash, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_blockhash, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst
    @classmethod
    def from_bytes(cls, bytes: "bytes"):
        """
        Construct a hash-like type from 32 bytes.
        """

        _UniffiConverterBytes.check_lower(bytes)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeHashParseError,_UniffiLib.uniffi_bdkffi_fn_constructor_blockhash_from_bytes,
        _UniffiConverterBytes.lower(bytes))
        return cls._make_instance_(pointer)

    @classmethod
    def from_string(cls, hex: "str"):
        """
        Construct a hash-like type from a hex string.
        """

        _UniffiConverterString.check_lower(hex)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeHashParseError,_UniffiLib.uniffi_bdkffi_fn_constructor_blockhash_from_string,
        _UniffiConverterString.lower(hex))
        return cls._make_instance_(pointer)



    def serialize(self, ) -> "bytes":
        """
        Serialize this type into a 32 byte array.
        """

        return _UniffiConverterBytes.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_blockhash_serialize,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_blockhash_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )



    def __eq__(self, other: object) -> bool:
        if not isinstance(other, BlockHash):
            return NotImplemented

        return _UniffiConverterBool.lift(_uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_blockhash_uniffi_trait_eq_eq,self._uniffi_clone_pointer(),
        _UniffiConverterTypeBlockHash.lower(other)))

    def __ne__(self, other: object) -> bool:
        if not isinstance(other, BlockHash):
            return NotImplemented

        return _UniffiConverterBool.lift(_uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_blockhash_uniffi_trait_eq_ne,self._uniffi_clone_pointer(),
        _UniffiConverterTypeBlockHash.lower(other)))


    def __hash__(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_blockhash_uniffi_trait_hash,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeBlockHash:

    @staticmethod
    def lift(value: int):
        return BlockHash._make_instance_(value)

    @staticmethod
    def check_lower(value: BlockHash):
        if not isinstance(value, BlockHash):
            raise TypeError("Expected BlockHash instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: BlockHashProtocol):
        if not isinstance(value, BlockHash):
            raise TypeError("Expected BlockHash instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: BlockHashProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class BumpFeeTxBuilderProtocol(typing.Protocol):
    """
    A `BumpFeeTxBuilder` is created by calling `build_fee_bump` on a wallet. After assigning it, you set options on it
    until finally calling `finish` to consume the builder and generate the transaction.
    """

    def allow_dust(self, allow_dust: "bool"):
        """
        Set whether the dust limit is checked.

        Note: by avoiding a dust limit check you may end up with a transaction that is non-standard.
        """

        raise NotImplementedError
    def current_height(self, height: "int"):
        """
        Set the current blockchain height.

        This will be used to:

        1. Set the `nLockTime` for preventing fee sniping. Note: This will be ignored if you manually specify a
        `nlocktime` using `TxBuilder::nlocktime`.

        2. Decide whether coinbase outputs are mature or not. If the coinbase outputs are not mature at `current_height`,
        we ignore them in the coin selection. If you want to create a transaction that spends immature coinbase inputs,
        manually add them using `TxBuilder::add_utxos`.
        In both cases, if you don’t provide a current height, we use the last sync height.
        """

        raise NotImplementedError
    def finish(self, wallet: "Wallet"):
        """
        Finish building the transaction.

        Uses the thread-local random number generator (rng).

        Returns a new `Psbt` per BIP174.

        WARNING: To avoid change address reuse you must persist the changes resulting from one or more calls to this
        method before closing the wallet. See `Wallet::reveal_next_address`.
        """

        raise NotImplementedError
    def nlocktime(self, locktime: "LockTime"):
        """
        Use a specific nLockTime while creating the transaction.

        This can cause conflicts if the wallet’s descriptors contain an "after" (`OP_CLTV`) operator.
        """

        raise NotImplementedError
    def set_exact_sequence(self, nsequence: "int"):
        """
        Set an exact `nSequence` value.

        This can cause conflicts if the wallet’s descriptors contain an "older" (`OP_CSV`) operator and the given
        `nsequence` is lower than the CSV value.
        """

        raise NotImplementedError
    def version(self, version: "int"):
        """
        Build a transaction with a specific version.

        The version should always be greater than 0 and greater than 1 if the wallet’s descriptors contain an "older"
        (`OP_CSV`) operator.
        """

        raise NotImplementedError
# BumpFeeTxBuilder is a Rust-only trait - it's a wrapper around a Rust implementation.
class BumpFeeTxBuilder():
    """
    A `BumpFeeTxBuilder` is created by calling `build_fee_bump` on a wallet. After assigning it, you set options on it
    until finally calling `finish` to consume the builder and generate the transaction.
    """

    _pointer: ctypes.c_void_p
    def __init__(self, txid: "Txid",fee_rate: "FeeRate"):
        _UniffiConverterTypeTxid.check_lower(txid)
        
        _UniffiConverterTypeFeeRate.check_lower(fee_rate)
        
        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_bumpfeetxbuilder_new,
        _UniffiConverterTypeTxid.lower(txid),
        _UniffiConverterTypeFeeRate.lower(fee_rate))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_bumpfeetxbuilder, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_bumpfeetxbuilder, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def allow_dust(self, allow_dust: "bool") -> "BumpFeeTxBuilder":
        """
        Set whether the dust limit is checked.

        Note: by avoiding a dust limit check you may end up with a transaction that is non-standard.
        """

        _UniffiConverterBool.check_lower(allow_dust)
        
        return _UniffiConverterTypeBumpFeeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_bumpfeetxbuilder_allow_dust,self._uniffi_clone_pointer(),
        _UniffiConverterBool.lower(allow_dust))
        )





    def current_height(self, height: "int") -> "BumpFeeTxBuilder":
        """
        Set the current blockchain height.

        This will be used to:

        1. Set the `nLockTime` for preventing fee sniping. Note: This will be ignored if you manually specify a
        `nlocktime` using `TxBuilder::nlocktime`.

        2. Decide whether coinbase outputs are mature or not. If the coinbase outputs are not mature at `current_height`,
        we ignore them in the coin selection. If you want to create a transaction that spends immature coinbase inputs,
        manually add them using `TxBuilder::add_utxos`.
        In both cases, if you don’t provide a current height, we use the last sync height.
        """

        _UniffiConverterUInt32.check_lower(height)
        
        return _UniffiConverterTypeBumpFeeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_bumpfeetxbuilder_current_height,self._uniffi_clone_pointer(),
        _UniffiConverterUInt32.lower(height))
        )





    def finish(self, wallet: "Wallet") -> "Psbt":
        """
        Finish building the transaction.

        Uses the thread-local random number generator (rng).

        Returns a new `Psbt` per BIP174.

        WARNING: To avoid change address reuse you must persist the changes resulting from one or more calls to this
        method before closing the wallet. See `Wallet::reveal_next_address`.
        """

        _UniffiConverterTypeWallet.check_lower(wallet)
        
        return _UniffiConverterTypePsbt.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeCreateTxError,_UniffiLib.uniffi_bdkffi_fn_method_bumpfeetxbuilder_finish,self._uniffi_clone_pointer(),
        _UniffiConverterTypeWallet.lower(wallet))
        )





    def nlocktime(self, locktime: "LockTime") -> "BumpFeeTxBuilder":
        """
        Use a specific nLockTime while creating the transaction.

        This can cause conflicts if the wallet’s descriptors contain an "after" (`OP_CLTV`) operator.
        """

        _UniffiConverterTypeLockTime.check_lower(locktime)
        
        return _UniffiConverterTypeBumpFeeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_bumpfeetxbuilder_nlocktime,self._uniffi_clone_pointer(),
        _UniffiConverterTypeLockTime.lower(locktime))
        )





    def set_exact_sequence(self, nsequence: "int") -> "BumpFeeTxBuilder":
        """
        Set an exact `nSequence` value.

        This can cause conflicts if the wallet’s descriptors contain an "older" (`OP_CSV`) operator and the given
        `nsequence` is lower than the CSV value.
        """

        _UniffiConverterUInt32.check_lower(nsequence)
        
        return _UniffiConverterTypeBumpFeeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_bumpfeetxbuilder_set_exact_sequence,self._uniffi_clone_pointer(),
        _UniffiConverterUInt32.lower(nsequence))
        )





    def version(self, version: "int") -> "BumpFeeTxBuilder":
        """
        Build a transaction with a specific version.

        The version should always be greater than 0 and greater than 1 if the wallet’s descriptors contain an "older"
        (`OP_CSV`) operator.
        """

        _UniffiConverterInt32.check_lower(version)
        
        return _UniffiConverterTypeBumpFeeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_bumpfeetxbuilder_version,self._uniffi_clone_pointer(),
        _UniffiConverterInt32.lower(version))
        )






class _UniffiConverterTypeBumpFeeTxBuilder:

    @staticmethod
    def lift(value: int):
        return BumpFeeTxBuilder._make_instance_(value)

    @staticmethod
    def check_lower(value: BumpFeeTxBuilder):
        if not isinstance(value, BumpFeeTxBuilder):
            raise TypeError("Expected BumpFeeTxBuilder instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: BumpFeeTxBuilderProtocol):
        if not isinstance(value, BumpFeeTxBuilder):
            raise TypeError("Expected BumpFeeTxBuilder instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: BumpFeeTxBuilderProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class CbfBuilderProtocol(typing.Protocol):
    """
    Build a BIP 157/158 light client to fetch transactions for a `Wallet`.

    Options:
    * List of `Peer`: Bitcoin full-nodes for the light client to connect to. May be empty.
    * `connections`: The number of connections for the light client to maintain.
    * `scan_type`: Sync, recover, or start a new wallet. For more information see [`ScanType`].
    * `data_dir`: Optional directory to store block headers and peers.

    A note on recovering wallets. Developers should allow users to provide an
    approximate recovery height and an estimated number of transactions for the
    wallet. When determining how many scripts to check filters for, the `Wallet`
    `lookahead` value will be used. To ensure all transactions are recovered, the
    `lookahead` should be roughly the number of transactions in the wallet history.
    """

    def build(self, wallet: "Wallet"):
        """
        Construct a [`CbfComponents`] for a [`Wallet`].
        """

        raise NotImplementedError
    def configure_timeout_millis(self, handshake: "int",response: "int"):
        """
        Configure the time in milliseconds that a node has to:
        1. Respond to the initial connection
        2. Respond to a request
        """

        raise NotImplementedError
    def connections(self, connections: "int"):
        """
        The number of connections for the light client to maintain. Default is two.
        """

        raise NotImplementedError
    def data_dir(self, data_dir: "str"):
        """
        Directory to store block headers and peers. If none is provided, the current
        working directory will be used.
        """

        raise NotImplementedError
    def dns_resolver(self, dns_resolver: "IpAddress"):
        """
        Configure a custom DNS resolver when querying DNS seeds. Default is `1.1.1.1` managed by
        CloudFlare.
        """

        raise NotImplementedError
    def log_level(self, log_level: "LogLevel"):
        """
        Set the log level for the node. Production applications may want to omit `Debug` messages
        to avoid heap allocations.
        """

        raise NotImplementedError
    def peers(self, peers: "typing.List[Peer]"):
        """
        Bitcoin full-nodes to attempt a connection with.
        """

        raise NotImplementedError
    def scan_type(self, scan_type: "ScanType"):
        """
        Select between syncing, recovering, or scanning for new wallets.
        """

        raise NotImplementedError
    def socks5_proxy(self, proxy: "Socks5Proxy"):
        """
        Configure connections to be established through a `Socks5 proxy. The vast majority of the
        time, the connection is to a local Tor daemon, which is typically exposed at
        `127.0.0.1:9050`.
        """

        raise NotImplementedError
# CbfBuilder is a Rust-only trait - it's a wrapper around a Rust implementation.
class CbfBuilder():
    """
    Build a BIP 157/158 light client to fetch transactions for a `Wallet`.

    Options:
    * List of `Peer`: Bitcoin full-nodes for the light client to connect to. May be empty.
    * `connections`: The number of connections for the light client to maintain.
    * `scan_type`: Sync, recover, or start a new wallet. For more information see [`ScanType`].
    * `data_dir`: Optional directory to store block headers and peers.

    A note on recovering wallets. Developers should allow users to provide an
    approximate recovery height and an estimated number of transactions for the
    wallet. When determining how many scripts to check filters for, the `Wallet`
    `lookahead` value will be used. To ensure all transactions are recovered, the
    `lookahead` should be roughly the number of transactions in the wallet history.
    """

    _pointer: ctypes.c_void_p
    def __init__(self, ):
        """
        Start a new [`CbfBuilder`]
        """

        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_cbfbuilder_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_cbfbuilder, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_cbfbuilder, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def build(self, wallet: "Wallet") -> "CbfComponents":
        """
        Construct a [`CbfComponents`] for a [`Wallet`].
        """

        _UniffiConverterTypeWallet.check_lower(wallet)
        
        return _UniffiConverterTypeCbfComponents.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeCbfBuilderError,_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_build,self._uniffi_clone_pointer(),
        _UniffiConverterTypeWallet.lower(wallet))
        )





    def configure_timeout_millis(self, handshake: "int",response: "int") -> "CbfBuilder":
        """
        Configure the time in milliseconds that a node has to:
        1. Respond to the initial connection
        2. Respond to a request
        """

        _UniffiConverterUInt64.check_lower(handshake)
        
        _UniffiConverterUInt64.check_lower(response)
        
        return _UniffiConverterTypeCbfBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_configure_timeout_millis,self._uniffi_clone_pointer(),
        _UniffiConverterUInt64.lower(handshake),
        _UniffiConverterUInt64.lower(response))
        )





    def connections(self, connections: "int") -> "CbfBuilder":
        """
        The number of connections for the light client to maintain. Default is two.
        """

        _UniffiConverterUInt8.check_lower(connections)
        
        return _UniffiConverterTypeCbfBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_connections,self._uniffi_clone_pointer(),
        _UniffiConverterUInt8.lower(connections))
        )





    def data_dir(self, data_dir: "str") -> "CbfBuilder":
        """
        Directory to store block headers and peers. If none is provided, the current
        working directory will be used.
        """

        _UniffiConverterString.check_lower(data_dir)
        
        return _UniffiConverterTypeCbfBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_data_dir,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(data_dir))
        )





    def dns_resolver(self, dns_resolver: "IpAddress") -> "CbfBuilder":
        """
        Configure a custom DNS resolver when querying DNS seeds. Default is `1.1.1.1` managed by
        CloudFlare.
        """

        _UniffiConverterTypeIpAddress.check_lower(dns_resolver)
        
        return _UniffiConverterTypeCbfBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_dns_resolver,self._uniffi_clone_pointer(),
        _UniffiConverterTypeIpAddress.lower(dns_resolver))
        )





    def log_level(self, log_level: "LogLevel") -> "CbfBuilder":
        """
        Set the log level for the node. Production applications may want to omit `Debug` messages
        to avoid heap allocations.
        """

        _UniffiConverterTypeLogLevel.check_lower(log_level)
        
        return _UniffiConverterTypeCbfBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_log_level,self._uniffi_clone_pointer(),
        _UniffiConverterTypeLogLevel.lower(log_level))
        )





    def peers(self, peers: "typing.List[Peer]") -> "CbfBuilder":
        """
        Bitcoin full-nodes to attempt a connection with.
        """

        _UniffiConverterSequenceTypePeer.check_lower(peers)
        
        return _UniffiConverterTypeCbfBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_peers,self._uniffi_clone_pointer(),
        _UniffiConverterSequenceTypePeer.lower(peers))
        )





    def scan_type(self, scan_type: "ScanType") -> "CbfBuilder":
        """
        Select between syncing, recovering, or scanning for new wallets.
        """

        _UniffiConverterTypeScanType.check_lower(scan_type)
        
        return _UniffiConverterTypeCbfBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_scan_type,self._uniffi_clone_pointer(),
        _UniffiConverterTypeScanType.lower(scan_type))
        )





    def socks5_proxy(self, proxy: "Socks5Proxy") -> "CbfBuilder":
        """
        Configure connections to be established through a `Socks5 proxy. The vast majority of the
        time, the connection is to a local Tor daemon, which is typically exposed at
        `127.0.0.1:9050`.
        """

        _UniffiConverterTypeSocks5Proxy.check_lower(proxy)
        
        return _UniffiConverterTypeCbfBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_cbfbuilder_socks5_proxy,self._uniffi_clone_pointer(),
        _UniffiConverterTypeSocks5Proxy.lower(proxy))
        )






class _UniffiConverterTypeCbfBuilder:

    @staticmethod
    def lift(value: int):
        return CbfBuilder._make_instance_(value)

    @staticmethod
    def check_lower(value: CbfBuilder):
        if not isinstance(value, CbfBuilder):
            raise TypeError("Expected CbfBuilder instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: CbfBuilderProtocol):
        if not isinstance(value, CbfBuilder):
            raise TypeError("Expected CbfBuilder instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: CbfBuilderProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class CbfClientProtocol(typing.Protocol):
    """
    A [`CbfClient`] handles wallet updates from a [`CbfNode`].
    """

    def add_revealed_scripts(self, wallet: "Wallet"):
        """
        Add scripts for the node to watch for as they are revealed. Typically used after creating
        a transaction or revealing a receive address.

        Note that only future blocks will be checked for these scripts, not past blocks.
        """

        raise NotImplementedError
    def average_fee_rate(self, blockhash: "BlockHash"):
        """
        Fetch the average fee rate for a block by requesting it from a peer. Not recommend for
        resource-limited devices.
        """

        raise NotImplementedError
    def broadcast(self, transaction: "Transaction"):
        """
        Broadcast a transaction to the network, erroring if the node has stopped running.
        """

        raise NotImplementedError
    def connect(self, peer: "Peer"):
        """
        Add another [`Peer`] to attempt a connection with.
        """

        raise NotImplementedError
    def is_running(self, ):
        """
        Check if the node is still running in the background.
        """

        raise NotImplementedError
    def lookup_host(self, hostname: "str"):
        """
        Query a Bitcoin DNS seeder using the configured resolver.

        This is **not** a generic DNS implementation. Host names are prefixed with a `x849` to filter
        for compact block filter nodes from the seeder. For example `dns.myseeder.com` will be queried
        as `x849.dns.myseeder.com`. This has no guarantee to return any `IpAddr`.
        """

        raise NotImplementedError
    def min_broadcast_feerate(self, ):
        """
        The minimum fee rate required to broadcast a transcation to all connected peers.
        """

        raise NotImplementedError
    def next_info(self, ):
        raise NotImplementedError
    def next_log(self, ):
        """
        Return the next available log message from a node. If none is returned, the node has stopped.
        """

        raise NotImplementedError
    def next_warning(self, ):
        """
        Return the next available warning message from a node. If none is returned, the node has stopped.
        """

        raise NotImplementedError
    def shutdown(self, ):
        """
        Stop the [`CbfNode`]. Errors if the node is already stopped.
        """

        raise NotImplementedError
    def update(self, ):
        """
        Return an [`Update`]. This is method returns once the node syncs to the rest of
        the network or a new block has been gossiped.
        """

        raise NotImplementedError
# CbfClient is a Rust-only trait - it's a wrapper around a Rust implementation.
class CbfClient():
    """
    A [`CbfClient`] handles wallet updates from a [`CbfNode`].
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_cbfclient, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_cbfclient, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def add_revealed_scripts(self, wallet: "Wallet") -> None:
        """
        Add scripts for the node to watch for as they are revealed. Typically used after creating
        a transaction or revealing a receive address.

        Note that only future blocks will be checked for these scripts, not past blocks.
        """

        _UniffiConverterTypeWallet.check_lower(wallet)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeCbfError,_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_add_revealed_scripts,self._uniffi_clone_pointer(),
        _UniffiConverterTypeWallet.lower(wallet))





    async def average_fee_rate(self, blockhash: "BlockHash") -> "FeeRate":
        """
        Fetch the average fee rate for a block by requesting it from a peer. Not recommend for
        resource-limited devices.
        """

        _UniffiConverterTypeBlockHash.check_lower(blockhash)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_bdkffi_fn_method_cbfclient_average_fee_rate(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeBlockHash.lower(blockhash)
            ),
            _UniffiLib.ffi_bdkffi_rust_future_poll_pointer,
            _UniffiLib.ffi_bdkffi_rust_future_complete_pointer,
            _UniffiLib.ffi_bdkffi_rust_future_free_pointer,
            # lift function
            _UniffiConverterTypeFeeRate.lift,
            
    # Error FFI converter
_UniffiConverterTypeCbfError,

        )




    def broadcast(self, transaction: "Transaction") -> None:
        """
        Broadcast a transaction to the network, erroring if the node has stopped running.
        """

        _UniffiConverterTypeTransaction.check_lower(transaction)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeCbfError,_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_broadcast,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTransaction.lower(transaction))






    def connect(self, peer: "Peer") -> None:
        """
        Add another [`Peer`] to attempt a connection with.
        """

        _UniffiConverterTypePeer.check_lower(peer)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeCbfError,_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_connect,self._uniffi_clone_pointer(),
        _UniffiConverterTypePeer.lower(peer))






    def is_running(self, ) -> "bool":
        """
        Check if the node is still running in the background.
        """

        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_is_running,self._uniffi_clone_pointer(),)
        )




    async def lookup_host(self, hostname: "str") -> "typing.List[IpAddress]":
        """
        Query a Bitcoin DNS seeder using the configured resolver.

        This is **not** a generic DNS implementation. Host names are prefixed with a `x849` to filter
        for compact block filter nodes from the seeder. For example `dns.myseeder.com` will be queried
        as `x849.dns.myseeder.com`. This has no guarantee to return any `IpAddr`.
        """

        _UniffiConverterString.check_lower(hostname)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_bdkffi_fn_method_cbfclient_lookup_host(
                self._uniffi_clone_pointer(), 
        _UniffiConverterString.lower(hostname)
            ),
            _UniffiLib.ffi_bdkffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_bdkffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_bdkffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceTypeIpAddress.lift,
            
    # Error FFI converter

    None,

        )



    async def min_broadcast_feerate(self, ) -> "FeeRate":
        """
        The minimum fee rate required to broadcast a transcation to all connected peers.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_bdkffi_fn_method_cbfclient_min_broadcast_feerate(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_bdkffi_rust_future_poll_pointer,
            _UniffiLib.ffi_bdkffi_rust_future_complete_pointer,
            _UniffiLib.ffi_bdkffi_rust_future_free_pointer,
            # lift function
            _UniffiConverterTypeFeeRate.lift,
            
    # Error FFI converter
_UniffiConverterTypeCbfError,

        )



    async def next_info(self, ) -> "Info":
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_bdkffi_fn_method_cbfclient_next_info(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_bdkffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_bdkffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_bdkffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeInfo.lift,
            
    # Error FFI converter
_UniffiConverterTypeCbfError,

        )



    async def next_log(self, ) -> "str":
        """
        Return the next available log message from a node. If none is returned, the node has stopped.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_bdkffi_fn_method_cbfclient_next_log(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_bdkffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_bdkffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_bdkffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterString.lift,
            
    # Error FFI converter
_UniffiConverterTypeCbfError,

        )



    async def next_warning(self, ) -> "Warning":
        """
        Return the next available warning message from a node. If none is returned, the node has stopped.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_bdkffi_fn_method_cbfclient_next_warning(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_bdkffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_bdkffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_bdkffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeWarning.lift,
            
    # Error FFI converter
_UniffiConverterTypeCbfError,

        )




    def shutdown(self, ) -> None:
        """
        Stop the [`CbfNode`]. Errors if the node is already stopped.
        """

        _uniffi_rust_call_with_error(_UniffiConverterTypeCbfError,_UniffiLib.uniffi_bdkffi_fn_method_cbfclient_shutdown,self._uniffi_clone_pointer(),)





    async def update(self, ) -> "Update":
        """
        Return an [`Update`]. This is method returns once the node syncs to the rest of
        the network or a new block has been gossiped.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_bdkffi_fn_method_cbfclient_update(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_bdkffi_rust_future_poll_pointer,
            _UniffiLib.ffi_bdkffi_rust_future_complete_pointer,
            _UniffiLib.ffi_bdkffi_rust_future_free_pointer,
            # lift function
            _UniffiConverterTypeUpdate.lift,
            
    # Error FFI converter
_UniffiConverterTypeCbfError,

        )





class _UniffiConverterTypeCbfClient:

    @staticmethod
    def lift(value: int):
        return CbfClient._make_instance_(value)

    @staticmethod
    def check_lower(value: CbfClient):
        if not isinstance(value, CbfClient):
            raise TypeError("Expected CbfClient instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: CbfClientProtocol):
        if not isinstance(value, CbfClient):
            raise TypeError("Expected CbfClient instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: CbfClientProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class CbfNodeProtocol(typing.Protocol):
    """
    A [`CbfNode`] gathers transactions for a [`Wallet`].
    To receive [`Update`] for [`Wallet`], refer to the
    [`CbfClient`]. The [`CbfNode`] will run until instructed
    to stop.
    """

    def run(self, ):
        """
        Start the node on a detached OS thread and immediately return.
        """

        raise NotImplementedError
# CbfNode is a Rust-only trait - it's a wrapper around a Rust implementation.
class CbfNode():
    """
    A [`CbfNode`] gathers transactions for a [`Wallet`].
    To receive [`Update`] for [`Wallet`], refer to the
    [`CbfClient`]. The [`CbfNode`] will run until instructed
    to stop.
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_cbfnode, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_cbfnode, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def run(self, ) -> None:
        """
        Start the node on a detached OS thread and immediately return.
        """

        _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_cbfnode_run,self._uniffi_clone_pointer(),)







class _UniffiConverterTypeCbfNode:

    @staticmethod
    def lift(value: int):
        return CbfNode._make_instance_(value)

    @staticmethod
    def check_lower(value: CbfNode):
        if not isinstance(value, CbfNode):
            raise TypeError("Expected CbfNode instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: CbfNodeProtocol):
        if not isinstance(value, CbfNode):
            raise TypeError("Expected CbfNode instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: CbfNodeProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class ChangeSetProtocol(typing.Protocol):
    def change_descriptor(self, ):
        """
        Get the change `Descriptor`
        """

        raise NotImplementedError
    def descriptor(self, ):
        """
        Get the receiving `Descriptor`.
        """

        raise NotImplementedError
    def indexer_changeset(self, ):
        """
        Get the changes to the indexer.
        """

        raise NotImplementedError
    def localchain_changeset(self, ):
        """
        Get the changes to the local chain.
        """

        raise NotImplementedError
    def network(self, ):
        """
        Get the `Network`
        """

        raise NotImplementedError
    def tx_graph_changeset(self, ):
        """
        Get the changes to the transaction graph.
        """

        raise NotImplementedError
# ChangeSet is a Rust-only trait - it's a wrapper around a Rust implementation.
class ChangeSet():
    _pointer: ctypes.c_void_p
    def __init__(self, ):
        """
        Create an empty `ChangeSet`.
        """

        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_changeset, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_changeset, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst
    @classmethod
    def from_aggregate(cls, descriptor: "typing.Optional[Descriptor]",change_descriptor: "typing.Optional[Descriptor]",network: "typing.Optional[Network]",local_chain: "LocalChainChangeSet",tx_graph: "TxGraphChangeSet",indexer: "IndexerChangeSet"):
        _UniffiConverterOptionalTypeDescriptor.check_lower(descriptor)
        
        _UniffiConverterOptionalTypeDescriptor.check_lower(change_descriptor)
        
        _UniffiConverterOptionalTypeNetwork.check_lower(network)
        
        _UniffiConverterTypeLocalChainChangeSet.check_lower(local_chain)
        
        _UniffiConverterTypeTxGraphChangeSet.check_lower(tx_graph)
        
        _UniffiConverterTypeIndexerChangeSet.check_lower(indexer)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_from_aggregate,
        _UniffiConverterOptionalTypeDescriptor.lower(descriptor),
        _UniffiConverterOptionalTypeDescriptor.lower(change_descriptor),
        _UniffiConverterOptionalTypeNetwork.lower(network),
        _UniffiConverterTypeLocalChainChangeSet.lower(local_chain),
        _UniffiConverterTypeTxGraphChangeSet.lower(tx_graph),
        _UniffiConverterTypeIndexerChangeSet.lower(indexer))
        return cls._make_instance_(pointer)

    @classmethod
    def from_descriptor_and_network(cls, descriptor: "typing.Optional[Descriptor]",change_descriptor: "typing.Optional[Descriptor]",network: "typing.Optional[Network]"):
        _UniffiConverterOptionalTypeDescriptor.check_lower(descriptor)
        
        _UniffiConverterOptionalTypeDescriptor.check_lower(change_descriptor)
        
        _UniffiConverterOptionalTypeNetwork.check_lower(network)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_from_descriptor_and_network,
        _UniffiConverterOptionalTypeDescriptor.lower(descriptor),
        _UniffiConverterOptionalTypeDescriptor.lower(change_descriptor),
        _UniffiConverterOptionalTypeNetwork.lower(network))
        return cls._make_instance_(pointer)

    @classmethod
    def from_indexer_changeset(cls, indexer_changes: "IndexerChangeSet"):
        """
        Start a wallet `ChangeSet` from indexer changes.
        """

        _UniffiConverterTypeIndexerChangeSet.check_lower(indexer_changes)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_from_indexer_changeset,
        _UniffiConverterTypeIndexerChangeSet.lower(indexer_changes))
        return cls._make_instance_(pointer)

    @classmethod
    def from_local_chain_changes(cls, local_chain_changes: "LocalChainChangeSet"):
        """
        Start a wallet `ChangeSet` from local chain changes.
        """

        _UniffiConverterTypeLocalChainChangeSet.check_lower(local_chain_changes)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_from_local_chain_changes,
        _UniffiConverterTypeLocalChainChangeSet.lower(local_chain_changes))
        return cls._make_instance_(pointer)

    @classmethod
    def from_merge(cls, left: "ChangeSet",right: "ChangeSet"):
        """
        Build a `ChangeSet` by merging together two `ChangeSet`.
        """

        _UniffiConverterTypeChangeSet.check_lower(left)
        
        _UniffiConverterTypeChangeSet.check_lower(right)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_from_merge,
        _UniffiConverterTypeChangeSet.lower(left),
        _UniffiConverterTypeChangeSet.lower(right))
        return cls._make_instance_(pointer)

    @classmethod
    def from_tx_graph_changeset(cls, tx_graph_changeset: "TxGraphChangeSet"):
        """
        Start a wallet `ChangeSet` from transaction graph changes.
        """

        _UniffiConverterTypeTxGraphChangeSet.check_lower(tx_graph_changeset)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_changeset_from_tx_graph_changeset,
        _UniffiConverterTypeTxGraphChangeSet.lower(tx_graph_changeset))
        return cls._make_instance_(pointer)



    def change_descriptor(self, ) -> "typing.Optional[Descriptor]":
        """
        Get the change `Descriptor`
        """

        return _UniffiConverterOptionalTypeDescriptor.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_changeset_change_descriptor,self._uniffi_clone_pointer(),)
        )





    def descriptor(self, ) -> "typing.Optional[Descriptor]":
        """
        Get the receiving `Descriptor`.
        """

        return _UniffiConverterOptionalTypeDescriptor.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_changeset_descriptor,self._uniffi_clone_pointer(),)
        )





    def indexer_changeset(self, ) -> "IndexerChangeSet":
        """
        Get the changes to the indexer.
        """

        return _UniffiConverterTypeIndexerChangeSet.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_changeset_indexer_changeset,self._uniffi_clone_pointer(),)
        )





    def localchain_changeset(self, ) -> "LocalChainChangeSet":
        """
        Get the changes to the local chain.
        """

        return _UniffiConverterTypeLocalChainChangeSet.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_changeset_localchain_changeset,self._uniffi_clone_pointer(),)
        )





    def network(self, ) -> "typing.Optional[Network]":
        """
        Get the `Network`
        """

        return _UniffiConverterOptionalTypeNetwork.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_changeset_network,self._uniffi_clone_pointer(),)
        )





    def tx_graph_changeset(self, ) -> "TxGraphChangeSet":
        """
        Get the changes to the transaction graph.
        """

        return _UniffiConverterTypeTxGraphChangeSet.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_changeset_tx_graph_changeset,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeChangeSet:

    @staticmethod
    def lift(value: int):
        return ChangeSet._make_instance_(value)

    @staticmethod
    def check_lower(value: ChangeSet):
        if not isinstance(value, ChangeSet):
            raise TypeError("Expected ChangeSet instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ChangeSetProtocol):
        if not isinstance(value, ChangeSet):
            raise TypeError("Expected ChangeSet instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ChangeSetProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class DerivationPathProtocol(typing.Protocol):
    """
    A BIP-32 derivation path.
    """

    pass
# DerivationPath is a Rust-only trait - it's a wrapper around a Rust implementation.
class DerivationPath():
    """
    A BIP-32 derivation path.
    """

    _pointer: ctypes.c_void_p
    def __init__(self, path: "str"):
        """
        Parse a string as a BIP-32 derivation path.
        """

        _UniffiConverterString.check_lower(path)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeBip32Error,_UniffiLib.uniffi_bdkffi_fn_constructor_derivationpath_new,
        _UniffiConverterString.lower(path))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_derivationpath, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_derivationpath, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst



class _UniffiConverterTypeDerivationPath:

    @staticmethod
    def lift(value: int):
        return DerivationPath._make_instance_(value)

    @staticmethod
    def check_lower(value: DerivationPath):
        if not isinstance(value, DerivationPath):
            raise TypeError("Expected DerivationPath instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: DerivationPathProtocol):
        if not isinstance(value, DerivationPath):
            raise TypeError("Expected DerivationPath instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: DerivationPathProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class DescriptorProtocol(typing.Protocol):
    """
    An expression of how to derive output scripts: https://github.com/bitcoin/bitcoin/blob/master/doc/descriptors.md
    """

    def descriptor_id(self, ):
        """
        A unique identifier for the descriptor.
        """

        raise NotImplementedError
    def is_multipath(self, ):
        """
        Does this descriptor contain paths: https://github.com/bitcoin/bips/blob/master/bip-0389.mediawiki
        """

        raise NotImplementedError
    def max_weight_to_satisfy(self, ):
        """
        Computes an upper bound on the difference between a non-satisfied `TxIn`'s
        `segwit_weight` and a satisfied `TxIn`'s `segwit_weight`.
        """

        raise NotImplementedError
    def to_single_descriptors(self, ):
        """
        Return descriptors for all valid paths.
        """

        raise NotImplementedError
    def to_string_with_secret(self, ):
        """
        Dangerously convert the descriptor to a string.
        """

        raise NotImplementedError
# Descriptor is a Rust-only trait - it's a wrapper around a Rust implementation.
class Descriptor():
    """
    An expression of how to derive output scripts: https://github.com/bitcoin/bitcoin/blob/master/doc/descriptors.md
    """

    _pointer: ctypes.c_void_p
    def __init__(self, descriptor: "str",network: "Network"):
        """
        Parse a string as a descriptor for the given network.
        """

        _UniffiConverterString.check_lower(descriptor)
        
        _UniffiConverterTypeNetwork.check_lower(network)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeDescriptorError,_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new,
        _UniffiConverterString.lower(descriptor),
        _UniffiConverterTypeNetwork.lower(network))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_descriptor, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_descriptor, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst
    @classmethod
    def new_bip44(cls, secret_key: "DescriptorSecretKey",keychain_kind: "KeychainKind",network: "Network"):
        """
        Multi-account hierarchy descriptor: https://github.com/bitcoin/bips/blob/master/bip-0044.mediawiki
        """

        _UniffiConverterTypeDescriptorSecretKey.check_lower(secret_key)
        
        _UniffiConverterTypeKeychainKind.check_lower(keychain_kind)
        
        _UniffiConverterTypeNetwork.check_lower(network)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip44,
        _UniffiConverterTypeDescriptorSecretKey.lower(secret_key),
        _UniffiConverterTypeKeychainKind.lower(keychain_kind),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)

    @classmethod
    def new_bip44_public(cls, public_key: "DescriptorPublicKey",fingerprint: "str",keychain_kind: "KeychainKind",network: "Network"):
        """
        Multi-account hierarchy descriptor: https://github.com/bitcoin/bips/blob/master/bip-0044.mediawiki
        """

        _UniffiConverterTypeDescriptorPublicKey.check_lower(public_key)
        
        _UniffiConverterString.check_lower(fingerprint)
        
        _UniffiConverterTypeKeychainKind.check_lower(keychain_kind)
        
        _UniffiConverterTypeNetwork.check_lower(network)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip44_public,
        _UniffiConverterTypeDescriptorPublicKey.lower(public_key),
        _UniffiConverterString.lower(fingerprint),
        _UniffiConverterTypeKeychainKind.lower(keychain_kind),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)

    @classmethod
    def new_bip49(cls, secret_key: "DescriptorSecretKey",keychain_kind: "KeychainKind",network: "Network"):
        """
        P2SH nested P2WSH descriptor: https://github.com/bitcoin/bips/blob/master/bip-0049.mediawiki
        """

        _UniffiConverterTypeDescriptorSecretKey.check_lower(secret_key)
        
        _UniffiConverterTypeKeychainKind.check_lower(keychain_kind)
        
        _UniffiConverterTypeNetwork.check_lower(network)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip49,
        _UniffiConverterTypeDescriptorSecretKey.lower(secret_key),
        _UniffiConverterTypeKeychainKind.lower(keychain_kind),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)

    @classmethod
    def new_bip49_public(cls, public_key: "DescriptorPublicKey",fingerprint: "str",keychain_kind: "KeychainKind",network: "Network"):
        """
        P2SH nested P2WSH descriptor: https://github.com/bitcoin/bips/blob/master/bip-0049.mediawiki
        """

        _UniffiConverterTypeDescriptorPublicKey.check_lower(public_key)
        
        _UniffiConverterString.check_lower(fingerprint)
        
        _UniffiConverterTypeKeychainKind.check_lower(keychain_kind)
        
        _UniffiConverterTypeNetwork.check_lower(network)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip49_public,
        _UniffiConverterTypeDescriptorPublicKey.lower(public_key),
        _UniffiConverterString.lower(fingerprint),
        _UniffiConverterTypeKeychainKind.lower(keychain_kind),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)

    @classmethod
    def new_bip84(cls, secret_key: "DescriptorSecretKey",keychain_kind: "KeychainKind",network: "Network"):
        """
        Pay to witness PKH descriptor: https://github.com/bitcoin/bips/blob/master/bip-0084.mediawiki
        """

        _UniffiConverterTypeDescriptorSecretKey.check_lower(secret_key)
        
        _UniffiConverterTypeKeychainKind.check_lower(keychain_kind)
        
        _UniffiConverterTypeNetwork.check_lower(network)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip84,
        _UniffiConverterTypeDescriptorSecretKey.lower(secret_key),
        _UniffiConverterTypeKeychainKind.lower(keychain_kind),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)

    @classmethod
    def new_bip84_public(cls, public_key: "DescriptorPublicKey",fingerprint: "str",keychain_kind: "KeychainKind",network: "Network"):
        """
        Pay to witness PKH descriptor: https://github.com/bitcoin/bips/blob/master/bip-0084.mediawiki
        """

        _UniffiConverterTypeDescriptorPublicKey.check_lower(public_key)
        
        _UniffiConverterString.check_lower(fingerprint)
        
        _UniffiConverterTypeKeychainKind.check_lower(keychain_kind)
        
        _UniffiConverterTypeNetwork.check_lower(network)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip84_public,
        _UniffiConverterTypeDescriptorPublicKey.lower(public_key),
        _UniffiConverterString.lower(fingerprint),
        _UniffiConverterTypeKeychainKind.lower(keychain_kind),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)

    @classmethod
    def new_bip86(cls, secret_key: "DescriptorSecretKey",keychain_kind: "KeychainKind",network: "Network"):
        """
        Single key P2TR descriptor: https://github.com/bitcoin/bips/blob/master/bip-0086.mediawiki
        """

        _UniffiConverterTypeDescriptorSecretKey.check_lower(secret_key)
        
        _UniffiConverterTypeKeychainKind.check_lower(keychain_kind)
        
        _UniffiConverterTypeNetwork.check_lower(network)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip86,
        _UniffiConverterTypeDescriptorSecretKey.lower(secret_key),
        _UniffiConverterTypeKeychainKind.lower(keychain_kind),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)

    @classmethod
    def new_bip86_public(cls, public_key: "DescriptorPublicKey",fingerprint: "str",keychain_kind: "KeychainKind",network: "Network"):
        """
        Single key P2TR descriptor: https://github.com/bitcoin/bips/blob/master/bip-0086.mediawiki
        """

        _UniffiConverterTypeDescriptorPublicKey.check_lower(public_key)
        
        _UniffiConverterString.check_lower(fingerprint)
        
        _UniffiConverterTypeKeychainKind.check_lower(keychain_kind)
        
        _UniffiConverterTypeNetwork.check_lower(network)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_descriptor_new_bip86_public,
        _UniffiConverterTypeDescriptorPublicKey.lower(public_key),
        _UniffiConverterString.lower(fingerprint),
        _UniffiConverterTypeKeychainKind.lower(keychain_kind),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)



    def descriptor_id(self, ) -> "DescriptorId":
        """
        A unique identifier for the descriptor.
        """

        return _UniffiConverterTypeDescriptorId.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptor_descriptor_id,self._uniffi_clone_pointer(),)
        )





    def is_multipath(self, ) -> "bool":
        """
        Does this descriptor contain paths: https://github.com/bitcoin/bips/blob/master/bip-0389.mediawiki
        """

        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptor_is_multipath,self._uniffi_clone_pointer(),)
        )





    def max_weight_to_satisfy(self, ) -> "int":
        """
        Computes an upper bound on the difference between a non-satisfied `TxIn`'s
        `segwit_weight` and a satisfied `TxIn`'s `segwit_weight`.
        """

        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeDescriptorError,_UniffiLib.uniffi_bdkffi_fn_method_descriptor_max_weight_to_satisfy,self._uniffi_clone_pointer(),)
        )





    def to_single_descriptors(self, ) -> "typing.List[Descriptor]":
        """
        Return descriptors for all valid paths.
        """

        return _UniffiConverterSequenceTypeDescriptor.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeMiniscriptError,_UniffiLib.uniffi_bdkffi_fn_method_descriptor_to_single_descriptors,self._uniffi_clone_pointer(),)
        )





    def to_string_with_secret(self, ) -> "str":
        """
        Dangerously convert the descriptor to a string.
        """

        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptor_to_string_with_secret,self._uniffi_clone_pointer(),)
        )





    def __repr__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptor_uniffi_trait_debug,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptor_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeDescriptor:

    @staticmethod
    def lift(value: int):
        return Descriptor._make_instance_(value)

    @staticmethod
    def check_lower(value: Descriptor):
        if not isinstance(value, Descriptor):
            raise TypeError("Expected Descriptor instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: DescriptorProtocol):
        if not isinstance(value, Descriptor):
            raise TypeError("Expected Descriptor instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: DescriptorProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class DescriptorIdProtocol(typing.Protocol):
    """
    A collision-proof unique identifier for a descriptor.
    """

    def serialize(self, ):
        """
        Serialize this type into a 32 byte array.
        """

        raise NotImplementedError
# DescriptorId is a Rust-only trait - it's a wrapper around a Rust implementation.
class DescriptorId():
    """
    A collision-proof unique identifier for a descriptor.
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_descriptorid, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_descriptorid, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst
    @classmethod
    def from_bytes(cls, bytes: "bytes"):
        """
        Construct a hash-like type from 32 bytes.
        """

        _UniffiConverterBytes.check_lower(bytes)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeHashParseError,_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorid_from_bytes,
        _UniffiConverterBytes.lower(bytes))
        return cls._make_instance_(pointer)

    @classmethod
    def from_string(cls, hex: "str"):
        """
        Construct a hash-like type from a hex string.
        """

        _UniffiConverterString.check_lower(hex)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeHashParseError,_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorid_from_string,
        _UniffiConverterString.lower(hex))
        return cls._make_instance_(pointer)



    def serialize(self, ) -> "bytes":
        """
        Serialize this type into a 32 byte array.
        """

        return _UniffiConverterBytes.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptorid_serialize,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptorid_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )



    def __eq__(self, other: object) -> bool:
        if not isinstance(other, DescriptorId):
            return NotImplemented

        return _UniffiConverterBool.lift(_uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptorid_uniffi_trait_eq_eq,self._uniffi_clone_pointer(),
        _UniffiConverterTypeDescriptorId.lower(other)))

    def __ne__(self, other: object) -> bool:
        if not isinstance(other, DescriptorId):
            return NotImplemented

        return _UniffiConverterBool.lift(_uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptorid_uniffi_trait_eq_ne,self._uniffi_clone_pointer(),
        _UniffiConverterTypeDescriptorId.lower(other)))


    def __hash__(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptorid_uniffi_trait_hash,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeDescriptorId:

    @staticmethod
    def lift(value: int):
        return DescriptorId._make_instance_(value)

    @staticmethod
    def check_lower(value: DescriptorId):
        if not isinstance(value, DescriptorId):
            raise TypeError("Expected DescriptorId instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: DescriptorIdProtocol):
        if not isinstance(value, DescriptorId):
            raise TypeError("Expected DescriptorId instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: DescriptorIdProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class DescriptorPublicKeyProtocol(typing.Protocol):
    """
    A descriptor public key.
    """

    def derive(self, path: "DerivationPath"):
        """
        Derive the descriptor public key at the given derivation path.
        """

        raise NotImplementedError
    def extend(self, path: "DerivationPath"):
        """
        Extend the descriptor public key by the given derivation path.
        """

        raise NotImplementedError
    def is_multipath(self, ):
        """
        Whether or not this key has multiple derivation paths.
        """

        raise NotImplementedError
    def master_fingerprint(self, ):
        """
        The fingerprint of the master key associated with this key, `0x00000000` if none.
        """

        raise NotImplementedError
# DescriptorPublicKey is a Rust-only trait - it's a wrapper around a Rust implementation.
class DescriptorPublicKey():
    """
    A descriptor public key.
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_descriptorpublickey, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_descriptorpublickey, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst
    @classmethod
    def from_string(cls, public_key: "str"):
        """
        Attempt to parse a string as a descriptor public key.
        """

        _UniffiConverterString.check_lower(public_key)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeDescriptorKeyError,_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorpublickey_from_string,
        _UniffiConverterString.lower(public_key))
        return cls._make_instance_(pointer)



    def derive(self, path: "DerivationPath") -> "DescriptorPublicKey":
        """
        Derive the descriptor public key at the given derivation path.
        """

        _UniffiConverterTypeDerivationPath.check_lower(path)
        
        return _UniffiConverterTypeDescriptorPublicKey.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeDescriptorKeyError,_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_derive,self._uniffi_clone_pointer(),
        _UniffiConverterTypeDerivationPath.lower(path))
        )





    def extend(self, path: "DerivationPath") -> "DescriptorPublicKey":
        """
        Extend the descriptor public key by the given derivation path.
        """

        _UniffiConverterTypeDerivationPath.check_lower(path)
        
        return _UniffiConverterTypeDescriptorPublicKey.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeDescriptorKeyError,_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_extend,self._uniffi_clone_pointer(),
        _UniffiConverterTypeDerivationPath.lower(path))
        )





    def is_multipath(self, ) -> "bool":
        """
        Whether or not this key has multiple derivation paths.
        """

        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_is_multipath,self._uniffi_clone_pointer(),)
        )





    def master_fingerprint(self, ) -> "str":
        """
        The fingerprint of the master key associated with this key, `0x00000000` if none.
        """

        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_master_fingerprint,self._uniffi_clone_pointer(),)
        )





    def __repr__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_uniffi_trait_debug,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptorpublickey_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeDescriptorPublicKey:

    @staticmethod
    def lift(value: int):
        return DescriptorPublicKey._make_instance_(value)

    @staticmethod
    def check_lower(value: DescriptorPublicKey):
        if not isinstance(value, DescriptorPublicKey):
            raise TypeError("Expected DescriptorPublicKey instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: DescriptorPublicKeyProtocol):
        if not isinstance(value, DescriptorPublicKey):
            raise TypeError("Expected DescriptorPublicKey instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: DescriptorPublicKeyProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class DescriptorSecretKeyProtocol(typing.Protocol):
    """
    A descriptor containing secret data.
    """

    def as_public(self, ):
        """
        Return the descriptor public key corresponding to this secret.
        """

        raise NotImplementedError
    def derive(self, path: "DerivationPath"):
        """
        Derive a descriptor secret key at a given derivation path.
        """

        raise NotImplementedError
    def extend(self, path: "DerivationPath"):
        """
        Extend the descriptor secret key by the derivation path.
        """

        raise NotImplementedError
    def secret_bytes(self, ):
        """
        Return the bytes of this descriptor secret key.
        """

        raise NotImplementedError
# DescriptorSecretKey is a Rust-only trait - it's a wrapper around a Rust implementation.
class DescriptorSecretKey():
    """
    A descriptor containing secret data.
    """

    _pointer: ctypes.c_void_p
    def __init__(self, network: "Network",mnemonic: "Mnemonic",password: "typing.Optional[str]"):
        """
        Construct a secret descriptor using a mnemonic.
        """

        _UniffiConverterTypeNetwork.check_lower(network)
        
        _UniffiConverterTypeMnemonic.check_lower(mnemonic)
        
        _UniffiConverterOptionalString.check_lower(password)
        
        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorsecretkey_new,
        _UniffiConverterTypeNetwork.lower(network),
        _UniffiConverterTypeMnemonic.lower(mnemonic),
        _UniffiConverterOptionalString.lower(password))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_descriptorsecretkey, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_descriptorsecretkey, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst
    @classmethod
    def from_string(cls, private_key: "str"):
        """
        Attempt to parse a string as a descriptor secret key.
        """

        _UniffiConverterString.check_lower(private_key)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeDescriptorKeyError,_UniffiLib.uniffi_bdkffi_fn_constructor_descriptorsecretkey_from_string,
        _UniffiConverterString.lower(private_key))
        return cls._make_instance_(pointer)



    def as_public(self, ) -> "DescriptorPublicKey":
        """
        Return the descriptor public key corresponding to this secret.
        """

        return _UniffiConverterTypeDescriptorPublicKey.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_as_public,self._uniffi_clone_pointer(),)
        )





    def derive(self, path: "DerivationPath") -> "DescriptorSecretKey":
        """
        Derive a descriptor secret key at a given derivation path.
        """

        _UniffiConverterTypeDerivationPath.check_lower(path)
        
        return _UniffiConverterTypeDescriptorSecretKey.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeDescriptorKeyError,_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_derive,self._uniffi_clone_pointer(),
        _UniffiConverterTypeDerivationPath.lower(path))
        )





    def extend(self, path: "DerivationPath") -> "DescriptorSecretKey":
        """
        Extend the descriptor secret key by the derivation path.
        """

        _UniffiConverterTypeDerivationPath.check_lower(path)
        
        return _UniffiConverterTypeDescriptorSecretKey.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeDescriptorKeyError,_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_extend,self._uniffi_clone_pointer(),
        _UniffiConverterTypeDerivationPath.lower(path))
        )





    def secret_bytes(self, ) -> "bytes":
        """
        Return the bytes of this descriptor secret key.
        """

        return _UniffiConverterBytes.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_secret_bytes,self._uniffi_clone_pointer(),)
        )





    def __repr__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_uniffi_trait_debug,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_descriptorsecretkey_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeDescriptorSecretKey:

    @staticmethod
    def lift(value: int):
        return DescriptorSecretKey._make_instance_(value)

    @staticmethod
    def check_lower(value: DescriptorSecretKey):
        if not isinstance(value, DescriptorSecretKey):
            raise TypeError("Expected DescriptorSecretKey instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: DescriptorSecretKeyProtocol):
        if not isinstance(value, DescriptorSecretKey):
            raise TypeError("Expected DescriptorSecretKey instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: DescriptorSecretKeyProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class ElectrumClientProtocol(typing.Protocol):
    """
    Wrapper around an electrum_client::ElectrumApi which includes an internal in-memory transaction
    cache to avoid re-fetching already downloaded transactions.
    """

    def block_headers_subscribe(self, ):
        """
        Subscribes to notifications for new block headers, by sending a blockchain.headers.subscribe call.
        """

        raise NotImplementedError
    def estimate_fee(self, number: "int"):
        """
        Estimates the fee required in bitcoin per kilobyte to confirm a transaction in `number` blocks.
        """

        raise NotImplementedError
    def full_scan(self, request: "FullScanRequest",stop_gap: "int",batch_size: "int",fetch_prev_txouts: "bool"):
        """
        Full scan the keychain scripts specified with the blockchain (via an Electrum client) and
        returns updates for bdk_chain data structures.

        - `request`: struct with data required to perform a spk-based blockchain client
        full scan, see `FullScanRequest`.
        - `stop_gap`: the full scan for each keychain stops after a gap of script pubkeys with no
        associated transactions.
        - `batch_size`: specifies the max number of script pubkeys to request for in a single batch
        request.
        - `fetch_prev_txouts`: specifies whether we want previous `TxOuts` for fee calculation. Note
        that this requires additional calls to the Electrum server, but is necessary for
        calculating the fee on a transaction if your wallet does not own the inputs. Methods like
        `Wallet.calculate_fee` and `Wallet.calculate_fee_rate` will return a
        `CalculateFeeError::MissingTxOut` error if those TxOuts are not present in the transaction
        graph.
        """

        raise NotImplementedError
    def ping(self, ):
        """
        Pings the server.
        """

        raise NotImplementedError
    def server_features(self, ):
        """
        Returns the capabilities of the server.
        """

        raise NotImplementedError
    def sync(self, request: "SyncRequest",batch_size: "int",fetch_prev_txouts: "bool"):
        """
        Sync a set of scripts with the blockchain (via an Electrum client) for the data specified and returns updates for bdk_chain data structures.

        - `request`: struct with data required to perform a spk-based blockchain client
        sync, see `SyncRequest`.
        - `batch_size`: specifies the max number of script pubkeys to request for in a single batch
        request.
        - `fetch_prev_txouts`: specifies whether we want previous `TxOuts` for fee calculation. Note
        that this requires additional calls to the Electrum server, but is necessary for
        calculating the fee on a transaction if your wallet does not own the inputs. Methods like
        `Wallet.calculate_fee` and `Wallet.calculate_fee_rate` will return a
        `CalculateFeeError::MissingTxOut` error if those TxOuts are not present in the transaction
        graph.

        If the scripts to sync are unknown, such as when restoring or importing a keychain that may
        include scripts that have been used, use full_scan with the keychain.
        """

        raise NotImplementedError
    def transaction_broadcast(self, tx: "Transaction"):
        """
        Broadcasts a transaction to the network.
        """

        raise NotImplementedError
# ElectrumClient is a Rust-only trait - it's a wrapper around a Rust implementation.
class ElectrumClient():
    """
    Wrapper around an electrum_client::ElectrumApi which includes an internal in-memory transaction
    cache to avoid re-fetching already downloaded transactions.
    """

    _pointer: ctypes.c_void_p
    def __init__(self, url: "str",socks5: "typing.Union[object, typing.Optional[str]]" = _DEFAULT):
        """
        Creates a new bdk client from a electrum_client::ElectrumApi
        Optional: Set the proxy of the builder
        """

        _UniffiConverterString.check_lower(url)
        
        if socks5 is _DEFAULT:
            socks5 = None
        _UniffiConverterOptionalString.check_lower(socks5)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeElectrumError,_UniffiLib.uniffi_bdkffi_fn_constructor_electrumclient_new,
        _UniffiConverterString.lower(url),
        _UniffiConverterOptionalString.lower(socks5))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_electrumclient, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_electrumclient, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def block_headers_subscribe(self, ) -> "HeaderNotification":
        """
        Subscribes to notifications for new block headers, by sending a blockchain.headers.subscribe call.
        """

        return _UniffiConverterTypeHeaderNotification.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeElectrumError,_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_block_headers_subscribe,self._uniffi_clone_pointer(),)
        )





    def estimate_fee(self, number: "int") -> "float":
        """
        Estimates the fee required in bitcoin per kilobyte to confirm a transaction in `number` blocks.
        """

        _UniffiConverterUInt64.check_lower(number)
        
        return _UniffiConverterDouble.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeElectrumError,_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_estimate_fee,self._uniffi_clone_pointer(),
        _UniffiConverterUInt64.lower(number))
        )





    def full_scan(self, request: "FullScanRequest",stop_gap: "int",batch_size: "int",fetch_prev_txouts: "bool") -> "Update":
        """
        Full scan the keychain scripts specified with the blockchain (via an Electrum client) and
        returns updates for bdk_chain data structures.

        - `request`: struct with data required to perform a spk-based blockchain client
        full scan, see `FullScanRequest`.
        - `stop_gap`: the full scan for each keychain stops after a gap of script pubkeys with no
        associated transactions.
        - `batch_size`: specifies the max number of script pubkeys to request for in a single batch
        request.
        - `fetch_prev_txouts`: specifies whether we want previous `TxOuts` for fee calculation. Note
        that this requires additional calls to the Electrum server, but is necessary for
        calculating the fee on a transaction if your wallet does not own the inputs. Methods like
        `Wallet.calculate_fee` and `Wallet.calculate_fee_rate` will return a
        `CalculateFeeError::MissingTxOut` error if those TxOuts are not present in the transaction
        graph.
        """

        _UniffiConverterTypeFullScanRequest.check_lower(request)
        
        _UniffiConverterUInt64.check_lower(stop_gap)
        
        _UniffiConverterUInt64.check_lower(batch_size)
        
        _UniffiConverterBool.check_lower(fetch_prev_txouts)
        
        return _UniffiConverterTypeUpdate.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeElectrumError,_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_full_scan,self._uniffi_clone_pointer(),
        _UniffiConverterTypeFullScanRequest.lower(request),
        _UniffiConverterUInt64.lower(stop_gap),
        _UniffiConverterUInt64.lower(batch_size),
        _UniffiConverterBool.lower(fetch_prev_txouts))
        )





    def ping(self, ) -> None:
        """
        Pings the server.
        """

        _uniffi_rust_call_with_error(_UniffiConverterTypeElectrumError,_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_ping,self._uniffi_clone_pointer(),)






    def server_features(self, ) -> "ServerFeaturesRes":
        """
        Returns the capabilities of the server.
        """

        return _UniffiConverterTypeServerFeaturesRes.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeElectrumError,_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_server_features,self._uniffi_clone_pointer(),)
        )





    def sync(self, request: "SyncRequest",batch_size: "int",fetch_prev_txouts: "bool") -> "Update":
        """
        Sync a set of scripts with the blockchain (via an Electrum client) for the data specified and returns updates for bdk_chain data structures.

        - `request`: struct with data required to perform a spk-based blockchain client
        sync, see `SyncRequest`.
        - `batch_size`: specifies the max number of script pubkeys to request for in a single batch
        request.
        - `fetch_prev_txouts`: specifies whether we want previous `TxOuts` for fee calculation. Note
        that this requires additional calls to the Electrum server, but is necessary for
        calculating the fee on a transaction if your wallet does not own the inputs. Methods like
        `Wallet.calculate_fee` and `Wallet.calculate_fee_rate` will return a
        `CalculateFeeError::MissingTxOut` error if those TxOuts are not present in the transaction
        graph.

        If the scripts to sync are unknown, such as when restoring or importing a keychain that may
        include scripts that have been used, use full_scan with the keychain.
        """

        _UniffiConverterTypeSyncRequest.check_lower(request)
        
        _UniffiConverterUInt64.check_lower(batch_size)
        
        _UniffiConverterBool.check_lower(fetch_prev_txouts)
        
        return _UniffiConverterTypeUpdate.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeElectrumError,_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_sync,self._uniffi_clone_pointer(),
        _UniffiConverterTypeSyncRequest.lower(request),
        _UniffiConverterUInt64.lower(batch_size),
        _UniffiConverterBool.lower(fetch_prev_txouts))
        )





    def transaction_broadcast(self, tx: "Transaction") -> "Txid":
        """
        Broadcasts a transaction to the network.
        """

        _UniffiConverterTypeTransaction.check_lower(tx)
        
        return _UniffiConverterTypeTxid.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeElectrumError,_UniffiLib.uniffi_bdkffi_fn_method_electrumclient_transaction_broadcast,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTransaction.lower(tx))
        )






class _UniffiConverterTypeElectrumClient:

    @staticmethod
    def lift(value: int):
        return ElectrumClient._make_instance_(value)

    @staticmethod
    def check_lower(value: ElectrumClient):
        if not isinstance(value, ElectrumClient):
            raise TypeError("Expected ElectrumClient instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ElectrumClientProtocol):
        if not isinstance(value, ElectrumClient):
            raise TypeError("Expected ElectrumClient instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ElectrumClientProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class EsploraClientProtocol(typing.Protocol):
    """
    Wrapper around an esplora_client::BlockingClient which includes an internal in-memory transaction
    cache to avoid re-fetching already downloaded transactions.
    """

    def broadcast(self, transaction: "Transaction"):
        """
        Broadcast a [`Transaction`] to Esplora.
        """

        raise NotImplementedError
    def full_scan(self, request: "FullScanRequest",stop_gap: "int",parallel_requests: "int"):
        """
        Scan keychain scripts for transactions against Esplora, returning an update that can be
        applied to the receiving structures.

        `request` provides the data required to perform a script-pubkey-based full scan
        (see [`FullScanRequest`]). The full scan for each keychain (`K`) stops after a gap of
        `stop_gap` script pubkeys with no associated transactions. `parallel_requests` specifies
        the maximum number of HTTP requests to make in parallel.
        """

        raise NotImplementedError
    def get_block_hash(self, block_height: "int"):
        """
        Get the [`BlockHash`] of a specific block height.
        """

        raise NotImplementedError
    def get_fee_estimates(self, ):
        """
        Get a map where the key is the confirmation target (in number of
        blocks) and the value is the estimated feerate (in sat/vB).
        """

        raise NotImplementedError
    def get_height(self, ):
        """
        Get the height of the current blockchain tip.
        """

        raise NotImplementedError
    def get_tx(self, txid: "Txid"):
        """
        Get a [`Transaction`] option given its [`Txid`].
        """

        raise NotImplementedError
    def get_tx_info(self, txid: "Txid"):
        """
        Get transaction info given its [`Txid`].
        """

        raise NotImplementedError
    def get_tx_status(self, txid: "Txid"):
        """
        Get the status of a [`Transaction`] given its [`Txid`].
        """

        raise NotImplementedError
    def sync(self, request: "SyncRequest",parallel_requests: "int"):
        """
        Sync a set of scripts, txids, and/or outpoints against Esplora.

        `request` provides the data required to perform a script-pubkey-based sync (see
        [`SyncRequest`]). `parallel_requests` specifies the maximum number of HTTP requests to make
        in parallel.
        """

        raise NotImplementedError
# EsploraClient is a Rust-only trait - it's a wrapper around a Rust implementation.
class EsploraClient():
    """
    Wrapper around an esplora_client::BlockingClient which includes an internal in-memory transaction
    cache to avoid re-fetching already downloaded transactions.
    """

    _pointer: ctypes.c_void_p
    def __init__(self, url: "str",proxy: "typing.Union[object, typing.Optional[str]]" = _DEFAULT):
        """
        Creates a new bdk client from an esplora_client::BlockingClient.
        Optional: Set the proxy of the builder.
        """

        _UniffiConverterString.check_lower(url)
        
        if proxy is _DEFAULT:
            proxy = None
        _UniffiConverterOptionalString.check_lower(proxy)
        
        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_esploraclient_new,
        _UniffiConverterString.lower(url),
        _UniffiConverterOptionalString.lower(proxy))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_esploraclient, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_esploraclient, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def broadcast(self, transaction: "Transaction") -> None:
        """
        Broadcast a [`Transaction`] to Esplora.
        """

        _UniffiConverterTypeTransaction.check_lower(transaction)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeEsploraError,_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_broadcast,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTransaction.lower(transaction))






    def full_scan(self, request: "FullScanRequest",stop_gap: "int",parallel_requests: "int") -> "Update":
        """
        Scan keychain scripts for transactions against Esplora, returning an update that can be
        applied to the receiving structures.

        `request` provides the data required to perform a script-pubkey-based full scan
        (see [`FullScanRequest`]). The full scan for each keychain (`K`) stops after a gap of
        `stop_gap` script pubkeys with no associated transactions. `parallel_requests` specifies
        the maximum number of HTTP requests to make in parallel.
        """

        _UniffiConverterTypeFullScanRequest.check_lower(request)
        
        _UniffiConverterUInt64.check_lower(stop_gap)
        
        _UniffiConverterUInt64.check_lower(parallel_requests)
        
        return _UniffiConverterTypeUpdate.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeEsploraError,_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_full_scan,self._uniffi_clone_pointer(),
        _UniffiConverterTypeFullScanRequest.lower(request),
        _UniffiConverterUInt64.lower(stop_gap),
        _UniffiConverterUInt64.lower(parallel_requests))
        )





    def get_block_hash(self, block_height: "int") -> "BlockHash":
        """
        Get the [`BlockHash`] of a specific block height.
        """

        _UniffiConverterUInt32.check_lower(block_height)
        
        return _UniffiConverterTypeBlockHash.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeEsploraError,_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_get_block_hash,self._uniffi_clone_pointer(),
        _UniffiConverterUInt32.lower(block_height))
        )





    def get_fee_estimates(self, ) -> "dict[int, float]":
        """
        Get a map where the key is the confirmation target (in number of
        blocks) and the value is the estimated feerate (in sat/vB).
        """

        return _UniffiConverterMapUInt16Double.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeEsploraError,_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_get_fee_estimates,self._uniffi_clone_pointer(),)
        )





    def get_height(self, ) -> "int":
        """
        Get the height of the current blockchain tip.
        """

        return _UniffiConverterUInt32.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeEsploraError,_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_get_height,self._uniffi_clone_pointer(),)
        )





    def get_tx(self, txid: "Txid") -> "typing.Optional[Transaction]":
        """
        Get a [`Transaction`] option given its [`Txid`].
        """

        _UniffiConverterTypeTxid.check_lower(txid)
        
        return _UniffiConverterOptionalTypeTransaction.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeEsploraError,_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_get_tx,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTxid.lower(txid))
        )





    def get_tx_info(self, txid: "Txid") -> "typing.Optional[Tx]":
        """
        Get transaction info given its [`Txid`].
        """

        _UniffiConverterTypeTxid.check_lower(txid)
        
        return _UniffiConverterOptionalTypeTx.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeEsploraError,_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_get_tx_info,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTxid.lower(txid))
        )





    def get_tx_status(self, txid: "Txid") -> "TxStatus":
        """
        Get the status of a [`Transaction`] given its [`Txid`].
        """

        _UniffiConverterTypeTxid.check_lower(txid)
        
        return _UniffiConverterTypeTxStatus.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeEsploraError,_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_get_tx_status,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTxid.lower(txid))
        )





    def sync(self, request: "SyncRequest",parallel_requests: "int") -> "Update":
        """
        Sync a set of scripts, txids, and/or outpoints against Esplora.

        `request` provides the data required to perform a script-pubkey-based sync (see
        [`SyncRequest`]). `parallel_requests` specifies the maximum number of HTTP requests to make
        in parallel.
        """

        _UniffiConverterTypeSyncRequest.check_lower(request)
        
        _UniffiConverterUInt64.check_lower(parallel_requests)
        
        return _UniffiConverterTypeUpdate.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeEsploraError,_UniffiLib.uniffi_bdkffi_fn_method_esploraclient_sync,self._uniffi_clone_pointer(),
        _UniffiConverterTypeSyncRequest.lower(request),
        _UniffiConverterUInt64.lower(parallel_requests))
        )






class _UniffiConverterTypeEsploraClient:

    @staticmethod
    def lift(value: int):
        return EsploraClient._make_instance_(value)

    @staticmethod
    def check_lower(value: EsploraClient):
        if not isinstance(value, EsploraClient):
            raise TypeError("Expected EsploraClient instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: EsploraClientProtocol):
        if not isinstance(value, EsploraClient):
            raise TypeError("Expected EsploraClient instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: EsploraClientProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class FeeRateProtocol(typing.Protocol):
    """
    Represents fee rate.

    This is an integer type representing fee rate in sat/kwu. It provides protection against mixing
    up the types as well as basic formatting features.
    """

    def to_sat_per_kwu(self, ):
        raise NotImplementedError
    def to_sat_per_vb_ceil(self, ):
        raise NotImplementedError
    def to_sat_per_vb_floor(self, ):
        raise NotImplementedError
# FeeRate is a Rust-only trait - it's a wrapper around a Rust implementation.
class FeeRate():
    """
    Represents fee rate.

    This is an integer type representing fee rate in sat/kwu. It provides protection against mixing
    up the types as well as basic formatting features.
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_feerate, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_feerate, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst
    @classmethod
    def from_sat_per_kwu(cls, sat_kwu: "int"):
        _UniffiConverterUInt64.check_lower(sat_kwu)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_feerate_from_sat_per_kwu,
        _UniffiConverterUInt64.lower(sat_kwu))
        return cls._make_instance_(pointer)

    @classmethod
    def from_sat_per_vb(cls, sat_vb: "int"):
        _UniffiConverterUInt64.check_lower(sat_vb)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeFeeRateError,_UniffiLib.uniffi_bdkffi_fn_constructor_feerate_from_sat_per_vb,
        _UniffiConverterUInt64.lower(sat_vb))
        return cls._make_instance_(pointer)



    def to_sat_per_kwu(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_feerate_to_sat_per_kwu,self._uniffi_clone_pointer(),)
        )





    def to_sat_per_vb_ceil(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_feerate_to_sat_per_vb_ceil,self._uniffi_clone_pointer(),)
        )





    def to_sat_per_vb_floor(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_feerate_to_sat_per_vb_floor,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeFeeRate:

    @staticmethod
    def lift(value: int):
        return FeeRate._make_instance_(value)

    @staticmethod
    def check_lower(value: FeeRate):
        if not isinstance(value, FeeRate):
            raise TypeError("Expected FeeRate instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: FeeRateProtocol):
        if not isinstance(value, FeeRate):
            raise TypeError("Expected FeeRate instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: FeeRateProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class FullScanRequestProtocol(typing.Protocol):
    pass
# FullScanRequest is a Rust-only trait - it's a wrapper around a Rust implementation.
class FullScanRequest():
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_fullscanrequest, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_fullscanrequest, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst



class _UniffiConverterTypeFullScanRequest:

    @staticmethod
    def lift(value: int):
        return FullScanRequest._make_instance_(value)

    @staticmethod
    def check_lower(value: FullScanRequest):
        if not isinstance(value, FullScanRequest):
            raise TypeError("Expected FullScanRequest instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: FullScanRequestProtocol):
        if not isinstance(value, FullScanRequest):
            raise TypeError("Expected FullScanRequest instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: FullScanRequestProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class FullScanRequestBuilderProtocol(typing.Protocol):
    def build(self, ):
        raise NotImplementedError
    def inspect_spks_for_all_keychains(self, inspector: "FullScanScriptInspector"):
        raise NotImplementedError
# FullScanRequestBuilder is a Rust-only trait - it's a wrapper around a Rust implementation.
class FullScanRequestBuilder():
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_fullscanrequestbuilder, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_fullscanrequestbuilder, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def build(self, ) -> "FullScanRequest":
        return _UniffiConverterTypeFullScanRequest.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRequestBuilderError,_UniffiLib.uniffi_bdkffi_fn_method_fullscanrequestbuilder_build,self._uniffi_clone_pointer(),)
        )





    def inspect_spks_for_all_keychains(self, inspector: "FullScanScriptInspector") -> "FullScanRequestBuilder":
        _UniffiConverterTypeFullScanScriptInspector.check_lower(inspector)
        
        return _UniffiConverterTypeFullScanRequestBuilder.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRequestBuilderError,_UniffiLib.uniffi_bdkffi_fn_method_fullscanrequestbuilder_inspect_spks_for_all_keychains,self._uniffi_clone_pointer(),
        _UniffiConverterTypeFullScanScriptInspector.lower(inspector))
        )






class _UniffiConverterTypeFullScanRequestBuilder:

    @staticmethod
    def lift(value: int):
        return FullScanRequestBuilder._make_instance_(value)

    @staticmethod
    def check_lower(value: FullScanRequestBuilder):
        if not isinstance(value, FullScanRequestBuilder):
            raise TypeError("Expected FullScanRequestBuilder instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: FullScanRequestBuilderProtocol):
        if not isinstance(value, FullScanRequestBuilder):
            raise TypeError("Expected FullScanRequestBuilder instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: FullScanRequestBuilderProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class HashableOutPointProtocol(typing.Protocol):
    """
    An [`OutPoint`] used as a key in a hash map.

    Due to limitations in generating the foreign language bindings, we cannot use [`OutPoint`] as a
    key for hash maps.
    """

    def outpoint(self, ):
        """
        Get the internal [`OutPoint`]
        """

        raise NotImplementedError
# HashableOutPoint is a Rust-only trait - it's a wrapper around a Rust implementation.
class HashableOutPoint():
    """
    An [`OutPoint`] used as a key in a hash map.

    Due to limitations in generating the foreign language bindings, we cannot use [`OutPoint`] as a
    key for hash maps.
    """

    _pointer: ctypes.c_void_p
    def __init__(self, outpoint: "OutPoint"):
        """
        Create a key for a key-value store from an [`OutPoint`]
        """

        _UniffiConverterTypeOutPoint.check_lower(outpoint)
        
        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_hashableoutpoint_new,
        _UniffiConverterTypeOutPoint.lower(outpoint))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_hashableoutpoint, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_hashableoutpoint, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def outpoint(self, ) -> "OutPoint":
        """
        Get the internal [`OutPoint`]
        """

        return _UniffiConverterTypeOutPoint.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_hashableoutpoint_outpoint,self._uniffi_clone_pointer(),)
        )





    def __repr__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_hashableoutpoint_uniffi_trait_debug,self._uniffi_clone_pointer(),)
        )



    def __eq__(self, other: object) -> bool:
        if not isinstance(other, HashableOutPoint):
            return NotImplemented

        return _UniffiConverterBool.lift(_uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_hashableoutpoint_uniffi_trait_eq_eq,self._uniffi_clone_pointer(),
        _UniffiConverterTypeHashableOutPoint.lower(other)))

    def __ne__(self, other: object) -> bool:
        if not isinstance(other, HashableOutPoint):
            return NotImplemented

        return _UniffiConverterBool.lift(_uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_hashableoutpoint_uniffi_trait_eq_ne,self._uniffi_clone_pointer(),
        _UniffiConverterTypeHashableOutPoint.lower(other)))


    def __hash__(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_hashableoutpoint_uniffi_trait_hash,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeHashableOutPoint:

    @staticmethod
    def lift(value: int):
        return HashableOutPoint._make_instance_(value)

    @staticmethod
    def check_lower(value: HashableOutPoint):
        if not isinstance(value, HashableOutPoint):
            raise TypeError("Expected HashableOutPoint instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: HashableOutPointProtocol):
        if not isinstance(value, HashableOutPoint):
            raise TypeError("Expected HashableOutPoint instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: HashableOutPointProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class IpAddressProtocol(typing.Protocol):
    """
    An IP address to connect to over TCP.
    """

    pass
# IpAddress is a Rust-only trait - it's a wrapper around a Rust implementation.
class IpAddress():
    """
    An IP address to connect to over TCP.
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_ipaddress, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_ipaddress, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst
    @classmethod
    def from_ipv4(cls, q1: "int",q2: "int",q3: "int",q4: "int"):
        """
        Build an IPv4 address.
        """

        _UniffiConverterUInt8.check_lower(q1)
        
        _UniffiConverterUInt8.check_lower(q2)
        
        _UniffiConverterUInt8.check_lower(q3)
        
        _UniffiConverterUInt8.check_lower(q4)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_ipaddress_from_ipv4,
        _UniffiConverterUInt8.lower(q1),
        _UniffiConverterUInt8.lower(q2),
        _UniffiConverterUInt8.lower(q3),
        _UniffiConverterUInt8.lower(q4))
        return cls._make_instance_(pointer)

    @classmethod
    def from_ipv6(cls, a: "int",b: "int",c: "int",d: "int",e: "int",f: "int",g: "int",h: "int"):
        """
        Build an IPv6 address.
        """

        _UniffiConverterUInt16.check_lower(a)
        
        _UniffiConverterUInt16.check_lower(b)
        
        _UniffiConverterUInt16.check_lower(c)
        
        _UniffiConverterUInt16.check_lower(d)
        
        _UniffiConverterUInt16.check_lower(e)
        
        _UniffiConverterUInt16.check_lower(f)
        
        _UniffiConverterUInt16.check_lower(g)
        
        _UniffiConverterUInt16.check_lower(h)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_ipaddress_from_ipv6,
        _UniffiConverterUInt16.lower(a),
        _UniffiConverterUInt16.lower(b),
        _UniffiConverterUInt16.lower(c),
        _UniffiConverterUInt16.lower(d),
        _UniffiConverterUInt16.lower(e),
        _UniffiConverterUInt16.lower(f),
        _UniffiConverterUInt16.lower(g),
        _UniffiConverterUInt16.lower(h))
        return cls._make_instance_(pointer)




class _UniffiConverterTypeIpAddress:

    @staticmethod
    def lift(value: int):
        return IpAddress._make_instance_(value)

    @staticmethod
    def check_lower(value: IpAddress):
        if not isinstance(value, IpAddress):
            raise TypeError("Expected IpAddress instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: IpAddressProtocol):
        if not isinstance(value, IpAddress):
            raise TypeError("Expected IpAddress instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: IpAddressProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class MnemonicProtocol(typing.Protocol):
    """
    A mnemonic seed phrase to recover a BIP-32 wallet.
    """

    pass
# Mnemonic is a Rust-only trait - it's a wrapper around a Rust implementation.
class Mnemonic():
    """
    A mnemonic seed phrase to recover a BIP-32 wallet.
    """

    _pointer: ctypes.c_void_p
    def __init__(self, word_count: "WordCount"):
        """
        Generate a mnemonic given a word count.
        """

        _UniffiConverterTypeWordCount.check_lower(word_count)
        
        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_mnemonic_new,
        _UniffiConverterTypeWordCount.lower(word_count))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_mnemonic, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_mnemonic, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst
    @classmethod
    def from_entropy(cls, entropy: "bytes"):
        """
        Construct a mnemonic given an array of bytes. Note that using weak entropy will result in a loss
        of funds. To ensure the entropy is generated properly, read about your operating
        system specific ways to generate secure random numbers.
        """

        _UniffiConverterBytes.check_lower(entropy)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeBip39Error,_UniffiLib.uniffi_bdkffi_fn_constructor_mnemonic_from_entropy,
        _UniffiConverterBytes.lower(entropy))
        return cls._make_instance_(pointer)

    @classmethod
    def from_string(cls, mnemonic: "str"):
        """
        Parse a string as a mnemonic seed phrase.
        """

        _UniffiConverterString.check_lower(mnemonic)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeBip39Error,_UniffiLib.uniffi_bdkffi_fn_constructor_mnemonic_from_string,
        _UniffiConverterString.lower(mnemonic))
        return cls._make_instance_(pointer)



    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_mnemonic_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeMnemonic:

    @staticmethod
    def lift(value: int):
        return Mnemonic._make_instance_(value)

    @staticmethod
    def check_lower(value: Mnemonic):
        if not isinstance(value, Mnemonic):
            raise TypeError("Expected Mnemonic instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: MnemonicProtocol):
        if not isinstance(value, Mnemonic):
            raise TypeError("Expected Mnemonic instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: MnemonicProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class PersisterProtocol(typing.Protocol):
    """
    Wallet backend implementations.
    """

    pass
# Persister is a Rust-only trait - it's a wrapper around a Rust implementation.
class Persister():
    """
    Wallet backend implementations.
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_persister, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_persister, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst
    @classmethod
    def custom(cls, persistence: "Persistence"):
        """
        Use a native persistence layer.
        """

        _UniffiConverterTypePersistence.check_lower(persistence)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_persister_custom,
        _UniffiConverterTypePersistence.lower(persistence))
        return cls._make_instance_(pointer)

    @classmethod
    def new_in_memory(cls, ):
        """
        Create a new connection in memory.
        """

        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypePersistenceError,_UniffiLib.uniffi_bdkffi_fn_constructor_persister_new_in_memory,)
        return cls._make_instance_(pointer)

    @classmethod
    def new_sqlite(cls, path: "str"):
        """
        Create a new Sqlite connection at the specified file path.
        """

        _UniffiConverterString.check_lower(path)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypePersistenceError,_UniffiLib.uniffi_bdkffi_fn_constructor_persister_new_sqlite,
        _UniffiConverterString.lower(path))
        return cls._make_instance_(pointer)




class _UniffiConverterTypePersister:

    @staticmethod
    def lift(value: int):
        return Persister._make_instance_(value)

    @staticmethod
    def check_lower(value: Persister):
        if not isinstance(value, Persister):
            raise TypeError("Expected Persister instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: PersisterProtocol):
        if not isinstance(value, Persister):
            raise TypeError("Expected Persister instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: PersisterProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class PolicyProtocol(typing.Protocol):
    """
    Descriptor spending policy
    """

    def as_string(self, ):
        raise NotImplementedError
    def contribution(self, ):
        raise NotImplementedError
    def id(self, ):
        raise NotImplementedError
    def item(self, ):
        raise NotImplementedError
    def requires_path(self, ):
        raise NotImplementedError
    def satisfaction(self, ):
        raise NotImplementedError
# Policy is a Rust-only trait - it's a wrapper around a Rust implementation.
class Policy():
    """
    Descriptor spending policy
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_policy, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_policy, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def as_string(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_policy_as_string,self._uniffi_clone_pointer(),)
        )





    def contribution(self, ) -> "Satisfaction":
        return _UniffiConverterTypeSatisfaction.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_policy_contribution,self._uniffi_clone_pointer(),)
        )





    def id(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_policy_id,self._uniffi_clone_pointer(),)
        )





    def item(self, ) -> "SatisfiableItem":
        return _UniffiConverterTypeSatisfiableItem.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_policy_item,self._uniffi_clone_pointer(),)
        )





    def requires_path(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_policy_requires_path,self._uniffi_clone_pointer(),)
        )





    def satisfaction(self, ) -> "Satisfaction":
        return _UniffiConverterTypeSatisfaction.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_policy_satisfaction,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypePolicy:

    @staticmethod
    def lift(value: int):
        return Policy._make_instance_(value)

    @staticmethod
    def check_lower(value: Policy):
        if not isinstance(value, Policy):
            raise TypeError("Expected Policy instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: PolicyProtocol):
        if not isinstance(value, Policy):
            raise TypeError("Expected Policy instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: PolicyProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class PsbtProtocol(typing.Protocol):
    """
    A Partially Signed Transaction.
    """

    def combine(self, other: "Psbt"):
        """
        Combines this `Psbt` with `other` PSBT as described by BIP 174.

        In accordance with BIP 174 this function is commutative i.e., `A.combine(B) == B.combine(A)`
        """

        raise NotImplementedError
    def extract_tx(self, ):
        """
        Extracts the `Transaction` from a `Psbt` by filling in the available signature information.

        #### Errors

        `ExtractTxError` variants will contain either the `Psbt` itself or the `Transaction`
        that was extracted. These can be extracted from the Errors in order to recover.
        See the error documentation for info on the variants. In general, it covers large fees.
        """

        raise NotImplementedError
    def fee(self, ):
        """
        Calculates transaction fee.

        'Fee' being the amount that will be paid for mining a transaction with the current inputs
        and outputs i.e., the difference in value of the total inputs and the total outputs.

        #### Errors

        - `MissingUtxo` when UTXO information for any input is not present or is invalid.
        - `NegativeFee` if calculated value is negative.
        - `FeeOverflow` if an integer overflow occurs.
        """

        raise NotImplementedError
    def finalize(self, ):
        """
        Finalizes the current PSBT and produces a result indicating

        whether the finalization was successful or not.
        """

        raise NotImplementedError
    def json_serialize(self, ):
        """
        Serializes the PSBT into a JSON string representation.
        """

        raise NotImplementedError
    def serialize(self, ):
        """
        Serialize the PSBT into a base64-encoded string.
        """

        raise NotImplementedError
    def spend_utxo(self, input_index: "int"):
        """
        Returns the spending utxo for this PSBT's input at `input_index`.
        """

        raise NotImplementedError
    def write_to_file(self, path: "str"):
        """
        Write the `Psbt` to a file. Note that the file must not yet exist.
        """

        raise NotImplementedError
# Psbt is a Rust-only trait - it's a wrapper around a Rust implementation.
class Psbt():
    """
    A Partially Signed Transaction.
    """

    _pointer: ctypes.c_void_p
    def __init__(self, psbt_base64: "str"):
        """
        Creates a new `Psbt` instance from a base64-encoded string.
        """

        _UniffiConverterString.check_lower(psbt_base64)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypePsbtParseError,_UniffiLib.uniffi_bdkffi_fn_constructor_psbt_new,
        _UniffiConverterString.lower(psbt_base64))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_psbt, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_psbt, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst
    @classmethod
    def from_file(cls, path: "str"):
        """
        Create a new `Psbt` from a `.psbt` file.
        """

        _UniffiConverterString.check_lower(path)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypePsbtError,_UniffiLib.uniffi_bdkffi_fn_constructor_psbt_from_file,
        _UniffiConverterString.lower(path))
        return cls._make_instance_(pointer)

    @classmethod
    def from_unsigned_tx(cls, tx: "Transaction"):
        """
        Creates a PSBT from an unsigned transaction.

        # Errors

        If transactions is not unsigned.
        """

        _UniffiConverterTypeTransaction.check_lower(tx)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypePsbtError,_UniffiLib.uniffi_bdkffi_fn_constructor_psbt_from_unsigned_tx,
        _UniffiConverterTypeTransaction.lower(tx))
        return cls._make_instance_(pointer)



    def combine(self, other: "Psbt") -> "Psbt":
        """
        Combines this `Psbt` with `other` PSBT as described by BIP 174.

        In accordance with BIP 174 this function is commutative i.e., `A.combine(B) == B.combine(A)`
        """

        _UniffiConverterTypePsbt.check_lower(other)
        
        return _UniffiConverterTypePsbt.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypePsbtError,_UniffiLib.uniffi_bdkffi_fn_method_psbt_combine,self._uniffi_clone_pointer(),
        _UniffiConverterTypePsbt.lower(other))
        )





    def extract_tx(self, ) -> "Transaction":
        """
        Extracts the `Transaction` from a `Psbt` by filling in the available signature information.

        #### Errors

        `ExtractTxError` variants will contain either the `Psbt` itself or the `Transaction`
        that was extracted. These can be extracted from the Errors in order to recover.
        See the error documentation for info on the variants. In general, it covers large fees.
        """

        return _UniffiConverterTypeTransaction.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeExtractTxError,_UniffiLib.uniffi_bdkffi_fn_method_psbt_extract_tx,self._uniffi_clone_pointer(),)
        )





    def fee(self, ) -> "int":
        """
        Calculates transaction fee.

        'Fee' being the amount that will be paid for mining a transaction with the current inputs
        and outputs i.e., the difference in value of the total inputs and the total outputs.

        #### Errors

        - `MissingUtxo` when UTXO information for any input is not present or is invalid.
        - `NegativeFee` if calculated value is negative.
        - `FeeOverflow` if an integer overflow occurs.
        """

        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypePsbtError,_UniffiLib.uniffi_bdkffi_fn_method_psbt_fee,self._uniffi_clone_pointer(),)
        )





    def finalize(self, ) -> "FinalizedPsbtResult":
        """
        Finalizes the current PSBT and produces a result indicating

        whether the finalization was successful or not.
        """

        return _UniffiConverterTypeFinalizedPsbtResult.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_psbt_finalize,self._uniffi_clone_pointer(),)
        )





    def json_serialize(self, ) -> "str":
        """
        Serializes the PSBT into a JSON string representation.
        """

        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_psbt_json_serialize,self._uniffi_clone_pointer(),)
        )





    def serialize(self, ) -> "str":
        """
        Serialize the PSBT into a base64-encoded string.
        """

        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_psbt_serialize,self._uniffi_clone_pointer(),)
        )





    def spend_utxo(self, input_index: "int") -> "str":
        """
        Returns the spending utxo for this PSBT's input at `input_index`.
        """

        _UniffiConverterUInt64.check_lower(input_index)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_psbt_spend_utxo,self._uniffi_clone_pointer(),
        _UniffiConverterUInt64.lower(input_index))
        )





    def write_to_file(self, path: "str") -> None:
        """
        Write the `Psbt` to a file. Note that the file must not yet exist.
        """

        _UniffiConverterString.check_lower(path)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypePsbtError,_UniffiLib.uniffi_bdkffi_fn_method_psbt_write_to_file,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(path))







class _UniffiConverterTypePsbt:

    @staticmethod
    def lift(value: int):
        return Psbt._make_instance_(value)

    @staticmethod
    def check_lower(value: Psbt):
        if not isinstance(value, Psbt):
            raise TypeError("Expected Psbt instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: PsbtProtocol):
        if not isinstance(value, Psbt):
            raise TypeError("Expected Psbt instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: PsbtProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class ScriptProtocol(typing.Protocol):
    """
    A bitcoin script: https://en.bitcoin.it/wiki/Script
    """

    def to_bytes(self, ):
        """
        Convert a script into an array of bytes.
        """

        raise NotImplementedError
# Script is a Rust-only trait - it's a wrapper around a Rust implementation.
class Script():
    """
    A bitcoin script: https://en.bitcoin.it/wiki/Script
    """

    _pointer: ctypes.c_void_p
    def __init__(self, raw_output_script: "bytes"):
        """
        Interpret an array of bytes as a bitcoin script.
        """

        _UniffiConverterBytes.check_lower(raw_output_script)
        
        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_script_new,
        _UniffiConverterBytes.lower(raw_output_script))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_script, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_script, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def to_bytes(self, ) -> "bytes":
        """
        Convert a script into an array of bytes.
        """

        return _UniffiConverterBytes.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_script_to_bytes,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeScript:

    @staticmethod
    def lift(value: int):
        return Script._make_instance_(value)

    @staticmethod
    def check_lower(value: Script):
        if not isinstance(value, Script):
            raise TypeError("Expected Script instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ScriptProtocol):
        if not isinstance(value, Script):
            raise TypeError("Expected Script instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ScriptProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class SyncRequestProtocol(typing.Protocol):
    pass
# SyncRequest is a Rust-only trait - it's a wrapper around a Rust implementation.
class SyncRequest():
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_syncrequest, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_syncrequest, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst



class _UniffiConverterTypeSyncRequest:

    @staticmethod
    def lift(value: int):
        return SyncRequest._make_instance_(value)

    @staticmethod
    def check_lower(value: SyncRequest):
        if not isinstance(value, SyncRequest):
            raise TypeError("Expected SyncRequest instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: SyncRequestProtocol):
        if not isinstance(value, SyncRequest):
            raise TypeError("Expected SyncRequest instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: SyncRequestProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class SyncRequestBuilderProtocol(typing.Protocol):
    def build(self, ):
        raise NotImplementedError
    def inspect_spks(self, inspector: "SyncScriptInspector"):
        raise NotImplementedError
# SyncRequestBuilder is a Rust-only trait - it's a wrapper around a Rust implementation.
class SyncRequestBuilder():
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_syncrequestbuilder, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_syncrequestbuilder, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def build(self, ) -> "SyncRequest":
        return _UniffiConverterTypeSyncRequest.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRequestBuilderError,_UniffiLib.uniffi_bdkffi_fn_method_syncrequestbuilder_build,self._uniffi_clone_pointer(),)
        )





    def inspect_spks(self, inspector: "SyncScriptInspector") -> "SyncRequestBuilder":
        _UniffiConverterTypeSyncScriptInspector.check_lower(inspector)
        
        return _UniffiConverterTypeSyncRequestBuilder.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeRequestBuilderError,_UniffiLib.uniffi_bdkffi_fn_method_syncrequestbuilder_inspect_spks,self._uniffi_clone_pointer(),
        _UniffiConverterTypeSyncScriptInspector.lower(inspector))
        )






class _UniffiConverterTypeSyncRequestBuilder:

    @staticmethod
    def lift(value: int):
        return SyncRequestBuilder._make_instance_(value)

    @staticmethod
    def check_lower(value: SyncRequestBuilder):
        if not isinstance(value, SyncRequestBuilder):
            raise TypeError("Expected SyncRequestBuilder instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: SyncRequestBuilderProtocol):
        if not isinstance(value, SyncRequestBuilder):
            raise TypeError("Expected SyncRequestBuilder instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: SyncRequestBuilderProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class TransactionProtocol(typing.Protocol):
    """
    Bitcoin transaction.
    An authenticated movement of coins.
    """

    def compute_txid(self, ):
        """
        Computes the Txid.
        Hashes the transaction excluding the segwit data (i.e. the marker, flag bytes, and the witness fields themselves).
        """

        raise NotImplementedError
    def compute_wtxid(self, ):
        """
        Compute the Wtxid, which includes the witness in the transaction hash.
        """

        raise NotImplementedError
    def input(self, ):
        """
        List of transaction inputs.
        """

        raise NotImplementedError
    def is_coinbase(self, ):
        """
        Checks if this is a coinbase transaction.
        The first transaction in the block distributes the mining reward and is called the coinbase transaction.
        It is impossible to check if the transaction is first in the block, so this function checks the structure
        of the transaction instead - the previous output must be all-zeros (creates satoshis “out of thin air”).
        """

        raise NotImplementedError
    def is_explicitly_rbf(self, ):
        """
        Returns `true` if the transaction itself opted in to be BIP-125-replaceable (RBF).

        # Warning

        **Incorrectly relying on RBF may lead to monetary loss!**

        This **does not** cover the case where a transaction becomes replaceable due to ancestors
        being RBF. Please note that transactions **may be replaced** even if they **do not** include
        the RBF signal: <https://bitcoinops.org/en/newsletters/2022/10/19/#transaction-replacement-option>.
        """

        raise NotImplementedError
    def is_lock_time_enabled(self, ):
        """
        Returns `true` if this transactions nLockTime is enabled ([BIP-65]).

        [BIP-65]: https://github.com/bitcoin/bips/blob/master/bip-0065.mediawiki
        """

        raise NotImplementedError
    def lock_time(self, ):
        """
        Block height or timestamp. Transaction cannot be included in a block until this height/time.

        /// ### Relevant BIPs

        * [BIP-65 OP_CHECKLOCKTIMEVERIFY](https://github.com/bitcoin/bips/blob/master/bip-0065.mediawiki)
        * [BIP-113 Median time-past as endpoint for lock-time calculations](https://github.com/bitcoin/bips/blob/master/bip-0113.mediawiki)
        """

        raise NotImplementedError
    def output(self, ):
        """
        List of transaction outputs.
        """

        raise NotImplementedError
    def serialize(self, ):
        """
        Serialize transaction into consensus-valid format. See https://docs.rs/bitcoin/latest/bitcoin/struct.Transaction.html#serialization-notes for more notes on transaction serialization.
        """

        raise NotImplementedError
    def total_size(self, ):
        """
        Returns the total transaction size

        Total transaction size is the transaction size in bytes serialized as described in BIP144,
        including base data and witness data.
        """

        raise NotImplementedError
    def version(self, ):
        """
        The protocol version, is currently expected to be 1 or 2 (BIP 68).
        """

        raise NotImplementedError
    def vsize(self, ):
        """
        Returns the "virtual size" (vsize) of this transaction.

        Will be `ceil(weight / 4.0)`. Note this implements the virtual size as per [`BIP141`], which
        is different to what is implemented in Bitcoin Core.
        > Virtual transaction size is defined as Transaction weight / 4 (rounded up to the next integer).

        [`BIP141`]: https://github.com/bitcoin/bips/blob/master/bip-0141.mediawiki
        """

        raise NotImplementedError
    def weight(self, ):
        """
        Returns the weight of this transaction, as defined by BIP-141.

        > Transaction weight is defined as Base transaction size * 3 + Total transaction size (ie.
        > the same method as calculating Block weight from Base size and Total size).

        For transactions with an empty witness, this is simply the consensus-serialized size times
        four. For transactions with a witness, this is the non-witness consensus-serialized size
        multiplied by three plus the with-witness consensus-serialized size.

        For transactions with no inputs, this function will return a value 2 less than the actual
        weight of the serialized transaction. The reason is that zero-input transactions, post-segwit,
        cannot be unambiguously serialized; we make a choice that adds two extra bytes. For more
        details see [BIP 141](https://github.com/bitcoin/bips/blob/master/bip-0141.mediawiki)
        which uses a "input count" of `0x00` as a `marker` for a Segwit-encoded transaction.

        If you need to use 0-input transactions, we strongly recommend you do so using the PSBT
        API. The unsigned transaction encoded within PSBT is always a non-segwit transaction
        and can therefore avoid this ambiguity.
        """

        raise NotImplementedError
# Transaction is a Rust-only trait - it's a wrapper around a Rust implementation.
class Transaction():
    """
    Bitcoin transaction.
    An authenticated movement of coins.
    """

    _pointer: ctypes.c_void_p
    def __init__(self, transaction_bytes: "bytes"):
        """
        Creates a new `Transaction` instance from serialized transaction bytes.
        """

        _UniffiConverterBytes.check_lower(transaction_bytes)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeTransactionError,_UniffiLib.uniffi_bdkffi_fn_constructor_transaction_new,
        _UniffiConverterBytes.lower(transaction_bytes))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_transaction, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_transaction, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def compute_txid(self, ) -> "Txid":
        """
        Computes the Txid.
        Hashes the transaction excluding the segwit data (i.e. the marker, flag bytes, and the witness fields themselves).
        """

        return _UniffiConverterTypeTxid.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_compute_txid,self._uniffi_clone_pointer(),)
        )





    def compute_wtxid(self, ) -> "Wtxid":
        """
        Compute the Wtxid, which includes the witness in the transaction hash.
        """

        return _UniffiConverterTypeWtxid.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_compute_wtxid,self._uniffi_clone_pointer(),)
        )





    def input(self, ) -> "typing.List[TxIn]":
        """
        List of transaction inputs.
        """

        return _UniffiConverterSequenceTypeTxIn.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_input,self._uniffi_clone_pointer(),)
        )





    def is_coinbase(self, ) -> "bool":
        """
        Checks if this is a coinbase transaction.
        The first transaction in the block distributes the mining reward and is called the coinbase transaction.
        It is impossible to check if the transaction is first in the block, so this function checks the structure
        of the transaction instead - the previous output must be all-zeros (creates satoshis “out of thin air”).
        """

        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_is_coinbase,self._uniffi_clone_pointer(),)
        )





    def is_explicitly_rbf(self, ) -> "bool":
        """
        Returns `true` if the transaction itself opted in to be BIP-125-replaceable (RBF).

        # Warning

        **Incorrectly relying on RBF may lead to monetary loss!**

        This **does not** cover the case where a transaction becomes replaceable due to ancestors
        being RBF. Please note that transactions **may be replaced** even if they **do not** include
        the RBF signal: <https://bitcoinops.org/en/newsletters/2022/10/19/#transaction-replacement-option>.
        """

        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_is_explicitly_rbf,self._uniffi_clone_pointer(),)
        )





    def is_lock_time_enabled(self, ) -> "bool":
        """
        Returns `true` if this transactions nLockTime is enabled ([BIP-65]).

        [BIP-65]: https://github.com/bitcoin/bips/blob/master/bip-0065.mediawiki
        """

        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_is_lock_time_enabled,self._uniffi_clone_pointer(),)
        )





    def lock_time(self, ) -> "int":
        """
        Block height or timestamp. Transaction cannot be included in a block until this height/time.

        /// ### Relevant BIPs

        * [BIP-65 OP_CHECKLOCKTIMEVERIFY](https://github.com/bitcoin/bips/blob/master/bip-0065.mediawiki)
        * [BIP-113 Median time-past as endpoint for lock-time calculations](https://github.com/bitcoin/bips/blob/master/bip-0113.mediawiki)
        """

        return _UniffiConverterUInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_lock_time,self._uniffi_clone_pointer(),)
        )





    def output(self, ) -> "typing.List[TxOut]":
        """
        List of transaction outputs.
        """

        return _UniffiConverterSequenceTypeTxOut.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_output,self._uniffi_clone_pointer(),)
        )





    def serialize(self, ) -> "bytes":
        """
        Serialize transaction into consensus-valid format. See https://docs.rs/bitcoin/latest/bitcoin/struct.Transaction.html#serialization-notes for more notes on transaction serialization.
        """

        return _UniffiConverterBytes.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_serialize,self._uniffi_clone_pointer(),)
        )





    def total_size(self, ) -> "int":
        """
        Returns the total transaction size

        Total transaction size is the transaction size in bytes serialized as described in BIP144,
        including base data and witness data.
        """

        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_total_size,self._uniffi_clone_pointer(),)
        )





    def version(self, ) -> "int":
        """
        The protocol version, is currently expected to be 1 or 2 (BIP 68).
        """

        return _UniffiConverterInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_version,self._uniffi_clone_pointer(),)
        )





    def vsize(self, ) -> "int":
        """
        Returns the "virtual size" (vsize) of this transaction.

        Will be `ceil(weight / 4.0)`. Note this implements the virtual size as per [`BIP141`], which
        is different to what is implemented in Bitcoin Core.
        > Virtual transaction size is defined as Transaction weight / 4 (rounded up to the next integer).

        [`BIP141`]: https://github.com/bitcoin/bips/blob/master/bip-0141.mediawiki
        """

        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_vsize,self._uniffi_clone_pointer(),)
        )





    def weight(self, ) -> "int":
        """
        Returns the weight of this transaction, as defined by BIP-141.

        > Transaction weight is defined as Base transaction size * 3 + Total transaction size (ie.
        > the same method as calculating Block weight from Base size and Total size).

        For transactions with an empty witness, this is simply the consensus-serialized size times
        four. For transactions with a witness, this is the non-witness consensus-serialized size
        multiplied by three plus the with-witness consensus-serialized size.

        For transactions with no inputs, this function will return a value 2 less than the actual
        weight of the serialized transaction. The reason is that zero-input transactions, post-segwit,
        cannot be unambiguously serialized; we make a choice that adds two extra bytes. For more
        details see [BIP 141](https://github.com/bitcoin/bips/blob/master/bip-0141.mediawiki)
        which uses a "input count" of `0x00` as a `marker` for a Segwit-encoded transaction.

        If you need to use 0-input transactions, we strongly recommend you do so using the PSBT
        API. The unsigned transaction encoded within PSBT is always a non-segwit transaction
        and can therefore avoid this ambiguity.
        """

        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_weight,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )



    def __eq__(self, other: object) -> bool:
        if not isinstance(other, Transaction):
            return NotImplemented

        return _UniffiConverterBool.lift(_uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_uniffi_trait_eq_eq,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTransaction.lower(other)))

    def __ne__(self, other: object) -> bool:
        if not isinstance(other, Transaction):
            return NotImplemented

        return _UniffiConverterBool.lift(_uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_transaction_uniffi_trait_eq_ne,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTransaction.lower(other)))



class _UniffiConverterTypeTransaction:

    @staticmethod
    def lift(value: int):
        return Transaction._make_instance_(value)

    @staticmethod
    def check_lower(value: Transaction):
        if not isinstance(value, Transaction):
            raise TypeError("Expected Transaction instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: TransactionProtocol):
        if not isinstance(value, Transaction):
            raise TypeError("Expected Transaction instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: TransactionProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class TxBuilderProtocol(typing.Protocol):
    """
    A `TxBuilder` is created by calling `build_tx` on a wallet. After assigning it, you set options on it until finally
    calling `finish` to consume the builder and generate the transaction.
    """

    def add_data(self, data: "bytes"):
        """
        Add data as an output using `OP_RETURN`.
        """

        raise NotImplementedError
    def add_global_xpubs(self, ):
        """
        Fill-in the `PSBT_GLOBAL_XPUB` field with the extended keys contained in both the external and internal
        descriptors.

        This is useful for offline signers that take part to a multisig. Some hardware wallets like BitBox and ColdCard
        are known to require this.
        """

        raise NotImplementedError
    def add_recipient(self, script: "Script",amount: "Amount"):
        """
        Add a recipient to the internal list of recipients.
        """

        raise NotImplementedError
    def add_unspendable(self, unspendable: "OutPoint"):
        """
        Add a utxo to the internal list of unspendable utxos.

        It’s important to note that the "must-be-spent" utxos added with `TxBuilder::add_utxo` have priority over this.
        """

        raise NotImplementedError
    def add_utxo(self, outpoint: "OutPoint"):
        """
        Add a utxo to the internal list of utxos that must be spent.

        These have priority over the "unspendable" utxos, meaning that if a utxo is present both in the "utxos" and the
        "unspendable" list, it will be spent.
        """

        raise NotImplementedError
    def add_utxos(self, outpoints: "typing.List[OutPoint]"):
        """
        Add the list of outpoints to the internal list of UTXOs that must be spent.
        """

        raise NotImplementedError
    def allow_dust(self, allow_dust: "bool"):
        """
        Set whether or not the dust limit is checked.

        Note: by avoiding a dust limit check you may end up with a transaction that is non-standard.
        """

        raise NotImplementedError
    def change_policy(self, change_policy: "ChangeSpendPolicy"):
        """
        Set a specific `ChangeSpendPolicy`. See `TxBuilder::do_not_spend_change` and `TxBuilder::only_spend_change` for
        some shortcuts. This method assumes the presence of an internal keychain, otherwise it has no effect.
        """

        raise NotImplementedError
    def current_height(self, height: "int"):
        """
        Set the current blockchain height.

        This will be used to:

        1. Set the `nLockTime` for preventing fee sniping. Note: This will be ignored if you manually specify a
        `nlocktime` using `TxBuilder::nlocktime`.

        2. Decide whether coinbase outputs are mature or not. If the coinbase outputs are not mature at `current_height`,
        we ignore them in the coin selection. If you want to create a transaction that spends immature coinbase inputs,
        manually add them using `TxBuilder::add_utxos`.
        In both cases, if you don’t provide a current height, we use the last sync height.
        """

        raise NotImplementedError
    def do_not_spend_change(self, ):
        """
        Do not spend change outputs.

        This effectively adds all the change outputs to the "unspendable" list. See `TxBuilder::unspendable`. This method
        assumes the presence of an internal keychain, otherwise it has no effect.
        """

        raise NotImplementedError
    def drain_to(self, script: "Script"):
        """
        Sets the address to drain excess coins to.

        Usually, when there are excess coins they are sent to a change address generated by the wallet. This option
        replaces the usual change address with an arbitrary script_pubkey of your choosing. Just as with a change output,
        if the drain output is not needed (the excess coins are too small) it will not be included in the resulting
        transaction. The only difference is that it is valid to use `drain_to` without setting any ordinary recipients
        with `add_recipient` (but it is perfectly fine to add recipients as well).

        If you choose not to set any recipients, you should provide the utxos that the transaction should spend via
        `add_utxos`. `drain_to` is very useful for draining all the coins in a wallet with `drain_wallet` to a single
        address.
        """

        raise NotImplementedError
    def drain_wallet(self, ):
        """
        Spend all the available inputs. This respects filters like `TxBuilder::unspendable` and the change policy.
        """

        raise NotImplementedError
    def fee_absolute(self, fee_amount: "Amount"):
        """
        Set an absolute fee The `fee_absolute` method refers to the absolute transaction fee in `Amount`. If anyone sets
        both the `fee_absolute` method and the `fee_rate` method, the `FeePolicy` enum will be set by whichever method was
        called last, as the `FeeRate` and `FeeAmount` are mutually exclusive.

        Note that this is really a minimum absolute fee – it’s possible to overshoot it slightly since adding a change output to drain the remaining excess might not be viable.
        """

        raise NotImplementedError
    def fee_rate(self, fee_rate: "FeeRate"):
        """
        Set a custom fee rate.

        This method sets the mining fee paid by the transaction as a rate on its size. This means that the total fee paid
        is equal to fee_rate times the size of the transaction. Default is 1 sat/vB in accordance with Bitcoin Core’s
        default relay policy.

        Note that this is really a minimum feerate – it’s possible to overshoot it slightly since adding a change output
        to drain the remaining excess might not be viable.
        """

        raise NotImplementedError
    def finish(self, wallet: "Wallet"):
        """
        Finish building the transaction.

        Uses the thread-local random number generator (rng).

        Returns a new `Psbt` per BIP174.

        WARNING: To avoid change address reuse you must persist the changes resulting from one or more calls to this
        method before closing the wallet. See `Wallet::reveal_next_address`.
        """

        raise NotImplementedError
    def manually_selected_only(self, ):
        """
        Only spend utxos added by `TxBuilder::add_utxo`.

        The wallet will not add additional utxos to the transaction even if they are needed to make the transaction valid.
        """

        raise NotImplementedError
    def nlocktime(self, locktime: "LockTime"):
        """
        Use a specific nLockTime while creating the transaction.

        This can cause conflicts if the wallet’s descriptors contain an "after" (`OP_CLTV`) operator.
        """

        raise NotImplementedError
    def only_spend_change(self, ):
        """
        Only spend change outputs.

        This effectively adds all the non-change outputs to the "unspendable" list. See `TxBuilder::unspendable`. This
        method assumes the presence of an internal keychain, otherwise it has no effect.
        """

        raise NotImplementedError
    def policy_path(self, policy_path: "dict[str, typing.List[int]]",keychain: "KeychainKind"):
        """
        The TxBuilder::policy_path is a complex API. See the Rust docs for complete       information: https://docs.rs/bdk_wallet/latest/bdk_wallet/struct.TxBuilder.html#method.policy_path
        """

        raise NotImplementedError
    def set_exact_sequence(self, nsequence: "int"):
        """
        Set an exact `nSequence` value.

        This can cause conflicts if the wallet’s descriptors contain an "older" (`OP_CSV`) operator and the given
        `nsequence` is lower than the CSV value.
        """

        raise NotImplementedError
    def set_recipients(self, recipients: "typing.List[ScriptAmount]"):
        """
        Replace the recipients already added with a new list of recipients.
        """

        raise NotImplementedError
    def unspendable(self, unspendable: "typing.List[OutPoint]"):
        """
        Replace the internal list of unspendable utxos with a new list.

        It’s important to note that the "must-be-spent" utxos added with `TxBuilder::add_utxo` have priority over these.
        """

        raise NotImplementedError
    def version(self, version: "int"):
        """
        Build a transaction with a specific version.

        The version should always be greater than 0 and greater than 1 if the wallet’s descriptors contain an "older"
        (`OP_CSV`) operator.
        """

        raise NotImplementedError
# TxBuilder is a Rust-only trait - it's a wrapper around a Rust implementation.
class TxBuilder():
    """
    A `TxBuilder` is created by calling `build_tx` on a wallet. After assigning it, you set options on it until finally
    calling `finish` to consume the builder and generate the transaction.
    """

    _pointer: ctypes.c_void_p
    def __init__(self, ):
        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_constructor_txbuilder_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_txbuilder, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_txbuilder, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def add_data(self, data: "bytes") -> "TxBuilder":
        """
        Add data as an output using `OP_RETURN`.
        """

        _UniffiConverterBytes.check_lower(data)
        
        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_data,self._uniffi_clone_pointer(),
        _UniffiConverterBytes.lower(data))
        )





    def add_global_xpubs(self, ) -> "TxBuilder":
        """
        Fill-in the `PSBT_GLOBAL_XPUB` field with the extended keys contained in both the external and internal
        descriptors.

        This is useful for offline signers that take part to a multisig. Some hardware wallets like BitBox and ColdCard
        are known to require this.
        """

        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_global_xpubs,self._uniffi_clone_pointer(),)
        )





    def add_recipient(self, script: "Script",amount: "Amount") -> "TxBuilder":
        """
        Add a recipient to the internal list of recipients.
        """

        _UniffiConverterTypeScript.check_lower(script)
        
        _UniffiConverterTypeAmount.check_lower(amount)
        
        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_recipient,self._uniffi_clone_pointer(),
        _UniffiConverterTypeScript.lower(script),
        _UniffiConverterTypeAmount.lower(amount))
        )





    def add_unspendable(self, unspendable: "OutPoint") -> "TxBuilder":
        """
        Add a utxo to the internal list of unspendable utxos.

        It’s important to note that the "must-be-spent" utxos added with `TxBuilder::add_utxo` have priority over this.
        """

        _UniffiConverterTypeOutPoint.check_lower(unspendable)
        
        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_unspendable,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOutPoint.lower(unspendable))
        )





    def add_utxo(self, outpoint: "OutPoint") -> "TxBuilder":
        """
        Add a utxo to the internal list of utxos that must be spent.

        These have priority over the "unspendable" utxos, meaning that if a utxo is present both in the "utxos" and the
        "unspendable" list, it will be spent.
        """

        _UniffiConverterTypeOutPoint.check_lower(outpoint)
        
        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_utxo,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOutPoint.lower(outpoint))
        )





    def add_utxos(self, outpoints: "typing.List[OutPoint]") -> "TxBuilder":
        """
        Add the list of outpoints to the internal list of UTXOs that must be spent.
        """

        _UniffiConverterSequenceTypeOutPoint.check_lower(outpoints)
        
        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_add_utxos,self._uniffi_clone_pointer(),
        _UniffiConverterSequenceTypeOutPoint.lower(outpoints))
        )





    def allow_dust(self, allow_dust: "bool") -> "TxBuilder":
        """
        Set whether or not the dust limit is checked.

        Note: by avoiding a dust limit check you may end up with a transaction that is non-standard.
        """

        _UniffiConverterBool.check_lower(allow_dust)
        
        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_allow_dust,self._uniffi_clone_pointer(),
        _UniffiConverterBool.lower(allow_dust))
        )





    def change_policy(self, change_policy: "ChangeSpendPolicy") -> "TxBuilder":
        """
        Set a specific `ChangeSpendPolicy`. See `TxBuilder::do_not_spend_change` and `TxBuilder::only_spend_change` for
        some shortcuts. This method assumes the presence of an internal keychain, otherwise it has no effect.
        """

        _UniffiConverterTypeChangeSpendPolicy.check_lower(change_policy)
        
        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_change_policy,self._uniffi_clone_pointer(),
        _UniffiConverterTypeChangeSpendPolicy.lower(change_policy))
        )





    def current_height(self, height: "int") -> "TxBuilder":
        """
        Set the current blockchain height.

        This will be used to:

        1. Set the `nLockTime` for preventing fee sniping. Note: This will be ignored if you manually specify a
        `nlocktime` using `TxBuilder::nlocktime`.

        2. Decide whether coinbase outputs are mature or not. If the coinbase outputs are not mature at `current_height`,
        we ignore them in the coin selection. If you want to create a transaction that spends immature coinbase inputs,
        manually add them using `TxBuilder::add_utxos`.
        In both cases, if you don’t provide a current height, we use the last sync height.
        """

        _UniffiConverterUInt32.check_lower(height)
        
        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_current_height,self._uniffi_clone_pointer(),
        _UniffiConverterUInt32.lower(height))
        )





    def do_not_spend_change(self, ) -> "TxBuilder":
        """
        Do not spend change outputs.

        This effectively adds all the change outputs to the "unspendable" list. See `TxBuilder::unspendable`. This method
        assumes the presence of an internal keychain, otherwise it has no effect.
        """

        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_do_not_spend_change,self._uniffi_clone_pointer(),)
        )





    def drain_to(self, script: "Script") -> "TxBuilder":
        """
        Sets the address to drain excess coins to.

        Usually, when there are excess coins they are sent to a change address generated by the wallet. This option
        replaces the usual change address with an arbitrary script_pubkey of your choosing. Just as with a change output,
        if the drain output is not needed (the excess coins are too small) it will not be included in the resulting
        transaction. The only difference is that it is valid to use `drain_to` without setting any ordinary recipients
        with `add_recipient` (but it is perfectly fine to add recipients as well).

        If you choose not to set any recipients, you should provide the utxos that the transaction should spend via
        `add_utxos`. `drain_to` is very useful for draining all the coins in a wallet with `drain_wallet` to a single
        address.
        """

        _UniffiConverterTypeScript.check_lower(script)
        
        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_drain_to,self._uniffi_clone_pointer(),
        _UniffiConverterTypeScript.lower(script))
        )





    def drain_wallet(self, ) -> "TxBuilder":
        """
        Spend all the available inputs. This respects filters like `TxBuilder::unspendable` and the change policy.
        """

        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_drain_wallet,self._uniffi_clone_pointer(),)
        )





    def fee_absolute(self, fee_amount: "Amount") -> "TxBuilder":
        """
        Set an absolute fee The `fee_absolute` method refers to the absolute transaction fee in `Amount`. If anyone sets
        both the `fee_absolute` method and the `fee_rate` method, the `FeePolicy` enum will be set by whichever method was
        called last, as the `FeeRate` and `FeeAmount` are mutually exclusive.

        Note that this is really a minimum absolute fee – it’s possible to overshoot it slightly since adding a change output to drain the remaining excess might not be viable.
        """

        _UniffiConverterTypeAmount.check_lower(fee_amount)
        
        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_fee_absolute,self._uniffi_clone_pointer(),
        _UniffiConverterTypeAmount.lower(fee_amount))
        )





    def fee_rate(self, fee_rate: "FeeRate") -> "TxBuilder":
        """
        Set a custom fee rate.

        This method sets the mining fee paid by the transaction as a rate on its size. This means that the total fee paid
        is equal to fee_rate times the size of the transaction. Default is 1 sat/vB in accordance with Bitcoin Core’s
        default relay policy.

        Note that this is really a minimum feerate – it’s possible to overshoot it slightly since adding a change output
        to drain the remaining excess might not be viable.
        """

        _UniffiConverterTypeFeeRate.check_lower(fee_rate)
        
        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_fee_rate,self._uniffi_clone_pointer(),
        _UniffiConverterTypeFeeRate.lower(fee_rate))
        )





    def finish(self, wallet: "Wallet") -> "Psbt":
        """
        Finish building the transaction.

        Uses the thread-local random number generator (rng).

        Returns a new `Psbt` per BIP174.

        WARNING: To avoid change address reuse you must persist the changes resulting from one or more calls to this
        method before closing the wallet. See `Wallet::reveal_next_address`.
        """

        _UniffiConverterTypeWallet.check_lower(wallet)
        
        return _UniffiConverterTypePsbt.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeCreateTxError,_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_finish,self._uniffi_clone_pointer(),
        _UniffiConverterTypeWallet.lower(wallet))
        )





    def manually_selected_only(self, ) -> "TxBuilder":
        """
        Only spend utxos added by `TxBuilder::add_utxo`.

        The wallet will not add additional utxos to the transaction even if they are needed to make the transaction valid.
        """

        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_manually_selected_only,self._uniffi_clone_pointer(),)
        )





    def nlocktime(self, locktime: "LockTime") -> "TxBuilder":
        """
        Use a specific nLockTime while creating the transaction.

        This can cause conflicts if the wallet’s descriptors contain an "after" (`OP_CLTV`) operator.
        """

        _UniffiConverterTypeLockTime.check_lower(locktime)
        
        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_nlocktime,self._uniffi_clone_pointer(),
        _UniffiConverterTypeLockTime.lower(locktime))
        )





    def only_spend_change(self, ) -> "TxBuilder":
        """
        Only spend change outputs.

        This effectively adds all the non-change outputs to the "unspendable" list. See `TxBuilder::unspendable`. This
        method assumes the presence of an internal keychain, otherwise it has no effect.
        """

        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_only_spend_change,self._uniffi_clone_pointer(),)
        )





    def policy_path(self, policy_path: "dict[str, typing.List[int]]",keychain: "KeychainKind") -> "TxBuilder":
        """
        The TxBuilder::policy_path is a complex API. See the Rust docs for complete       information: https://docs.rs/bdk_wallet/latest/bdk_wallet/struct.TxBuilder.html#method.policy_path
        """

        _UniffiConverterMapStringSequenceUInt64.check_lower(policy_path)
        
        _UniffiConverterTypeKeychainKind.check_lower(keychain)
        
        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_policy_path,self._uniffi_clone_pointer(),
        _UniffiConverterMapStringSequenceUInt64.lower(policy_path),
        _UniffiConverterTypeKeychainKind.lower(keychain))
        )





    def set_exact_sequence(self, nsequence: "int") -> "TxBuilder":
        """
        Set an exact `nSequence` value.

        This can cause conflicts if the wallet’s descriptors contain an "older" (`OP_CSV`) operator and the given
        `nsequence` is lower than the CSV value.
        """

        _UniffiConverterUInt32.check_lower(nsequence)
        
        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_set_exact_sequence,self._uniffi_clone_pointer(),
        _UniffiConverterUInt32.lower(nsequence))
        )





    def set_recipients(self, recipients: "typing.List[ScriptAmount]") -> "TxBuilder":
        """
        Replace the recipients already added with a new list of recipients.
        """

        _UniffiConverterSequenceTypeScriptAmount.check_lower(recipients)
        
        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_set_recipients,self._uniffi_clone_pointer(),
        _UniffiConverterSequenceTypeScriptAmount.lower(recipients))
        )





    def unspendable(self, unspendable: "typing.List[OutPoint]") -> "TxBuilder":
        """
        Replace the internal list of unspendable utxos with a new list.

        It’s important to note that the "must-be-spent" utxos added with `TxBuilder::add_utxo` have priority over these.
        """

        _UniffiConverterSequenceTypeOutPoint.check_lower(unspendable)
        
        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_unspendable,self._uniffi_clone_pointer(),
        _UniffiConverterSequenceTypeOutPoint.lower(unspendable))
        )





    def version(self, version: "int") -> "TxBuilder":
        """
        Build a transaction with a specific version.

        The version should always be greater than 0 and greater than 1 if the wallet’s descriptors contain an "older"
        (`OP_CSV`) operator.
        """

        _UniffiConverterInt32.check_lower(version)
        
        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txbuilder_version,self._uniffi_clone_pointer(),
        _UniffiConverterInt32.lower(version))
        )






class _UniffiConverterTypeTxBuilder:

    @staticmethod
    def lift(value: int):
        return TxBuilder._make_instance_(value)

    @staticmethod
    def check_lower(value: TxBuilder):
        if not isinstance(value, TxBuilder):
            raise TypeError("Expected TxBuilder instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: TxBuilderProtocol):
        if not isinstance(value, TxBuilder):
            raise TypeError("Expected TxBuilder instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: TxBuilderProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class TxMerkleNodeProtocol(typing.Protocol):
    """
    The merkle root of the merkle tree corresponding to a block's transactions.
    """

    def serialize(self, ):
        """
        Serialize this type into a 32 byte array.
        """

        raise NotImplementedError
# TxMerkleNode is a Rust-only trait - it's a wrapper around a Rust implementation.
class TxMerkleNode():
    """
    The merkle root of the merkle tree corresponding to a block's transactions.
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_txmerklenode, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_txmerklenode, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst
    @classmethod
    def from_bytes(cls, bytes: "bytes"):
        """
        Construct a hash-like type from 32 bytes.
        """

        _UniffiConverterBytes.check_lower(bytes)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeHashParseError,_UniffiLib.uniffi_bdkffi_fn_constructor_txmerklenode_from_bytes,
        _UniffiConverterBytes.lower(bytes))
        return cls._make_instance_(pointer)

    @classmethod
    def from_string(cls, hex: "str"):
        """
        Construct a hash-like type from a hex string.
        """

        _UniffiConverterString.check_lower(hex)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeHashParseError,_UniffiLib.uniffi_bdkffi_fn_constructor_txmerklenode_from_string,
        _UniffiConverterString.lower(hex))
        return cls._make_instance_(pointer)



    def serialize(self, ) -> "bytes":
        """
        Serialize this type into a 32 byte array.
        """

        return _UniffiConverterBytes.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txmerklenode_serialize,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txmerklenode_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )



    def __eq__(self, other: object) -> bool:
        if not isinstance(other, TxMerkleNode):
            return NotImplemented

        return _UniffiConverterBool.lift(_uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txmerklenode_uniffi_trait_eq_eq,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTxMerkleNode.lower(other)))

    def __ne__(self, other: object) -> bool:
        if not isinstance(other, TxMerkleNode):
            return NotImplemented

        return _UniffiConverterBool.lift(_uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txmerklenode_uniffi_trait_eq_ne,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTxMerkleNode.lower(other)))


    def __hash__(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txmerklenode_uniffi_trait_hash,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeTxMerkleNode:

    @staticmethod
    def lift(value: int):
        return TxMerkleNode._make_instance_(value)

    @staticmethod
    def check_lower(value: TxMerkleNode):
        if not isinstance(value, TxMerkleNode):
            raise TypeError("Expected TxMerkleNode instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: TxMerkleNodeProtocol):
        if not isinstance(value, TxMerkleNode):
            raise TypeError("Expected TxMerkleNode instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: TxMerkleNodeProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class TxidProtocol(typing.Protocol):
    """
    A bitcoin transaction identifier
    """

    def serialize(self, ):
        """
        Serialize this type into a 32 byte array.
        """

        raise NotImplementedError
# Txid is a Rust-only trait - it's a wrapper around a Rust implementation.
class Txid():
    """
    A bitcoin transaction identifier
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_txid, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_txid, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst
    @classmethod
    def from_bytes(cls, bytes: "bytes"):
        """
        Construct a hash-like type from 32 bytes.
        """

        _UniffiConverterBytes.check_lower(bytes)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeHashParseError,_UniffiLib.uniffi_bdkffi_fn_constructor_txid_from_bytes,
        _UniffiConverterBytes.lower(bytes))
        return cls._make_instance_(pointer)

    @classmethod
    def from_string(cls, hex: "str"):
        """
        Construct a hash-like type from a hex string.
        """

        _UniffiConverterString.check_lower(hex)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeHashParseError,_UniffiLib.uniffi_bdkffi_fn_constructor_txid_from_string,
        _UniffiConverterString.lower(hex))
        return cls._make_instance_(pointer)



    def serialize(self, ) -> "bytes":
        """
        Serialize this type into a 32 byte array.
        """

        return _UniffiConverterBytes.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txid_serialize,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txid_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )



    def __eq__(self, other: object) -> bool:
        if not isinstance(other, Txid):
            return NotImplemented

        return _UniffiConverterBool.lift(_uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txid_uniffi_trait_eq_eq,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTxid.lower(other)))

    def __ne__(self, other: object) -> bool:
        if not isinstance(other, Txid):
            return NotImplemented

        return _UniffiConverterBool.lift(_uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txid_uniffi_trait_eq_ne,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTxid.lower(other)))


    def __hash__(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_txid_uniffi_trait_hash,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeTxid:

    @staticmethod
    def lift(value: int):
        return Txid._make_instance_(value)

    @staticmethod
    def check_lower(value: Txid):
        if not isinstance(value, Txid):
            raise TypeError("Expected Txid instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: TxidProtocol):
        if not isinstance(value, Txid):
            raise TypeError("Expected Txid instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: TxidProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class UpdateProtocol(typing.Protocol):
    """
    An update for a wallet containing chain, descriptor index, and transaction data.
    """

    pass
# Update is a Rust-only trait - it's a wrapper around a Rust implementation.
class Update():
    """
    An update for a wallet containing chain, descriptor index, and transaction data.
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_update, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_update, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst



class _UniffiConverterTypeUpdate:

    @staticmethod
    def lift(value: int):
        return Update._make_instance_(value)

    @staticmethod
    def check_lower(value: Update):
        if not isinstance(value, Update):
            raise TypeError("Expected Update instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: UpdateProtocol):
        if not isinstance(value, Update):
            raise TypeError("Expected Update instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: UpdateProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class WalletProtocol(typing.Protocol):
    """
    A Bitcoin wallet.

    The Wallet acts as a way of coherently interfacing with output descriptors and related transactions. Its main components are:
    1. output descriptors from which it can derive addresses.
    2. signers that can contribute signatures to addresses instantiated from the descriptors.

    The user is responsible for loading and writing wallet changes which are represented as
    ChangeSets (see take_staged). Also see individual functions and example for instructions on when
    Wallet state needs to be persisted.

    The Wallet descriptor (external) and change descriptor (internal) must not derive the same
    script pubkeys. See KeychainTxOutIndex::insert_descriptor() for more details.
    """

    def apply_unconfirmed_txs(self, unconfirmed_txs: "typing.List[UnconfirmedTx]"):
        """
        Apply relevant unconfirmed transactions to the wallet.
        Transactions that are not relevant are filtered out.
        """

        raise NotImplementedError
    def apply_update(self, update: "Update"):
        """
        Applies an update to the wallet and stages the changes (but does not persist them).

        Usually you create an `update` by interacting with some blockchain data source and inserting
        transactions related to your wallet into it.

        After applying updates you should persist the staged wallet changes. For an example of how
        to persist staged wallet changes see [`Wallet::reveal_next_address`].
        """

        raise NotImplementedError
    def balance(self, ):
        """
        Return the balance, separated into available, trusted-pending, untrusted-pending and
        immature values.
        """

        raise NotImplementedError
    def calculate_fee(self, tx: "Transaction"):
        """
        Calculates the fee of a given transaction. Returns [`Amount::ZERO`] if `tx` is a coinbase transaction.

        To calculate the fee for a [`Transaction`] with inputs not owned by this wallet you must
        manually insert the TxOut(s) into the tx graph using the [`insert_txout`] function.

        Note `tx` does not have to be in the graph for this to work.
        """

        raise NotImplementedError
    def calculate_fee_rate(self, tx: "Transaction"):
        """
        Calculate the [`FeeRate`] for a given transaction.

        To calculate the fee rate for a [`Transaction`] with inputs not owned by this wallet you must
        manually insert the TxOut(s) into the tx graph using the [`insert_txout`] function.

        Note `tx` does not have to be in the graph for this to work.
        """

        raise NotImplementedError
    def cancel_tx(self, tx: "Transaction"):
        """
        Informs the wallet that you no longer intend to broadcast a tx that was built from it.

        This frees up the change address used when creating the tx for use in future transactions.
        """

        raise NotImplementedError
    def derivation_index(self, keychain: "KeychainKind"):
        """
        The derivation index of this wallet. It will return `None` if it has not derived any addresses.
        Otherwise, it will return the index of the highest address it has derived.
        """

        raise NotImplementedError
    def derivation_of_spk(self, spk: "Script"):
        """
        Finds how the wallet derived the script pubkey `spk`.

        Will only return `Some(_)` if the wallet has given out the spk.
        """

        raise NotImplementedError
    def descriptor_checksum(self, keychain: "KeychainKind"):
        """
        Return the checksum of the public descriptor associated to `keychain`.

        Internally calls [`Self::public_descriptor`] to fetch the right descriptor.
        """

        raise NotImplementedError
    def finalize_psbt(self, psbt: "Psbt",sign_options: "typing.Union[object, typing.Optional[SignOptions]]" = _DEFAULT):
        """
        Finalize a PSBT, i.e., for each input determine if sufficient data is available to pass
        validation and construct the respective `scriptSig` or `scriptWitness`. Please refer to
        [BIP174](https://github.com/bitcoin/bips/blob/master/bip-0174.mediawiki#Input_Finalizer),
        and [BIP371](https://github.com/bitcoin/bips/blob/master/bip-0371.mediawiki)
        for further information.

        Returns `true` if the PSBT could be finalized, and `false` otherwise.

        The [`SignOptions`] can be used to tweak the behavior of the finalizer.
        """

        raise NotImplementedError
    def get_tx(self, txid: "Txid"):
        """
        Get a single transaction from the wallet as a [`WalletTx`] (if the transaction exists).

        `WalletTx` contains the full transaction alongside meta-data such as:
        * Blocks that the transaction is [`Anchor`]ed in. These may or may not be blocks that exist
        in the best chain.
        * The [`ChainPosition`] of the transaction in the best chain - whether the transaction is
        confirmed or unconfirmed. If the transaction is confirmed, the anchor which proves the
        confirmation is provided. If the transaction is unconfirmed, the unix timestamp of when
        the transaction was last seen in the mempool is provided.
        """

        raise NotImplementedError
    def get_utxo(self, op: "OutPoint"):
        """
        Returns the utxo owned by this wallet corresponding to `outpoint` if it exists in the
        wallet's database.
        """

        raise NotImplementedError
    def is_mine(self, script: "Script"):
        """
        Return whether or not a `script` is part of this wallet (either internal or external).
        """

        raise NotImplementedError
    def latest_checkpoint(self, ):
        """
        Returns the latest checkpoint.
        """

        raise NotImplementedError
    def list_output(self, ):
        """
        List all relevant outputs (includes both spent and unspent, confirmed and unconfirmed).

        To list only unspent outputs (UTXOs), use [`Wallet::list_unspent`] instead.
        """

        raise NotImplementedError
    def list_unspent(self, ):
        """
        Return the list of unspent outputs of this wallet.
        """

        raise NotImplementedError
    def list_unused_addresses(self, keychain: "KeychainKind"):
        """
        List addresses that are revealed but unused.

        Note if the returned iterator is empty you can reveal more addresses
        by using [`reveal_next_address`](Self::reveal_next_address) or
        [`reveal_addresses_to`](Self::reveal_addresses_to).
        """

        raise NotImplementedError
    def mark_used(self, keychain: "KeychainKind",index: "int"):
        """
        Marks an address used of the given `keychain` at `index`.

        Returns whether the given index was present and then removed from the unused set.
        """

        raise NotImplementedError
    def network(self, ):
        """
        Get the Bitcoin network the wallet is using.
        """

        raise NotImplementedError
    def next_derivation_index(self, keychain: "KeychainKind"):
        """
        The index of the next address that you would get if you were to ask the wallet for a new
        address.
        """

        raise NotImplementedError
    def next_unused_address(self, keychain: "KeychainKind"):
        """
        Get the next unused address for the given `keychain`, i.e. the address with the lowest
        derivation index that hasn't been used in a transaction.

        This will attempt to reveal a new address if all previously revealed addresses have
        been used, in which case the returned address will be the same as calling [`Wallet::reveal_next_address`].

        **WARNING**: To avoid address reuse you must persist the changes resulting from one or more
        calls to this method before closing the wallet. See [`Wallet::reveal_next_address`].
        """

        raise NotImplementedError
    def peek_address(self, keychain: "KeychainKind",index: "int"):
        """
        Peek an address of the given `keychain` at `index` without revealing it.

        For non-wildcard descriptors this returns the same address at every provided index.

        # Panics

        This panics when the caller requests for an address of derivation index greater than the
        [BIP32](https://github.com/bitcoin/bips/blob/master/bip-0032.mediawiki) max index.
        """

        raise NotImplementedError
    def persist(self, persister: "Persister"):
        """
        Persist staged changes of wallet into persister.

        Returns whether any new changes were persisted.

        If the persister errors, the staged changes will not be cleared.
        """

        raise NotImplementedError
    def policies(self, keychain: "KeychainKind"):
        """
        Return the spending policies for the wallet’s descriptor.
        """

        raise NotImplementedError
    def public_descriptor(self, keychain: "KeychainKind"):
        """
        Returns the descriptor used to create addresses for a particular `keychain`.

        It's the "public" version of the wallet's descriptor, meaning a new descriptor that has
        the same structure but with the all secret keys replaced by their corresponding public key.
        This can be used to build a watch-only version of a wallet.
        """

        raise NotImplementedError
    def reveal_addresses_to(self, keychain: "KeychainKind",index: "int"):
        """
        Reveal addresses up to and including the target `index` and return an iterator
        of newly revealed addresses.

        If the target `index` is unreachable, we make a best effort to reveal up to the last
        possible index. If all addresses up to the given `index` are already revealed, then
        no new addresses are returned.

        **WARNING**: To avoid address reuse you must persist the changes resulting from one or more
        calls to this method before closing the wallet. See [`Wallet::reveal_next_address`].
        """

        raise NotImplementedError
    def reveal_next_address(self, keychain: "KeychainKind"):
        """
        Attempt to reveal the next address of the given `keychain`.

        This will increment the keychain's derivation index. If the keychain's descriptor doesn't
        contain a wildcard or every address is already revealed up to the maximum derivation
        index defined in [BIP32](https://github.com/bitcoin/bips/blob/master/bip-0032.mediawiki),
        then the last revealed address will be returned.
        """

        raise NotImplementedError
    def sent_and_received(self, tx: "Transaction"):
        """
        Compute the `tx`'s sent and received [`Amount`]s.

        This method returns a tuple `(sent, received)`. Sent is the sum of the txin amounts
        that spend from previous txouts tracked by this wallet. Received is the summation
        of this tx's outputs that send to script pubkeys tracked by this wallet.
        """

        raise NotImplementedError
    def sign(self, psbt: "Psbt",sign_options: "typing.Union[object, typing.Optional[SignOptions]]" = _DEFAULT):
        """
        Sign a transaction with all the wallet's signers, in the order specified by every signer's
        [`SignerOrdering`]. This function returns the `Result` type with an encapsulated `bool` that
        has the value true if the PSBT was finalized, or false otherwise.

        The [`SignOptions`] can be used to tweak the behavior of the software signers, and the way
        the transaction is finalized at the end. Note that it can't be guaranteed that *every*
        signers will follow the options, but the "software signers" (WIF keys and `xprv`) defined
        in this library will.
        """

        raise NotImplementedError
    def start_full_scan(self, ):
        """
        Create a [`FullScanRequest] for this wallet.

        This is the first step when performing a spk-based wallet full scan, the returned
        [`FullScanRequest] collects iterators for the wallet's keychain script pub keys needed to
        start a blockchain full scan with a spk based blockchain client.

        This operation is generally only used when importing or restoring a previously used wallet
        in which the list of used scripts is not known.
        """

        raise NotImplementedError
    def start_sync_with_revealed_spks(self, ):
        """
        Create a partial [`SyncRequest`] for this wallet for all revealed spks.

        This is the first step when performing a spk-based wallet partial sync, the returned
        [`SyncRequest`] collects all revealed script pubkeys from the wallet keychain needed to
        start a blockchain sync with a spk based blockchain client.
        """

        raise NotImplementedError
    def transactions(self, ):
        """
        Iterate over the transactions in the wallet.
        """

        raise NotImplementedError
    def tx_details(self, txid: "Txid"):
        """
        Get the [`TxDetails`] of a wallet transaction.
        """

        raise NotImplementedError
# Wallet is a Rust-only trait - it's a wrapper around a Rust implementation.
class Wallet():
    """
    A Bitcoin wallet.

    The Wallet acts as a way of coherently interfacing with output descriptors and related transactions. Its main components are:
    1. output descriptors from which it can derive addresses.
    2. signers that can contribute signatures to addresses instantiated from the descriptors.

    The user is responsible for loading and writing wallet changes which are represented as
    ChangeSets (see take_staged). Also see individual functions and example for instructions on when
    Wallet state needs to be persisted.

    The Wallet descriptor (external) and change descriptor (internal) must not derive the same
    script pubkeys. See KeychainTxOutIndex::insert_descriptor() for more details.
    """

    _pointer: ctypes.c_void_p
    def __init__(self, descriptor: "Descriptor",change_descriptor: "Descriptor",network: "Network",persister: "Persister",lookahead: "typing.Union[object, int]" = _DEFAULT):
        """
        Build a new Wallet.

        If you have previously created a wallet, use load instead.
        """

        _UniffiConverterTypeDescriptor.check_lower(descriptor)
        
        _UniffiConverterTypeDescriptor.check_lower(change_descriptor)
        
        _UniffiConverterTypeNetwork.check_lower(network)
        
        _UniffiConverterTypePersister.check_lower(persister)
        
        if lookahead is _DEFAULT:
            lookahead = 25
        _UniffiConverterUInt32.check_lower(lookahead)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeCreateWithPersistError,_UniffiLib.uniffi_bdkffi_fn_constructor_wallet_new,
        _UniffiConverterTypeDescriptor.lower(descriptor),
        _UniffiConverterTypeDescriptor.lower(change_descriptor),
        _UniffiConverterTypeNetwork.lower(network),
        _UniffiConverterTypePersister.lower(persister),
        _UniffiConverterUInt32.lower(lookahead))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_wallet, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_wallet, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst
    @classmethod
    def load(cls, descriptor: "Descriptor",change_descriptor: "Descriptor",persister: "Persister"):
        """
        Build Wallet by loading from persistence.
        """

        _UniffiConverterTypeDescriptor.check_lower(descriptor)
        
        _UniffiConverterTypeDescriptor.check_lower(change_descriptor)
        
        _UniffiConverterTypePersister.check_lower(persister)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLoadWithPersistError,_UniffiLib.uniffi_bdkffi_fn_constructor_wallet_load,
        _UniffiConverterTypeDescriptor.lower(descriptor),
        _UniffiConverterTypeDescriptor.lower(change_descriptor),
        _UniffiConverterTypePersister.lower(persister))
        return cls._make_instance_(pointer)



    def apply_unconfirmed_txs(self, unconfirmed_txs: "typing.List[UnconfirmedTx]") -> None:
        """
        Apply relevant unconfirmed transactions to the wallet.
        Transactions that are not relevant are filtered out.
        """

        _UniffiConverterSequenceTypeUnconfirmedTx.check_lower(unconfirmed_txs)
        
        _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_apply_unconfirmed_txs,self._uniffi_clone_pointer(),
        _UniffiConverterSequenceTypeUnconfirmedTx.lower(unconfirmed_txs))






    def apply_update(self, update: "Update") -> None:
        """
        Applies an update to the wallet and stages the changes (but does not persist them).

        Usually you create an `update` by interacting with some blockchain data source and inserting
        transactions related to your wallet into it.

        After applying updates you should persist the staged wallet changes. For an example of how
        to persist staged wallet changes see [`Wallet::reveal_next_address`].
        """

        _UniffiConverterTypeUpdate.check_lower(update)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeCannotConnectError,_UniffiLib.uniffi_bdkffi_fn_method_wallet_apply_update,self._uniffi_clone_pointer(),
        _UniffiConverterTypeUpdate.lower(update))






    def balance(self, ) -> "Balance":
        """
        Return the balance, separated into available, trusted-pending, untrusted-pending and
        immature values.
        """

        return _UniffiConverterTypeBalance.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_balance,self._uniffi_clone_pointer(),)
        )





    def calculate_fee(self, tx: "Transaction") -> "Amount":
        """
        Calculates the fee of a given transaction. Returns [`Amount::ZERO`] if `tx` is a coinbase transaction.

        To calculate the fee for a [`Transaction`] with inputs not owned by this wallet you must
        manually insert the TxOut(s) into the tx graph using the [`insert_txout`] function.

        Note `tx` does not have to be in the graph for this to work.
        """

        _UniffiConverterTypeTransaction.check_lower(tx)
        
        return _UniffiConverterTypeAmount.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeCalculateFeeError,_UniffiLib.uniffi_bdkffi_fn_method_wallet_calculate_fee,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTransaction.lower(tx))
        )





    def calculate_fee_rate(self, tx: "Transaction") -> "FeeRate":
        """
        Calculate the [`FeeRate`] for a given transaction.

        To calculate the fee rate for a [`Transaction`] with inputs not owned by this wallet you must
        manually insert the TxOut(s) into the tx graph using the [`insert_txout`] function.

        Note `tx` does not have to be in the graph for this to work.
        """

        _UniffiConverterTypeTransaction.check_lower(tx)
        
        return _UniffiConverterTypeFeeRate.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeCalculateFeeError,_UniffiLib.uniffi_bdkffi_fn_method_wallet_calculate_fee_rate,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTransaction.lower(tx))
        )





    def cancel_tx(self, tx: "Transaction") -> None:
        """
        Informs the wallet that you no longer intend to broadcast a tx that was built from it.

        This frees up the change address used when creating the tx for use in future transactions.
        """

        _UniffiConverterTypeTransaction.check_lower(tx)
        
        _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_cancel_tx,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTransaction.lower(tx))






    def derivation_index(self, keychain: "KeychainKind") -> "typing.Optional[int]":
        """
        The derivation index of this wallet. It will return `None` if it has not derived any addresses.
        Otherwise, it will return the index of the highest address it has derived.
        """

        _UniffiConverterTypeKeychainKind.check_lower(keychain)
        
        return _UniffiConverterOptionalUInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_derivation_index,self._uniffi_clone_pointer(),
        _UniffiConverterTypeKeychainKind.lower(keychain))
        )





    def derivation_of_spk(self, spk: "Script") -> "typing.Optional[KeychainAndIndex]":
        """
        Finds how the wallet derived the script pubkey `spk`.

        Will only return `Some(_)` if the wallet has given out the spk.
        """

        _UniffiConverterTypeScript.check_lower(spk)
        
        return _UniffiConverterOptionalTypeKeychainAndIndex.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_derivation_of_spk,self._uniffi_clone_pointer(),
        _UniffiConverterTypeScript.lower(spk))
        )





    def descriptor_checksum(self, keychain: "KeychainKind") -> "str":
        """
        Return the checksum of the public descriptor associated to `keychain`.

        Internally calls [`Self::public_descriptor`] to fetch the right descriptor.
        """

        _UniffiConverterTypeKeychainKind.check_lower(keychain)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_descriptor_checksum,self._uniffi_clone_pointer(),
        _UniffiConverterTypeKeychainKind.lower(keychain))
        )





    def finalize_psbt(self, psbt: "Psbt",sign_options: "typing.Union[object, typing.Optional[SignOptions]]" = _DEFAULT) -> "bool":
        """
        Finalize a PSBT, i.e., for each input determine if sufficient data is available to pass
        validation and construct the respective `scriptSig` or `scriptWitness`. Please refer to
        [BIP174](https://github.com/bitcoin/bips/blob/master/bip-0174.mediawiki#Input_Finalizer),
        and [BIP371](https://github.com/bitcoin/bips/blob/master/bip-0371.mediawiki)
        for further information.

        Returns `true` if the PSBT could be finalized, and `false` otherwise.

        The [`SignOptions`] can be used to tweak the behavior of the finalizer.
        """

        _UniffiConverterTypePsbt.check_lower(psbt)
        
        if sign_options is _DEFAULT:
            sign_options = None
        _UniffiConverterOptionalTypeSignOptions.check_lower(sign_options)
        
        return _UniffiConverterBool.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeSignerError,_UniffiLib.uniffi_bdkffi_fn_method_wallet_finalize_psbt,self._uniffi_clone_pointer(),
        _UniffiConverterTypePsbt.lower(psbt),
        _UniffiConverterOptionalTypeSignOptions.lower(sign_options))
        )





    def get_tx(self, txid: "Txid") -> "typing.Optional[CanonicalTx]":
        """
        Get a single transaction from the wallet as a [`WalletTx`] (if the transaction exists).

        `WalletTx` contains the full transaction alongside meta-data such as:
        * Blocks that the transaction is [`Anchor`]ed in. These may or may not be blocks that exist
        in the best chain.
        * The [`ChainPosition`] of the transaction in the best chain - whether the transaction is
        confirmed or unconfirmed. If the transaction is confirmed, the anchor which proves the
        confirmation is provided. If the transaction is unconfirmed, the unix timestamp of when
        the transaction was last seen in the mempool is provided.
        """

        _UniffiConverterTypeTxid.check_lower(txid)
        
        return _UniffiConverterOptionalTypeCanonicalTx.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeTxidParseError,_UniffiLib.uniffi_bdkffi_fn_method_wallet_get_tx,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTxid.lower(txid))
        )





    def get_utxo(self, op: "OutPoint") -> "typing.Optional[LocalOutput]":
        """
        Returns the utxo owned by this wallet corresponding to `outpoint` if it exists in the
        wallet's database.
        """

        _UniffiConverterTypeOutPoint.check_lower(op)
        
        return _UniffiConverterOptionalTypeLocalOutput.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_get_utxo,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOutPoint.lower(op))
        )





    def is_mine(self, script: "Script") -> "bool":
        """
        Return whether or not a `script` is part of this wallet (either internal or external).
        """

        _UniffiConverterTypeScript.check_lower(script)
        
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_is_mine,self._uniffi_clone_pointer(),
        _UniffiConverterTypeScript.lower(script))
        )





    def latest_checkpoint(self, ) -> "BlockId":
        """
        Returns the latest checkpoint.
        """

        return _UniffiConverterTypeBlockId.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_latest_checkpoint,self._uniffi_clone_pointer(),)
        )





    def list_output(self, ) -> "typing.List[LocalOutput]":
        """
        List all relevant outputs (includes both spent and unspent, confirmed and unconfirmed).

        To list only unspent outputs (UTXOs), use [`Wallet::list_unspent`] instead.
        """

        return _UniffiConverterSequenceTypeLocalOutput.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_list_output,self._uniffi_clone_pointer(),)
        )





    def list_unspent(self, ) -> "typing.List[LocalOutput]":
        """
        Return the list of unspent outputs of this wallet.
        """

        return _UniffiConverterSequenceTypeLocalOutput.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_list_unspent,self._uniffi_clone_pointer(),)
        )





    def list_unused_addresses(self, keychain: "KeychainKind") -> "typing.List[AddressInfo]":
        """
        List addresses that are revealed but unused.

        Note if the returned iterator is empty you can reveal more addresses
        by using [`reveal_next_address`](Self::reveal_next_address) or
        [`reveal_addresses_to`](Self::reveal_addresses_to).
        """

        _UniffiConverterTypeKeychainKind.check_lower(keychain)
        
        return _UniffiConverterSequenceTypeAddressInfo.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_list_unused_addresses,self._uniffi_clone_pointer(),
        _UniffiConverterTypeKeychainKind.lower(keychain))
        )





    def mark_used(self, keychain: "KeychainKind",index: "int") -> "bool":
        """
        Marks an address used of the given `keychain` at `index`.

        Returns whether the given index was present and then removed from the unused set.
        """

        _UniffiConverterTypeKeychainKind.check_lower(keychain)
        
        _UniffiConverterUInt32.check_lower(index)
        
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_mark_used,self._uniffi_clone_pointer(),
        _UniffiConverterTypeKeychainKind.lower(keychain),
        _UniffiConverterUInt32.lower(index))
        )





    def network(self, ) -> "Network":
        """
        Get the Bitcoin network the wallet is using.
        """

        return _UniffiConverterTypeNetwork.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_network,self._uniffi_clone_pointer(),)
        )





    def next_derivation_index(self, keychain: "KeychainKind") -> "int":
        """
        The index of the next address that you would get if you were to ask the wallet for a new
        address.
        """

        _UniffiConverterTypeKeychainKind.check_lower(keychain)
        
        return _UniffiConverterUInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_next_derivation_index,self._uniffi_clone_pointer(),
        _UniffiConverterTypeKeychainKind.lower(keychain))
        )





    def next_unused_address(self, keychain: "KeychainKind") -> "AddressInfo":
        """
        Get the next unused address for the given `keychain`, i.e. the address with the lowest
        derivation index that hasn't been used in a transaction.

        This will attempt to reveal a new address if all previously revealed addresses have
        been used, in which case the returned address will be the same as calling [`Wallet::reveal_next_address`].

        **WARNING**: To avoid address reuse you must persist the changes resulting from one or more
        calls to this method before closing the wallet. See [`Wallet::reveal_next_address`].
        """

        _UniffiConverterTypeKeychainKind.check_lower(keychain)
        
        return _UniffiConverterTypeAddressInfo.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_next_unused_address,self._uniffi_clone_pointer(),
        _UniffiConverterTypeKeychainKind.lower(keychain))
        )





    def peek_address(self, keychain: "KeychainKind",index: "int") -> "AddressInfo":
        """
        Peek an address of the given `keychain` at `index` without revealing it.

        For non-wildcard descriptors this returns the same address at every provided index.

        # Panics

        This panics when the caller requests for an address of derivation index greater than the
        [BIP32](https://github.com/bitcoin/bips/blob/master/bip-0032.mediawiki) max index.
        """

        _UniffiConverterTypeKeychainKind.check_lower(keychain)
        
        _UniffiConverterUInt32.check_lower(index)
        
        return _UniffiConverterTypeAddressInfo.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_peek_address,self._uniffi_clone_pointer(),
        _UniffiConverterTypeKeychainKind.lower(keychain),
        _UniffiConverterUInt32.lower(index))
        )





    def persist(self, persister: "Persister") -> "bool":
        """
        Persist staged changes of wallet into persister.

        Returns whether any new changes were persisted.

        If the persister errors, the staged changes will not be cleared.
        """

        _UniffiConverterTypePersister.check_lower(persister)
        
        return _UniffiConverterBool.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypePersistenceError,_UniffiLib.uniffi_bdkffi_fn_method_wallet_persist,self._uniffi_clone_pointer(),
        _UniffiConverterTypePersister.lower(persister))
        )





    def policies(self, keychain: "KeychainKind") -> "typing.Optional[Policy]":
        """
        Return the spending policies for the wallet’s descriptor.
        """

        _UniffiConverterTypeKeychainKind.check_lower(keychain)
        
        return _UniffiConverterOptionalTypePolicy.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeDescriptorError,_UniffiLib.uniffi_bdkffi_fn_method_wallet_policies,self._uniffi_clone_pointer(),
        _UniffiConverterTypeKeychainKind.lower(keychain))
        )





    def public_descriptor(self, keychain: "KeychainKind") -> "str":
        """
        Returns the descriptor used to create addresses for a particular `keychain`.

        It's the "public" version of the wallet's descriptor, meaning a new descriptor that has
        the same structure but with the all secret keys replaced by their corresponding public key.
        This can be used to build a watch-only version of a wallet.
        """

        _UniffiConverterTypeKeychainKind.check_lower(keychain)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_public_descriptor,self._uniffi_clone_pointer(),
        _UniffiConverterTypeKeychainKind.lower(keychain))
        )





    def reveal_addresses_to(self, keychain: "KeychainKind",index: "int") -> "typing.List[AddressInfo]":
        """
        Reveal addresses up to and including the target `index` and return an iterator
        of newly revealed addresses.

        If the target `index` is unreachable, we make a best effort to reveal up to the last
        possible index. If all addresses up to the given `index` are already revealed, then
        no new addresses are returned.

        **WARNING**: To avoid address reuse you must persist the changes resulting from one or more
        calls to this method before closing the wallet. See [`Wallet::reveal_next_address`].
        """

        _UniffiConverterTypeKeychainKind.check_lower(keychain)
        
        _UniffiConverterUInt32.check_lower(index)
        
        return _UniffiConverterSequenceTypeAddressInfo.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_reveal_addresses_to,self._uniffi_clone_pointer(),
        _UniffiConverterTypeKeychainKind.lower(keychain),
        _UniffiConverterUInt32.lower(index))
        )





    def reveal_next_address(self, keychain: "KeychainKind") -> "AddressInfo":
        """
        Attempt to reveal the next address of the given `keychain`.

        This will increment the keychain's derivation index. If the keychain's descriptor doesn't
        contain a wildcard or every address is already revealed up to the maximum derivation
        index defined in [BIP32](https://github.com/bitcoin/bips/blob/master/bip-0032.mediawiki),
        then the last revealed address will be returned.
        """

        _UniffiConverterTypeKeychainKind.check_lower(keychain)
        
        return _UniffiConverterTypeAddressInfo.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_reveal_next_address,self._uniffi_clone_pointer(),
        _UniffiConverterTypeKeychainKind.lower(keychain))
        )





    def sent_and_received(self, tx: "Transaction") -> "SentAndReceivedValues":
        """
        Compute the `tx`'s sent and received [`Amount`]s.

        This method returns a tuple `(sent, received)`. Sent is the sum of the txin amounts
        that spend from previous txouts tracked by this wallet. Received is the summation
        of this tx's outputs that send to script pubkeys tracked by this wallet.
        """

        _UniffiConverterTypeTransaction.check_lower(tx)
        
        return _UniffiConverterTypeSentAndReceivedValues.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_sent_and_received,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTransaction.lower(tx))
        )





    def sign(self, psbt: "Psbt",sign_options: "typing.Union[object, typing.Optional[SignOptions]]" = _DEFAULT) -> "bool":
        """
        Sign a transaction with all the wallet's signers, in the order specified by every signer's
        [`SignerOrdering`]. This function returns the `Result` type with an encapsulated `bool` that
        has the value true if the PSBT was finalized, or false otherwise.

        The [`SignOptions`] can be used to tweak the behavior of the software signers, and the way
        the transaction is finalized at the end. Note that it can't be guaranteed that *every*
        signers will follow the options, but the "software signers" (WIF keys and `xprv`) defined
        in this library will.
        """

        _UniffiConverterTypePsbt.check_lower(psbt)
        
        if sign_options is _DEFAULT:
            sign_options = None
        _UniffiConverterOptionalTypeSignOptions.check_lower(sign_options)
        
        return _UniffiConverterBool.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeSignerError,_UniffiLib.uniffi_bdkffi_fn_method_wallet_sign,self._uniffi_clone_pointer(),
        _UniffiConverterTypePsbt.lower(psbt),
        _UniffiConverterOptionalTypeSignOptions.lower(sign_options))
        )





    def start_full_scan(self, ) -> "FullScanRequestBuilder":
        """
        Create a [`FullScanRequest] for this wallet.

        This is the first step when performing a spk-based wallet full scan, the returned
        [`FullScanRequest] collects iterators for the wallet's keychain script pub keys needed to
        start a blockchain full scan with a spk based blockchain client.

        This operation is generally only used when importing or restoring a previously used wallet
        in which the list of used scripts is not known.
        """

        return _UniffiConverterTypeFullScanRequestBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_start_full_scan,self._uniffi_clone_pointer(),)
        )





    def start_sync_with_revealed_spks(self, ) -> "SyncRequestBuilder":
        """
        Create a partial [`SyncRequest`] for this wallet for all revealed spks.

        This is the first step when performing a spk-based wallet partial sync, the returned
        [`SyncRequest`] collects all revealed script pubkeys from the wallet keychain needed to
        start a blockchain sync with a spk based blockchain client.
        """

        return _UniffiConverterTypeSyncRequestBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_start_sync_with_revealed_spks,self._uniffi_clone_pointer(),)
        )





    def transactions(self, ) -> "typing.List[CanonicalTx]":
        """
        Iterate over the transactions in the wallet.
        """

        return _UniffiConverterSequenceTypeCanonicalTx.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_transactions,self._uniffi_clone_pointer(),)
        )





    def tx_details(self, txid: "Txid") -> "typing.Optional[TxDetails]":
        """
        Get the [`TxDetails`] of a wallet transaction.
        """

        _UniffiConverterTypeTxid.check_lower(txid)
        
        return _UniffiConverterOptionalTypeTxDetails.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wallet_tx_details,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTxid.lower(txid))
        )






class _UniffiConverterTypeWallet:

    @staticmethod
    def lift(value: int):
        return Wallet._make_instance_(value)

    @staticmethod
    def check_lower(value: Wallet):
        if not isinstance(value, Wallet):
            raise TypeError("Expected Wallet instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: WalletProtocol):
        if not isinstance(value, Wallet):
            raise TypeError("Expected Wallet instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: WalletProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class WtxidProtocol(typing.Protocol):
    """
    A bitcoin transaction identifier, including witness data.
    For transactions with no SegWit inputs, the `txid` will be equivalent to `wtxid`.
    """

    def serialize(self, ):
        """
        Serialize this type into a 32 byte array.
        """

        raise NotImplementedError
# Wtxid is a Rust-only trait - it's a wrapper around a Rust implementation.
class Wtxid():
    """
    A bitcoin transaction identifier, including witness data.
    For transactions with no SegWit inputs, the `txid` will be equivalent to `wtxid`.
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_free_wtxid, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_clone_wtxid, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst
    @classmethod
    def from_bytes(cls, bytes: "bytes"):
        """
        Construct a hash-like type from 32 bytes.
        """

        _UniffiConverterBytes.check_lower(bytes)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeHashParseError,_UniffiLib.uniffi_bdkffi_fn_constructor_wtxid_from_bytes,
        _UniffiConverterBytes.lower(bytes))
        return cls._make_instance_(pointer)

    @classmethod
    def from_string(cls, hex: "str"):
        """
        Construct a hash-like type from a hex string.
        """

        _UniffiConverterString.check_lower(hex)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeHashParseError,_UniffiLib.uniffi_bdkffi_fn_constructor_wtxid_from_string,
        _UniffiConverterString.lower(hex))
        return cls._make_instance_(pointer)



    def serialize(self, ) -> "bytes":
        """
        Serialize this type into a 32 byte array.
        """

        return _UniffiConverterBytes.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wtxid_serialize,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wtxid_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )



    def __eq__(self, other: object) -> bool:
        if not isinstance(other, Wtxid):
            return NotImplemented

        return _UniffiConverterBool.lift(_uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wtxid_uniffi_trait_eq_eq,self._uniffi_clone_pointer(),
        _UniffiConverterTypeWtxid.lower(other)))

    def __ne__(self, other: object) -> bool:
        if not isinstance(other, Wtxid):
            return NotImplemented

        return _UniffiConverterBool.lift(_uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wtxid_uniffi_trait_eq_ne,self._uniffi_clone_pointer(),
        _UniffiConverterTypeWtxid.lower(other)))


    def __hash__(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_bdkffi_fn_method_wtxid_uniffi_trait_hash,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeWtxid:

    @staticmethod
    def lift(value: int):
        return Wtxid._make_instance_(value)

    @staticmethod
    def check_lower(value: Wtxid):
        if not isinstance(value, Wtxid):
            raise TypeError("Expected Wtxid instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: WtxidProtocol):
        if not isinstance(value, Wtxid):
            raise TypeError("Expected Wtxid instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: WtxidProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))

# Async support# RustFuturePoll values
_UNIFFI_RUST_FUTURE_POLL_READY = 0
_UNIFFI_RUST_FUTURE_POLL_MAYBE_READY = 1

# Stores futures for _uniffi_continuation_callback
_UniffiContinuationHandleMap = _UniffiHandleMap()

_UNIFFI_GLOBAL_EVENT_LOOP = None

"""
Set the event loop to use for async functions

This is needed if some async functions run outside of the eventloop, for example:
    - A non-eventloop thread is spawned, maybe from `EventLoop.run_in_executor` or maybe from the
      Rust code spawning its own thread.
    - The Rust code calls an async callback method from a sync callback function, using something
      like `pollster` to block on the async call.

In this case, we need an event loop to run the Python async function, but there's no eventloop set
for the thread.  Use `uniffi_set_event_loop` to force an eventloop to be used in this case.
"""
def uniffi_set_event_loop(eventloop: asyncio.BaseEventLoop):
    global _UNIFFI_GLOBAL_EVENT_LOOP
    _UNIFFI_GLOBAL_EVENT_LOOP = eventloop

def _uniffi_get_event_loop():
    if _UNIFFI_GLOBAL_EVENT_LOOP is not None:
        return _UNIFFI_GLOBAL_EVENT_LOOP
    else:
        return asyncio.get_running_loop()

# Continuation callback for async functions
# lift the return value or error and resolve the future, causing the async function to resume.
@_UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK
def _uniffi_continuation_callback(future_ptr, poll_code):
    (eventloop, future) = _UniffiContinuationHandleMap.remove(future_ptr)
    eventloop.call_soon_threadsafe(_uniffi_set_future_result, future, poll_code)

def _uniffi_set_future_result(future, poll_code):
    if not future.cancelled():
        future.set_result(poll_code)

async def _uniffi_rust_call_async(rust_future, ffi_poll, ffi_complete, ffi_free, lift_func, error_ffi_converter):
    try:
        eventloop = _uniffi_get_event_loop()

        # Loop and poll until we see a _UNIFFI_RUST_FUTURE_POLL_READY value
        while True:
            future = eventloop.create_future()
            ffi_poll(
                rust_future,
                _uniffi_continuation_callback,
                _UniffiContinuationHandleMap.insert((eventloop, future)),
            )
            poll_code = await future
            if poll_code == _UNIFFI_RUST_FUTURE_POLL_READY:
                break

        return lift_func(
            _uniffi_rust_call_with_error(error_ffi_converter, ffi_complete, rust_future)
        )
    finally:
        ffi_free(rust_future)

__all__ = [
    "InternalError",
    "AddressData",
    "AddressParseError",
    "Bip32Error",
    "Bip39Error",
    "CalculateFeeError",
    "CannotConnectError",
    "CbfBuilderError",
    "CbfError",
    "ChainPosition",
    "ChangeSpendPolicy",
    "CreateTxError",
    "CreateWithPersistError",
    "DescriptorError",
    "DescriptorKeyError",
    "ElectrumError",
    "EsploraError",
    "ExtractTxError",
    "FeeRateError",
    "FromScriptError",
    "HashParseError",
    "Info",
    "KeychainKind",
    "LoadWithPersistError",
    "LockTime",
    "LogLevel",
    "MiniscriptError",
    "Network",
    "NodeState",
    "ParseAmountError",
    "PersistenceError",
    "PkOrF",
    "PsbtError",
    "PsbtFinalizeError",
    "PsbtParseError",
    "RequestBuilderError",
    "Satisfaction",
    "SatisfiableItem",
    "ScanType",
    "SignerError",
    "TransactionError",
    "TxidParseError",
    "Warning",
    "WordCount",
    "AddressInfo",
    "Anchor",
    "Balance",
    "BlockId",
    "CanonicalTx",
    "CbfComponents",
    "ChainChange",
    "Condition",
    "ConfirmationBlockTime",
    "FinalizedPsbtResult",
    "Header",
    "HeaderNotification",
    "IndexerChangeSet",
    "KeychainAndIndex",
    "LocalChainChangeSet",
    "LocalOutput",
    "OutPoint",
    "Peer",
    "ScriptAmount",
    "SentAndReceivedValues",
    "ServerFeaturesRes",
    "SignOptions",
    "Socks5Proxy",
    "Tx",
    "TxDetails",
    "TxGraphChangeSet",
    "TxIn",
    "TxOut",
    "TxStatus",
    "UnconfirmedTx",
    "WitnessProgram",
    "Address",
    "Amount",
    "BlockHash",
    "BumpFeeTxBuilder",
    "CbfBuilder",
    "CbfClient",
    "CbfNode",
    "ChangeSet",
    "DerivationPath",
    "Descriptor",
    "DescriptorId",
    "DescriptorPublicKey",
    "DescriptorSecretKey",
    "ElectrumClient",
    "EsploraClient",
    "FeeRate",
    "FullScanRequest",
    "FullScanRequestBuilder",
    "FullScanScriptInspector",
    "HashableOutPoint",
    "IpAddress",
    "Mnemonic",
    "Persistence",
    "Persister",
    "Policy",
    "Psbt",
    "Script",
    "SyncRequest",
    "SyncRequestBuilder",
    "SyncScriptInspector",
    "Transaction",
    "TxBuilder",
    "TxMerkleNode",
    "Txid",
    "Update",
    "Wallet",
    "Wtxid",
]

