/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core;

import io.javalin.core.HandlerEntry;
import io.javalin.core.HandlerType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u001bJ\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u0018H\u0002R-\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/javalin/core/PathMatcher;", "", "()V", "handlerEntries", "Ljava/util/EnumMap;", "Lio/javalin/core/HandlerType;", "Ljava/util/ArrayList;", "Lio/javalin/core/HandlerEntry;", "Lkotlin/collections/ArrayList;", "getHandlerEntries", "()Ljava/util/EnumMap;", "ignoreTrailingSlashes", "", "getIgnoreTrailingSlashes", "()Z", "setIgnoreTrailingSlashes", "(Z)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "findEntries", "", "requestType", "requestUri", "", "findHandlerPath", "predicate", "Lkotlin/Function1;", "match", "entry", "requestPath", "slashMismatch", "s1", "s2", "javalin"})
public final class PathMatcher {
    private boolean ignoreTrailingSlashes = true;
    private final Logger log = LoggerFactory.getLogger(PathMatcher.class);
    @NotNull
    private final EnumMap<HandlerType, ArrayList<HandlerEntry>> handlerEntries;

    public final boolean getIgnoreTrailingSlashes() {
        return this.ignoreTrailingSlashes;
    }

    public final void setIgnoreTrailingSlashes(boolean bl) {
        this.ignoreTrailingSlashes = bl;
    }

    @NotNull
    public final EnumMap<HandlerType, ArrayList<HandlerEntry>> getHandlerEntries() {
        return this.handlerEntries;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<HandlerEntry> findEntries(@NotNull HandlerType requestType, @NotNull String requestUri) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)requestType), (String)"requestType");
        Intrinsics.checkParameterIsNotNull((Object)requestUri, (String)"requestUri");
        ArrayList<HandlerEntry> arrayList = this.handlerEntries.get((Object)requestType);
        if (arrayList == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"handlerEntries[requestType]!!");
        Iterable iterable = $receiver$iv = (Iterable)arrayList;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            HandlerEntry he = (HandlerEntry)element$iv$iv;
            if (!this.match(he, requestUri)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean match(HandlerEntry entry, String requestPath) {
        return Intrinsics.areEqual((Object)entry.getPath(), (Object)"*") ? true : (Intrinsics.areEqual((Object)entry.getPath(), (Object)requestPath) ? true : (!this.ignoreTrailingSlashes && this.slashMismatch(entry.getPath(), requestPath) ? false : entry.matches(requestPath)));
    }

    private final boolean slashMismatch(String s1, String s2) {
        return (StringsKt.endsWith$default((CharSequence)s1, (char)'/', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)s2, (char)'/', (boolean)false, (int)2, null)) && StringsKt.last((CharSequence)s1) != StringsKt.last((CharSequence)s2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String findHandlerPath(@NotNull Function1<? super HandlerEntry, Boolean> predicate) {
        Collection collection;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        Collection<ArrayList<HandlerEntry>> collection2 = this.handlerEntries.values();
        Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"handlerEntries.values");
        Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.flatten((Iterable)collection2);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!((Boolean)predicate.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List entries = (List)destination$iv$iv;
        if (entries.size() > 1) {
            this.log.warn("More than one path found for handler, returning first match: '{} {}'", (Object)((HandlerEntry)entries.get(0)).getType(), (Object)((HandlerEntry)entries.get(0)).getPath());
        }
        return !(collection = (Collection)entries).isEmpty() ? ((HandlerEntry)entries.get(0)).getPath() : null;
    }

    /*
     * WARNING - void declaration
     */
    public PathMatcher() {
        void $receiver$iv;
        HandlerType[] handlerTypeArray = HandlerType.values();
        Map map = new EnumMap(HandlerType.class);
        PathMatcher pathMatcher = this;
        for (void element$iv : $receiver$iv) {
            void it;
            void destination$iv;
            void var6_7 = destination$iv;
            void var8_9 = it = element$iv;
            ArrayList arrayList = new ArrayList();
            Pair pair = TuplesKt.to((Object)var8_9, arrayList);
            var6_7.put(pair.getFirst(), pair.getSecond());
        }
        Map map2 = map;
        pathMatcher.handlerEntries = (EnumMap)map2;
    }
}

