/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ShortArrays;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractShortArrayAssert<S extends AbstractShortArrayAssert<S>>
extends AbstractArrayAssert<S, short[], Short> {
    @VisibleForTesting
    protected ShortArrays arrays = ShortArrays.instance();

    public AbstractShortArrayAssert(short[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (short[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (short[])this.actual);
    }

    @Override
    public S isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (short[])this.actual);
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    @Override
    public S hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (short[])this.actual, expected);
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (short[])this.actual, other);
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    public S contains(short ... values) {
        this.arrays.assertContains(this.info, (short[])this.actual, values);
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    public S containsOnly(short ... values) {
        this.arrays.assertContainsOnly(this.info, (short[])this.actual, values);
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    public S containsOnlyOnce(short ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (short[])this.actual, values);
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    public S containsSequence(short ... sequence) {
        this.arrays.assertContainsSequence(this.info, (short[])this.actual, sequence);
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    public S containsSubsequence(short ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (short[])this.actual, subsequence);
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    public S contains(short value, Index index) {
        this.arrays.assertContains(this.info, (short[])this.actual, value, index);
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    public S doesNotContain(short ... values) {
        this.arrays.assertDoesNotContain(this.info, (short[])this.actual, values);
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    public S doesNotContain(short value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (short[])this.actual, value, index);
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    public S doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (short[])this.actual);
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    public S startsWith(short ... sequence) {
        this.arrays.assertStartsWith(this.info, (short[])this.actual, sequence);
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    public S endsWith(short ... sequence) {
        this.arrays.assertEndsWith(this.info, (short[])this.actual, sequence);
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    @Override
    public S isSorted() {
        this.arrays.assertIsSorted(this.info, (short[])this.actual);
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    @Override
    public S isSortedAccordingTo(Comparator<? super Short> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (short[])this.actual, comparator);
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    @Override
    public S usingElementComparator(Comparator<? super Short> customComparator) {
        this.arrays = new ShortArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    @Override
    public S usingDefaultElementComparator() {
        this.arrays = ShortArrays.instance();
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    public S containsExactly(short ... values) {
        this.objects.assertEqual(this.info, this.actual, values);
        return (S)((AbstractShortArrayAssert)this.myself);
    }

    public S containsExactlyInAnyOrder(short ... values) {
        this.arrays.assertContainsExactlyInAnyOrder(this.info, (short[])this.actual, values);
        return (S)((AbstractShortArrayAssert)this.myself);
    }
}

