/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.MessageCreatorService;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandType;
import com.twosigma.beakerx.kernel.magic.command.functionality.LoadMagicMagicCommandInfo;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import java.lang.reflect.Constructor;

public class LoadMagicMagicCommand
implements MagicCommandFunctionality,
LoadMagicMagicCommandInfo {
    private KernelFunctionality kernel;
    private MessageCreatorService messageCreatorService;

    public LoadMagicMagicCommand(KernelFunctionality kernel, MessageCreatorService messageCreatorService) {
        this.kernel = kernel;
        this.messageCreatorService = messageCreatorService;
    }

    public String getMagicCommandName() {
        return "%load_magic";
    }

    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        String command = param.getCommand();
        String[] split = MagicCommandUtils.splitPath((String)command);
        if (split.length != 2) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Wrong format. %load_magic", this.messageCreatorService);
        }
        String clazzName = split[1];
        return this.load(clazzName);
    }

    public MagicCommandOutcomeItem load(String clazzName) {
        try {
            Class aClass = this.kernel.loadClass(clazzName);
            Constructor constructor = null;
            try {
                constructor = aClass.getConstructor(KernelFunctionality.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object instance = null;
            instance = constructor != null ? constructor.newInstance(this.kernel) : aClass.newInstance();
            if (instance instanceof MagicCommandFunctionality) {
                MagicCommandFunctionality commandFunctionality = instance;
                this.kernel.registerMagicCommandType(new MagicCommandType(commandFunctionality.getMagicCommandName(), "", commandFunctionality));
                return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, "Magic command " + commandFunctionality.getMagicCommandName() + " was successfully added.", this.messageCreatorService);
            }
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Magic command have to implement " + MagicCommandFunctionality.class + " interface.", this.messageCreatorService);
        }
        catch (Exception e) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, e.toString(), this.messageCreatorService);
        }
    }
}

