/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.clojure.evaluator;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.clojure.evaluator.ClojureCodeRunner;
import com.twosigma.beakerx.clojure.evaluator.ClojureEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClojureWorkerThread
implements Callable<TryResult> {
    private static final Logger logger = LoggerFactory.getLogger((String)ClojureWorkerThread.class.getName());
    private ClojureEvaluator clojureEvaluator;
    private final JobDescriptor j;

    ClojureWorkerThread(ClojureEvaluator clojureEvaluator, JobDescriptor j) {
        this.clojureEvaluator = clojureEvaluator;
        this.j = j;
    }

    @Override
    public TryResult call() {
        TryResult.CellError r;
        try {
            this.j.outputObject.started();
            r = this.clojureEvaluator.executeTask(new ClojureCodeRunner(this.clojureEvaluator, this.j.codeToBeExecuted, this.j.outputObject), this.j.getExecutionOptions());
        }
        catch (Throwable e) {
            logger.error(e.getMessage());
            r = TryResult.createError((String)e.getLocalizedMessage());
        }
        return r;
    }

    void doExit() {
    }
}

