/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.clojure.serializers;

import clojure.lang.PersistentVector;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.jvm.serialization.ObjectDeserializer;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClojureCollectionDeserializer
implements ObjectDeserializer {
    private static final Logger logger = LoggerFactory.getLogger((String)ClojureCollectionDeserializer.class.getName());
    private final BeakerObjectConverter parent;

    public ClojureCollectionDeserializer(BeakerObjectConverter p) {
        this.parent = p;
    }

    public boolean canBeUsed(JsonNode n) {
        return n.isArray();
    }

    public Object deserialize(JsonNode n, ObjectMapper mapper) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < n.size(); ++i) {
            try {
                list.add(this.parent.deserialize(n.get(i), mapper));
                continue;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        PersistentVector collection = PersistentVector.create(list);
        return collection;
    }
}

