/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.clojure.serializers;

import clojure.lang.PersistentArrayMap;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.jvm.serialization.ObjectDeserializer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class ClojureMapDeserializer
implements ObjectDeserializer {
    private final BeakerObjectConverter parent;

    public ClojureMapDeserializer(BeakerObjectConverter p) {
        this.parent = p;
    }

    public boolean canBeUsed(JsonNode n) {
        return n.isObject() && (!n.has("type") || !this.parent.isKnownBeakerType(n.get("type").asText()));
    }

    public Object deserialize(JsonNode n, ObjectMapper mapper) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator entries = n.fields();
        while (entries.hasNext()) {
            try {
                Map.Entry ee = (Map.Entry)entries.next();
                map.put((String)ee.getKey(), this.parent.deserialize((JsonNode)ee.getValue(), mapper));
            }
            catch (Exception e) {
                LoggerFactory.getLogger((String)this.getClass().getName()).error(e.getMessage());
            }
        }
        return PersistentArrayMap.create(map);
    }
}

