/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.jvm.serialization.ObjectDeserializer;
import com.twosigma.beakerx.util.Images;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedImageDeserializer
implements ObjectDeserializer {
    private static final Logger logger = LoggerFactory.getLogger((String)BufferedImageDeserializer.class.getName());

    public BufferedImageDeserializer(BeakerObjectConverter p) {
        p.addKnownBeakerType("ImageIcon");
    }

    public boolean canBeUsed(JsonNode n) {
        return n.has("type") && n.get("type").asText().equals("ImageIcon");
    }

    public Object deserialize(JsonNode n, ObjectMapper mapper) {
        BufferedImage o = null;
        try {
            if (n.has("imageData")) {
                byte[] data = n.get("imageData").binaryValue();
                o = Images.decode(data);
            }
        }
        catch (Exception e) {
            logger.error("exception deserializing ImageIcon ", (Throwable)e);
        }
        return o;
    }
}

