/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command;

import com.twosigma.beakerx.autocomplete.MagicCommandAutocompletePatterns;
import com.twosigma.beakerx.evaluator.SimpleEvaluationObjectFactory;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandConfiguration;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandType;
import com.twosigma.beakerx.kernel.magic.command.MavenJarResolverService;
import com.twosigma.beakerx.kernel.magic.command.functionality.AddImportMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.AddStaticImportMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.AsyncMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.BashMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClassPathAddMvnCellMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddDynamicMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddJarMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddMvnMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddRepoMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathResetMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathShowMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.FileService;
import com.twosigma.beakerx.kernel.magic.command.functionality.HtmlAliasMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.HtmlMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.JSMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.JavaScriptMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.LoadMagicMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.LsMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeCellModeMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeItCellModeMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeItLineModeMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeLineModeMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.UnImportMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.kernelMagic.ClojureMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.kernelMagic.GroovyMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.kernelMagic.JavaMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.kernelMagic.KernelMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.kernelMagic.KotlinMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.kernelMagic.PythonMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.kernelMagic.SQLMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.kernelMagic.ScalaMagicCommand;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class MagicCommandConfigurationImpl
implements MagicCommandConfiguration {
    private MagicCommandAutocompletePatterns autocompletePatterns;
    private FileService fileService;
    private MavenJarResolverService resolverService;
    private SimpleEvaluationObjectFactory objectFactory;

    public MagicCommandConfigurationImpl(FileService fileService, MavenJarResolverService mavenJarResolverService, MagicCommandAutocompletePatterns patterns) {
        this.fileService = fileService;
        this.resolverService = mavenJarResolverService;
        this.autocompletePatterns = patterns;
        this.objectFactory = new SimpleEvaluationObjectFactory();
    }

    public MagicCommandAutocompletePatterns patterns() {
        return this.autocompletePatterns;
    }

    public FileService getFileService() {
        return this.fileService;
    }

    public List<MagicCommandType> createDefaults(KernelFunctionality kernel) {
        ArrayList<MagicCommandType> magicCommandTypes = new ArrayList<MagicCommandType>();
        magicCommandTypes.addAll(Arrays.asList(this.javascript(), this.js(), this.html(), this.HTML(), this.bash(), this.lsmagic(magicCommandTypes), this.addJar(kernel), this.addJarByMvn(kernel), this.addJarByMvnCell(kernel), this.addDynamic(kernel), this.addRepo(kernel), this.addClasspathReset(kernel), this.showClasspath(kernel), this.addStaticImport(kernel), this.addImport(kernel), this.unimport(kernel), this.timeLine(kernel), this.timeCell(kernel), this.timeItLine(kernel), this.timeItCell(kernel), this.loadMagic(kernel), this.kernel(kernel), this.python(kernel), this.clojure(kernel), this.groovy(kernel), this.java(kernel), this.kotlin(kernel), this.scala(kernel), this.sql(kernel), this.async(kernel)));
        return magicCommandTypes;
    }

    public MagicCommandType async(KernelFunctionality kernel) {
        return new MagicCommandType("%%async", "", (MagicCommandFunctionality)new AsyncMagicCommand(kernel, this.objectFactory));
    }

    public ClasspathAddMvnMagicCommand getClasspathAddMvnMagicCommand(KernelFunctionality kernel) {
        Optional<MagicCommandType> first = kernel.getMagicCommandTypes().stream().filter(x -> x.getCommand().equals("%classpath add mvn")).findFirst();
        return (ClasspathAddMvnMagicCommand)first.get().getMagicCommandFunctionality();
    }

    private MagicCommandType addClasspathReset(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath reset", "", (MagicCommandFunctionality)new ClasspathResetMagicCommand(kernel, this.fileService));
    }

    private MagicCommandType addDynamic(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath add dynamic", "", (MagicCommandFunctionality)new ClasspathAddDynamicMagicCommand(kernel, MessageCreator.get(), this.objectFactory));
    }

    private MagicCommandType loadMagic(KernelFunctionality kernel) {
        return new MagicCommandType("%load_magic", "", (MagicCommandFunctionality)new LoadMagicMagicCommand(kernel, MessageCreator.get()));
    }

    private MagicCommandType timeItCell(KernelFunctionality kernel) {
        return new MagicCommandType("%%timeit", "", (MagicCommandFunctionality)new TimeItCellModeMagicCommand(kernel, this.objectFactory));
    }

    private MagicCommandType timeItLine(KernelFunctionality kernel) {
        return new MagicCommandType("%timeit", "", (MagicCommandFunctionality)new TimeItLineModeMagicCommand(kernel, this.objectFactory));
    }

    private MagicCommandType timeCell(KernelFunctionality kernel) {
        return new MagicCommandType("%%time", "", (MagicCommandFunctionality)new TimeCellModeMagicCommand(kernel, this.objectFactory));
    }

    private MagicCommandType timeLine(KernelFunctionality kernel) {
        return new MagicCommandType("%time", "", (MagicCommandFunctionality)new TimeLineModeMagicCommand(kernel, this.objectFactory));
    }

    private MagicCommandType unimport(KernelFunctionality kernel) {
        return new MagicCommandType("%unimport", "<classpath>", (MagicCommandFunctionality)new UnImportMagicCommand(kernel, MessageCreator.get()));
    }

    private MagicCommandType addImport(KernelFunctionality kernel) {
        return new MagicCommandType("%import", "<classpath>", (MagicCommandFunctionality)new AddImportMagicCommand(kernel, MessageCreator.get()));
    }

    private MagicCommandType addStaticImport(KernelFunctionality kernel) {
        return new MagicCommandType("%import static", "<classpath>", (MagicCommandFunctionality)new AddStaticImportMagicCommand(kernel));
    }

    private MagicCommandType showClasspath(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath", "", (MagicCommandFunctionality)new ClasspathShowMagicCommand(kernel, MessageCreator.get()));
    }

    private MagicCommandType addJarByMvn(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath add mvn", "<group name version>", (MagicCommandFunctionality)new ClasspathAddMvnMagicCommand(this.resolverService.getParams(kernel), kernel, MessageCreator.get()));
    }

    private MagicCommandType addJarByMvnCell(KernelFunctionality kernel) {
        return new MagicCommandType("%%classpath add mvn", "<group name version>", (MagicCommandFunctionality)new ClassPathAddMvnCellMagicCommand(this.resolverService.getParams(kernel), kernel, MessageCreator.get()));
    }

    private MagicCommandType addJar(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath add jar", "<jar path>", (MagicCommandFunctionality)new ClasspathAddJarMagicCommand(kernel, MessageCreator.get()));
    }

    private MagicCommandType addRepo(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath config resolver", "<repoName repoUrl>", (MagicCommandFunctionality)new ClasspathAddRepoMagicCommand(kernel));
    }

    private MagicCommandType lsmagic(List<MagicCommandType> magicCommandTypes) {
        return new MagicCommandType("%lsmagic", "", (MagicCommandFunctionality)new LsMagicCommand(magicCommandTypes));
    }

    private MagicCommandType bash() {
        return new MagicCommandType("%%bash", "", (MagicCommandFunctionality)new BashMagicCommand());
    }

    private MagicCommandType html() {
        return new MagicCommandType("%%html", "", (MagicCommandFunctionality)new HtmlMagicCommand());
    }

    private MagicCommandType HTML() {
        return new MagicCommandType("%%HTML", "", (MagicCommandFunctionality)new HtmlAliasMagicCommand());
    }

    private MagicCommandType javascript() {
        return new MagicCommandType("%%javascript", "", (MagicCommandFunctionality)new JavaScriptMagicCommand());
    }

    private MagicCommandType js() {
        return new MagicCommandType("%%js", "", (MagicCommandFunctionality)new JSMagicCommand());
    }

    private MagicCommandType kernel(KernelFunctionality kernel) {
        return new MagicCommandType("%%kernel", "", (MagicCommandFunctionality)new KernelMagicCommand(kernel));
    }

    private MagicCommandType python(KernelFunctionality kernel) {
        return new MagicCommandType("%%python", "", (MagicCommandFunctionality)new PythonMagicCommand(kernel));
    }

    private MagicCommandType sql(KernelFunctionality kernel) {
        return new MagicCommandType("%%sql", "", (MagicCommandFunctionality)new SQLMagicCommand(kernel));
    }

    private MagicCommandType scala(KernelFunctionality kernel) {
        return new MagicCommandType("%%scala", "", (MagicCommandFunctionality)new ScalaMagicCommand(kernel));
    }

    private MagicCommandType kotlin(KernelFunctionality kernel) {
        return new MagicCommandType("%%kotlin", "", (MagicCommandFunctionality)new KotlinMagicCommand(kernel));
    }

    private MagicCommandType java(KernelFunctionality kernel) {
        return new MagicCommandType("%%java", "", (MagicCommandFunctionality)new JavaMagicCommand(kernel));
    }

    private MagicCommandType groovy(KernelFunctionality kernel) {
        return new MagicCommandType("%%groovy", "", (MagicCommandFunctionality)new GroovyMagicCommand(kernel));
    }

    private MagicCommandType clojure(KernelFunctionality kernel) {
        return new MagicCommandType("%%clojure", "", (MagicCommandFunctionality)new ClojureMagicCommand(kernel));
    }
}

