/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.restserver.impl;

import com.twosigma.beakerx.kernel.GroupName;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.MagicKernelManager;
import com.twosigma.beakerx.kernel.comm.GetCodeCellsHandler;
import com.twosigma.beakerx.kernel.restserver.BeakerXServer;
import com.twosigma.beakerx.kernel.restserver.Context;
import com.twosigma.beakerx.kernel.restserver.RESTAction;
import com.twosigma.beakerx.kernel.restserver.impl.ContextJavalin;
import com.twosigma.beakerx.kernel.restserver.impl.GetUrlArgHandler;
import io.javalin.Handler;
import io.javalin.Javalin;
import org.jetbrains.annotations.NotNull;

public abstract class BeakerXServerJavalin
implements BeakerXServer {
    private Javalin app = null;
    private Integer freePort;
    private GetUrlArgHandler urlArgHandler;

    public BeakerXServerJavalin(GetUrlArgHandler urlArgHandler) {
        this.urlArgHandler = urlArgHandler;
    }

    public synchronized BeakerXServer get(KernelFunctionality kernel) {
        if (this.app == null) {
            this.app = this.createServer(kernel);
        }
        return this;
    }

    private Javalin createServer(KernelFunctionality kernel) {
        this.freePort = MagicKernelManager.findFreePort();
        Javalin server = Javalin.create().disableStartupBanner().port(this.freePort.intValue()).start();
        this.doCreateMapping(server, kernel);
        return server;
    }

    public String getURL() {
        return String.format("http://localhost:%s/", this.freePort);
    }

    private void doCreateMapping(Javalin server, KernelFunctionality kernel) {
        this.mappingsForAllKernels(server, kernel);
        this.createMapping(server, kernel);
    }

    private void mappingsForAllKernels(Javalin server, KernelFunctionality kernel) {
        server.post("codecell", ctx -> {
            String body = ctx.body();
            GetCodeCellsHandler.INSTANCE.handle(body);
        });
        server.post("cancel/execution//:groupname", ctx -> kernel.cancelExecution(GroupName.of((String)ctx.param("groupname"))));
        server.post("urlarg", ctx -> {
            String body = ctx.body();
            this.urlArgHandler.handle(body);
        });
    }

    public abstract void createMapping(Javalin var1, KernelFunctionality var2);

    public void addPostMapping(String path, RESTAction restAction) {
        this.app.post(path, this.handleBackground(restAction));
    }

    @NotNull
    private Handler handleBackground(RESTAction restAction) {
        return ctx -> {
            restAction.run((Context)new ContextJavalin(ctx));
            ctx.result("ok");
        };
    }
}

