/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.twosigma.beakerx.kernel.Utils;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.MessageSerializer;
import com.twosigma.beakerx.util.Preconditions;

@JsonPropertyOrder(value={"id", "username", "session", "date", "type", "version"})
public class Header {
    public static final String MSG_ID = "msg_id";
    private String date;
    @JsonProperty(value="msg_id")
    private String id;
    private String username;
    private String session;
    @JsonProperty(value="msg_type")
    private JupyterMessages type;
    private String version;

    private Header() {
    }

    public Header(JupyterMessages type, String session) {
        this.date = Utils.timestamp();
        this.id = Utils.uuid();
        this.username = "kernel";
        this.type = type;
        this.session = Preconditions.checkNotNull(session);
        this.version = "5.3";
    }

    public String asJson() {
        return MessageSerializer.toJson(this);
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getSession() {
        return this.session;
    }

    public String getType() {
        return this.type != null ? this.type.getName() : null;
    }

    public JupyterMessages getTypeEnum() {
        return this.type;
    }

    public void setTypeEnum(JupyterMessages type) {
        this.type = type;
    }

    public void setType(String type) {
        this.type = JupyterMessages.getType(type);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return "Type = " + this.getType() + " Id = " + this.getId();
    }
}

