/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;

public final class Sets {
    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    public static <T> HashSet<T> newHashSet(Iterable<? extends T> elements) {
        if (elements == null) {
            return null;
        }
        HashSet<T> set = Sets.newHashSet();
        for (T e : elements) {
            set.add(e);
        }
        return set;
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        if (elements == null) {
            return null;
        }
        LinkedHashSet<T> set = Sets.newLinkedHashSet();
        Collections.addAll(set, elements);
        return set;
    }

    private Sets() {
    }
}

