/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.PathToJar;
import com.twosigma.beakerx.kernel.Runtimetools;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;

public class RuntimetoolsImpl
implements Runtimetools {
    public void configRuntimeJars(KernelFunctionality kernel) {
        Optional<String> runtimetools = this.getJar("runtimetools");
        if (runtimetools.isPresent()) {
            kernel.addJarsToClasspath(Arrays.asList(new PathToJar(runtimetools.get())));
            kernel.addImport(new ImportPath("com.twosigma.beakerx.BxDriverManager"));
        }
    }

    private Optional<String> getJar(String name) {
        try {
            Path path = Paths.get(KernelFunctionality.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            Path location = path.getParent().getParent().getParent().resolve("kernel").resolve("ext");
            if (location.toFile().exists()) {
                Optional<String> jarFile = Arrays.stream(location.toFile().list()).filter(jar -> jar.contains(name)).findFirst();
                return jarFile.map(s -> location.resolve((String)s).toString());
            }
            return Optional.empty();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

