/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.javash;

import com.twosigma.beakerx.jvm.classloader.BeakerXUrlClassLoader;
import com.twosigma.beakerx.kernel.PathToJar;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class JavaBeakerXUrlClassLoader
extends URLClassLoader {
    private BeakerXUrlClassLoader beakerxUrlClassLoader;
    private JavaInternalUrlClassLoader javaURLClassLoader;

    public JavaBeakerXUrlClassLoader(ClassLoader systemClassLoader, PathToJar pathToJar) {
        super(new URL[0]);
        this.beakerxUrlClassLoader = new BeakerXUrlClassLoader(this.getURLs(), systemClassLoader);
        this.javaURLClassLoader = new JavaInternalUrlClassLoader(this.beakerxUrlClassLoader, new URL[0]);
        this.javaURLClassLoader.addJar(pathToJar);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public void addJar(PathToJar pathToJar) {
        this.javaURLClassLoader.addJar(pathToJar);
    }

    public void addInitJar(PathToJar pathToJar) {
        this.beakerxUrlClassLoader.addJar(pathToJar);
    }

    public void addInitPathToJars(List<PathToJar> paths) {
        for (PathToJar dir : paths) {
            this.addInitJar(dir);
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> aClass = null;
        try {
            aClass = this.javaURLClassLoader.loadClass(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (aClass != null) {
            return aClass;
        }
        return this.beakerxUrlClassLoader.loadClass(name);
    }

    public void resetClassloader() {
        this.javaURLClassLoader = new JavaInternalUrlClassLoader(this.beakerxUrlClassLoader, this.javaURLClassLoader.getURLs());
    }

    public JavaInternalUrlClassLoader getJavaURLClassLoader() {
        return this.javaURLClassLoader;
    }

    static class JavaInternalUrlClassLoader
    extends BeakerXUrlClassLoader {
        private static final List<String> excludedClasses = Collections.singletonList("slf4j");
        private BeakerXUrlClassLoader external;

        public JavaInternalUrlClassLoader(BeakerXUrlClassLoader external, URL[] urls) {
            super(urls, null);
            this.external = external;
        }

        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (this.isNotInExcludedClasses(name)) {
                Class aClass = null;
                try {
                    aClass = super.loadClass(name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (aClass != null) {
                    return aClass;
                }
            }
            return this.external.loadClass(name);
        }

        private boolean isNotInExcludedClasses(String name) {
            return excludedClasses.stream().filter(name::contains).collect(Collectors.toList()).isEmpty();
        }
    }
}

