/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.javash.evaluator;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.javash.evaluator.JavaEvaluator;
import com.twosigma.beakerx.jvm.object.EvaluationObject;
import com.twosigma.beakerx.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import jdk.jshell.Diag;
import jdk.jshell.Snippet;
import jdk.jshell.SnippetEvent;
import jdk.jshell.SourceCodeAnalysis;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

class JavaCodeRunner
implements Callable<TryResult> {
    private final EvaluationObject theOutput;
    private JobDescriptor j;
    private JavaEvaluator javaEvaluator;

    public JavaCodeRunner(JavaEvaluator javaEvaluator, EvaluationObject out, JobDescriptor j) {
        this.javaEvaluator = javaEvaluator;
        this.theOutput = (EvaluationObject)Preconditions.checkNotNull((Object)out);
        this.j = j;
    }

    @Override
    public TryResult call() throws Exception {
        TryResult either;
        try {
            this.theOutput.setOutputHandler();
            either = this.runCode(this.j);
        }
        catch (Throwable e) {
            either = this.handleError(e);
        }
        finally {
            this.theOutput.clrOutputHandler();
        }
        return this.javaEvaluator.processResult(either);
    }

    private TryResult runCode(JobDescriptor j) {
        j.outputObject.started();
        String code = j.codeToBeExecuted;
        try {
            SourceCodeAnalysis.CompletionInfo info = this.analyze(code);
            List<Object> snippetsList = new ArrayList();
            while (this.isComplete(info)) {
                snippetsList = this.javaEvaluator.getJshell().eval(info.source());
                SnippetEvent snippetEvent = (SnippetEvent)snippetsList.get(0);
                if (!snippetEvent.status().equals((Object)Snippet.Status.VALID)) {
                    String message = this.createErrorMessage(snippetEvent.snippet());
                    return TryResult.createError((String)message);
                }
                info = this.analyze(info.remaining());
            }
            return TryResult.createResult((Object)this.getResult((SnippetEvent)snippetsList.get(0)));
        }
        catch (Throwable e) {
            return this.handleError(e);
        }
    }

    private TryResult handleError(Throwable e) {
        if (e instanceof InterruptedException || e instanceof ThreadDeath) {
            return TryResult.createError((String)BaseEvaluator.INTERUPTED_MSG);
        }
        return TryResult.createError((String)e.getMessage());
    }

    @Nullable
    private Object getResult(SnippetEvent snippet) {
        String uuid = snippet.value();
        if (uuid == null) {
            return null;
        }
        return this.javaEvaluator.getExecutionControl().getObject(uuid);
    }

    private String createErrorMessage(Snippet sn) {
        List diagnostics = this.javaEvaluator.getJshell().diagnostics(sn).collect(Collectors.toList());
        String source = sn.source();
        ArrayList<String> message = new ArrayList<String>();
        for (Diag d : diagnostics) {
            message.add(d.getMessage(Locale.ENGLISH));
        }
        return source + System.lineSeparator() + StringUtils.join(message, (String)System.lineSeparator());
    }

    private boolean isComplete(SourceCodeAnalysis.CompletionInfo info) {
        return info.completeness().isComplete();
    }

    private SourceCodeAnalysis.CompletionInfo analyze(String code) {
        return this.javaEvaluator.getJshell().sourceCodeAnalysis().analyzeCompletion(code);
    }
}

