/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.ResultSetHelper;
import com.opencsv.ResultSetHelperService;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ResultSetColumnNameHelperService
extends ResultSetHelperService
implements ResultSetHelper {
    private String[] columnNames;
    private String[] columnHeaders;
    private final Map<String, Integer> columnNamePositionMap = new HashMap<String, Integer>();

    public void setColumnNames(String[] columnNames, String[] columnHeaders) {
        if (columnHeaders.length != columnNames.length) {
            throw new UnsupportedOperationException("The number of column names must be the same as the number of header names.");
        }
        if (this.hasInvalidValue(columnNames)) {
            throw new UnsupportedOperationException("Column names cannot be null, empty, or blank");
        }
        if (this.hasInvalidValue(columnHeaders)) {
            throw new UnsupportedOperationException("Column header names cannot be null, empty, or blank");
        }
        this.columnNames = Arrays.copyOf(columnNames, columnNames.length);
        this.columnHeaders = Arrays.copyOf(columnHeaders, columnHeaders.length);
    }

    private boolean hasInvalidValue(String[] strings) {
        for (String s : strings) {
            if (!StringUtils.isBlank((CharSequence)s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getColumnNames(ResultSet rs) throws SQLException {
        if (this.columnNamePositionMap.isEmpty()) {
            this.populateColumnData(rs);
        }
        return Arrays.copyOf(this.columnHeaders, this.columnHeaders.length);
    }

    private void populateColumnData(ResultSet rs) throws SQLException {
        Object[] realColumnNames = super.getColumnNames(rs);
        if (this.columnNames == null) {
            this.columnNames = Arrays.copyOf(realColumnNames, realColumnNames.length);
            this.columnHeaders = Arrays.copyOf(realColumnNames, realColumnNames.length);
        }
        for (String name : this.columnNames) {
            int position = ArrayUtils.indexOf((Object[])realColumnNames, (Object)name);
            if (position == -1) {
                throw new UnsupportedOperationException("The column named " + name + " does not exist in the result set!");
            }
            this.columnNamePositionMap.put(name, position);
        }
    }

    @Override
    public String[] getColumnValues(ResultSet rs) throws SQLException, IOException {
        if (this.columnNamePositionMap.isEmpty()) {
            this.populateColumnData(rs);
        }
        String[] realColumnValues = super.getColumnValues(rs, false, "dd-MMM-yyyy", "dd-MMM-yyyy HH:mm:ss");
        return this.getColumnValueSubset(realColumnValues);
    }

    @Override
    public String[] getColumnValues(ResultSet rs, boolean trim) throws SQLException, IOException {
        if (this.columnNamePositionMap.isEmpty()) {
            this.populateColumnData(rs);
        }
        String[] realColumnValues = super.getColumnValues(rs, trim, "dd-MMM-yyyy", "dd-MMM-yyyy HH:mm:ss");
        return this.getColumnValueSubset(realColumnValues);
    }

    @Override
    public String[] getColumnValues(ResultSet rs, boolean trim, String dateFormatString, String timeFormatString) throws SQLException, IOException {
        if (this.columnNamePositionMap.isEmpty()) {
            this.populateColumnData(rs);
        }
        String[] realColumnValues = super.getColumnValues(rs, trim, dateFormatString, timeFormatString);
        return this.getColumnValueSubset(realColumnValues);
    }

    private String[] getColumnValueSubset(String[] realColumnValues) {
        ArrayList<String> valueList = new ArrayList<String>(realColumnValues.length);
        for (String columnName : this.columnNames) {
            valueList.add(realColumnValues[this.columnNamePositionMap.get(columnName)]);
        }
        return valueList.toArray(new String[this.columnNames.length]);
    }
}

