/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart;

import com.twosigma.beakerx.chart.ChartDetails;
import com.twosigma.beakerx.chart.ChartToJson;
import com.twosigma.beakerx.chart.legend.LegendLayout;
import com.twosigma.beakerx.chart.legend.LegendPosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Chart
extends ChartDetails {
    public static final String PLOT_GRIDLINE = ".plot-gridline";
    public static final String PLOT_LABEL_Y = ".plot-label-y";
    public static final String PLOT_LABEL_X = ".plot-label-x";
    public static final String PLOT_LABEL = ".plot-label";
    public static final String PLOT_TITLE = ".plot-title";
    private int initWidth = 640;
    private int initHeight = 480;
    private List<String> customStyles = new ArrayList<String>();
    private Map<String, String> elementStyles = new HashMap<String, String>();
    private String title;
    private Boolean showLegend;
    private boolean useToolTip = true;
    private LegendPosition legendPosition = new LegendPosition(LegendPosition.Position.TOP_RIGHT);
    private LegendLayout legendLayout = LegendLayout.VERTICAL;

    public Chart setInitWidth(int w) {
        this.initWidth = w;
        this.sendModelUpdate(ChartToJson.serializeInitWidth(this.initWidth));
        return this;
    }

    public Integer getInitWidth() {
        return this.initWidth;
    }

    public Chart setInitHeight(int h) {
        this.initHeight = h;
        this.sendModelUpdate(ChartToJson.serializeInitHeight(this.initHeight));
        return this;
    }

    public Integer getInitHeight() {
        return this.initHeight;
    }

    public Chart setTitle(String title) {
        this.title = title;
        this.sendModelUpdate(ChartToJson.serializeTitle(this.title));
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Chart setShowLegend(Boolean showLegend) {
        this.showLegend = showLegend;
        return this;
    }

    public Boolean getShowLegend() {
        return this.showLegend;
    }

    public Chart setUseToolTip(boolean useToolTip) {
        this.useToolTip = useToolTip;
        return this;
    }

    public Boolean getUseToolTip() {
        return this.useToolTip;
    }

    public LegendPosition getLegendPosition() {
        return this.legendPosition;
    }

    public Chart setLegendPosition(LegendPosition legendPosition) {
        this.legendPosition = legendPosition;
        this.sendModelUpdate(ChartToJson.serializeLegendPosition(this.legendPosition));
        return this;
    }

    public LegendLayout getLegendLayout() {
        return this.legendLayout;
    }

    public Chart setLegendLayout(LegendLayout legendLayout) {
        this.legendLayout = legendLayout;
        this.sendModelUpdate(ChartToJson.serializeLegendLayout(this.legendLayout));
        return this;
    }

    public List<String> getCustomStyles() {
        return this.customStyles;
    }

    public void setCustomStyles(List<String> customStyle) {
        this.customStyles = customStyle;
        this.sendModelUpdate(ChartToJson.serializeCustomStyles(this.customStyles));
    }

    public String getLabelStyle() {
        return this.elementStyles.get(PLOT_LABEL);
    }

    public void setLabelStyle(String style) {
        this.elementStyles.put(PLOT_LABEL, style);
        this.sendModelUpdate(ChartToJson.serializeElementStyles(this.elementStyles));
    }

    public String getLabelXStyle() {
        return this.elementStyles.get(PLOT_LABEL_X);
    }

    public void setLabelXStyle(String style) {
        this.elementStyles.put(PLOT_LABEL_X, style);
        this.sendModelUpdate(ChartToJson.serializeElementStyles(this.elementStyles));
    }

    public String getLabelYStyle() {
        return this.elementStyles.get(PLOT_LABEL_Y);
    }

    public void setLabelYStyle(String style) {
        this.elementStyles.put(PLOT_LABEL_Y, style);
        this.sendModelUpdate(ChartToJson.serializeElementStyles(this.elementStyles));
    }

    public String getGridLineStyle() {
        return this.elementStyles.get(PLOT_GRIDLINE);
    }

    public void setGridLineStyle(String style) {
        this.elementStyles.put(PLOT_GRIDLINE, style);
        this.sendModelUpdate(ChartToJson.serializeElementStyles(this.elementStyles));
    }

    public String getTitleStyle() {
        return this.elementStyles.get(PLOT_TITLE);
    }

    public void setTitleStyle(String style) {
        this.elementStyles.put(PLOT_TITLE, style);
        this.sendModelUpdate(ChartToJson.serializeElementStyles(this.elementStyles));
    }

    public Map<String, String> getElementStyles() {
        return this.elementStyles;
    }

    @Override
    public String getModelNameValue() {
        return "PlotModel";
    }

    @Override
    public String getViewNameValue() {
        return "PlotView";
    }

    @Override
    protected Map serializeToJsonObject() {
        return ChartToJson.toJson(this);
    }

    @Override
    protected Map serializeToJsonObject(Object item) {
        return ChartToJson.toJson(item);
    }
}

