/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.MIMEContainerFactory;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.jvm.object.ConfigurationFactoryImpl;
import com.twosigma.beakerx.jvm.object.EvaluationObject;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import com.twosigma.beakerx.widget.CommActions;
import com.twosigma.beakerx.widget.Widget;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledCodeRunner {
    private static final Logger logger = LoggerFactory.getLogger(CompiledCodeRunner.class);

    static void runCommEvent(Message message, CommActions action, Widget.ActionPerformed handlerAction) {
        Object contentObject;
        Serializable data;
        if (message.getContent() != null && (data = (Serializable)message.getContent().get("data")) != null && data instanceof LinkedHashMap && (contentObject = ((LinkedHashMap)data).get("content")) instanceof LinkedHashMap) {
            LinkedHashMap content = (LinkedHashMap)contentObject;
            if (handlerAction != null) {
                SimpleEvaluationObject seo = CompiledCodeRunner.initOutput(message);
                handlerAction.executeAction(content, message);
                seo.clrOutputHandler();
            }
        }
    }

    public static void runCompiledCode(Message message, ExecuteCompiledCode handler, Object ... params) {
        SimpleEvaluationObject seo = CompiledCodeRunner.initOutput(message);
        InternalVariable.setValue((EvaluationObject)seo);
        try {
            Object result = handler.executeCode(params);
            if (result != null) {
                MIMEContainerFactory.createMIMEContainers(result);
            }
        }
        catch (Exception e) {
            CompiledCodeRunner.printError(message, seo, e);
        }
        seo.clrOutputHandler();
    }

    public static void runCompiledCodeAndPublish(Message message, ExecuteCompiledCode handler, Object ... params) {
        SimpleEvaluationObject seo = CompiledCodeRunner.initOutput(message);
        InternalVariable.setValue((EvaluationObject)seo);
        KernelManager.get().publish(Collections.singletonList(MessageCreator.buildClearOutput(message, true)));
        try {
            Object result = handler.executeCode(params);
            if (result != null) {
                List<MIMEContainer> resultString = MIMEContainerFactory.createMIMEContainers(result);
                KernelManager.get().publish(Collections.singletonList(MessageCreator.buildDisplayData(message, resultString)));
            }
        }
        catch (Exception e) {
            CompiledCodeRunner.printError(message, seo, e);
        }
        seo.clrOutputHandler();
    }

    private static SimpleEvaluationObject initOutput(Message message) {
        SimpleEvaluationObject seo = new SimpleEvaluationObject("", new ConfigurationFactoryImpl(KernelManager.get(), message, 1));
        seo.setOutputHandler();
        return seo;
    }

    private static void printError(Message message, SimpleEvaluationObject seo, Exception e) {
        if (message != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            seo.error(sw.toString());
        } else {
            logger.info("Execution result ERROR: \n" + e);
        }
    }

    public static interface ExecuteCompiledCode {
        public Object executeCode(Object ... var1) throws Exception;
    }
}

