/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.evaluator;

import com.twosigma.beakerx.inspect.ClassInspect;
import com.twosigma.beakerx.inspect.CodeParsingTool;
import com.twosigma.beakerx.inspect.Inspect;
import com.twosigma.beakerx.inspect.InspectResult;
import com.twosigma.beakerx.inspect.MethodInspect;
import com.twosigma.beakerx.inspect.SerializeInspect;
import com.twosigma.beakerx.kernel.Imports;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class BxInspect
implements Inspect {
    private static final String COLOR_RED = "\u001b[31m";
    private static final String COLOR_RESET = "\u001b[0m";
    public static final String BEAKERX_INSPECT_JSON = "beakerx_inspect.json";
    private String inspectData;
    private InputStream inspectDataStream;

    public BxInspect(InputStream inspectDataStream) {
        this.inspectDataStream = inspectDataStream;
    }

    public InspectResult doInspect(String code, int caretPosition, URLClassLoader classLoader, Imports imports) {
        InspectResult inspectResult = new InspectResult();
        if (code.length() >= caretPosition) {
            String methodName = CodeParsingTool.getSelectedMethodName((String)code, (int)caretPosition);
            String className = CodeParsingTool.getClassName((String)code, (int)caretPosition, (String)methodName);
            inspectResult = this.getInspectResult(caretPosition, methodName, className, this.getInspectData());
        }
        return inspectResult;
    }

    private String getInspectData() {
        if (this.inspectData == null) {
            try (InputStream inputStream = this.inspectDataStream;){
                this.inspectData = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.inspectData;
    }

    public static InputStream getInspectFile() {
        String inputFile = "jar:file:" + BxInspect.pathToInspectionFile(BxInspect.class).toString() + "!/beakerx_inspect.json";
        try {
            URL inputURL = new URL(inputFile);
            JarURLConnection conn = (JarURLConnection)inputURL.openConnection();
            InputStream in = conn.getInputStream();
            return in;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    public static Path pathToInspectionFile(Class clazz) {
        Path workingDirectory = null;
        try {
            workingDirectory = Paths.get(clazz.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return workingDirectory;
    }

    private InspectResult getInspectResult(int caretPosition, String methodName, String className, String everything) {
        HashMap stringClassInspectHashMap = new SerializeInspect().fromJson(everything);
        InspectResult inspectResult = new InspectResult();
        ClassInspect classInspect = null;
        if (stringClassInspectHashMap.containsKey(className)) {
            classInspect = (ClassInspect)stringClassInspectHashMap.get(className);
        } else {
            for (ClassInspect cls : stringClassInspectHashMap.values()) {
                if (!cls.getClassName().equals(className)) continue;
                classInspect = cls;
                break;
            }
        }
        if (methodName == null && classInspect != null) {
            List constructors = classInspect.getConstructors();
            String classInfo = this.parseClassInfo(classInspect) + "\n\n" + this.parseMethodsInfo(constructors, "");
            inspectResult = new InspectResult(classInfo, caretPosition);
        } else {
            List methodInspectsList;
            List list = methodInspectsList = classInspect == null ? null : classInspect.getMethods();
            if (methodInspectsList == null) {
                return new InspectResult();
            }
            List<MethodInspect> methods = methodInspectsList.stream().filter(m -> m.getMethodName().equals(methodName)).collect(Collectors.toList());
            if (!methods.isEmpty()) {
                return new InspectResult(this.parseMethodsInfo(methods, className), caretPosition);
            }
        }
        return inspectResult;
    }

    private String parseClassInfo(ClassInspect classInspect) {
        return "\u001b[31mClass: \u001b[0m" + classInspect.getFullName() + "\n\u001b[31mJavaDoc: " + (String)(classInspect.getJavadoc().equals("") ? "<no JavaDoc>" : COLOR_RESET + classInspect.getJavadoc());
    }

    public String parseMethodsInfo(List<MethodInspect> methods, String className) {
        if (methods == null) {
            return "";
        }
        String parsedMethods = methods.stream().map(m -> "\u001b[31mSignature: \u001b[0m" + className + (className.equals("") ? "" : ".") + m.getMethodName() + "(" + m.getSignature() + ")\n\u001b[31mJavaDoc: " + (String)(m.getJavadoc().equals("") ? "<no JavaDoc>" : COLOR_RESET + m.getJavadoc())).collect(Collectors.joining("\n\n"));
        return parsedMethods;
    }
}

