/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.mimetype;

import com.twosigma.beakerx.mimetype.MIMEContainer;
import java.io.File;

public class FileLinkContainer
extends MIMEContainer {
    public FileLinkContainer(String mime, String code) {
        super(mime, (Object)code);
    }

    public static MIMEContainer FileLink(String filePath) {
        File f = new File(filePath);
        if (f.isDirectory()) {
            return FileLinkContainer.addMimeType((String)"text/plain", (Object)"Cannot display a directory using FileLink.");
        }
        if (!f.exists()) {
            return FileLinkContainer.addMimeType((String)"text/html", (Object)("Path (<tt>" + f.getAbsolutePath() + "</tt>) doesn't exist. It may still be in the runMagicCommands of being generated, or you may have the incorrect path."));
        }
        String htmlLink = String.format("<a href='%1$s' target='_blank'>%1$s</a><br/>", filePath);
        return FileLinkContainer.addMimeType((String)"text/html", (Object)htmlLink);
    }

    public static MIMEContainer FileLinks(String dirPath) {
        File f = new File(dirPath);
        String result = "";
        if (!f.isDirectory()) {
            return FileLinkContainer.addMimeType((String)"text/plain", (Object)("Cannot display a file using FileLinks.\nUse FileLink to display " + dirPath));
        }
        return FileLinkContainer.addMimeType((String)"text/html", (Object)FileLinkContainer.listFilesForFolder(f, result));
    }

    private static String listFilesForFolder(File folder, String result) {
        File[] fileList = folder.listFiles();
        if (fileList == null) {
            return null;
        }
        for (File fileEntry : fileList) {
            if (fileEntry.isDirectory()) {
                result = (String)result + String.format("%1$s <br/>", fileEntry.getName());
                FileLinkContainer.listFilesForFolder(fileEntry, (String)result);
                continue;
            }
            result = (String)result + String.format("<a href='%1$s' target='_blank'>%1$s</a><br/>", fileEntry.getPath());
        }
        return result;
    }
}

