/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.javash.evaluator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import jdk.jshell.execution.DirectExecutionControl;
import jdk.jshell.execution.LoaderDelegate;
import jdk.jshell.spi.ExecutionControl;

public class BeakerxLocalExecutionControl
extends DirectExecutionControl {
    private final Object STOP_LOCK = new Object();
    private boolean userCodeRunning = false;
    private ThreadGroup execThreadGroup;
    private final Map<String, Object> objects = new ConcurrentHashMap<String, Object>();

    public BeakerxLocalExecutionControl(LoaderDelegate loaderDelegate) {
        super(loaderDelegate);
    }

    public Object getObject(String uuid) {
        return this.objects.remove(uuid);
    }

    @Override
    protected String invoke(Method doitMethod) throws Exception {
        Object object = this.invokeMethod(doitMethod);
        String uuid = UUID.randomUUID().toString();
        this.objects.put(uuid, object);
        return uuid;
    }

    private Object invokeMethod(Method doitMethod) throws Exception {
        this.execThreadGroup = new ThreadGroup("JShell process local execution");
        AtomicReference iteEx = new AtomicReference();
        AtomicReference iaeEx = new AtomicReference();
        AtomicReference nmeEx = new AtomicReference();
        AtomicReference<Boolean> stopped = new AtomicReference<Boolean>(false);
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            if (e instanceof InvocationTargetException) {
                if (e.getCause() instanceof ThreadDeath) {
                    stopped.set(true);
                } else {
                    iteEx.set((InvocationTargetException)e);
                }
            } else if (e instanceof IllegalAccessException) {
                iaeEx.set((IllegalAccessException)e);
            } else if (e instanceof NoSuchMethodException) {
                nmeEx.set((NoSuchMethodException)e);
            } else if (e instanceof ThreadDeath) {
                stopped.set(true);
            }
        });
        Object[] res = new Object[1];
        Thread snippetThread = new Thread(this.execThreadGroup, () -> {
            try {
                res[0] = doitMethod.invoke(null, new Object[0]);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof ThreadDeath) {
                    stopped.set(true);
                } else {
                    iteEx.set(e);
                }
            }
            catch (IllegalAccessException e) {
                iaeEx.set(e);
            }
            catch (ThreadDeath e) {
                stopped.set(true);
            }
        });
        snippetThread.start();
        Thread[] threadList = new Thread[this.execThreadGroup.activeCount()];
        this.execThreadGroup.enumerate(threadList);
        for (Thread thread : threadList) {
            if (thread == null) continue;
            thread.join();
        }
        if (stopped.get().booleanValue()) {
            throw new ExecutionControl.StoppedException();
        }
        if (iteEx.get() != null) {
            throw (InvocationTargetException)iteEx.get();
        }
        if (nmeEx.get() != null) {
            throw (NoSuchMethodException)nmeEx.get();
        }
        if (iaeEx.get() != null) {
            throw (IllegalAccessException)iaeEx.get();
        }
        return res[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws ExecutionControl.InternalException {
        Object object = this.STOP_LOCK;
        synchronized (object) {
            if (!this.userCodeRunning) {
                return;
            }
            if (this.execThreadGroup == null) {
                throw new ExecutionControl.InternalException("Process-local code snippets thread group is null. Aborting stop.");
            }
            this.execThreadGroup.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clientCodeEnter() {
        Object object = this.STOP_LOCK;
        synchronized (object) {
            this.userCodeRunning = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clientCodeLeave() {
        Object object = this.STOP_LOCK;
        synchronized (object) {
            this.userCodeRunning = false;
        }
    }
}

