/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.javash.evaluator;

import com.twosigma.beakerx.javash.JavaBeakerXUrlClassLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.CodeSource;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jdk.jshell.execution.LoaderDelegate;
import jdk.jshell.spi.ExecutionControl;

public class BxLoaderDelegate
implements LoaderDelegate {
    private final RemoteClassLoader loader;
    private final Map<String, Class<?>> klasses = new HashMap();

    public BxLoaderDelegate(JavaBeakerXUrlClassLoader parent) {
        this.loader = new RemoteClassLoader(parent);
        Thread.currentThread().setContextClassLoader(this.loader);
    }

    public URLClassLoader getLoader() {
        return this.loader;
    }

    @Override
    public void load(ExecutionControl.ClassBytecodes[] cbcs) throws ExecutionControl.ClassInstallException, ExecutionControl.EngineTerminationException {
        boolean[] loaded = new boolean[cbcs.length];
        try {
            for (ExecutionControl.ClassBytecodes cbc : cbcs) {
                this.loader.declare(cbc.name(), cbc.bytecodes());
            }
            for (int i = 0; i < cbcs.length; ++i) {
                ExecutionControl.ClassBytecodes cbc = cbcs[i];
                Class<?> klass = this.loader.loadClass(cbc.name());
                this.klasses.put(cbc.name(), klass);
                loaded[i] = true;
                klass.getDeclaredMethods();
            }
        }
        catch (Throwable ex) {
            throw new ExecutionControl.ClassInstallException("load: " + ex.getMessage(), loaded);
        }
    }

    @Override
    public void classesRedefined(ExecutionControl.ClassBytecodes[] cbcs) {
        for (ExecutionControl.ClassBytecodes cbc : cbcs) {
            this.loader.declare(cbc.name(), cbc.bytecodes());
        }
    }

    @Override
    public void addToClasspath(String cp) throws ExecutionControl.EngineTerminationException, ExecutionControl.InternalException {
        try {
            for (String path : cp.split(File.pathSeparator)) {
                this.loader.addURL(new File(path).toURI().toURL());
            }
        }
        catch (Exception ex) {
            throw new ExecutionControl.InternalException(ex.toString());
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> klass = this.klasses.get(name);
        if (klass == null) {
            throw new ClassNotFoundException(name + " not found");
        }
        return klass;
    }

    private static class RemoteClassLoader
    extends URLClassLoader {
        private final Map<String, ClassFile> classFiles = new HashMap<String, ClassFile>();

        RemoteClassLoader(JavaBeakerXUrlClassLoader parent) {
            super(new URL[0], (ClassLoader)parent);
        }

        void declare(String name, byte[] bytes) {
            this.classFiles.put(this.toResourceString(name), new ClassFile(bytes, System.currentTimeMillis()));
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            ClassFile file = this.classFiles.get(this.toResourceString(name));
            if (file == null) {
                return super.findClass(name);
            }
            return super.defineClass(name, file.data, 0, file.data.length, (CodeSource)null);
        }

        @Override
        public URL findResource(String name) {
            URL u = this.doFindResource(name);
            return u != null ? u : super.findResource(name);
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            URL u = this.doFindResource(name);
            Enumeration<URL> sup = super.findResources(name);
            if (u == null) {
                return sup;
            }
            ArrayList<URL> result = new ArrayList<URL>();
            while (sup.hasMoreElements()) {
                result.add(sup.nextElement());
            }
            result.add(u);
            return Collections.enumeration(result);
        }

        private URL doFindResource(String name) {
            if (this.classFiles.containsKey(name)) {
                try {
                    return new URL(null, new URI("jshell", null, "/" + name, null).toString(), new ResourceURLStreamHandler(name));
                }
                catch (MalformedURLException | URISyntaxException ex) {
                    throw new InternalError(ex);
                }
            }
            return null;
        }

        private String toResourceString(String className) {
            return className.replace('.', '/') + ".class";
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        private static class ClassFile {
            public final byte[] data;
            public final long timestamp;

            ClassFile(byte[] data, long timestamp) {
                this.data = data;
                this.timestamp = timestamp;
            }
        }

        private class ResourceURLStreamHandler
        extends URLStreamHandler {
            private final String name;

            ResourceURLStreamHandler(String name) {
                this.name = name;
            }

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                return new URLConnection(u){
                    private InputStream in;
                    private Map<String, List<String>> fields;
                    private List<String> fieldNames;

                    @Override
                    public void connect() {
                        if (this.connected) {
                            return;
                        }
                        this.connected = true;
                        ClassFile file = RemoteClassLoader.this.classFiles.get(ResourceURLStreamHandler.this.name);
                        this.in = new ByteArrayInputStream(file.data);
                        this.fields = new LinkedHashMap<String, List<String>>();
                        this.fields.put("content-length", List.of(Integer.toString(file.data.length)));
                        Instant instant = new Date(file.timestamp).toInstant();
                        ZonedDateTime time = ZonedDateTime.ofInstant(instant, ZoneId.of("GMT"));
                        String timeStamp = DateTimeFormatter.RFC_1123_DATE_TIME.format(time);
                        this.fields.put("date", List.of(timeStamp));
                        this.fields.put("last-modified", List.of(timeStamp));
                        this.fieldNames = new ArrayList<String>(this.fields.keySet());
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        this.connect();
                        return this.in;
                    }

                    @Override
                    public String getHeaderField(String name) {
                        this.connect();
                        return this.fields.getOrDefault(name, List.of()).stream().findFirst().orElse(null);
                    }

                    @Override
                    public Map<String, List<String>> getHeaderFields() {
                        this.connect();
                        return this.fields;
                    }

                    @Override
                    public String getHeaderFieldKey(int n) {
                        return n < this.fieldNames.size() ? this.fieldNames.get(n) : null;
                    }

                    @Override
                    public String getHeaderField(int n) {
                        String name = this.getHeaderFieldKey(n);
                        return name != null ? this.getHeaderField(name) : null;
                    }
                };
            }
        }
    }
}

