/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.javash.evaluator;

import com.twosigma.beakerx.BeakerXClient;
import com.twosigma.beakerx.BeakerXClientManager;
import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.autocomplete.MagicCommandAutocompletePatterns;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.ClasspathScanner;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.TempFolderFactory;
import com.twosigma.beakerx.evaluator.TempFolderFactoryImpl;
import com.twosigma.beakerx.inspect.Inspect;
import com.twosigma.beakerx.javash.JavaBeakerXUrlClassLoader;
import com.twosigma.beakerx.javash.autocomplete.JavaAutocomplete;
import com.twosigma.beakerx.javash.evaluator.BeakerxLocalExecutionControl;
import com.twosigma.beakerx.javash.evaluator.BeakerxLocalExecutionControlProvider;
import com.twosigma.beakerx.javash.evaluator.BxLoaderDelegate;
import com.twosigma.beakerx.javash.evaluator.JavaWorkerThread;
import com.twosigma.beakerx.jvm.object.EvaluationObject;
import com.twosigma.beakerx.jvm.threads.BeakerCellExecutor;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kernel.ExecutionOptions;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.PathToJar;
import java.net.URLClassLoader;
import java.util.concurrent.Executors;
import jdk.jshell.JShell;
import jdk.jshell.SourceCodeAnalysis;

public class JavaEvaluator
extends BaseEvaluator {
    private JavaAutocomplete jac;
    private URLClassLoader loader = null;
    private JShell jshell;
    private SourceCodeAnalysis sourceCodeAnalysis;
    private BeakerxLocalExecutionControl executionControl;

    public JavaEvaluator(String id, String sId, EvaluatorParameters evaluatorParameters, BeakerXClient beakerxClient, MagicCommandAutocompletePatterns autocompletePatterns, ClasspathScanner classpathScanner, Inspect inspect) {
        this(id, sId, (CellExecutor)new BeakerCellExecutor("java`"), (TempFolderFactory)new TempFolderFactoryImpl(), evaluatorParameters, beakerxClient, autocompletePatterns, classpathScanner, inspect);
    }

    public JavaEvaluator(String id, String sId, CellExecutor cellExecutor, TempFolderFactory tempFolderFactory, EvaluatorParameters evaluatorParameters, BeakerXClient beakerxClient, MagicCommandAutocompletePatterns autocompletePatterns, ClasspathScanner classpathScanner, Inspect inspect) {
        super(id, sId, cellExecutor, tempFolderFactory, evaluatorParameters, beakerxClient, autocompletePatterns, classpathScanner, inspect);
        JavaBeakerXUrlClassLoader javaClassLoader = this.newClassLoader();
        this.jac = this.createJavaAutocomplete();
        this.jshell = this.newJShell(javaClassLoader);
        this.sourceCodeAnalysis = this.jshell.sourceCodeAnalysis();
    }

    public JShell getJshell() {
        return this.jshell;
    }

    public BeakerxLocalExecutionControl getExecutionControl() {
        return this.executionControl;
    }

    public ClassLoader getClassLoaderForImport() {
        return this.getJavaClassLoader().getJavaURLClassLoader();
    }

    protected void doResetEnvironment() {
        JavaBeakerXUrlClassLoader javaClassLoader = this.newClassLoader();
        this.jshell = this.newJShell(javaClassLoader);
        this.sourceCodeAnalysis = this.jshell.sourceCodeAnalysis();
        this.jac = this.createJavaAutocomplete();
        this.executorService.shutdown();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    protected void addJarToClassLoader(PathToJar pathToJar) {
        this.jshell.addToClasspath(pathToJar.getPath());
        this.getJavaClassLoader().addJar(pathToJar);
    }

    protected void addImportToClassLoader(ImportPath anImport) {
        this.addImportToClassLoader(anImport.asString(), this.jshell);
    }

    private void addImportToClassLoader(String anImport, JShell jShell) {
        jShell.eval("import " + anImport + ";");
    }

    public void exit() {
        super.exit();
        this.killAllThreads();
        this.executorService.shutdown();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public TryResult evaluate(EvaluationObject seo, String code, ExecutionOptions executionOptions) {
        return this.evaluate(seo, new JavaWorkerThread(this, new JobDescriptor(code, seo, executionOptions)));
    }

    public AutocompleteResult autocomplete(String code, int caretPosition) {
        return this.jac.find(code, caretPosition, this.sourceCodeAnalysis);
    }

    private JavaAutocomplete createJavaAutocomplete() {
        return new JavaAutocomplete();
    }

    private JavaBeakerXUrlClassLoader newClassLoader() {
        JavaBeakerXUrlClassLoader loader = new JavaBeakerXUrlClassLoader(ClassLoader.getSystemClassLoader(), new PathToJar(this.outDir));
        loader.addInitPathToJars(this.getClasspath().getPaths());
        return loader;
    }

    public JavaBeakerXUrlClassLoader getJavaClassLoader() {
        return (JavaBeakerXUrlClassLoader)this.loader.getParent();
    }

    private JShell newJShell(JavaBeakerXUrlClassLoader loader) {
        BxLoaderDelegate loaderDelegate = new BxLoaderDelegate(loader);
        this.loader = loaderDelegate.getLoader();
        this.executionControl = new BeakerxLocalExecutionControl(loaderDelegate);
        JShell shell = JShell.builder().executionEngine(new BeakerxLocalExecutionControlProvider(this.executionControl), null).compilerOptions(new String[0]).build();
        for (ImportPath ip : this.getImports().getImportPaths()) {
            this.addImportToClassLoader(ip.asString(), shell);
        }
        shell = this.configureBeakerxObject(shell);
        return shell;
    }

    private JShell configureBeakerxObject(JShell jShell) {
        String beakerxObject = "var beakerx = " + BeakerXClientManager.BEAKER_X_CLIENT_MANAGER + ";";
        jShell.eval(beakerxObject);
        return jShell;
    }
}

