/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.shared.NamespaceBinding;
import java.io.IOException;

public class NamespaceBindingDeserializer
extends JsonDeserializer<NamespaceBinding> {
    private final BeakerObjectConverter objectSerializerProvider;

    public NamespaceBindingDeserializer(BeakerObjectConverter osp) {
        this.objectSerializerProvider = osp;
    }

    public NamespaceBinding deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(jp);
        String name = node.get("name").asText();
        String session = node.get("session").asText();
        Boolean defined = node.get("defined").asBoolean();
        JsonNode o = node.get("value");
        Object obj = this.objectSerializerProvider.deserialize(o, mapper);
        return new NamespaceBinding(name, session, obj, defined);
    }
}

