/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.table;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.twosigma.beakerx.table.BxTableSettingsDefaults;
import com.twosigma.beakerx.table.TableSettingsDefaults;
import com.twosigma.beakerx.table.serializer.TableSettings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;

public class BxTableSettings
implements TableSettings {
    private String path;
    private TableSettingsDefaults defaults;
    private ObjectMapper objectMapper;

    public BxTableSettings() {
        this(BxTableSettings.getFile("beakerx_tabledisplay.json"), new BxTableSettingsDefaults());
    }

    public BxTableSettings(String path, TableSettingsDefaults defaults) {
        this.path = path;
        this.defaults = defaults;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    @Override
    public Map<String, Object> options() {
        Map options;
        Map<String, Map> load = this.load();
        try {
            options = (Map)load.get("beakerx_tabledisplay").get("options");
        }
        catch (Exception e) {
            options = (Map)this.defaults.getDefault().get("beakerx_tabledisplay").get("options");
        }
        return options;
    }

    private Map<String, Map> load() {
        String jsonAsString = null;
        try {
            jsonAsString = Files.readString(Paths.get(this.path, new String[0]));
            LinkedHashMap linkedHashMap = this.fromJson(jsonAsString, LinkedHashMap.class);
            Map merge = this.mergeSettingsWithDefaults(linkedHashMap);
            return merge;
        }
        catch (Exception e) {
            Map<String, Map> defaultConfig = this.defaults.getDefault();
            this.save(defaultConfig);
            jsonAsString = this.toJson(defaultConfig);
            return this.fromJson(jsonAsString, LinkedHashMap.class);
        }
    }

    private Map mergeSettingsWithDefaults(Map<String, Map> current) {
        Map options = (Map)current.get("beakerx_tabledisplay").get("options");
        Map<String, Map> merge = this.defaults.getDefault();
        Map optionsFromDefault = (Map)merge.get("beakerx_tabledisplay").get("options");
        optionsFromDefault.putAll(options);
        return merge;
    }

    private <T> T fromJson(String json, Class<T> theClass) {
        Object result = null;
        try {
            result = this.objectMapper.readValue(json, theClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)result;
    }

    private String toJson(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void save(Map<String, Map> map) {
        try {
            String content = this.toJson(map);
            Files.write(Paths.get(this.path, new String[0]), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getFile(String fileName) {
        String path = (String)(System.getenv("JUPYTER_CONFIG_DIR") != null ? System.getenv("JUPYTER_CONFIG_DIR") : System.getProperty("user.home") + File.separator + ".jupyter") + File.separator + fileName;
        return path;
    }
}

