/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.sql;

import com.twosigma.beakerx.BeakerXClient;
import com.twosigma.beakerx.jvm.object.OutputCell;
import com.twosigma.beakerx.jvm.object.OutputContainer;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import com.twosigma.beakerx.sql.BeakerInputVar;
import com.twosigma.beakerx.sql.BeakerParseResult;
import com.twosigma.beakerx.sql.BeakerParser;
import com.twosigma.beakerx.sql.ConnectionStringHolder;
import com.twosigma.beakerx.sql.JDBCClient;
import com.twosigma.beakerx.sql.ReadVariableException;
import com.twosigma.beakerx.table.TableDisplay;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.dbcp2.BasicDataSource;

public class QueryExecutor {
    protected final JDBCClient jdbcClient;
    private Connection connection;
    private PreparedStatement statement;

    public QueryExecutor(JDBCClient jdbcClient) {
        this.jdbcClient = jdbcClient;
    }

    public synchronized Object executeQuery(String script, BeakerXClient namespaceClient, ConnectionStringHolder defaultConnectionString, Map<String, ConnectionStringHolder> namedConnectionString) throws SQLException, IOException, ReadVariableException {
        BeakerParser beakerParser = new BeakerParser(script, namespaceClient, defaultConnectionString, namedConnectionString, this.jdbcClient);
        BasicDataSource ds = this.jdbcClient.getDataSource(beakerParser.getDbURI().getActualConnectionString());
        Properties info = null;
        if (beakerParser.getDbURI().getUser() != null && !beakerParser.getDbURI().getUser().isEmpty()) {
            if (info == null) {
                info = new Properties();
            }
            info.put("user", beakerParser.getDbURI().getUser());
        }
        if (beakerParser.getDbURI().getPassword() != null && !beakerParser.getDbURI().getPassword().isEmpty()) {
            if (info == null) {
                info = new Properties();
            }
            info.put("password", beakerParser.getDbURI().getPassword());
        }
        boolean isConnectionExeption = true;
        try {
            MIMEContainer mIMEContainer;
            block37: {
                Connection connection;
                block35: {
                    block36: {
                        ArrayList<Object> resultsForOutputCell;
                        block33: {
                            OutputContainer outputContainer;
                            block34: {
                                connection = info != null ? ds.getDriver().connect(beakerParser.getDbURI().getActualConnectionString(), info) : ds.getConnection();
                                try {
                                    OutputContainer outputContainer2;
                                    this.connection = connection;
                                    connection.setAutoCommit(false);
                                    resultsForOutputCell = new ArrayList<Object>();
                                    HashMap<String, List<Object>> resultsForNamspace = new HashMap<String, List<Object>>();
                                    for (BeakerParseResult queryLine : beakerParser.getResults()) {
                                        BeakerInputVar basicIterationArray = null;
                                        for (BeakerInputVar parameter : queryLine.getInputVars()) {
                                            if (!parameter.isAll()) continue;
                                            basicIterationArray = parameter;
                                            if (parameter.getErrorMessage() == null) break;
                                            throw new ReadVariableException(parameter.getErrorMessage());
                                        }
                                        try {
                                            if (basicIterationArray != null) {
                                                int l;
                                                Object obj;
                                                try {
                                                    obj = namespaceClient.get(basicIterationArray.objectName);
                                                }
                                                catch (Exception e) {
                                                    throw new ReadVariableException(basicIterationArray.objectName, e);
                                                }
                                                if (obj instanceof List) {
                                                    l = ((List)obj).size();
                                                } else {
                                                    if (!obj.getClass().isArray()) break;
                                                    l = Array.getLength(obj);
                                                }
                                                for (int i = 0; i < l; ++i) {
                                                    QueryResult queryResult = this.executeQuery(i, queryLine, connection, namespaceClient);
                                                    this.adoptResult(queryLine, queryResult, resultsForOutputCell, resultsForNamspace);
                                                }
                                                continue;
                                            }
                                            QueryResult queryResult = this.executeQuery(-1, queryLine, connection, namespaceClient);
                                            this.adoptResult(queryLine, queryResult, resultsForOutputCell, resultsForNamspace);
                                        }
                                        catch (Exception e) {
                                            isConnectionExeption = false;
                                            throw e;
                                        }
                                    }
                                    connection.commit();
                                    for (String output : resultsForNamspace.keySet()) {
                                        if (((List)resultsForNamspace.get(output)).size() > 1) {
                                            OutputContainer outputContainer3 = new OutputContainer((List)resultsForNamspace.get(output));
                                            namespaceClient.set(output, (Object)outputContainer3);
                                            continue;
                                        }
                                        if (!((List)resultsForNamspace.get(output)).isEmpty()) {
                                            namespaceClient.set(output, ((List)resultsForNamspace.get(output)).get(0));
                                            continue;
                                        }
                                        namespaceClient.set(output, null);
                                    }
                                    if (resultsForOutputCell.size() <= 1) break block33;
                                    outputContainer = outputContainer2 = new OutputContainer(resultsForOutputCell);
                                    if (connection == null) break block34;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (connection != null) {
                                            try {
                                                connection.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    catch (Exception e) {
                                        if (beakerParser.getDbURI() != null && isConnectionExeption) {
                                            beakerParser.getDbURI().setShowDialog(true);
                                        }
                                        throw e;
                                    }
                                }
                                connection.close();
                            }
                            return outputContainer;
                        }
                        if (resultsForOutputCell.isEmpty()) break block35;
                        mIMEContainer = resultsForOutputCell.get(0);
                        if (connection == null) break block36;
                        connection.close();
                    }
                    return mIMEContainer;
                }
                mIMEContainer = OutputCell.HIDDEN;
                if (connection == null) break block37;
                connection.close();
            }
            return mIMEContainer;
        }
        finally {
            this.statement = null;
        }
    }

    private void adoptResult(BeakerParseResult queryLine, QueryResult queryResult, List<Object> resultsForOutputCell, Map<String, List<Object>> resultsForNamspace) {
        if (queryLine.isSelectInto() && resultsForNamspace.get(queryLine.selectIntoVar) == null) {
            resultsForNamspace.put(queryLine.selectIntoVar, new ArrayList());
        }
        if (queryResult.getValues().size() > 1) {
            TableDisplay tableDisplay = new TableDisplay(queryResult.getValues(), queryResult.getColumns(), queryResult.getTypes());
            if (!queryLine.isSelectInto()) {
                resultsForOutputCell.add(tableDisplay);
            } else {
                resultsForNamspace.get(queryLine.selectIntoVar).add(tableDisplay);
            }
        } else if (queryResult.getValues().size() == 1) {
            List<?> row = queryResult.getValues().get(0);
            if (row.size() == 1) {
                if (!queryLine.isSelectInto()) {
                    resultsForOutputCell.add(row.get(0));
                } else {
                    resultsForNamspace.get(queryLine.selectIntoVar).add(row.get(0));
                }
            } else if (row.size() > 1) {
                LinkedHashMap map = new LinkedHashMap();
                for (int i = 0; i < row.size(); ++i) {
                    map.put(queryResult.getColumns().get(i), row.get(i));
                }
                if (!queryLine.isSelectInto()) {
                    resultsForOutputCell.add(map);
                } else {
                    resultsForNamspace.get(queryLine.selectIntoVar).add(map);
                }
            }
        }
    }

    private QueryResult executeQuery(int currentIterationIndex, BeakerParseResult queryLine, Connection conn, BeakerXClient namespaceClient) throws SQLException, ReadVariableException {
        QueryResult queryResult = new QueryResult();
        try (PreparedStatement statement = conn.prepareStatement(queryLine.getResultQuery());){
            this.statement = statement;
            int n = 1;
            for (BeakerInputVar parameter : queryLine.getInputVars()) {
                if (parameter.getErrorMessage() != null) {
                    throw new ReadVariableException(parameter.getErrorMessage());
                }
                try {
                    Object obj = namespaceClient.get(parameter.objectName);
                    if (!parameter.isArray() && !parameter.isObject()) {
                        statement.setObject(n, obj);
                    } else if (!parameter.isArray() && parameter.isObject()) {
                        statement.setObject(n, this.getValue(obj, parameter.getFieldName()));
                    } else if (parameter.isArray()) {
                        Object arrayElement;
                        int index = currentIterationIndex > 0 && parameter.isAll() ? currentIterationIndex : parameter.index;
                        if (!parameter.isObject()) {
                            if (obj instanceof List) {
                                statement.setObject(n, ((List)obj).get(index));
                            } else if (obj.getClass().isArray()) {
                                arrayElement = Array.get(obj, index);
                                statement.setObject(n, arrayElement);
                            }
                        } else if (obj instanceof List) {
                            statement.setObject(n, this.getValue(((List)obj).get(index), parameter.getFieldName()));
                        } else if (obj.getClass().isArray()) {
                            arrayElement = Array.get(obj, index);
                            statement.setObject(n, this.getValue(arrayElement, parameter.getFieldName()));
                        }
                    }
                    ++n;
                }
                catch (Exception e) {
                    throw new ReadVariableException(parameter.objectName, e);
                }
            }
            boolean hasResultSet = statement.execute();
            if (hasResultSet) {
                ResultSet rs = statement.getResultSet();
                for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                    queryResult.getColumns().add(rs.getMetaData().getColumnName(i));
                    queryResult.getTypes().add(rs.getMetaData().getColumnClassName(i));
                }
                while (rs.next()) {
                    if (rs.getMetaData().getColumnCount() == 0) continue;
                    ArrayList<Object> row = new ArrayList<Object>();
                    queryResult.getValues().add(row);
                    for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                        if (Date.class.getName().equals(rs.getMetaData().getColumnClassName(i))) {
                            Date sqlDate = rs.getDate(i);
                            row.add(sqlDate == null ? null : new java.util.Date(sqlDate.getTime()));
                            continue;
                        }
                        row.add(rs.getObject(i));
                    }
                }
            }
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        return queryResult;
    }

    private Object getValue(Object obj, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        if (obj instanceof Map) {
            return ((Map)obj).get(fieldName);
        }
        Class<?> clazz = obj.getClass();
        Field field = clazz.getField(fieldName);
        return field.get(obj);
    }

    public void cancel() {
        try {
            if (this.statement != null && !this.statement.isClosed()) {
                this.statement.cancel();
                this.connection.rollback();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private class QueryResult {
        List<List<?>> values = new ArrayList();
        List<String> columns = new ArrayList<String>();
        List<String> types = new ArrayList<String>();

        private QueryResult() {
        }

        public List<List<?>> getValues() {
            return this.values;
        }

        public void setValues(List<List<?>> values) {
            this.values = values;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public void setColumns(List<String> columns) {
            this.columns = columns;
        }

        public List<String> getTypes() {
            return this.types;
        }

        public void setTypes(List<String> types) {
            this.types = types;
        }
    }
}

