/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.sql;

import com.twosigma.beakerx.util.BeakerXSystem;
import com.twosigma.beakerx.util.BeakerXSystemImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class QueryParser {
    private static BeakerXSystem beakerXSystem = BeakerXSystemImpl.getINSTANCE();
    private static String rd = beakerXSystem.getenv("REMOVE_DASH_LINECOMMENT");
    private static boolean REMOVE_DASH_LINECOMMENT = rd == null || rd.equals("true");
    private static final List<ParsingState> PARSING_STATES = Arrays.asList(new ParsingState("'", "'", false), new ParsingState("/*", "*/", true), new LineCommentParsingState("--"), new LineCommentParsingState("%%"));

    public static List<String> split(String script) {
        StringBuilder sb = new StringBuilder(script);
        ParsingState currentState = null;
        int stateStart = -1;
        int i = 0;
        while (i < sb.length()) {
            if (currentState != null) {
                if (currentState.isEnd(sb, i)) {
                    if (currentState.mustBeDeleted()) {
                        int stateEnd = currentState.skipEnd(i);
                        sb = new StringBuilder().append(sb.substring(0, stateStart)).append(sb.substring(stateEnd));
                        i = stateStart;
                    } else {
                        i = currentState.skipEnd(i);
                    }
                    currentState = null;
                    continue;
                }
                ++i;
                continue;
            }
            ParsingState state = QueryParser.getSuitableState(sb, i);
            if (state != null) {
                currentState = state;
                stateStart = i;
                i = state.skipStart(i);
                continue;
            }
            ++i;
        }
        String[] splittedQueries = sb.toString().split(";");
        ArrayList<String> listOfQueries = new ArrayList<String>();
        for (int i2 = 0; i2 < splittedQueries.length; ++i2) {
            if (splittedQueries[i2].trim().equals("") || splittedQueries[i2].trim().equals("\t")) continue;
            listOfQueries.add(splittedQueries[i2].trim());
        }
        return listOfQueries;
    }

    private static ParsingState getSuitableState(StringBuilder line, int index) {
        for (ParsingState eachState : PARSING_STATES) {
            if (!eachState.isStart(line, index)) continue;
            return eachState;
        }
        return null;
    }

    private static class ParsingState {
        private String start;
        private String end;
        private boolean mustBeDeleted;

        public ParsingState(String start, String end, boolean mustBeDeleted) {
            this.start = start;
            this.end = end;
            this.mustBeDeleted = mustBeDeleted;
        }

        public boolean isStart(StringBuilder line, int index) {
            return this.isAtPosition(line, index, this.start);
        }

        public int skipStart(int index) {
            return index + this.start.length();
        }

        public boolean isEnd(StringBuilder line, int index) {
            return this.isAtPosition(line, index, this.end);
        }

        public int skipEnd(int index) {
            return index + this.end.length();
        }

        private boolean isAtPosition(StringBuilder line, int index, String element) {
            int endIndex = index + element.length();
            return line.length() >= endIndex && line.substring(index, endIndex).equals(element);
        }

        public boolean mustBeDeleted() {
            return this.mustBeDeleted;
        }
    }

    private static class LineCommentParsingState
    extends ParsingState {
        public LineCommentParsingState(String start) {
            super(start, "\n", REMOVE_DASH_LINECOMMENT);
        }
    }
}

