/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.sql.magic.command;

import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.sql.magic.command.DataSourceParamResolver;
import java.util.HashMap;

public class DataSourcesMagicCommand
implements MagicCommandFunctionality {
    public static final String DATASOURCES = "%datasources";
    private KernelFunctionality kernel;
    private DataSourceParamResolver paramResolver;

    public DataSourcesMagicCommand(KernelFunctionality kernel, DataSourceParamResolver paramResolver) {
        this.kernel = kernel;
        this.paramResolver = paramResolver;
    }

    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        return this.dataSource(DATASOURCES, param.getCommand());
    }

    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath((String)command);
        return commandParts.length > 0 && commandParts[0].equals(DATASOURCES);
    }

    public String getMagicCommandName() {
        return DATASOURCES;
    }

    protected MagicCommandOutcomeItem dataSource(String source, String command) {
        String[] parts = command.split(" ");
        if (parts.length != 2) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Wrong format. ", MessageCreator.get());
        }
        if (!parts[1].contains("jdbc:")) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Incorrect jdbc url.", MessageCreator.get());
        }
        String jdbc = this.paramResolver.resolve(parts[1]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(source, jdbc);
        this.kernel.updateEvaluatorParameters(new EvaluatorParameters(params));
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, MessageCreator.get());
    }
}

