/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.comm;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beakerx.BeakerXClientManager;
import com.twosigma.beakerx.CodeCell;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class GetCodeCellsHandler {
    public static final GetCodeCellsHandler INSTANCE = new GetCodeCellsHandler();
    private ObjectMapper objectMapper = new ObjectMapper();

    private GetCodeCellsHandler() {
    }

    public void handle(String data) {
        try {
            List<CodeCell> cells = this.getBeakerCodeCells(data);
            BeakerXClientManager.get().getMessageQueue("CodeCells").put(cells);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private List<CodeCell> getBeakerCodeCells(String json) {
        try {
            CodeCellWithBody codeCellWithBody = (CodeCellWithBody)this.objectMapper.readValue(json, CodeCellWithBody.class);
            return Arrays.asList(codeCellWithBody.code_cells);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class CodeCellWithBody {
        public CodeCell[] code_cells;
        public String url;
    }
}

